ent_to_iso = {
    "aruba": "AW",
    "afghanistan": "AF",
    "islamic state of afghanistan": "AF",
    "angola": "AO",
    "republic of angola": "AO",
    "anguilla": "AI",
    "genus anguilla": "AI",
    "aland islands": "AX",
    "aaland islands": "AX",
    "ahvenanmaa": "AX",
    "albania": "AL",
    "republic of albania": "AL",
    "andorra": "AD",
    "principality of andorra": "AD",
    "united arab emirates": "AE",
    "argentina": "AR",
    "argentine republic": "AR",
    "genus argentina": "AR",
    "armenia": "AM",
    "republic of armenia": "AM",
    "hayastan": "AM",
    "american samoa": "AS",
    "eastern samoa": "AS",
    # "as": "AS",
    "antarctica": "AQ",
    "antarctic continent": "AQ",
    "antigua and barbuda": "AG",
    "australia": "AU",
    "commonwealth of australia": "AU",
    "austria": "AT",
    "republic of austria": "AT",
    "oesterreich": "AT",
    "azerbaijan": "AZ",
    "azerbaijani republic": "AZ",
    "azerbajdzhan": "AZ",
    "azerbajdzhan republic": "AZ",
    "burundi": "BI",
    "republic of burundi": "BI",
    "burundian": "BI",
    "belgium": "BE",
    "kingdom of belgium": "BE",
    "belgique": "BE",
    "benin": "BJ",
    "republic of benin": "BJ",
    "dahomey": "BJ",
    "bonaire": "BQ",
    "burkina faso": "BF",
    "upper volta": "BF",
    "bangladesh": "BD",
    "people's republic of bangladesh": "BD",
    "bangla desh": "BD",
    "east pakistan": "BD",
    "bulgaria": "BG",
    "republic of bulgaria": "BG",
    "bahrain": "BH",
    "bahrain island": "BH",
    "bahrein": "BH",
    "bahrein island": "BH",
    "state of bahrain": "BH",
    "bahamas": "BS",
    "commonwealth of the bahamas": "BS",
    "bahama islands": "BS",
    "bosnia and herzegovina": "BA",
    "republic of bosnia and herzegovina": "BA",
    "bosna i hercegovina": "BA",
    "bosnia-herzegovina": "BA",
    "bosnia": "BA",
    "belarus": "BY",
    "republic of belarus": "BY",
    "byelarus": "BY",
    "byelorussia": "BY",
    "belorussia": "BY",
    "white russia": "BY",
    "belize": "BZ",
    "british honduras": "BZ",
    "bermuda": "BM",
    "bermudas": "BM",
    "bolivia": "BO",
    "republic of bolivia": "BO",
    "brazil": "BR",
    "federative republic of brazil": "BR",
    "brasil": "BR",
    "barbados": "BB",
    "bhutan": "BT",
    "kingdom of bhutan": "BT",
    "bouvet island": "BV",
    "botswana": "BW",
    "republic of botswana": "BW",
    "central african republic": "CF",
    "central africa": "CF",
    "canada": "CA",
    "switzerland": "CH",
    "swiss confederation": "CH",
    "suisse": "CH",
    "schweiz": "CH",
    "svizzera": "CH",
    "chile": "CL",
    "republic of chile": "CL",
    "china": "TW",
    "people's republic of china": "CN",
    "mainland china": "CN",
    "communist china": "CN",
    "red china": "CN",
    # "prc": "CN",
    "cathay": "CN",
    "taiwan": "TW",
    "nationalist china": "TW",
    "republic of china": "TW",
    "ivory coast": "CI",
    "cote d'ivoire": "CI",
    "republic of cote d'ivoire": "CI",
    "cameroon": "CM",
    "republic of cameroon": "CM",
    "cameroun": "CM",
    "congo": "CG",
    "democratic republic of the congo": "CG",
    "zaire": "CG",
    "belgian congo": "CG",
    "congo river": "CG",
    "zaire river": "CG",
    "republic of the congo": "CG",
    "french congo": "CG",
    "congou": "CG",
    "congou tea": "CG",
    "english breakfast tea": "CG",
    "colombia": "CO",
    "republic of colombia": "CO",
    "comoros": "KM",
    "federal islamic republic of the comoros": "KM",
    "costa rica": "CR",
    "republic of costa rica": "CR",
    "cuba": "CU",
    "republic of cuba": "CU",
    "curacao": "CW",
    "curacoa": "CW",
    "cayman islands": "KY",
    "cyprus": "CY",
    "republic of cyprus": "CY",
    "germany": "DE",
    "federal republic of germany": "DE",
    "deutschland": "DE",
    # "frg": "DE",
    "djibouti": "DJ",
    "capital of djibouti": "DJ",
    "republic of djibouti": "DJ",
    "afars and issas": "DJ",
    # "dominica": "DM",
    # "commonwealth of dominica": "DM",
    "denmark": "DK",
    "kingdom of denmark": "DK",
    "danmark": "DK",
    "dominican republic": "DO",
    "algeria": "DZ",
    "algerie": "DZ",
    "democratic and popular republic of algeria": "DZ",
    "ecuador": "EC",
    "republic of ecuador": "EC",
    "egypt": "EG",
    "arab republic of egypt": "EG",
    "united arab republic": "EG",
    "egyptian empire": "EG",
    "eritrea": "ER",
    "state of eritrea": "ER",
    "western sahara": "EH",
    "spanish sahara": "EH",
    "spain": "ES",
    "kingdom of spain": "ES",
    "espana": "ES",
    "estonia": "EE",
    "esthonia": "EE",
    "republic of estonia": "EE",
    "ethiopia": "ET",
    "federal democratic republic of ethiopia": "ET",
    "yaltopya": "ET",
    "abyssinia": "ET",
    "finland": "FI",
    "republic of finland": "FI",
    "suomi": "FI",
    "fiji": "FJ",
    "republic of fiji": "FJ",
    "france": "FR",
    "french republic": "FR",
    "anatole france": "FR",
    "jacques anatole francois thibault": "FR",
    "faroe islands": "FO",
    "faeroe islands": "FO",
    "faroes": "FO",
    "faeroes": "FO",
    "micronesia": ["GU", "KI", "MH", "FM", "NR", "MP", "PW", "UM"],
    "federated states of micronesia": "FM",
    # "tt": "PW",
    "gabon": "GA",
    "gabonese republic": "GA",
    "gabun": "GA",
    "united kingdom": "GB",
    "uk": "GB",
    "u.k.": "GB",
    "britain": "GB",
    "united kingdom of great britain and northern ireland": "GB",
    "great britain": "GB",
    "georgia": "GE",
    "sakartvelo": "GE",
    "guernsey": "GG",
    "island of guernsey": "GG",
    "ghana": "GH",
    "republic of ghana": "GH",
    "gold coast": "GH",
    "gibraltar": "GI",
    "rock of gibraltar": "GI",
    "calpe": "GI",
    "guinea": "GN",
    "republic of guinea": "GN",
    "french guinea": "GN",
    "guinea fowl": "GN",
    "numida meleagris": "GN",
    "guadeloupe": "GP",
    "gambia": "GM",
    "republic of the gambia": "GM",
    "guinea-bissau": "GW",
    "republic of guinea-bissau": "GW",
    "guine-bissau": "GW",
    "portuguese guinea": "GW",
    "equatorial guinea": "GQ",
    "republic of equatorial guinea": "GQ",
    "spanish guinea": "GQ",
    "greece": "GR",
    "hellenic republic": "GR",
    "ellas": "GR",
    "grenada": "GD",
    "greenland": "GL",
    "gronland": "GL",
    "kalaallit nunaat": "GL",
    "guatemala": "GT",
    "republic of guatemala": "GT",
    "guam": "GU",
    # "gu": "GU",
    "guyana": "GY",
    "co-operative republic of guyana": "GY",
    "british guiana": "GY",
    "hong kong": "HK",
    "honduras": "HN",
    "republic of honduras": "HN",
    "croatia": "HR",
    "republic of croatia": "HR",
    "hrvatska": "HR",
    "haiti": "HT",
    "republic of haiti": "HT",
    "hispaniola": "HT",
    "hayti": "HT",
    "hungary": "HU",
    "republic of hungary": "HU",
    "magyarorszag": "HU",
    "indonesia": "ID",
    "republic of indonesia": "ID",
    "dutch east indies": "ID",
    # "man": "IM",
    "isle of man": "IM",
    "india": "IN",
    "republic of india": "IN",
    "bharat": "IN",
    "ireland": "IE",
    "republic of ireland": "IE",
    "irish republic": "IE",
    "eire": "IE",
    "hibernia": "IE",
    "emerald isle": "IE",
    "iran": "IR",
    "islamic republic of iran": "IR",
    "persia": "IR",
    "iraq": "IQ",
    "republic of iraq": "IQ",
    "al-iraq": "IQ",
    "irak": "IQ",
    "iceland": "IS",
    "republic of iceland": "IS",
    "israel": "IL",
    "state of israel": "IL",
    "yisrael": "IL",
    "zion": "IL",
    "sion": "IL",
    "italy": "IT",
    "italian republic": "IT",
    "italia": "IT",
    "jamaica": "JM",
    "jersey": "JE",
    "island of jersey": "JE",
    "jordan": "JO",
    "hashemite kingdom of jordan": "JO",
    "japan": "JP",
    "japanese islands": "JP",
    "japanese archipelago": "JP",
    "nippon": "JP",
    "nihon": "JP",
    "kazakhstan": "KZ",
    "republic of kazakhstan": "KZ",
    "kazakstan": "KZ",
    "kazakh": "KZ",
    "kazak": "KZ",
    "kenya": "KE",
    "republic of kenya": "KE",
    "kyrgyzstan": "KG",
    "kyrgyz republic": "KG",
    "kirghizia": "KG",
    "kirgizia": "KG",
    "kirghiz": "KG",
    "kirgiz": "KG",
    "kirghizstan": "KG",
    "kirgizstan": "KG",
    "cambodia": "KH",
    "kingdom of cambodia": "KH",
    "kampuchea": "KH",
    "kiribati": "KI",
    "republic of kiribati": "KI",
    "saint kitts and nevis": "KN",
    "federation of saint kitts and nevis": "KN",
    "saint christopher-nevis": "KN",
    "st. christopher-nevis": "KN",
    "st. kitts and nevis": "KN",
    "korea": "KP",
    "korean peninsula": "KP",
    "dae-han-min-gook": "KP",
    "han-gook": "KP",
    "kuwait": "KW",
    "kuwait city": "KW",
    "koweit": "KW",
    "capital of kuwait": "KW",
    "state of kuwait": "KW",
    "laos": "LA",
    "lao people's democratic republic": "LA",
    "lebanon": "LB",
    "lebanese republic": "LB",
    "liberia": "LR",
    "republic of liberia": "LR",
    "libya": "LY",
    "socialist people's libyan arab jamahiriya": "LY",
    "saint lucia": "LC",
    "st. lucia": "LC",
    "liechtenstein": "LI",
    "principality of liechtenstein": "LI",
    "sri lanka": "LK",
    "democratic socialist republic of sri lanka": "LK",
    "ceylon": "LK",
    "lesotho": "LS",
    "kingdom of lesotho": "LS",
    "basutoland": "LS",
    "lithuania": "LT",
    "republic of lithuania": "LT",
    "lietuva": "LT",
    "luxembourg-ville": "LU",
    "luxembourg": "LU",
    "luxemburg": "LU",
    "luxembourg city": "LU",
    "capital of luxembourg": "LU",
    "grand duchy of luxembourg": "LU",
    "latvia": "LV",
    "republic of latvia": "LV",
    "macao": "MO",
    "macau": "MO",
    "morocco": "MA",
    "kingdom of morocco": "MA",
    "maroc": "MA",
    "marruecos": "MA",
    "al-magrib": "MA",
    "monaco": "MC",
    "principality of monaco": "MC",
    "moldova": "MD",
    "republic of moldova": "MD",
    "moldavia": "MD",
    "madagascar": "MG",
    "republic of madagascar": "MG",
    "malagasy republic": "MG",
    "maldives": "MV",
    "republic of maldives": "MV",
    "maldive islands": "MV",
    "mexico": "MX",
    "united mexican states": "MX",
    "marshall islands": "MH",
    "republic of the marshall islands": "MH",
    # "mali": "ML",
    "republic of mali": "ML",
    "french sudan": "ML",
    "malta": "MT",
    "republic of malta": "MT",
    "myanmar": "MM",
    "union of burma": "MM",
    "burma": "MM",
    "montenegro": "ME",
    "crna gora": "ME",
    "mongolia": "MN",
    "mongolian people's republic": "MN",
    "outer mongolia": "MN",
    "northern marianas": "MP",
    "northern mariana islands": "MP",
    "mozambique": "MZ",
    "republic of mozambique": "MZ",
    "mocambique": "MZ",
    "mauritania": "MR",
    "islamic republic of mauritania": "MR",
    "mauritanie": "MR",
    "muritaniya": "MR",
    "montserrat": "MS",
    "martinique": "MQ",
    "mauritius": "MU",
    "republic of mauritius": "MU",
    "malawi": "MW",
    "republic of malawi": "MW",
    "nyasaland": "MW",
    "malaysia": "MY",
    "malaya": "MY",
    "namibia": "NA",
    "republic of namibia": "NA",
    "south west africa": "NA",
    "new caledonia": "NC",
    "niger": "NE",
    "republic of niger": "NE",
    "norfolk island": "NF",
    "nigeria": "NG",
    "federal republic of nigeria": "NG",
    "nicaragua": "NI",
    "republic of nicaragua": "NI",
    "netherlands": "NL",
    "kingdom of the netherlands": "NL",
    "nederland": "NL",
    "holland": "NL",
    "norway": "NO",
    "kingdom of norway": "NO",
    "norge": "NO",
    "noreg": "NO",
    "nepal": "NP",
    "kingdom of nepal": "NP",
    "nauru": "NR",
    "republic of nauru": "NR",
    "nauru island": "NR",
    "pleasant island": "NR",
    "new zealand": "NZ",
    "new zealand islands": "NZ",
    "oman": "OM",
    "sultanate of oman": "OM",
    "muscat and oman": "OM",
    "pakistan": "PK",
    "islamic republic of pakistan": "PK",
    "west pakistan": "PK",
    "panama": "PA",
    "republic of panama": "PA",
    "panama hat": "PA",
    "peru": "PE",
    "republic of peru": "PE",
    "philippines": "PH",
    "republic of the philippines": "PH",
    "philippine islands": "PH",
    "philippine": "PH",
    "filipino": "PH",
    "palau": "PW",
    "republic of palau": "PW",
    "palau islands": "PW",
    "belau": "PW",
    "pelew": "PW",
    "papua new guinea": "PG",
    "independent state of papua new guinea": "PG",
    "poland": "PL",
    "republic of poland": "PL",
    "polska": "PL",
    "puerto rico": "PR",
    "porto rico": "PR",
    "commonwealth of puerto rico": "PR",
    # "pr": "PR",
    "portugal": "PT",
    "portuguese republic": "PT",
    "paraguay": "PY",
    "republic of paraguay": "PY",
    "palestine": "PS",
    "french polynesia": "PF",
    "french oceania": "PF",
    "qatar": "QA",
    "state of qatar": "QA",
    "katar": "QA",
    "state of katar": "QA",
    "qatar peninsula": "QA",
    "katar peninsula": "QA",
    "reunion": "RE",
    "reunification": "RE",
    "romania": "RO",
    "roumania": "RO",
    "rumania": "RO",
    "russia": "RU",
    "russian federation": "RU",
    "rwanda": "RW",
    "rwandese republic": "RW",
    "ruanda": "RW",
    "saudi arabia": "SA",
    "kingdom of saudi arabia": "SA",
    "sudan": "SD",
    "republic of the sudan": "SD",
    "soudan": "SD",
    "senegal": "SN",
    "republic of senegal": "SN",
    "singapore": "SG",
    "capital of singapore": "SG",
    "republic of singapore": "SG",
    "singapore island": "SG",
    "solomon islands": "SB",
    "solomons": "SB",
    "sierra leone": "SL",
    "republic of sierra leone": "SL",
    "el salvador": "SV",
    "republic of el salvador": "SV",
    "salvador": "SV",
    "san marino": "SM",
    "capital of san marino": "SM",
    "republic of san marino": "SM",
    "somalia": "SO",
    "serbia": "RS",
    "srbija": "RS",
    "sao tome and principe": "ST",
    "democratic republic of sao tome and principe": "ST",
    "sao tome e principe": "ST",
    "sao thome e principe": "ST",
    "st. thomas and principe": "ST",
    "suriname": "SR",
    "republic of suriname": "SR",
    "surinam": "SR",
    "dutch guiana": "SR",
    "netherlands guiana": "SR",
    "slovakia": "SK",
    "slovak republic": "SK",
    "slovenia": "SI",
    "republic of slovenia": "SI",
    "slovenija": "SI",
    "sweden": "SE",
    "kingdom of sweden": "SE",
    "sverige": "SE",
    "seychelles": "SC",
    "republic of seychelles": "SC",
    "seychelles islands": "SC",
    "syria": "SY",
    "syrian arab republic": "SY",
    "chad": "TD",
    "lake chad": "TD",
    "republic of chad": "TD",
    "tchad": "TD",
    "chadic": "TD",
    "chadic language": "TD",
    "togo": "TG",
    "togolese republic": "TG",
    "thailand": "TH",
    "kingdom of thailand": "TH",
    "siam": "TH",
    "tajikistan": "TJ",
    "republic of tajikistan": "TJ",
    "tadzhikistan": "TJ",
    "tadzhik": "TJ",
    "tadjik": "TJ",
    "tajik": "TJ",
    "turkmenistan": "TM",
    "turkomen": "TM",
    "turkmen": "TM",
    "turkmenia": "TM",
    "tonga": "TO",
    "kingdom of tonga": "TO",
    "friendly islands": "TO",
    "trinidad and tobago": "TT",
    "republic of trinidad and tobago": "TT",
    "tunisia": "TN",
    "republic of tunisia": "TN",
    "turkey": "TR",
    "meleagris gallopavo": "TR",
    "republic of turkey": "TR",
    "tuvalu": "TV",
    "ellice islands": "TV",
    "formosa": "TW",
    "tanzania": "TZ",
    "united republic of tanzania": "TZ",
    "uganda": "UG",
    "republic of uganda": "UG",
    "ukraine": "UA",
    "ukrayina": "UA",
    "uruguay": "UY",
    "united states": "US",
    "united states of america": "US",
    "america": "US",
    "states": "US",
    "us": "US",
    "u.s.": "US",
    "usa": "US",
    "u.s.a.": "US",
    "united states government": "US",
    "u.s. government": "US",
    "us government": "US",
    "uzbekistan": "UZ",
    "republic of uzbekistan": "UZ",
    "uzbek": "UZ",
    "saint vincent and the grenadines": "VC",
    "st. vincent and the grenadines": "VC",
    "venezuela": "VE",
    "republic of venezuela": "VE",
    "virgin islands": "VI",
    "vietnam": "VN",
    "socialist republic of vietnam": "VN",
    "viet nam": "VN",
    "annam": "VN",
    "vanuatu": "VU",
    "republic of vanuatu": "VU",
    "new hebrides": "VU",
    "samoa": "WS",
    "independent state of samoa": "WS",
    "western samoa": "WS",
    "samoa i sisifo": "WS",
    "samoan islands": "WS",
    "yemen": "YE",
    "republic of yemen": "YE",
    "south africa": ["ZA"],
    "republic of south africa": "ZA",
    "zambia": "ZM",
    "republic of zambia": "ZM",
    "northern rhodesia": "ZM",
    "zimbabwe": "ZW",
    "republic of zimbabwe": "ZW",
    "rhodesia": "ZW",
    "southern rhodesia": "ZW",
    "kosovo": "XK",
    "nordics": ["DK", "FI", "IS", "NO", "SE", "FO", "GL", "AX", "SJ"],
    "baltics": ["EE", "LV", "LT"],
    "benelux": ["BE", "NL", "LU"],
    "central europe": [
        "AT",
        "CZ",
        "DE",
        "HU",
        "PL",
        "SK",
        "SI",
        "CH",
        "AT",
        "AT",
        "CZ",
        "CZ",
        "DE",
        "DE",
        "HU",
        "HU",
        "PL",
        "PL",
        "SK",
        "SK",
        "SI",
        "SI",
        "CH",
        "CH",
    ],
    "balkan": ["AL", "BA", "BG", "HR", "GR", "XK", "ME", "MK", "RO", "RS"],
    "caucasus": ["AM", "AZ", "GE"],
    "caucasia": ["AM", "AZ", "GE"],
    "middle eastern": [
        "BH",
        "CY",
        "EG",
        "IR",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "central european": [
        "AT",
        "CZ",
        "DE",
        "HU",
        "PL",
        "SK",
        "SI",
        "CH",
        "AT",
        "AT",
        "CZ",
        "CZ",
        "DE",
        "DE",
        "HU",
        "HU",
        "PL",
        "PL",
        "SK",
        "SK",
        "SI",
        "SI",
        "CH",
        "CH",
    ],
    "middle east": [
        "BH",
        "CY",
        "EG",
        "IR",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "asia": [
        "AF",
        "AM",
        "AZ",
        "BH",
        "BD",
        "BT",
        "BN",
        "KH",
        "CN",
        "CY",
        "GE",
        "HK",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IL",
        "JP",
        "JO",
        "KZ",
        "KP",
        "KR",
        "KW",
        "KG",
        "LA",
        "LB",
        "MO",
        "MY",
        "MV",
        "MN",
        "MM",
        "NP",
        "OM",
        "PK",
        "PS",
        "PH",
        "QA",
        "SA",
        "SG",
        "LK",
        "SY",
        "TW",
        "TJ",
        "TH",
        "TL",
        "TR",
        "TM",
        "AE",
        "UZ",
        "VN",
        "YE",
    ],
    "asian": [
        "AF",
        "AM",
        "AZ",
        "BH",
        "BD",
        "BT",
        "BN",
        "KH",
        "CN",
        "CY",
        "GE",
        "HK",
        "IN",
        "ID",
        "IR",
        "IQ",
        "IL",
        "JP",
        "JO",
        "KZ",
        "KP",
        "KR",
        "KW",
        "KG",
        "LA",
        "LB",
        "MO",
        "MY",
        "MV",
        "MN",
        "MM",
        "NP",
        "OM",
        "PK",
        "PS",
        "PH",
        "QA",
        "SA",
        "SG",
        "LK",
        "SY",
        "TW",
        "TJ",
        "TH",
        "TL",
        "TR",
        "TM",
        "AE",
        "UZ",
        "VN",
        "YE",
    ],
    "southern asia": ["AF", "BD", "BT", "IN", "IR", "MV", "NP", "PK", "LK"],
    "southern asian": ["AF", "BD", "BT", "IN", "IR", "MV", "NP", "PK", "LK"],
    "south asia": ["AF", "BD", "BT", "IN", "IR", "MV", "NP", "PK", "LK"],
    "south asian": ["AF", "BD", "BT", "IN", "IR", "MV", "NP", "PK", "LK"],
    "europe": [
        "AX",
        "AL",
        "AD",
        "AT",
        "BY",
        "BE",
        "BA",
        "BG",
        "HR",
        "CZ",
        "DK",
        "EE",
        "FO",
        "FI",
        "FR",
        "DE",
        "GI",
        "GR",
        "GG",
        "VA",
        "HU",
        "IS",
        "IE",
        "IM",
        "IT",
        "JE",
        "LV",
        "LI",
        "LT",
        "LU",
        "MT",
        "MD",
        "MC",
        "ME",
        "NL",
        "MK",
        "NO",
        "PL",
        "PT",
        "RO",
        "RU",
        "SM",
        "RS",
        "SK",
        "SI",
        "ES",
        "SJ",
        "SE",
        "CH",
        "UA",
        "GB",
    ],
    "european": [
        "AX",
        "AL",
        "AD",
        "AT",
        "BY",
        "BE",
        "BA",
        "BG",
        "HR",
        "CZ",
        "DK",
        "EE",
        "FO",
        "FI",
        "FR",
        "DE",
        "GI",
        "GR",
        "GG",
        "VA",
        "HU",
        "IS",
        "IE",
        "IM",
        "IT",
        "JE",
        "LV",
        "LI",
        "LT",
        "LU",
        "MT",
        "MD",
        "MC",
        "ME",
        "NL",
        "MK",
        "NO",
        "PL",
        "PT",
        "RO",
        "RU",
        "SM",
        "RS",
        "SK",
        "SI",
        "ES",
        "SJ",
        "SE",
        "CH",
        "UA",
        "GB",
    ],
    "northern europe": [
        "AX",
        "DK",
        "EE",
        "FO",
        "FI",
        "GG",
        "IS",
        "IE",
        "IM",
        "JE",
        "LV",
        "LT",
        "NO",
        "SJ",
        "SE",
        "GB",
    ],
    "northern european": [
        "AX",
        "DK",
        "EE",
        "FO",
        "FI",
        "GG",
        "IS",
        "IE",
        "IM",
        "JE",
        "LV",
        "LT",
        "NO",
        "SJ",
        "SE",
        "GB",
    ],
    "north europe": [
        "AX",
        "DK",
        "EE",
        "FO",
        "FI",
        "GG",
        "IS",
        "IE",
        "IM",
        "JE",
        "LV",
        "LT",
        "NO",
        "SJ",
        "SE",
        "GB",
    ],
    "north european": [
        "AX",
        "DK",
        "EE",
        "FO",
        "FI",
        "GG",
        "IS",
        "IE",
        "IM",
        "JE",
        "LV",
        "LT",
        "NO",
        "SJ",
        "SE",
        "GB",
    ],
    "scandinavia": ["AX", "DK", "FO", "FI", "IS", "NO", "SE"],
    "southern europe": [
        "AL",
        "AD",
        "BA",
        "HR",
        "GI",
        "GR",
        "VA",
        "IT",
        "MT",
        "ME",
        "MK",
        "PT",
        "SM",
        "RS",
        "SI",
        "ES",
    ],
    "southern european": [
        "AL",
        "AD",
        "BA",
        "HR",
        "GI",
        "GR",
        "VA",
        "IT",
        "MT",
        "ME",
        "MK",
        "PT",
        "SM",
        "RS",
        "SI",
        "ES",
    ],
    "south europe": [
        "AL",
        "AD",
        "BA",
        "HR",
        "GI",
        "GR",
        "VA",
        "IT",
        "MT",
        "ME",
        "MK",
        "PT",
        "SM",
        "RS",
        "SI",
        "ES",
    ],
    "south european": [
        "AL",
        "AD",
        "BA",
        "HR",
        "GI",
        "GR",
        "VA",
        "IT",
        "MT",
        "ME",
        "MK",
        "PT",
        "SM",
        "RS",
        "SI",
        "ES",
    ],
    "africa": [
        "DZ",
        "AO",
        "BJ",
        "BW",
        "IO",
        "BF",
        "BI",
        "CV",
        "CM",
        "CF",
        "TD",
        "KM",
        "CG",
        "CI",
        "DJ",
        "EG",
        "GQ",
        "ER",
        "SZ",
        "ET",
        "TF",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "KE",
        "LS",
        "LR",
        "LY",
        "MG",
        "MW",
        "ML",
        "MR",
        "MU",
        "YT",
        "MA",
        "MZ",
        "NE",
        "NG",
        "RE",
        "RW",
        "SH",
        "ST",
        "SN",
        "SC",
        "SL",
        "SO",
        "ZA",
        "SS",
        "SD",
        "TZ",
        "TG",
        "TN",
        "UG",
        "EH",
        "ZM",
        "ZW",
    ],
    "african": [
        "DZ",
        "AO",
        "BJ",
        "BW",
        "IO",
        "BF",
        "BI",
        "CV",
        "CM",
        "CF",
        "TD",
        "KM",
        "CG",
        "CI",
        "DJ",
        "EG",
        "GQ",
        "ER",
        "SZ",
        "ET",
        "TF",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "KE",
        "LS",
        "LR",
        "LY",
        "MG",
        "MW",
        "ML",
        "MR",
        "MU",
        "YT",
        "MA",
        "MZ",
        "NE",
        "NG",
        "RE",
        "RW",
        "SH",
        "ST",
        "SN",
        "SC",
        "SL",
        "SO",
        "ZA",
        "SS",
        "SD",
        "TZ",
        "TG",
        "TN",
        "UG",
        "EH",
        "ZM",
        "ZW",
    ],
    "northern africa": ["DZ", "EG", "LY", "MA", "SD", "TN", "EH"],
    "northern african": ["DZ", "EG", "LY", "MA", "SD", "TN", "EH"],
    "north africa": ["DZ", "EG", "LY", "MA", "SD", "TN", "EH"],
    "north african": ["DZ", "EG", "LY", "MA", "SD", "TN", "EH"],
    "oceania": [
        "AS",
        "AU",
        "CX",
        "CC",
        "CK",
        "FJ",
        "PF",
        "GU",
        "HM",
        "KI",
        "MH",
        "FM",
        "NR",
        "NC",
        "NZ",
        "NU",
        "NF",
        "MP",
        "PW",
        "PG",
        "PN",
        "WS",
        "SB",
        "TK",
        "TO",
        "TV",
        "UM",
        "VU",
        "WF",
    ],
    "oceanian": [
        "AS",
        "AU",
        "CX",
        "CC",
        "CK",
        "FJ",
        "PF",
        "GU",
        "HM",
        "KI",
        "MH",
        "FM",
        "NR",
        "NC",
        "NZ",
        "NU",
        "NF",
        "MP",
        "PW",
        "PG",
        "PN",
        "WS",
        "SB",
        "TK",
        "TO",
        "TV",
        "UM",
        "VU",
        "WF",
    ],
    "polynesia": ["AS", "CK", "PF", "NU", "PN", "WS", "TK", "TO", "TV", "WF"],
    "sub-saharan africa": [
        "AO",
        "BJ",
        "BW",
        "IO",
        "BF",
        "BI",
        "CV",
        "CM",
        "CF",
        "TD",
        "KM",
        "CG",
        "CI",
        "DJ",
        "GQ",
        "ER",
        "SZ",
        "ET",
        "TF",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "KE",
        "LS",
        "LR",
        "MG",
        "MW",
        "ML",
        "MR",
        "MU",
        "YT",
        "MZ",
        "NE",
        "NG",
        "RE",
        "RW",
        "SH",
        "ST",
        "SN",
        "SC",
        "SL",
        "SO",
        "ZA",
        "SS",
        "TZ",
        "TG",
        "UG",
        "ZM",
        "ZW",
    ],
    "sub-saharan african": [
        "AO",
        "BJ",
        "BW",
        "IO",
        "BF",
        "BI",
        "CV",
        "CM",
        "CF",
        "TD",
        "KM",
        "CG",
        "CI",
        "DJ",
        "GQ",
        "ER",
        "SZ",
        "ET",
        "TF",
        "GA",
        "GM",
        "GH",
        "GN",
        "GW",
        "KE",
        "LS",
        "LR",
        "MG",
        "MW",
        "ML",
        "MR",
        "MU",
        "YT",
        "MZ",
        "NE",
        "NG",
        "RE",
        "RW",
        "SH",
        "ST",
        "SN",
        "SC",
        "SL",
        "SO",
        "ZA",
        "SS",
        "TZ",
        "TG",
        "UG",
        "ZM",
        "ZW",
    ],
    "middle africa": ["AO", "CM", "CF", "TD", "CG", "GQ", "GA", "ST"],
    "middle african": ["AO", "CM", "CF", "TD", "CG", "GQ", "GA", "ST"],
    "americas": [
        "AI",
        "AG",
        "AR",
        "AW",
        "BS",
        "BB",
        "BZ",
        "BM",
        "BO",
        "BQ",
        "BV",
        "BR",
        "CA",
        "KY",
        "CL",
        "CO",
        "CR",
        "CU",
        "CW",
        # "DM",
        "DO",
        "EC",
        "SV",
        "FK",
        "GF",
        "GL",
        "GD",
        "GP",
        "GT",
        "GY",
        "HT",
        "HN",
        "JM",
        "MQ",
        "MX",
        "MS",
        "NI",
        "PA",
        "PY",
        "PE",
        "PR",
        "BL",
        "KN",
        "LC",
        "MF",
        "PM",
        "VC",
        "SX",
        "GS",
        "SR",
        "TT",
        "TC",
        "US",
        "UY",
        "VE",
        "VG",
        "VI",
    ],
    "american": "US",
    "latin america": [
        "AI",
        "AG",
        "AR",
        "AW",
        "BS",
        "BB",
        "BZ",
        "BO",
        "BQ",
        "BV",
        "BR",
        "KY",
        "CL",
        "CO",
        "CR",
        "CU",
        "CW",
        # "DM",
        "DO",
        "EC",
        "SV",
        "FK",
        "GF",
        "GD",
        "GP",
        "GT",
        "GY",
        "HT",
        "HN",
        "JM",
        "MQ",
        "MX",
        "MS",
        "NI",
        "PA",
        "PY",
        "PE",
        "PR",
        "BL",
        "KN",
        "LC",
        "MF",
        "VC",
        "SX",
        "GS",
        "SR",
        "TT",
        "TC",
        "UY",
        "VE",
        "VG",
        "VI",
    ],
    "latin american": [
        "AI",
        "AG",
        "AR",
        "AW",
        "BS",
        "BB",
        "BZ",
        "BO",
        "BQ",
        "BV",
        "BR",
        "KY",
        "CL",
        "CO",
        "CR",
        "CU",
        "CW",
        # "DM",
        "DO",
        "EC",
        "SV",
        "FK",
        "GF",
        "GD",
        "GP",
        "GT",
        "GY",
        "HT",
        "HN",
        "JM",
        "MQ",
        "MX",
        "MS",
        "NI",
        "PA",
        "PY",
        "PE",
        "PR",
        "BL",
        "KN",
        "LC",
        "MF",
        "VC",
        "SX",
        "GS",
        "SR",
        "TT",
        "TC",
        "UY",
        "VE",
        "VG",
        "VI",
    ],
    "caribbean": [
        "AI",
        "AG",
        "AW",
        "BS",
        "BB",
        "BQ",
        "KY",
        "CU",
        "CW",
        # "DM",
        "DO",
        "GD",
        "GP",
        "HT",
        "JM",
        "MQ",
        "MS",
        "PR",
        "BL",
        "KN",
        "LC",
        "MF",
        "VC",
        "SX",
        "TT",
        "TC",
        "VG",
        "VI",
    ],
    "south america": [
        "AR",
        "BO",
        "BV",
        "BR",
        "CL",
        "CO",
        "EC",
        "FK",
        "GF",
        "GY",
        "PY",
        "PE",
        "GS",
        "SR",
        "UY",
        "VE",
    ],
    "south american": [
        "AR",
        "BO",
        "BV",
        "BR",
        "CL",
        "CO",
        "EC",
        "FK",
        "GF",
        "GY",
        "PY",
        "PE",
        "GS",
        "SR",
        "UY",
        "VE",
    ],
    "western asia": [
        "AM",
        "AZ",
        "BH",
        "CY",
        "GE",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "western asian": [
        "AM",
        "AZ",
        "BH",
        "CY",
        "GE",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "west asia": [
        "AM",
        "AZ",
        "BH",
        "CY",
        "GE",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "west asian": [
        "AM",
        "AZ",
        "BH",
        "CY",
        "GE",
        "IQ",
        "IL",
        "JO",
        "KW",
        "LB",
        "OM",
        "PS",
        "QA",
        "SA",
        "SY",
        "TR",
        "AE",
        "YE",
    ],
    "australia and new zealand": ["AU", "CX", "CC", "HM", "NZ", "NF"],
    "western europe": ["AT", "BE", "FR", "DE", "LI", "LU", "MC", "NL", "CH"],
    "western european": ["AT", "BE", "FR", "DE", "LI", "LU", "MC", "NL", "CH"],
    "west europe": ["AT", "BE", "FR", "DE", "LI", "LU", "MC", "NL", "CH"],
    "west european": ["AT", "BE", "FR", "DE", "LI", "LU", "MC", "NL", "CH"],
    "eastern europe": ["BY", "BG", "CZ", "HU", "MD", "PL", "RO", "RU", "SK", "UA"],
    "eastern european": ["BY", "BG", "CZ", "HU", "MD", "PL", "RO", "RU", "SK", "UA"],
    "east europe": ["BY", "BG", "CZ", "HU", "MD", "PL", "RO", "RU", "SK", "UA"],
    "east european": ["BY", "BG", "CZ", "HU", "MD", "PL", "RO", "RU", "SK", "UA"],
    "central america": ["BZ", "CR", "SV", "GT", "HN", "MX", "NI", "PA"],
    "central american": ["BZ", "CR", "SV", "GT", "HN", "MX", "NI", "PA"],
    "western africa": [
        "BJ",
        "BF",
        "CV",
        "CI",
        "GM",
        "GH",
        "GN",
        "GW",
        "LR",
        "ML",
        "MR",
        "NE",
        "NG",
        "SH",
        "SN",
        "SL",
        "TG",
    ],
    "western african": [
        "BJ",
        "BF",
        "CV",
        "CI",
        "GM",
        "GH",
        "GN",
        "GW",
        "LR",
        "ML",
        "MR",
        "NE",
        "NG",
        "SH",
        "SN",
        "SL",
        "TG",
    ],
    "west africa": [
        "BJ",
        "BF",
        "CV",
        "CI",
        "GM",
        "GH",
        "GN",
        "GW",
        "LR",
        "ML",
        "MR",
        "NE",
        "NG",
        "SH",
        "SN",
        "SL",
        "TG",
    ],
    "west african": [
        "BJ",
        "BF",
        "CV",
        "CI",
        "GM",
        "GH",
        "GN",
        "GW",
        "LR",
        "ML",
        "MR",
        "NE",
        "NG",
        "SH",
        "SN",
        "SL",
        "TG",
    ],
    "northern america": ["BM", "CA", "GL", "PM", "US"],
    "northern american": ["BM", "CA", "GL", "PM", "US"],
    "north america": ["BM", "CA", "GL", "PM", "US"],
    "north american": ["BM", "CA", "GL", "PM", "US"],
    "southern africa": ["BW", "SZ", "LS", "ZA"],
    "southern african": ["BW", "SZ", "LS", "ZA"],
    "south african": "ZA",
    "eastern africa": [
        "IO",
        "BI",
        "KM",
        "DJ",
        "ER",
        "ET",
        "TF",
        "KE",
        "MG",
        "MW",
        "MU",
        "YT",
        "MZ",
        "RE",
        "RW",
        "SC",
        "SO",
        "SS",
        "TZ",
        "UG",
        "ZM",
        "ZW",
    ],
    "eastern african": [
        "IO",
        "BI",
        "KM",
        "DJ",
        "ER",
        "ET",
        "TF",
        "KE",
        "MG",
        "MW",
        "MU",
        "YT",
        "MZ",
        "RE",
        "RW",
        "SC",
        "SO",
        "SS",
        "TZ",
        "UG",
        "ZM",
        "ZW",
    ],
    "east africa": [
        "IO",
        "BI",
        "KM",
        "DJ",
        "ER",
        "ET",
        "TF",
        "KE",
        "MG",
        "MW",
        "MU",
        "YT",
        "MZ",
        "RE",
        "RW",
        "SC",
        "SO",
        "SS",
        "TZ",
        "UG",
        "ZM",
        "ZW",
    ],
    "east african": [
        "IO",
        "BI",
        "KM",
        "DJ",
        "ER",
        "ET",
        "TF",
        "KE",
        "MG",
        "MW",
        "MU",
        "YT",
        "MZ",
        "RE",
        "RW",
        "SC",
        "SO",
        "SS",
        "TZ",
        "UG",
        "ZM",
        "ZW",
    ],
    "south-eastern asia": [
        "BN",
        "KH",
        "ID",
        "LA",
        "MY",
        "MM",
        "PH",
        "SG",
        "TH",
        "TL",
        "VN",
    ],
    "south-eastern asian": [
        "BN",
        "KH",
        "ID",
        "LA",
        "MY",
        "MM",
        "PH",
        "SG",
        "TH",
        "TL",
        "VN",
    ],
    "eastern asia": ["CN", "HK", "JP", "KP", "KR", "MO", "MN", "TW"],
    "eastern asian": ["CN", "HK", "JP", "KP", "KR", "MO", "MN", "TW"],
    "east asia": ["CN", "HK", "JP", "KP", "KR", "MO", "MN", "TW"],
    "east asian": ["CN", "HK", "JP", "KP", "KR", "MO", "MN", "TW"],
    "melanesia": ["FJ", "NC", "PG", "SB", "VU"],
    "channel islands": ["GG", "JE"],
    "central asia": ["KZ", "KG", "TJ", "TM", "UZ"],
    "central asian": ["KZ", "KG", "TJ", "TM", "UZ"],
    "afghan": "AF",
    "albanian": "AL",
    "algerian": "DZ",
    "american samoan": "AS",
    "andorran": "AD",
    "angolan": "AO",
    "anguillian": "AI",
    "antiguan": "AG",
    "argentinean": "AR",
    "argentinian": "AR",
    "argentine": "AR",
    "armenian": "AM",
    "aruban": "AW",
    "australian": "AU",
    "aussie": "AU",
    "austrian": "AT",
    "azerbaijani": "AZ",
    "bahamian": "BS",
    "bahraini": "BH",
    "bangladeshi": "BD",
    "barbadian": "BB",
    "barbudan": "AG",
    "belarusian": "BY",
    "belgian": "BE",
    "belizean": "BZ",
    "beninese": "BJ",
    "bermudian": "BM",
    "bhutanese": "BT",
    "bolivian": "BO",
    "bosnian": "BA",
    "brazilian": "BR",
    "british": "GB",
    "bruneian": "BN",
    "bulgarian": "BG",
    "burkinabe": "BF",
    "cambodian": "KH",
    "cameroonian": "CM",
    "canadian": "CA",
    "cape verdian": "CV",
    "caymanian": "KY",
    "central african": "CF",
    "chadian": "TD",
    "chilean": "CL",
    "chinese": "CN",
    "colombian": "CO",
    "comoran": "KM",
    "congolese": "CG",
    "costa rican": "CR",
    "costarican": "CR",
    "croatian": "HR",
    "cuban": "CU",
    "curaçaoan": "CW",
    "cypriot": "CY",
    "czech": "CZ",
    "danish": "DK",
    "dominican": "DO",
    "dutch": "NL",
    "timorese": "TL",
    "east timorese": "TL",
    "ecuadorean": "EC",
    "egyptian": "EG",
    "emirati": "AE",
    "equatorial guinean": "GQ",
    "eritrean": "ER",
    "estonian": "EE",
    "ethiopian": "ET",
    "falkland": "FK",
    "faroese": "FO",
    "fijian": "FJ",
    "finnish": "FI",
    "french polynesian": "PF",
    "french": "FR",
    "gabonese": "GA",
    "gambian": "GM",
    "georgian": "GE",
    "german": "DE",
    "ghanaian": "GH",
    "hellenic": "GR",
    "grecian": "GR",
    "greek": "GR",
    "greenlandic": "GL",
    "grenadian": "GD",
    "guadeloupian": "GP",
    "guamanian": "GU",
    "guatemalan": "GT",
    "guinea-bissauan": "GW",
    "guinean": "GN",
    "guyanese": "GY",
    "haitian": "HT",
    "herzegovinian": "BA",
    "honduran": "HN",
    "hong kongese": "HK",
    "hongkongese": "HK",
    "hungarian": "HU",
    "i-kiribati": "KI",
    "icelander": "IS",
    "indian": "IN",
    "indonesian": "ID",
    "iranian": "IR",
    "persian": "IR",
    "iraqi": "IQ",
    "irish": "IE",
    "israeli": "IL",
    "italian": "IT",
    "ivorian": "CI",
    "jamaican": "JM",
    "japanese": "JP",
    "jordanian": "JO",
    "kazakhstani": "KZ",
    "kenyan": "KE",
    "kittian and nevisian": "KN",
    "kittian": "KN",
    "nevisian": "KN",
    "kuwaiti": "KW",
    "kyrgyzstani": "KG",
    "kosovar": "XK",
    "laotian": "LA",
    "latvian": "LV",
    "lebanese": "LB",
    "liberian": "LR",
    "libyan": "LY",
    "liechtensteiner": "LI",
    "lithuanian": "LT",
    "luxembourger": "LU",
    "macanese": "MO",
    "macedonian": "MK",
    "malagasy": "MG",
    "malawian": "MW",
    "malaysian": "MY",
    "maldivan": "MV",
    "malian": "ML",
    "maltese": "MT",
    "manx": "IM",
    "marshallese": "MH",
    "mauritanian": "MR",
    "mauritian": "MU",
    "mexican": "MX",
    "micronesian": "FM",
    "moldovan": "MD",
    "monegasque": "MC",
    "mongolian": "MN",
    "montenegrin": "ME",
    "montserratian": "MS",
    "moroccan": "MA",
    "mosotho": "LS",
    "motswana": "BW",
    "mozambican": "MZ",
    "namibian": "NA",
    "nauruan": "NR",
    "nepalese": "NP",
    "new caledonian": "NC",
    "new zealander": "NZ",
    "ni-vanuatu": "VU",
    "nicaraguan": "NI",
    "nigerien": "NE",
    "nigerian": "NG",
    "niuean": "NU",
    "norfolk islander": "NF",
    "north korean": "KP",
    "norwegian": "NO",
    "norse": "NO",
    "omani": "OM",
    "pakistani": "PK",
    "palauan": "PW",
    "palestinian": "PS",
    "panamanian": "PA",
    "papua new guinean": "PG",
    "paraguayan": "PY",
    "peruvian": "PE",
    "pitcairn": "PN",
    "polish": "PL",
    "portuguese": "PT",
    "puerto rican": "PR",
    "qatari": "QA",
    "romanian": "RO",
    "russian": "RU",
    "rwandan": "RW",
    "sahrawi": "EH",
    "saint barthelemian": "BL",
    "saint helenian": "SH",
    "saint lucian": "LC",
    "saint martinian": "MF",
    "saint vincentian": "VC",
    "salvadoran": "SV",
    "sammarinese": "SM",
    "samoan": "WS",
    "sao tomean": "ST",
    "saudi arabian": "SA",
    "senegalese": "SN",
    "serbian": "RS",
    "serbs": "CS",
    "seychellois": "SC",
    "sierra leonean": "SL",
    "singaporean": "SG",
    "slovak": "SK",
    "slovenian": "SI",
    "slovene": "SI",
    "solomon islander": "SB",
    "somali": "SO",
    "south korean": "KR",
    "spanish": "ES",
    "sri lankan": "LK",
    "sudanese": "SD",
    "surinamer": "SR",
    "swazi": "SZ",
    "swedish": "SE",
    "swiss": "CH",
    "syrian": "SY",
    "taiwanese": "TW",
    "tanzanian": "TZ",
    "thai": "TH",
    "togolese": "TG",
    "tokelauan": "TK",
    "tongan": "TO",
    "trinidadian": "TT",
    "tunisian": "TN",
    "turkish": "TR",
    "tuvaluan": "TV",
    "ugandan": "UG",
    "ukrainian": "UA",
    "uruguayan": "UY",
    "uzbekistani": "UZ",
    "venezuelan": "VE",
    "vietnamese": "VN",
    "wallisian": "WF",
    "futunan": "WF",
    "yemeni": "YE",
    "zambian": "ZM",
    "zimbabwean": "ZW",
}

adj_to_iso = {
    "afghan": "AF",
    "albanian": "AL",
    "algerian": "DZ",
    "american samoan": "AS",
    "american": "US",
    "andorran": "AD",
    "angolan": "AO",
    "anguillian": "AI",
    "antiguan": "AG",
    "argentinean": "AR",
    "argentinian": "AR",
    "argentine": "AR",
    "armenian": "AM",
    "aruban": "AW",
    "australian": "AU",
    "aussie": "AU",
    "austrian": "AT",
    "azerbaijani": "AZ",
    "bahamian": "BS",
    "bahraini": "BH",
    "bangladeshi": "BD",
    "barbadian": "BB",
    "barbudan": "AG",
    "belarusian": "BY",
    "belgian": "BE",
    "belizean": "BZ",
    "beninese": "BJ",
    "bermudian": "BM",
    "bhutanese": "BT",
    "bolivian": "BO",
    "bosnian": "BA",
    "brazilian": "BR",
    "british": "GB",
    "bruneian": "BN",
    "bulgarian": "BG",
    "burkinabe": "BF",
    "burundian": "BI",
    "cambodian": "KH",
    "cameroonian": "CM",
    "canadian": "CA",
    "cape verdian": "CV",
    "caymanian": "KY",
    "central african": "CF",
    "chadian": "TD",
    "chilean": "CL",
    "chinese": "CN",
    "colombian": "CO",
    "comoran": "KM",
    "congolese": "CG",
    "costa rican": "CR",
    "costarican": "CR",
    "croatian": "HR",
    "cuban": "CU",
    "curaçaoan": "CW",
    "cypriot": "CY",
    "czech": "CZ",
    "danish": "DK",
    "djibouti": "DJ",
    "dominican": "DO",
    "dutch": "NL",
    "timorese": "TL",
    "east timorese": "TL",
    "ecuadorean": "EC",
    "egyptian": "EG",
    "emirati": "AE",
    "equatorial guinean": "GQ",
    "eritrean": "ER",
    "estonian": "EE",
    "ethiopian": "ET",
    "falkland": "FK",
    "faroese": "FO",
    "fijian": "FJ",
    "filipino": "PH",
    "philippine": "PH",
    "finnish": "FI",
    "french polynesian": "PF",
    "french": "FR",
    "gabonese": "GA",
    "gambian": "GM",
    "georgian": "GE",
    "german": "DE",
    "ghanaian": "GH",
    "gibraltar": "GI",
    "hellenic": "GR",
    "grecian": "GR",
    "greek": "GR",
    "greenlandic": "GL",
    "grenadian": "GD",
    "guadeloupian": "GP",
    "guamanian": "GU",
    "guatemalan": "GT",
    "guinea-bissauan": "GW",
    "guinean": "GN",
    "guyanese": "GY",
    "haitian": "HT",
    "herzegovinian": "BA",
    "honduran": "HN",
    "hong kongese": "HK",
    "hongkongese": "HK",
    "hungarian": "HU",
    "i-kiribati": "KI",
    "kiribati": "KI",
    "icelander": "IS",
    "indian": "IN",
    "indonesian": "ID",
    "iranian": "IR",
    "persian": "IR",
    "iraqi": "IQ",
    "irish": "IE",
    "israeli": "IL",
    "italian": "IT",
    "ivorian": "CI",
    "jamaican": "JM",
    "japanese": "JP",
    "jordanian": "JO",
    "kazakhstani": "KZ",
    "kenyan": "KE",
    "kirghiz": "KG",
    "kittian and nevisian": "KN",
    "kittian": "KN",
    "kosovar": "XK",
    "nevisian": "KN",
    "kuwaiti": "KW",
    "laotian": "LA",
    "latvian": "LV",
    "lebanese": "LB",
    "liberian": "LR",
    "libyan": "LY",
    "liechtensteiner": "LI",
    "lithuanian": "LT",
    "luxembourger": "LU",
    "macanese": "MO",
    "macedonian": "MK",
    "malagasy": "MG",
    "malawian": "MW",
    "malaysian": "MY",
    "maldivan": "MV",
    "malian": "ML",
    "maltese": "MT",
    "manx": "IM",
    "marshallese": "MH",
    "mauritanian": "MR",
    "mauritian": "MU",
    "mexican": "MX",
    "micronesian": "FM",
    "moldovan": "MD",
    "monegasque": "MC",
    "mongolian": "MN",
    "montenegrin": "ME",
    "montserratian": "MS",
    "moroccan": "MA",
    "mosotho": "LS",
    "motswana": "BW",
    "mozambican": "MZ",
    "myanmar": "MM",
    "namibian": "NA",
    "nauruan": "NR",
    "nepalese": "NP",
    "new caledonian": "NC",
    "new zealander": "NZ",
    "ni-vanuatu": "VU",
    "vanuatu": "VU",
    "nicaraguan": "NI",
    "nigerien": "NE",
    "nigerian": "NG",
    "niuean": "NU",
    "norfolk islander": "NF",
    "north korean": "KP",
    "norwegian": "NO",
    "norse": "NO",
    "omani": "OM",
    "pakistani": "PK",
    "palauan": "PW",
    "palestinian": "PS",
    "panamanian": "PA",
    "papua new guinean": "PG",
    "paraguayan": "PY",
    "peruvian": "PE",
    "pitcairn": "PN",
    "polish": "PL",
    "portuguese": "PT",
    "puerto rican": "PR",
    "qatari": "QA",
    "romanian": "RO",
    "russian": "RU",
    "rwandan": "RW",
    "sahrawi": "EH",
    "saint barthelemian": "BL",
    "saint helenian": "SH",
    "saint lucian": "LC",
    "saint martinian": "MF",
    "saint vincentian": "VC",
    "salvadoran": "SV",
    "sammarinese": "SM",
    "samoan": "WS",
    "sao tomean": "ST",
    "saudi arabian": "SA",
    "senegalese": "SN",
    "serbian": "RS",
    "serbs": "CS",
    "seychellois": "SC",
    "sierra leonean": "SL",
    "singaporean": "SG",
    "slovak": "SK",
    "slovenian": "SI",
    "slovene": "SI",
    "solomon islander": "SB",
    "somali": "SO",
    "south african": "ZA",
    "south korean": "KR",
    "spanish": "ES",
    "sri lankan": "LK",
    "sudanese": "SD",
    "surinamer": "SR",
    "swazi": "SZ",
    "swedish": "SE",
    "swiss": "CH",
    "syrian": "SY",
    "tadzhik": "TJ",
    "taiwanese": "TW",
    "tanzanian": "TZ",
    "thai": "TH",
    "togolese": "TG",
    "tokelauan": "TK",
    "tongan": "TO",
    "trinidadian": "TT",
    "tunisian": "TN",
    "turkish": "TR",
    "turkmen": "TM",
    "tuvaluan": "TV",
    "ugandan": "UG",
    "ukrainian": "UA",
    "uruguayan": "UY",
    "uzbekistani": "UZ",
    "venezuelan": "VE",
    "vietnamese": "VN",
    "wallisian": "WF",
    "futunan": "WF",
    "yemeni": "YE",
    "zambian": "ZM",
    "zimbabwean": "ZW",
}

iso_to_adj = {iso: adj for adj, iso in adj_to_iso.items()}
