grapes = [
    {
        "name": "Abbuoto",
        "synonyms": ["Aboto", "Cecubo"],
        "description": {
            "default": "Rare, central Italian variety producing plenty of alcohol, generally blended.",
            "julie": "",
            "sommelier": "Abbuoto is the bold, enigmatic heart of central Italy, delivering a heady rush of plum, cherry, and earthy spice in every glass. Often blended, this grape brings both muscle and mystique to traditional table wines, making it a true hidden gem for adventurous palates.",
        },
        "color": "black",
        "regions": ["Lazio", "Campania", "Central Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "full_bodied", "table_wine", "traditional"],
    },
    {
        "name": "Abouriou",
        "synonyms": [
            "Early Burgundy",
            "Gamay-Saint-Laurent",
            "Loubéjac",
            "Malbec Argenté",
            "Plant Abouriou",
            "Précoce Naugé",
            "Précoce Noir",
            "Pressac de Bourgogne",
        ],
        "description": {
            "default": "Declining, early-ripening south-west French variety making tannic red.",
            "julie": "",
            "sommelier": "Abouriou is the bold, brooding poet of southwest France—delivering a full-bodied, tannic embrace of black plum, blackberry, and earthy spice. Once a local favorite, this early-ripening grape now offers a rare, rustic charm in both blends and varietal reds, perfect for those who crave a taste of tradition with a rebellious edge.",
        },
        "color": "black",
        "regions": ["South West France", "Côtes du Marmandais", "Lot-et-Garonne"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "red_fruit",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
            "age_worthy",
        ],
    },
    {
        "name": "Abrusco",
        "synonyms": [
            "Abrostalo",
            "Abrostine",
            "Abrostino",
            "Abrusco Nero",
            "Abrusio",
            "Colore",
            "Colorino",
            "Lambrusco",
            "Raverusto",
        ],
        "description": {
            "default": "Obscure and endangered late-ripening Italian red adding colour to blends.",
            "julie": "",
            "sommelier": "Abrusco is Tuscany’s secret weapon, lending brooding color, bold tannins, and a tapestry of black fruit and spice to traditional blends—think of it as the mysterious artist behind Italy’s most age-worthy reds. Rare and nearly forgotten, this grape is a hidden gem for those who crave depth and drama in their glass.",
        },
        "color": "black",
        "regions": ["Tuscany", "Central Italy"],
        "flavor_profile": ["black_fruit", "earth", "spice", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "age_worthy", "full_bodied"],
    },
    {
        "name": "Acitana",
        "synonyms": ["Citana Nera"],
        "description": {
            "default": "Rare dark-skinned variety from north-east Sicilia used in blends.",
            "julie": "",
            "sommelier": "Acitana is Sicily’s secret handshake—an elusive black grape lending blends a sultry medley of red and black fruits, subtle spice, and earthy charm. Medium in every measure, it’s the understated backbone of traditional Sicilian reds, quietly elevating the island’s table wines with rustic elegance.",
        },
        "color": "black",
        "regions": ["Sicilia", "Northeast Sicily"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine", "medium_bodied"],
    },
    {
        "name": "Acolon",
        "synonyms": ["Weinsberg 71-816-102"],
        "description": {
            "default": "Recently authorized German cross favoured for its colour and early ripening.",
            "julie": "",
            "sommelier": "Acolon is Germany’s stylish newcomer, offering a juicy medley of cherries, plums, and a dash of spice, all wrapped in a velvety, medium-bodied frame—perfect for those who like their reds vibrant and ready to pour.",
        },
        "color": "black",
        "regions": ["Germany", "Württemberg", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Adakarasi",
        "synonyms": ["Ada Karası"],
        "description": {
            "default": "Vine grown mainly on the Turkish island of Avşa, making soft, dark reds.",
            "julie": "",
            "sommelier": "Adakarasi, the pride of Avşa Island, pours a velvety, dark red brimming with juicy blackberries and plums, its gentle tannins and lively acidity making it the perfect companion for a sun-drenched Turkish table. This charming grape delivers a soft, easy-drinking style that invites you to savor the moment, glass after glass.",
        },
        "color": "black",
        "regions": ["Avşa Island", "Turkey"],
        "flavor_profile": ["black_fruit", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Adalmiina",
        "synonyms": ["Aldemina", "ES 6-16-30"],
        "description": {
            "default": "Minor but complex, cold-hardy American hybrid grown mostly in Québec.",
            "julie": "",
            "sommelier": "Adalmiina is a zesty northern gem, offering a lively medley of citrus, apple, and pear with a crisp, mineral edge—think of it as a brisk Québec morning in a glass. Perfect for those who crave a refreshing, unoaked white with a floral lift and a racy, palate-awakening acidity.",
        },
        "color": "white",
        "regions": ["Québec", "Canada", "Northern United States"],
        "flavor_profile": ["citrus", "floral", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Addoraca",
        "synonyms": ["Odoacra"],
        "description": {
            "default": "Extremely rare Calabrian white that contributes to an equally rare dessert wine.",
            "julie": "",
            "sommelier": "Addoraca is Calabria’s secret treasure, weaving together honeyed florals, sun-dried fruits, and a tropical breeze into a voluptuous, high-octane dessert wine that lingers like a Mediterranean sunset. This elusive grape is a must-try for adventurous palates seeking a taste of Italy’s rarest vinous jewels.",
        },
        "color": "white",
        "regions": ["Calabria"],
        "flavor_profile": [
            "dried_fruit",
            "honey",
            "floral",
            "stone_fruit",
            "tropical_fruit",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "premium",
            "reserve",
            "age_worthy",
            "blend",
        ],
    },
    {
        "name": "Affenthaler",
        "synonyms": [
            "Blauer Affenthaler",
            "Kleiner Trollinger",
            "Säuerlicher Burgunder",
        ],
        "description": {
            "default": "Very rare old variety from southern Germany.",
            "julie": "",
            "sommelier": "Affenthaler is a charmingly rare gem from southern Germany, offering a lively medley of cherry and raspberry with a whisper of herbs and earth, all wrapped in a light, zippy frame. Perfect for those who crave a refreshing, early-drinking red that dances on the palate and tells a story of tradition.",
        },
        "color": "black",
        "regions": ["Baden", "Württemberg", "Germany"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Agiorgitiko",
        "synonyms": [
            "Aghiorghitiko",
            "Mavro Nemeas",
            "Mavrostaphylo Mavraki",
            "Mavroudi Nemeas",
            "Nemeas Mavro",
        ],
        "description": {
            "default": "Greece’s most widely planted dark-skinned variety, capable of both high volumes and high quality as well as a wide range of styles.",
            "julie": "",
            "sommelier": "Agiorgitiko, the pride of Nemea, charms with juicy cherry and plum notes dusted in spice and earth, delivering a supple, medium-bodied red that’s as versatile as a Greek feast—equally at home in a casual taverna or a grand celebration.",
        },
        "color": "black",
        "regions": ["Nemea", "Peloponnese", "Greece"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Aglianico",
        "synonyms": [
            "Aglianco di Puglia",
            "Aglianica",
            "Aglianichella",
            "Aglianichello",
            "Aglianico Amaro",
            "Aglianico del Vulture",
            "Aglianico di Castellaneta",
            "Aglianico di Taurasi",
            "Aglianico Nero",
            "Aglianico Pannarano",
            "Aglianicuccia",
            "Agliano",
            "Agliatica",
            "Agliatico",
            "Agnanico",
            "Agnanico di Castellaneta",
            "Cascavoglia",
            "Cerasole",
            "Ellanico",
            "Ellenico",
            "Fiano Rosso",
            "Fresella",
            "Gagliano",
            "Ghiandara",
            "Ghianna",
            "Ghiannara",
            "Glianica",
            "Gnanica",
            "Gnanico",
            "Granica",
            "Olivella di S. Cosmo",
            "Ruopolo",
            "Spriema",
            "Tringarulo",
            "Uva Catellaneta",
            "Uva dei Cani",
            "Uva di Castellaneta",
            "Uva Nera",
        ],
        "description": {
            "default": "High-quality, late-ripening, tannic and ageworthy southern Italian red.",
            "julie": "",
            "sommelier": "Aglianico is the brooding poet of southern Italy—intensely tannic, brimming with black fruit, spice, and earthy intrigue, and destined to age gracefully for decades. This full-bodied powerhouse delivers a symphony of plum, leather, and smoky tobacco, making every sip a bold Mediterranean adventure.",
        },
        "color": "black",
        "regions": ["Campania", "Basilicata", "Puglia", "Molise"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "mineral",
            "leather",
            "tobacco",
            "smoke",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Agni",
        "synonyms": ["PE-11/47"],
        "description": {
            "default": "Recent Czech cross producing unusually aromatic reds.",
            "julie": "",
            "sommelier": "Agni is a vibrant Czech original, bursting with red fruit, floral, and spicy-herbal notes, delivering a lively, aromatic red with a zesty backbone. Perfect for those seeking a modern, early-drinking wine that dances between elegance and intrigue.",
        },
        "color": "black",
        "regions": ["Czech Republic", "Moravia", "Central Europe"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "spice"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Aïdani",
        "synonyms": [
            "Adani",
            "Aedano Leyko",
            "Aïdani Aspro",
            "Aïdani Blanc",
            "Aïdani Lefko",
            "Aspaedano",
            "Aspraïdano",
            "Moschaïdano",
        ],
        "description": {
            "default": "Minor, aromatic Greek variety that plays a small but significant role in the wines of Santoríni.",
            "julie": "",
            "sommelier": "Aïdani is Santoríni’s secret whisper of citrus, stone fruit, and wildflowers, bringing a breezy, mineral elegance to Greek white blends. With its high acidity and feather-light body, this grape is the island’s invitation to sip the sun and sea in every glass.",
        },
        "color": "white",
        "regions": ["Santoríni", "Cyclades", "Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Airén",
        "synonyms": [
            "Aidén",
            "Blancón",
            "Burra Blanca",
            "Colgadera",
            "Forcallada",
            "Forcallat",
            "Forcallat Blanca",
            "Manchega",
            "Valdepeñera Blanca",
            "Valdepeñas",
        ],
        "description": {
            "default": "Spain’s most widely planted light-skinned variety making brandy and rather neutral, fresh white wines.",
            "julie": "",
            "sommelier": "Airén is the unsung hero of Spanish vineyards, delivering crisp, mineral-driven whites with gentle citrus and orchard fruit notes—perfect for a sunny afternoon or as the backbone of a classic Spanish brandy.",
        },
        "color": "white",
        "regions": ["La Mancha", "Valdepeñas", "Castilla-La Mancha", "Spain"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Akhtanak",
        "synonyms": ["2-18-23", "Akchtanak", "Haghtanak", "Hakhtanak"],
        "description": {
            "default": "Versatile, late-ripening Armenian complex cross.",
            "julie": "",
            "sommelier": "Akhtanak is Armenia’s bold black grape, delivering a full-bodied symphony of plum, cherry, and blackberry, laced with spice and earthy intrigue—think of it as the velvet-clad hero of both traditional and modern Armenian reds, with enough acidity and structure to age gracefully or shine in a glass today.",
        },
        "color": "black",
        "regions": ["Armenia", "Ararat Valley", "Vayots Dzor"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "full_bodied",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Aladasturi",
        "synonyms": ["Aladastouri", "Anadassaouli", "Anadastouri"],
        "description": {
            "default": "Minor Georgian variety responsible for alcoholic reds.",
            "julie": "",
            "sommelier": "Aladasturi is Georgia’s bold, black-skinned secret, delivering full-bodied reds brimming with juicy red fruit, earthy undertones, and a spicy kick—perfect for those who like their wines as lively and spirited as a Georgian supra. This high-octane grape is a celebration in a glass, ready to charm both traditionalists and adventurous palates alike.",
        },
        "color": "black",
        "regions": ["Georgia"],
        "flavor_profile": ["red_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Alarije",
        "synonyms": [
            "Acería",
            "Alarije Dorada",
            "Alarije Dorado",
            "Alarije Verdoso",
            "Arín",
            "Arís",
            "Cagazal",
            "Coloraillo Gordo",
            "Coloraillo Pequeno",
            "Esclafacherri",
            "Malfar",
            "Malvasía",
            "Malvasía Riojana",
            "Pirulés Dorada  and Pirulés Verde",
            "Rojal",
            "Subirat",
            "Subirat Parent",
        ],
        "description": {
            "default": "Light-skinned variety from south-west Spain travelling under many aliases.",
            "julie": "",
            "sommelier": "Alarije is the chameleon of Spanish white grapes, slipping under many names but always delivering a zesty medley of citrus, stone fruit, and floral notes with a refreshing mineral streak. Light-bodied and lively, it’s the perfect companion for sun-drenched afternoons and convivial tables.",
        },
        "color": "white",
        "regions": ["Extremadura", "Castilla-La Mancha", "Andalusia", "La Rioja"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Albalonga",
        "synonyms": ["Würzburg B 51-2-1"],
        "description": {
            "default": "Fresh and aromatically complex German cross planted and valued mainly in Rheinhessen.",
            "julie": "",
            "sommelier": "Albalonga is Rheinhessen’s aromatic secret, bursting with zesty citrus, juicy stone fruit, and a floral-mineral lift, all wrapped in a lively, high-acid frame. This rare German gem delivers a refreshing, premium white wine experience that’s as intriguing as it is delicious.",
        },
        "color": "white",
        "regions": ["Rheinhessen", "Germany"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "varietal", "table_wine", "early_drinking", "premium"],
    },
    {
        "name": "Albana",
        "synonyms": [
            "Albana a Grappolo Fitto",
            "Albana a Grappolo Lungo",
            "Albana della Forcella",
            "Albana di Romagna",
            "Albana Gentile",
            "Albana Grossa",
            "Albanone",
            "Ribona",
            "Riminèse",
            "Sforcella",
        ],
        "description": {
            "default": "Ancient but inherently neutral Italian variety that can produce very good sweet wines.",
            "julie": "",
            "sommelier": "Albana is Emilia-Romagna’s golden secret, delivering vibrant notes of stone fruit, honey, and florals with a zesty acidity that shines in both crisp whites and luscious dessert wines—proof that ancient grapes can still surprise and delight modern palates.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Italy"],
        "flavor_profile": [
            "stone_fruit",
            "apple",
            "pear",
            "honey",
            "dried_fruit",
            "floral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Albanello",
        "synonyms": ["Albanello di Siracusa"],
        "description": {
            "default": "Disappearing Sicilian variety once used for sweet wines.",
            "julie": "",
            "sommelier": "Albanello, the elusive jewel of Sicily, enchants with a honeyed bouquet of stone fruit and citrus, delivering a full-bodied embrace that whispers of sun-drenched orchards and bygone Sicilian feasts. Once nearly lost, this grape is a rare treat for those seeking a taste of history in every golden glass.",
        },
        "color": "white",
        "regions": ["Sicily", "Siracusa"],
        "flavor_profile": ["stone_fruit", "dried_fruit", "honey", "floral", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["white", "dessert", "full_bodied", "varietal", "traditional"],
    },
    {
        "name": "Albaranzeuli Bianco",
        "synonyms": ["Laconari", "Lacconargiu", "Lacconarzu"],
        "description": {
            "default": "Virtually extinct white grape from Sardegna.",
            "julie": "",
            "sommelier": "Albaranzeuli Bianco is Sardinia’s elusive white treasure, offering a delicate dance of citrus, stone fruit, and floral notes over a whisper of minerality. Light-bodied and lively, this nearly vanished grape is a refreshing sip of Mediterranean history.",
        },
        "color": "white",
        "regions": ["Sardegna", "Sardinia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Albaranzeuli Nero",
        "synonyms": ["Albarenzelin Nero", "Uva Melone"],
        "description": {
            "default": "A pinky-red-skinned Sardinian variety still very occasionally used in blends.",
            "julie": "",
            "sommelier": "Albaranzeuli Nero is Sardinia’s elusive pinky-red gem, offering a breezy medley of red fruit, wild herbs, and floral whispers in a light, easy-drinking style. A true island rarity, it’s a delightful companion for those seeking a taste of Sardinian tradition in every sip.",
        },
        "color": "red",
        "regions": ["Sardinia"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Albarín Blanco",
        "synonyms": [
            "Blanco Legítimo",
            "Blanco País",
            "Blanco Verdín",
            "Branco Lexítimo",
            "Raposo",
            "Tinta Fina",
        ],
        "description": {
            "default": "Very minor variety from the far north of Spain.",
            "julie": "",
            "sommelier": "Albarín Blanco is a vivacious northern Spanish gem, bursting with citrus, apple, and pear, and finishing with a racy mineral streak—think of it as a mountain stream in a glass, perfect for those who crave freshness and finesse.",
        },
        "color": "white",
        "regions": ["Asturias", "León", "Castilla y León", "Galicia"],
        "flavor_profile": ["citrus", "floral", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Albarola",
        "synonyms": ["Bianchetta Genovese", "Calcatella"],
        "description": {
            "default": "Neutral white grape of Liguria.",
            "julie": "",
            "sommelier": "Albarola is Liguria’s breezy white, offering a zesty medley of citrus and stone fruit with a whisper of seaside minerality—think of it as the Mediterranean in a glass, perfect for a sun-drenched afternoon or a plate of fresh seafood.",
        },
        "color": "white",
        "regions": ["Liguria", "Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Albarossa",
        "synonyms": ["Incrocio Dalmasso XV/31"],
        "description": {
            "default": "Minor Piemontese dark-skinned cross recently replanted by Michele Chiarlo.",
            "julie": "",
            "sommelier": "Albarossa is Piedmont’s hidden gem, weaving together vibrant cherry and plum with a dash of spice and earth, all wrapped in a lively, medium-bodied frame. This grape is a sommelier’s delight—equally at home in a rustic trattoria or aging gracefully in your cellar.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "earth",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "varietal",
            "blend",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Albillo Mayor",
        "synonyms": ["Albilla", "Pardina", "Turruntes", "Turruntés"],
        "description": {
            "default": "Ribera del Duero variety used mostly in blends and now partly disentangled from the Albillo confusion.",
            "julie": "",
            "sommelier": "Albillo Mayor is the unsung white gem of Ribera del Duero, offering a harmonious medley of pear, peach, and delicate florals, all wrapped in a mineral embrace. Whether oaked or unoaked, this grape brings a sophisticated, medium-bodied charm that can age gracefully or delight in its youth.",
        },
        "color": "white",
        "regions": ["Ribera del Duero", "Castilla y León", "Madrid", "Spain"],
        "flavor_profile": ["stone_fruit", "pear", "peach", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "varietal",
            "medium_bodied",
            "oaked",
            "unoaked",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Albillo Real",
        "synonyms": ["Albillo", "Albillo de Cebreros", "Albillo de Madrid"],
        "description": {
            "default": "Aromatic Spanish variety producing smooth wines that are used mostly in blends, both red and white.",
            "julie": "",
            "sommelier": "Albillo Real is Spain’s aromatic white gem, weaving together notes of juicy pear, peach, and wildflowers with a subtle mineral backbone—perfect for those who crave a smooth, medium-bodied wine that shines both solo and in a blend. This grape is a delightful secret from Madrid and Castilla y León, offering a honeyed whisper of Spanish sunshine in every sip.",
        },
        "color": "white",
        "regions": ["Spain", "Madrid", "Castilla y León", "Cebreros"],
        "flavor_profile": [
            "stone_fruit",
            "floral",
            "mineral",
            "honey",
            "pear",
            "peach",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Alcañón",
        "synonyms": ["Blanco Castellano", "Bobal Blanca"],
        "description": {
            "default": "Rare variety producing light but characterful whites in Somontano.",
            "julie": "",
            "sommelier": "Alcañón is a hidden gem from Somontano, delivering zesty citrus and delicate stone fruit flavors wrapped in a floral, mineral embrace—think of it as Spain’s answer to a mountain spring in a glass. With its lively acidity and feather-light body, this rare varietal is a refreshing adventure for the curious palate.",
        },
        "color": "white",
        "regions": ["Somontano", "Aragon", "Spain"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "light_bodied", "unoaked", "varietal", "table_wine"],
    },
    {
        "name": "Aleatico",
        "synonyms": [
            "Aleaticu",
            "Halápi",
            "Moscatello Nero",
            "Moscato Nero",
            "Vernaccia di Pergola",
            "Vernaccia Moscatella",
        ],
        "description": {
            "default": "Unusually perfumed and Muscat-like Italian red.",
            "julie": "",
            "sommelier": "Aleatico is Italy’s aromatic wild child, bursting with rose petals, red berries, and a whiff of exotic spice—think Muscat in a velvet smoking jacket. Whether sipped young or aged, this grape delivers a perfumed, medium-bodied ride that’s as enchanting as a Tuscan sunset.",
        },
        "color": "black",
        "regions": ["Tuscany", "Lazio", "Puglia", "Elba", "Umbria"],
        "flavor_profile": ["red_fruit", "dried_fruit", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Aleksandrouli",
        "synonyms": ["Aleksandroouly", "Aleksandrouli Shavi", "Alexandrouli"],
        "description": {
            "default": "Rare but highly promising Georgian variety often late harvested for violet-scented semi-sweet wines.",
            "julie": "",
            "sommelier": "Aleksandrouli is Georgia’s hidden gem, seducing the senses with a bouquet of violets, ripe plums, and cherries, all wrapped in a silky, medium-bodied embrace—perfect for those who crave a touch of sweetness and floral intrigue in their glass.",
        },
        "color": "black",
        "regions": ["Georgia", "Racha"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "dried_fruit",
            "floral",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Alexander",
        "synonyms": [
            "Alexandria",
            "Black Cape",
            "Buck Grape",
            "Cape",
            "Clifton’s Constantia",
            "Clifton’s Lombardia",
            "Columbian",
            "Constantia",
            "Farkers Grape",
            "Madeira of York",
            "Rothrock",
            "Rothrock of Prince",
            "Schuylkill",
            "Schuylkill Muscadel",
            "Schuylkill Muscadine",
            "Springmill Constantia",
            "Tasker’s Grape",
            "Vevay",
            "Vevay Winne",
            "Winne",
            "York Lisbon",
        ],
        "description": {
            "default": "American hybrid of purely historical significance in the US.",
            "julie": "",
            "sommelier": "Once the toast of early American vineyards, Alexander is a light-bodied, low-alcohol red that charms with whispers of red and black fruit, earthy undertones, and a touch of herbal intrigue—a true taste of American wine history in every glass.",
        },
        "color": "black",
        "regions": ["Pennsylvania", "New York", "Ohio", "United States"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "blend",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Alfrocheiro",
        "synonyms": [
            "Albarín Negro",
            "Albarín Tinto",
            "Alfrocheiro Preto",
            "Alfrucheiro",
            "Baboso Negro",
            "Bastardo Negro",
            "Bruñal",
            "Caiño Gordo",
            "Tinta Bastardinha",
            "Tinta Francesa de Viseu",
        ],
        "description": {
            "default": "Portuguese variety with intense fruit aromas and high quality potential.",
            "julie": "",
            "sommelier": "Alfrocheiro is Portugal’s secret weapon, delivering a vibrant medley of cherries, plums, and earthy spice wrapped in a lively, high-acid frame—perfect for both early sipping and cellaring. This grape’s medium body and supple tannins make it a versatile star in blends or as a solo act, always promising a spirited, fruit-forward performance.",
        },
        "color": "black",
        "regions": ["Dão", "Alentejo", "Beira Interior", "Portugal"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Alicante Henri Bouschet",
        "synonyms": [
            "Alicante",
            "Alicante Bouschet",
            "Alicante Bouschet no. 2",
            "Dalmatinka",
            "Garnacha Tintorera",
            "Kambuša",
            "Sumo Tinto",
            "Tintorera",
        ],
        "description": {
            "default": "Productive, widely dispersed, red-fleshed southern French cross on the wane in France but waxing in southern Portugal.",
            "julie": "",
            "sommelier": "Alicante Henri Bouschet is the bold chameleon of the vineyard, offering a juicy medley of plum and cherry wrapped in earthy spice, all delivered with a full-bodied swagger and a splash of southern sun—perfect for those who like their reds both powerful and plush.",
        },
        "color": "black",
        "regions": [
            "Southern France",
            "Alentejo (Portugal)",
            "Douro (Portugal)",
            "Spain",
            "California",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "earth",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "full_bodied",
            "table_wine",
            "traditional",
            "modern",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Aligoté",
        "synonyms": [
            "Aligotte",
            "Alligotay",
            "Alligoté",
            "Alligotet",
            "Beaunois",
            "Carcairone",
            "Chaudenet Gras",
            "Giboulot",
            "Giboudot",
            "Griset Blanc",
            "Mahranauli",
            "Plant de Trois",
            "Plant Gris",
            "Troyen Blanc",
            "Vert Blanc",
        ],
        "description": {
            "default": "Burgundy’s tart ‘other’ white wine grape, particularly popular in Eastern Europe.",
            "julie": "",
            "sommelier": "Aligoté is Burgundy’s vivacious underdog, delivering a crisp, citrusy punch with a mineral backbone and floral lift—perfect for those who crave a refreshing, high-acid white that dances on the palate. Often enjoyed young and unoaked, it’s the ultimate apéritif or a zesty companion to seafood and sunshine.",
        },
        "color": "white",
        "regions": ["Burgundy", "Bulgaria", "Moldova", "Russia", "Romania"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral", "lemon"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Alionza",
        "synonyms": [
            "Aleonza",
            "Alionga Bianca del Bolognese",
            "Allionza",
            "Glionza",
            "Leonza",
            "Uva Lonza",
            "Uva Schiava",
        ],
        "description": {
            "default": "Rare but ancient white on the verge of extinction.",
            "julie": "",
            "sommelier": "Alionza is Emilia-Romagna’s whisper from the past—a delicate, light-bodied white grape offering a refreshing medley of citrus, apple, and floral notes with a subtle mineral finish. Nearly extinct, this ancient variety is a rare treat for adventurous palates seeking a taste of Italian wine history.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Italy"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Allegro",
        "synonyms": ["Geisenheim 8331-1"],
        "description": {
            "default": "German hybrid with good disease resistance.",
            "julie": "",
            "sommelier": "Allegro is Germany’s lively answer to easy-drinking reds, offering a playful medley of red and black fruits with a whisper of herbs. Light on its feet and refreshingly unoaked, this grape is perfect for those who crave a spirited, uncomplicated glass that’s ready to enjoy now.",
        },
        "color": "black",
        "regions": ["Germany"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Altesse",
        "synonyms": [
            "Anet",
            "Fusette d’Ambérieu",
            "Marestel",
            "Plant d’Altesse",
            "Prin Blanc",
            "Roussette",
            "Roussette de Montagnieu",
            "Roussette de Seyssel",
            "Roussette Haute",
        ],
        "description": {
            "default": "Savoie’s finest grape making delicate whites.",
            "julie": "",
            "sommelier": "Altesse, Savoie's regal white, enchants with a bouquet of alpine flowers, ripe pear, and a whisper of honey, all carried on a brisk, mineral-laced acidity—think of it as mountain air in a glass, elegant and built to age gracefully.",
        },
        "color": "white",
        "regions": ["Savoie", "Bugey", "France"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "pear",
            "peach",
            "mineral",
            "honey",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Alvarelhão",
        "synonyms": [
            "Albarello",
            "Alvarelhao",
            "Alvarelho",
            "Alvarellao",
            "Brancelho",
            "Brancellao",
            "Broncellao",
            "Locaia",
            "Pilongo",
            "Pirruivo",
            "Serradelo",
            "Serradillo",
            "Uva Gallega",
            "Varancelha",
            "Verancelha",
        ],
        "description": {
            "default": "Declining but potentially high-quality variety from northern Portugal.",
            "julie": "",
            "sommelier": "Alvarelhão is a lively northern Portuguese grape that dazzles with bright cherry and raspberry flavors, accented by floral and herbal notes—think of it as a spirited conversation between a spring garden and a spice market. With its zippy acidity and medium body, this grape crafts wines that are as charmingly fresh as they are rare, perfect for those seeking a taste of tradition with a twist.",
        },
        "color": "black",
        "regions": [
            "Dão",
            "Douro",
            "Ribeira Sacra",
            "Rías Baixas",
            "Galicia",
            "Northern Portugal",
        ],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "spice",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Alvarinho",
        "synonyms": [
            "Albariño",
            "Albelleiro",
            "Alvarin Blanco",
            "Azal Blanco",
            "Galego",
            "Galeguinho",
            "Padernã",
        ],
        "description": {
            "default": "Fashionable, high-quality, fresh, aromatic variety straddling the Spanish–Portuguese border.",
            "julie": "",
            "sommelier": "Alvarinho, the darling of the Iberian coast, dazzles with zesty citrus, juicy peach, and a whisper of sea breeze minerality—think of it as summer in a glass, perfect for sipping on sun-drenched afternoons or pairing with fresh seafood.",
        },
        "color": "white",
        "regions": ["Rías Baixas", "Vinho Verde", "Galicia", "Minho"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "lemon",
            "peach",
            "apple",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "premium",
            "early_drinking",
            "age_worthy",
        ],
    },
    {
        "name": "Amaral",
        "synonyms": [
            "Azal Tinto",
            "Azar",
            "Cainho Bravo",
            "Cainho Miúdo",
            "Caíño Bravo",
            "Cainzinho",
        ],
        "description": {
            "default": "High-acid Portuguese red found mainly in Vinho Verde.",
            "julie": "",
            "sommelier": "Amaral is the zesty secret of Northern Portugal, bursting with raspberry, wild herbs, and a stony minerality that dances across the palate. With its high acidity and feather-light body, this grape crafts vibrant, early-drinking reds that are as refreshing as a cool Atlantic breeze.",
        },
        "color": "black",
        "regions": ["Vinho Verde", "Minho", "Northern Portugal"],
        "flavor_profile": ["red_fruit", "herbal", "mineral", "raspberry"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Amigne",
        "synonyms": [
            "Amigne Blanche",
            "Grande Amigne",
            "Grosse Amigne",
            "Petite Amigne",
        ],
        "description": {
            "default": "Ancient but minor Swiss variety making mainly sweeter styles of wine.",
            "julie": "",
            "sommelier": "Amigne is Switzerland’s secret treasure, weaving together honeyed florals, zesty citrus, and a mineral backbone into a luscious, age-worthy white that dazzles with every sip. This rare grape from Valais is a sommelier’s delight—think liquid Alpine gold with a refreshing twist.",
        },
        "color": "white",
        "regions": ["Switzerland", "Valais"],
        "flavor_profile": [
            "floral",
            "honey",
            "dried_fruit",
            "citrus",
            "stone_fruit",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Ancellotta",
        "synonyms": ["Ancellotta di Massenzatico", "Lancellotta"],
        "description": {
            "default": "Useful, deeply coloured blending ingredient valued more for its colour, tannins and acidity than for its flavour.",
            "julie": "",
            "sommelier": "Ancellotta is the secret weapon of Italian winemakers, lending a brooding inky hue, assertive tannins, and zesty acidity to blends, while whispering notes of blackberry and plum. Though rarely the star, this grape is the unsung hero that gives many wines their backbone and boldness.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Lombardy", "Italy"],
        "flavor_profile": ["black_fruit", "plum", "blackberry"],
        "acidity": "High",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "medium_bodied",
        ],
    },
    {
        "name": "André",
        "synonyms": ["Andrea", "Semenac A 16-76"],
        "description": {
            "default": "Late-ripening Czech cross producing well-structured reds if harvested fully ripe.",
            "julie": "",
            "sommelier": "André is Central Europe's answer to a well-structured, medium-bodied red, brimming with cherry, plum, and a whisper of earthy spice—think of it as the Czech Republic’s secret handshake to the world of wine. When fully ripe, it delivers a harmonious balance that’s both charmingly traditional and quietly sophisticated.",
        },
        "color": "black",
        "regions": ["Czech Republic", "Slovakia", "Moravia", "Central Europe"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Antão Vaz",
        "synonyms": ["Antonio Vaz"],
        "description": {
            "default": "High-quality Portuguese variety at home in the hot, dry south.",
            "julie": "",
            "sommelier": "Antão Vaz is the sun-kissed star of southern Portugal, delivering lush, full-bodied whites bursting with citrus, stone fruit, and tropical flair, all wrapped in a mineral embrace. Whether sipped young or aged to perfection, this grape brings a taste of Alentejo’s golden warmth to every glass.",
        },
        "color": "white",
        "regions": ["Alentejo", "Portugal (southern regions)"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "mineral",
            "floral",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "full_bodied",
            "unoaked",
            "oaked",
            "varietal",
            "blend",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Antey Magarachsky",
        "synonyms": ["Antei", "Antei Magarachskii", "Magarach 70-71-52"],
        "description": {
            "default": "Ukrainian hybrid used to make sweet red wines.",
            "julie": "",
            "sommelier": "Antey Magarachsky is a luscious Ukrainian hybrid that bursts with flavors of ripe plum, cherry, and dried fruits, delivering a full-bodied, velvety red wine with a gentle touch of sweetness. Perfect for those who crave a fruit-forward, easy-drinking wine with a hint of Eastern European intrigue.",
        },
        "color": "black",
        "regions": ["Ukraine", "Crimea", "Russia"],
        "flavor_profile": ["red_fruit", "black_fruit", "dried_fruit", "plum", "cherry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "full_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Araklinos",
        "synonyms": ["Araclinos", "Araklino", "Raklino"],
        "description": {
            "default": "Rare Greek variety used mainly in red blends.",
            "julie": "",
            "sommelier": "Araklinos is a hidden gem of Greece, weaving together red and black fruits with a whisper of herbs and earthy intrigue—perfect for those seeking a taste of the Peloponnese or Crete in their glass. Medium-bodied and harmoniously balanced, it’s the secret ingredient in many a soulful Greek blend.",
        },
        "color": "black",
        "regions": ["Greece", "Peloponnese", "Crete"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Aramon Noir",
        "synonyms": [
            "Amor-Não-Me-Deixes",
            "Aramonen",
            "Gros Bouteillan",
            "Pisse-Vin",
            "Plant Riche",
            "Rabalaïré",
            "Ramonen",
            "Réballaïré",
            "Ugni Noir",
        ],
        "description": {
            "default": "Very productive vine once responsible for much of France’s least noble wine.",
            "julie": "",
            "sommelier": "Aramon Noir is the workhorse of Southern France, producing light-bodied, zesty reds bursting with red fruit and herbal notes—think of it as the humble, thirst-quenching companion to a sun-drenched picnic. Once the backbone of everyday French wine, it’s a grape that brings a touch of rustic nostalgia to the glass.",
        },
        "color": "black",
        "regions": ["Languedoc", "Southern France", "Gard", "Hérault"],
        "flavor_profile": ["red_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "blend",
            "traditional",
        ],
    },
    {
        "name": "Arany Sárfehér",
        "synonyms": [
            "Fehér Kadarka",
            "Fehér Muskotály",
            "Huszár Szőlő",
            "Izsáki",
            "Izsáki Fehér",
            "Izsáki Sárfehér",
            "Német Dinka",
            "Vékonyhéjú",
        ],
        "description": {
            "default": "Hungarian variety making simple but useful, high-acid wines and fizz on the Alföld (Great Plain).",
            "julie": "",
            "sommelier": "Arany Sárfehér is Hungary’s zesty answer to thirst-quenching whites, bursting with citrus and apple, a floral breeze, and a mineral snap—think of it as the Great Plain’s sparkling, feather-light refreshment, perfect for picnics and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Hungary", "Alföld (Great Plain)"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Arbane",
        "synonyms": [
            "Albane",
            "Arbanne",
            "Arbenne",
            "Arbone",
            "Crène",
            "Crénillat",
            "Darbanne",
        ],
        "description": {
            "default": "Old, aromatic but virtually extinct variety from southern Champagne.",
            "julie": "",
            "sommelier": "Arbane is Champagne’s elusive white gem, offering a zesty medley of citrus and stone fruit with a floral lift and racy acidity—think of it as the secret spice in the region’s most age-worthy sparkling blends. A true sommelier’s delight, this grape is a rare treat for those who seek the thrill of the nearly extinct.",
        },
        "color": "white",
        "regions": ["Champagne", "France"],
        "flavor_profile": ["citrus", "floral", "stone_fruit", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "blend",
            "traditional",
            "age_worthy",
            "light_bodied",
        ],
    },
    {
        "name": "Areni",
        "synonyms": [
            "Areni Chernyi",
            "Areni Noir",
            "Areny",
            "Areny Tcherny",
            "Malai Sev",
            "Malayi",
            "Sev Areni",
            "Urza Sev",
        ],
        "description": {
            "default": "Armenia’s signature variety making top-quality dry and sweet reds.",
            "julie": "",
            "sommelier": "Areni, the pride of Armenia, dazzles with a tapestry of cherry, plum, and blackberry woven through earthy spice and mineral undertones—think of it as the ancient soul of the Caucasus in a glass, equally at home in a rustic village feast or a modern wine bar. With lively acidity and supple tannins, Areni’s reds are as versatile as they are age-worthy, making every sip a journey through Armenian history.",
        },
        "color": "black",
        "regions": ["Armenia", "Vayots Dzor"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Arilla",
        "synonyms": ["Agrilla", "Arillo", "Rille", "Uva Rilla"],
        "description": {
            "default": "Rare but productive island white from southern Italy.",
            "julie": "",
            "sommelier": "Arilla is Ischia’s sun-kissed secret: a zesty, mineral-driven white that dances with citrus and stone fruit, perfect for seaside sipping. With its high acidity and breezy lightness, this rare southern Italian gem is a refreshing escape in every glass.",
        },
        "color": "white",
        "regions": ["Ischia", "Campania", "Southern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Arinto De Bucelas",
        "synonyms": [
            "Arinto",
            "Arinto Branco",
            "Arinto Cercial",
            "Arinto d’Anadia",
            "Arinto Galego",
            "Arintho",
            "Azal Espanhol",
            "Chapeludo",
            "Pedernã",
            "Terrantez da Terceira",
        ],
        "description": {
            "default": "High-quality, high-acid, adaptable Portuguese variety from just north of Lisboa.",
            "julie": "",
            "sommelier": "Arinto De Bucelas is Portugal’s zesty white gem, bursting with citrus and green apple, and a racy acidity that dances on the palate—think of it as the life of the party in your glass, equally at home in a crisp aperitif or a sophisticated, age-worthy bottle.",
        },
        "color": "white",
        "regions": ["Bucelas", "Lisboa", "Vinho Verde", "Tejo", "Dão", "Alentejo"],
        "flavor_profile": ["citrus", "apple", "lemon", "mineral", "stone_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Arna-Grna",
        "synonyms": ["Alagura", "Arha-Grna", "Khana Crna"],
        "description": {
            "default": "Light-skinned Azeri variety found mainly in the Nakhchivan Autonomous Republic.",
            "julie": "",
            "sommelier": "Arna-Grna is a charmingly rare white grape from Azerbaijan’s Nakhchivan region, offering a breezy medley of citrus, stone fruit, and delicate florals over a crisp mineral backbone—think of it as the Caspian’s answer to a summer afternoon in a glass.",
        },
        "color": "white",
        "regions": ["Nakhchivan Autonomous Republic", "Azerbaijan"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Arneis",
        "synonyms": ["Bianchetta di Alba", "Bianchetto", "Nebbiolo Bianco"],
        "description": {
            "default": "Piemonte’s scented and full-bodied signature dry white.",
            "julie": "",
            "sommelier": "Arneis is Piemonte’s enchanting white, seducing with fragrant blossoms, ripe pear, and a whisper of minerality, all wrapped in a luxuriously full body. This “little rascal” is the Italian answer to aromatic whites—delightfully complex yet refreshingly easy to love.",
        },
        "color": "white",
        "regions": ["Piemonte", "Roero", "Langhe"],
        "flavor_profile": ["floral", "stone_fruit", "pear", "peach", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Arnsburger",
        "synonyms": ["Geisenheim 22-74"],
        "description": {
            "default": "Scarce German cross used to make base wines for inexpensive fizz.",
            "julie": "",
            "sommelier": "Arnsburger is a zippy German white grape that brings a lively medley of citrus, apple, and pear to the glass, making it the unsung hero behind many a sparkling wine. With its high acidity and feather-light body, it's the perfect partner for a refreshing, early-drinking fizz.",
        },
        "color": "white",
        "regions": ["Germany"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "table_wine",
            "blend",
        ],
    },
    {
        "name": "Arrouya",
        "synonyms": ["Dourec Noir", "Eremachaoua", "Erematxahua"],
        "description": {
            "default": "Virtually extinct old Jurançon vine.",
            "julie": "",
            "sommelier": "Arrouya, the elusive black gem of Jurançon, enchants with a rustic medley of red and black fruits, earthy undertones, and a whisper of herbs—an evocative taste of Southwest France’s nearly forgotten vineyards. Medium-bodied and versatile, it’s a rare treat for those seeking tradition in their glass.",
        },
        "color": "black",
        "regions": ["Jurançon", "Southwest France"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Arrufiac",
        "synonyms": [
            "Arrefiat",
            "Arruffiac",
            "Arruffiat",
            "Arrufiat",
            "Bouisselet",
            "Raffiac",
            "Raffiat",
            "Réfiat",
            "Rufiat",
            "Zurizerratia",
        ],
        "description": {
            "default": "South-west France relic starting to regain a little local respect.",
            "julie": "",
            "sommelier": "Arrufiac is a zesty relic from Gascony, delivering a lively medley of citrus, pear, and stony minerality with a floral lift—think of it as the comeback kid of French whites, perfect for those who crave crisp, unoaked elegance with a dash of history.",
        },
        "color": "white",
        "regions": ["South-West France", "Gascony", "Pacherenc du Vic-Bilh"],
        "flavor_profile": [
            "citrus",
            "floral",
            "mineral",
            "stone_fruit",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Arvesiniadu",
        "synonyms": [
            "Argu Ingianau",
            "Arvesimiadu Bianco",
            "Arvu Siniadu",
            "Uva Oschirese",
        ],
        "description": {
            "default": "Rare Sardinian white that disappears into blends.",
            "julie": "",
            "sommelier": "Arvesiniadu is Sardinia’s secret handshake—a rare white grape that whispers of citrus, crisp apple, and stony minerals, perfect for those who love their wines light, lively, and a little mysterious. Blink and you’ll miss it in blends, but catch it solo and you’ll taste the island’s sunlit charm in every sip.",
        },
        "color": "white",
        "regions": ["Sardinia"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Arvine",
        "synonyms": ["Arvena", "Arvina", "Petite Arvine"],
        "description": {
            "default": "The finest indigenous Valais variety making lively, sometimes intense, whites both dry and sweet.",
            "julie": "",
            "sommelier": "Petite Arvine dazzles with zesty citrus, wisteria, and rhubarb, finishing with a mouthwatering saline snap—think of it as the Swiss Alps in a glass, perfect for elevating fondue or lobster to new heights.",
        },
        "color": "white",
        "regions": ["Valais", "Switzerland"],
        "flavor_profile": ["citrus", "floral", "vegetal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "medium_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Ashughaji",
        "synonyms": ["Achougage", "Ashugazh"],
        "description": {
            "default": "Minor Georgian variety producing fresh, aromatic reds.",
            "julie": "",
            "sommelier": "Ashughaji is Georgia’s hidden gem, delivering a lively, aromatic red brimming with cherry, raspberry, and a hint of spice—think of it as a floral serenade in a glass, perfect for those who crave freshness and tradition in every sip.",
        },
        "color": "black",
        "regions": ["Georgia"],
        "flavor_profile": ["red_fruit", "floral", "spice", "cherry", "raspberry"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Aspiran Bouschet",
        "synonyms": ["Grand Noir de Laques"],
        "description": {
            "default": "Deeply coloured but almost extinct.",
            "julie": "",
            "sommelier": "Aspiran Bouschet is a shadowy relic of Southern France, offering a full-bodied embrace of black fruit, earthy spice, and juicy plum—an almost forgotten grape that paints your glass with history and intrigue.",
        },
        "color": "black",
        "regions": ["Languedoc", "Southern France"],
        "flavor_profile": ["black_fruit", "earth", "spice", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Assyrtiko",
        "synonyms": ["Assirtico", "Assyrtico", "Asyrtico", "Asyrtiko"],
        "description": {
            "default": "Top-quality, intense, highly structured Greek island white that retains acidity even in the heat.",
            "julie": "",
            "sommelier": "Assyrtiko is Santorini’s sun-kissed gift to the wine world, dazzling with zesty citrus, stony minerality, and a lightning bolt of acidity that keeps you coming back for more. This Greek white is as crisp and invigorating as a sea breeze, perfect for those who crave both intensity and elegance in their glass.",
        },
        "color": "white",
        "regions": ["Santorini", "Cyclades", "Macedonia (Greece)", "Attica", "Crete"],
        "flavor_profile": ["citrus", "lemon", "mineral", "stone_fruit", "earth"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "unoaked",
            "oaked",
            "premium",
            "age_worthy",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Asuretuli Shavi",
        "synonyms": ["Asuretuli", "Schalltraube", "Shadi Traube", "Shala"],
        "description": {
            "default": "Minor Georgian variety once popular with German colonists.",
            "julie": "",
            "sommelier": "Asuretuli Shavi is a charming Georgian black grape that weaves together red and black fruit, earthy minerals, and a whisper of cherry-plum, all in a medium-bodied, approachable style. Once beloved by German settlers, this grape is a delightful nod to history and a perfect companion for early-drinking red wines.",
        },
        "color": "black",
        "regions": ["Georgia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Athiri",
        "synonyms": [
            "Asprathiri",
            "Asprathiro",
            "Athiri Aspro",
            "Athiri Lefko",
            "Athiri Leyko",
        ],
        "description": {
            "default": "An old, easy-to-grow Greek variety producing soft, dry, fruity whites.",
            "julie": "",
            "sommelier": "Athiri is the sun-drenched soul of the Aegean, offering a breezy bouquet of citrus and stone fruit with a whisper of wildflowers—perfect for sipping seaside or at a lively Greek table. Light-bodied and effortlessly charming, this ancient grape is your passport to the easygoing pleasures of island life.",
        },
        "color": "white",
        "regions": ["Greece", "Rhodes", "Santorini", "Aegean Islands"],
        "flavor_profile": ["citrus", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Aubin Blanc",
        "synonyms": [
            "Albin Blanc",
            "Aubain",
            "Aubier",
            "Aubin",
            "Blanc de Creuë",
            "Blanc de Magny",
            "Gros Vert de Crenay",
        ],
        "description": {
            "default": "Virtually extinct Lorraine speciality.",
            "julie": "",
            "sommelier": "Aubin Blanc is a ghostly gem from Lorraine, offering a zesty medley of citrus and apple with a whisper of floral and mineral elegance—think of it as a crisp, refreshing echo from France’s viticultural past. Light-bodied and lively, it’s a rare treat for those who seek the thrill of the nearly forgotten.",
        },
        "color": "white",
        "regions": ["Lorraine"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Aubin Vert",
        "synonyms": ["Blanc d’Euvézin", "Vert Blanc"],
        "description": {
            "default": "Virtually extinct Lorraine variety.",
            "julie": "",
            "sommelier": "Aubin Vert is a ghostly gem from Lorraine, offering a lively dance of citrus, apple, and pear atop a mineral backbone—think of it as a spring breeze in a glass, perfect for those who crave crisp, unoaked whites with a whisper of floral intrigue.",
        },
        "color": "white",
        "regions": ["Lorraine", "France"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Aubun",
        "synonyms": [
            "Carignan de Bédoin",
            "Carignan de Gigondas",
            "Grosse Rogettaz",
            "Morescola",
            "Murescola",
            "Moustardier",
            "Moutardier",
        ],
        "description": {
            "default": "Minor blending component from the southern Rhône.",
            "julie": "",
            "sommelier": "Aubun is the unsung hero of the southern Rhône, lending its rustic charm and a medley of red and black fruits, spice, and earthy notes to traditional blends—perfect for those who appreciate a medium-bodied, approachable red with a touch of old-world intrigue.",
        },
        "color": "black",
        "regions": ["Southern Rhône", "Provence", "Languedoc"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Aurore",
        "synonyms": ["Aurora", "Feri Szölö", "Financ Szölö", "Redei", "Seibel 5279"],
        "description": {
            "default": "Complex hybrid more successful in North America than in its homeland France.",
            "julie": "",
            "sommelier": "Aurore is the zesty, globe-trotting hybrid that brings a bouquet of citrus, stone fruit, and wildflowers to your glass, all wrapped in a crisp, high-acid frame. Perfect for those who crave a lively, early-drinking white with a whisper of French flair and a North American heart.",
        },
        "color": "grey",
        "regions": [
            "United States (Northeast)",
            "Canada (Ontario, Quebec)",
            "France (Loire, experimental plantings)",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "herbal",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Auxerrois",
        "synonyms": [
            "Aucerot",
            "Auxera",
            "Auxerrois de Laquenexy",
            "Auxois",
            "Auzerrois Blanc",
            "Blanc de Kienzheim",
            "Ericey de la Montée",
            "Kleiner Heunisch",
            "Okseroa",
            "Pinot Auxerrois",
            "Riesling Jaune de la Moselle",
        ],
        "description": {
            "default": "Low-acid variety useful in cool climates.",
            "julie": "",
            "sommelier": "Auxerrois is the quiet charmer of the white wine world, offering a soft embrace of orchard fruits and delicate florals, all wrapped in a gentle, low-acid package—think of it as Pinot Blanc’s easygoing cousin, perfect for sipping on a spring afternoon.",
        },
        "color": "white",
        "regions": [
            "Alsace",
            "Luxembourg",
            "Moselle (Germany)",
            "Baden (Germany)",
            "Oregon (USA)",
        ],
        "flavor_profile": ["apple", "pear", "peach", "floral", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Avanà",
        "synonyms": [
            "Avenà",
            "Avenai",
            "Avanale",
            "Avanas",
            "Avanato",
            "Avanè",
            "Hibou Noir",
            "Vermaglio",
        ],
        "description": {
            "default": "Light, early-drinking Piemontese red, rarely made as a varietal.",
            "julie": "",
            "sommelier": "Avanà is Piedmont’s charming secret: a featherweight red brimming with cherry and raspberry, kissed by wild herbs and flowers, perfect for those who crave a lively, unoaked sip that dances on the palate. Rarely seen solo, this grape is a delightful, early-drinking companion for any table.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Avarengo",
        "synonyms": [
            "Amarene",
            "Avarenc",
            "Avarena",
            "Mustèr",
            "Riondosca",
            "Riundasca",
        ],
        "description": {
            "default": "Low-yielding, perfumed Piemontese red.",
            "julie": "",
            "sommelier": "Avarengo is Piedmont’s aromatic secret, delivering a lively medley of cherry, raspberry, and spice wrapped in a floral, earthy embrace—perfect for those who crave a zesty, medium-bodied red with a dash of Italian tradition.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "earth",
            "cherry",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Avasirkhva",
        "synonyms": ["Ajiche", "Ajishi", "Auasirkhva", "Avasarkhva", "Avassirkhva"],
        "description": {
            "default": "Rare Georgian variety grown in Apkhazeti.",
            "julie": "",
            "sommelier": "Avasirkhva is a zesty Georgian gem, bursting with citrus and stone fruit, kissed by floral and mineral notes—think of it as a mountain spring in a glass, perfect for those who crave a crisp, lively white with a story to tell.",
        },
        "color": "white",
        "regions": ["Georgia", "Apkhazeti"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Avesso",
        "synonyms": ["Bornal", "Bornão", "Borral"],
        "description": {
            "default": "Portuguese variety with more body than others making Vinho Verde.",
            "julie": "",
            "sommelier": "Avesso is the Vinho Verde rebel, delivering a zesty punch of lemon, pear, and peach with a surprising richness and mineral backbone—think of it as the white grape that brings both freshness and a little swagger to your glass. Perfect for those who crave a lively, aromatic white with a bit more heft than the usual suspects.",
        },
        "color": "white",
        "regions": ["Portugal", "Vinho Verde"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "pear",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "full_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Avgoustiatis",
        "synonyms": ["Avgoustella", "Agoustiates"],
        "description": {
            "default": "Minor Greek variety found mainly on the island of Zákynthos and in the western Pelopónnisos (Peloponnese).",
            "julie": "",
            "sommelier": "Avgoustiatis is a charming Greek rarity, offering a vibrant medley of red and black fruits laced with herbal and spicy undertones—think of it as the Mediterranean in a glass, perfect for those who crave a medium-bodied, easy-drinking red with a touch of island intrigue.",
        },
        "color": "black",
        "regions": ["Zákynthos", "Western Peloponnese", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Azal",
        "synonyms": [
            "Asal",
            "Azal Branco",
            "Asal da Lixa",
            "Azal da Lixa",
            "Carvalha",
            "Carvalhal",
            "Gadelhudo",
            "Pinheira",
        ],
        "description": {
            "default": "High-acid variety losing ground but still widespread in northern Portugal.",
            "julie": "",
            "sommelier": "Azal is the zippy secret of northern Portugal, delivering a lively burst of citrus, apple, and mineral notes in every glass—think of it as Vinho Verde’s crisp, floral whisper on a summer breeze. Light-bodied and low in alcohol, it’s the ultimate refresher for those who love their whites bright and bracing.",
        },
        "color": "white",
        "regions": ["Vinho Verde", "Minho", "Northern Portugal"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Băbească Neagră",
        "synonyms": [
            "Asîl Kara",
            "Băbească",
            "Căldăruşă",
            "Chernyi Redkii",
            "Crăcană",
            "Crăcănată",
            "Poama Rară Neagră",
            "Rarăneagră",
            "Rară Neagră",
            "Răşchirată",
            "Rastriopa",
            "Serecsia Ciornaia",
            "Sereksia",
            "Sereksiya",
        ],
        "description": {
            "default": "High-acid Romanian variety producing fairy light reds.",
            "julie": "",
            "sommelier": "Băbească Neagră is Romania’s answer to a featherweight champion—delivering a lively burst of cherry and raspberry, a whisper of flowers, and a refreshing zip of acidity, all wrapped in a delightfully light frame. This is the wine to reach for when you want something playful, easy-drinking, and full of old-world charm.",
        },
        "color": "black",
        "regions": ["Romania", "Moldova"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "earth"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Very light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Babić",
        "synonyms": ["Babić Crni", "Rogoznička"],
        "description": {
            "default": "Lively and potentially high-quality Croatian variety well suited to barrel ageing.",
            "julie": "",
            "sommelier": "Babić is Croatia’s brooding black pearl, delivering a full-bodied embrace of plum, blackberry, and earthy spice, all wrapped in a mineral cloak and polished by oak. This Dalmatian classic is a sommelier’s delight—age-worthy, complex, and as lively as the Adriatic coast itself.",
        },
        "color": "black",
        "regions": ["Croatia", "Dalmatia", "Šibenik", "Primošten"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "mineral",
            "oak",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "age_worthy",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Babica",
        "synonyms": ["Kaštelanka"],
        "description": {
            "default": "Rare variety from Croatia’s Adriatic coast.",
            "julie": "",
            "sommelier": "Babica, the Adriatic’s hidden treasure, delivers a harmonious dance of plum, cherry, and earthy minerality in every sip—think of it as Dalmatia’s soulful answer to a classic, medium-bodied red. Perfect for those seeking a taste of Croatia’s coastal charm in a glass.",
        },
        "color": "black",
        "regions": ["Croatia", "Dalmatia", "Adriatic Coast"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Bacchus",
        "synonyms": ["Bacchus Weiss", "Geilweilerhof 33-29-133"],
        "description": {
            "default": "One of the most important German crosses producing highly aromatic whites, not least in England.",
            "julie": "",
            "sommelier": "Bacchus is the zesty life of the party, bursting with citrus, stone fruit, and tropical flair, all wrapped in a bouquet of florals and herbs—think of it as Sauvignon Blanc’s exuberant cousin, perfect for a refreshing glass on a sunny afternoon.",
        },
        "color": "white",
        "regions": ["Germany", "England"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "floral",
            "herbal",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Bachet Noir",
        "synonyms": ["Bachey", "François Noir", "Gris Bachet"],
        "description": {
            "default": "Ancient and almost extinct.",
            "julie": "",
            "sommelier": "Bachet Noir is a vinous relic, offering a tapestry of red and black fruits laced with earthy, mineral undertones—think of it as Burgundy’s secret handshake to those who seek the rare and the remarkable. Medium in every measure but rich in history, this nearly extinct grape is a true sommelier’s treasure.",
        },
        "color": "black",
        "regions": ["France", "Burgundy", "Champagne"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "traditional",
            "blend",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Baco Blanc",
        "synonyms": ["Baco 22 A", "Maurice Baco", "Piquepoul du Gers"],
        "description": {
            "default": "Light-skinned French hybrid still allowed in Armagnac but declining.",
            "julie": "",
            "sommelier": "Baco Blanc is the unsung hero of Armagnac, delivering zesty citrus and crisp apple flavors with a whisper of wildflowers and a stony finish. Light on its feet and refreshingly unoaked, this grape is a charming throwback to classic French country whites.",
        },
        "color": "white",
        "regions": ["Southwest France", "Gers", "Armagnac"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Baco Noir",
        "synonyms": ["Baco 1", "Baco 24-23", "Bacoi", "Bago", "Bako Speiskii", "Bakon"],
        "description": {
            "default": "Dark-skinned French hybrid faring better across the Atlantic than at home.",
            "julie": "",
            "sommelier": "Baco Noir is the plucky French hybrid that crossed the Atlantic and never looked back, delivering juicy waves of cherry, plum, and blackberry wrapped in a smoky, spicy embrace. With its lively acidity and medium body, this grape crafts reds that are as spirited and inviting as a campfire singalong in the cool North American night.",
        },
        "color": "black",
        "regions": ["Ontario", "New York", "Oregon", "British Columbia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "raspberry",
            "earth",
            "smoke",
            "spice",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "unoaked",
            "oaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Baga",
        "synonyms": [
            "Baga de Louro",
            "Carrasquenho",
            "Carrego Burros",
            "Poeirinho",
            "Tinta Bairrada",
            "Tinta da Bairrada",
            "Tinta de Baga",
        ],
        "description": {
            "default": "Controversial, demanding northern Portuguese variety capable of making great, ageworthy wines.",
            "julie": "",
            "sommelier": "Baga is Portugal’s enigmatic black grape, notorious for its high acidity and tannin, but beloved for crafting deeply complex, ageworthy reds bursting with cherry, plum, and smoky earth. In the right hands, Baga transforms from a winemaker’s challenge into a connoisseur’s delight—think brooding fruit, leather, and spice, all wrapped in a structure built to last.",
        },
        "color": "black",
        "regions": ["Bairrada", "Dão", "Beira Atlântico", "Lisboa", "Portugal"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "earth",
            "mineral",
            "leather",
            "smoke",
            "spice",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Bagrina",
        "synonyms": [
            "Bagrina Crvena",
            "Bagrina Krajinska",
            "Bagrina Rošie",
            "Braghina",
            "Braghină",
            "Braghină de Drăgășani",
            "Bragina",
            "Bragina Rara",
        ],
        "description": {
            "default": "Pink-skinned Balkan variety making fresh and ageworthy whites.",
            "julie": "",
            "sommelier": "Bagrina is the Balkan beauty that turns pink skin into white wine magic—zesty citrus and stone fruit dance with floral and mineral notes, all wrapped in a crisp, ageworthy package that’s as charming as a Drăgășani sunset.",
        },
        "color": "pink",
        "regions": ["Serbia", "Romania", "Balkans", "Drăgășani"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Balzac Blanc",
        "synonyms": [
            "Balzard Blanc",
            "Balzat",
            "Blanc Limousin",
            "Margnac Blanc",
            "Ressière",
        ],
        "description": {
            "default": "Almost extinct variety from Cognac country.",
            "julie": "",
            "sommelier": "Balzac Blanc is a ghostly gem from Cognac, offering a lively dance of citrus, apple, and floral notes over a racy mineral backbone—think of it as the Loire’s sprightly cousin, perfect for those who crave a crisp, unoaked white with a whisper of history in every sip.",
        },
        "color": "white",
        "regions": ["Cognac", "Southwest France"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "traditional",
            "table_wine",
            "varietal",
        ],
    },
    {
        "name": "Baratuciat",
        "synonyms": ["Bertacuciàt"],
        "description": {
            "default": "Rare but recovered Piemontese white that tastes a bit like Sauvignon Blanc.",
            "julie": "",
            "sommelier": "Baratuciat is Piedmont’s hidden white gem, bursting with zesty citrus, fresh herbs, and a mineral snap that rivals the best Sauvignon Blancs—think of it as Italy’s answer to a summer breeze in a glass. Light-bodied and lively, this rare varietal is a must-try for those seeking something refreshingly off the beaten path.",
        },
        "color": "white",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["citrus", "herbal", "floral", "mineral", "lemon", "apple"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "modern",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Barbaroux",
        "synonyms": ["Barbarons", "Grec Rose", "Roussée"],
        "description": {
            "default": "Almost extinct, relatively undistinguished pink-skinned Provençal variety.",
            "julie": "",
            "sommelier": "Barbaroux is Provence’s elusive pink pearl, yielding feather-light, floral rosés with a whisper of red fruit and a breezy, low-alcohol finish—perfect for those who seek the thrill of the nearly extinct in their glass.",
        },
        "color": "pink",
        "regions": ["Provence", "France"],
        "flavor_profile": ["red_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Barbera",
        "synonyms": [
            "Barbera a Peduncolo Rosso",
            "Barbera a Raspo Verde",
            "Barbera Amaro",
            "Barbera d’Asti",
            "Barbera Dolce",
            "Barbera Fina",
            "Barbera Grossa",
            "Barbera Nera",
            "Barbera Nostrana",
            "Barbera Vera",
            "Barberone",
            "Gaietto",
            "Lombardesca",
            "Sciaa",
        ],
        "description": {
            "default": "With origins still unknown, this versatile variety makes crisp, sweet Italian reds in a wide range of styles and locations.",
            "julie": "Barbera is the most planted red grape varitety in the region of Piemonte, Italy. Barbera wines are deeply coloured, high in acidity, plump and with soft tannins. Famous DOC for production include Barbera d'Asti DOCG, Nizza DOCG and Barbera del Monferrato Superiore DOCG. ",
            "sommelier": "Barbera is Piemonte’s juicy, high-acid charmer, delivering a cascade of cherry and plum flavors with a spicy, earthy twist and a plush, velvety finish. Whether sipped young or aged, it’s the Italian red that brings both vibrancy and versatility to the table.",
        },
        "color": "black",
        "regions": [
            "Piemonte",
            "Asti",
            "Monferrato",
            "Nizza",
            "Lombardy",
            "Emilia-Romagna",
            "California",
            "Argentina",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "unoaked",
            "oaked",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "early_drinking",
        ],
    },
    {
        "name": "Barbera Bianca",
        "synonyms": ["Bertolino", "Peisìn"],
        "description": {
            "default": "Rare Piemontese variety unrelated to dark-skinned Barbera.",
            "julie": "",
            "sommelier": "Barbera Bianca is Piedmont’s hidden white gem, delivering zesty citrus and stone fruit flavors with a floral lift and a crisp, mineral finish—think of it as the vivacious, lighter cousin to the region’s famous reds, perfect for early drinking and lively conversation.",
        },
        "color": "white",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Barbera Del Sannio",
        "synonyms": ["Barbetta"],
        "description": {
            "default": "Increasingly well-made central Italian variety unrelated to more northerly Barberas.",
            "julie": "",
            "sommelier": "Barbera Del Sannio is Campania’s vivacious answer to the north’s Barbera, bursting with cherry, plum, and a dash of earthy spice. With zesty acidity and a medium frame, it’s a spirited companion for lively gatherings and rustic Italian fare.",
        },
        "color": "black",
        "regions": ["Campania", "Sannio", "Central Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "table_wine",
            "traditional",
            "modern",
            "early_drinking",
        ],
    },
    {
        "name": "Barcelo",
        "synonyms": ["Barcello", "Barcelos"],
        "description": {
            "default": "Minor Portuguese found in white Dão blends.",
            "julie": "",
            "sommelier": "Barcelo is the unsung hero of Dão’s white blends, offering a delicate medley of citrus, stone fruit, and floral notes with a whisper of minerality—think of it as Portugal’s refreshing answer to a summer breeze in a glass.",
        },
        "color": "white",
        "regions": ["Portugal", "Dão"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bariadorgia",
        "synonyms": [
            "Bariadorgia Bianca",
            "Bariadorza",
            "Barria Dorgia",
            "Barriadorgia",
            "Carcaghjolu Biancu",
            "Carcajola",
            "Carcajola Bianco",
            "Carcajolo Blanc",
            "Gregu Bianco",
        ],
        "description": {
            "default": "Virtually extinct Sardinian white, surviving on the French island of Corse as Carcajolo Blanc.",
            "julie": "",
            "sommelier": "Bariadorgia is a Sardinian-Corsican white grape treasure, offering zesty citrus and stone fruit flavors with a floral, mineral edge—think of it as a sun-kissed island breeze in a glass, perfect for those who crave the thrill of rare finds.",
        },
        "color": "white",
        "regions": ["Sardinia", "Corsica"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Baroque",
        "synonyms": [
            "Baroca",
            "Barroque",
            "Bordalès",
            "Bordelais Blanc",
            "Bordeleza zuria",
        ],
        "description": {
            "default": "South-west French variety given an injection of life from a renowned local chef.",
            "julie": "",
            "sommelier": "Baroque is the vivacious white grape of Southwest France, bursting with zesty citrus, stone fruit, and a whisper of spice, all wrapped in a mineral embrace—think of it as Gascony’s answer to a lively soirée, recently revived by a chef’s creative touch. With high acidity and a medium body, it dances effortlessly between tradition and innovation in both classic and modern wines.",
        },
        "color": "white",
        "regions": ["Southwest France", "Tursan", "Gascony"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "spice",
            "earth",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Barsaglina",
        "synonyms": ["Barsullina", "Bersaglina", "Massareta", "Massaretta"],
        "description": {
            "default": "Deeply coloured Tuscan red that has all but disappeared.",
            "julie": "",
            "sommelier": "Once nearly lost to time, Barsaglina is Tuscany’s inky treasure—bursting with black fruit, plum, and earthy spice, this full-bodied red delivers a bold, tannic embrace that’s as rare as it is unforgettable.",
        },
        "color": "black",
        "regions": ["Tuscany", "Italy"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Bastardo Magarachsky",
        "synonyms": [
            "Bastard de Magaraci",
            "Bastardo Magarach",
            "Magaratch 217",
            "Magarach Bastardo",
        ],
        "description": {
            "default": "Versatile Ukrainian cross.",
            "julie": "",
            "sommelier": "Bastardo Magarachsky is Ukraine’s enigmatic black grape, weaving together red and black fruits, earthy spice, and a whisper of plum and cherry into a harmonious, medium-bodied tapestry—perfect for both traditional and modern wine lovers seeking a taste of Crimean intrigue.",
        },
        "color": "black",
        "regions": ["Ukraine", "Crimea", "Russia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Batiki",
        "synonyms": [
            "Bantiki",
            "Dembatiki",
            "Deve Baliki",
            "Dimbatiki",
            "Dimi Batiki",
            "Timbi Batiki",
        ],
        "description": {
            "default": "Variety grown mainly in central Greece making soft whites for blending, retsina and the table.",
            "julie": "",
            "sommelier": "Batiki is the charming underdog of central Greece, offering a breezy bouquet of citrus and stone fruit with a whisper of florals—perfect for those seeking a light, refreshing white or a taste of classic retsina. Its gentle acidity and low alcohol make it a delightful companion for sunny afternoons and lively Greek feasts.",
        },
        "color": "white",
        "regions": ["Central Greece", "Thessaly", "Boeotia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "unoaked",
            "table_wine",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Batoca",
        "synonyms": [
            "Alvadurao Portalegre",
            "Alvaraça",
            "Alvarça",
            "Alvaroça",
            "Alvaroco",
            "Asal Espanhol",
            "Batoco",
            "Blanca Mar",
            "Espadeiro Branco",
            "Sedouro .",
        ],
        "description": {
            "default": "Minor, unexceptional white from Vinho Verde country.",
            "julie": "",
            "sommelier": "Batoca is the unsung hero of Vinho Verde, delivering a crisp, citrusy punch with a whisper of apple and stony minerality—think of it as the lively supporting act that keeps the party going, best enjoyed young and chilled on a sunny afternoon.",
        },
        "color": "white",
        "regions": ["Vinho Verde", "Minho", "Portugal"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Bayanshira",
        "synonyms": [
            "Ag Shirei",
            "Ag Üzüm",
            "Bahïan Chireï",
            "Bajac Shirei",
            "Banants",
            "Bayan Shirei",
            "Bayan Shirey",
            "Bayanshire",
            "Shirei",
            "Spitak Khagog",
        ],
        "description": {
            "default": "Lacklustre Azeri variety with high acidity and generally low alcohol.",
            "julie": "",
            "sommelier": "Bayanshira is Azerbaijan’s zesty answer to a summer thirst, delivering a crisp, citrusy punch with whispers of apple and pear, all wrapped in a feather-light frame. Perfect for those who crave refreshment over richness, this grape is a lively companion for light fare and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Azerbaijan"],
        "flavor_profile": ["citrus", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "varietal",
            "blend",
            "early_drinking",
        ],
    },
    {
        "name": "Beaunoir",
        "synonyms": [
            "Beaunoire",
            "Cep Gris",
            "Mourillon",
            "Pinot d’Aï",
            "Pinot d’Ailly",
            "Pinot d’Orléans",
            "Sogris",
        ],
        "description": {
            "default": "Virtually extinct black-skinned variety with one illustrious and one promiscuous parent.",
            "julie": "",
            "sommelier": "Beaunoir is a rare gem from Burgundy and the Loire, offering a delicate dance of cherry, raspberry, and earthy notes in a light, easy-drinking frame—think of it as Pinot Noir’s elusive, flirtatious cousin who left the party too soon. Sip it for a taste of French wine history nearly lost to time.",
        },
        "color": "black",
        "regions": ["Burgundy", "Loire Valley", "France"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Beba",
        "synonyms": [
            "Beba de los Santos",
            "Beba Dorada de Jerez",
            "Blanca de Mesa",
            "Blanca Superior Parral",
            "Boal de Praça",
            "Breval",
            "Calop Blanco",
            "Eva",
            "Malvoisie de la Chartreuse",
            "Malvoisie des Chartreux",
            "Teta de Vaca",
            "Uva de Planta",
            "Valencí Blanco",
        ],
        "description": {
            "default": "Andalusian variety grown mainly in Extremadura today.",
            "julie": "",
            "sommelier": "Beba is a charming Andalusian white grape that dazzles with zesty citrus, juicy pear, and delicate floral notes, all wrapped in a light, refreshing body—perfect for sipping on a sun-drenched Spanish afternoon. Its unoaked, early-drinking style makes it a delightful companion for tapas and lively conversation.",
        },
        "color": "white",
        "regions": ["Extremadura", "Andalusia", "Spain"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "pear",
            "peach",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Béclan",
        "synonyms": [
            "Baclan",
            "Baclans",
            "Becclan",
            "Petit Béclan",
            "Petit Dureau",
            "Petit Margillin",
            "Roussette Noire",
            "Saunoir",
        ],
        "description": {
            "default": "Virtually extinct Jura vine.",
            "julie": "",
            "sommelier": "Béclan is a ghostly gem from the Jura, offering a whisper of red and black fruits laced with earthy, mineral notes in a light, low-alcohol frame—perfect for those who crave a sip of nearly forgotten French tradition.",
        },
        "color": "black",
        "regions": ["Jura"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": ["red", "light_bodied", "traditional", "blend", "table_wine"],
    },
    {
        "name": "Beichun",
        "synonyms": ["Bei Chun"],
        "description": {
            "default": "Winter-hardy Chinese hybrid.",
            "julie": "",
            "sommelier": "Beichun is the resilient northern star of Chinese viticulture, offering a harmonious medley of red and black fruits laced with herbal intrigue. Perfect for early drinking, this medium-bodied charmer brings a fresh, lively spirit to the glass—proof that great wine can thrive even in the coldest corners.",
        },
        "color": "black",
        "regions": ["China", "Northern China", "Heilongjiang", "Jilin", "Liaoning"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "vegetal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "varietal", "table_wine", "early_drinking"],
    },
    {
        "name": "Bekari",
        "synonyms": ["Bekaro", "Mbekari Mavro", "Mpekari Mavro", "Mbekaro", "Mpekaro"],
        "description": {
            "default": "Minor variety local to Ípeiros (Epirus) in western Greece.",
            "julie": "",
            "sommelier": "Bekari is Epirus’s hidden gem, offering a harmonious medley of red and black fruits laced with wild herbs and a whisper of earth, all wrapped in a medium-bodied, easy-drinking style—perfect for those seeking a taste of Greece’s untamed terroir.",
        },
        "color": "black",
        "regions": ["Epirus", "Ípeiros", "Western Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "table_wine",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Bellone",
        "synonyms": ["Arciprete Bianco", "Cacchione", "Fagotto and many more"],
        "description": {
            "default": "Vigorous Roman white that rarely appears solo.",
            "julie": "",
            "sommelier": "Bellone, the Roman white grape with a storied past, dazzles with zesty citrus and stone fruit flavors, underscored by a mineral streak and floral lift. Often the unsung hero in blends, it brings a lively, refreshing character to the table—perfect for early drinking and la dolce vita moments.",
        },
        "color": "white",
        "regions": ["Lazio", "Italy", "Rome"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "unoaked",
            "medium_bodied",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Béquignol Noir",
        "synonyms": [
            "Béquin Rouge",
            "Breton",
            "Chalosse Noire",
            "Embalouzat",
            "Mançais Noir",
        ],
        "description": {
            "default": "Rare dark-skinned French variety much more common in Argentina.",
            "julie": "",
            "sommelier": "Béquignol Noir is a globe-trotting French rarity that found its true home in Argentina, offering a charming medley of red and black fruits, spice, and earthy notes. With its medium body and balanced structure, this grape crafts wines that are as versatile as they are intriguing—perfect for early drinking or blending adventures.",
        },
        "color": "black",
        "regions": ["Argentina", "Southwest France"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "table_wine",
            "medium_bodied",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Berdomenel",
        "synonyms": ["Berdanel"],
        "description": {
            "default": "Virtually extinct Ariège variety recently replanted.",
            "julie": "",
            "sommelier": "Berdomenel, the elusive white gem of Ariège, enchants with zesty citrus, crisp apple, and a whisper of wildflowers over a stony backbone—an elegant revival of Southwest France’s vinous heritage. Light on its feet yet brimming with character, this nearly forgotten grape is a true sommelier’s secret.",
        },
        "color": "white",
        "regions": ["Ariège", "Southwest France"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Besgano Bianco",
        "synonyms": ["Colombana Bianca"],
        "description": {
            "default": "Very rare northern Italian white once used to produce Vin Santo.",
            "julie": "",
            "sommelier": "Besgano Bianco is a hidden gem of northern Italy, offering a decadent medley of honeyed dried fruits, toasted nuts, and floral notes, all wrapped in a full-bodied, high-acid embrace—an opulent throwback to the golden age of Vin Santo.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Lombardy", "Tuscany"],
        "flavor_profile": ["dried_fruit", "honey", "nuts", "floral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "age_worthy",
            "traditional",
            "varietal",
            "premium",
        ],
    },
    {
        "name": "Bianca",
        "synonyms": ["Bianka", "Ec 40", "Ecs 40", "Egri Csillagok 40", "May Rot"],
        "description": {
            "default": "Hungarian hybrid producing generally unexciting wines, also in Russia.",
            "julie": "",
            "sommelier": "Bianca is Hungary’s easygoing white grape, offering a breezy bouquet of citrus, apple, and delicate florals in a light, unoaked style—perfect for those seeking a crisp, uncomplicated sip. While it may not steal the spotlight, Bianca’s charm lies in its refreshing simplicity and everyday drinkability.",
        },
        "color": "white",
        "regions": ["Hungary", "Russia"],
        "flavor_profile": ["citrus", "apple", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Bianchetta Trevigiana",
        "synonyms": [
            "Bianca Gentile di Fonzaso",
            "Bianchetta Gentile",
            "Bianchetta Semplice",
            "Senese",
            "Vernanzina",
            "Vernassina",
        ],
        "description": {
            "default": "Vigorous, thick-skinned northern Italian white producing rather ordinary, slightly astringent wines that are generally blended.",
            "julie": "",
            "sommelier": "Bianchetta Trevigiana is the unsung hero of northern Italy, lending zesty citrus and crisp apple notes to blends, with a whisper of minerality and a refreshing, light-bodied charm—perfect for easy, early sipping.",
        },
        "color": "white",
        "regions": ["Veneto", "Trentino", "Northern Italy"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bianco D’Alessano",
        "synonyms": [
            "Acchiappapalmento",
            "Bianco di Lessame",
            "Iuvarello",
            "Verdurino",
            "Vuiono",
        ],
        "description": {
            "default": "Southern Italian white frequently blended with Verdeca, enjoying success in Australia.",
            "julie": "",
            "sommelier": "Bianco D’Alessano is a zesty Southern Italian charmer, bursting with citrus and stone fruit, laced with floral and herbal notes, and finishing with a mineral snap—think of it as a Mediterranean breeze in a glass, perfect for early sipping and lively conversation.",
        },
        "color": "white",
        "regions": ["Puglia", "Southern Italy", "South Australia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "varietal",
            "light_bodied",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Biancolella",
        "synonyms": ["Bianculillo", "Jancolella", "San Nicola"],
        "description": {
            "default": "Light white grape from Napoli and the neighbouring islands inspires some heroic production.",
            "julie": "",
            "sommelier": "Biancolella is Campania’s breezy island gem, delivering a zesty medley of citrus, pear, and wildflowers with a crisp, mineral finish—think of it as a seaside picnic in a glass, perfect for those who crave freshness and a touch of Italian sunshine.",
        },
        "color": "white",
        "regions": ["Campania", "Ischia", "Napoli", "Capri"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Biancone Di Portoferraio",
        "synonyms": ["Biancone", "Pagadebiti di Porto S. Stefano"],
        "description": {
            "default": "Ordinary white exclusive to Elba.",
            "julie": "",
            "sommelier": "Biancone Di Portoferraio is Elba’s crisp, citrus-kissed secret—think zesty apples and seaside minerals in a glass, perfect for sun-drenched afternoons. This light, unoaked white is a charming island escape for your palate, best enjoyed young and carefree.",
        },
        "color": "white",
        "regions": ["Elba", "Tuscany", "Italy"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Biancu Gentile",
        "synonyms": ["Biancone Gentile"],
        "description": {
            "default": "Rare, aromatic Corsican.",
            "julie": "",
            "sommelier": "Biancu Gentile is Corsica’s aromatic treasure, weaving together delicate florals, sun-kissed stone fruit, and a whisper of herbs over a mineral backbone. This rare white grape delivers a medium-bodied, lively sip that’s as enchanting as a Mediterranean breeze—perfect for those who crave both elegance and adventure in their glass.",
        },
        "color": "white",
        "regions": ["Corsica"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "herbal", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bíborkadarka",
        "synonyms": ["Bíbor Kadarka", "Biborkadarsa", "Cs 4"],
        "description": {
            "default": "Minor red-fleshed Hungarian cross used mainly for colour.",
            "julie": "",
            "sommelier": "Bíborkadarka is Hungary’s secret splash of color, delivering a playful medley of cherry, plum, and raspberry in a light, juicy frame—perfect for those who like their reds bright, breezy, and ready to party.",
        },
        "color": "black",
        "regions": ["Hungary"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum", "raspberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "light_bodied", "table_wine", "early_drinking"],
    },
    {
        "name": "Bical",
        "synonyms": [
            "Arinto de Alcobaça",
            "Bical de Bairrada",
            "Borrado das Moscas",
            "Fernão Pires Galego",
            "Pintado das Moscas",
            "Pintado dos Pardais",
        ],
        "description": {
            "default": "Aromatic, early-ripening variety widely planted in western central Portugal.",
            "julie": "",
            "sommelier": "Bical is Portugal’s zesty white gem, bursting with citrus and stone fruit, and a whisper of wildflowers, all wrapped in a racy, mineral-driven frame. Whether sparkling or still, this high-acid, light-bodied charmer is as refreshing as a sea breeze and as versatile as a sommelier’s smile.",
        },
        "color": "white",
        "regions": ["Portugal", "Bairrada", "Dão", "Beira Atlântico"],
        "flavor_profile": [
            "citrus",
            "lemon",
            "stone_fruit",
            "peach",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Bigolona",
        "synonyms": [
            "Bigolara",
            "Bigolona Bianca",
            "Bigolona Veronese",
            "Sampagna",
            "Smarzirola",
        ],
        "description": {
            "default": "Rare white from the Valpolicella region of northern Italy used in sweet-wine blends.",
            "julie": "",
            "sommelier": "Bigolona is Valpolicella’s hidden gem, weaving together honeyed stone fruit, dried apricot, and delicate florals into a full-bodied, velvety white that shines in decadent dessert blends. This rare grape is a sweet serenade from the Veneto, perfect for those who crave a taste of Italian tradition with a touch of opulence.",
        },
        "color": "white",
        "regions": ["Valpolicella", "Veneto", "Northern Italy"],
        "flavor_profile": [
            "stone_fruit",
            "dried_fruit",
            "floral",
            "honey",
            "apple",
            "pear",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["white", "dessert", "blend", "traditional"],
    },
    {
        "name": "Birstaler Muskat",
        "synonyms": ["Birchstaler Muscat", "Muscat de la Birse", "VB 86-6"],
        "description": {
            "default": "Light-skinned Swiss hybrid used mainly for the table.",
            "julie": "",
            "sommelier": "Birstaler Muskat is Switzerland’s aromatic charmer, bursting with floral perfume and a medley of stone fruit, citrus, and tropical notes—think of it as a summer picnic in a glass, perfect for easy, early sipping. With its light body and gentle acidity, this grape is a delightful companion for those seeking a fresh, unoaked white that dances on the palate.",
        },
        "color": "white",
        "regions": ["Switzerland"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "tropical_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Black Queen",
        "synonyms": ["Pokdum", "Pok Dum"],
        "description": {
            "default": "Japanese complex hybrid widely used for winemaking in Asia.",
            "julie": "",
            "sommelier": "Black Queen is Asia’s enigmatic answer to light-bodied reds, offering a charming medley of red and black fruits, delicate florals, and a whisper of herbs—perfect for those seeking a refreshing, early-drinking wine with a touch of exotic flair.",
        },
        "color": "black",
        "regions": ["Japan", "Thailand", "China", "South Korea"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Blanc Dame",
        "synonyms": [
            "Blanc Madame",
            "Blanquette Grise",
            "Clairette de Gascogne",
            "Claret",
            "Claret de Gascogne",
            "Plan de Dame",
        ],
        "description": {
            "default": "Almost abandoned by south-west French vignerons but not quite by armagnac distillers.",
            "julie": "",
            "sommelier": "Blanc Dame is the elusive belle of Southwest France, offering a zesty medley of citrus and stone fruit with a floral lift and mineral backbone—think of it as the secret ingredient in both crisp summer sips and the soul of Armagnac. Light on its feet and high in acidity, this grape is a charming relic that rewards the adventurous palate.",
        },
        "color": "white",
        "regions": ["Southwest France", "Gascogne", "Armagnac"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "blend",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Blanc Du Bois",
        "synonyms": ["Blanc DuBois", "Florida H18-37"],
        "description": {
            "default": "Potentially high-quality, aromatic hybrid from Florida with useful resistance to Pierce’s disease.",
            "julie": "",
            "sommelier": "Blanc Du Bois dazzles with zesty citrus and lush tropical fruit, delivering a lively, floral white wine that’s as refreshing as a Gulf Coast breeze—perfect for sipping on a sultry Southern afternoon.",
        },
        "color": "white",
        "regions": ["Florida", "Texas", "Louisiana", "Georgia", "Mississippi"],
        "flavor_profile": ["citrus", "stone_fruit", "tropical_fruit", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Blanqueiro",
        "synonyms": ["Blanqueirol", "Blanqueiron", "Blanquerel", "Pignairon"],
        "description": {
            "default": "Very minor Provençal variety.",
            "julie": "",
            "sommelier": "Blanqueiro is Provence’s hidden white gem, offering a delicate dance of citrus, stone fruit, and floral notes over a whisper of minerality. Light on its feet and refreshingly crisp, this grape is perfect for those who crave a taste of the sun-drenched French countryside in every glass.",
        },
        "color": "white",
        "regions": ["Provence", "France"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "table_wine",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Blatina",
        "synonyms": [
            "Blathina",
            "Blatina Crna",
            "Blatina Hercegovacka",
            "Blatina Mala",
            "Blatina Velika",
            "Praznobačva",
            "Zlorod",
        ],
        "description": {
            "default": "Bosnia and Herzegovina’s most important red variety.",
            "julie": "",
            "sommelier": "Blatina is the pride of Herzegovina, offering a harmonious medley of cherry, plum, and earthy mineral notes in a medium-bodied, easy-drinking style—think of it as the soulful storyteller of Balkan reds, equally at home on a rustic table or in a refined glass.",
        },
        "color": "black",
        "regions": ["Bosnia and Herzegovina", "Herzegovina"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "earth",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "unoaked",
            "oaked",
            "early_drinking",
        ],
    },
    {
        "name": "Blauer Portugieser",
        "synonyms": [
            "Autrichien",
            "Badner",
            "Early Burgundy",
            "Modrý Portugal",
            "Oporto",
            "Portugais Bleu",
            "Portugalkja",
            "Portugieser",
            "Portugieser Blau",
            "Portugizac Crni",
            "Português Azul",
            "Vöslauer ; Kékoportó is no longer officially used in Hungary",
        ],
        "description": {
            "default": "Prolific Austrian red wine variety producing rather dull, low-acid wines.",
            "julie": "",
            "sommelier": "Blauer Portugieser is the ultimate crowd-pleaser: a juicy, easy-going red brimming with red currant, raspberry, and a dash of pepper, perfect for sipping slightly chilled on a sunny afternoon. With its gentle tannins and refreshing acidity, this Austrian classic is your go-to for uncomplicated, everyday pleasure.",
        },
        "color": "black",
        "regions": ["Austria", "Germany", "Hungary"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "spice", "pepper"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "early_drinking",
            "table_wine",
            "varietal",
        ],
    },
    {
        "name": "Blauer Urban",
        "synonyms": ["Schwarzer Urban", "Urban", "Urban Blau", "Urban Blauer"],
        "description": {
            "default": "Rarity just about surviving in southern Germany.",
            "julie": "",
            "sommelier": "Blauer Urban is a rare southern German gem, offering a lively dance of cherry, plum, and earthy minerality in a light-bodied, easy-drinking style. This nearly forgotten grape is a delicious nod to tradition, perfect for those seeking a taste of history in their glass.",
        },
        "color": "black",
        "regions": ["Baden", "Württemberg", "Pfalz", "Franken"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Blauer Wildbacher",
        "synonyms": ["Schilcher", "Wildbacher", "Wildbacher Blau"],
        "description": {
            "default": "Distinctively perfumed Austrian red wine grape producing eye-watering pinks.",
            "julie": "",
            "sommelier": "Blauer Wildbacher, the spirited heart of Austria’s Schilcher rosé, dazzles with piercing acidity, red berry zing, and a grassy, spicy kick—think of it as a mountain stream in a glass, perfect for waking up your palate or starting a lively evening.",
        },
        "color": "black",
        "regions": ["Austria", "Weststeiermark", "Styria"],
        "flavor_profile": ["red_fruit", "herbal", "spice", "mineral"],
        "acidity": "Very high",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "red",
            "dessert",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Blaufränkisch",
        "synonyms": [
            "Blauer Limberger",
            "Borgonja",
            "Burgund Mare",
            "Franconia",
            "Franconia Nera",
            "Frankovka",
            "Frankovka Modrá",
            "Frankovna Crna",
            "Gamé",
            "Kékfrankos",
            "Limberger",
            "Lemberger",
            "Nagyburgundi",
            "Sura Lisicina",
        ],
        "description": {
            "default": "Dark-skinned, dark-fruited Austro-Hungarian variety increasingly well grown and vinified, gaining ground.",
            "julie": "Blaufränkisch is Austria second most planted red grape variety. The variety produces a wide array of wine styles ranging from light, fresh and fruity to intensely flavoured, firmly structured and spicy. In Germany, the variety is called Lemberger and in Hungary it is known as Kékfrankos.",
            "sommelier": "Blaufränkisch is the dark horse of Central Europe, galloping from Austria to Hungary with a basket of wild berries, a dash of spice, and a backbone of lively acidity—youthful and bold at first, but destined to mellow into velvet with age. This grape is a true shapeshifter, equally at home in a fresh, fruity glass or a brooding, age-worthy bottle.",
        },
        "color": "black",
        "regions": ["Austria", "Germany", "Hungary", "Slovakia", "Czech Republic"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "blackberry",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Bobal",
        "synonyms": [
            "Balau",
            "Benicarló",
            "Bobos",
            "Carignan Espagnol",
            "Carignan d’Espagne",
            "Coreana",
            "Espagnol",
            "Moravio",
            "Pobretón",
            "Provechón",
            "Rajeno",
            "Requena",
            "Terret d’Espagne",
            "Tinta Madrid",
            "Tonto de Zurra",
            "Valenciana",
        ],
        "description": {
            "default": "Important and increasingly respected variety producing velvety wines in Spain’s Levante.",
            "julie": "",
            "sommelier": "Bobal is Spain’s unsung hero, delivering a juicy medley of plum, cherry, and raspberry wrapped in a velvety, medium-bodied embrace, with a lively acidity that keeps every sip fresh and food-friendly. Whether in a rustic blend or a modern rosé, Bobal charms with its earthy, herbal undertones and a spirited personality that’s impossible to ignore.",
        },
        "color": "black",
        "regions": [
            "Utiel-Requena",
            "Manchuela",
            "Valencia",
            "Castilla-La Mancha",
            "Levante",
            "Spain",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "plum",
            "cherry",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Boğazkere",
        "synonyms": ["Şaraplık Siyah"],
        "description": {
            "default": "Tannic but potentially high-quality, quite common Turkish variety.",
            "julie": "",
            "sommelier": "Boğazkere is Turkey’s answer to a brooding, full-bodied red—think blackberries and plums wrapped in a cloak of spice, leather, and tobacco, with a tannic grip that promises longevity. This grape is a bold companion for adventurous palates, offering a taste of Anatolia’s rugged soul in every glass.",
        },
        "color": "black",
        "regions": [
            "Diyarbakır",
            "Southeastern Anatolia",
            "Elazığ",
            "Eastern Anatolia",
            "Turkey",
        ],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "leather",
            "tobacco",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Bogdanuša",
        "synonyms": [
            "Bogdanjuša",
            "Bogdanuša Bijela",
            "Bojdanuša",
            "Hvarka",
            "Vrbanjka",
        ],
        "description": {
            "default": "Makes light, fresh white on the Croatian island of Hvar.",
            "julie": "",
            "sommelier": "Bogdanuša is Hvar’s breezy white gem, offering a lively dance of citrus and floral notes over a crisp, mineral backbone—think Adriatic sunshine in a glass, perfect for early drinking and seaside daydreams.",
        },
        "color": "white",
        "regions": ["Hvar", "Croatia"],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Bombino Bianco",
        "synonyms": [
            "Bambino",
            "Buonvino",
            "Ottonese",
            "Pagadebit",
            "Straccia Cambiale",
        ],
        "description": {
            "default": "Productive Italian white found mainly in the south and only rarely distinguished.",
            "julie": "",
            "sommelier": "Bombino Bianco is the unsung hero of southern Italy, delivering a crisp, citrusy punch with a whisper of flowers and minerals—perfect for those who crave a refreshing, unoaked white that dances on the palate and disappears all too quickly.",
        },
        "color": "white",
        "regions": ["Puglia", "Abruzzo", "Molise", "Lazio", "Emilia-Romagna"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "table_wine",
            "early_drinking",
            "sparkling",
        ],
    },
    {
        "name": "Bombino Nero",
        "synonyms": ["Bambino", "Buonvino"],
        "description": {
            "default": "Southern Italian dark-skinned variety much less common than its pale namesake.",
            "julie": "",
            "sommelier": "Bombino Nero is the playful, lesser-known dark-skinned gem of Puglia, delivering a lively medley of cherry and raspberry with a whisper of herbs and flowers—think of it as the life of the Italian picnic, best enjoyed young and chilled.",
        },
        "color": "black",
        "regions": ["Puglia", "Southern Italy"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Bonamico",
        "synonyms": ["Giacomino", "Uva di Palaia"],
        "description": {
            "default": "High-yielding Italian black variety hanging on in the Pisa region.",
            "julie": "",
            "sommelier": "Bonamico, a Tuscan treasure clinging to the hills of Pisa, charms with a medley of cherry and plum flavors, medium body, and a lively, easygoing spirit—perfect for early-drinking reds that sing of Italian conviviality. Whether solo or in a blend, this high-yielding grape brings a juicy, fruit-forward flair to the table.",
        },
        "color": "black",
        "regions": ["Tuscany", "Pisa"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Bonarda Piemontese",
        "synonyms": [
            "Bonarda del Monferrato",
            "Bonarda dell’Astigiano",
            "Bonarda di Chieri",
        ],
        "description": {
            "default": "Aromatic, well-coloured Italian red with small bunches and soft tannins.",
            "julie": "",
            "sommelier": "Bonarda Piemontese is Piedmont’s charming secret, offering a vibrant medley of red and black fruits, delicate florals, and a whisper of spice, all wrapped in a silky, medium-bodied frame. With its soft tannins and lively character, it’s the perfect companion for early-drinking Italian reds that dance on the palate.",
        },
        "color": "black",
        "regions": ["Piedmont", "Monferrato", "Asti", "Chieri"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bondola",
        "synonyms": ["Bondola Nera", "Briegler", "Brieger", "Bundula", "Longobardo"],
        "description": {
            "default": "Old, rare Ticino variety that has been overwhelmed by Merlot.",
            "julie": "",
            "sommelier": "Bondola is Ticino’s hidden gem—a medium-bodied red bursting with cherry, plum, and earthy minerality, offering a nostalgic sip of Swiss tradition before Merlot took center stage. This rare varietal is perfect for those seeking a taste of history in their glass.",
        },
        "color": "black",
        "regions": ["Ticino", "Switzerland"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bordô",
        "synonyms": ["Grana d’Oro"],
        "description": {
            "default": "American hybrid used to make cheap, sweetish reds and juices in Brazil.",
            "julie": "",
            "sommelier": "Bordô, Brazil’s beloved black grape, delivers a playful medley of red and black fruits in a light, juicy package—think of it as the life of the party in a glass, perfect for easy sipping and carefree gatherings. Often bottled young and unoaked, it’s the go-to choice for those who crave a sweet, approachable red with a distinctly Brazilian flair.",
        },
        "color": "black",
        "regions": ["Brazil"],
        "flavor_profile": ["red_fruit", "black_fruit", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Borraçal",
        "synonyms": [
            "Azedo",
            "Bogalhal",
            "Caíño Tinto",
            "Espadeiro Redondo",
            "Olho de Sapo",
            "Tinta Femia",
        ],
        "description": {
            "default": "Makes potent, tart, sometimes tough wines in north-west Spain as well as in its native Vinho Verde.",
            "julie": "",
            "sommelier": "Borraçal is the wild child of Vinho Verde and Galicia, delivering a punchy, high-acid red brimming with plum, raspberry, and earthy herbs—think of it as a rustic feast in a glass, equally at home in a blend or standing boldly on its own. Its robust structure and mineral backbone make it a wine for the adventurous, promising both immediate excitement and graceful aging.",
        },
        "color": "black",
        "regions": ["Vinho Verde", "Galicia", "Minho", "Rías Baixas"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "mineral",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Bosco",
        "synonyms": ["Bosco Bianco del Genovese", "Bosco Bianco di Savona"],
        "description": {
            "default": "Ligurian white speciality making excellent sweet wines.",
            "julie": "",
            "sommelier": "Bosco is Liguria’s golden secret, delivering decadent, full-bodied whites and dessert wines that shimmer with honeyed stone fruit, floral perfume, and a whisper of seaside minerals. This grape is a true Italian gem—sumptuous, age-worthy, and perfect for those who crave both opulence and intrigue in their glass.",
        },
        "color": "white",
        "regions": ["Liguria", "Italy"],
        "flavor_profile": ["stone_fruit", "floral", "honey", "mineral", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Bouchalès",
        "synonyms": [
            "Bouchalets",
            "Bouissalet",
            "Gros Bouchalès",
            "Gros Boucharès",
            "Grappu",
            "Grapput",
            "Picardan Noir",
            "Prolongeau",
        ],
        "description": {
            "default": "Declining dark-skinned variety surviving around Bordeaux.",
            "julie": "",
            "sommelier": "Bouchalès is a nostalgic Bordeaux relic, offering a harmonious medley of red and black fruits, earthy undertones, and herbal whispers—perfect for those who appreciate a medium-bodied, easy-drinking red with a story to tell.",
        },
        "color": "black",
        "regions": ["Bordeaux", "Southwest France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine", "early_drinking"],
    },
    {
        "name": "Bourboulenc",
        "synonyms": [
            "Blanquette",
            "Bourboulenco",
            "Bourbouleng",
            "Bourboulenque",
            "Bourbounenco",
            "Clairette à Grains Ronds",
            "Clairette Dorée",
            "Doucillon",
            "Malvoisie",
            "Picardan",
        ],
        "description": {
            "default": "Useful vine making interesting white throughout the south of France.",
            "julie": "",
            "sommelier": "Bourboulenc is the zesty secret of Southern France, delivering a lively medley of citrus, herbs, and minerals in a light, refreshing package—perfect for sipping on a sunlit terrace. Its high acidity and delicate floral notes make it a sommelier’s go-to for bright, early-drinking whites that dance on the palate.",
        },
        "color": "white",
        "regions": ["Southern Rhône", "Languedoc", "Provence", "Southwest France"],
        "flavor_profile": ["citrus", "floral", "herbal", "mineral", "lemon"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bourrisquou",
        "synonyms": ["Bourriscou", "Mourrisquou de Romani", "Romanet"],
        "description": {
            "default": "Very rarely makes wine; better known as the parent of various rootstocks.",
            "julie": "",
            "sommelier": "Bourrisquou is the unsung hero of the vineyard, more often found beneath the soil as a rootstock parent than in your glass, but when it does make wine, expect a balanced, medium-bodied pour with a quiet French charm. Think of it as the grape world's backstage legend—vital, yet rarely in the spotlight.",
        },
        "color": "black",
        "regions": ["France", "Southwest France"],
        "flavor_profile": [],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [],
    },
    {
        "name": "Bouteillan Noir",
        "synonyms": ["Fouiral", "Moulas", "Psalmodi Noir", "Sigoyer"],
        "description": {
            "default": "Virtually extinct Provençal variety.",
            "julie": "",
            "sommelier": "Bouteillan Noir is a whisper from Provence’s past—light-bodied and unoaked, it charms with red fruit, earthy herbs, and a dash of spice, perfect for those seeking a taste of nearly forgotten French tradition.",
        },
        "color": "black",
        "regions": ["Provence", "Southern France"],
        "flavor_profile": ["red_fruit", "herbal", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bouvier",
        "synonyms": [
            "Bela Ranina",
            "Bouvier Blanc",
            "Bouvierovo Hrozno",
            "Bouviertraube",
            "Radgonska Ranina",
            "Ranina",
            "Ranina Bela",
        ],
        "description": {
            "default": "Low-acid Central European variety used for many styles of wine.",
            "julie": "",
            "sommelier": "Bouvier is the Central European charmer, offering a gentle bouquet of pear, peach, and honeyed florals in a light, easy-drinking style—perfect for those who prefer their whites soft, subtle, and endlessly versatile. Whether sparkling or still, this grape is a delightful companion for any casual occasion.",
        },
        "color": "white",
        "regions": ["Slovenia", "Austria", "Hungary", "Croatia"],
        "flavor_profile": ["stone_fruit", "pear", "peach", "floral", "honey", "citrus"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Bracciola Nera",
        "synonyms": ["Bracciuola", "Braciola", "Braciuola", "Brassola"],
        "description": {
            "default": "Obscure, high-yielding, late-ripening black Italian variety found in Toscana and Liguria.",
            "julie": "",
            "sommelier": "Bracciola Nera is the unsung hero of Tuscany and Liguria, delivering a rustic medley of red and black fruits with a whisper of herbs and earth—perfect for those who crave a traditional Italian table wine with character and charm. This grape’s medium everything—body, acidity, tannin—makes it a versatile companion for lively gatherings and hearty fare.",
        },
        "color": "black",
        "regions": ["Toscana", "Liguria"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Brachetto Del Piemonte",
        "synonyms": ["Bracchetto", "Brachetto d’Acqui", "Brachetto"],
        "description": {
            "default": "Rose-scented Piemontese variety making very light, sweet, frothy reds.",
            "julie": "",
            "sommelier": "Brachetto Del Piemonte is the Piedmontese party-starter, bursting with rose petals, raspberries, and cherries in a sweet, frothy red that’s as flirtatious as it is refreshing. With its low alcohol and feather-light body, it’s the perfect companion for dessert or a sun-drenched afternoon.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "floral", "raspberry", "cherry"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Very light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "sparkling",
            "dessert",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Braquet Noir",
        "synonyms": ["Brachet"],
        "description": {
            "default": "Very minor but historic, vine making aromatic light reds around Nice.",
            "julie": "",
            "sommelier": "Braquet Noir is Provence’s aromatic secret, weaving together red fruit, wild herbs, and a whisper of spice in a light, breezy red that’s as charming as a stroll along the Côte d’Azur. This rare grape delivers a delicate, floral-infused sip that’s perfect for early enjoyment and Mediterranean fare.",
        },
        "color": "black",
        "regions": ["Provence", "France", "Nice"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "blend",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Bratkovina Bijela",
        "synonyms": ["Brabkovica", "Mesnac"],
        "description": {
            "default": "Rare Croatian island white adding freshness to Pošip blends.",
            "julie": "",
            "sommelier": "Bratkovina Bijela is a zesty Croatian island gem, bursting with citrus and floral notes atop a mineral backbone—think of it as the secret ingredient that gives Pošip blends their irresistible, sun-kissed freshness. Light-bodied and lively, it’s the perfect companion for seaside sipping and Mediterranean fare.",
        },
        "color": "white",
        "regions": ["Croatian Islands", "Dalmatia", "Korčula"],
        "flavor_profile": ["citrus", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Brauner Veltliner",
        "synonyms": ["Todträger", "Veltliner Braun"],
        "description": {
            "default": "Almost extinct Austrian, unrelated to Roter Veltliner.",
            "julie": "",
            "sommelier": "Brauner Veltliner is Austria’s elusive grey gem, offering a whisper of stone fruit, apple, and pear, laced with mineral and herbal notes—think of it as a light-footed ghost from the vineyards, perfect for those who crave something rare and refreshingly different.",
        },
        "color": "grey",
        "regions": ["Austria"],
        "flavor_profile": ["stone_fruit", "mineral", "herbal", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Breidecker",
        "synonyms": ["Geisenheim 49-84"],
        "description": {
            "default": "Relatively neutral German hybrid that has found limited favour in New Zealand.",
            "julie": "",
            "sommelier": "Breidecker is the quiet achiever of the white wine world—delivering crisp apple and pear flavors with a whisper of minerality, all wrapped in a light, refreshing body. Perfect for those who appreciate subtlety and a clean, unoaked finish, this German-New Zealand hybrid is a charming companion for easygoing afternoons.",
        },
        "color": "white",
        "regions": ["Germany", "New Zealand"],
        "flavor_profile": ["apple", "pear", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Breslava",
        "synonyms": ["CHRTČ × St Dc ALC 10/28", "Chrtc × St M D#Alc 10/28"],
        "description": {
            "default": "One of the earliest Slovakian crosses but little dispersed.",
            "julie": "",
            "sommelier": "Breslava is a hidden gem from Central Europe, offering a crisp medley of apple, pear, and citrus with a whisper of floral and mineral notes—think of it as a spring breeze in a glass, perfect for those who crave light, lively, and easy-drinking whites.",
        },
        "color": "white",
        "regions": ["Slovakia", "Czech Republic", "Hungary", "Austria"],
        "flavor_profile": ["apple", "pear", "floral", "citrus", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "traditional",
            "modern",
            "early_drinking",
        ],
    },
    {
        "name": "Brianna",
        "synonyms": ["ES 7-4-76"],
        "description": {
            "default": "Minor but usefully winter-hardy and increasingly popular American hybrid.",
            "julie": "",
            "sommelier": "Brianna is the Midwest’s answer to a tropical getaway—this winter-hardy white grape bursts with flavors of pineapple, pear, and honey, delivering a light, floral wine that’s as refreshing as a summer breeze on the prairie. Perfect for early sipping, it’s a charming reminder that great wine can thrive even where winters bite.",
        },
        "color": "white",
        "regions": [
            "Midwestern United States",
            "Minnesota",
            "Iowa",
            "Nebraska",
            "South Dakota",
        ],
        "flavor_profile": [
            "tropical_fruit",
            "stone_fruit",
            "floral",
            "honey",
            "apple",
            "pear",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Bronner",
        "synonyms": ["Freiburg 250-75"],
        "description": {
            "default": "German hybrid bred for its disease resistance.",
            "julie": "",
            "sommelier": "Bronner is the eco-warrior of the vineyard, delivering zesty citrus and orchard fruit flavors with a floral, herbal lift and a racy streak of minerality—think of it as Riesling’s fresh-faced, disease-resistant cousin, perfect for a sunny afternoon sip.",
        },
        "color": "white",
        "regions": ["Germany", "Switzerland", "Austria"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Brun Argenté",
        "synonyms": ["Camarèse", "Camarèze", "Vaccarèse", "Vacarèse", "Vaccarèze"],
        "description": {
            "default": "Very minor southern Rhône variety.",
            "julie": "",
            "sommelier": "Brun Argenté is the Rhône’s elusive charmer, weaving red and black fruits, wild herbs, and a whisper of spice into light-bodied, early-drinking blends. Rarely bottled solo, it’s the secret ingredient that brings aromatic flair and a touch of intrigue to classic Châteauneuf-du-Pape.",
        },
        "color": "black",
        "regions": ["Southern Rhône", "Châteauneuf-du-Pape", "France"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Brun Fourca",
        "synonyms": [
            "Brun d’Auriol",
            "Brun Fourcat",
            "Farnous",
            "Flouron",
            "Mançonnet",
            "Moulan",
            "Moureau",
            "Mouzeau",
            "Mourrastel-Flourat",
        ],
        "description": {
            "default": "Ancient but now virtually extinct western Provençal vine.",
            "julie": "",
            "sommelier": "Brun Fourca is a rare, time-traveling grape from the sun-drenched hills of Provence, offering a tapestry of red and black fruits, wild herbs, and earthy spice—like a Provençal market in a glass. Medium-bodied and balanced, it’s a delicious relic for those who crave the flavors of old-world France.",
        },
        "color": "black",
        "regions": ["Provence", "Languedoc", "Southern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "traditional",
            "table_wine",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Brustiano Bianco",
        "synonyms": ["Calitrano", "Colitrano", "Licronaxu Bianco"],
        "description": {
            "default": "Scarce white variety found on the Italian island of Sardegna and reintroduced on the French island of Corse.",
            "julie": "",
            "sommelier": "Brustiano Bianco is a Sardinian-Corsican rarity that dazzles with zesty citrus, delicate stone fruit, and a whisper of wildflowers, all wrapped in a crisp, mineral-driven frame—perfect for those who crave a lively, unoaked white with a story to tell.",
        },
        "color": "white",
        "regions": ["Sardegna", "Corse"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Budai Zöld",
        "synonyms": ["Budai", "Zöld Budai", "Zöld Szőlő", "Zöldfehér", "Zöldszőlő"],
        "description": {
            "default": "Very minor Hungarian variety making fresh, simple whites.",
            "julie": "",
            "sommelier": "Budai Zöld is Hungary’s zippy secret: a feather-light white bursting with citrus, apple, and a whisper of wildflowers, perfect for quenching your thirst on a sunny afternoon. With its high acidity and mineral edge, this grape delivers a clean, refreshing sip that’s as easygoing as a stroll along the Danube.",
        },
        "color": "white",
        "regions": ["Hungary"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Budeshuri Tsiteli",
        "synonyms": ["Budeshuri Saperavi", "Budeshuri Shavi", "Tsiteli Budeshuri"],
        "description": {
            "default": "Very minor Georgian variety usually blended with Saperavi.",
            "julie": "",
            "sommelier": "Budeshuri Tsiteli is Georgia’s hidden gem—a pink-skinned grape that lends a whisper of red fruit, wild herbs, and stony minerality to blends, making every sip a gentle, aromatic adventure. Light on its feet and charmingly floral, it’s the secret ingredient that gives Georgian wines their playful complexity.",
        },
        "color": "pink",
        "regions": ["Georgia"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "mineral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Buket",
        "synonyms": ["Bouquet"],
        "description": {
            "default": "Relatively unknown Bulgarian cross with potential for well-structured, full-flavoured reds.",
            "julie": "",
            "sommelier": "Buket, Bulgaria’s hidden gem, delivers a symphony of black fruit, plum, and earthy spice in a full-bodied embrace—think of it as the Balkan answer to a classic, age-worthy red, ready to surprise and delight adventurous palates.",
        },
        "color": "black",
        "regions": ["Bulgaria"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Bukettraube",
        "synonyms": [
            "Bocksbeutel",
            "Bouquettraube",
            "Buket",
            "Bukettrebe",
            "Würzburger",
        ],
        "description": {
            "default": "Aromatic cross bred in Germany but most widely planted in South Africa for sweet wines.",
            "julie": "",
            "sommelier": "Bukettraube is a charmingly aromatic white grape, offering a bouquet of honeysuckle, ripe peaches, and tropical fruit, all wrapped in a silky, medium-bodied frame. Most at home in South Africa, it’s a sweet treat that dances on the palate and is perfect for those who love their wines fragrant and fun.",
        },
        "color": "white",
        "regions": ["South Africa", "Germany"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "dessert", "varietal", "premium", "early_drinking"],
    },
    {
        "name": "Bussanello",
        "synonyms": ["Incrocio Dalmasso 12/37"],
        "description": {
            "default": "Aromatic white Italian cross recommended in parts of Piemonte.",
            "julie": "",
            "sommelier": "Bussanello dazzles with a bouquet of spring blossoms, zesty citrus, and a whisper of stone fruit, all underpinned by a crisp mineral streak—think of it as Piemonte’s lively answer to a summer aperitif, perfect for those who crave freshness in every sip.",
        },
        "color": "white",
        "regions": ["Piemonte"],
        "flavor_profile": ["floral", "citrus", "stone_fruit", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Busuioacă De Bohotin",
        "synonyms": [
            "Busuioacă Neagră",
            "Busuioacă Vânată de Bohotin",
            "Tămâioasă de Bohotin",
            "Tămâioasă Violetă",
        ],
        "description": {
            "default": "Aromatic pink-skinned Romanian variety making sweet, well-balanced Muscat-like wines.",
            "julie": "",
            "sommelier": "Busuioacă De Bohotin is Romania’s enchanting pink gem, seducing the senses with a fragrant swirl of rose petals, ripe cherries, and a honeyed whisper of spice—think of it as Muscat’s flirtatious cousin, perfect for those who crave a light-bodied, aromatic adventure in their glass.",
        },
        "color": "pink",
        "regions": ["Romania", "Moldova (Romania)", "Bohotin"],
        "flavor_profile": ["red_fruit", "floral", "stone_fruit", "honey", "spice"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "dessert",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Caberinta",
        "synonyms": ["CG 14892", "Gargiulo 14892"],
        "description": {
            "default": "Productive but not very popular Argentine hybrid.",
            "julie": "",
            "sommelier": "Caberinta is Argentina’s unsung hero—a juicy, medium-bodied red brimming with vibrant red and black fruit flavors, perfect for those seeking a fresh, approachable table wine. Though not a household name, this hybrid grape delivers a charming, easy-drinking experience that’s as lively as a Buenos Aires street tango.",
        },
        "color": "black",
        "regions": ["Argentina"],
        "flavor_profile": ["red_fruit", "black_fruit"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "table_wine",
            "early_drinking",
            "medium_bodied",
            "varietal",
        ],
    },
    {
        "name": "Cabernet Blanc",
        "synonyms": ["VB 91-26-1"],
        "description": {
            "default": "Recent Swiss hybrid that combines fresh, clean flavours and good disease resistance.",
            "julie": "",
            "sommelier": "Cabernet Blanc is the zesty Swiss secret, delivering a lively medley of citrus, apple, and delicate florals with a mineral edge—think of it as a mountain-fresh breeze in a glass, perfect for those who crave crisp, modern whites.",
        },
        "color": "white",
        "regions": ["Switzerland", "Germany", "Austria"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "modern",
            "table_wine",
        ],
    },
    {
        "name": "Cabernet Carbon",
        "synonyms": [],
        "description": {
            "default": "Recent tannic German, very complex, hybrid bred for superior disease resistance.",
            "julie": "",
            "sommelier": "Cabernet Carbon is Germany’s answer to the modern red: a full-bodied, age-worthy hybrid bursting with blackberries, plums, and a spicy, earthy backbone, all wrapped in a cloak of high tannin and zesty acidity. This grape is a sommelier’s delight—complex, resilient, and ready to shake up your cellar.",
        },
        "color": "black",
        "regions": ["Germany", "Austria", "Switzerland"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "modern",
            "table_wine",
            "full_bodied",
            "age_worthy",
        ],
    },
    {
        "name": "Cabernet Carol",
        "synonyms": [],
        "description": {
            "default": "Barely planted disease-resistant German hybrid.",
            "julie": "",
            "sommelier": "Cabernet Carol is a rare German gem, blending the boldness of black fruit and plum with a whisper of herbs and spice, all wrapped in a modern, eco-friendly package. Perfect for adventurous palates, this medium-bodied red brings a fresh twist to classic table wine.",
        },
        "color": "black",
        "regions": ["Germany", "Austria", "Switzerland"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "modern",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Cabernet Colonjes",
        "synonyms": ["VB 91-26-5", "VB 91-26-05"],
        "description": {
            "default": "Minor dark-skinned Swiss hybrid found mainly in the Netherlands.",
            "julie": "",
            "sommelier": "Cabernet Colonjes is a Dutch-Swiss rarity that dazzles with a vibrant medley of red and black fruits, accented by fresh herbal notes and a zippy acidity—perfect for those seeking a modern, early-drinking red with a twist of the unexpected.",
        },
        "color": "black",
        "regions": ["Netherlands", "Switzerland"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "vegetal"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "modern",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Cortis",
        "synonyms": [],
        "description": {
            "default": "Recent tannic German hybrid bred for superior disease resistance.",
            "julie": "",
            "sommelier": "Cabernet Cortis is the eco-warrior of the vineyard, delivering a robust medley of black and red fruits, earthy spice, and a firm tannic handshake—all wrapped up in a modern, disease-resistant package perfect for early-drinking European reds.",
        },
        "color": "black",
        "regions": ["Germany", "Switzerland", "Austria"],
        "flavor_profile": ["black_fruit", "red_fruit", "herbal", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "medium_bodied",
            "full_bodied",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Cubin",
        "synonyms": ["Weinsberg 70-281-35"],
        "description": {
            "default": "Deeply coloured, tannin-rich German cross that needs the best sites to ripen fully.",
            "julie": "",
            "sommelier": "Cabernet Cubin is Germany’s answer to a brooding, full-bodied red—think blackberry, plum, and a peppery kick, all wrapped in a cloak of earthy minerality and robust tannins. This grape demands the best sites to show its true colors, rewarding patient drinkers with a wine as age-worthy as it is intriguing.",
        },
        "color": "black",
        "regions": ["Germany", "Württemberg", "Pfalz"],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "blackberry",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "blend",
            "varietal",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Cabernet Dorio",
        "synonyms": ["Weinsberg 71-817-89"],
        "description": {
            "default": "Recent German cross with a certain Cabernet likeness.",
            "julie": "",
            "sommelier": "Cabernet Dorio is Germany’s answer to Cabernet, delivering a charming medley of black fruit, plum, and earthy spice in a medium-bodied frame—think of it as Cabernet’s cool, contemporary cousin, perfect for both traditionalists and modernists alike.",
        },
        "color": "black",
        "regions": ["Germany", "Baden", "Württemberg", "Rheinhessen"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "herbal",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Dorsa",
        "synonyms": ["Weinsberg 71-817-92"],
        "description": {
            "default": "The most successful of the new German Cabernets.",
            "julie": "",
            "sommelier": "Cabernet Dorsa is Germany’s answer to the modern red, offering a harmonious medley of plum, blackberry, and cherry, dusted with pepper and a hint of oak. This medium-bodied charmer is as versatile as it is vibrant, perfect for those seeking a fresh twist on classic Cabernet character.",
        },
        "color": "black",
        "regions": ["Germany", "Württemberg", "Rheinhessen"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "spice",
            "earth",
            "oak",
            "plum",
            "blackberry",
            "cherry",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "blend",
            "varietal",
            "modern",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Franc",
        "synonyms": [
            "Achéria",
            "Ardounet",
            "Bidure",
            "Bordeaux",
            "Bordo",
            "Boubet",
            "Bouchet Franc",
            "Gros Bouchet",
            "Bouchy",
            "Breton",
            "Cabernet Gris",
            "Cabrunet",
            "Capbreton Rouge",
            "Carmenet",
            "Couahort",
            "Plant Breton",
            "Plant de l’Abbé Breton",
            "Sable Rouge",
            "Trouchet",
            "Tsapournako",
            "Verdejilla Tinto",
            "Véron",
            "Vidure",
            "Vuidure",
            "Grosse Vidure",
        ],
        "description": {
            "default": "Fragrant, well-structured parent of Cabernet Sauvignon that shines in the Loire and in Bordeaux blends.",
            "julie": 'Cabernet franc is one of the most ancient grape varities found in the region of Bordeaux. Today it is also widely planted in the Loire Valley where it is often known as "Breton". Cabernet Franc produces wines that have a characteristic herbal aromas ranging from refreshing leafiness when ripe to full on green bell pepper (pyrazine) when underripe. In the Loire Valley, the wines can be supple, medium-bodied, with aromas of raspberries and pencil shavings or can show more structure and minerality in regions such as Saumur-Champigny. In Bordeaux, Cabernet Franc is most often blended with Merlot and Cabernet Sauvignon, howver, some producers in the region of Saint Emilion are using the grape variety as a solo player or as the main player. The grape is also found in many other countries around the world. ',
            "sommelier": "Cabernet Franc is the elegant, aromatic ancestor of Cabernet Sauvignon, charming with its vibrant red fruit, herbal lift, and a whisper of pencil shavings. Whether starring solo in the Loire or blending in Bordeaux, it delivers a lively, medium-bodied wine that dances between freshness and earthy complexity—perfect for those who like their reds with a dash of intrigue.",
        },
        "color": "black",
        "regions": [
            "Loire Valley",
            "Bordeaux",
            "Italy",
            "United States",
            "Canada",
            "Argentina",
            "Chile",
            "Hungary",
        ],
        "flavor_profile": [
            "red_fruit",
            "herbal",
            "vegetal",
            "earth",
            "mineral",
            "raspberry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Jura",
        "synonyms": ["VB 5-02"],
        "description": {
            "default": "A recent dark-skinned, disease-resistant Swiss hybrid that has so far remained in its homeland.",
            "julie": "",
            "sommelier": "Cabernet Jura is Switzerland’s secret weapon: a modern, disease-resistant grape that delivers a medley of red and black fruits, herbal spice, and earthy charm in a medium-bodied, easy-drinking red. Think of it as the Swiss Army knife of wines—versatile, reliable, and ready for any table.",
        },
        "color": "black",
        "regions": ["Switzerland", "Jura (Switzerland)"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "medium_bodied",
            "table_wine",
            "early_drinking",
            "modern",
        ],
    },
    {
        "name": "Cabernet Mitos",
        "synonyms": ["Weinsberg 70-77-4F"],
        "description": {
            "default": "Recent, deeply coloured German cross making wines useful in blends.",
            "julie": "",
            "sommelier": "Cabernet Mitos is Germany’s answer to a modern, inky red—bursting with black fruit, plum, and earthy spice, it brings a suave, medium-bodied charm to blends and varietal wines alike. Think of it as the stylish newcomer at the table, effortlessly bridging tradition and innovation in every glass.",
        },
        "color": "black",
        "regions": ["Germany", "Rheinhessen", "Pfalz", "Baden"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "medium_bodied",
            "modern",
            "table_wine",
            "varietal",
        ],
    },
    {
        "name": "Cabernet Moravia",
        "synonyms": ["M-43"],
        "description": {
            "default": "High-quality, late-ripening Czech cross producing Cabernet-like wines.",
            "julie": "",
            "sommelier": "Cabernet Moravia is Moravia’s answer to Cabernet, offering a beguiling medley of blackberries, plums, and peppery spice, all wrapped in a medium-bodied, age-worthy frame. This Czech original charms with its earthy undertones and herbal lift, making it a must-try for adventurous red wine lovers.",
        },
        "color": "black",
        "regions": ["Czech Republic", "Moravia"],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "herbal",
            "earth",
            "plum",
            "blackberry",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "traditional",
            "age_worthy",
        ],
    },
    {
        "name": "Cabernet Pfeffer",
        "synonyms": ["Pfeffer Cabernet"],
        "description": {
            "default": "Rare, peppery California cross.",
            "julie": "",
            "sommelier": "Cabernet Pfeffer is California’s spicy secret, delivering a lively medley of black fruit, cracked pepper, and earthy intrigue in a medium-bodied, modern red that’s as rare as it is memorable. Perfect for those who crave a dash of adventure in their glass!",
        },
        "color": "black",
        "regions": ["California"],
        "flavor_profile": ["black_fruit", "spice", "pepper", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "modern",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Cabernet Sauvignon",
        "synonyms": [
            "Bidure",
            "Bordo",
            "Bouchet",
            "Bouchet Sauvignon",
            "Petit Bouchet",
            "Burdeos Tinto",
            "Cabernet Petit",
            "Carbonet",
            "Carbouet",
            "Carmenet",
            "Lafit",
            "Lafite",
            "Marchoupet",
            "Petit Cabernet",
            "Petit Cavernet Sauvignon",
            "Sauvignon",
            "Sauvignonne",
            "Vidure",
            "Vidure Sauvignonne",
            "Petite Vidure",
        ],
        "description": {
            "default": "The world’s best-travelled red wine variety making concentrated, tannic wines for particularly long ageing.",
            "julie": "The number one red grape in the world is originally from the Gironde region in France. Cabernet Sauvignon has small, thick-skinned berries that contribute to deep colour, high tannins and relatively high acidity in the wine. Aronatically Cabernet is often associated with blackcurrant.",
            "sommelier": "Cabernet Sauvignon is the globe-trotting monarch of red grapes, delivering bold, full-bodied wines brimming with blackcurrant, spice, and a hint of tobacco—perfect for those who appreciate power, complexity, and a wine that only gets better with age.",
        },
        "color": "black",
        "regions": [
            "Bordeaux",
            "Napa Valley",
            "Coonawarra",
            "Maipo Valley",
            "Tuscany",
            "Stellenbosch",
            "Margaret River",
        ],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "oak",
            "tobacco",
            "chocolate",
            "coffee",
            "leather",
            "herbal",
            "vegetal",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "blend",
            "varietal",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
            "traditional",
            "modern",
        ],
    },
    {
        "name": "Cabernet Severny",
        "synonyms": ["Cabernet Szevernuej", "Kaberne Severnyi"],
        "description": {
            "default": "Winter-hardy hybrid with Asian not Cabernet genes but marked Cabernet colour and flavours.",
            "julie": "",
            "sommelier": "Cabernet Severny is the cold-climate rebel of Eastern Europe, delivering a medley of blackberries, cherries, and earthy spice with a nod to Cabernet’s classic charm—despite its non-Cabernet roots. Medium-bodied and versatile, it’s a winter-hardy wonder that brings a taste of adventure to your glass.",
        },
        "color": "black",
        "regions": ["Russia", "Ukraine", "Moldova", "Eastern Europe"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "herbal",
            "spice",
            "earth",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cabertin",
        "synonyms": ["VB 91-26-17"],
        "description": {
            "default": "Recent disease-resistant Swiss hybrid with potential.",
            "julie": "",
            "sommelier": "Cabertin is the Swiss army knife of grapes—disease-resistant, charmingly balanced, and bursting with cherry, plum, and a whisper of spice. Whether in a light, early-drinking red or a more premium blend, it delivers a juicy, earthy intrigue that’s as versatile as it is delicious.",
        },
        "color": "black",
        "regions": ["Switzerland", "Germany", "Austria", "France (Alsace)"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "earth",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Cacaboué",
        "synonyms": ["Caca d’Oie", "Cacabois", "Cacabouet", "Persan Blanc"],
        "description": {
            "default": "Virtually extinct Savoie vine.",
            "julie": "",
            "sommelier": "Cacaboué is a ghostly gem from Savoie, offering a lively dance of citrus, apple, and wildflowers over a crisp mineral backbone—think of it as a mountain stream in a glass, perfect for those who seek the thrill of the nearly forgotten.",
        },
        "color": "white",
        "regions": ["Savoie", "France"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Cacamosca",
        "synonyms": ["Riciniello Bianco"],
        "description": {
            "default": "Rare, low-yielding Campanian white.",
            "julie": "",
            "sommelier": "Cacamosca, Campania’s elusive white gem, dazzles with zesty citrus, delicate stone fruit, and a whisper of wildflowers, all wrapped in a brisk, mineral-driven frame. This light-bodied rarity is a refreshing ode to tradition—perfect for those who seek the thrill of the undiscovered.",
        },
        "color": "white",
        "regions": ["Campania"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Caddiu",
        "synonyms": ["Caddeo", "Caddiu Nieddu", "Caddu", "Pàmpinu"],
        "description": {
            "default": "Sardinian blending and sometimes table grape.",
            "julie": "",
            "sommelier": "Caddiu is Sardinia’s secret handshake—a medium-bodied black grape that weaves together red and black fruits with a whisper of wild herbs and earth, perfect for early-drinking reds or as a rustic table companion. Whether in a blend or solo, it brings a taste of the island’s sun-drenched tradition to your glass.",
        },
        "color": "black",
        "regions": ["Sardinia"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Caíño Blanco",
        "synonyms": ["Cainho de Moreira", "Caíño Branco"],
        "description": {
            "default": "Rare Iberian white that ripens late but keeps its acidity.",
            "julie": "",
            "sommelier": "Caíño Blanco is the zesty secret of Iberia, delivering a lively medley of citrus, pear, and stony minerality in every sip. With its high-wire acidity and delicate floral notes, this rare grape is a sommelier’s delight for those who crave a crisp, invigorating white.",
        },
        "color": "white",
        "regions": ["Galicia", "Rías Baixas", "Ribeiro", "Minho", "Vinho Verde"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Caladoc",
        "synonyms": ["Kaladok"],
        "description": {
            "default": "Usefully reliable cross created in southern France but now well dispersed.",
            "julie": "",
            "sommelier": "Caladoc is the Mediterranean’s reliable secret, offering a juicy tapestry of plum, cherry, and blackberry, laced with a dash of spice and herbs. Perfect for early drinking, this medium-bodied charmer brings a sun-kissed French flair to any table.",
        },
        "color": "black",
        "regions": ["Southern France", "Languedoc", "Provence", "Spain", "Portugal"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "herbal",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Calagraño",
        "synonyms": ["Calagraña", "Navès"],
        "description": {
            "default": "Virtually extinct Rioja vine making coarse, uninteresting wine.",
            "julie": "",
            "sommelier": "Once a humble staple of Rioja, Calagraño is a rare white grape whose earthy, mineral-driven wines are more a nod to tradition than a toast to finesse—think of it as a rustic relic best enjoyed for its historical curiosity rather than its complexity.",
        },
        "color": "white",
        "regions": ["Rioja", "Spain"],
        "flavor_profile": ["earth", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Calandro",
        "synonyms": ["Geilweilerhof 84-58-1233"],
        "description": {
            "default": "Recent German hybrid awaiting official recognition.",
            "julie": "",
            "sommelier": "Calandro is Germany’s up-and-coming black grape, bursting with red and black fruit, a dash of herbs, and earthy intrigue—all wrapped in zesty acidity and a medium frame. Perfect for those seeking a fresh, modern twist on classic table reds.",
        },
        "color": "black",
        "regions": ["Germany"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
            "modern",
        ],
    },
    {
        "name": "Calitor Noir",
        "synonyms": [
            "Col Tor",
            "Colitor",
            "Coytor",
            "Garriga",
            "Pécoui-Touar",
            "Picpoul de Fronton",
        ],
        "description": {
            "default": "Declining, low-quality Provençal variety with more synonyms than hectares under vine.",
            "julie": "",
            "sommelier": "Calitor Noir is Provence’s elusive chameleon, offering a whisper of red fruit, herbs, and earth in a light, easy-drinking style—more a nostalgic nod to tradition than a showstopper, but a charming companion for a casual Provençal table.",
        },
        "color": "black",
        "regions": ["Provence", "Southern France"],
        "flavor_profile": ["red_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "blend",
            "traditional",
        ],
    },
    {
        "name": "Çalkarasi",
        "synonyms": ["Çal Karası"],
        "description": {
            "default": "Produces light, fresh reds and rosés in south-west Turkey.",
            "julie": "",
            "sommelier": "Çalkarasi is Turkey’s answer to summer in a glass—think a breezy, floral bouquet of cherries and raspberries, with a zippy acidity that dances on the palate. Light-bodied and charming, it’s the perfect companion for a sun-drenched afternoon or a lively mezze spread.",
        },
        "color": "black",
        "regions": ["Turkey", "Denizli", "South-west Turkey"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Camaralet De Lasseube",
        "synonyms": [
            "Camaralet",
            "Camaralet Blanc",
            "Camaralet de la Seube",
            "Camarau Blanc",
            "Kamarau",
            "Gentil Aromatique",
            "Moustardet",
            "Petit Camarau",
        ],
        "description": {
            "default": "Low fertility threatens this south-west France vine that can produce full-bodied, aromatic whites.",
            "julie": "",
            "sommelier": "Camaralet De Lasseube is a floral and spicy white from southwest France, offering a full-bodied embrace of stone fruit and citrus with a whisper of herbs—an aromatic rarity that rewards the curious palate.",
        },
        "color": "white",
        "regions": ["South West France", "Jurançon", "Béarn"],
        "flavor_profile": ["floral", "herbal", "spice", "stone_fruit", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Camaraou Noir",
        "synonyms": ["Caíño Redondo", "Camarau", "Kamarau", "Moustardet"],
        "description": {
            "default": "Vigorous south-west French vine makes basic wine, mainly in Galicia.",
            "julie": "",
            "sommelier": "Camaraou Noir, a spirited grape from the wilds of South-West France and Galicia, delivers a lively medley of red and black fruits, earthy undertones, and a zesty herbal kick—perfect for those who crave a rustic, early-drinking red with a dash of local flair.",
        },
        "color": "black",
        "regions": ["South-West France", "Galicia", "Spain"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "table_wine",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Camarate",
        "synonyms": [
            "Camarate Tinto",
            "Castelão da Bairrada",
            "Castelão do Nosso",
            "Castelão Nacional",
            "Moreto do Douro",
            "Moreto de Soure",
            "Mortágua",
            "Mortagua de Vide Preta",
            "Negro Mouro",
            "Vide Preta",
        ],
        "description": {
            "default": "Sun-loving Portuguese variety making soft, easy-drinking reds.",
            "julie": "",
            "sommelier": "Camarate is Portugal’s easygoing charmer, offering a juicy medley of plum, cherry, and spice in a soft, medium-bodied red that’s perfect for early sipping or blending. Think of it as the friendliest guest at the table—always ready to please, never overpowering.",
        },
        "color": "black",
        "regions": ["Lisboa", "Bairrada", "Douro", "Portugal"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "table_wine",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Campbell Early",
        "synonyms": ["Campbell", "Campbell’s Early", "Island Belle"],
        "description": {
            "default": "North American hybrid now more widely grown in Asia, often for the table.",
            "julie": "",
            "sommelier": "Campbell Early is the charming globetrotter of the grape world, offering a bouquet of red and blue fruits with a delicate floral lift, all wrapped in a light, refreshing body. Whether sipped as a playful red or rosé or enjoyed straight from the bunch, this grape brings a taste of springtime to your glass.",
        },
        "color": "black",
        "regions": ["Japan", "South Korea", "United States (New York, Ohio)"],
        "flavor_profile": ["red_fruit", "blue_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Canada Muscat",
        "synonyms": ["NY 17806"],
        "description": {
            "default": "Grapey hybrid just about surviving in Australia.",
            "julie": "",
            "sommelier": "Canada Muscat is a whimsical white hybrid that charms with floral and tropical fruit aromas, delivering a light, breezy sip perfect for early enjoyment. Think of it as the plucky underdog of the vineyard, thriving in Canada and just hanging on in Australia, offering a fresh, grapey delight with every glass.",
        },
        "color": "white",
        "regions": ["Australia", "Canada"],
        "flavor_profile": ["floral", "tropical_fruit", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "light_bodied", "varietal", "early_drinking"],
    },
    {
        "name": "Canaiolo Nero",
        "synonyms": [
            "Cannaiola di Marta",
            "Cannaiola Macchie di Marta",
            "Canaiolo",
            "Uva Canina",
        ],
        "description": {
            "default": "Soft, full-bodied, central Italian red used mainly to complement Sangiovese.",
            "julie": "",
            "sommelier": "Canaiolo Nero is the unsung hero of central Italy, lending a plush, velvety embrace to Sangiovese blends with its juicy cherry and plum notes, gentle florals, and a whisper of herbs. This grape brings a soft, full-bodied charm to the table, making every sip a harmonious Italian serenade.",
        },
        "color": "black",
        "regions": ["Tuscany", "Umbria", "Lazio"],
        "flavor_profile": ["red_fruit", "cherry", "plum", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "full_bodied",
            "age_worthy",
        ],
    },
    {
        "name": "Canari Noir",
        "synonyms": ["Batista", "Canaril", "Canarill", "Carcassès", "Luverdon"],
        "description": {
            "default": "Hanging on by a thread in the Ariège.",
            "julie": "",
            "sommelier": "Canari Noir is a black grape on the brink of extinction, offering a rustic tapestry of red and black fruits, earthy undertones, and herbal whispers—an unsung hero of Ariège, perfect for those who savor the thrill of rare finds in their glass.",
        },
        "color": "black",
        "regions": ["Ariège", "Southwest France", "Occitanie"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cañocazo",
        "synonyms": ["False Pedro", "Hardskin Pedro", "Mollar Blanco", "Pedro"],
        "description": {
            "default": "Virtually extinct variety once popular in sherry country.",
            "julie": "",
            "sommelier": "Cañocazo is a ghost of sherry country, offering a beguiling medley of dried fruit, nuts, and mineral notes wrapped in a light, high-octane frame—an Andalusian treasure for those lucky enough to taste its rare, age-worthy wines. Once a star in Jerez, this nearly vanished grape whispers of Spain’s vinous past with every sip.",
        },
        "color": "white",
        "regions": ["Andalusia", "Jerez", "Spain"],
        "flavor_profile": ["dried_fruit", "nuts", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "High",
        "wine_styles": ["white", "fortified", "traditional", "age_worthy", "varietal"],
    },
    {
        "name": "Caracol",
        "synonyms": ["Olho de Pargo", "Uva das Eiras"],
        "description": {
            "default": "Very minor variety found on the Portuguese island of Porto Santo.",
            "julie": "",
            "sommelier": "Caracol is a hidden gem from Porto Santo, offering a breezy bouquet of citrus and wildflowers over a whisper of sea-salted minerals—think of it as a sunlit stroll along a windswept Atlantic shore, bottled for your table.",
        },
        "color": "white",
        "regions": ["Porto Santo", "Madeira", "Portugal"],
        "flavor_profile": ["citrus", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cardinal",
        "synonyms": [
            "Apostoliatiko",
            "Francesa",
            "G 10-30",
            "Karaburnu Rannii",
            "Kardinal",
            "Rannii Carabournu",
        ],
        "description": {
            "default": "Red-skinned North American table grape occasionally used to make wine in parts of Asia.",
            "julie": "",
            "sommelier": "Cardinal is the globetrotter of grapes—born in North America but beloved from California to Vietnam—offering a juicy burst of red fruit and delicate florals in every sip. Light-bodied and low in alcohol, it's the perfect companion for a sunny afternoon or a breezy table wine adventure.",
        },
        "color": "red",
        "regions": ["California", "Thailand", "Vietnam", "China"],
        "flavor_profile": ["red_fruit", "floral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Cargarello",
        "synonyms": ["Cargarèl"],
        "description": {
            "default": "White variety on the verge of extinction in the Rimini area of northern Italy.",
            "julie": "",
            "sommelier": "Cargarello is a whisper of Rimini’s winemaking past—delicate, citrusy, and floral, with a mineral streak and a light, refreshing body that makes it perfect for early sipping and lively conversation. This nearly forgotten gem is a crisp, unoaked delight, ideal for those who seek the rare and the authentic.",
        },
        "color": "white",
        "regions": ["Rimini", "Emilia-Romagna", "Northern Italy"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Carmenère",
        "synonyms": [
            "Cabernelle",
            "Cabernet Gernicht",
            "Cabernet Gernischet",
            "Cabernet Gernischt",
            "Cabernet Shelongzhu",
            "Carbonet",
            "Carbouet",
            "Caremenelle",
            "Carménègre",
            "Carménère",
            "Carmeneyre",
            "Grosse Vidure",
        ],
        "description": {
            "default": "Produces deeply coloured, sometimes herbaceous wines, in Chile far more than in its native Bordeaux.",
            "julie": "Carménère is an old grape varierty from the Gironde region, in France. It was widely planted in Bordeaux until the Phylloxera crisis but nearly disappeared since. Carménère has built a new reputation in Chile, where it was at first mistaken for Merlot. If harvested before being fully ripe, Carménère produces wines which are are in pyrazine (herbaceous, green bell pepper aromas). When made from fully ripe grapes, the wines are full bodied and display aromas of black and blue fruits, chocolate and soy sauce. ",
            "sommelier": "Once Bordeaux’s forgotten child, Carmenère now reigns in Chile, offering a full-bodied, inky wine that seduces with black and blue fruits, a whisper of chocolate, and a savory hint of soy sauce—just don’t pick it too early, or you’ll get a green bell pepper surprise!",
        },
        "color": "black",
        "regions": ["Chile", "Bordeaux", "France"],
        "flavor_profile": [
            "black_fruit",
            "blue_fruit",
            "herbal",
            "vegetal",
            "chocolate",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "modern",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Carricante",
        "synonyms": ["Catanese Bianco"],
        "description": {
            "default": "Potentially very fine, crisp and distinctive Sicilian white variety.",
            "julie": "",
            "sommelier": "Carricante dazzles with zesty citrus and apple notes, a racy backbone of volcanic minerality, and a floral lift—Sicily’s answer to Chablis, but with a sun-kissed Mediterranean soul. This high-acid, age-worthy white is a sommelier’s secret weapon for seafood and sunshine.",
        },
        "color": "white",
        "regions": ["Sicily", "Etna"],
        "flavor_profile": ["citrus", "lemon", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Cascarolo Bianco",
        "synonyms": ["Cascarala", "Cascarecul", "Cascarelbo"],
        "description": {
            "default": "Ancient and barely surviving white variety from Piemonte.",
            "julie": "",
            "sommelier": "Cascarolo Bianco is Piemonte’s whisper from the past—a light-bodied, zesty white brimming with citrus, pear, and floral notes, all wrapped in a crisp, mineral embrace. This nearly forgotten gem is a lively companion for early evenings and classic Italian fare.",
        },
        "color": "white",
        "regions": ["Piemonte"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Casculho",
        "synonyms": ["Cascudo"],
        "description": {
            "default": "Minor northern Portuguese variety generally found in blends.",
            "julie": "",
            "sommelier": "Casculho, the unsung hero of northern Portugal, brings a medley of red and black fruits, earthy undertones, and a whisper of herbs to traditional blends—think of it as the soulful backbone in your glass, perfect for those who appreciate a medium-bodied, easygoing red with authentic regional flair.",
        },
        "color": "black",
        "regions": ["Douro", "Vinho Verde", "Trás-os-Montes", "Minho"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Casetta",
        "synonyms": ["Lambrusco a Foglia Tonda", "Lambrusco Casetta", "Maranela"],
        "description": {
            "default": "Northern Italian dark-skinned variety snatched from the jaws of extinction and making highly structured and distinctive wines.",
            "julie": "",
            "sommelier": "Once nearly lost to history, Casetta is a bold Northern Italian grape that delivers a symphony of black fruit, plum, and earthy spice, wrapped in robust tannins and a full-bodied embrace—perfect for those who crave tradition with a touch of adventure in their glass.",
        },
        "color": "black",
        "regions": ["Trentino-Alto Adige", "Veneto", "Northern Italy"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Castagnara",
        "synonyms": ["Santa Maria Nera", "Sarnese"],
        "description": {
            "default": "Low-acid Italian red wine variety improved by blending.",
            "julie": "",
            "sommelier": "Castagnara, a charming Southern Italian grape, brings together juicy red and black fruits with earthy, herbal undertones in a soft, easy-drinking style. Perfect for blending or solo sipping, it’s a delightful companion for those who appreciate tradition and a touch of rustic elegance in their glass.",
        },
        "color": "black",
        "regions": ["Campania", "Southern Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Low",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Castelão",
        "synonyms": [
            "Bastardo Castico",
            "Bastardo Espanhol",
            "Castelão Francês",
            "Castellao Portugues",
            "Castico",
            "João Santarém",
            "João de Santarém",
            "Periquita",
            "Piriquita",
            "Piriquito",
        ],
        "description": {
            "default": "Portugal’s most common variety: hardy, adaptable and widely grown under many different aliases.",
            "julie": "",
            "sommelier": "Castelão, Portugal’s chameleon grape, dazzles with a medley of plum, cherry, and earthy spice, often cloaked in hints of tobacco and leather—think of it as the country’s soulful storyteller, equally at home in a rustic blend or a polished, age-worthy red.",
        },
        "color": "black",
        "regions": ["Portugal", "Setúbal Peninsula", "Palmela", "Alentejo"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "spice",
            "earth",
            "herbal",
            "tobacco",
            "leather",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Castets",
        "synonyms": ["Engrunat", "Machouquet", "Nicouleau"],
        "description": {
            "default": "Very minor western Pyreneen variety clinging on in France; a parent in Slovakia.",
            "julie": "",
            "sommelier": "Castets is a rare Pyrenean treasure, weaving together black fruit, earthy spice, and vibrant acidity into a medium-bodied, age-worthy red that whispers of old-world tradition and untamed landscapes. A true find for those seeking the soulful depth of forgotten French vineyards.",
        },
        "color": "black",
        "regions": ["Southwest France", "Bordeaux", "Western Pyrenees", "Slovakia"],
        "flavor_profile": ["black_fruit", "plum", "earth", "mineral", "spice"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Castiglione",
        "synonyms": [
            "Castigliono",
            "Mantonico Nero",
            "Marchesana",
            "Zagarese",
            "Zagarolese",
        ],
        "description": {
            "default": "Dark-skinned Italian variety almost exclusive to Calabria and usually blended.",
            "julie": "",
            "sommelier": "Castiglione is Calabria’s secret weapon, delivering a full-bodied, high-octane red brimming with blackberries, plums, and a whisper of earthy spice—perfect for those who like their wines as bold and mysterious as an Italian midnight. Often blended, it brings depth and southern Italian swagger to the table.",
        },
        "color": "black",
        "regions": ["Calabria"],
        "flavor_profile": ["black_fruit", "spice", "earth", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "full_bodied", "traditional", "table_wine"],
    },
    {
        "name": "Catalanesca",
        "synonyms": ["Catalana", "Uva Catalana"],
        "description": {
            "default": "Very old, high-acid white Italian variety suited to both table and glass and exclusive to Campania.",
            "julie": "",
            "sommelier": "Catalanesca is Campania’s hidden gem—a high-acid, light-bodied white that dazzles with citrus, apple, and pear, finishing on a crisp, mineral note. This ancient grape is as refreshing as a Mediterranean breeze and as rare as a secret whispered in Naples.",
        },
        "color": "white",
        "regions": ["Campania"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Catanese Nero",
        "synonyms": ["Vesparola"],
        "description": {
            "default": "Minor Sicilian red variety.",
            "julie": "",
            "sommelier": "Catanese Nero is Sicily’s secret handshake—an inviting red grape that weaves together juicy red and black fruits with a whisper of spice and earth, all wrapped in a harmonious, medium-bodied frame. Perfect for early drinking, it’s a charming companion for rustic Sicilian fare and a delightful discovery for adventurous palates.",
        },
        "color": "black",
        "regions": ["Sicily"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Catarratto Bianco",
        "synonyms": [
            "Catarratteddu",
            "Catarratto",
            "Catarratto Bertolaro",
            "Catarratto Bianco Comune",
            "Catarratto Bianco Lucido",
            "Catarratto Bianco Lucido Serrato",
            "Catarratto Corteddaro",
            "Catarratto Latino",
            "Catarrattu Lu Nostrum.",
        ],
        "description": {
            "default": "Widely planted and variously named Sicilian white with potential for quality in the right hands.",
            "julie": "",
            "sommelier": "Catarratto Bianco is Sicily’s chameleon white grape, bursting with zesty citrus, crisp apple, and a whisper of stone fruit, all wrapped in a lively, mineral-driven frame—perfect for those who crave a refreshing Mediterranean escape in a glass.",
        },
        "color": "white",
        "regions": ["Sicily", "Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "apple",
            "lemon",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "medium_bodied",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Catawba",
        "synonyms": [
            "Arkansas",
            "Catawba Rosa",
            "Cherokee",
            "Francher",
            "Lincoln",
            "Mammoth Catawba",
            "Meads Seedling",
            "Mecleron",
            "Merceron",
            "Munipale Red",
            "Omega",
            "Rose of Tennessee",
            "Saratoga",
            "Singleton",
            "Tekomah",
            "Tokay",
        ],
        "description": {
            "default": "Historically important American or part-American variety that was very popular in the nineteenth century but ripens inconveniently late and is now in decline.",
            "julie": "",
            "sommelier": "Catawba is the comeback kid of American grapes—bursting with zesty red fruit, floral notes, and a spicy earthiness, this high-acid, low-tannin charmer once ruled the 19th-century wine scene and still dazzles in light, lively reds, rosés, and sparkling wines. Sip it for a taste of American wine history with a fresh, tangy twist!",
        },
        "color": "red",
        "regions": ["Ohio", "New York", "Pennsylvania", "Missouri", "North Carolina"],
        "flavor_profile": ["red_fruit", "floral", "earth", "spice"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Cavrara",
        "synonyms": [
            "Bassanese dal Peduncolo Rosso",
            "Caprara",
            "Cavarada",
            "Cavarara",
        ],
        "description": {
            "default": "Virtually extinct red of the Veneto.",
            "julie": "",
            "sommelier": "Cavrara is a rare Venetian gem, offering a harmonious medley of red and black fruits laced with earthy spice—an evocative sip of Italy’s nearly forgotten viticultural heritage. Medium-bodied and approachable, it’s a delicious time capsule for adventurous palates.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "table_wine",
            "traditional",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Çavuş",
        "synonyms": [
            "Čauš Beli",
            "Čauš Bijeli",
            "Ceaus Alb",
            "Chaouch",
            "Damascenka",
            "Feher Tökszölö",
            "Panse de Constantinople",
            "Parc de Versailles",
            "Tchaouch",
            "Tsaousi",
            "Tsaoussi",
            "Turceasca",
        ],
        "description": {
            "default": "Eastern table grape showing potential for citrus-flavoured wines in Turkey and Greece.",
            "julie": "",
            "sommelier": "Çavuş is a zesty white grape from Turkey and Greece, bursting with citrus and lemon notes, and crafted into light, unoaked wines that are as refreshing as a Mediterranean breeze. Perfect for early sipping, this grape is your passport to sun-drenched terraces and lively conversation.",
        },
        "color": "white",
        "regions": ["Turkey", "Greece"],
        "flavor_profile": ["citrus", "lemon"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Cayetana Blanca",
        "synonyms": [
            "Amor Blanco",
            "Aujubi",
            "Baladi",
            "Baladi-Verdejo",
            "Balay",
            "Belledy",
            "Blanca Cayetana",
            "Blanco Jaén",
            "Cagazal",
            "Cayetana",
            "Cazagal",
            "Charello",
            "Charelo",
            "Chaselo",
            "Cheres",
            "Cirial",
            "Dedo",
            "Dedro",
            "Djiniani",
            "Doradillo",
            "Farta Gosos",
            "Garillo",
            "Garrida",
            "Garrido",
            "Garriga",
            "Garrilla",
            "Hoja Vuelta",
            "Jaén Blanco",
            "Jaén Doradillo",
            "Jaén Empinadillo",
            "Jaén Prieto Blanco",
            "Jaenes",
            "Jainas",
            "Jarime",
            "Jean de Castilla",
            "Jean de Letur",
            "Jean de Letur de Maratella",
            "Jean Doradillo",
            "Jean Dore",
            "Jean Prieto",
            "Machuenco",
            "Maizancho",
            "Malvasia",
            "Malvoisie Espagnole",
            "Mariouti",
            "Morisco",
            "Mourisco Arsello",
            "Mourisco Branco",
            "Mourisco Portalegre",
            "Naves",
            "Naves Cazagal",
            "Neruca",
            "Padero",
            "Parda",
            "Pirulet",
            "Plateadillo",
            "Robal",
            "Sarigo",
            "Tierra de Barros",
        ],
        "description": {
            "default": "Lesser-quality Iberian variety known in Portugal as Mourisco Branco but more common in Spain under various synonyms.",
            "julie": "",
            "sommelier": "Cayetana Blanca is the chameleon of Iberian vineyards, offering crisp apple, pear, and citrus notes with a whisper of minerality—perfect for those seeking a refreshing, easygoing white that’s as versatile as its many names. Often found in blends or as a simple table wine, it’s the unsung hero of sunny Spanish and Portuguese afternoons.",
        },
        "color": "white",
        "regions": ["Spain", "Extremadura", "Andalusia", "Portugal", "Alentejo"],
        "flavor_profile": ["apple", "pear", "citrus", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "blend",
            "traditional",
        ],
    },
    {
        "name": "Cayuga White",
        "synonyms": ["Geneva White 3", "GW 3", "New York 33403", "NY 33403"],
        "description": {
            "default": "Versatile New York hybrid.",
            "julie": "",
            "sommelier": "Cayuga White is the Finger Lakes’ answer to summer in a glass: zesty, floral, and bursting with orchard fruit, this lively hybrid delivers a crisp, mineral-driven sip that’s as refreshing as a lakeside breeze. Perfect for picnics or patio sipping, it’s a crowd-pleaser that proves New York knows how to do white wine right.",
        },
        "color": "white",
        "regions": ["New York", "Finger Lakes", "Lake Erie", "Ohio", "Pennsylvania"],
        "flavor_profile": ["apple", "pear", "peach", "citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Centesimino",
        "synonyms": ["Alicante del Faentino", "Savignon Rosso", "Savignôn Rosso"],
        "description": {
            "default": "Red variety resurrected in a garden in Emilia-Romagna in the mid twentieth century.",
            "julie": "",
            "sommelier": "Centesimino, Emilia-Romagna’s garden-born gem, enchants with a medley of cherry, raspberry, and floral spice, all wrapped in a supple, medium-bodied frame. This rare varietal is a delightful conversation starter, offering a taste of Italian heritage with every sip.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Faenza"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "herbal",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Centurian",
        "synonyms": ["Centurion"],
        "description": {
            "default": "California cross as unsuccessful as its sibling Carnelian.",
            "julie": "",
            "sommelier": "Centurian is California’s bold, full-bodied underdog, offering a juicy medley of red and black fruits laced with spice and earthy undertones—perfect for those who like their table wines with a bit of swagger and a story to tell.",
        },
        "color": "black",
        "regions": ["California"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "table_wine", "full_bodied", "early_drinking"],
    },
    {
        "name": "Cerceal Branco",
        "synonyms": ["Cercial", "Cercial do Douro"],
        "description": {
            "default": "Fresh Douro variety not to be confused with Madeira’s Sercial.",
            "julie": "",
            "sommelier": "Cerceal Branco dazzles with a lively medley of citrus, apple, and mineral notes, all wrapped in a floral bouquet and zippy acidity—think of it as the Douro’s answer to a refreshing summer breeze in a glass. Perfect for those who crave a light, unoaked white that’s as invigorating as it is elegant.",
        },
        "color": "white",
        "regions": ["Douro", "Portugal"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cesanese",
        "synonyms": [
            "Bonvino Nero",
            "Cesanese Comune",
            "Cesanese di Affile",
            "Cesanese Nostrano",
            "Nero Ferrigno",
            "Sanguinella",
            "Uva di Affile",
        ],
        "description": {
            "default": "Lazio’s prime red wine grape, aromatic and difficult to ripen.",
            "julie": "",
            "sommelier": "Cesanese, Lazio’s enigmatic red, seduces with a bouquet of cherries, plums, and peppery spice, all wrapped in a medium-bodied, aromatic embrace—think of it as Italy’s best-kept secret, ready to charm your palate with every sip.",
        },
        "color": "black",
        "regions": ["Lazio", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "earth",
            "cherry",
            "plum",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "César",
        "synonyms": ["Céear", "Céelar", "Célar", "Picarniau", "Romain", "Römer"],
        "description": {
            "default": "Tannic variety playing a very minor and local role in northern Burgundy.",
            "julie": "",
            "sommelier": "César is Burgundy’s brawny, ancient rebel—packing a punch of black and red fruits, earthy spice, and pepper, all wrapped in a full-bodied, tannic embrace. Rarely seen outside Irancy, this grape brings Roman swagger and age-worthy depth to the region’s traditional reds.",
        },
        "color": "black",
        "regions": ["Northern Burgundy", "Irancy", "Yonne"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "age_worthy",
            "full_bodied",
            "table_wine",
        ],
    },
    {
        "name": "Cetinka",
        "synonyms": [
            "Blajka",
            "Blatinka",
            "Blatka",
            "Blatska",
            "Cetinjka",
            "Cetinjka Bijela",
            "Cetinka Bijela",
            "Poserača",
            "Potomkinja",
        ],
        "description": {
            "default": "Extremely rare Croatian island white.",
            "julie": "",
            "sommelier": "Cetinka is a hidden gem from Croatia’s sun-drenched Dalmatian islands, offering a breezy medley of citrus, stone fruit, and delicate florals over a crisp mineral backbone—think of it as the Adriatic in a glass, perfect for those who crave something rare and refreshingly light.",
        },
        "color": "white",
        "regions": ["Croatia", "Dalmatian Coast", "Dalmatian Islands"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Cevat Kara",
        "synonyms": [
            "Djevat Kara",
            "Dshevat-Kara",
            "Dzhevat Kara",
            "Jewath",
            "Polkovnik Kara",
        ],
        "description": {
            "default": "Southern Ukrainian variety used in fortified blends.",
            "julie": "",
            "sommelier": "Cevat Kara is the dark horse of Southern Ukraine, delivering a sumptuous symphony of black fruit, plum, and chocolate, all wrapped in a full-bodied, spicy embrace—perfect for those who crave their reds with both power and intrigue. This grape’s fortified blends are a secret handshake among connoisseurs, promising age-worthy decadence and a taste of Crimean tradition.",
        },
        "color": "black",
        "regions": ["Southern Ukraine", "Odessa", "Crimea"],
        "flavor_profile": [
            "black_fruit",
            "dried_fruit",
            "spice",
            "earth",
            "plum",
            "blackberry",
            "chocolate",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "fortified",
            "blend",
            "full_bodied",
            "traditional",
            "age_worthy",
        ],
    },
    {
        "name": "Chambourcin",
        "synonyms": ["Joannes Seyve 26-205"],
        "description": {
            "default": "French humidity-tolerant hybrid popular in the US and Australia but on the decline in its homeland.",
            "julie": "",
            "sommelier": "Chambourcin is the chameleon of the wine world—bursting with cherry, plum, and a hint of earthy spice, this French-born hybrid dazzles in everything from juicy reds to playful rosés. Medium in body and brimming with character, it’s a crowd-pleaser that thrives where others wilt, making every glass a celebration of adaptability and charm.",
        },
        "color": "black",
        "regions": ["United States", "Australia", "France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "sparkling",
            "medium_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Chancellor",
        "synonyms": ["Seibel 7053"],
        "description": {
            "default": "Minor French-American hybrid now more widely planted in North America than in France.",
            "julie": "",
            "sommelier": "Chancellor is the cosmopolitan hybrid that brings together the best of both worlds—think juicy cherries and plums mingling with earthy, herbal notes, all wrapped in a smooth, medium-bodied package. Perfect for those who like their reds approachable and lively, this grape is the Finger Lakes’ answer to easy-drinking elegance.",
        },
        "color": "black",
        "regions": [
            "New York (Finger Lakes)",
            "Ontario",
            "Pennsylvania",
            "Ohio",
            "Quebec",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "herbal",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Chardonel",
        "synonyms": ["GW 9", "NY 45010"],
        "description": {
            "default": "New York hybrid that is more hardy and productive than its Chardonnay parent, adopted in some northern US states.",
            "julie": "",
            "sommelier": "Chardonel is the winter warrior of white grapes, delivering a lively medley of apple, pear, and zesty citrus with a refreshing mineral streak—think of it as Chardonnay’s rugged, adventurous cousin, perfect for crisp, early-drinking whites or elegant sparkling wines.",
        },
        "color": "white",
        "regions": [
            "New York",
            "Missouri",
            "Indiana",
            "Illinois",
            "Ohio",
            "Pennsylvania",
        ],
        "flavor_profile": ["apple", "pear", "citrus", "floral", "mineral", "lemon"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "medium_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Chardonnay",
        "synonyms": [
            "Aubaine",
            "Auvernat",
            "Auxerrois",
            "Auxois",
            "Beaunois",
            "Chaudenay",
            "Clevner",
            "Clävner",
            "Gamay Blanc",
            "Luisant",
            "Melon à Queue Rouge",
            "Melon d’Arbois",
            "Obaideh",
            "Pinot Blanc Chardonnay",
            "Wais Edler",
            "Waiser Clevner",
        ],
        "description": {
            "default": "Hugely popular, versatile and widely planted international white variety equally capable of extreme mediocrity and regal splendour.",
            "julie": "",
            "sommelier": "Chardonnay is the ultimate shape-shifter of the wine world, dazzling with flavors from zesty citrus and green apple to creamy vanilla and tropical fruit, depending on where it’s grown and how it’s crafted. Whether you crave a lean, mineral-driven sipper or a rich, buttery showstopper, this grape always keeps you guessing—and coming back for more.",
        },
        "color": "white",
        "regions": [
            "Burgundy",
            "California",
            "Australia",
            "Champagne",
            "New Zealand",
            "South Africa",
            "Chile",
            "Oregon",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "apple",
            "pear",
            "peach",
            "lemon",
            "vanilla",
            "butter",
            "oak",
            "mineral",
            "nuts",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Charentsi",
        "synonyms": ["Charentzi"],
        "description": {
            "default": "Cold-hardy Armenian hybrid.",
            "julie": "",
            "sommelier": "Charentsi is Armenia’s spirited black grape, bursting with red and black fruit, a dash of spice, and earthy undertones—think of it as a mountain breeze in a glass, lively and ready to charm your table with its zesty acidity and rustic allure.",
        },
        "color": "black",
        "regions": ["Armenia"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Chasan",
        "synonyms": ["INRA 1527-78"],
        "description": {
            "default": "Low-acid French cross grown mainly in the Languedoc.",
            "julie": "",
            "sommelier": "Chasan is the Languedoc’s charming white, offering a bouquet of orchard fruits and delicate florals in a soft, easygoing package—perfect for those who prefer their wines fresh, friendly, and ready to pour without pretense.",
        },
        "color": "white",
        "regions": ["Languedoc", "France"],
        "flavor_profile": ["apple", "pear", "stone_fruit", "floral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "table_wine",
            "early_drinking",
            "varietal",
            "blend",
            "unoaked",
        ],
    },
    {
        "name": "Chasselas",
        "synonyms": [
            "Amber Chasselas",
            "Bar-sur-Aube",
            "Bassiraube",
            "Blanchette",
            "Bois Rouge",
            "Bon Blanc",
            "Chasselas Bianco",
            "Chasselas Blanc",
            "Chasselas Cioutat",
            "Chasselas Croquant",
            "Chasselas de Bar-Sur-Aube",
            "Chasselas de Fontainebleau",
            "Chasselas de Moissac",
            "Chasselas de Montauban",
            "Chasselas de Thomery",
            "Chasselas Dorada",
            "Chasselas Dorato",
            "Chasselas Doré",
            "Chasselas Fendant",
            "Chasselas Giclet",
            "Chasselas Jaune Cire",
            "Chasselas Musqué",
            "Chasselas Piros",
            "Chasselas Plant Droit",
            "Chasselas Queen Victoria",
            "Chasselat",
            "Dorin",
            "Elba Toro",
            "Féher Chasselas",
            "Fendant",
            "Fendant Blanc",
            "Fendant Roux",
            "Fendant Vert",
            "Franceset",
            "Franceseta",
            "Frauentraube",
            "Gelber Gutedel",
            "Gutedel",
            "Gutedel Weiss",
            "Junker",
            "Krachgutedel",
            "Lausannois",
            "Mornen",
            "Mornen Blanc",
            "Perlan",
            "Pinzutella",
            "Plemenka",
            "Plemenka Bela",
            "Queen Victoria White",
            "Rdeča Žlahtina",
            "Rougeasse",
            "Royal Muscadine",
            "Schönedel",
            "Shasla Belaya",
            "Silberling",
            "Süssling",
            "Temprana Agosteña",
            "Temprana Media",
            "Temprana Tardía",
            "Tempranillo de Nav",
            "Temprano",
            "Temprano Blanco",
            "Viviser",
            "Wälsche",
            "Weisser Gutedel",
            "Weisser Krachgutedel",
        ],
        "description": {
            "default": "French Switzerland’s characteristic variety producing soft, occasionally distinguished but often pretty ordinary, whites. Widely grown for juice and the table.",
            "julie": "",
            "sommelier": "Chasselas is Switzerland’s understated white gem, offering a gentle bouquet of white flowers, flint, and butter in its youth, and evolving into a silky, honeyed delight with age—perfect for pairing with fondue, raclette, or a lakeside catch. This grape is the quiet hero of Alpine tables, bringing a whisper of elegance to every Swiss celebration.",
        },
        "color": "white",
        "regions": [
            "Switzerland",
            "France (Loire, Alsace)",
            "Germany (Baden)",
            "Hungary",
        ],
        "flavor_profile": ["floral", "mineral", "butter", "lemon", "honey", "nuts"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Chatus",
        "synonyms": [
            "Bolgnino",
            "Bourgnin",
            "Brachet",
            "Brunetta",
            "Chanu",
            "Chatelos",
            "Chatelus",
            "Chatos",
            "Châtut",
            "Corbeil",
            "Corbel",
            "Corbelle",
            "Corbès",
            "Corbesse",
            "Mouraud",
            "Mouret",
            "Mourre",
            "Nebbiolo di Dronero",
            "Nebbiolo Pairolè",
            "Neiret",
            "Neiret Pinerolese",
            "Neretto",
            "Ouron",
            "Houron",
            "Persagne-Gamay",
            "Scarlattin",
        ],
        "description": {
            "default": "Ancient, rare tannic Ardèche variety also found in Piemonte.",
            "julie": "",
            "sommelier": "Chatus is a brooding, full-bodied relic from Ardèche, delivering a bold tapestry of plum, cherry, and blackberry woven with earthy spice and mineral notes—an ancient grape with the backbone to age and the charisma to command your attention at the table.",
        },
        "color": "black",
        "regions": ["Ardèche", "Piemonte"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Chelois",
        "synonyms": ["Seibel 10878"],
        "description": {
            "default": "French-American hybrid found in Canada and the north-eastern US; wine is rather rustic on its own.",
            "julie": "",
            "sommelier": "Chelois is the wild child of the vineyard, delivering a lively medley of cherry and raspberry with a rustic, earthy twist—perfect for those who like their reds with a dash of adventure and a nod to the untamed. This French-American hybrid shines in cool climates, offering medium-bodied, easy-drinking wines that are as charmingly unrefined as a countryside picnic.",
        },
        "color": "black",
        "regions": [
            "Canada",
            "New York",
            "Pennsylvania",
            "Vermont",
            "Ontario",
            "Quebec",
        ],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "earth",
            "herbal",
            "vegetal",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Chelva",
        "synonyms": [
            "Chelva de Cebreros",
            "Chelva de Guareña",
            "Eva",
            "Forastera Blanca",
            "Gabriela",
            "Guarena",
            "Mantúo",
            "Mantúo de Pilas",
            "Montúa",
            "Montúo de Villanueva",
            "Montúo Gordo",
            "Uva Rey",
            "Uva del Rey",
            "Uva de Puerto Real",
            "Villanueva",
        ],
        "description": {
            "default": "Spanish variety more popular for the table than for wine.",
            "julie": "",
            "sommelier": "Chelva is the life of the Spanish picnic—crisp, floral, and brimming with orchard fruit, this light-bodied grape delivers a breezy, unoaked white wine that’s as easygoing as a siesta in the Andalusian sun. Often enjoyed fresh off the vine, Chelva’s gentle acidity and low alcohol make it a delightful companion for early, carefree sipping.",
        },
        "color": "white",
        "regions": [
            "Andalusia",
            "Montilla-Moriles",
            "Cádiz",
            "Extremadura",
            "Castilla y León",
        ],
        "flavor_profile": ["apple", "pear", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Chenanson",
        "synonyms": ["Chenançon"],
        "description": {
            "default": "Montpellier cross planted to a limited extent around the Mediterranean.",
            "julie": "",
            "sommelier": "Chenanson is the Mediterranean’s best-kept secret—a supple, medium-bodied red grape that charms with a basket of red and black fruits, a whisper of herbs, and a rustic earthiness. Perfect for early drinking, it’s the ideal companion for sun-drenched afternoons and lively tables.",
        },
        "color": "black",
        "regions": [
            "France (Languedoc-Roussillon)",
            "Southern France",
            "Spain",
            "Italy (Sicily, Sardinia)",
        ],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Chenin Blanc",
        "synonyms": [
            "Agudelo",
            "Agudillo",
            "Blanc d’Aunis",
            "Capbreton Blanc",
            "Franc Blanc",
            "Gros Chenin",
            "Gros Pineau",
            "Pineau d’Anjou",
            "Pineau de la Loire",
            "Plant d’Anjou",
            "Ronchalin",
            "Rouchelein",
            "Rouchelin",
            "Steen",
        ],
        "description": {
            "default": "Loire, and South African, speciality making crisp, sometimes long-lived, wines with varying degrees of sweetness that deserve more recognition.",
            "julie": "Chenin blanc is mostly planted into two areas : France's Loire Valley and South Africa. In the Loire Valley it produces a multitude of styles - sparkling wines, dry, off-dry and sweet wines. Chenin blanc is a very versatile grape variety highly influences by the soil it grows on. Aromatically, it can displays aromas of white flowers, quince, stone fruits and honey. South Africa has the most plantings of Chenin Blanc in the world and the styles and quality of the wines produced with the grapes can varry greatly too. ",
            "sommelier": "Chenin Blanc is the ultimate shape-shifter, dazzling with everything from crisp, floral sparklers to honeyed, age-worthy treasures—think of it as the wine world’s secret superstar, equally at home in the Loire or South Africa, and always ready to surprise your palate.",
        },
        "color": "white",
        "regions": ["Loire Valley", "South Africa"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "apple",
            "pear",
            "honey",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Chichaud",
        "synonyms": ["Brunet", "Tsintsào"],
        "description": {
            "default": "Ardèche variety that can still, just, be found in southern France.",
            "julie": "",
            "sommelier": "Chichaud is a nearly forgotten gem from Ardèche, weaving together red and black fruits with earthy spice in a medium-bodied, easy-drinking red—think of it as southern France’s delicious secret, waiting to be rediscovered at your table.",
        },
        "color": "black",
        "regions": ["Ardèche", "Southern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "table_wine",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Chidiriotiko",
        "synonyms": ["Kalloniatiko"],
        "description": {
            "default": "Greek variety revived by one producer on the island of Lésvos (Lesbos).",
            "julie": "",
            "sommelier": "Chidiriotiko is Lesbos’ vinous treasure, offering a charming dance of red and black fruits, herbal whispers, and earthy depth in every sip. Medium-bodied and beautifully balanced, this revived Greek classic is a must-try for adventurous palates seeking a taste of Aegean tradition.",
        },
        "color": "black",
        "regions": ["Lesbos", "North Aegean", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Chinuri",
        "synonyms": ["Chinabuli", "Kaspura", "Kaspuri Tetri", "Okroula", "Tchinouri"],
        "description": {
            "default": "High-acid Georgian variety used for both still and sparkling wines.",
            "julie": "",
            "sommelier": "Chinuri is Georgia’s zippy white gem, bursting with citrus and apple, and a mineral streak that dances on the palate—perfect for those who crave a crisp, floral spark in their glass. Whether still or sparkling, it’s a lively companion to any table, channeling the ancient terroir of Kartli with every sip.",
        },
        "color": "white",
        "regions": ["Georgia", "Kartli"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Chkhaveri",
        "synonyms": ["Tchkhaveri", "Vanis Chkhaveri"],
        "description": {
            "default": "Minor but versatile pink-skinned Georgian variety.",
            "julie": "",
            "sommelier": "Chkhaveri is Georgia’s playful pink-skinned charmer, delivering a lively medley of cherry, raspberry, and floral notes with a whisper of spice and earth. Light on its feet and brimming with character, it’s the perfect companion for those seeking a fresh, unoaked adventure in their glass.",
        },
        "color": "pink",
        "regions": ["Georgia", "Guria", "Adjara"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "red",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Chondromavro",
        "synonyms": [
            "Chondromavrouda",
            "Chondromavroudi",
            "Chondromavroudo",
            "Khondromavroud",
        ],
        "description": {
            "default": "Very rare Greek variety planted in Makedonía.",
            "julie": "",
            "sommelier": "Chondromavro is a hidden gem from Northern Greece, weaving together red and black fruits with a spicy, earthy undertone in a perfectly balanced, medium-bodied frame. This rare variety is a must-try for adventurous wine lovers seeking a taste of Greek tradition and terroir.",
        },
        "color": "black",
        "regions": ["Makedonía", "Northern Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Chouchillon",
        "synonyms": ["Faux Viognier"],
        "description": {
            "default": "Light-skinned variety recently rescued in central France.",
            "julie": "",
            "sommelier": 'Chouchillon, the "Faux Viognier" of central France, delights with a bouquet of spring flowers and juicy stone fruits, offering a crisp, light-bodied sip that\'s as rare as it is refreshing. This rescued gem is perfect for those who crave a playful, aromatic white with a whisper of French countryside charm.',
        },
        "color": "white",
        "regions": ["Central France", "Loire Valley", "Auvergne"],
        "flavor_profile": ["floral", "stone_fruit", "pear", "peach", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Cianorie",
        "synonyms": [
            "Canore",
            "Canorie",
            "Chianorie",
            "Cianoria",
            "Cjanorie",
            "Rossarie",
            "Vinosa",
        ],
        "description": {
            "default": "Old and very minor dark-skinned variety from Friuli, north-east Italy.",
            "julie": "",
            "sommelier": "Cianorie is Friuli’s secret handshake—a whisper of red and black fruit, herbs, and earth in a light-bodied, unoaked red that’s as charmingly rustic as a countryside picnic. This rare grape invites you to taste the old-world soul of northeast Italy, one glass at a time.",
        },
        "color": "black",
        "regions": ["Friuli", "Friuli-Venezia Giulia", "Northeast Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ciliegiolo",
        "synonyms": [
            "Albana Nera",
            "Brunellone",
            "Canaiolo Romano",
            "Ciliegino",
            "Ciliegiolo di Spagna",
            "Mazzèse",
            "Riminese Nero",
            "Sangiovese Polveroso",
        ],
        "description": {
            "default": "Cherry-flavoured Italian red with untapped potential, especially in Toscana. Parent of Sangiovese.",
            "julie": "",
            "sommelier": "Ciliegiolo is Tuscany’s juicy secret, bursting with cherry and floral notes, and a gentle spice that dances on the palate—think of it as Sangiovese’s charming parent, ready to steal the spotlight in any glass. This medium-bodied red is perfect for those who crave Italian tradition with a playful, fruit-forward twist.",
        },
        "color": "black",
        "regions": ["Tuscany", "Umbria", "Liguria", "Central Italy"],
        "flavor_profile": ["red_fruit", "cherry", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Cinsaut",
        "synonyms": [
            "Black Malvoisie",
            "Black Prince",
            "Blue Imperial",
            "Cinqsaut",
            "Cinq-saou",
            "Cinsault",
            "Grecaù",
            "Grecu Masculinu",
            "Hermitage",
            "Marroquin",
            "Marrouquin",
            "Ottavianello",
            "Picardan Noir",
            "Piquepoul d’Uzès",
            "Prunelat",
            "Prunellas",
            "Sinsó",
            "Sinsón",
            "Sinseur",
            "Uva Spina",
        ],
        "description": {
            "default": "Underrated Mediterranean-loving variety making characterful rosés and flirtatious reds.",
            "julie": "Cinsault thrives in mediterranean climates and produces red wines that are soft, elegant, fruity and aromatic as well as fersh and perfumed rosé wines.",
            "sommelier": "Cinsaut is the Mediterranean’s secret charmer, delivering flirtatious reds and breezy rosés bursting with raspberry, cherry, and a whisper of herbs. With its soft tannins and aromatic flair, this grape is the life of the party—always fresh, always inviting.",
        },
        "color": "black",
        "regions": [
            "Languedoc",
            "Provence",
            "Southern Rhône",
            "South Africa",
            "Lebanon",
            "Morocco",
            "Chile",
        ],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "herbal",
            "spice",
            "raspberry",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ciurlese",
        "synonyms": ["Ciurlès"],
        "description": {
            "default": "Virtually extinct white from around Rimini in northern Italy.",
            "julie": "",
            "sommelier": "Once nearly lost to time, Ciurlese is a zippy, feather-light white from Rimini, bursting with citrus and stone fruit, and a whisper of wildflowers—think of it as a crisp Italian breeze in a glass, perfect for early sipping and lively conversation.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Rimini", "Northern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Cividin",
        "synonyms": ["Cividin Bianco", "Cividino"],
        "description": {
            "default": "Ancient, rare white from Friuli, north-east Italy.",
            "julie": "",
            "sommelier": "Cividin is Friuli’s hidden gem—a zesty, light-bodied white bursting with citrus, pear, and floral notes, all wrapped in a crisp mineral finish. This rare varietal is a lively sip of Italian tradition, perfect for those who crave freshness and a taste of history in their glass.",
        },
        "color": "white",
        "regions": ["Friuli", "Friuli-Venezia Giulia", "Northeast Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Clairette",
        "synonyms": [
            "Blanc Laffite",
            "Blanquette",
            "Clairet",
            "Clarette",
            "Clairette Blanche",
            "Fehér Clairette",
            "Kleret",
            "Kleret Belyi",
            "Muscade",
            "Oeillade Blanche",
            "Osianka",
            "Ovsyanka",
            "Petit Blanc",
            "Petit Kleret",
            "Uva Gijona",
            "Vivsyanka",
        ],
        "description": {
            "default": "Once very popular and now useful, crisp southern French white.",
            "julie": "",
            "sommelier": "Clairette is the zesty belle of southern France, offering a crisp medley of citrus, pear, and floral notes with a mineral edge—perfect for a sun-drenched afternoon or a sparkling celebration. Light-bodied and lively, this grape brings a refreshing, early-drinking charm to both blends and varietal wines.",
        },
        "color": "white",
        "regions": [
            "Southern Rhône",
            "Languedoc",
            "Provence",
            "Clairette de Die (Drôme)",
            "South Africa",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "herbal",
            "mineral",
            "apple",
            "pear",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Claverie",
        "synonyms": [
            "Bouguieu",
            "Chalosse Blanche",
            "Chaloussenc",
            "Clabarien",
            "Clabérieu",
            "Claverie Blanc",
            "Claverie Verte",
            "Galia Zuria",
        ],
        "description": {
            "default": "Virtually extinct, disease-prone white from south-west France.",
            "julie": "",
            "sommelier": "Claverie is a ghostly gem from Gascony, offering a whisper of citrus, apple, and wildflowers in a feather-light, unoaked frame—perfect for those who seek a taste of French tradition nearly lost to time. Sip it young and imagine the sun-dappled vineyards of south-west France, where this rare grape once flourished.",
        },
        "color": "white",
        "regions": ["South-West France", "Gascony", "Landes"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Clinton",
        "synonyms": [
            "Bacchus",
            "Clinton Rose",
            "Klinton",
            "Plant des Carmes",
            "Plant Pouzin",
            "Vorthington",
            "Worthington",
            "Zephirin",
        ],
        "description": {
            "default": "Pre-Civil War natural American hybrid of historical interest only.",
            "julie": "",
            "sommelier": "Clinton is a charmingly eccentric relic of American viticultural history, offering a light-bodied, unoaked red with notes of black fruit, earthy spice, and a whisper of wild vegetation—perfect for adventurous palates seeking a taste of the past. This grape’s journey from pre-Civil War America to European vineyards is as intriguing as its rustic, early-drinking wines.",
        },
        "color": "black",
        "regions": [
            "Eastern United States",
            "France (Loire, Ardèche)",
            "Northern Italy (Veneto, Friuli)",
            "Austria",
            "Switzerland",
        ],
        "flavor_profile": ["black_fruit", "earth", "vegetal", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "table_wine",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Cococciola",
        "synonyms": ["Cacciola", "Cocacciara"],
        "description": {
            "default": "Fruity, herbal white from Abruzzo and Puglia.",
            "julie": "",
            "sommelier": "Cococciola dazzles with a burst of citrus and crisp apple, underscored by a whisper of herbs—think of it as Italy’s answer to a summer breeze in a glass, light-bodied and vivacious, perfect for sipping on sun-drenched afternoons.",
        },
        "color": "white",
        "regions": ["Abruzzo", "Puglia"],
        "flavor_profile": ["citrus", "apple", "herbal"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Coda Di Cavallo Bianca",
        "synonyms": ["Cavalla", "Codacavallo"],
        "description": {
            "default": "Barely cultivated and generally blended white variety from Campania, southern Italy.",
            "julie": "",
            "sommelier": "Coda Di Cavallo Bianca is Campania’s hidden gem—a whisper of citrus, stone fruit, and wildflowers, dancing lightly across the palate with a mineral-laced finish. Rarely found solo, this grape brings a refreshing, sun-kissed elegance to southern Italian blends.",
        },
        "color": "white",
        "regions": ["Campania", "Southern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Coda Di Volpe Bianca",
        "synonyms": ["Durante", "Falerno", "Guarnaccia Bianca"],
        "description": {
            "default": "Ancient, full-bodied white from southern Italy coming into its own as a varietal wine.",
            "julie": "",
            "sommelier": "Coda Di Volpe Bianca is Campania’s golden secret, offering a voluptuous, full-bodied white wine brimming with juicy stone fruit, pear, and a whisper of mineral elegance. This ancient grape delivers a sun-kissed Italian embrace in every glass—perfect for those who crave both tradition and flavor.",
        },
        "color": "white",
        "regions": ["Campania", "Southern Italy", "Benevento", "Avellino", "Naples"],
        "flavor_profile": ["stone_fruit", "pear", "peach", "citrus", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Côdega De Larinho",
        "synonyms": ["Côdega do Larinho"],
        "description": {
            "default": "Very fruity but soft variety from north-east Portugal.",
            "julie": "",
            "sommelier": "Côdega De Larinho is Portugal’s charming white grape, offering a bouquet of citrus, pear, and delicate florals in a light, breezy package—perfect for sipping on a sun-drenched terrace. Its gentle fruitiness and soft texture make it a delightful companion for early drinking and lively conversation.",
        },
        "color": "white",
        "regions": ["Douro", "Trás-os-Montes", "Beira Interior"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Codivarta",
        "synonyms": ["Codivarte Blanc", "Codivertola Blanc", "Cudiverta"],
        "description": {
            "default": "Soft northern Corsican.",
            "julie": "",
            "sommelier": "Codivarta is Corsica’s breezy white gem, offering a lively medley of citrus, stone fruit, and delicate florals over a whisper of minerality—perfect for those seeking a light, unoaked wine that captures the island’s sunlit spirit in every glass.",
        },
        "color": "white",
        "regions": ["Corsica", "France"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Colobel",
        "synonyms": ["Seibel 8357"],
        "description": {
            "default": "Almost extinct French hybrid that can make very dark but astringent reds.",
            "julie": "",
            "sommelier": "Colobel is a nearly forgotten French hybrid that delivers brooding black fruit and earthy, vegetal notes wrapped in a cloak of deep color and robust tannins—think of it as the mysterious stranger at the wine party, intriguing but not for the faint of heart.",
        },
        "color": "black",
        "regions": ["Southwest France", "Loire Valley", "France (general)"],
        "flavor_profile": ["black_fruit", "earth", "vegetal"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Colombard",
        "synonyms": [
            "Colombar",
            "Colombier",
            "French Colombard",
            "Queue Tendre",
            "Tourterelle",
        ],
        "description": {
            "default": "Productive workhorse variety now more valued for easy-drinking blended whites than for brandy.",
            "julie": "",
            "sommelier": "Colombard is the life of the party in the white wine world—zippy, citrusy, and bursting with apple and tropical fruit, it delivers a refreshing, floral lift with every sip. Once a brandy workhorse, this grape now charms in light, unoaked wines perfect for sunny afternoons and carefree gatherings.",
        },
        "color": "white",
        "regions": [
            "Southwest France",
            "Gascony",
            "California",
            "South Africa",
            "Australia",
        ],
        "flavor_profile": ["citrus", "apple", "pear", "tropical_fruit", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Colombaud",
        "synonyms": ["Aubié", "Colombaud du Var"],
        "description": {
            "default": "Ancient but virtually extinct white related to the Swiss variety Humagne.",
            "julie": "",
            "sommelier": "Colombaud is a rare gem from Provence, offering a whisper of history in every sip—think delicate stone fruit and pear, a floral breeze, and a mineral finish, all wrapped in a light, refreshing frame. This nearly extinct variety is a true treat for adventurous palates seeking a taste of the past.",
        },
        "color": "white",
        "regions": ["Provence", "Var (France)", "Switzerland"],
        "flavor_profile": ["stone_fruit", "floral", "mineral", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Colorino Del Valdarno",
        "synonyms": ["Colore", "Colorino"],
        "description": {
            "default": "Rare, dark-skinned Tuscan variety often confused with others called Colorino Something and especially useful for adding colour to blends.",
            "julie": "",
            "sommelier": "Colorino Del Valdarno is Tuscany’s secret weapon, lending brooding color and bold tannins to blends, while its flavors of blackberry, plum, and earthy spice make it a full-bodied, age-worthy delight for adventurous red wine lovers.",
        },
        "color": "black",
        "regions": ["Tuscany", "Italy"],
        "flavor_profile": ["black_fruit", "spice", "earth", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "age_worthy", "full_bodied"],
    },
    {
        "name": "Completer",
        "synonyms": ["Lindauer", "Malanstraube", "Zürirebe"],
        "description": {
            "default": "Rare Swiss variety making very distinctive, ageworthy whites.",
            "julie": "",
            "sommelier": "Completer is Switzerland’s vinous hidden gem, weaving together vibrant stone fruit, wildflower, and honeyed nut flavors into a tapestry of high-acid, ageworthy elegance—think of it as the alpine answer to white Burgundy, but with a Swiss passport and a flair for the extraordinary.",
        },
        "color": "white",
        "regions": ["Switzerland", "Graubünden"],
        "flavor_profile": ["stone_fruit", "floral", "mineral", "honey", "nuts"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "varietal", "premium", "age_worthy"],
    },
    {
        "name": "Concord",
        "synonyms": [
            "Bull’s Seedling",
            "Corin",
            "Cornin",
            "Dalmadin",
            "Feherhatu",
            "Fekete Noah",
            "Furmin Noir",
            "Gorin",
            "Gurin",
            "Kek Olasz",
            "Konkordi",
            "Konkordia",
            "Nyarfalevelue",
            "Nyarlevelue",
            "Olasz Kek",
        ],
        "description": {
            "default": "America’s own grape. Winter-hardy, Massachusetts hybrid planted more for jelly and juice than for wine.",
            "julie": "",
            "sommelier": "Concord is the all-American classic, bursting with nostalgic flavors of grape jelly, black fruit, and a hint of earthiness—think childhood picnics in a glass. Light-bodied and zippy, this grape delivers a playful, juicy sip that’s as charmingly unpretentious as a summer fair.",
        },
        "color": "black",
        "regions": [
            "United States",
            "New York",
            "Massachusetts",
            "Pennsylvania",
            "Ohio",
            "Michigan",
        ],
        "flavor_profile": ["black_fruit", "red_fruit", "earth", "dried_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cordenossa",
        "synonyms": ["Cordenos"],
        "description": {
            "default": "Recently rescued and still rare Friulian red.",
            "julie": "",
            "sommelier": "Cordenossa is Friuli’s hidden gem—a black grape recently rescued from obscurity, offering a harmonious medley of red and black fruits, earthy undertones, and a whisper of spice. Medium in every measure, it’s a versatile charmer that brings a taste of Italian tradition to the modern table.",
        },
        "color": "black",
        "regions": ["Friuli-Venezia Giulia", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "traditional", "table_wine", "premium"],
    },
    {
        "name": "Cornalin",
        "synonyms": [
            "Broblanc",
            "Cargnola",
            "Cornalin d’Aoste",
            "Cornalino",
            "Cornallin",
            "Corniola",
            "Humagne Rouge",
        ],
        "description": {
            "default": "Ancient red from the Valle d’Aosta in northern Italy, widespread in the Valais in Switzerland as Humagne Rouge.",
            "julie": "",
            "sommelier": "Cornalin is a storied red grape from the Alpine valleys, offering a lively medley of cherry, blackberry, and spice, all wrapped in a floral, earthy embrace—think of it as the mountain climber of wines: robust, refreshing, and full of character. This high-acid, medium-bodied gem is a must-try for those seeking a taste of Alpine tradition with a modern twist.",
        },
        "color": "black",
        "regions": ["Valais", "Valle d'Aosta"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "blackberry",
            "spice",
            "earth",
            "floral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Cornarea",
        "synonyms": ["Incrocio Dalmasso IV/28"],
        "description": {
            "default": "Obscure dark-skinned Italian cross whose true parentage has only recently been revealed.",
            "julie": "",
            "sommelier": "Cornarea is Piedmont’s enigmatic black beauty, weaving together juicy cherries and plums with earthy, mineral undertones in a medium-bodied embrace—perfect for those who love a touch of mystery in their glass. This recently unmasked Italian cross is a delightful companion for early drinking, whether solo or in a blend.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "table_wine",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Cornifesto",
        "synonyms": [
            "Cornifeito",
            "Cornifesta",
            "Cornifesto no Dao",
            "Cornifesto Tinto",
            "Cornifresco",
            "Tinta Bastardeira",
        ],
        "description": {
            "default": "Minor Douro variety used for both port and unfortified wines.",
            "julie": "",
            "sommelier": "Cornifesto is the Douro’s unsung hero, lending a charming medley of red and black fruits, earthy undertones, and a dash of spice to both robust ports and everyday reds. With its balanced structure and rustic allure, this grape is a delightful secret in Portugal’s vinous tapestry.",
        },
        "color": "black",
        "regions": ["Douro", "Dão"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "fortified", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Corot Noir",
        "synonyms": ["NY 70.0809.10"],
        "description": {
            "default": "Minor hybrid bred in upstate New York for the eastern US.",
            "julie": "",
            "sommelier": "Corot Noir is the Finger Lakes’ answer to a juicy, fruit-forward red, bursting with cherry, plum, and raspberry, all wrapped in a gentle herbal earthiness. This easygoing, medium-bodied hybrid is perfect for those seeking a fresh, approachable table wine with a distinctly American twist.",
        },
        "color": "black",
        "regions": ["New York", "Eastern United States", "Finger Lakes", "Lake Erie"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Cortese",
        "synonyms": ["Corteis", "Courteis", "Courtesia"],
        "description": {
            "default": "Generally rather bland northern-Italian white that shows its best varietal face in Gavi.",
            "julie": "",
            "sommelier": "Cortese, the star of Gavi, dazzles with zesty citrus, green apple, and a mineral snap, making it northern Italy’s answer to thirst-quenching, high-acid whites. Light-bodied and lively, it’s the perfect companion for a sunny afternoon or a plate of fresh seafood.",
        },
        "color": "white",
        "regions": ["Piedmont", "Gavi", "Alessandria", "Northern Italy"],
        "flavor_profile": ["citrus", "lemon", "apple", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Corvina Veronese",
        "synonyms": [
            "Corvina Comune",
            "Corvina Gentile",
            "Corvina Nostrana",
            "Corvina Reale",
            "Cruina",
            "Corvina",
        ],
        "description": {
            "default": "Bright, fresh, cherry-scented red encountered most often in Valpolicella and Bardolino.",
            "julie": "Corvina is a grape variety found in the Veneto region of Italy and which is typically blended with Rondinella and Molinara to producer Valpolicella, Bardolino and Amarone wines. When not blended, Corvina gives wines which are light-bodied, with fresh acidity, moderate tannins and sour cherry flavours. ",
            "sommelier": "Corvina Veronese is the zesty, cherry-charged heart of Veneto, delivering a lively, light-bodied red with a tangy twist—think of it as the Italian answer to a summer breeze in a glass, equally at home in a casual blend or as a solo star.",
        },
        "color": "black",
        "regions": ["Veneto", "Valpolicella", "Bardolino"],
        "flavor_profile": ["red_fruit", "cherry"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Corvinone",
        "synonyms": ["Corvinon", "Cruinon"],
        "description": {
            "default": "A dark-skinned variety with fresh acidity that contributes to Veneto blends.",
            "julie": "Corvinone is a red grape variety, with bright acidity, that contributes to blends in the region of Veneto. It can replace a percentage of the Corvina grape for Valpolicella and Amaron wines.",
            "sommelier": "Corvinone is Veneto’s secret weapon, lending a zesty lift and a tapestry of cherry, plum, and earthy spice to classic blends like Amarone. With its vibrant acidity and medium body, this grape brings both freshness and depth, making every sip a lively Italian adventure.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "dried_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Cot",
        "synonyms": [
            "Agreste",
            "Auxerrois",
            "Bouyssales",
            "Cagors",
            "Coq Rouge",
            "Cor",
            "Cors",
            "Cos",
            "Côt",
            "Cots",
            "Estrangey",
            "Étranger",
            "Lutkens",
            "Malbec",
            "Malbeck",
            "Malbech",
            "Mancin",
            "Nuar de Presac",
            "Pied de Perdrix",
            "Pressac",
            "Noir de Pressac",
            "Prunelat",
            "Quercy",
        ],
        "description": {
            "default": "Makes dark, flavoursome, well-structured reds more celebrated as Argentine Malbec than in its home Cahors.",
            "julie": "Better known as Malbec, Cot is originally from the region of Cahors in Southwest France. Today, modern Cahors can be incredible pure, bright and mineral balancing structure and fruit yumminess. The biggest success of Malbec however, resides in Argentina, especially in the region of Mendoza where Malbec has become a super-star variety. There, the wines produces are full-bodied, smooth and packed with blue fruits and spiciness. The grape particularly stives in the high alitude vineyards of sub-regions such as the Uco Valley where it can express more elegance and minerality. ",
            "sommelier": "Cot, or Malbec, is the brooding rockstar of the wine world—delivering inky, full-bodied reds bursting with blue fruits, spice, and a mineral edge, whether from its rustic French homeland or the sun-drenched heights of Argentina. Expect a glass that’s as bold and structured as it is irresistibly smooth, perfect for those who like their wines with both muscle and finesse.",
        },
        "color": "black",
        "regions": ["Cahors", "Southwest France", "Mendoza", "Uco Valley", "Argentina"],
        "flavor_profile": [
            "blue_fruit",
            "spice",
            "mineral",
            "earth",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Couderc Noir",
        "synonyms": ["Contassot 20", "Couderc 7120", "Plant Verni"],
        "description": {
            "default": "Undistinguished French hybrid with few remaining fans.",
            "julie": "",
            "sommelier": "Couderc Noir is the wallflower of French hybrids—light-bodied, low in alcohol, and brimming with red and black fruit, earthy, and vegetal notes, it offers a simple, rustic charm best enjoyed young and without pretense. A rare find for the adventurous, this grape whispers of the Loire and Southwest France’s forgotten vineyards.",
        },
        "color": "black",
        "regions": ["France", "Loire Valley", "Southwest France"],
        "flavor_profile": ["red_fruit", "black_fruit", "vegetal", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Counoise",
        "synonyms": [
            "Coneze",
            "Connoges",
            "Connoise",
            "Counèse",
            "Counoïse",
            "Counoïso",
            "Counoueiso",
            "Guénoise",
            "Quenoise",
            "Rivier",
        ],
        "description": {
            "default": "Minor but valued southern Rhône ingredient, occasional varietal.",
            "julie": "",
            "sommelier": "Counoise is the Rhône’s charming underdog, bringing a lively medley of raspberry, cherry, and pepper to blends and varietals alike—think of it as the zesty, floral friend who keeps the party fresh and the palate dancing. With high acidity and a light, easy-drinking style, it’s the perfect companion for those who crave a spirited, early-drinking red with a touch of southern French flair.",
        },
        "color": "black",
        "regions": ["Southern Rhône", "Provence", "Languedoc", "California"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "herbal",
            "spice",
            "raspberry",
            "cherry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Courbu Blanc",
        "synonyms": [
            "Courbeau",
            "Courbi",
            "Courbis Blanc",
            "Courbu",
            "Courbut Blanc",
            "Courtoisie",
            "Vieux Pacherenc",
        ],
        "description": {
            "default": "Minor variety often consorting with the Mansengs in French Basque Country.",
            "julie": "",
            "sommelier": "Courbu Blanc is the secret handshake of the French Basque vineyards—zesty, floral, and honeyed, with a mineral backbone and a lively acidity that makes every sip feel like a sunlit stroll through a mountain orchard. Whether in a crisp blend or a nuanced dessert wine, this grape brings a touch of old-world intrigue to your glass.",
        },
        "color": "white",
        "regions": [
            "Southwest France",
            "French Basque Country",
            "Jurançon",
            "Pacherenc du Vic-Bilh",
        ],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "honey", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "unoaked",
            "oaked",
            "traditional",
            "age_worthy",
            "early_drinking",
            "table_wine",
            "dessert",
        ],
    },
    {
        "name": "Courbu Noir",
        "synonyms": ["Courbu Rouge", "Courbut", "Dolceolo", "Noir du Pays"],
        "description": {
            "default": "Virtually extinct speciality of Béarn, south-west France, unrelated to Courbu Blanc.",
            "julie": "",
            "sommelier": "Courbu Noir is Béarn’s elusive black pearl—an almost forgotten grape yielding medium-bodied reds brimming with red and black fruit, earthy spice, and a whisper of rustic charm. Sip it for a taste of French wine history, as rare as it is rewarding.",
        },
        "color": "black",
        "regions": ["Béarn", "South-West France"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "traditional",
            "varietal",
            "blend",
            "age_worthy",
        ],
    },
    {
        "name": "Crâmpoșie Selecţionată",
        "synonyms": ["Crîmpoșie Selecţionată"],
        "description": {
            "default": "High-quality, high-acid Romanian variety producing zesty, mineral-laden whites.",
            "julie": "",
            "sommelier": "Crâmpoșie Selecţionată is Romania’s zesty answer to summer thirst, bursting with citrus, white flowers, and a stony minerality that dances across the palate. Light-bodied and lively, it’s the perfect companion for a sun-drenched afternoon or a plate of fresh seafood.",
        },
        "color": "white",
        "regions": ["Romania", "Oltenia", "Muntenia"],
        "flavor_profile": ["citrus", "mineral", "floral", "stone_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Criolla Grande",
        "synonyms": ["Criolla Grande Sanjuanina"],
        "description": {
            "default": "Declining but still very widely planted Argentine pink-skinned variety making humdrum wine.",
            "julie": "",
            "sommelier": "Criolla Grande is Argentina’s unsung hero, delivering cheerful red and rosé wines bursting with red fruit, floral, and herbal notes—think of it as the laid-back cousin at the family reunion, always ready to please but never stealing the spotlight. Light-bodied and easygoing, it’s the perfect companion for a sunny afternoon or a casual gathering.",
        },
        "color": "red",
        "regions": ["Argentina", "San Juan", "Mendoza"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Croatina",
        "synonyms": [
            "Bonarda",
            "Bonarda di Rovescala",
            "Crovattina",
            "Nebbiolo di Gattinara",
            "Neretto",
            "Spanna-Nebbiolo",
            "Uga del Zio",
            "Uva Vermiglia",
        ],
        "description": {
            "default": "A fruity dark-skinned variety grown in many different areas of northern Italy and used both solo and in blends.",
            "julie": "",
            "sommelier": "Croatina, the chameleon of northern Italy, dazzles with juicy black fruit, plum, and a whisper of spice, making it equally at home in rustic blends or as a solo star. With its medium body and earthy undertones, this grape brings a lively, approachable charm to both everyday tables and cellars alike.",
        },
        "color": "black",
        "regions": [
            "Lombardy",
            "Emilia-Romagna",
            "Piedmont",
            "Oltrepò Pavese",
            "Colli Piacentini",
        ],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
            "age_worthy",
        ],
    },
    {
        "name": "Crouchen",
        "synonyms": [
            "Cape Riesling",
            "Clare Riesling",
            "Cougnet",
            "Cruchen Blanc",
            "Cruchenta",
            "Messanges Blanc",
            "Paarl Riesling",
            "Sable Blanc",
            "Trouchet Blanc",
        ],
        "description": {
            "default": "Widely travelled neutral French variety from the western Pyrenees that for long benefited from naming confusion.",
            "julie": "",
            "sommelier": "Crouchen, the globe-trotting master of disguise (often masquerading as Cape Riesling), delivers a crisp, refreshing white wine brimming with apple, pear, and citrus notes over a subtle mineral backbone—perfect for those who love their wines light, lively, and full of intrigue.",
        },
        "color": "white",
        "regions": ["South Africa", "Australia", "France (Southwest)"],
        "flavor_profile": ["apple", "pear", "mineral", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Crovassa",
        "synonyms": ["Croassa"],
        "description": {
            "default": "Very minor red variety in the Valle d’Aosta.",
            "julie": "",
            "sommelier": "Crovassa is Valle d’Aosta’s hidden gem, offering a delicate dance of red fruit, wild herbs, and earthy florals in a light-bodied, easy-drinking red—perfect for those who crave a taste of Alpine tradition off the beaten path.",
        },
        "color": "black",
        "regions": ["Valle d'Aosta"],
        "flavor_profile": ["red_fruit", "herbal", "earth", "floral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Csaba Gyöngye",
        "synonyms": [
            "Cabski Biser",
            "Csabagyöngye",
            "Julski Muskat",
            "Pearl of Csaba",
            "Perl do Saba",
            "Perla Czabanska",
            "Perla di Csaba",
            "Perle de Csaba",
            "Perle von Csaba",
            "Rindunicaz Strugurilor",
            "Vengerskii Muskatnii Rannüj",
            "Zemcug Saba",
        ],
        "description": {
            "default": "Hungarian table grape occasionally turned into light, grapey whites.",
            "julie": "",
            "sommelier": 'Csaba Gyöngye, or "Pearl of Csaba," is a Hungarian gem that dazzles with floral aromas and juicy stone fruit, delivering a light, refreshing sip perfect for summer afternoons. Whether enjoyed as a table grape or in a crisp, unoaked white, it’s a playful nod to the joys of early drinking.',
        },
        "color": "white",
        "regions": ["Hungary", "Romania", "Slovakia"],
        "flavor_profile": ["floral", "stone_fruit", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Csókaszőlő",
        "synonyms": [
            "Csóka Szőlő",
            "Csóka",
            "Fekete Magyarka",
            "Kleinhungar Blauer",
            "Magyarka Neagra",
            "Rácfekete",
            "Vadfekete",
        ],
        "description": {
            "default": "Old Hungarian variety in the throes of rediscovery.",
            "julie": "",
            "sommelier": "Once nearly forgotten, Csókaszőlő is Hungary’s comeback kid, delivering a lively dance of cherry, plum, and earthy spice with a zesty acidity that keeps you coming back for more. This medium-bodied red is a delicious bridge between tradition and innovation—perfect for adventurous palates and history buffs alike.",
        },
        "color": "black",
        "regions": ["Hungary", "Eger", "Mátra", "Bükk", "Szekszárd"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Dafni",
        "synonyms": ["Dafnia", "Daphni", "Daphnia"],
        "description": {
            "default": "Distinctively laurel-scented variety from Kríti (Crete) recently rescued from oblivion.",
            "julie": "",
            "sommelier": "Dafni is Crete’s aromatic treasure, wafting laurel and wild herbs from your glass like a Mediterranean breeze. With zesty acidity and a mineral backbone, this revived classic is a refreshing ode to Greek tradition—perfect for adventurous palates seeking something truly unique.",
        },
        "color": "white",
        "regions": ["Crete", "Greece"],
        "flavor_profile": ["herbal", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Dakapo",
        "synonyms": ["Geisenheim 7225-8"],
        "description": {
            "default": "Red-fleshed German cross adds colour to blends.",
            "julie": "",
            "sommelier": "Dakapo is Germany’s secret weapon for vibrant blends, infusing wines with a juicy burst of cherry, plum, and raspberry, all wrapped in a spicy, earthy embrace. With its balanced structure and playful fruitiness, it’s the life of the party in any glass—perfect for those who love their reds lively and approachable.",
        },
        "color": "black",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Dalkauer",
        "synonyms": ["Beutelrebe"],
        "description": {
            "default": "Rare German offspring of Riesling and A N Other.",
            "julie": "",
            "sommelier": "Dalkauer is a zesty German rarity, bursting with citrus, pear, and floral notes, and a racy acidity that dances on the palate. Think of it as Riesling’s enigmatic cousin—light, mineral-driven, and perfect for those who crave a crisp, refreshing white with a touch of intrigue.",
        },
        "color": "white",
        "regions": ["Germany"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Damaschino",
        "synonyms": [
            "Alicante Branco",
            "Beldi",
            "Damaschena",
            "Farana  orFaranah",
            "Farranah",
            "Mayorquin",
            "Planta Fina",
            "Planta Fina de Pedralba",
            "Planta Pedralba",
        ],
        "description": {
            "default": "Ancient but neutral white included in blends around the Mediterranean and in Portugal.",
            "julie": "",
            "sommelier": "Damaschino is the unsung hero of Mediterranean blends, offering a whisper of stone fruit and apple over a mineral backbone—think of it as the elegant supporting actor that lets the stars shine, yet leaves a lasting impression of freshness and tradition.",
        },
        "color": "white",
        "regions": ["Sicily", "Portugal", "Spain", "North Africa", "Mediterranean"],
        "flavor_profile": ["stone_fruit", "mineral", "apple"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "De Chaunac",
        "synonyms": ["Cameo", "Seibel 9549"],
        "description": {
            "default": "French hybrid now at home in Canada and New York State.",
            "julie": "",
            "sommelier": "De Chaunac is the plucky French hybrid that’s made itself at home in the chilly vineyards of Canada and New York, offering up a lively medley of plum, cherry, and earthy notes in a smooth, easy-drinking style. Perfect for those who like their reds fresh, fruity, and ready to pour at a moment’s notice!",
        },
        "color": "black",
        "regions": ["Canada", "New York State", "Ontario", "Quebec", "Finger Lakes"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "vegetal",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Debina",
        "synonyms": ["Debina Metsovou", "Debina Palea", "Dempina", "Ntempina"],
        "description": {
            "default": "Highly localized, high-acid Greek variety making light, fresh and digestible wines.",
            "julie": "",
            "sommelier": "Debina is Greece’s zesty secret, delivering a vivacious burst of citrus, apple, and pear with a mineral snap—think of it as a mountain breeze in a glass, perfect for sparkling or light, unoaked whites that dance on the palate.",
        },
        "color": "white",
        "regions": ["Epirus", "Zitsa", "Greece"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Debine E Bardhë",
        "synonyms": ["Debin"],
        "description": {
            "default": "Declining Albanian of mysterious origin.",
            "julie": "",
            "sommelier": "Debine E Bardhë is Albania’s elusive white gem, offering a breezy medley of citrus, stone fruit, and wildflowers over a whisper of minerality. Light-bodied and lively, this grape is a charming companion for early sipping and a true taste of Albanian tradition.",
        },
        "color": "white",
        "regions": ["Albania"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Debit",
        "synonyms": ["Belan", "Čarapar", "Debit Bijeli", "Puljižanac"],
        "description": {
            "default": "Vine producing alcoholic wine throughout Dalmacija (Dalmatia).",
            "julie": "",
            "sommelier": "Debit is Dalmatia’s sun-kissed secret, offering a breezy medley of citrus, stone fruit, and delicate florals over a crisp, mineral backbone—perfect for seaside sipping and lively conversation. This light-bodied, unoaked white is a charming companion to Mediterranean fare and warm summer evenings.",
        },
        "color": "white",
        "regions": ["Dalmatia", "Croatia"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Deckrot",
        "synonyms": [],
        "description": {
            "default": "Red-fleshed German cross bred for colour.",
            "julie": "",
            "sommelier": "Deckrot dazzles with its ruby hue and a playful medley of cherry, plum, and raspberry, all grounded by a whisper of earth and stone—think of it as Germany’s answer to a fruit-forward, easy-drinking red that’s as charming as it is rare.",
        },
        "color": "black",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Delaware",
        "synonyms": ["Delavar", "Heath Grape", "Ladies Choice", "Powell", "Ruff Heath"],
        "description": {
            "default": "Historic variety of obscure origin once popular in the Midwest and in the eastern US states.",
            "julie": "",
            "sommelier": "Delaware is the darling of American vineyards, offering a whimsical bouquet of red berries, blossoms, and a hint of tropical sunshine in every sip. Light-bodied and refreshingly lively, this historic pink grape is perfect for those who crave a playful, easy-drinking wine with a touch of nostalgia.",
        },
        "color": "pink",
        "regions": [
            "Midwest USA",
            "Eastern USA",
            "New York (Finger Lakes)",
            "Ohio",
            "Pennsylvania",
            "Japan",
        ],
        "flavor_profile": ["red_fruit", "floral", "tropical_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Delisle",
        "synonyms": ["ES 7-5-41"],
        "description": {
            "default": "Very minor, cold-hardy North American hybrid with marked petrol-like aromas.",
            "julie": "",
            "sommelier": "Delisle is a quirky, cold-hardy white grape that dazzles with zippy acidity, a whiff of petrol, and a refreshing mineral-citrus punch—think of it as Riesling’s eccentric North American cousin, perfect for those who crave something off the beaten path.",
        },
        "color": "white",
        "regions": ["New York State", "Ontario", "Quebec", "Minnesota"],
        "flavor_profile": ["mineral", "citrus"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Devín",
        "synonyms": ["Děvín", "TCVCB 15/4"],
        "description": {
            "default": "Slovakian cross producing full-bodied, spicy whites in Slovakia and the Czech Republic.",
            "julie": "",
            "sommelier": "Devín is Slovakia’s aromatic white gem, seducing the senses with a heady bouquet of spice, wildflowers, and ripe stone fruit, all wrapped in a full-bodied, mineral embrace—perfect for those who crave both tradition and adventure in their glass.",
        },
        "color": "white",
        "regions": ["Slovakia", "Czech Republic"],
        "flavor_profile": ["spice", "floral", "stone_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["white", "full_bodied", "varietal", "traditional"],
    },
    {
        "name": "Diagalves",
        "synonyms": [
            "Carnal",
            "Dependura",
            "Diego Alves",
            "Diogalves",
            "Fernan Fer",
            "Formosa",
            "Formosa Dourada",
            "Formosa Portalegre",
            "Pendura",
            "Pendura Amarela",
            "Villanueva",
        ],
        "description": {
            "default": "Southern Portuguese variety generally used in blends or eaten fresh.",
            "julie": "",
            "sommelier": "Diagalves is the sun-kissed secret of Southern Portugal, offering a lively medley of stone fruit, apple, and citrus in a light, refreshing package. Perfect for easy sipping or blending, this grape brings a breezy, floral charm to any table.",
        },
        "color": "white",
        "regions": ["Alentejo", "Algarve", "Portalegre", "Southern Portugal"],
        "flavor_profile": ["stone_fruit", "apple", "pear", "floral", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "unoaked",
            "light_bodied",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Dimrit",
        "synonyms": ["Dimlit", "Dimrit Kara", "Dirmit Kara"],
        "description": {
            "default": "Poor-quality, dark-skinned Turkish variety little used for wine so far.",
            "julie": "",
            "sommelier": "Dimrit is a little-known Turkish black grape, offering a playful medley of red and black fruit flavors in a feather-light, low-alcohol package—perfect for a casual table wine that whispers of Anatolian tradition. While not a showstopper, its easygoing charm makes it a delightful companion for early, unfussy sipping.",
        },
        "color": "black",
        "regions": ["Turkey"],
        "flavor_profile": ["red_fruit", "black_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Dimyat",
        "synonyms": [
            "Ahorntraube",
            "Bekaszőlő",
            "Dertonia",
            "Dimiat",
            "Galan",
            "Grobweisser",
            "Misket Slivenski",
            "Roşioară",
            "Semendria",
            "Smederevka",
            "Smederevka Bianca",
            "Szemendriai Fehér",
            "Töröklugas",
            "Yapalaki",
            "Zoumiatiko",
            "Zumiatico",
            "Zumyat",
        ],
        "description": {
            "default": "Productive, everyday Bulgarian white.",
            "julie": "",
            "sommelier": "Dimyat is Bulgaria’s everyday white, offering a breezy bouquet of citrus, apple, and pear with a whisper of floral and mineral charm—think of it as the perfect companion for a sunlit afternoon, light on its feet and always ready to refresh.",
        },
        "color": "white",
        "regions": ["Bulgaria", "Romania", "Serbia", "North Macedonia"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Dindarella",
        "synonyms": ["Dindarella Rizza", "Pelada", "Pelara"],
        "description": {
            "default": "Rare, dark-skinned Veneto variety well suited to dried-grape wine styles.",
            "julie": "",
            "sommelier": "Dindarella is Veneto’s secret weapon, delivering a decadent medley of black fruit, dried figs, and a dusting of chocolate, all wrapped in a full-bodied, age-worthy embrace. This rare grape is a must-try for those who crave bold, traditional reds with a whisper of spice and earth.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": ["black_fruit", "dried_fruit", "spice", "earth", "chocolate"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "dessert",
            "blend",
            "full_bodied",
            "age_worthy",
            "traditional",
        ],
    },
    {
        "name": "Dišeća Ranina",
        "synonyms": ["Dišeća Ranina Bijela", "Petrinjska Ranina", "Petrinjska Bijela"],
        "description": {
            "default": "Rare and very localized Croatian variety from south of Zagreb.",
            "julie": "",
            "sommelier": "Dišeća Ranina is Croatia’s aromatic hidden gem, bursting with floral, citrus, and stone fruit notes atop a zippy, light-bodied frame—think of it as a springtime stroll through a Zagreb orchard in a glass. Rarely seen outside its homeland, this lively white is a must-try for adventurous palates seeking a fresh, unoaked delight.",
        },
        "color": "white",
        "regions": ["Croatia", "South of Zagreb", "Continental Croatia"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Dobričić",
        "synonyms": [
            "Čihovac",
            "Crljenak Slatinski",
            "Dobričić Crni",
            "Dobrovoljac",
            "Krucalin",
            "Okručanac",
            "Sholtanats",
            "Slatinjac",
            "Slatinski",
        ],
        "description": {
            "default": "Rare Croatian variety high in sugar, rich in colour and used mainly in red blends on the island of Šolta.",
            "julie": "",
            "sommelier": "Dobričić is the dark horse of Dalmatia, delivering a full-bodied, high-octane red brimming with black fruit, plum, and earthy minerality—a true island original that brings both power and tradition to the glass.",
        },
        "color": "black",
        "regions": ["Šolta", "Dalmatia", "Croatia"],
        "flavor_profile": ["black_fruit", "plum", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "traditional", "table_wine", "full_bodied"],
    },
    {
        "name": "Dolcetto",
        "synonyms": ["Dolcetto Nero", "Nibièu", "Nibiò", "Ormeasco"],
        "description": {
            "default": "Deeply coloured, low-acid, fragrant Piemontese red.",
            "julie": "",
            "sommelier": "Dolcetto is Piedmont’s everyday charmer—bursting with juicy cherries, plums, and a hint of earth, this deeply colored red is soft on acidity but lively on the palate, perfect for those who like their wines both fragrant and friendly. It’s the Italian answer to a weeknight red: easygoing, medium-bodied, and always ready to please.",
        },
        "color": "black",
        "regions": ["Piedmont", "Liguria"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "cherry",
            "plum",
            "blackberry",
            "floral",
            "earth",
        ],
        "acidity": "Low",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
            "medium_bodied",
        ],
    },
    {
        "name": "Dolciame",
        "synonyms": ["Malfiore", "Parlano", "Uva delle Vecchie"],
        "description": {
            "default": "Virtually extinct Umbrian white.",
            "julie": "",
            "sommelier": "Dolciame is Umbria’s whisper from the past—a light-bodied, unoaked white that dances with citrus and floral notes, finishing with a mineral snap. Nearly extinct, this grape is a hidden gem for those who seek a taste of Italian tradition in its purest, most refreshing form.",
        },
        "color": "white",
        "regions": ["Umbria"],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "traditional",
            "table_wine",
            "varietal",
        ],
    },
    {
        "name": "Domina",
        "synonyms": ["Geilweilerhof 4-25-7"],
        "description": {
            "default": "Modern red German cross planted mainly in Franken.",
            "julie": "",
            "sommelier": "Domina is Franken’s modern answer to a juicy, medium-bodied red, brimming with cherry and plum, dusted with earthy spice, and ready to charm both the casual sipper and the curious connoisseur. Think of it as Germany’s stylish, fruit-forward twist on classic table wine—delightfully drinkable, whether oaked or unoaked.",
        },
        "color": "black",
        "regions": ["Franken", "Germany"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "earth",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "modern",
            "table_wine",
            "medium_bodied",
            "unoaked",
            "oaked",
            "early_drinking",
        ],
    },
    {
        "name": "Donzelinho Tinto",
        "synonyms": ["Donzelinho do Castello", "Donzelynho", "Tinta do Minho"],
        "description": {
            "default": "Old, rare Douro variety playing a very small, inglorious part in blended wines, fortified and unfortified.",
            "julie": "",
            "sommelier": "Donzelinho Tinto is the Douro’s elusive black pearl—high in acidity and full-bodied, it weaves red and black fruit, spice, and earthy notes into blends that quietly age with grace. Though seldom in the spotlight, this grape adds a dash of intrigue and backbone to Portugal’s most traditional wines.",
        },
        "color": "black",
        "regions": ["Douro", "Portugal"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "fortified", "traditional", "age_worthy"],
    },
    {
        "name": "Doradilla",
        "synonyms": ["Forastera Blanca", "Plateado"],
        "description": {
            "default": "Very minor variety from Málaga in Andalucía frequently confused with other varieties.",
            "julie": "",
            "sommelier": "Doradilla is Andalucía’s hidden gem, offering a breezy medley of citrus and stone fruit with a whisper of minerality—think of it as the sun-drenched Mediterranean in a glass, perfect for sipping young and carefree.",
        },
        "color": "white",
        "regions": ["Málaga", "Andalucía"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Dorinto",
        "synonyms": [
            "Arinto Branco",
            "Arinto do Douro",
            "Arinto do Interior",
            "Arinto no Douro",
            "Arinto de Trás-os-Montes",
        ],
        "description": {
            "default": "Recently renamed Portuguese white.",
            "julie": "",
            "sommelier": "Dorinto, Portugal’s zesty white gem, dazzles with a lively medley of citrus, apple, and mineral notes, all wrapped in a crisp, high-acid frame. Whether sipped young or aged, this grape brings a refreshing vibrancy to the glass, perfect for those who crave a spirited and versatile white wine.",
        },
        "color": "white",
        "regions": ["Portugal", "Douro", "Trás-os-Montes", "Bucelas"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral", "lemon"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Dornfelder",
        "synonyms": ["Weinsberg S 341"],
        "description": {
            "default": "The most successful of the modern red German crosses, making dark, velvety wines.",
            "julie": "",
            "sommelier": "Dornfelder is Germany’s velvet-clad answer to bold red wine, bursting with sour cherry and blackberry, and equally at home by a roaring fire or chilled for a summer soirée. Its deep color and smooth, harmonious palate make it a crowd-pleaser—whether you crave a fruity quaffer or a structured, oak-aged stunner.",
        },
        "color": "black",
        "regions": ["Germany", "Rheinhessen", "Pfalz", "Nahe", "Baden"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "blackberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Dorona Di Venezia",
        "synonyms": ["Dorona", "Dorona Veneziana", "Uva d’Oro"],
        "description": {
            "default": "Recently rescued but not especially ancient Venetian white.",
            "julie": "",
            "sommelier": "Dorona Di Venezia is Venice’s golden secret, offering a zesty medley of citrus and stone fruit with a salty sea breeze minerality—think of it as the lagoon’s answer to a summer aperitivo, both rare and ravishing.",
        },
        "color": "white",
        "regions": ["Veneto", "Venice Lagoon", "Mazzorbo"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "unoaked",
            "traditional",
            "premium",
            "table_wine",
        ],
    },
    {
        "name": "Douce Noire",
        "synonyms": [
            "Bathiolin",
            "Bonarda",
            "Charbonneau",
            "Charbono",
            "Corbeau",
            "Corbeau Noir",
            "Mauvais Noir",
            "Plant de Montmélian",
            "Plant de Turin",
            "Plant Noir",
            "Turca",
            "Turin",
        ],
        "description": {
            "default": "Savoie variety with several aliases causing considerable confusion, most widely planted in Argentina.",
            "julie": "",
            "sommelier": "Douce Noire is the globe-trotting chameleon of the wine world, offering a juicy burst of plum, cherry, and blackberry wrapped in herbal spice and earthy intrigue. Whether enjoyed young or aged, this full-bodied red dazzles with high acidity and a mysterious past—perfect for adventurous palates seeking a wine with both character and story.",
        },
        "color": "black",
        "regions": ["Argentina", "Savoie", "California"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "blackberry",
            "herbal",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "full_bodied",
            "table_wine",
            "age_worthy",
            "early_drinking",
            "oaked",
            "unoaked",
        ],
    },
    {
        "name": "Doux D’Henry",
        "synonyms": ["Doux d’Enry", "Gros d’Henry"],
        "description": {
            "default": "Rare, light-bodied red exclusive to the Pinerolese region of Piemonte.",
            "julie": "",
            "sommelier": "Doux D’Henry is Piemonte’s hidden gem—a featherweight red bursting with cherry and raspberry, laced with floral and earthy intrigue, and finishing with a zippy, mineral snap. Perfect for those who crave a rare, refreshing sip that dances lightly on the palate.",
        },
        "color": "black",
        "regions": ["Pinerolese", "Piemonte", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "earth",
            "mineral",
            "cherry",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Drnekuša",
        "synonyms": ["Darnekuša", "Darnekuša Mala", "Darnekuša Vela", "Dernakuša"],
        "description": {
            "default": "Rare vine from the Croatian island of Hvar.",
            "julie": "",
            "sommelier": "Drnekuša, the elusive black pearl of Hvar, charms with a breezy medley of cherry, raspberry, and wild herbs, all wrapped in a mineral embrace. Light-bodied and lively, this Croatian rarity is a sun-kissed invitation to the Adriatic in every glass.",
        },
        "color": "black",
        "regions": ["Hvar", "Dalmatia", "Croatia"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "herbal", "mineral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Drupeggio",
        "synonyms": [
            "Bottaio Bianco",
            "Cacinello",
            "Cacciumo",
            "Canaiolo Bianco",
            "Canajola",
            "Canina",
            "Uva dei Cani",
            "Drupeccio",
            "Lupeccio",
            "Trupeccio",
            "Volpicchio",
        ],
        "description": {
            "default": "Neutral, central Italian white also known as Canaiolo Bianco.",
            "julie": "",
            "sommelier": "Drupeggio, the chameleon of central Italy, charms with subtle apple and pear flavors, a whisper of minerality, and a light, easygoing personality—perfect for those who prefer their whites crisp, unoaked, and refreshingly uncomplicated.",
        },
        "color": "white",
        "regions": ["Umbria", "Tuscany", "Lazio"],
        "flavor_profile": ["apple", "pear", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Dunaj",
        "synonyms": ["MBOP × SV 6/10"],
        "description": {
            "default": "Minor but potentially high-quality Slovak cross responsible for soft, full-bodied reds.",
            "julie": "",
            "sommelier": "Dunaj is Slovakia’s secret weapon, delivering plush, full-bodied reds brimming with juicy plum, cherry, and a whisper of spice and earth. This grape charms with its velvety texture and balanced structure, making it a must-try for lovers of bold yet elegant wines.",
        },
        "color": "black",
        "regions": ["Slovakia", "Czech Republic", "Hungary", "Austria"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Dunkelfelder",
        "synonyms": ["Fröhlich V. 4.4", "Fröhlich V 4", "Purpur"],
        "description": {
            "default": "Dark-skinned German cross usefully adding colour and body to blends.",
            "julie": "",
            "sommelier": "Dunkelfelder is Germany’s secret weapon for adding brooding color and plush body to red blends, bursting with flavors of blackberry, plum, and a whisper of earthy spice. This full-bodied grape brings a velvet glove of richness to the glass, making every sip a dark and delicious adventure.",
        },
        "color": "black",
        "regions": ["Germany", "Rheinhessen", "Pfalz", "Baden"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "full_bodied",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Duranija",
        "synonyms": ["Brajdenica", "Duranija Bijela", "Duronija"],
        "description": {
            "default": "Almost extinct Croatian variety from the Istrian peninsula.",
            "julie": "",
            "sommelier": "Duranija is a rare Istrian gem, offering a lively medley of citrus and stone fruit with a whisper of wildflowers and a stony backbone—like a sunlit stroll through a Croatian orchard. Light-bodied and unoaked, it’s a crisp, charming relic of tradition that begs to be rediscovered.",
        },
        "color": "white",
        "regions": ["Istria", "Croatia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Duras",
        "synonyms": ["Durade", "Duras Rouge", "Durazé"],
        "description": {
            "default": "Structured and peppery variety playing a minor role in the Gaillac appellation.",
            "julie": "",
            "sommelier": "Duras is Gaillac’s spicy secret—a medium-bodied red grape that weaves black fruit and earthy pepper into a tapestry of rustic French charm, perfect for those who crave a little intrigue in their glass. Often found in blends but captivating on its own, Duras delivers a structured, age-worthy wine that’s as lively as a village fête in Southwest France.",
        },
        "color": "black",
        "regions": ["Gaillac", "Southwest France"],
        "flavor_profile": ["black_fruit", "spice", "pepper", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "medium_bodied",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Durella",
        "synonyms": ["Cagnina", "Caina", "Durella Gentile", "Rabiosa"],
        "description": {
            "default": "Makes crisp, light-bodied Veneto whites.",
            "julie": "",
            "sommelier": "Durella dazzles with a zippy burst of citrus and orchard fruit, its high acidity and mineral edge making it the ultimate thirst-quencher from Veneto. This lively Italian white is your go-to for a crisp, unoaked sip that sings of fresh apples and pears—perfect for early, carefree enjoyment.",
        },
        "color": "white",
        "regions": ["Veneto", "Italy"],
        "flavor_profile": ["citrus", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Dureza",
        "synonyms": ["Duré", "Duret", "Durezza", "Petit Duret", "Serène", "Serine"],
        "description": {
            "default": "Virtually extinct Ardèche variety most famous as a parent of Syrah.",
            "julie": "",
            "sommelier": "Dureza is the enigmatic ancestor of Syrah, offering a bold tapestry of black fruit, earthy spice, and pepper, all wrapped in a full-bodied, high-tannin embrace—an adventurous sip into French wine history.",
        },
        "color": "black",
        "regions": ["Ardèche", "Rhône-Alpes", "France"],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "blackberry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Durif",
        "synonyms": [
            "Dure",
            "Duret",
            "Gros Noir",
            "Petite Sirah",
            "Petite Syrah",
            "Pinot de l’Hermitage",
            "Pinot de Romans",
            "Plant Durif",
            "Serine des Mauves",
            "Sirane Fourchue",
        ],
        "description": {
            "default": "Originally French but particularly famous, as Petite Sirah, in California.",
            "julie": "",
            "sommelier": "Durif, better known as Petite Sirah in California, is a powerhouse grape that delivers a full-throttle ride of blackberry, plum, and pepper, all wrapped in a cloak of chocolate and spice. With its formidable tannins and high-octane personality, this is the wine equivalent of a velvet-gloved heavyweight—perfect for those who like their reds bold and unapologetic.",
        },
        "color": "black",
        "regions": ["California", "Australia", "France"],
        "flavor_profile": [
            "black_fruit",
            "blue_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "oak",
            "pepper",
            "chocolate",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "blend",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Dutchess",
        "synonyms": ["Duchess"],
        "description": {
            "default": "Disappearing, low-yielding, sensitive North American hybrid also found in Brazil.",
            "julie": "",
            "sommelier": "Dutchess is a vanishing gem of a grape, offering a whimsical bouquet of stone fruit, apple, and pear, kissed with floral and earthy notes—think of it as the Cinderella of North American hybrids, best enjoyed before the clock strikes midnight. Light-bodied and lively, this unoaked white is a rare treat for those lucky enough to find it.",
        },
        "color": "white",
        "regions": ["United States", "Brazil"],
        "flavor_profile": ["stone_fruit", "floral", "apple", "pear", "earth"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Dzvelshavi Obchuri",
        "synonyms": ["Zelscavi"],
        "description": {
            "default": "Mediocre Georgian variety producing intensely coloured reds.",
            "julie": "",
            "sommelier": "Dzvelshavi Obchuri may not be Georgia’s star grape, but it delivers a rustic charm with its inky hue and a medley of red and black fruits dusted with earthy notes. Perfect for those seeking a taste of Georgian tradition in a medium-bodied, easy-drinking red.",
        },
        "color": "black",
        "regions": ["Georgia", "Imereti", "Racha-Lechkhumi"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "table_wine",
            "early_drinking",
            "varietal",
            "blend",
            "traditional",
        ],
    },
    {
        "name": "Early Muscat",
        "synonyms": ["California K 4-19"],
        "description": {
            "default": "California cross bred for the table but also producing aromatic wines in Oregon.",
            "julie": "",
            "sommelier": "Early Muscat is a vivacious white grape that dazzles with a bouquet of spring flowers, zesty citrus, and a whisper of honeyed stone fruit, all wrapped in a crisp, light-bodied frame. Perfect for those who crave a modern, aromatic white that’s as lively and refreshing as a breezy Oregon afternoon.",
        },
        "color": "white",
        "regions": ["California", "Oregon"],
        "flavor_profile": ["floral", "citrus", "stone_fruit", "honey"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "modern",
        ],
    },
    {
        "name": "Edelweiss",
        "synonyms": ["Elmer Swenson", "ES 40"],
        "description": {
            "default": "Minor, usefully disease-resistant and winter-hardy, not too foxy American hybrid.",
            "julie": "",
            "sommelier": "Edelweiss is the Midwest’s answer to aromatic white wine, bursting with floral and tropical fruit notes, and as resilient as it is refreshing. This light-bodied, unoaked charmer is perfect for those seeking a crisp, easy-drinking table wine with a touch of American ingenuity.",
        },
        "color": "white",
        "regions": [
            "Nebraska",
            "Minnesota",
            "Iowa",
            "Wisconsin",
            "Midwestern United States",
        ],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Ederena",
        "synonyms": ["Édéréna"],
        "description": {
            "default": "Bordeaux cross being trialled in California.",
            "julie": "",
            "sommelier": "Ederena is a cosmopolitan charmer, blending Bordeaux pedigree with California innovation to deliver a harmonious medley of red and black fruits, subtle herbs, and earthy undertones. Medium in every measure, it’s a versatile grape that shines in both modern blends and classic varietal expressions.",
        },
        "color": "black",
        "regions": ["California", "Bordeaux"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "table_wine",
            "modern",
            "traditional",
        ],
    },
    {
        "name": "Egiodola",
        "synonyms": ["Égiodola"],
        "description": {
            "default": "Recent productive Bordeaux cross starting to show some potential at home and abroad. Quite tannic.",
            "julie": "",
            "sommelier": "Egiodola is a bold, modern Bordeaux cross that packs a punch with high tannins, full body, and a medley of red and black fruits, spice, and earthy undertones—perfect for those who like their reds with muscle and intrigue. This up-and-comer is making waves from Bordeaux to Spain, promising a future as both a blending powerhouse and a varietal star.",
        },
        "color": "black",
        "regions": ["France", "Bordeaux", "Southwest France", "Spain", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "table_wine",
            "modern",
        ],
    },
    {
        "name": "Ehrenfelser",
        "synonyms": ["Geisenheim 9-93"],
        "description": {
            "default": "Frost-resistant German cross bred as an alternative to Riesling.",
            "julie": "",
            "sommelier": "Ehrenfelser is the lively understudy to Riesling, bursting with juicy peach, crisp apple, and zesty citrus, all wrapped in a bouquet of spring flowers. With its high acidity and light body, this frost-loving grape delivers a refreshing, aromatic sip that shines from Germany to Canada’s Okanagan Valley.",
        },
        "color": "white",
        "regions": ["Germany", "Canada", "Okanagan Valley"],
        "flavor_profile": ["stone_fruit", "peach", "apple", "citrus", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "premium",
            "dessert",
        ],
    },
    {
        "name": "Ekigaïna",
        "synonyms": ["Ékigaïna"],
        "description": {
            "default": "Recent Bordeaux cross yet to make inroads in the vineyard.",
            "julie": "",
            "sommelier": "Ekigaïna is Bordeaux’s up-and-coming black beauty, offering a harmonious medley of black and red fruits, plum, and cherry, all dusted with spice and earth. With its balanced structure and modern flair, this grape is poised to charm adventurous palates seeking something fresh yet unmistakably French.",
        },
        "color": "black",
        "regions": ["Bordeaux", "France"],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "plum",
            "cherry",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "blend",
            "varietal",
            "modern",
            "table_wine",
        ],
    },
    {
        "name": "Ekim Kara",
        "synonyms": ["Echim Kara"],
        "description": {
            "default": "Late-ripening Ukrainian variety making fortified red dessert wines.",
            "julie": "",
            "sommelier": "Ekim Kara is Ukraine’s answer to opulence: a voluptuous, late-ripening black grape that delivers fortified dessert wines brimming with black fruit, chocolate, and spice, all wrapped in a velvet cloak of richness and power. This is a grape for those who crave indulgence and intrigue in every sip.",
        },
        "color": "black",
        "regions": ["Ukraine"],
        "flavor_profile": [
            "black_fruit",
            "dried_fruit",
            "spice",
            "chocolate",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Very full",
        "alcohol": "Very high",
        "wine_styles": [
            "red",
            "dessert",
            "fortified",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Elbling",
        "synonyms": [
            "Aelbinen",
            "Albich",
            "Burger",
            "Elbling Weiss",
            "Elsässer",
            "Grobriesling",
            "Grossriesling",
            "Haussard",
            "Raisin Blanc des Allemands",
            "Rheinelbe",
            "Weisser Silvaner",
            "Ysèle .",
        ],
        "description": {
            "default": "Ancient, once ubiquitous, now unfashionable German variety used mainly as a base wine for fizz.",
            "julie": "",
            "sommelier": "Elbling is the zippy, citrus-charged relic of Germany’s vineyards—think of it as Riesling’s sprightly, mineral-driven ancestor, perfect for sparkling wines and summer sipping. With its brisk acidity and apple-fresh charm, Elbling is a lively throwback that’s ready to party, even if it’s no longer the belle of the ball.",
        },
        "color": "white",
        "regions": ["Germany", "Mosel", "Upper Mosel", "Luxembourg"],
        "flavor_profile": ["citrus", "mineral", "apple"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "varietal",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Emerald Riesling",
        "synonyms": ["California 1139E29", "Emerald Rizling"],
        "description": {
            "default": "California cross that has travelled widely but not gloriously and turns out to be no Riesling.",
            "julie": "",
            "sommelier": "Emerald Riesling is a globe-trotting California creation that charms with bright stone fruit, apple, and pear notes, all wrapped in a light, easy-drinking package—just don’t expect it to taste like true Riesling! Perfect for a sunny afternoon, this varietal is a crisp, floral refresher with a story as intriguing as its name.",
        },
        "color": "white",
        "regions": ["California", "Australia", "Israel"],
        "flavor_profile": ["stone_fruit", "floral", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Enantio",
        "synonyms": [
            "Foja Tonda",
            "Lambrusco a Foglia Frastagliata",
            "Lambrusco Nostrano",
        ],
        "description": {
            "default": "Fairly recent official name for a Trentino variety once called Lambrusco a Foglia Frastagliata.",
            "julie": "",
            "sommelier": "Enantio, the bold black gem of Trentino, dazzles with a riot of cherries, blackberries, and earthy spice, all wrapped in a muscular frame of high acidity and tannins. This age-worthy Italian classic is a must-try for lovers of powerful, characterful reds with a wild Alpine soul.",
        },
        "color": "black",
        "regions": ["Trentino", "Alto Adige", "Northern Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "blackberry",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Encruzado",
        "synonyms": ["Salgueirinho"],
        "description": {
            "default": "High-quality, well-structured Portuguese variety with the potential to produce ageworthy wines.",
            "julie": "",
            "sommelier": "Encruzado is the Dão’s white jewel, dazzling with a tapestry of citrus, stone fruit, and floral notes, underpinned by a mineral backbone and whispers of honeyed nuts. This high-acid, medium-bodied grape crafts both fresh and ageworthy wines, making it Portugal’s answer to white Burgundy—elegant, complex, and always a delightful surprise.",
        },
        "color": "white",
        "regions": ["Dão", "Portugal"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "honey",
            "butter",
            "nuts",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Enfariné Noir",
        "synonyms": ["Enfariné du Jura", "Gaillard", "Gouais Noir"],
        "description": {
            "default": "Ancient and virtually extinct variety that survives in the Jura.",
            "julie": "",
            "sommelier": "Enfariné Noir is a rare gem from the Jura, offering a whisper of red and black fruits dusted with earthy minerals—think of it as a time capsule in a glass, light on its feet yet rich in history. This nearly forgotten variety is a sommelier’s secret handshake, perfect for those who crave a taste of vinous antiquity.",
        },
        "color": "black",
        "regions": ["Jura"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Eona",
        "synonyms": ["Éona"],
        "description": {
            "default": "South Dakotan hybrid just about surviving in Québec.",
            "julie": "",
            "sommelier": "Eona is a plucky white hybrid thriving where few dare, delivering a lively burst of citrus, apple, and floral notes over a crisp mineral backbone—think of it as the spirited underdog of the northern vineyards, perfect for a chilled, easy-drinking escape.",
        },
        "color": "white",
        "regions": ["South Dakota", "Québec"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Erbaluce",
        "synonyms": [
            "Albaluce",
            "Bian Roustì",
            "Bianchera",
            "Greco Bianco di Novara",
            "Uva Rustìa",
        ],
        "description": {
            "default": "Minor white Piemontese variety, occasionally making distinctive sweet wines.",
            "julie": "",
            "sommelier": "Erbaluce dazzles with zesty citrus and crisp apple, underpinned by a racy acidity that makes both its dry and sweet wines sing; think of it as Piedmont’s secret handshake for those who crave a mineral-driven, honey-kissed white with serious aging potential.",
        },
        "color": "white",
        "regions": ["Piedmont", "Caluso"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral", "honey"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Erbamat",
        "synonyms": ["Albamatto", "Erbamatto", "Verdealbara"],
        "description": {
            "default": "Virtually extinct local white from Brescia, northern Italy.",
            "julie": "",
            "sommelier": "Erbamat is a rare northern Italian treasure, offering zesty citrus and crisp apple flavors with a floral lift and stony minerality—think of it as a refreshing alpine breeze in a glass, perfect for those who seek the thrill of the undiscovered.",
        },
        "color": "white",
        "regions": ["Brescia", "Lombardy", "Northern Italy"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Ervi",
        "synonyms": ["Barbera × Bonarda 108", "Incrocio Fregoni 108"],
        "description": {
            "default": "Minor and relatively recent dark-skinned cross from Emilia-Romagna.",
            "julie": "",
            "sommelier": "Ervi is Emilia-Romagna’s lively newcomer, blending the juicy red and black fruit charm of Barbera and Bonarda with a spicy, earthy twist. With its zippy acidity and medium frame, this grape crafts versatile, early-drinking reds that are as spirited as an Italian festa.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Escursac",
        "synonyms": ["Corçac", "Cursach", "Escorçac", "Escursag", "Excursach"],
        "description": {
            "default": "Recently rescued Mallorcan making promising reds.",
            "julie": "",
            "sommelier": "Escursac is Mallorca’s comeback kid, delivering lively reds that dance with red fruit, wild herbs, and a whisper of island minerals—perfect for those seeking a taste of Balearic tradition with a modern twist. This medium-bodied charmer is as versatile as it is rare, making every sip a celebration of Mallorca’s vinous revival.",
        },
        "color": "black",
        "regions": ["Mallorca", "Balearic Islands", "Spain"],
        "flavor_profile": ["red_fruit", "herbal", "mineral", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "traditional", "modern", "early_drinking"],
    },
    {
        "name": "Espadeiro",
        "synonyms": ["Espadeiro Tinto", "Padeiro Tinto"],
        "description": {
            "default": "Minho vine producing rosé.",
            "julie": "",
            "sommelier": "Espadeiro is the life of the Vinho Verde party, delivering a zesty, high-acid rosé brimming with raspberry, cherry, and a bouquet of wildflowers—think of it as Portugal’s answer to summer in a glass. Light on its feet and low in alcohol, this grape is your go-to for refreshing, early-drinking wines that dance on the palate.",
        },
        "color": "black",
        "regions": ["Minho", "Vinho Verde", "Portugal"],
        "flavor_profile": ["red_fruit", "raspberry", "cherry", "floral", "herbal"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Espirit",
        "synonyms": ["ES 422", "Esprit"],
        "description": {
            "default": "Very minor but cold-hardy American hybrid producing mild, fruity wines.",
            "julie": "",
            "sommelier": "Espirit is the zesty snowbird of the grape world, delivering a crisp, high-acid white wine brimming with apple, pear, and citrus flavors, all wrapped in a delicate floral bouquet—think of it as a breath of fresh northern air in your glass, perfect for those who love their whites light, lively, and ready to drink.",
        },
        "color": "white",
        "regions": ["New York", "Minnesota", "Ontario", "Vermont"],
        "flavor_profile": ["apple", "pear", "citrus", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Etraire De L’Aduï",
        "synonyms": [
            "Beccu de l’Aduï",
            "Betu",
            "Etraire de la Dot",
            "Etraire de la Dû",
            "Due",
            "Etraire de la Duï",
            "Etraire de la Duy",
            "Grosse Etraire",
        ],
        "description": {
            "default": "Isère speciality still cultivated to a limited extent in Savoie.",
            "julie": "",
            "sommelier": "Etraire De L’Aduï is a Savoie secret, offering a beguiling mix of red and black fruits laced with earthy, mineral undertones—think of it as the soulful chanteur of French grapes, perfect for those who crave tradition with a touch of mystery.",
        },
        "color": "black",
        "regions": ["Isère", "Savoie", "France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Evmolpia",
        "synonyms": ["Evmolpiya", "Thracian Mavrud"],
        "description": {
            "default": "Recent Bulgarian cross valued for its productivity and early ripening as well as for its easy-drinking reds.",
            "julie": "",
            "sommelier": "Evmolpia is Bulgaria’s answer to the everyday red: a juicy, medium-bodied charmer brimming with cherry, plum, and a whisper of spice, perfect for those who like their wines as friendly and unpretentious as a Thracian sunset. This grape’s easygoing nature and earthy undertones make it a delightful companion for casual gatherings and hearty fare alike.",
        },
        "color": "black",
        "regions": ["Bulgaria", "Thracian Valley"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Eyholzer Rote",
        "synonyms": ["Eyholzer Roter", "Gross Roth", "Grossroter"],
        "description": {
            "default": "Ancient and extremely rare variety vinified by just one southern Swiss producer.",
            "julie": "",
            "sommelier": "Eyholzer Rote is a unicorn of the Swiss Alps—an ancient, feather-light red brimming with tart cherry, wild raspberry, and alpine florals, all underpinned by a brisk, mineral snap. With just one producer keeping this grape’s legacy alive, each glass is a rare taste of Valais tradition and mountain air.",
        },
        "color": "red",
        "regions": ["Switzerland", "Valais"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Ezerfürtű",
        "synonyms": ["Kecskemét 5", "Miklóstelepi 5"],
        "description": {
            "default": "Neutral Hungarian white cross generally hidden in blends.",
            "julie": "",
            "sommelier": "Ezerfürtű is Hungary’s quiet achiever—a light-bodied, mineral-laced white grape that prefers to whisper rather than shout, often lending its crisp freshness to blends. Think of it as the supporting actor in a blockbuster, bringing balance and subtlety to the glass.",
        },
        "color": "white",
        "regions": ["Hungary"],
        "flavor_profile": ["mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "table_wine",
            "unoaked",
            "early_drinking",
        ],
    },
    {
        "name": "Ezerjó",
        "synonyms": [
            "Budai Fehér",
            "Fehér Bakator",
            "Kolmreifler",
            "Korponai",
            "Tausendgute",
            "Tausent Güte",
            "Trummertraube",
            "Zátoki",
        ],
        "description": {
            "default": "Once widely planted Hungarian variety making high-acid whites from dry to sweet.",
            "julie": "",
            "sommelier": "Ezerjó, Hungary’s “thousand good things” grape, dazzles with electrifying acidity and a bouquet of citrus, apple, and wildflowers, making it a zippy, mineral-driven white that shines from aperitif to dessert. This lively varietal is a must-try for fans of crisp, refreshing wines with a storied past.",
        },
        "color": "white",
        "regions": ["Hungary"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "age_worthy",
        ],
    },
    {
        "name": "Faberrebe",
        "synonyms": ["Alzey 10375", "Faber"],
        "description": {
            "default": "High-yielding, lightly aromatic German cross losing ground.",
            "julie": "",
            "sommelier": "Faberrebe is the unsung hero of German whites, offering a zesty medley of citrus and stone fruit with a whisper of florals and minerals—perfect for those who crave a crisp, refreshing sip. Light on its feet and easy to love, this grape shines brightest in lively, unoaked table wines from Rheinhessen and Pfalz.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Falanghina Flegrea",
        "synonyms": [
            "Falanghina Pigna Piccola",
            "Falernina",
            "Uva Falerna",
            "Falanghina",
        ],
        "description": {
            "default": "Campania’s signature white wine grape.",
            "julie": "",
            "sommelier": "Falanghina Flegrea is Campania’s sun-kissed white, bursting with lively citrus, peach, and apple notes, all wrapped in a crisp, mineral embrace. This vivacious grape delivers a refreshing, mouthwatering sip that’s as perfect for seaside sipping as it is for a lively Italian table.",
        },
        "color": "white",
        "regions": ["Campania", "Italy"],
        "flavor_profile": [
            "citrus",
            "lemon",
            "stone_fruit",
            "peach",
            "apple",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Fer",
        "synonyms": [
            "Braucol",
            "Caillaba",
            "Camaralet Noir",
            "Camirouch",
            "Estronc",
            "Fer Servadou",
            "Gragnelut",
            "Hère",
            "Mansois",
            "Samençois",
            "Mourac",
            "Pinenc",
            "Servadou",
        ],
        "description": {
            "default": "The untamed, tannic variety of Marcillac, south-west France.",
            "julie": "",
            "sommelier": "Fer, the untamed heart of Marcillac, delivers a rustic symphony of cherry, plum, and pepper, wrapped in earthy minerality and assertive tannins—perfect for those who crave a wild, age-worthy French red with a rebellious streak.",
        },
        "color": "black",
        "regions": ["Marcillac", "Gaillac", "Madiran", "Southwest France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "spice",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
            "unoaked",
        ],
    },
    {
        "name": "Fernão Pires",
        "synonyms": [
            "Fernao Pirao",
            "Fernão Pires de Beco",
            "Gaeiro",
            "Gaieiro",
            "Maria Gomes",
            "Molinha",
            "Torrontés",
        ],
        "description": {
            "default": "Most common light-skinned grape in Portugal. Adaptable, high-yielding, making aromatic whites.",
            "julie": "",
            "sommelier": "Fernão Pires, Portugal’s aromatic white darling, dazzles with a bouquet of citrus, pear, and tropical fruit, all wrapped in a light, zesty frame. Perfect for sun-drenched afternoons, this grape delivers a lively, easy-drinking experience that’s as charming as a Lisbon summer.",
        },
        "color": "white",
        "regions": ["Portugal", "Bairrada", "Tejo", "Lisboa"],
        "flavor_profile": [
            "citrus",
            "floral",
            "stone_fruit",
            "tropical_fruit",
            "pear",
            "peach",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Fertilia",
        "synonyms": ["Incrocio Cosmo", "Merlot × Raboso Veronese 108"],
        "description": {
            "default": "Very minor red blending component in Treviso, northern Italy.",
            "julie": "",
            "sommelier": "Fertilia is the unsung hero of Treviso blends, bringing a lively medley of cherry, plum, and spice with a zesty acidity that keeps the palate dancing. This rare northern Italian grape is a masterful supporting act, adding depth and verve to traditional Venetian reds—perfect for those who love a little mystery in their glass.",
        },
        "color": "black",
        "regions": ["Treviso", "Veneto", "Northern Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "traditional",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Fetească Albă",
        "synonyms": [
            "Dievcie Hrozno",
            "Fetiasca Belii",
            "Fetișoară",
            "Fetyaska Alba",
            "Mädchentraube",
            "Păsărească Albă",
            "Poamă Fetei Albă",
            "Văratic",
        ],
        "description": {
            "default": "Second most planted Fetească and is even more important in Romania than in its Moldovan birthplace.",
            "julie": "",
            "sommelier": "Fetească Albă is Romania’s floral darling, bursting with zesty citrus, crisp apple, and a whisper of stone fruit, all wrapped in a lively, mineral-driven frame. This high-acid, light-bodied charmer is perfect for sparkling wines or a breezy summer sip—think of it as the ultimate white for those who crave freshness and a taste of Eastern European tradition.",
        },
        "color": "white",
        "regions": ["Romania", "Moldova"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "sparkling",
        ],
    },
    {
        "name": "Fetească Neagră",
        "synonyms": [
            "Coada Rândunicii",
            "Fetyaska Chernaya",
            "Păsărească Neagră",
            "Poamă Fetei Neagră",
            "Schwarze Mädchentraube",
        ],
        "description": {
            "default": "The red-wine Fetească, a resurgent Moldovan producing good-quality wine mainly in Romania.",
            "julie": "",
            "sommelier": "Fetească Neagră is Romania and Moldova’s sultry black grape, seducing with a tapestry of plum, cherry, and smoky spice, all wrapped in a velvety, medium-bodied embrace. Whether poured young or aged, it’s a soulful companion for adventurous palates seeking both tradition and intrigue.",
        },
        "color": "black",
        "regions": ["Romania", "Moldova"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "plum",
            "cherry",
            "blackberry",
            "spice",
            "earth",
            "smoke",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Fetească Regală",
        "synonyms": [
            "Dănăşană",
            "Danesana",
            "Dunesdörfer Königsast",
            "Galbenă de Ardeal",
            "Königliche Mädchentraube",
            "Pesecká Leánka .",
        ],
        "description": {
            "default": "The most planted Fetească, responsible for fresh, aromatic whites in Romania.",
            "julie": "",
            "sommelier": "Fetească Regală is Romania’s regal white, bursting with zesty citrus, juicy stone fruit, and delicate floral aromas, all wrapped in a crisp, high-acid frame. This lively grape is your ticket to a refreshing, easy-drinking wine that dances on the palate and brightens any table.",
        },
        "color": "white",
        "regions": ["Romania", "Slovakia", "Hungary", "Moldova"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "apple", "pear", "peach"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Fiano",
        "synonyms": ["Fiano di Avellino"],
        "description": {
            "default": "Rich, waxy, strongly flavoured, fashionable southern Italian.",
            "julie": "",
            "sommelier": "Fiano is the southern Italian white that seduces with its lush stone fruit, honeyed richness, and a whisper of toasted nuts, all wrapped in a full-bodied, high-acid embrace. This grape is a sommelier’s delight—fashionable, age-worthy, and as at home at a seaside trattoria as it is in a Michelin-starred cellar.",
        },
        "color": "white",
        "regions": ["Campania", "Avellino", "Sicily", "Puglia"],
        "flavor_profile": [
            "stone_fruit",
            "pear",
            "peach",
            "honey",
            "nuts",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "premium",
            "age_worthy",
            "unoaked",
            "oaked",
            "table_wine",
        ],
    },
    {
        "name": "Fioletovy Ranny",
        "synonyms": ["Filetovyi Ranii"],
        "description": {
            "default": "Russian variety used for the table, grape juice and nutmeg-flavoured red wine.",
            "julie": "",
            "sommelier": "Fioletovy Ranny is a charming Russian black grape that delights with red fruit, spice, and floral notes, producing light-bodied, low-alcohol reds with a whisper of nutmeg. Perfect for early sipping or as a table grape, it brings a playful, aromatic twist to Eastern European wine traditions.",
        },
        "color": "black",
        "regions": ["Russia", "Ukraine", "Moldova"],
        "flavor_profile": ["red_fruit", "spice", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "early_drinking",
            "table_wine",
            "varietal",
        ],
    },
    {
        "name": "Flavis",
        "synonyms": ["Incrocio Cosmo 76"],
        "description": {
            "default": "Minor white northern Italian cross.",
            "julie": "",
            "sommelier": "Flavis is a zippy northern Italian white, bursting with citrus, apple, and pear, and a whisper of alpine flowers and minerals—think of it as a mountain breeze in a glass, perfect for those who crave a lively, refreshing sip.",
        },
        "color": "white",
        "regions": ["Friuli-Venezia Giulia", "Veneto", "Trentino-Alto Adige"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Flora",
        "synonyms": ["California H59-90"],
        "description": {
            "default": "Minor, pink-skinned California cross capable of producing aromatic, full-bodied, sometimes flabby wines.",
            "julie": "",
            "sommelier": "Flora is California’s aromatic charmer, offering a lush bouquet of flowers, stone fruit, and tropical notes in a full-bodied, easy-drinking style—perfect for those who like their wines voluptuous and approachable, if occasionally a touch laid-back on acidity.",
        },
        "color": "pink",
        "regions": ["California"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "rosé",
            "full_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Florental",
        "synonyms": ["Burdin 7705"],
        "description": {
            "default": "Minor eastern French hybrid widely recommended but apparently hardly grown.",
            "julie": "",
            "sommelier": "Florental is the hidden gem of eastern France—think juicy red and black fruits dusted with earthy herbs, all wrapped in a medium-bodied, easy-drinking package. This rare hybrid is perfect for those seeking a fresh, early-drinking red with a touch of rustic French charm.",
        },
        "color": "black",
        "regions": ["Eastern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "table_wine", "blend", "varietal", "early_drinking"],
    },
    {
        "name": "Foça Karasi",
        "synonyms": ["Bilgi Yok", "Foça", "Foçakarası"],
        "description": {
            "default": "Almost-extinct variety from Turkey’s Aegean coast.",
            "julie": "",
            "sommelier": "Foça Karasi is a Turkish treasure on the brink of extinction, offering a harmonious medley of red and black fruits, spice, and earth in a medium-bodied, approachable style—perfect for adventurous palates seeking a taste of Anatolian history.",
        },
        "color": "black",
        "regions": ["Turkey", "Aegean Coast", "Foça"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Fogarina",
        "synonyms": ["Fogarina di Gualtieri", "Fugarina"],
        "description": {
            "default": "Mysterious, twice-rescued northern Italian red that adds colour and acidity in blends.",
            "julie": "",
            "sommelier": "Fogarina is the comeback kid of northern Italy, lending a vibrant splash of cherry and plum, earthy intrigue, and zesty acidity to blends—think of it as the secret spice in Emilia-Romagna’s vinous recipe. Twice saved from obscurity, this grape is a lively companion for those who love their reds with a dash of mystery and a burst of freshness.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Lombardy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "medium_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Fogoneu",
        "synonyms": [
            "Fogoneau",
            "Fogonet",
            "Fogonetxo",
            "Fogoneu Frances",
            "Fogoneu Mallorquí",
        ],
        "description": {
            "default": "Minor Mallorcan, usually blended.",
            "julie": "",
            "sommelier": "Fogoneu is Mallorca’s secret handshake—light-bodied and low in tannin, it charms with whispers of red fruit, wild herbs, and a touch of earth, making it the perfect partner in blends or a breezy solo act for early drinking. This grape is a true taste of the Balearic Islands’ sun-drenched tradition.",
        },
        "color": "black",
        "regions": ["Mallorca", "Balearic Islands", "Spain"],
        "flavor_profile": ["red_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Fokiano",
        "synonyms": [
            "Damaskino",
            "Fokiana",
            "Fokiano Kokkino",
            "Fokiano Mavro",
            "Giouroukiko",
            "Ghiouroukiko",
            "Phokiano",
            "Phokiano Kokkineli",
            "Phokiano Mavro",
        ],
        "description": {
            "default": "Rare Greek variety almost lost in the confusion over its name and synonyms.",
            "julie": "",
            "sommelier": "Fokiano is a bold, full-bodied Greek gem, bursting with red and black fruit, spice, and earthy undertones—an island rarity that’s as intriguing as its many names. High in both acidity and alcohol, this grape crafts age-worthy wines that are a true taste of the Aegean’s wild spirit.",
        },
        "color": "black",
        "regions": ["Ikaria", "Rhodes", "Dodecanese Islands", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Folgasão",
        "synonyms": ["Cagarrizo", "Silveiriña"],
        "description": {
            "default": "Robust Iberian variety with complex origins.",
            "julie": "",
            "sommelier": "Folgasão, also known as Cagarrizo or Silveiriña, is a zesty Iberian white grape that dazzles with high acidity and a medley of citrus, stone fruit, and mineral notes—think of it as the spirited storyteller of Portugal and Galicia, equally at home in a rustic blend or a polished, age-worthy white.",
        },
        "color": "white",
        "regions": ["Portugal", "Douro", "Dão", "Galicia", "Spain"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Folignan",
        "synonyms": ["INRA 8476"],
        "description": {
            "default": "Recent Bordeaux cross authorized for the production of cognac.",
            "julie": "",
            "sommelier": "Folignan is Bordeaux’s bright newcomer, delivering a zesty medley of apple and pear with a floral lift and a mineral snap—think of it as the life of the party in a glass, perfect for lovers of crisp, unoaked whites or a fresh twist in your next Cognac.",
        },
        "color": "white",
        "regions": ["Bordeaux", "Cognac", "France"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "light_bodied", "unoaked", "varietal", "traditional"],
    },
    {
        "name": "Folle Blanche",
        "synonyms": [
            "Chalosse Blanche",
            "Dame Blanche",
            "Enrageat",
            "Enragé",
            "Folle",
            "Gros Plant",
            "Matza Zuri",
            "Mune Mahatsa",
            "Piquepoul",
            "Piquepoul du Gers",
            "Picpoul",
            "Picpoule",
        ],
        "description": {
            "default": "Productive but rot-prone and very acidic white variety.",
            "julie": "",
            "sommelier": "Folle Blanche is the zippy, vivacious sprite of the Loire, bursting with lemon, green apple, and a racy mineral edge—think of it as the ultimate palate awakener, perfect for those who crave a bracing, thirst-quenching white. Its high-wire acidity and light body make it a classic for refreshing table wines and sparkling delights.",
        },
        "color": "white",
        "regions": [
            "Loire Valley",
            "Pays Nantais",
            "Southwest France",
            "Bas-Armagnac",
            "Cognac",
        ],
        "flavor_profile": ["citrus", "apple", "mineral", "lemon"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
            "sparkling",
        ],
    },
    {
        "name": "Fonte Cal",
        "synonyms": ["Fonte de Cal"],
        "description": {
            "default": "Minor Portuguese variety that rarely takes a leading role.",
            "julie": "",
            "sommelier": "Fonte Cal is Portugal’s quiet virtuoso, lending zesty citrus, delicate stone fruit, and a whisper of minerality to light-bodied blends—perfect for those who love their whites crisp, floral, and ready to drink without delay.",
        },
        "color": "white",
        "regions": ["Portugal", "Dão"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "table_wine",
            "light_bodied",
            "unoaked",
            "early_drinking",
        ],
    },
    {
        "name": "Forastera",
        "synonyms": ["Forastiera", "Forestiera", "Frastera", "Uva dell’Isola"],
        "description": {
            "default": "Ischian speciality.",
            "julie": "",
            "sommelier": "Forastera is Ischia’s zesty island gem, delivering a breezy bouquet of citrus, apple, and wildflowers with a mineral snap—think of it as a Mediterranean sea breeze in a glass, perfect for sun-drenched afternoons.",
        },
        "color": "white",
        "regions": ["Ischia", "Campania", "Italy"],
        "flavor_profile": ["citrus", "floral", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Forcallat Tinta",
        "synonyms": [
            "Alcabril di Gualadin",
            "Forcalla",
            "Forcalla Negra",
            "Forcalla Prieta",
            "Verdal",
            "Verdalejo",
            "Verdalla",
        ],
        "description": {
            "default": "Late-ripening central Spanish variety used in blends.",
            "julie": "",
            "sommelier": "Forcallat Tinta is the unsung hero of central Spain, weaving together juicy plum and cherry with earthy spice and a mineral backbone—perfect for those who crave a medium-bodied red that’s as versatile as it is intriguing. Often found in blends, this grape brings a harmonious balance of fruit and structure, making every sip a delightful Spanish adventure.",
        },
        "color": "black",
        "regions": ["Castilla-La Mancha", "Valencia", "Alicante", "Murcia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "medium_bodied"],
    },
    {
        "name": "Forsellina",
        "synonyms": ["Forcelina", "Forselina", "Forsella", "Forsellana", "Forzelina"],
        "description": {
            "default": "Rarity occasionally blended into Valpolicella or Bardolino.",
            "julie": "",
            "sommelier": "Forsellina is the elusive supporting actor of Veneto, lending its juicy cherry, plum, and earthy spice to classic blends—think of it as the secret ingredient that gives Valpolicella and Bardolino their charming depth and early-drinking appeal.",
        },
        "color": "black",
        "regions": ["Veneto", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Fortana",
        "synonyms": [
            "Canèna",
            "Canina Nera",
            "Cannina",
            "Costa d’Oro",
            "Oliva",
            "Rapa",
            "Uva Cornetta",
            "Uva d’Oro",
            "Uva d’Oro di Comacchio",
            "Uva Francese Nera",
            "Uva Vecchia",
        ],
        "description": {
            "default": "Late-ripening, declining Italian red prized for its high yields.",
            "julie": "",
            "sommelier": "Fortana is the lively, rustic charmer of Northern Italy, delivering a basket of cherries and plums with a whisper of earth and herbs. With its zippy acidity and feather-light body, this grape is perfect for those who crave a refreshing, unoaked red that sings of Emilia-Romagna’s countryside.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Ferrara", "Po Delta", "Northern Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "herbal",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Francavidda",
        "synonyms": ["Francavilla"],
        "description": {
            "default": "Minor and dwindling vine found in Brindisi, generally blended.",
            "julie": "",
            "sommelier": "Francavidda is a charmingly elusive white grape from Puglia, offering a breezy medley of citrus, stone fruit, and delicate florals with a mineral backbone—think of it as the sun-dappled countryside in a glass, best enjoyed young and in good company.",
        },
        "color": "white",
        "regions": ["Brindisi", "Puglia", "Southern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Frâncuşă",
        "synonyms": [
            "Frâncuşe",
            "Frîncuşă",
            "Mustoasă",
            "Mustoasă de Moldova",
            "Poamă Creaţă",
            "Poamă Franchie",
            "Poamă Muştei",
            "Târţără",
            "Vinoasă",
        ],
        "description": {
            "default": "North-east Romanian variety producing fresh and relatively light, dry whites for early drinking.",
            "julie": "",
            "sommelier": "Frâncuşă is Romania’s zesty white gem, bursting with citrus and apple, a whisper of wildflowers, and a crisp mineral finish—think of it as a mountain spring in a glass, perfect for those who crave refreshment and vibrancy in every sip.",
        },
        "color": "white",
        "regions": ["Romania", "Moldova"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Frappato",
        "synonyms": [
            "Frappato di Vittoria",
            "Frappato Nero",
            "Frappatu",
            "Nero Capitano",
            "Surra",
        ],
        "description": {
            "default": "Fruity, fresh and floral Sicilian often blended with Nero d’Avola.",
            "julie": "",
            "sommelier": "Frappato is Sicily’s answer to a summer red: bursting with cherry and raspberry, kissed by wildflowers and herbs, and as breezy as a Mediterranean afternoon. Light on its feet and low in tannin, it’s the perfect companion for a sun-drenched table and good company.",
        },
        "color": "black",
        "regions": ["Sicily", "Vittoria"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Fraueler",
        "synonyms": ["Frauler", "Vezzaner"],
        "description": {
            "default": "Rare, high-yielding and acidic Tyrolean white.",
            "julie": "",
            "sommelier": "Fraueler is a zesty Tyrolean gem, bursting with citrus and apple flavors, delicate florals, and a crisp mineral finish—think of it as the alpine breeze in a glass, perfect for those who crave a lively, thirst-quenching white.",
        },
        "color": "white",
        "regions": ["Alto Adige", "Trentino", "Tyrol", "South Tyrol"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Fredonia",
        "synonyms": ["Early Concord"],
        "description": {
            "default": "New York hybrid found mainly in Pennsylvania.",
            "julie": "",
            "sommelier": "Fredonia, the vivacious offspring of New York’s vineyards, charms with a burst of blackberry and blue fruit, accented by floral whispers and earthy intrigue. With its zippy acidity and gentle tannins, this light-bodied red is the perfect companion for casual sipping and lively gatherings.",
        },
        "color": "black",
        "regions": [
            "New York",
            "Pennsylvania",
            "Lake Erie AVA",
            "Eastern United States",
        ],
        "flavor_profile": [
            "black_fruit",
            "blue_fruit",
            "floral",
            "earth",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Freisa",
        "synonyms": [
            "Freisa di Chieri",
            "Freisa Piccola",
            "Freisetta",
            "Fresia",
            "Monferrina",
            "Mounfrina",
            "Spannina",
        ],
        "description": {
            "default": "Light, fragrant, unusual Nebbiolo relative, made in a wide range of styles, including frothy.",
            "julie": "",
            "sommelier": "Freisa is Piedmont’s playful rebel, bursting with cherry and raspberry, a whiff of violets, and a spicy, earthy twist—sometimes even with a frothy sparkle. This lively, high-acid cousin of Nebbiolo is a must-try for those who crave something both traditional and refreshingly offbeat.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy", "Monferrato", "Chieri"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Freisamer",
        "synonyms": [],
        "description": {
            "default": "Early-twentieth-century German cross in severe decline.",
            "julie": "",
            "sommelier": "Freisamer is a crisp, high-acid German white that charms with orchard fruit, delicate florals, and a stony backbone—think of it as the shy but witty guest at the table, quietly elevating any gathering with its refreshing presence.",
        },
        "color": "white",
        "regions": ["Germany", "Baden"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Frontenac",
        "synonyms": ["MN 1047"],
        "description": {
            "default": "Successfully cold-hardy American hybrid thriving particularly in its home state of Minnesota.",
            "julie": "",
            "sommelier": "Frontenac is the Minnesota maverick of the grape world, bursting with juicy cherry and blackberry flavors, zippy acidity, and a plucky spirit that thrives where most vines fear to tread. Whether in a bright red or a playful rosé, it delivers a refreshing, fruit-forward experience perfect for chilly evenings or summer picnics alike.",
        },
        "color": "black",
        "regions": [
            "Minnesota",
            "Wisconsin",
            "Vermont",
            "New York",
            "Canada (Quebec, Ontario)",
        ],
        "flavor_profile": ["red_fruit", "cherry", "plum", "blackberry"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Frühroter Veltliner",
        "synonyms": [
            "Früher Roter Malvasier",
            "Korai Piros Veltelini",
            "Malvasier",
            "Malvoisie Rouge d’Italie",
            "Velteliner Rouge Précoce",
            "Veltlínské Červené Rané",
            "Veltlínske Červené Skoré",
        ],
        "description": {
            "default": "Tentacular in its relations but Grüner Veltliner is not one of them.",
            "julie": "",
            "sommelier": "Frühroter Veltliner is Austria’s charming underdog—a light, floral, and nutty sipper with whispers of bitter almond, perfect for easy, early enjoyment. Once a local staple, it now quietly graces tables as a gentle, low-alcohol companion, best savored young and carefree.",
        },
        "color": "red",
        "regions": ["Thermenregion", "Weinviertel", "Wagram", "Lower Austria"],
        "flavor_profile": ["floral", "nuts"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Fubiano",
        "synonyms": ["Incrocio Dalmasso II/32"],
        "description": {
            "default": "Barely significant white cross from northern Italy.",
            "julie": "",
            "sommelier": "Fubiano is northern Italy’s best-kept secret: a featherweight white with zesty citrus, crisp apple, and a whisper of wildflowers, perfect for those who prefer their wines as lively and unpretentious as a spring picnic. This rare varietal is a charming companion for light fare and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Piedmont", "Lombardy", "Veneto"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Fuella Nera",
        "synonyms": [
            "Dame Noire",
            "Folle de Nice",
            "Folle Noire",
            "Fuella",
            "Fuola",
            "Jurançon Rouge",
        ],
        "description": {
            "default": "Minor but aromatic variety at home on the French Riviera.",
            "julie": "",
            "sommelier": "Fuella Nera is the Riviera’s aromatic secret, offering a breezy medley of red fruit, wild herbs, and a dash of spice in a light, easy-drinking frame—perfect for a sunlit Provençal lunch. This grape is a delightful reminder that sometimes the best treasures are found off the beaten path.",
        },
        "color": "black",
        "regions": ["Provence", "Nice", "Southern France", "French Riviera"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Furmint",
        "synonyms": [
            "Fehér Furmint",
            "Lazafürtű Furmint",
            "Moslavac",
            "Moslavac Bijeli",
            "Mosler",
            "Šipon",
            "Som",
            "Szigeti",
            "Tokay",
            "Változó Furmint",
            "Zapfner",
            "Zopfner",
        ],
        "description": {
            "default": "The principal variety of the fiery, high-acid wines of Tokaj in Hungary.",
            "julie": "",
            "sommelier": "Furmint is the electrifying backbone of Hungary’s Tokaji, dazzling with high-wire acidity and a kaleidoscope of flavors from citrus and apple to honeyed minerality—think of it as the white grape that can do it all, from zesty dry sippers to opulent dessert treasures.",
        },
        "color": "white",
        "regions": ["Hungary", "Slovakia", "Austria", "Croatia"],
        "flavor_profile": ["citrus", "apple", "pear", "peach", "honey", "mineral"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Gaglioppo",
        "synonyms": [
            "Arvino Nero",
            "Cirotana",
            "Gaglioppo di Cirò",
            "Galloppo",
            "Morellino Pizzuto",
            "Navarna",
        ],
        "description": {
            "default": "The characterful red wine grape of Calabria.",
            "julie": "",
            "sommelier": "Gaglioppo is Calabria’s charismatic red, delivering a sun-drenched medley of cherry, plum, and spice, all wrapped in earthy, age-worthy elegance. This grape is the soulful heart of Cirò, offering a taste of southern Italy’s wild beauty in every glass.",
        },
        "color": "black",
        "regions": ["Calabria", "Cirò", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
            "dried_fruit",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Gaidouria",
        "synonyms": ["Gaidouricha", "Gaidouriha", "Gaydura", "Guydourina"],
        "description": {
            "default": "Very rare variety just surviving on the Greek island of Santoríni.",
            "julie": "",
            "sommelier": "Gaidouria is Santoríni’s secret handshake—a zesty, mineral-driven white grape that dazzles with citrus and stone fruit, all wrapped in a breezy, floral embrace. Light-bodied and lively, it’s a rare island gem that whispers of sun, sea, and volcanic soil.",
        },
        "color": "white",
        "regions": ["Santoríni", "Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Galbenă De Odobești",
        "synonyms": [
            "Bucium de Poamă Galbenă",
            "Galbenă di Căpătanu",
            "Galbenă Grasă",
            "Galbenă Uriașă",
            "Poamă Galbenă",
        ],
        "description": {
            "default": "Gradually declining Romanian variety producing everyday whites.",
            "julie": "",
            "sommelier": "Galbenă De Odobești is Romania’s cheerful white, bursting with crisp apple and pear flavors, a hint of blossom, and a zesty citrus finish—perfect for easy sipping and lively gatherings. This light-bodied, unoaked charmer is the everyday hero of Odobești, bringing a taste of Romanian sunshine to your glass.",
        },
        "color": "white",
        "regions": ["Romania", "Odobești"],
        "flavor_profile": ["apple", "pear", "floral", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Galego Dourado",
        "synonyms": [
            "Dourado",
            "False Pedro",
            "Gallego",
            "Moscato Galego Dourado",
            "Olho de Lebre",
            "Pedro Luis",
            "Rutherglen Pedro",
        ],
        "description": {
            "default": "Rare Portuguese clings on.",
            "julie": "",
            "sommelier": "Galego Dourado is Portugal’s golden secret, offering a lively medley of citrus, stone fruit, and delicate florals atop a whisper-light frame. This rare grape brings a mineral elegance to the glass, making every sip a refreshing tribute to its storied homeland.",
        },
        "color": "white",
        "regions": ["Portugal", "Douro", "Lisboa"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "traditional",
            "varietal",
            "blend",
            "table_wine",
        ],
    },
    {
        "name": "Gallioppo Delle Marche",
        "synonyms": [
            "Balsamina Galloppa",
            "Balsamina Grossa",
            "Gaglioppa",
            "Galloppa",
            "Lancianese Nero",
            "Moretta",
        ],
        "description": {
            "default": "Recently rescued and replanted central Italian vine that may be related to Sangiovese.",
            "julie": "",
            "sommelier": "Gallioppo Delle Marche is a charismatic Italian grape, bursting with lively cherry and plum flavors, accented by herbal and earthy undertones. With its zesty acidity and medium structure, it crafts reds that are as charming at the dinner table today as they are after a few years in the cellar.",
        },
        "color": "black",
        "regions": ["Marche", "Abruzzo", "Lazio"],
        "flavor_profile": ["red_fruit", "cherry", "plum", "herbal", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
            "age_worthy",
        ],
    },
    {
        "name": "Gallizzone",
        "synonyms": ["Gallazzone"],
        "description": {
            "default": "Tuscan red on the verge of extinction.",
            "julie": "",
            "sommelier": "Gallizzone is Tuscany’s elusive black pearl, offering a vibrant medley of red and black fruits dusted with earth and spice, all wrapped in a lively, medium-bodied frame—an endangered treasure for adventurous palates.",
        },
        "color": "black",
        "regions": ["Tuscany", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "traditional",
            "varietal",
            "blend",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Gamaret",
        "synonyms": ["Pully B-13"],
        "description": {
            "default": "Increasingly popular Swiss cross valued for its early ripening and resistance to rot.",
            "julie": "",
            "sommelier": "Gamaret is Switzerland’s bold answer to powerful reds, flaunting a deep purple hue, spicy black fruit aromas, and a tannic backbone that begs for barrel aging. Whether blended or solo, this grape delivers a full-bodied, age-worthy wine that’s as intriguing as the Alpine slopes it calls home.",
        },
        "color": "black",
        "regions": ["Switzerland", "Vaud", "Geneva", "Valais"],
        "flavor_profile": ["black_fruit", "spice", "oak", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "oaked",
            "full_bodied",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Gamay Noir",
        "synonyms": [
            "Beaujolais",
            "Bourguignon Noir",
            "Gamai",
            "Gamai Chatillon",
            "Gamay",
            "Gamay Beaujolais",
            "Gamay Charmont",
            "Gamay d’Arcenant",
            "Gamay d’Auvergne",
            "Gamay de la Dôle",
            "Gamay de Liverdun",
            "Gamay de Saint-Romain",
            "Gamay de Sainte-Foix",
            "Gamay de Toul",
            "Gamay de Vaux",
            "Gamay d’Orléans",
            "Gamay du Gâtinais",
            "Gamay Labronde",
            "Gamay Noir à Jus Blanc",
            "Gamay Ovoïde",
            "Gamay Précoce",
            "Gamé",
            "Gammé",
            "Grosse Dôle",
            "Liverdun Grand",
            "Lyonnais",
            "Petit Gamay",
            "Plant Robert",
        ],
        "description": {
            "default": "Greater Burgundian refresher making wines generally but not always for early consumption.",
            "julie": "",
            "sommelier": "Gamay Noir is the life of the party in a glass—bursting with juicy raspberries and cherries, this light-bodied, high-acid charmer is best enjoyed young for its irresistible freshness and flirtatious red fruit aromas. Think of it as Burgundy’s breezy, fun-loving cousin, perfect for picnics or a lively dinner with friends.",
        },
        "color": "black",
        "regions": ["Beaujolais", "Burgundy", "Switzerland", "Loire Valley"],
        "flavor_profile": ["red_fruit", "raspberry", "cherry"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Gamay Teinturier De Bouze",
        "synonyms": [
            ": Gamay de Bouze",
            "Moureau",
            "Mourot",
            "Plant de Bouze",
            "Rouge de Bouze",
        ],
        "description": {
            "default": "Red-fleshed variety possibly related to the more common Gamay Noir but much less widely planted.",
            "julie": "",
            "sommelier": "Gamay Teinturier De Bouze is a rare, red-fleshed gem from France, delivering a juicy burst of cherry and raspberry with earthy spice, all wrapped in a lively, refreshing frame—think of it as the bold, eccentric cousin at the Gamay family reunion.",
        },
        "color": "black",
        "regions": ["France", "Loire Valley", "Burgundy"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "earth", "spice"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Gamba Di Pernice",
        "synonyms": ["Neretto degli Alteni", "Pernice"],
        "description": {
            "default": "Rare, aromatic and spicy Piemontese.",
            "julie": "",
            "sommelier": "Gamba Di Pernice is Piedmont’s aromatic secret, bursting with red fruit, spice, and floral notes, all wrapped in a lively, medium-bodied frame. This rare grape delivers a spirited, earthy elegance that will charm any lover of Italian reds.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "spice", "floral", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "traditional", "premium", "table_wine"],
    },
    {
        "name": "Gänsfüsser",
        "synonyms": [
            "Argan",
            "Argant",
            "Bockshorn",
            "Buchser",
            "Espagnol",
            "Gros Margillien",
            "Margillien",
        ],
        "description": {
            "default": "Barely surviving ancient variety, probably German.",
            "julie": "",
            "sommelier": "Gänsfüsser is a nearly forgotten relic of the vine, weaving together red and black fruit with earthy, herbal whispers—think of it as the soulful storyteller of old German vineyards, perfect for those who crave a taste of history in their glass. Medium-bodied and balanced, this grape is a rare treat for adventurous palates seeking tradition with a twist.",
        },
        "color": "black",
        "regions": ["Germany", "Switzerland", "Alsace (France)"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Gara Ikeni",
        "synonyms": ["Gara Lkeni", "Qara Lkeni", "Lkeny Tchernyi"],
        "description": {
            "default": "Azeri grape used for both dry and sweet reds.",
            "julie": "",
            "sommelier": "Gara Ikeni is the dark jewel of Azerbaijan, offering a tapestry of plum, cherry, and blackberry flavors dusted with spice and earth. Whether in a robust red or a luscious dessert wine, this grape charms with its balanced structure and a whisper of the Caucasus in every sip.",
        },
        "color": "black",
        "regions": ["Azerbaijan", "Caucasus"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "table_wine",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Garandmak",
        "synonyms": ["Alani Chagog", "Alivoruk", "Dik Chardji", "Garan Dmak"],
        "description": {
            "default": "Old, popular and multi-purpose Armenian variety.",
            "julie": "",
            "sommelier": "Garandmak is Armenia’s lively white grape, offering a charming medley of stone fruit, crisp apple, and delicate floral notes, all wrapped in a refreshing mineral finish. Perfect for early sipping, this versatile variety brings a taste of Armenian tradition to your glass.",
        },
        "color": "white",
        "regions": ["Armenia"],
        "flavor_profile": ["stone_fruit", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Garanoir",
        "synonyms": ["Pully B-28"],
        "description": {
            "default": "Swiss cross producing fruity but low-acid wines.",
            "julie": "",
            "sommelier": "Garanoir is Switzerland’s answer to easygoing red wine—bursting with juicy cherries and plums, it charms with soft tannins and a gentle, fruit-forward style that’s perfect for sharing with friends over a lively meal. This grape is a delightful Swiss secret, offering a smooth, medium-bodied sip that’s as inviting as an Alpine picnic.",
        },
        "color": "black",
        "regions": ["Switzerland", "Vaud", "Valais", "Geneva"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum"],
        "acidity": "Low",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Garganega",
        "synonyms": [
            "Grecanico Dorato",
            "Malvasía de Manresa",
            "Grecanico",
            "Garganega Bianca",
        ],
        "description": {
            "default": "A delicate white closely associated with Soave whose vigour and yields need strict control.",
            "julie": "",
            "sommelier": "Garganega is the elegant backbone of Soave, offering a zesty medley of citrus, pear, and peach, all wrapped in a floral, mineral embrace—think of it as Italy’s answer to a summer breeze in a glass, equally at home on a sunlit terrace or a white-tablecloth dinner.",
        },
        "color": "white",
        "regions": ["Veneto", "Sicily"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "pear",
            "peach",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Garnacha Tinta",
        "synonyms": [
            "Abundante",
            "Aragones",
            "Bernacha Negra",
            "Bois Jaune",
            "Cannonao",
            "Cannonau",
            "Crannaxia",
            "Granaxia",
            "Vrannaxia",
            "Garnacha",
            "Garnaxa",
            "Gironet",
            "Granache",
            "Granaxa",
            "Grenache",
            "Grenache Crni",
            "Grenache Noir",
            "Lladoner",
            "Redondal",
            "Ranaccio",
            "Sans Pareil",
            "Tinto Basto",
            "Tocai Rosso",
            "Vernaccia Nera",
            "Gamay del Trasimeno",
        ],
        "description": {
            "default": "Very widely planted, long-lived vine making strong, sweetish reds and some successful rosés.",
            "julie": "One of the world's most planted grape variety that can thrive in hot and dry climate. Also known as Garnacha in Spain, it is often blended with Syrah and Mourvèdre - sometimes labelled then at GSM. In France, it thrives in the Southern Rhône and the Languedoc Roussillon. In the Rhône Valley, Grenache Noir has made the reputation of wines such as Châteauneuf-du-Pape, Gigondas and Vacqueyras where it is usually blended with Syrah and Mourvèdre. In the Roussillon, it produces some delicious fortified wines (Vins Doux Naturels) sold under the names Banyuls and Maury. In Spain, a new wave of perfumed, digest and elegant grenache have appeared in the regions of Gredos and Mentrida, near Madrid. In Catalonia, producers in the region of Priorat are making big, powerful wines grown on llicorella schist. Grenacge is also planted in Australia, California, Sardinia, etc. ",
            "sommelier": "Garnacha Tinta, the globe-trotting chameleon of the wine world, dazzles with juicy red fruit, spice, and a sun-kissed earthiness—whether starring in legendary Rhône blends or powering the bold, mineral-laced reds of Priorat. With its generous body and high spirits, this grape is as comfortable in a rustic village bistro as it is at a grand celebration.",
        },
        "color": "black",
        "regions": [
            "Southern Rhône (France)",
            "Languedoc Roussillon (France)",
            "Priorat (Spain)",
            "Catalonia (Spain)",
            "Gredos (Spain)",
            "Mentrida (Spain)",
            "Australia",
            "California",
            "Sardinia (Italy)",
        ],
        "flavor_profile": [
            "red_fruit",
            "spice",
            "earth",
            "herbal",
            "mineral",
            "plum",
            "cherry",
            "raspberry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "rosé",
            "fortified",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Garnacha Blanca",
        "synonyms": [
            "Alicant Belyi",
            "Alicante Blanca",
            "Belan",
            "Belon",
            "Bernacha Blanca",
            "Fehér Grenache",
            "Garnacha",
            "Garnacho Blanco",
            "Garnatxa",
            "Garnatxa Blanca",
            "Gkrenas Mplan",
            "Grenache Blanc",
            "Grenash Beli",
            "Grenash Belyi",
            "Grenash Bjal",
            "Lladanor Blanca",
            "Rool Grenache",
            "Silla Blanc",
            "Sillina Lanc",
        ],
        "description": {
            "default": "Full-bodied whites, pale version of the reds.",
            "julie": "Garnacha Blanca is mostly found in the Roussillon region in France but also in Catalonia and Aragon in Spain. Traditionnaly grown for the production of Vin Doux Naturel in France, it is more often blended than sold as a single grape variety for the production of table wine. It can produce however some outstading white wines with great subtance, texture and fragrance. ",
            "sommelier": "Garnacha Blanca is the white grape that thinks it's red—full-bodied, fragrant, and brimming with stone fruit, citrus, and a whisper of herbs and nuts. Whether blended or solo, it delivers a textured, age-worthy white that’s as at home in a sun-drenched Catalan vineyard as it is in your glass.",
        },
        "color": "white",
        "regions": [
            "Roussillon",
            "Catalonia",
            "Aragon",
            "Languedoc",
            "Navarra",
            "Priorat",
        ],
        "flavor_profile": [
            "stone_fruit",
            "citrus",
            "floral",
            "herbal",
            "mineral",
            "nuts",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "full_bodied",
            "blend",
            "varietal",
            "oaked",
            "unoaked",
            "table_wine",
            "dessert",
            "fortified",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Garnacha Roja (Gris)",
        "synonyms": [
            "Garnacha Gris",
            "Garnacha Rioja",
            "Garnacho Rojo",
            "Garnatxa Gris",
            "Grenache Gris",
            "Grenache Rouge",
            "Grey Grenache",
            "Piros Grenache",
            "Rosco dos Pinheiro",
            "Szuerke Grenache",
        ],
        "description": {
            "default": "Perfumed and full-bodied.",
            "julie": "",
            "sommelier": "Garnacha Roja (Gris) dazzles with its perfumed bouquet and plush, full-bodied character, offering a lively medley of peach, pear, and citrus over a subtle mineral backbone. This rare pink-hued grape crafts exuberant whites and rosés that are as charmingly aromatic as they are deliciously drinkable.",
        },
        "color": "grey and pink",
        "regions": ["Spain", "France", "Catalonia", "Roussillon", "Rioja"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "mineral",
            "peach",
            "pear",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "rosé",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Garnacha Peluda",
        "synonyms": [
            "Garnatxa Pelud",
            "Garnatxa Peluda",
            "Grenache d’Afrique",
            "Grenache Noir Tomenteux",
            "Grenache Poilu",
            "Grenache Velu",
            "Lladoner Pelud",
            "Lledoner Pelut",
        ],
        "description": {
            "default": "Downy-leaved variant of Garnacha Tinta.",
            "julie": "",
            "sommelier": 'Garnacha Peluda, the "fuzzy" cousin of Garnacha, delights with a plush medley of plum, raspberry, and earthy spice, all wrapped in a medium-bodied, velvety embrace—perfect for those who like their reds with a touch of wild intrigue and immediate charm.',
        },
        "color": "black",
        "regions": [
            "Catalonia",
            "Aragon",
            "Navarra",
            "Priorat",
            "Terra Alta",
            "Spain",
            "Languedoc",
            "France",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "spice",
            "earth",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "table_wine",
            "medium_bodied",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Garrido Fino",
        "synonyms": [
            "Charrido Fino",
            "Garrido",
            "Garrido Fino de Villanueva",
            "Garrio Fino",
            "Palomino Garrio",
        ],
        "description": {
            "default": "Very minor, acidic variety from Huelva in southern Spain.",
            "julie": "",
            "sommelier": "Garrido Fino is a zesty Andalusian gem, bursting with citrus and apple brightness over a crisp mineral backbone—think of it as the lively flamenco dancer of southern Spain’s vineyards, perfect for those who crave refreshment and a taste of the region’s sun-soaked terroir.",
        },
        "color": "white",
        "regions": ["Huelva", "Andalusia", "Southern Spain"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gascon",
        "synonyms": [
            "Franc Noir de l’Yonne",
            "Franc Noir du Gâtinais",
            "Noirien",
            "Plant de Moret",
        ],
        "description": {
            "default": "Rare Touraine vine.",
            "julie": "",
            "sommelier": "Gascon is a Loire Valley gem, offering a lively medley of cherry and raspberry with a whisper of wild herbs and earth, all wrapped in a feather-light frame. This rare varietal is a sommelier’s secret for those who crave a refreshing, unoaked red with a dash of French countryside charm.",
        },
        "color": "black",
        "regions": ["Touraine", "Loire Valley", "France"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Gegić",
        "synonyms": [
            "Debejan",
            "Debljan",
            "Gegić Bijeli",
            "Paška",
            "Paškinja",
            "Žutina",
        ],
        "description": {
            "default": "Speciality of the Croatian island of Pag.",
            "julie": "",
            "sommelier": "Gegić is the zesty island gem of Pag, delivering a breezy bouquet of citrus, stone fruit, and wildflowers over a crisp, mineral backbone—perfect for sun-drenched afternoons and seaside feasts. This lively Croatian white is a true taste of the Adriatic, as refreshing as a sea breeze and as unique as its island home.",
        },
        "color": "white",
        "regions": ["Croatia", "Pag Island", "Dalmatia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ġellewża",
        "synonyms": ["Gelleuza"],
        "description": {
            "default": "Second most planted Maltese variety but being edged out by international invaders.",
            "julie": "",
            "sommelier": "Ġellewża is Malta’s spirited native, offering a breezy dance of red fruit, wild herbs, and delicate florals in a light-bodied, easy-drinking style—perfect for those seeking a taste of Mediterranean tradition before it’s swept away by global trends.",
        },
        "color": "black",
        "regions": ["Malta"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Genouillet",
        "synonyms": ["Genouilleret", "Genouillet Noir", "Moret Noir"],
        "description": {
            "default": "Recently rescued central French vine.",
            "julie": "",
            "sommelier": "Genouillet is a spirited French rarity, bursting with cherry, plum, and raspberry, underpinned by earthy minerality and a zippy acidity that makes it a joy to drink young. This rescued grape from the heart of France delivers a charming, medium-bodied red that’s as lively and intriguing as its history.",
        },
        "color": "black",
        "regions": ["Central France", "Loire Valley", "Berry", "Auvergne"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gibi",
        "synonyms": [
            "Alzibib",
            "Aparia",
            "Augibi",
            "Jubi Blanc",
            "Maccabeu à Gros Grains",
            "Panse Blanche",
            "Passerille Blanche",
            "Tercia Blanc",
        ],
        "description": {
            "default": "Ancient Spanish table grape still planted in Argentina with significant offspring.",
            "julie": "",
            "sommelier": "Gibi is a charming relic of Spanish viticulture, offering a bouquet of apple, pear, and delicate florals in a light, refreshing frame—perfect for those who prefer their wines as lively and unpretentious as a summer afternoon. With its ancient roots and easy-drinking style, Gibi is a delightful companion for early sipping and convivial gatherings.",
        },
        "color": "white",
        "regions": ["Spain", "Argentina"],
        "flavor_profile": ["apple", "pear", "floral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Ginestra",
        "synonyms": ["Biancatenera", "Biancazita", "Ginestro", "Nocella"],
        "description": {
            "default": "Minor but interesting and refreshing Campanian.",
            "julie": "",
            "sommelier": "Ginestra is Campania’s zesty secret, bursting with citrus and delicate floral notes over a crisp mineral backbone—think of it as a sunbeam in a glass, perfect for those who crave refreshment and a taste of southern Italian tradition.",
        },
        "color": "white",
        "regions": ["Campania"],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Girgentina",
        "synonyms": ["Ghirghentina", "Insolja Tal-Girgenti"],
        "description": {
            "default": "The most planted Maltese variety, producing soft, light whites but under threat from Chardonnay.",
            "julie": "",
            "sommelier": "Girgentina is Malta’s breezy white gem, offering a sun-kissed medley of citrus and stone fruit with a whisper of wildflowers and sea-spray minerality—perfect for sipping seaside before the Chardonnay crowd arrives.",
        },
        "color": "white",
        "regions": ["Malta"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Girò",
        "synonyms": [
            "Girò Comune",
            "Girò Rosso di Spagna",
            "Girone di Spagna",
            "Zirone",
        ],
        "description": {
            "default": "Cherry-flavoured Sardinian red used to make dry, sweet and fortified wines.",
            "julie": "",
            "sommelier": "Girò is Sardinia’s sultry secret, bursting with ripe cherry flavors and a velvet embrace, equally at home in bold reds or decadent dessert wines. This grape’s full body and high spirits make every glass a sun-drenched Mediterranean adventure.",
        },
        "color": "black",
        "regions": ["Sardinia"],
        "flavor_profile": ["red_fruit", "cherry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "dessert",
            "fortified",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Giró Blanc",
        "synonyms": ["Girò Roz"],
        "description": {
            "default": "Recently rescued, high-quality, aromatic, full-bodied Mallorcan.",
            "julie": "",
            "sommelier": "Giró Blanc is Mallorca’s aromatic treasure, delivering a lush, full-bodied experience bursting with floral, stone fruit, and tropical flavors, all wrapped in a mineral embrace. This recently rediscovered grape crafts premium, age-worthy whites and rosés that are as vibrant and sun-kissed as the Balearic Islands themselves.",
        },
        "color": "pink",
        "regions": ["Mallorca", "Balearic Islands", "Spain"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "rosé",
            "full_bodied",
            "varietal",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Glavinuša",
        "synonyms": ["Carnjenak", "Glavanjuša", "Glavinka", "Okatac", "Okatac Crni"],
        "description": {
            "default": "Very rare Croatian variety sometimes useful for the Dalmatian sweet wine Prošek.",
            "julie": "",
            "sommelier": "Glavinuša is Dalmatia’s hidden gem, weaving together black fruit, dried fruit, and earthy spice into a full-bodied, high-octane tapestry—perfect for those who crave a taste of Croatian tradition in every glass. Rarely seen outside its homeland, this grape brings both power and mystique to red blends and the legendary Prošek dessert wine.",
        },
        "color": "black",
        "regions": ["Dalmatia", "Croatia"],
        "flavor_profile": ["black_fruit", "dried_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "dessert", "blend", "traditional", "age_worthy"],
    },
    {
        "name": "Godello",
        "synonyms": [
            "Agodello",
            "Agodenho",
            "Agudanho",
            "Agudelha",
            "Agudelho",
            "Agudello",
            "Agudelo",
            "Agudenho",
            "Berdello",
            "Godelho",
            "Godella",
            "Godenho",
            "Gouveio",
            "Ojo de Gallo",
            "Prieto Picudo Blanco",
            "Trincadente",
            "Verdelho",
            "Verdelho do Dão",
        ],
        "description": {
            "default": "Very high-quality variety undergoing a revival, under several names, in north-western Iberia.",
            "julie": "",
            "sommelier": "Godello is the comeback kid of Galicia, dazzling with zesty citrus, juicy stone fruit, and a whisper of minerality, all wrapped in a refreshing, high-acid package. Whether crisp and unoaked or luxuriously aged, this grape delivers a sophisticated sip that’s as lively as a Spanish fiesta.",
        },
        "color": "white",
        "regions": [
            "Galicia",
            "Valdeorras",
            "Bierzo",
            "Ribeira Sacra",
            "Monterrei",
            "Dão",
            "Douro",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "pear",
            "peach",
            "mineral",
            "floral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Goldburger",
        "synonyms": ["Klosterneuburg 16-8", "Orangeriesling"],
        "description": {
            "default": "Generally unexciting pale Austrian cross used mainly for sweet wines.",
            "julie": "",
            "sommelier": "Goldburger is Austria’s quiet achiever, offering a gentle bouquet of citrus and stone fruit with a whisper of florals—perfect for those who prefer their wines light, easy, and ready to drink now. While it may not steal the spotlight, its subtle charm shines in sweet and early-drinking styles.",
        },
        "color": "white",
        "regions": ["Austria"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Golden Muscat",
        "synonyms": ["New York 10303"],
        "description": {
            "default": "Minor American hybrid producing grapey dessert wines.",
            "julie": "",
            "sommelier": "Golden Muscat dazzles with a bouquet of tropical fruit, honey, and floral notes, delivering a lush, full-bodied dessert wine that’s as charming as a summer garden party in upstate New York. This hybrid grape’s medium acidity and gentle sweetness make it a crowd-pleaser for those who love their wines aromatic and irresistibly drinkable.",
        },
        "color": "white",
        "regions": ["United States", "New York"],
        "flavor_profile": ["tropical_fruit", "floral", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["white", "dessert", "varietal", "unoaked", "early_drinking"],
    },
    {
        "name": "Goldriesling",
        "synonyms": [
            "Franzosentraube",
            "Gelbriesling",
            "Goldmuskat",
            "Riesling Doré",
            "Risling Khativ",
            "Risling Zolotistyi",
        ],
        "description": {
            "default": "Alsace cross producing light, white quaffing wine, now a speciality of Sachsen in eastern Germany.",
            "julie": "",
            "sommelier": "Goldriesling is Saxony’s secret summer sipper—a vivacious white bursting with citrus, blossom, and stone fruit, all wrapped in a brisk, mineral-driven frame. Light-bodied and lively, it’s the perfect companion for early evenings and easy laughter.",
        },
        "color": "white",
        "regions": ["Sachsen (Saxony)", "Alsace"],
        "flavor_profile": ["citrus", "floral", "stone_fruit", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Golubok",
        "synonyms": ["Golubuk"],
        "description": {
            "default": "Red-fleshed Ukrainian hybrid also found in Russia.",
            "julie": "",
            "sommelier": "Golubok is a bold Ukrainian hybrid that delivers a symphony of black fruit, plum, and earthy spice, wrapped in a full-bodied embrace—perfect for those who crave both tradition and adventure in their glass.",
        },
        "color": "black",
        "regions": ["Ukraine", "Russia"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gorgollasa",
        "synonyms": ["Gargollasa", "Gargollosa", "Gorgollosa"],
        "description": {
            "default": "Recently resurrected, high-quality, red-fruited Mallorcan.",
            "julie": "",
            "sommelier": "Gorgollasa is Mallorca’s vinous comeback kid, offering a lively medley of cherry and raspberry wrapped in a perfectly balanced, medium-bodied frame. This rare gem is a must-try for adventurous palates seeking a taste of the Balearic Islands’ winemaking renaissance.",
        },
        "color": "black",
        "regions": ["Mallorca", "Balearic Islands", "Spain"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Goruli Mtsvane",
        "synonyms": [
            "Goruli Mcvané",
            "Kvishkhuri",
            "Mtsvane",
            "Mtsvané",
            "Suramula",
            "Tetrpotola",
        ],
        "description": {
            "default": "Fresh, fruity, light-skinned Georgian variety used to make both still and sparkling wines.",
            "julie": "",
            "sommelier": "Goruli Mtsvane is Georgia’s zesty white gem, bursting with citrus, stone fruit, and floral notes, all wrapped in a lively, high-acid frame—think of it as a crisp mountain breeze in a glass, perfect for those who crave freshness and a taste of tradition.",
        },
        "color": "white",
        "regions": ["Georgia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Gouais Blanc",
        "synonyms": [
            "Belina",
            "Belina Drobna",
            "Best’s no 4",
            "Blanció",
            "Bouilleaud",
            "Enfariné Blanc",
            "Foirard",
            "Gôt",
            "Gouais Jaune",
            "Gouget Blanc",
            "Gueuche Blanc",
            "Gwäss",
            "Hajnos",
            "Heunisch Weiss",
            "Heinsch",
            "Heinisch",
            "Krapinska Belina",
            "Liseiret",
            "Plant de Séchex",
            "Président",
            "Preveiral",
            "Provereau Blanc",
            "Weisser Heunisch",
            "Wippacher",
        ],
        "description": {
            "default": "Extremely important progenitor (with Pinot) even if almost extinct.",
            "julie": "",
            "sommelier": "Once the Cinderella of the vineyard, Gouais Blanc is the unsung hero behind many noble grapes, offering a lively medley of apple, pear, and lemon with a crisp, mineral edge—think of it as history in a glass, bright and refreshingly tart.",
        },
        "color": "white",
        "regions": ["France", "Germany", "Austria", "Switzerland", "Croatia"],
        "flavor_profile": ["apple", "pear", "lemon", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
            "blend",
            "traditional",
        ],
    },
    {
        "name": "Gouget Noir",
        "synonyms": [
            "Gouge Noir",
            "Gouget",
            "Goujet",
            "Lyonnais",
            "Nérou",
            "Neyran",
            "Neyrou",
        ],
        "description": {
            "default": "Rare and disappearing central French vine.",
            "julie": "",
            "sommelier": "Gouget Noir is a vanishing treasure from central France, offering a lively dance of cherry and raspberry atop earthy, mineral undertones in a light, unoaked red—perfect for those who seek the thrill of the undiscovered in their glass.",
        },
        "color": "black",
        "regions": ["Central France", "Allier", "Loire"],
        "flavor_profile": ["red_fruit", "earth", "mineral", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Goustolidi",
        "synonyms": [
            "Augoustelidi",
            "Augoustelli",
            "Avgoustolidi",
            "Bostilidas",
            "Goustoulidi",
            "Goystolidi",
            "Rompola",
            "Vostilidi",
            "Vostilida",
            "Voustolidi",
        ],
        "description": {
            "default": "Traditional, rustic Greek variety.",
            "julie": "",
            "sommelier": "Goustolidi is a zesty Greek white grape from Kefalonia, bursting with citrus and stone fruit flavors, a mineral backbone, and lively acidity—think of it as a sun-drenched Mediterranean breeze in a glass, perfect for seafood or a lazy afternoon by the sea.",
        },
        "color": "white",
        "regions": ["Greece", "Ionian Islands", "Kefalonia"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "varietal", "traditional", "table_wine", "premium"],
    },
    {
        "name": "Gr 7",
        "synonyms": ["Geneva Red 7", "NY 34791"],
        "description": {
            "default": "Minor but sturdy, winter-hardy complex American hybrid used mostly in blends.",
            "julie": "",
            "sommelier": "Gr 7, also known as Geneva Red 7, is the unsung hero of American hybrids—bringing a zesty medley of red and black fruits, earthy undertones, and a herbal twist to blends, all wrapped in a sturdy, winter-proof package. Perfect for those seeking a lively, early-drinking red with a refreshing bite and a touch of rustic charm.",
        },
        "color": "black",
        "regions": ["New York", "Finger Lakes", "Midwest USA"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "light_bodied", "early_drinking"],
    },
    {
        "name": "Graciano",
        "synonyms": [
            "Bovale",
            "Bovale Sardo",
            "Bovaleddu",
            "Caldareddhu",
            "Calda Reio",
            "Courouillade",
            "Graciana",
            "Minustellu",
            "Monastrell Menudo",
            "Monastrell Verdadero",
            "Morastell",
            "Morrastel",
            "Moristell",
            "Muristellu",
            "Tinta Miúda",
            "Tintilla de Rota",
            "Xeres",
        ],
        "description": {
            "default": "Low-yielding, richly coloured, perfumed variety that retains acidity and is regaining favour in Rioja.",
            "julie": "Graciano is a fragrant, fresh and sometimes spicy grape variety that is most often blended with other grape varieties to add brightness and perfume. It is regularly used in the region of Rioja. Graciano is also fashionable in Sardinia where it is called Bovale Sardo or Cagnulari.",
            "sommelier": "Graciano is the secret weapon of Rioja, infusing blends with a burst of floral perfume, juicy plum and cherry, and a spicy lift that keeps the palate dancing. With its high acidity and medium body, this grape crafts wines that are as lively as they are age-worthy—think of it as the elegant rebel in the Spanish vineyard.",
        },
        "color": "black",
        "regions": ["Rioja", "Sardinia", "Navarra", "Castilla-La Mancha"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "plum",
            "cherry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Graisse",
        "synonyms": [
            "Blanquette Grise",
            "Chalosse",
            "Gras",
            "Gras Blanc",
            "Grèce Blanche",
            "Plant de Graisse",
            "Plant de Grèce",
            "Président",
            "Ramassou Blanc",
            "Tizourine Bou-Afrara",
        ],
        "description": {
            "default": "Minor south-west French variety used mostly for armagnac.",
            "julie": "",
            "sommelier": "Graisse is a rare gem from Gascony, delivering a zesty burst of citrus and apple with a floral lift and mineral snap—think of it as the secret ingredient behind Armagnac’s finesse, or a crisp white for those who love their wines lively and light.",
        },
        "color": "white",
        "regions": ["South-West France", "Gascony", "Armagnac"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Grand Noir",
        "synonyms": [
            "Gran Negro",
            "Grand Bouschet",
            "Grand Noir de la Calmette",
            "Gros Noir",
            "Sumo Tinto",
        ],
        "description": {
            "default": "Pale red-fleshed nineteenth-century French cross with potential. Still found around the world.",
            "julie": "",
            "sommelier": "Grand Noir is a globe-trotting French original, offering a charming medley of red and black fruits dusted with earthy spice—think of it as the mysterious stranger at the wine party, equally at home in a blend or shining solo in a glass. With its medium everything—acidity, tannin, body, and alcohol—this grape delivers a balanced, approachable sip that’s as intriguing as its storied past.",
        },
        "color": "black",
        "regions": ["France", "Spain", "Portugal"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "table_wine",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Grapariol",
        "synonyms": [
            "Grappariol",
            "Rabosa Bianca",
            "Rabosina Bianca",
            "Rabosino Grappariol",
        ],
        "description": {
            "default": "Veneto variety recently rescued from extinction.",
            "julie": "",
            "sommelier": "Grapariol is Veneto’s vivacious comeback kid—a zippy, light-bodied white bursting with citrus, apple, and floral notes, all wrapped in a crisp, mineral-driven frame. This rare gem is a refreshing, unoaked delight that dances on the palate and begs for a sunny afternoon.",
        },
        "color": "white",
        "regions": ["Veneto"],
        "flavor_profile": ["citrus", "floral", "herbal", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Grasă De Cotnari",
        "synonyms": [
            "Bajor",
            "Fehér Kövérszőlő",
            "Fejérszőlő",
            "Gras",
            "Grasă",
            "Grasă de Cotnar",
            "Grasă Mare",
            "Grasă Mică",
            "Grasi",
            "Grassa",
            "Kövérszőlő",
            "Poamă Grasă",
            "Resertraube",
        ],
        "description": {
            "default": "Rare Romanian variety once famous for its sweet Cotnari wines, occasionally found in those of Tokaj in Hungary.",
            "julie": "",
            "sommelier": "Grasă De Cotnari is Romania’s golden treasure, weaving together honeyed stone fruit, dried apricot, and delicate florals into a full-bodied, high-acid symphony—perfect for those who crave a decadent, age-worthy dessert wine with a regal past.",
        },
        "color": "white",
        "regions": ["Romania", "Cotnari", "Hungary", "Tokaj"],
        "flavor_profile": [
            "stone_fruit",
            "dried_fruit",
            "honey",
            "floral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
            "reserve",
        ],
    },
    {
        "name": "Graševina",
        "synonyms": [
            "Borba",
            "Graševina Bijela",
            "Italian Riesling",
            "Laški Rizling",
            "Olasz Rizling",
            "Olaszrizling",
            "Riesling Italico",
            "Riesling Italian",
            "Rismi",
            "Rismi",
            "Risli",
            "Rizling Vlašský",
            "Ryzlink Vlašský",
            "Taljanska Graševina",
            "Wälschriesling",
            "Welschriesling",
        ],
        "description": {
            "default": "Unfairly maligned variety widely planted in Central Europe that has in its time suffered in comparison to Riesling.",
            "julie": "",
            "sommelier": "Graševina is Central Europe's unsung white grape hero, delivering zesty apple and pear flavors with a refreshing mineral streak—think of it as Riesling’s fun-loving, approachable sibling, perfect for both casual sipping and cellaring surprises.",
        },
        "color": "white",
        "regions": [
            "Croatia",
            "Hungary",
            "Austria",
            "Slovakia",
            "Czech Republic",
            "Slovenia",
            "Serbia",
            "Romania",
        ],
        "flavor_profile": ["apple", "pear", "lemon", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Grechetto Di Orvieto",
        "synonyms": ["Grechetto", "Grechetto Bianco", "Grechetto Spoletino"],
        "description": {
            "default": "Characterful and versatile Umbrian.",
            "julie": "",
            "sommelier": "Grechetto di Orvieto is Umbria’s charming chameleon, offering a delightful medley of pear, peach, and zesty citrus with a whisper of wildflowers and a mineral snap. Whether in a crisp table wine or a more polished blend, it’s the perfect companion for sun-drenched afternoons and lively Italian feasts.",
        },
        "color": "white",
        "regions": ["Umbria", "Orvieto", "Lazio"],
        "flavor_profile": [
            "stone_fruit",
            "pear",
            "peach",
            "citrus",
            "lemon",
            "floral",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "unoaked",
            "oaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Greco",
        "synonyms": [
            "Asprinio",
            "Greco del Vesuvio",
            "Greco della Torre",
            "Greco di Napoli",
            "Greco di Tufo",
            "Grieco di Castelvenere",
        ],
        "description": {
            "default": "Potentially fine, aromatic but notably firm Campanian.",
            "julie": "",
            "sommelier": "Greco is Campania’s zesty white gem, bursting with citrus and stone fruit, underpinned by a racy acidity and a whisper of volcanic minerality—think of it as the Italian answer to a summer breeze in a glass, equally at home on a sun-drenched terrace or a fine dining table.",
        },
        "color": "white",
        "regions": ["Campania", "Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Greco Bianco",
        "synonyms": [
            "Greco Bianco di Cosenza",
            "Greco Bianco di Rogliano",
            "Pecorello Bianco",
        ],
        "description": {
            "default": "Rare Calabrian used to make dessert wines.",
            "julie": "",
            "sommelier": "Greco Bianco is Calabria’s golden secret, weaving together honeyed stone fruit and floral aromas into a full-bodied, high-octane dessert wine that lingers luxuriously on the palate. This rare varietal is a masterclass in Italian indulgence, perfect for those who savor the sweet side of life.",
        },
        "color": "white",
        "regions": ["Calabria", "Italy"],
        "flavor_profile": ["dried_fruit", "honey", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Greco Nero",
        "synonyms": [],
        "description": {
            "default": "A group of different Calabrians confusingly sharing one name.",
            "julie": "",
            "sommelier": "Greco Nero is Calabria’s enigmatic chameleon, offering a harmonious blend of red and black fruits, spice, and earthy notes in a medium-bodied, approachable style. Perfect for those who love a little mystery in their glass, this grape brings the sun-drenched hills of southern Italy straight to your table.",
        },
        "color": "black",
        "regions": ["Calabria"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "traditional",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Grignolino",
        "synonyms": ["Barbesino", "Barbisino", "Berbesino"],
        "description": {
            "default": "Waning, distinctively pale, light, local (ancient) Monferrato speciality.",
            "julie": "",
            "sommelier": "Grignolino is Piedmont’s quirky charmer—a pale, light-bodied red bursting with tart cherry, raspberry, and a whisper of spice, all wrapped in lively acidity and gentle tannins. This ancient Monferrato specialty is the perfect companion for those who crave a refreshing, unoaked red with a touch of Italian eccentricity.",
        },
        "color": "black",
        "regions": ["Piedmont", "Monferrato", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Grillo",
        "synonyms": ["Ariddu", "Riddu", "Rossese Bianco"],
        "description": {
            "default": "Increasingly popular high-quality, full-bodied western Sicilian white.",
            "julie": "",
            "sommelier": "Grillo is Sicily’s sun-drenched answer to vibrant white wine, bursting with zesty citrus, juicy peach, and a whisper of Mediterranean herbs. With its lively acidity and full body, this grape delivers a refreshing yet substantial sip that captures the spirit of the island in every glass.",
        },
        "color": "white",
        "regions": ["Sicily", "Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "herbal",
            "mineral",
            "lemon",
            "peach",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Gringet",
        "synonyms": ["Gringet Gras", "Gros Gringet", "Petit Gringet"],
        "description": {
            "default": "Rare, lightly floral and high-quality variety exclusive to Savoie.",
            "julie": "",
            "sommelier": "Gringet is Savoie’s secret treasure—a rare white grape that dazzles with floral, citrus, and mineral notes, high acidity, and a feather-light body. Perfect for sparkling or still wines, it’s a crisp alpine breeze in a glass, best enjoyed young and fresh.",
        },
        "color": "white",
        "regions": ["Savoie", "Ayze"],
        "flavor_profile": ["floral", "citrus", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Grisa Nera",
        "synonyms": ["Grisa", "Grisa di Cumiana"],
        "description": {
            "default": "Old and rare Piemontese.",
            "julie": "",
            "sommelier": "Grisa Nera is Piedmont’s hidden gem, weaving together red and black fruits, earthy undertones, and a whisper of spice in a medium-bodied frame. This rare grape delivers a charmingly rustic yet elegant sip, perfect for those seeking a taste of Italy’s vinous heritage.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Grk",
        "synonyms": [
            "Gark",
            "Grk Bijeli",
            "Grk Korčulanski",
            "Grk Mali",
            "Grk Veli",
            "Lumbarajski Grk",
        ],
        "description": {
            "default": "Rare, high-quality and highly localized island white from Croatia.",
            "julie": "",
            "sommelier": "Grk is Croatia’s island treasure—a zesty, mineral-driven white that dazzles with citrus and stone fruit, all wrapped in a sea-breeze freshness. Rare and captivating, it’s the Mediterranean in a glass, perfect for adventurous palates seeking something truly unique.",
        },
        "color": "white",
        "regions": ["Korčula", "Lumbarda", "Dalmatian Coast", "Croatia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
            "table_wine",
            "unoaked",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Grolleau Noir",
        "synonyms": [
            "Bourdalès",
            "Gamay de Châtillon",
            "Gamay Groslot",
            "Grolleau de Cinq-Mars",
            "Grolleau de Tourraine",
            "Grolleau des Mahé",
            "Grolleau de Tours",
            "Groslot",
            "Gros-Lot",
            "Groslot de Vallères",
            "Groslot Noir",
            "Moinard",
            "Pineau de Saumur",
        ],
        "description": {
            "default": "Widely planted though little recognized dark-skinned Loire variety that makes a lot of rosé and some supple reds.",
            "julie": "",
            "sommelier": "Grolleau Noir is the Loire Valley’s vivacious secret, delivering zippy, floral rosés and featherweight reds bursting with raspberry and cherry charm. With its high acidity and low tannin, this grape is the life of the picnic—fresh, fun, and always ready to please.",
        },
        "color": "black",
        "regions": ["Loire Valley"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "raspberry", "cherry"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "rosé",
            "red",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Groppello Di Mocasina",
        "synonyms": ["Groppello di San Stefano", "Groppello Moliner"],
        "description": {
            "default": "Minor northern Italian whose wine is generally blended.",
            "julie": "",
            "sommelier": "Groppello Di Mocasina is the unsung hero of Lake Garda, offering a delightful medley of cherry, raspberry, and herbal spice in a medium-bodied, easy-drinking red—perfect for those who appreciate Italian tradition in every sip.",
        },
        "color": "black",
        "regions": ["Lombardy", "Lake Garda", "Northern Italy"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Groppello Di Revò",
        "synonyms": ["Gropel", "Gropel Nones", "Groppello Anaune"],
        "description": {
            "default": "Very minor northern Italian that was far more popular in the eighteenth and nineteenth centuries.",
            "julie": "",
            "sommelier": "Groppello Di Revò is a charming relic from northern Italy, delivering a lively medley of cherry, raspberry, and earthy herbs in a light-bodied, easy-drinking style. Once a local favorite centuries ago, this grape is a delightful find for those seeking a taste of Italian wine history in every glass.",
        },
        "color": "black",
        "regions": ["Trentino-Alto Adige", "Val di Non", "Northern Italy"],
        "flavor_profile": ["red_fruit", "herbal", "earth", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Groppello Gentile",
        "synonyms": ["Groppella", "Groppello Comune", "Groppellone"],
        "description": {
            "default": "Ancient, usually blended, northern Italian red.",
            "julie": "",
            "sommelier": "Groppello Gentile is the lively soul of northern Italy, offering a delicate dance of cherry, raspberry, and subtle spice in a light-bodied, easy-drinking red. Perfect for lakeside picnics or rustic tables, this ancient grape brings a whisper of floral and herbal intrigue to every glass.",
        },
        "color": "black",
        "regions": ["Lombardy", "Lake Garda", "Valtenesi", "Northern Italy"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gros Manseng",
        "synonyms": [
            "Gros Mansenc",
            "Izkiriot Haundi",
            "Iskiriota Zuri Handia",
            "Manseng Gros Blanc",
        ],
        "description": {
            "default": "Full-flavoured, thick-skinned white speciality of the far south west of France.",
            "julie": "",
            "sommelier": "Gros Manseng is the vivacious white grape of Southwest France, bursting with citrus, stone fruit, and honeyed tropical flavors, all wrapped in a zippy, high-acid package. Whether enjoyed young or with a touch of age, it dazzles in both crisp whites and decadent dessert wines, making every sip a lively adventure.",
        },
        "color": "white",
        "regions": ["Southwest France", "Jurançon", "Pacherenc du Vic-Bilh", "Gascony"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "honey",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "age_worthy",
            "early_drinking",
            "premium",
            "table_wine",
        ],
    },
    {
        "name": "Gros Verdot",
        "synonyms": ["Hère", "Plant des Palus", "Verdot Colon"],
        "description": {
            "default": "Very minor dark-skinned variety inferior to Petit Verdot.",
            "julie": "",
            "sommelier": "Gros Verdot is the unsung hero of Bordeaux blends, offering a rustic medley of plum, blackberry, and earthy spice—think of it as the reliable supporting actor who adds depth and intrigue to the ensemble cast of traditional French reds.",
        },
        "color": "black",
        "regions": ["Bordeaux", "Southwest France"],
        "flavor_profile": ["black_fruit", "spice", "earth", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "medium_bodied", "table_wine", "traditional"],
    },
    {
        "name": "Grossa",
        "synonyms": ["Tinta Grossa"],
        "description": {
            "default": "Alentejo variety used to improve red blends.",
            "julie": "",
            "sommelier": "Grossa is the unsung hero of Alentejo blends, lending a bold medley of red and black fruits, earthy spice, and a hearty full body—think of it as the grape that gives Portuguese reds their swagger and soul.",
        },
        "color": "black",
        "regions": ["Alentejo", "Portugal"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["red", "blend", "full_bodied", "table_wine", "traditional"],
    },
    {
        "name": "Gruaja",
        "synonyms": [
            "Crovaja",
            "Cruaia",
            "Cruara",
            "Cruvaio",
            "Gruaia",
            "Gruaio",
            "Gruajo",
        ],
        "description": {
            "default": "Rescued from extinction in northern Italy in the early 1990s but still very rare.",
            "julie": "",
            "sommelier": "Gruaja is a black grape gem from northern Italy, rescued from obscurity and now dazzling with lively cherry and plum notes, earthy minerality, and a zesty backbone. This medium-bodied rarity is a sommelier’s secret handshake—complex, refreshing, and steeped in tradition.",
        },
        "color": "black",
        "regions": ["Northern Italy", "Friuli-Venezia Giulia", "Veneto"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Grüner Veltliner",
        "synonyms": [
            "Grauer Veltliner",
            "Grün Muskateller",
            "Veltliner",
            "Veltliner Grau",
            "Veltliner Grün",
            "Veltlinske Zelené",
            "Veltlinské Zelené",
            "Weissgipfler",
            "Zeleni Veltinec",
            "Zöld Veltlini",
        ],
        "description": {
            "default": "Fashionable, versatile, top-quality Austrian white wine variety.",
            "julie": "Grüner Veltliner is the most planted grape variety of Austria. The variety can produce wines that range from light, crisp and fruity to full-bodied, complex, mineral and textural with a fabulous ageing potential. ",
            "sommelier": "Grüner Veltliner is Austria’s white wine superstar, dazzling with zippy acidity, a peppery kick, and flavors of stone fruit and citrus—think of it as the sommelier’s secret weapon for everything from schnitzel to sushi. Whether light and refreshing or rich and textured, this grape always brings a touch of Alpine elegance to the glass.",
        },
        "color": "white",
        "regions": ["Austria", "Czech Republic", "Slovakia", "Hungary"],
        "flavor_profile": [
            "stone_fruit",
            "spice",
            "pepper",
            "mineral",
            "citrus",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Guardavalle",
        "synonyms": [
            "Greco Bianco di Cirò",
            "Greco del Cirotano",
            "Montonico di Rogliano",
            "Uva da Passito",
            "Uva Greca",
            "Vardavalli",
        ],
        "description": {
            "default": "Makes a minor, nutty white in Italy’s deep south.",
            "julie": "",
            "sommelier": "Guardavalle is Calabria’s hidden white gem, offering a charming medley of toasted nuts, sun-warmed stones, and ripe orchard fruit in every glass. With its easygoing character and subtle complexity, it’s the perfect companion for a sun-drenched afternoon or a lively Italian table.",
        },
        "color": "white",
        "regions": ["Calabria", "Southern Italy"],
        "flavor_profile": ["nuts", "mineral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gueuche Noir",
        "synonyms": ["Foirard", "Foirard Noir", "Plant d’Arlay", "Plant de Treffort"],
        "description": {
            "default": "Virtually extinct, late-ripening variety from eastern France, related to Gouais Blanc.",
            "julie": "",
            "sommelier": "Gueuche Noir is a nearly forgotten gem from France’s Jura, offering a vibrant medley of cherry, plum, and raspberry with earthy, mineral undertones—think of it as a spirited echo from the vineyards of yesteryear, perfect for those who crave history in their glass.",
        },
        "color": "black",
        "regions": ["Jura", "Franche-Comté", "Eastern France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Gutenborner",
        "synonyms": ["Geisenheim 17-52"],
        "description": {
            "default": "Minor German cross with very limited plantings in the UK.",
            "julie": "",
            "sommelier": "Gutenborner is a zesty, little-known German white grape that dazzles with crisp apple and pear flavors, a floral lift, and a citrusy snap—think of it as a refreshing spring breeze in a glass, perfect for early sipping and light-hearted occasions.",
        },
        "color": "white",
        "regions": ["Germany", "United Kingdom"],
        "flavor_profile": ["apple", "pear", "floral", "citrus"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Hamashara",
        "synonyms": ["Aronova Boroda", "Gamashara"],
        "description": {
            "default": "Early-ripening Azeri red wine grape.",
            "julie": "",
            "sommelier": "Hamashara, a rare gem from the Caucasus, charms with a tapestry of red and black fruits, earthy spice, and a juicy cherry-plum finish—think of it as Azerbaijan’s answer to a lively, early-drinking red that dances gracefully between tradition and vibrancy.",
        },
        "color": "black",
        "regions": ["Azerbaijan", "Caucasus"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Hárslevelű",
        "synonyms": [
            "Budai Féher",
            "Feuille de Tilleul",
            "Harslevleue",
            "Harzevelu",
            "Lindenblättrige",
            "Lipolist",
            "Lipovina",
        ],
        "description": {
            "default": "Aromatic, descriptively named Hungarian variety used for both sweet and dry whites.",
            "julie": "",
            "sommelier": "Hárslevelű is Hungary’s aromatic gem, weaving together linden blossom, honey, and juicy stone fruits in a glass that’s as lively as a summer breeze in Tokaj. With its high acidity and mineral backbone, this grape crafts both vibrant dry whites and luscious dessert wines that age gracefully and charm effortlessly.",
        },
        "color": "white",
        "regions": ["Hungary", "Tokaj", "Slovakia"],
        "flavor_profile": [
            "floral",
            "honey",
            "stone_fruit",
            "citrus",
            "mineral",
            "pear",
            "peach",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "blend",
            "unoaked",
            "oaked",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Hasandede",
        "synonyms": ["Ahmet Bey", "Aşeri", "Hasan Dede", "Hasandede Beyazi"],
        "description": {
            "default": "Humdrum Turkish variety found east of the capital, Ankara.",
            "julie": "",
            "sommelier": "Hasandede is Central Anatolia’s charming white grape, offering a crisp medley of orchard fruits and delicate florals, perfect for those seeking a refreshing, unoaked Turkish original. Light-bodied and lively, it’s a delightful companion for early sipping and local fare.",
        },
        "color": "white",
        "regions": ["Turkey", "Central Anatolia", "Ankara"],
        "flavor_profile": ["apple", "pear", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Helfensteiner",
        "synonyms": ["Blauer Weinsberger", "Weinsberg S 5332"],
        "description": {
            "default": "German cross eclipsed by its offspring Dornfelder.",
            "julie": "",
            "sommelier": "Helfensteiner is the unsung hero of German reds, delivering a lively medley of cherry and raspberry with a whisper of florals and herbs—think of it as Dornfelder’s delicate, easygoing parent, perfect for a light-hearted evening. This light-bodied charmer is a delightful companion for those who appreciate freshness and finesse in their glass.",
        },
        "color": "red",
        "regions": ["Germany", "Württemberg", "Rheinhessen"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Helios",
        "synonyms": [],
        "description": {
            "default": "Little-known, very complex, disease-resistant German hybrid.",
            "julie": "",
            "sommelier": "Helios is a zesty German white that dazzles with citrus, apple, and pear, all wrapped in a floral-mineral embrace—think of it as a sunbeam in a glass, perfect for those who crave crisp, lively refreshment.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Herbemont",
        "synonyms": [
            "Black Herbemont",
            "Bottsi",
            "Brown French",
            "Dunn",
            "Herbemon",
            "Herbemont’s Madeira",
            "Hunt",
            "Kay’s Seedling",
            "Mcknee",
            "Neal Grape",
            "Neil Grape",
            "Warren",
            "Warrenton",
            "White Herbemont",
        ],
        "description": {
            "default": "Almost extinct American hybrid with a complex and disputed parentage.",
            "julie": "",
            "sommelier": "Herbemont is the Southern belle of American grapes—light-bodied, high-acid, and bursting with red and black fruit, floral, and herbal notes, it’s a rare treat that dances gracefully across the palate. Nearly extinct but unforgettable, Herbemont’s wines are a charming nod to the South’s winemaking heritage, perfect for those who crave something both refreshing and storied.",
        },
        "color": "black",
        "regions": [
            "Texas",
            "Southeastern United States",
            "Louisiana",
            "Georgia",
            "Mississippi",
        ],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "herbal"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "rosé",
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Heroldrebe",
        "synonyms": ["Weinsberg S 130"],
        "description": {
            "default": "Unexceptional, productive but inconveniently late-ripening German cross.",
            "julie": "",
            "sommelier": "Heroldrebe is the unsung workhorse of German vineyards, delivering earthy, fruit-driven reds with a rustic charm—perfect for those who appreciate a no-nonsense, early-drinking table wine with a touch of Württemberg soul.",
        },
        "color": "black",
        "regions": ["Germany", "Württemberg", "Rheinhessen"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "vegetal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "table_wine", "blend", "early_drinking"],
    },
    {
        "name": "Hetera",
        "synonyms": ["HTCVCB 4/13"],
        "description": {
            "default": "Recently authorized Slovakian cross making promising sweet wines.",
            "julie": "",
            "sommelier": "Hetera is Slovakia’s sweet secret, delivering a full-bodied embrace of red and dried fruits, floral perfume, and a honeyed finish—think of it as dessert in a glass, perfect for those who crave modern indulgence with a gentle touch.",
        },
        "color": "red",
        "regions": ["Slovakia"],
        "flavor_profile": ["red_fruit", "dried_fruit", "floral", "honey"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "full_bodied",
            "varietal",
            "modern",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Hibernal",
        "synonyms": ["Geisenheim 322-58"],
        "description": {
            "default": "German hybrid planted more widely in the Czech Republic than at home.",
            "julie": "",
            "sommelier": "Hibernal is a zesty white grape that dazzles with lively citrus, apple, and pear notes, underscored by a floral and mineral edge—think of it as the Czech Republic’s answer to a brisk spring morning in a glass. With its high acidity and light body, this unoaked charmer is perfect for those who crave refreshment and vibrancy in their everyday sips.",
        },
        "color": "white",
        "regions": ["Czech Republic", "Germany", "Slovakia"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Hitzkircher",
        "synonyms": ["Grosse Blaue Mörsch", "Hitzkirchener", "Hitzkirchler"],
        "description": {
            "default": "Swiss rarity found only in the village after which it was named.",
            "julie": "",
            "sommelier": "Hitzkircher is a true Swiss gem—light-bodied yet brimming with red and black fruit, earthy minerals, and a whisper of cherry and plum, this rare grape from Hitzkirch offers a taste of Alpine tradition in every glass. A must-try for adventurous palates seeking a sip of Swiss heritage!",
        },
        "color": "black",
        "regions": ["Switzerland", "Hitzkirch"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Hölder",
        "synonyms": ["Hoelder", "Weinsberg S 397"],
        "description": {
            "default": "Very minor, distinctly ordinary German cross.",
            "julie": "",
            "sommelier": "Hölder is the wallflower of German whites—delicate, light-bodied, and refreshingly crisp, with gentle notes of apple, pear, and a whisper of spring flowers. Perfect for early sipping, it’s a charming companion for those who appreciate subtlety over showiness.",
        },
        "color": "white",
        "regions": ["Germany"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Hondarribi Beltza",
        "synonyms": [
            "Chacolí",
            "Cruchen Nègre",
            "Hondarrabi Beltza",
            "Kurixketu Beltza",
            "Ondarrabi Beltza",
            "Txakoli",
            "Verde Matza",
            "Xerratu Beltza",
        ],
        "description": {
            "default": "Rare speciality of northern Spain’s Basque Country related to, and sometimes reminiscent of, Cabernet Franc.",
            "julie": "",
            "sommelier": "Hondarribi Beltza is the Basque Country’s secret handshake—a light-bodied, high-acid red bursting with raspberry, herbs, and a whisper of earth, like Cabernet Franc’s wilder cousin. Sip it young and unoaked for a zesty, peppery taste of Atlantic Spain’s windswept vineyards.",
        },
        "color": "black",
        "regions": [
            "Basque Country",
            "Getariako Txakolina",
            "Bizkaiko Txakolina",
            "Arabako Txakolina",
        ],
        "flavor_profile": [
            "red_fruit",
            "herbal",
            "mineral",
            "earth",
            "raspberry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Horozkarasi",
        "synonyms": ["Horoz Karası"],
        "description": {
            "default": "A stay-at-home variety used more for the table than for wine.",
            "julie": "",
            "sommelier": "Horozkarasi is Turkey’s charming homebody grape, offering a basket of red and black fruit flavors in a light, easy-drinking style. With gentle acidity and a soft touch, it’s perfect for those who prefer their reds playful and unpretentious.",
        },
        "color": "black",
        "regions": ["Turkey"],
        "flavor_profile": ["red_fruit", "black_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Hron",
        "synonyms": ["CAAB 3/22"],
        "description": {
            "default": "Recent but promising Slovakian cross producing full-bodied, ageworthy reds.",
            "julie": "",
            "sommelier": "Hron is Slovakia’s bold new contender, delivering a muscular, full-bodied red brimming with black fruit, plum, and spicy earth, all wrapped in a cloak of oak. With high tannins and serious aging potential, this grape is a must-try for fans of powerful, cellar-worthy wines.",
        },
        "color": "black",
        "regions": ["Slovakia"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "oak",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "age_worthy",
            "premium",
            "reserve",
            "varietal",
        ],
    },
    {
        "name": "Hrvatica",
        "synonyms": [
            "Hrvatica Crna",
            "Jarbola",
            "Karbonera",
            "Markolina",
            "Negrara",
            "Negrona",
        ],
        "description": {
            "default": "Recently rescued Croatian variety making pale reds.",
            "julie": "",
            "sommelier": "Hrvatica is a charming Croatian rarity, delivering a lively, pale red wine bursting with cherry and raspberry brightness, accented by floral and herbal whispers. With its zippy acidity and feather-light body, it's the perfect companion for a sun-drenched seaside lunch.",
        },
        "color": "black",
        "regions": ["Croatia", "Istria", "Dalmatia"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Humagne",
        "synonyms": [
            "Humagne Blanc",
            "Humagne Blanche",
            "Miousat",
            "Miousap",
            "Mioussat",
        ],
        "description": {
            "default": "Ancient, tangy Swiss variety recently revived in the Valais.",
            "julie": "",
            "sommelier": "Humagne is a zesty Swiss treasure, bursting with citrus and stone fruit, laced with alpine minerality and delicate florals—think of it as a mountain breeze in a glass, perfect for those who crave crisp, lively whites with a story to tell.",
        },
        "color": "white",
        "regions": ["Switzerland", "Valais"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Huxelrebe",
        "synonyms": ["Alzey S. 3962"],
        "description": {
            "default": "German cross scores highly for yields, ripeness, aroma and acidity but not for subtlety.",
            "julie": "",
            "sommelier": "Huxelrebe is Germany’s exuberant white grape, bursting with zesty citrus, lush stone fruit, and a honeyed floral lift, all wrapped in a lively, high-acid package. Think of it as the life of the party—bold, aromatic, and always ready to charm, whether in a crisp table wine or a decadent dessert pour.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "floral",
            "honey",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Incrocio Bianco Fedit 51",
        "synonyms": ["Fedit 51"],
        "description": {
            "default": "Rare Veneto 1950s white cross good for passito wines.",
            "julie": "",
            "sommelier": "Incrocio Bianco Fedit 51 is a rare Venetian gem, weaving together honeyed dried fruit and floral notes in a voluptuous, full-bodied embrace—perfect for luscious, age-worthy passito wines that linger long after the last sip.",
        },
        "color": "white",
        "regions": ["Veneto"],
        "flavor_profile": ["dried_fruit", "honey", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["white", "dessert", "full_bodied", "age_worthy", "varietal"],
    },
    {
        "name": "Incrocio Bruni 54",
        "synonyms": ["Dorico", "Sauvignon × Verdicchio"],
        "description": {
            "default": "Minor but high-yielding central Italian white cross that generally disappears into blends.",
            "julie": "",
            "sommelier": "Incrocio Bruni 54 is Italy’s secret blending ace, delivering a vivacious medley of citrus, apple, and pear with a breezy herbal twist—think of it as the zesty supporting actor that keeps your table wine fresh, lively, and always ready for a good time.",
        },
        "color": "white",
        "regions": ["Marche", "Umbria", "Abruzzo"],
        "flavor_profile": ["citrus", "apple", "pear", "herbal", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "unoaked",
        ],
    },
    {
        "name": "Incrocio Manzoni 2.15",
        "synonyms": ["Manzoni Nero", "Prosecco × Cabernet Sauvignon 2-15"],
        "description": {
            "default": "Very minor black-skinned cross confined to the Veneto in northern Italy.",
            "julie": "",
            "sommelier": "Incrocio Manzoni 2.15 is a Veneto-born rarity, blending the elegance of Prosecco with the depth of Cabernet Sauvignon to deliver a juicy medley of red and black fruits, herbs, and spice—perfect for those seeking a fresh, medium-bodied red with a story to tell.",
        },
        "color": "black",
        "regions": ["Veneto", "Northern Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "table_wine", "early_drinking"],
    },
    {
        "name": "Incrocio Terzi 1",
        "synonyms": ["Barbera × Cabernet Franc 1"],
        "description": {
            "default": "Minor Lombardia crossing that disappears into blends.",
            "julie": "",
            "sommelier": "Incrocio Terzi 1 is Lombardia’s secret handshake—a rare crossing of Barbera and Cabernet Franc that whispers cherry, plum, and blackberry with a touch of earth and herbs, perfect for those who love their reds lively, approachable, and just a bit mysterious.",
        },
        "color": "black",
        "regions": ["Lombardia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "light_bodied",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Invernenga",
        "synonyms": ["Invernesca", "Ua’mbrunesca"],
        "description": {
            "default": "Old and rare Brescia white, ideal for drying off the vine.",
            "julie": "",
            "sommelier": "Invernenga is Brescia’s hidden white gem, offering a luscious medley of dried fruit, honey, and stone fruit flavors, all lifted by zesty acidity. Perfect for both vibrant whites and decadent dessert wines, this rare grape is a true Italian treasure waiting to be rediscovered.",
        },
        "color": "white",
        "regions": ["Brescia", "Lombardy", "Italy"],
        "flavor_profile": [
            "dried_fruit",
            "honey",
            "stone_fruit",
            "floral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Inzolia",
        "synonyms": [
            "Ansolica",
            "Ansonica",
            "Ansora",
            "Anzonica",
            "Insolia",
            "Insolia di Palermo",
            "Insora",
            "’Nzolia",
            "Zolia Bianca",
        ],
        "description": {
            "default": "Nutty Sicilian white.",
            "julie": "",
            "sommelier": "Inzolia is Sicily’s sun-kissed white, charming with a nutty bouquet, zesty citrus, and a whisper of stone fruit, all wrapped in a mineral embrace. Medium-bodied and effortlessly drinkable, it’s the Mediterranean in a glass—perfect for seaside sipping or a lively table.",
        },
        "color": "white",
        "regions": ["Sicily", "Tuscany", "Elba"],
        "flavor_profile": ["nuts", "citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Iri Kara",
        "synonyms": ["Arikaras", "Focea", "Fodja"],
        "description": {
            "default": "Very minor, mediocre, pink-skinned Turkish variety.",
            "julie": "",
            "sommelier": "Iri Kara is a charmingly obscure Turkish pink grape, offering a bouquet of red fruit and floral notes in a feather-light, low-alcohol package—perfect for a breezy afternoon rosé or a convivial table wine. While it may not steal the spotlight, its gentle character and easy-drinking style make it a delightful discovery for the adventurous palate.",
        },
        "color": "pink",
        "regions": ["Turkey"],
        "flavor_profile": ["red_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Irsai Olivér",
        "synonyms": [
            "Irsay Oliver",
            "Irsay Oliver Muskotaly",
            "Muscat Oliver",
            "Oliver Irsay",
        ],
        "description": {
            "default": "Hungarian table grape promoted to making soft, aromatic white wines.",
            "julie": "",
            "sommelier": "Irsai Olivér is Hungary’s aromatic charmer, bursting with floral perfume and juicy stone fruit, perfect for those who crave a breezy, light-bodied white that’s as easygoing as a summer afternoon. Sip it young and unoaked for a taste of Central European sunshine in every glass.",
        },
        "color": "white",
        "regions": ["Hungary", "Slovakia", "Czech Republic"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Isabella",
        "synonyms": [
            "Americano",
            "Ananas",
            "Bangalore Blue",
            "Bellina",
            "Black Cape",
            "Bromostaphylo",
            "Captraube",
            "Dorchester",
            "Fragola",
            "Framboisier",
            "Fraula",
            "Fraulaghju",
            "Frutilla",
            "Gibb’s Grape",
            "Gros Framboisé",
            "Isabel",
            "Isabella Nera",
            "Isabelle",
            "Isabellinha",
            "Izabella",
            "Kepshuna",
            "Kerkyraios",
            "Kokulu Uezuem",
            "Koreos",
            "Lidia",
            "Loipe Makedonia",
            "Moschostaphylo",
            "New Hanover",
            "Nostrano",
            "Odessa",
            "Paign’s Isabella",
            "Raisin du Cap",
            "Raisin Fraise",
            "Raisin Framboise",
            "Sainte Helene",
            "Saluda",
            "Schuykill",
            "Strawberry Grape",
            "Tjortjidica",
            "Tzampela",
            "Tzortzidika Chakidike",
            "Tzortzines",
            "Utkopro",
            "Uva Cimice",
            "Uva Fragola",
            "Vernet",
            "Woodward",
            "Zampela",
        ],
        "description": {
            "default": "Once widely planted, old American variety now found mostly in Brazil and India.",
            "julie": "",
            "sommelier": "Isabella is the globe-trotting black grape that charms with raspberry and wild strawberry notes, a floral lift, and a rustic, earthy edge—think of it as the adventurous cousin at the family reunion. Light-bodied and low in alcohol, it’s the perfect companion for a sunny afternoon, best enjoyed young and with good company.",
        },
        "color": "black",
        "regions": [
            "Brazil",
            "India",
            "United States (historically)",
            "Georgia",
            "Ukraine",
        ],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "herbal",
            "vegetal",
            "earth",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Italia",
        "synonyms": ["Moscatel Italia", "Moscatel Italiano", "Muscat d’Italie"],
        "description": {
            "default": "Important, extremely large-berried table grape only very rarely used to make wine.",
            "julie": "",
            "sommelier": "Italia is the showstopper of the fruit bowl—an exuberant, globe-trotting white grape bursting with floral perfume, juicy stone fruit, and a tropical honeyed kiss. While it rarely graces a wine bottle, its luscious, oversized berries are a sun-drenched treat that brings a taste of Mediterranean summer to every bite.",
        },
        "color": "white",
        "regions": ["Italy", "Brazil", "Argentina", "Peru", "Egypt"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Italica",
        "synonyms": ["103", "Incrocio Cosmo 103", "Verdiso × Riesling Italico 103"],
        "description": {
            "default": "A 1950s white Italian cross of interest only in the province of Treviso.",
            "julie": "",
            "sommelier": "Italica is Treviso’s hidden gem—a zesty, high-acid white bursting with citrus, apple, and pear, kissed by floral and mineral notes. Light on its feet and made for early enjoyment, this rare Italian cross is a refreshing ode to Veneto’s vibrant terroir.",
        },
        "color": "white",
        "regions": ["Treviso", "Veneto", "Italy"],
        "flavor_profile": ["citrus", "apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ives",
        "synonyms": [
            "Black Ives",
            "Bôrdo",
            "Ives Madeira",
            "Ives’ Madeira Seedling",
            "Ives Seedling",
            "Kittredge",
        ],
        "description": {
            "default": "American hybrid that needs fresh air.",
            "julie": "",
            "sommelier": "Ives is the life of the party among American hybrids, bursting with cherry and raspberry flavors, a whisper of wildflowers, and a breezy herbal lift—perfect for those seeking a light, lively red that’s as easygoing as a summer picnic in Ohio.",
        },
        "color": "black",
        "regions": ["United States", "Ohio", "New York", "Pennsylvania", "Missouri"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "blend",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Jacquère",
        "synonyms": [
            "Cugnette",
            "Jacquerre",
            "Jaquère",
            "Martin-Cot",
            "Molette de Montmélian",
            "Plant des Abîmes",
            "Plant des Abymes de Myans",
            "Raisin des Abîmes",
            "Redin",
            "Robinet",
            "Roussette",
        ],
        "description": {
            "default": "Savoie speciality producing fresh, light, mountain whites.",
            "julie": "",
            "sommelier": "Jacquère is the alpine sprite of Savoie, delivering a zesty, mineral-driven white wine that dances with citrus, apple, and pear—perfect for après-ski or a sunlit terrace. Its brisk acidity and feather-light body make it as invigorating as a mountain breeze.",
        },
        "color": "white",
        "regions": ["Savoie", "France"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Jacquez",
        "synonyms": [
            "Black Spanish",
            "Cigar Box",
            "French Grape",
            "Jacquet",
            "Lenoir",
            "Longworth’s Ohio",
            "Troya",
        ],
        "description": {
            "default": "Once-popular American hybrid with good resistance to Pierce’s disease and now surviving mainly in Brazil and Texas.",
            "julie": "",
            "sommelier": "Jacquez, also known as Black Spanish, is a tenacious American hybrid thriving in Texas and Brazil, offering a lively medley of blackberry, plum, and earthy herbs. With its high acidity and medium body, this grape crafts vibrant, early-drinking reds that are as bold and resilient as their storied past.",
        },
        "color": "black",
        "regions": ["Texas", "Brazil", "Southern United States", "Mexico"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "earth", "herbal"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "table_wine",
            "blend",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Jampal",
        "synonyms": ["Cercial", "Jampaulo", "João Paolo", "Pinheira Branca"],
        "description": {
            "default": "Minor Portuguese vine recognized for its quality but not widely planted.",
            "julie": "",
            "sommelier": "Jampal is Portugal’s secret white treasure, bursting with zesty citrus, juicy stone fruit, and a whisper of florals, all wrapped in a crisp, mineral embrace. With its lively acidity and rare status, this grape delivers a refreshing, modern white wine that’s as intriguing as it is delicious.",
        },
        "color": "white",
        "regions": ["Portugal", "Lisboa"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "modern",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Johanniter",
        "synonyms": [],
        "description": {
            "default": "Recent German hybrid with very good disease resistance.",
            "julie": "",
            "sommelier": "Johanniter is the zesty wunderkind of German vineyards, delivering a crisp medley of orchard fruits and citrus with a floral lift and mineral snap—think of it as Riesling’s easygoing, disease-resistant cousin, perfect for picnics and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Germany", "Switzerland", "Austria"],
        "flavor_profile": ["apple", "pear", "citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "modern",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Juan García",
        "synonyms": [
            "Gorda",
            "Malvasía  Negra",
            "Mouratón",
            "Negrera",
            "Negrón de Aldán",
            "Nepada",
            "Tinta Gorda",
            "Villarino",
        ],
        "description": {
            "default": "Intriguing, perfumed speciality of north-western Spain.",
            "julie": "",
            "sommelier": "Juan García is the enigmatic jewel of north-western Spain, offering a beguiling bouquet of cherry, raspberry, and wildflowers, all grounded by a subtle earthiness. Medium-bodied and effortlessly drinkable, this grape is a delightful companion for those seeking a taste of Spanish tradition with a perfumed twist.",
        },
        "color": "black",
        "regions": ["Castilla y León", "Arribes", "Zamora", "Salamanca"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "earth",
            "mineral",
            "cherry",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Juhfark",
        "synonyms": ["Lämmerschwanz"],
        "description": {
            "default": "Minor Hungarian variety that needs ageing and aeration to swap asperity for elegance.",
            "julie": "",
            "sommelier": "Juhfark, Hungary’s enigmatic white grape, dazzles with zesty citrus, stone fruit, and a flinty minerality, evolving from sharp youth to graceful elegance with age and a swirl of the glass. This Somló specialty is a must-try for adventurous palates craving a taste of volcanic terroir and tradition.",
        },
        "color": "white",
        "regions": ["Hungary", "Somló"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "age_worthy",
            "medium_bodied",
            "table_wine",
        ],
    },
    {
        "name": "Jurançon Blanc",
        "synonyms": [
            "Braquet",
            "Dame Blanc",
            "Plant de Dame",
            "Plant Debout",
            "Quillat",
            "Quillard",
            "Secal",
        ],
        "description": {
            "default": "Inferior and increasingly neglected variety traditionally used as a base for spirits.",
            "julie": "",
            "sommelier": "Once the unsung hero of Southwest France’s vineyards, Jurançon Blanc delivers a crisp medley of apple and pear with a whisper of minerality—perfect for those who appreciate a light, easygoing white with a story to tell, even if it’s usually told in a blend.",
        },
        "color": "white",
        "regions": ["Southwest France", "Jurançon"],
        "flavor_profile": ["apple", "pear", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Jurançon Noir",
        "synonyms": [
            "Chalosse Noire",
            "Dame Noire",
            "Plant de Dame",
            "Enrageat Noir",
            "Fola Belcha",
            "Folle Noire",
            "Folle Rouge",
            "Gouni",
            "Jurançon Rouge",
            "Luxuriant",
            "Piquepout Rouge",
            "Quillat",
            "Quillard",
            "Vidiella",
        ],
        "description": {
            "default": "South-west French variety producing light wines but rapidly losing ground.",
            "julie": "",
            "sommelier": "Jurançon Noir is the charming underdog of Southwest France, offering a breezy, light-bodied red brimming with cherry and raspberry, accented by earthy and herbal notes. Perfect for a casual table, this grape is a delightful throwback to rustic French tradition—catch it before it disappears!",
        },
        "color": "black",
        "regions": ["Southwest France", "Jurançon", "Gascony"],
        "flavor_profile": ["red_fruit", "herbal", "earth", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "traditional",
            "early_drinking",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Juwel",
        "synonyms": ["Jewel", "Weinsberg S 378"],
        "description": {
            "default": "Modern German cross with patchy disease resistance.",
            "julie": "",
            "sommelier": "Juwel is Germany’s sparkling little secret, delivering a zesty medley of citrus and apple with a floral lift and a mineral backbone. With its high acidity and easy-drinking style, this modern grape is perfect for those who crave a crisp, refreshing white that shines in its youth.",
        },
        "color": "white",
        "regions": ["Germany"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kabar",
        "synonyms": ["Tarcal 10"],
        "description": {
            "default": "Recent Hungarian cross designed for Tokaj.",
            "julie": "",
            "sommelier": "Kabar is Tokaj’s contemporary white wonder, bursting with zesty citrus, juicy stone fruit, and a whisper of honeyed florals, all wrapped in a lively, mineral-driven frame. Whether as a crisp varietal or a decadent dessert wine, Kabar dazzles with its high-wire acidity and modern Hungarian flair.",
        },
        "color": "white",
        "regions": ["Hungary", "Tokaj"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "honey", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Kachichi",
        "synonyms": ["Abkhazouri", "Kagigi", "Katchitchi", "Katcitci"],
        "description": {
            "default": "Minor variety producing deep red wines in north-western Georgia.",
            "julie": "",
            "sommelier": "Kachichi is Georgia’s hidden gem, delivering a robust, full-bodied red brimming with red and black fruits, earthy spice, and a mineral backbone—perfect for adventurous palates seeking a taste of the Caucasus. This rare variety charms with its balance and depth, making every sip a journey through Georgia’s storied vineyards.",
        },
        "color": "black",
        "regions": ["Georgia", "North-western Georgia"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "table_wine",
            "full_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Kadarka",
        "synonyms": [
            "Branicevka",
            "Cadarcă",
            "Cadarcă Neagră",
            "Cadarcă de Miniş",
            "Fekete Budai",
            "Gamza",
            "Gamza de Varna",
            "Gomza",
            "Gumza",
            "Gymza",
            "Kadarka Kék",
            "Kallmet",
            "Lugojană",
            "Skadarka",
            "Törökszőlő",
            "Varnenska Gimza",
        ],
        "description": {
            "default": "Variety of uncertain origin producing gentle, fresh reds in Eastern Europe.",
            "julie": "",
            "sommelier": "Kadarka is the Eastern European charmer, delivering a lively dance of cherry and raspberry flavors with a spicy, earthy twist—think of it as a featherweight boxer: light on its feet, high in acidity, and always ready for a good time at the table.",
        },
        "color": "black",
        "regions": ["Hungary", "Romania", "Bulgaria", "Serbia"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "spice", "earth"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kakhet",
        "synonyms": ["Cakhete", "Kachet", "Kakheti"],
        "description": {
            "default": "Possibly Georgian grape best known for the sweet Kagor reds in Armenia.",
            "julie": "",
            "sommelier": "Kakhet is a sultry, full-bodied black grape that seduces the palate with waves of black fruit, dried fruit, and chocolate, all wrapped in a spicy embrace—no wonder it’s the star of Armenia’s legendary Kagor wines. With medium acidity and tannins but a high-octane finish, this grape is a decadent treat for lovers of bold, traditional reds and luscious dessert wines.",
        },
        "color": "black",
        "regions": ["Armenia", "Georgia"],
        "flavor_profile": ["black_fruit", "dried_fruit", "chocolate", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "dessert",
            "fortified",
            "full_bodied",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Kakotrygis",
        "synonyms": ["Kako Tryghi", "Kakotriguis", "Kakotriki", "Kakotryghis"],
        "description": {
            "default": "Very minor variety found on the Greek island of Kérkyra (Corfu).",
            "julie": "",
            "sommelier": "Kakotrygis is Corfu’s zesty secret: a high-acid, light-bodied white bursting with citrus, stone fruit, and a whisper of Mediterranean florals—think of it as a sunbeam in a glass, perfect for seaside sipping and Greek island daydreams.",
        },
        "color": "white",
        "regions": ["Corfu", "Ionian Islands", "Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kangun",
        "synonyms": ["2-17-22", "Cangoune", "Kangoon", "Kangoun"],
        "description": {
            "default": "Armenian complex hybrid used to produce brandy and sweet, fortified whites.",
            "julie": "",
            "sommelier": "Kangun is Armenia’s golden secret, delivering a full-bodied, high-octane white wine that dazzles with stone fruit, honey, and a whisper of dried flowers—perfect for those who crave both opulence and tradition in their glass.",
        },
        "color": "white",
        "regions": ["Armenia"],
        "flavor_profile": ["stone_fruit", "floral", "honey", "dried_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "full_bodied",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Kanzler",
        "synonyms": ["Alzey S 3983"],
        "description": {
            "default": "Low-yielding and declining German cross.",
            "julie": "",
            "sommelier": "Kanzler is a hidden gem of Germany, offering a crisp, high-acid dance of apple, pear, and floral notes with a mineral backbone—perfect for those who crave a refreshing, light-bodied white that’s as rare as it is elegant.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kapistoni Tetri",
        "synonyms": [
            "Capistoni Tetri",
            "Kabistoni Tetri",
            "Kapistona",
            "Kapistoni",
            "Zekroula Kapistoni",
        ],
        "description": {
            "default": "Ancient Georgian variety responsible for still and sparkling wines.",
            "julie": "",
            "sommelier": "Kapistoni Tetri dazzles with a lively medley of citrus, stone fruit, and delicate florals, all wrapped in a crisp, mineral-driven frame—think of it as Georgia’s sparkling answer to a summer breeze in a glass. This ancient variety is a masterclass in refreshment, perfect for those who crave a zippy, unoaked white with a story to tell.",
        },
        "color": "white",
        "regions": ["Georgia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kapitan Jani Kara",
        "synonyms": [
            "Adzhi Ibram Kara",
            "Agii Ibram",
            "Capitan Kara",
            "Chaban Khalil Kara",
            "Kapitan Yani Kara",
            "Ridzhaga",
        ],
        "description": {
            "default": "Minor Ukrainian component in sweet red blends.",
            "julie": "",
            "sommelier": "Kapitan Jani Kara is the unsung hero of Eastern European sweet blends, offering a charming medley of red, black, and dried fruit flavors with a gentle touch of acidity and low tannins. This grape brings a smooth, medium-bodied character to the glass, perfect for those who enjoy their reds with a whisper of sweetness and a nod to tradition.",
        },
        "color": "black",
        "regions": ["Ukraine", "Moldova", "Russia"],
        "flavor_profile": ["red_fruit", "black_fruit", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "dessert", "traditional"],
    },
    {
        "name": "Kapselsky",
        "synonyms": [
            "Kapsel Skii",
            "Kapselski",
            "Kapselskii",
            "Matvienkovsky",
            "SD-62",
        ],
        "description": {
            "default": "Minor Ukrainian white.",
            "julie": "",
            "sommelier": "Kapselsky is Ukraine’s zesty secret, offering a lively medley of citrus, apple, and wildflower aromas with a gentle herbal twist. Light-bodied and refreshingly crisp, it’s the perfect companion for sunlit afternoons and spontaneous toasts.",
        },
        "color": "white",
        "regions": ["Ukraine"],
        "flavor_profile": ["citrus", "apple", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Karalahna",
        "synonyms": ["Kara Lahna", "Lahna Kara"],
        "description": {
            "default": "Found mainly on the Turkish island of Bozcaada in the Aegean, makes tannic but fresh reds.",
            "julie": "",
            "sommelier": "Karalahna is Bozcaada’s bold black pearl, delivering a lively dance of red and black fruits, earthy spice, and a firm tannic grip—think of it as the Aegean’s answer to a rustic, sun-kissed red with a fresh island breeze.",
        },
        "color": "black",
        "regions": ["Bozcaada", "Aegean", "Turkey"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Karasakiz",
        "synonyms": [
            "Kara Sakız",
            "Karakız",
            "Karassakýz",
            "Kuntra",
            "Makbule",
            "Mavrupalya",
            "Sakız Kara",
        ],
        "description": {
            "default": "Turkish variety making soft, light reds and being overtaken by the likes of Cabernet and Merlot.",
            "julie": "",
            "sommelier": "Karasakiz is Turkey’s answer to a breezy summer red—light on its feet, with a bouquet of wild herbs and red berries, and a gentle floral lift. This easy-drinking varietal is a delightful alternative to the usual suspects, perfect for those who crave a taste of Anatolian tradition in their glass.",
        },
        "color": "black",
        "regions": ["Turkey"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "traditional",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Karmrahyut",
        "synonyms": ["Karmrahiut", "Karmraiute"],
        "description": {
            "default": "Dark-skinned, red-fleshed Armenian hybrid.",
            "julie": "",
            "sommelier": "Karmrahyut is Armenia’s dark-skinned gem, bursting with lively cherry, plum, and blackberry flavors, underscored by a spicy, earthy backbone. With its high acidity and medium structure, this grape crafts wines that are both energetic and age-worthy—perfect for adventurous palates seeking a taste of the Caucasus.",
        },
        "color": "black",
        "regions": ["Armenia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Karnachalades",
        "synonyms": ["Karnachalas"],
        "description": {
            "default": "Very rare variety from north-eastern Greece.",
            "julie": "",
            "sommelier": "Karnachalades is a hidden gem from Greece’s northeast, offering a vibrant medley of red and black fruits laced with earthy spice, all wrapped in a lively, medium-bodied frame. This rare variety’s high acidity and age-worthy structure make it a sommelier’s secret weapon for adventurous palates and memorable pairings.",
        },
        "color": "black",
        "regions": ["North-eastern Greece", "Macedonia (Greece)", "Thrace"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Katsakoulias",
        "synonyms": [
            "Gyftokoritho",
            "Kaltsakouli",
            "Kartsakouli",
            "Katsacoul",
            "Katsakouli",
            "Katsakoulia",
        ],
        "description": {
            "default": "Rare Greek variety almost exclusive to the island of Zákynthos.",
            "julie": "",
            "sommelier": "Katsakoulias is Zákynthos’ hidden gem—a rare black grape yielding medium-bodied reds that dance with red and black fruit, herbal whispers, and earthy charm. Sip it for a taste of Greek tradition and Ionian island mystique in every glass.",
        },
        "color": "black",
        "regions": ["Zákynthos", "Ionian Islands", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "medium_bodied",
            "table_wine",
        ],
    },
    {
        "name": "Katsano",
        "synonyms": ["Katsamon"],
        "description": {
            "default": "Rare variety just surviving on Santoríni.",
            "julie": "",
            "sommelier": "Katsano is Santorini’s hidden white gem, bursting with zesty citrus, juicy stone fruit, and a whisper of wildflowers, all wrapped in a crisp, mineral embrace. This rare grape delivers a lively, unoaked sip that captures the sun-drenched spirit and volcanic soul of Greece’s most storied island.",
        },
        "color": "white",
        "regions": ["Santorini", "Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kay Gray",
        "synonyms": ["Elmer Swenson 1-63", "ES 1-63"],
        "description": {
            "default": "Minor and not terribly successful American hybrid.",
            "julie": "",
            "sommelier": "Kay Gray is the plucky underdog of the Upper Midwest, offering a crisp medley of apple and pear with a whisper of wildflowers and earth—perfect for those seeking a refreshing, unoaked white with a story as unique as its origins.",
        },
        "color": "white",
        "regions": ["Wisconsin", "Minnesota", "Upper Midwest USA"],
        "flavor_profile": ["apple", "pear", "floral", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Kefessiya",
        "synonyms": [
            "Cefecia",
            "Cefesia",
            "Doktorsky Chernyi",
            "Kefe Izyum",
            "Kefesia",
            "Kefesiya",
            "Kethessia",
        ],
        "description": {
            "default": "Late-ripening variety from southern Ukraine that needs help to reproduce.",
            "julie": "",
            "sommelier": "Kefessiya is a mysterious black grape from southern Ukraine, weaving together flavors of plum, cherry, and earthy minerals into a medium-bodied tapestry. Rare and somewhat elusive, it’s a sommelier’s secret handshake—perfect for those seeking a taste of Eastern European tradition in their glass.",
        },
        "color": "black",
        "regions": ["Southern Ukraine", "Crimea", "Moldova", "Russia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Kéknyelű",
        "synonyms": ["Blaustängler"],
        "description": {
            "default": "Rare, potentially high-quality western Hungarian variety producing fragrant, high-acid whites.",
            "julie": "",
            "sommelier": "Kéknyelű is Hungary’s elusive white gem, dazzling with high-toned citrus, delicate florals, and a racy mineral streak that dances across the palate. This light-bodied beauty from Badacsony is a sommelier’s secret weapon—refreshing, refined, and built to age gracefully.",
        },
        "color": "white",
        "regions": ["Hungary", "Badacsony"],
        "flavor_profile": ["floral", "citrus", "stone_fruit", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Keratsuda",
        "synonyms": [
            "Breza",
            "Breznik",
            "Govedina",
            "Keratsouda",
            "Keratuda",
            "Mirizlivka",
            "Tsarevitsa",
        ],
        "description": {
            "default": "Minor Bulgarian variety making simple whites in the Struma Valley.",
            "julie": "",
            "sommelier": "Keratsuda is Bulgaria’s charming underdog, delivering crisp citrus and apple flavors with a whisper of florals in a light, refreshing package—perfect for those who love their whites bright, breezy, and uncomplicated.",
        },
        "color": "white",
        "regions": ["Bulgaria", "Struma Valley"],
        "flavor_profile": ["citrus", "apple", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kerner",
        "synonyms": ["Weinsberg S 2530"],
        "description": {
            "default": "Qualitatively the most successful modern German cross, versatile, producing Riesling-like wines.",
            "julie": "",
            "sommelier": "Kerner is the vivacious offspring of German ingenuity, delivering a zesty medley of citrus, peach, and floral aromas with a crisp, mouthwatering acidity that dances on the palate. Think of it as Riesling’s spirited cousin—bright, charming, and always ready to liven up your glass.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz", "Alto Adige", "Austria"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Khikhvi",
        "synonyms": ["Chichvi", "Djananura", "Janaani", "Jananura", "Khichvi"],
        "description": {
            "default": "Rare Georgian variety used for both dry and sweet wines.",
            "julie": "",
            "sommelier": "Khikhvi is Georgia’s hidden white gem, offering a delightful bouquet of peach, pear, and wildflowers, kissed with honey and a whisper of minerality. Whether enjoyed young or with some age, its medium body and gentle acidity make it a versatile companion for both festive feasts and quiet contemplation.",
        },
        "color": "white",
        "regions": ["Georgia", "Kakheti"],
        "flavor_profile": [
            "stone_fruit",
            "floral",
            "honey",
            "pear",
            "peach",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Khindogni",
        "synonyms": [
            "Chindogni",
            "Khendorni",
            "Khindogny",
            "Khndogni",
            "Scireni",
            "Sveni",
        ],
        "description": {
            "default": "Versatile grape from the southern Caucasus used to make just about every style of red wine.",
            "julie": "",
            "sommelier": "Khindogni is the chameleon of the Caucasus, offering a symphony of plum, cherry, and blackberry flavors laced with earthy spice and mineral intrigue—equally at home in a rustic table wine or a refined, age-worthy blend. This grape’s medium everything—acidity, tannin, body, and alcohol—makes it a crowd-pleaser, ready to charm both traditionalists and modernists alike.",
        },
        "color": "black",
        "regions": ["Georgia", "Armenia", "Azerbaijan"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Királyleányka",
        "synonyms": ["Dánosi Leányka"],
        "description": {
            "default": "Hungarian variety producing light, aromatic whites.",
            "julie": "",
            "sommelier": "Királyleányka, Hungary’s “Little Princess,” enchants with a bouquet of wildflowers and orchard fruits, delivering a zesty, high-acid white that dances lightly on the palate. Perfect for early sipping, this unoaked gem is a crisp, aromatic delight that brings a taste of Central Europe’s sun-dappled vineyards to your glass.",
        },
        "color": "white",
        "regions": ["Hungary", "Transylvania", "Romania"],
        "flavor_profile": ["floral", "stone_fruit", "apple", "pear", "peach", "citrus"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Kisi",
        "synonyms": ["Kissi", "Maghranuli"],
        "description": {
            "default": "Floral-scented Georgian variety made in both modern and traditional styles.",
            "julie": "",
            "sommelier": "Kisi is Georgia’s aromatic white gem, seducing the senses with a bouquet of wildflowers, juicy stone fruit, and a whisper of herbs, all wrapped in a mineral embrace. Whether crafted in ancient qvevri or modern cellars, Kisi delivers a vibrant, food-friendly wine that bridges tradition and innovation with every sip.",
        },
        "color": "white",
        "regions": ["Georgia", "Kakheti"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "herbal", "mineral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Klarnica",
        "synonyms": ["Klarna Mieja", "Klarnca", "Klarnitza", "Mejina"],
        "description": {
            "default": "Minor but characterful Slovenian variety making sweet-smelling whites.",
            "julie": "",
            "sommelier": "Klarnica is Slovenia’s aromatic hidden gem, offering a bouquet of wildflowers, ripe pears, and a drizzle of honey in every glass. Light on its feet and brimming with charm, this varietal is a delightful companion for those seeking a fresh, unoaked white with a whisper of sweetness.",
        },
        "color": "white",
        "regions": ["Slovenia", "Primorska", "Vipava Valley"],
        "flavor_profile": ["floral", "stone_fruit", "honey", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Knipperlé",
        "synonyms": [
            "Ettlinger",
            "Gelber Ortlieber",
            "Kleiner Räuschling",
            "Kniperlé",
            "Ortlieber",
            "Petit Mielleux",
            "Petit Räuschling",
            "Reichenweiherer",
            "Strassburger",
            "Türckheimer",
            "Wesser Ortlieber",
        ],
        "description": {
            "default": "Light-skinned, rot-prone Alsace variety on the way out.",
            "julie": "",
            "sommelier": "Knipperlé is the elusive ghost of Alsace, offering a zippy, citrus-and-apple dance on the palate with a whisper of wildflowers and wet stones—catch it before it vanishes from the vineyards for good!",
        },
        "color": "white",
        "regions": ["Alsace", "France", "Baden", "Germany"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Kok Pandas",
        "synonyms": ["Coc Pandas", "Kok Pandasse", "Pandas Kok", "Tken Izyum"],
        "description": {
            "default": "Vine making full-bodied whites in southern Ukraine.",
            "julie": "",
            "sommelier": "Kok Pandas dazzles from the sun-drenched vineyards of southern Ukraine, delivering a full-bodied white wine brimming with juicy stone fruit, crisp apple, and delicate floral aromas, all wrapped in a refreshing mineral embrace. This rare gem is a masterclass in balance—lush yet lively, and a true testament to Ukraine’s winemaking prowess.",
        },
        "color": "white",
        "regions": ["Southern Ukraine"],
        "flavor_profile": ["stone_fruit", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Kokur Bely",
        "synonyms": ["Belji Dolgi", "Dolgi", "Kokour Blanc", "Kokuri Belji"],
        "description": {
            "default": "Multi-purpose Ukrainian variety with possible Greek origins.",
            "julie": "",
            "sommelier": "Kokur Bely is a charming Ukrainian white grape with whispers of Greek ancestry, offering a crisp medley of apple, pear, and delicate florals over a mineral backbone—perfect for those who love their wines light, lively, and ready to drink. This grape is a true crowd-pleaser, shining in both blends and solo performances at the table.",
        },
        "color": "white",
        "regions": ["Ukraine", "Crimea", "Greece"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kolindrino",
        "synonyms": ["Kolindros"],
        "description": {
            "default": "Rare Greek variety named after its place of origin.",
            "julie": "",
            "sommelier": "Kolindrino, the elusive black gem of Macedonia, charms with a tapestry of red and black fruits, earthy spice, and a balanced, medium-bodied frame—perfect for those seeking a taste of Greek tradition in every sip.",
        },
        "color": "black",
        "regions": ["Macedonia", "Northern Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Korinthiaki",
        "synonyms": [
            "Alga Passera",
            "Black Corinth",
            "Corinthe Noir",
            "Corinto Negro",
            "Corinto Nero",
            "Crni Korint",
            "Currant Grape",
            "Korinthiaki Stafida",
            "Korinthiaki Stafis",
            "Korinthusi Kék",
            "Lianorogi",
            "Mavri Stafis",
            "Passerilla",
            "Passula di Corinto",
            "Raisin de Corinthe",
            "Stafida",
            "Stafidambelo",
            "Zante Currant",
        ],
        "description": {
            "default": "The currant grape.",
            "julie": "",
            "sommelier": "Korinthiaki, the famed currant grape of Greece, dazzles with a lively medley of red, black, and dried fruit flavors, all wrapped in a feather-light body and zippy acidity. Perfect for those who crave a refreshing, unoaked red that’s as spirited and sun-kissed as the Ionian coast itself.",
        },
        "color": "black",
        "regions": ["Greece", "Peloponnese", "Ionian Islands"],
        "flavor_profile": ["red_fruit", "black_fruit", "dried_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": ["red", "light_bodied", "unoaked", "early_drinking", "varietal"],
    },
    {
        "name": "Koriostafylo",
        "synonyms": ["Koriostaphylo"],
        "description": {
            "default": "Very rare Greek variety that seems to be exclusive to the island of Ikaría.",
            "julie": "",
            "sommelier": "Koriostafylo is Ikaría’s hidden gem—a medium-bodied red bursting with red and black fruit, earthy undertones, and a whisper of island minerality. Rarely seen beyond its windswept home, this grape offers a taste of Greek tradition in every glass.",
        },
        "color": "black",
        "regions": ["Ikaría", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "medium_bodied",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kotsifali",
        "synonyms": ["Kotrifali", "Kotsiphali", "Kotzifali"],
        "description": {
            "default": "Oft-maligned variety widely planted on Kríti (Crete), producing soft, pale, alcoholic but potentially aromatic and distinctive reds.",
            "julie": "",
            "sommelier": "Kotsifali, Crete’s unsung hero, delivers a charmingly pale yet potent red brimming with red fruit, wild herbs, and a whisper of spice—think of it as the Mediterranean in a glass, perfect for those who crave both character and conviviality. This high-spirited grape proves that looks can be deceiving, offering aromatic intrigue and a soft, easy-drinking style that’s made for lively tables and sun-drenched afternoons.",
        },
        "color": "black",
        "regions": ["Crete", "Greece"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Koutsoumpeli",
        "synonyms": [
            "Koutsoubeli",
            "Koutsoumbeli",
            "Koutsoumbeli Kokkino",
            "Koutsoumpeli Kokkino",
        ],
        "description": {
            "default": "Rare Greek pink-skinned variety.",
            "julie": "",
            "sommelier": "Koutsoumpeli is a rare Greek gem, offering a bouquet of red fruit and floral aromas with a whisper of stone fruit, all wrapped in a light, refreshing body—perfect for those seeking a taste of Thessaly’s sun-drenched vineyards in a glass. This pink-skinned beauty shines in lively rosés and blends, making every sip a celebration of Greek tradition and terroir.",
        },
        "color": "pink",
        "regions": ["Greece", "Thessaly", "Central Greece"],
        "flavor_profile": ["red_fruit", "floral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Kövidinka",
        "synonyms": [
            "Dinka Alba",
            "Dinka Fehér",
            "Kevedinka",
            "Kevidinka",
            "Kövidinka Rose",
            "Rosentraube",
            "Ruzsitza",
            "Steinschiller",
        ],
        "description": {
            "default": "Common pink-skinned Hungarian variety making commonplace whites.",
            "julie": "",
            "sommelier": "Kövidinka is the charming workhorse of Central Europe, delivering crisp, floral white wines with whispers of apple and pear—perfect for easy, early sipping. Its light body and gentle character make it a delightful companion for casual gatherings and traditional feasts alike.",
        },
        "color": "pink",
        "regions": ["Hungary", "Serbia", "Croatia", "Slovakia", "Romania"],
        "flavor_profile": ["apple", "pear", "floral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Krakhuna",
        "synonyms": ["Chkovra", "Krakhuna Shavi"],
        "description": {
            "default": "Minor but well-established Georgian variety producing fresh, fruity whites.",
            "julie": "",
            "sommelier": "Krakhuna is Georgia’s zesty secret, bursting with citrus and stone fruit, a floral breeze, and a mineral snap—think of it as a lively, unoaked white that dances on the palate and captures the spirit of Imereti in every sip.",
        },
        "color": "white",
        "regions": ["Georgia", "Imereti"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Kraljevina",
        "synonyms": ["Imbrina", "Kraljevina Crvena", "Moravina"],
        "description": {
            "default": "Old Croatian variety producing simple, refreshing everyday whites.",
            "julie": "",
            "sommelier": "Kraljevina is Croatia’s zesty answer to thirst, delivering a lively splash of citrus, apple, and delicate florals in a feather-light, mineral-driven frame. Perfect for sun-drenched afternoons, this high-acid charmer is the ultimate everyday white—crisp, refreshing, and delightfully unpretentious.",
        },
        "color": "white",
        "regions": ["Croatia"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Krasnostop Zolotovsky",
        "synonyms": ["Krasnostop", "Krasnostop Anapsky"],
        "description": {
            "default": "Russian variety making full-bodied dry reds as well as sweet fizz.",
            "julie": "",
            "sommelier": "Krasnostop Zolotovsky is Russia’s answer to bold, characterful reds—think a brooding symphony of plum, cherry, and blackberry, dusted with spice and earth, all wrapped in a full-bodied embrace. Whether as a robust table wine or a sweet, sparkling treat, this grape brings a taste of the Russian steppe to your glass.",
        },
        "color": "black",
        "regions": ["Russia", "Rostov", "Krasnodar"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "full_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Krassato",
        "synonyms": ["Krasata", "Krasato"],
        "description": {
            "default": "Greek variety integral to the Rapsáni appellation.",
            "julie": "",
            "sommelier": "Krassato, the soulful heart of Rapsáni, weaves together vibrant cherry and plum with a tapestry of herbs, spice, and earthy minerality—delivering a lively, medium-bodied red that sings of Greek tradition and terroir.",
        },
        "color": "black",
        "regions": ["Greece", "Thessaly", "Rapsani"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "herbal",
            "spice",
            "earth",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "medium_bodied",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Kreaca",
        "synonyms": [
            "Banat Riesling",
            "Bánáti Rizling",
            "Banatski Rizling",
            "Creaţă",
            "Creaţă de Banat",
            "Franchie",
            "Kreáca",
            "Kreatza",
            "Kriaca",
            "Riesling Banatsky",
            "Zakkelweiss",
        ],
        "description": {
            "default": "Rare Balkan pale-skinned vine now found mainly in Serbia.",
            "julie": "",
            "sommelier": "Kreaca is a zesty Balkan gem, bursting with citrus, stone fruit, and floral notes, all wrapped in a crisp, mineral-driven frame—think of it as the lively, lesser-known cousin of Riesling, perfect for adventurous palates and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Serbia", "Romania", "Hungary"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Krkošija",
        "synonyms": ["Krkochia", "Krkoshia", "Kyrkochia"],
        "description": {
            "default": "Minor blending partner for Žilavka in Bosnia and Herzegovina.",
            "julie": "",
            "sommelier": "Krkošija is the unsung hero of Bosnian blends, lending a zesty citrus and stone fruit brightness with a whisper of minerality—think of it as the lively supporting actor that makes Žilavka shine. Light-bodied and refreshingly crisp, it’s a delightful sip for those seeking tradition with a twist.",
        },
        "color": "white",
        "regions": ["Bosnia and Herzegovina"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "unoaked",
            "table_wine",
            "light_bodied",
            "traditional",
        ],
    },
    {
        "name": "Krstač",
        "synonyms": [
            "Bijeli Krstač",
            "Krata Bijela",
            "Krstač Bijela",
            "Loza Bijela",
            "Vinogradarska Bijela",
        ],
        "description": {
            "default": "Old Montenegrin variety producing light, summery whites.",
            "julie": "",
            "sommelier": "Krstač is Montenegro’s breezy white gem, offering a zesty medley of citrus and stone fruit with a whisper of wildflowers and a crisp mineral finish—perfect for sun-drenched afternoons and seaside feasts. Light on its feet and refreshingly unoaked, this ancient variety is a delightful taste of Balkan tradition in every glass.",
        },
        "color": "white",
        "regions": ["Montenegro"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Kujundžuša",
        "synonyms": ["Kojundžuša", "Kujundžuša Bijela", "Tvrdac", "Žutac", "Žutka"],
        "description": {
            "default": "Rare Dalmatian variety.",
            "julie": "",
            "sommelier": "Kujundžuša is Dalmatia’s hidden white gem, offering a breezy medley of citrus, stone fruit, and delicate florals over a crisp, mineral backbone. Light-bodied and lively, it’s the perfect companion for sun-drenched afternoons and fresh seafood feasts.",
        },
        "color": "white",
        "regions": ["Dalmatia", "Croatia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Kupusar",
        "synonyms": ["Plavac Kupusar"],
        "description": {
            "default": "Very rare, tannic variety from coastal Croatia.",
            "julie": "",
            "sommelier": "Kupusar is a Croatian coastal gem, brimming with brooding black fruit, earthy spice, and a muscular tannic grip—think of it as the Adriatic’s answer to a powerlifting Malbec, perfect for those who like their reds bold, age-worthy, and a little bit wild.",
        },
        "color": "black",
        "regions": ["Coastal Croatia", "Dalmatia"],
        "flavor_profile": ["black_fruit", "spice", "earth", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "age_worthy",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Kydonitsa",
        "synonyms": ["Kidonitsa"],
        "description": {
            "default": "Promising but still very minor variety producing aromatic, finely textured wines near Monemvasia.",
            "julie": "",
            "sommelier": "Kydonitsa is Greece’s hidden white gem, offering a bouquet of wildflowers, juicy pear, and zesty citrus in every sip—think of it as a sun-drenched stroll through a Peloponnesian orchard, bottled for your pleasure. With its silky texture and vibrant freshness, this unoaked beauty is a must-try for adventurous palates seeking something truly unique.",
        },
        "color": "white",
        "regions": ["Greece", "Peloponnese", "Monemvasia"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "pear", "apple"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "varietal", "unoaked", "premium", "early_drinking"],
    },
    {
        "name": "L’Acadie Blanc",
        "synonyms": ["Acadie", "L’Acadie", "V 53261"],
        "description": {
            "default": "1950s Canadian very complex hybrid performing well in the chilly climes of Nova Scotia and Québec.",
            "julie": "",
            "sommelier": "L’Acadie Blanc is the zesty darling of Canada’s Atlantic vineyards, bursting with citrus, apple, and a crisp mineral edge that dances on the palate. Perfect for lovers of lively, unoaked whites and sparkling wines, it’s a refreshing taste of Nova Scotia’s cool breezes in every glass.",
        },
        "color": "white",
        "regions": ["Nova Scotia", "Québec"],
        "flavor_profile": ["citrus", "apple", "lemon", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "La Crescent",
        "synonyms": ["MN 1166"],
        "description": {
            "default": "Promising and increasingly popular cold-hardy American hybrid.",
            "julie": "",
            "sommelier": "La Crescent dazzles with a lively medley of citrus, peach, and honey, delivering a crisp, aromatic white that’s as refreshing as a Minnesota breeze—perfect for those who crave a zesty, fruit-forward sip with a touch of northern charm.",
        },
        "color": "white",
        "regions": [
            "Minnesota",
            "Wisconsin",
            "Vermont",
            "Iowa",
            "New York (Finger Lakes)",
            "Canada (Ontario)",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "floral",
            "honey",
            "apple",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
            "dessert",
            "unoaked",
        ],
    },
    {
        "name": "La Crosse",
        "synonyms": ["ES 294", "LaCrosse"],
        "description": {
            "default": "Complex American hybrid starting to achieve some success in the US Midwest.",
            "julie": "",
            "sommelier": "La Crosse is the Midwest’s answer to a summer refresher: light-bodied and zesty, it bursts with orchard fruit and citrus, finishing with a delicate floral-mineral lift. This charming hybrid is perfect for picnics and patio sipping, offering a taste of the heartland in every glass.",
        },
        "color": "white",
        "regions": ["Minnesota", "Wisconsin", "Iowa", "Illinois", "Missouri"],
        "flavor_profile": ["apple", "pear", "citrus", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Lacrima Di Morro D’Alba",
        "synonyms": ["Lacrima"],
        "description": {
            "default": "Recovered, very local Marche speciality used for both dry and sweet early-maturing reds",
            "julie": "",
            "sommelier": "Lacrima di Morro d’Alba is Marche’s fragrant secret, bursting with cherry, raspberry, and a bouquet of wildflowers, all wrapped in a silky, medium-bodied frame—an early-drinking delight that’s as enchanting as its name.",
        },
        "color": "black",
        "regions": ["Marche", "Morro d'Alba"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Lafnetscha",
        "synonyms": ["Laffnetscha", "Lafnätscha", "Lavenetsch"],
        "description": {
            "default": "Old but quantitively unimportant Swiss variety producing well-structured, ageworthy whites.",
            "julie": "",
            "sommelier": "Lafnetscha is Switzerland’s hidden white gem, offering a zesty medley of citrus and stone fruit with a floral lift and a mineral backbone—think of it as an alpine breeze in a glass, built to age gracefully. This rare Valais varietal is a must-try for those seeking a crisp, characterful white with a story to tell.",
        },
        "color": "white",
        "regions": ["Switzerland", "Valais"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "varietal", "premium", "age_worthy"],
    },
    {
        "name": "Lagarino Bianco",
        "synonyms": ["Chegarèl", "Sghittarella"],
        "description": {
            "default": "Old but only recently registered crisp Trentino white wine grape.",
            "julie": "",
            "sommelier": "Lagarino Bianco is Trentino’s zesty secret, bursting with citrus, apple, and a stony minerality, all wrapped in a feather-light frame—perfect for those who crave a brisk, floral Italian white that dances on the palate.",
        },
        "color": "white",
        "regions": ["Trentino", "Trentino-Alto Adige", "Northern Italy"],
        "flavor_profile": ["citrus", "apple", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lagrein",
        "synonyms": ["Lagrain"],
        "description": {
            "default": "Very well-connected, distinctively fruity but sometimes rustic feature of the Alto Adige.",
            "julie": "",
            "sommelier": "Lagrein is Alto Adige’s brooding black beauty, delivering a robust, full-bodied red brimming with blackberries, plums, and a wild streak of spice and leather—perfect for those who like their wines as untamed as the Dolomites themselves.",
        },
        "color": "black",
        "regions": ["Alto Adige", "Trentino", "Northern Italy", "South Tyrol"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "leather",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Lairén",
        "synonyms": [
            "Laeren del Rey",
            "Layrenes",
            "Malvar",
            "Mantuo Laéren",
            "Mantuo Layrenes",
            "Temprana Agosteña",
        ],
        "description": {
            "default": "Very minor Andalusian variety often mistaken for the much more common Airén.",
            "julie": "",
            "sommelier": "Lairén is Andalusia’s hidden white gem, offering a crisp medley of apple and pear with a whisper of floral and mineral charm—think of it as Airén’s more interesting, elusive sibling, perfect for a sun-drenched afternoon. Light-bodied and unoaked, it’s a delightful companion for those who seek something off the beaten Spanish path.",
        },
        "color": "white",
        "regions": ["Andalusia", "Spain"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lalvari",
        "synonyms": ["Burra", "Dana Bouroun", "Dana Burnu", "Dana Burun", "Glglan"],
        "description": {
            "default": "Versatile Armenian white wine grape.",
            "julie": "",
            "sommelier": "Lalvari is Armenia’s zesty white gem, bursting with citrus, stone fruit, and delicate floral notes, all wrapped in a light, refreshing frame. Perfect for early sipping, this versatile grape brings a lively, mineral-driven charm to both blends and varietal wines.",
        },
        "color": "white",
        "regions": ["Armenia"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lambrusca Di Alessandria",
        "synonyms": [
            "Anrè",
            "Caruét",
            "Croetto",
            "Crova",
            "Crovet",
            "Crovìn",
            "Moretto",
            "Lambrusco di Alessandria",
            "Neretto di Alessandria",
            "Stupèt",
        ],
        "description": {
            "default": "Adaptable but minor dark-skinned variety grown in parts of Piemonte, north-west Italy, and generally blended.",
            "julie": "",
            "sommelier": "Lambrusca Di Alessandria is Piemonte’s secret handshake—an adaptable, dark-skinned grape that brings a medley of red and black fruits, earthy undertones, and a mineral streak to traditional blends. Medium-bodied and easygoing, it’s the perfect companion for a lively Italian table.",
        },
        "color": "black",
        "regions": ["Piemonte", "North-West Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Lambrusca Vittona",
        "synonyms": ["Vittona"],
        "description": {
            "default": "Very minor Piemontese variety.",
            "julie": "",
            "sommelier": "Lambrusca Vittona is Piedmont’s hidden gem, offering a charming medley of cherry, plum, and earthy undertones in a medium-bodied, easy-drinking red. This rare varietal is a delightful nod to tradition, perfect for those seeking a taste of Italy’s vinous secrets.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lambruschetto",
        "synonyms": ["Crovino", "Lambruschetta", "Malaga"],
        "description": {
            "default": "Old and very localized variety arousing current interest in Piemonte.",
            "julie": "",
            "sommelier": "Lambruschetto is Piemonte’s hidden gem, offering a lively medley of cherries, plums, and raspberries dusted with earthy intrigue—perfect for those who crave a medium-bodied red that’s as charmingly rustic as it is refreshingly drinkable. This old-school variety is making a comeback, and it’s ready to steal the show at your next table.",
        },
        "color": "black",
        "regions": ["Piemonte"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lambrusco Barghi",
        "synonyms": ["Lambrusco Bardi", "Lambrusco Corbelli", "Lambrusco di Rivalta"],
        "description": {
            "default": "Very minor, recently recognized, dark-skinned blending component in Reggio.",
            "julie": "",
            "sommelier": "Lambrusco Barghi is the unsung hero of Emilia-Romagna blends, offering a charming medley of red and black fruits with a floral lift and earthy undertones—perfect for those who love their sparkling reds light, lively, and ready to party.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Reggio Emilia"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "sparkling",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lambrusco Di Fiorano",
        "synonyms": ["Lambruscone"],
        "description": {
            "default": "Obscure, highly localized Emilia-Romagna variety unrelated to other Lambruscos.",
            "julie": "",
            "sommelier": "Lambrusco Di Fiorano is Emilia-Romagna’s secret handshake—an obscure, vivacious grape bursting with red and black fruit, floral perfume, and earthy charm. With its zippy acidity and medium body, it’s the life of the party in both sparkling and still forms, perfect for early drinking and classic Italian fare.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Lambrusco Di Sorbara",
        "synonyms": ["Lambruschetta di Sorbara", "Lambrusco Sorbarese"],
        "description": {
            "default": "Perhaps the most respected of the varieties responsible for Lambrusco, Emilia-Romagna’s potentially refreshing, lightly frothy, food-friendly red.",
            "julie": "",
            "sommelier": "Lambrusco di Sorbara is the crown jewel of Emilia-Romagna’s sparkling reds, bursting with lively cherry and raspberry notes, a floral lift, and a zippy acidity that dances on the palate. Light-bodied and low in tannin, it’s the ultimate party guest—refreshing, approachable, and always ready to mingle with your favorite foods.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "earth"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Lambrusco Grasparossa",
        "synonyms": ["Lambrusco di Castelvetro", "Scorzamara"],
        "description": {
            "default": "Makes fuller, more tannic Lambrusco than most, both dry and medium sweet.",
            "julie": "",
            "sommelier": "Lambrusco Grasparossa is the rock star of the Lambrusco family—bold, tannic, and bursting with flavors of cherry, plum, and spice, all wrapped in a lively sparkle. Hailing from Emilia-Romagna, this grape delivers a full-bodied, high-acid red that dances between rustic charm and festive elegance.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Castelvetro di Modena"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "raspberry",
            "earth",
            "spice",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Lambrusco Maestri",
        "synonyms": ["Grappello Maestri", "Lambrusco di Spagna"],
        "description": {
            "default": "One of the lesser Lambruscos, from Parma, and making rather rustic wines.",
            "julie": "",
            "sommelier": "Lambrusco Maestri is the Parma rebel of the Lambrusco clan, bursting with juicy cherry, plum, and a rustic earthiness that dances on the palate—think of it as the life of the Emilia-Romagna party, best enjoyed young and sparkling with a hearty plate of salumi.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Parma"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lambrusco Oliva",
        "synonyms": ["Lambrusco Mazzone", "Olivone"],
        "description": {
            "default": "Relatively minor, occasionally bitter Lambrusco variety.",
            "julie": "",
            "sommelier": "Lambrusco Oliva is the rebellious cousin in the Lambrusco family, bursting with cherry, plum, and raspberry flavors, a floral lift, and a cheeky hint of bitterness. Its high acidity and medium body make it a zesty, food-friendly sparkler or table wine that’s as lively as an Italian festa.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Lombardy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "earth",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Lambrusco Salamino",
        "synonyms": ["Lambrusco Galassi", "Lambrusco di Santa Croce"],
        "description": {
            "default": "The most widely planted of the Lambrusco varieties, making the most substantial wines.",
            "julie": "",
            "sommelier": "Lambrusco Salamino dazzles with a jubilant burst of cherries, plums, and blackberries, all wrapped in a lively sparkle and a refreshing, food-friendly acidity—making it the life of any Italian table. This is the quintessential Lambrusco: playful, aromatic, and always ready to turn a meal into a celebration.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Modena", "Reggio Emilia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "floral",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Lambrusco Viadanese",
        "synonyms": ["Grappello Ruperti", "Mantovano", "Montecchio", "Viadanese"],
        "description": {
            "default": "Minor but characterful Lambrusco variety.",
            "julie": "",
            "sommelier": "Lambrusco Viadanese is the life of the party in a glass—bursting with cherry, raspberry, and blackberry, this lively, lightly sparkling red from northern Italy charms with floral aromas, earthy undertones, and a zippy acidity that keeps you coming back for more. Perfect for those who like their wines fun, fresh, and full of character.",
        },
        "color": "black",
        "regions": ["Lombardy", "Emilia-Romagna", "Mantova (Mantua)"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "raspberry",
            "blackberry",
            "floral",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Landal",
        "synonyms": ["Landot 244"],
        "description": {
            "default": "Disease-resistant, waning French hybrid.",
            "julie": "",
            "sommelier": "Landal is a rare French hybrid that charms with lively raspberry and cherry flavors, a whisper of earth and herbs, and a feather-light body—perfect for those seeking a fresh, easygoing red that’s as adaptable as it is intriguing.",
        },
        "color": "black",
        "regions": [
            "Loire Valley",
            "Eastern France",
            "Canada",
            "Northeastern United States",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "herbal",
            "raspberry",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "table_wine",
            "early_drinking",
            "unoaked",
        ],
    },
    {
        "name": "Landot Noir",
        "synonyms": ["Landot 4511"],
        "description": {
            "default": "Minor French hybrid, son of Landal, also found in a few pockets in the US and Canada.",
            "julie": "",
            "sommelier": "Landot Noir is the adventurous offspring of French hybrids, offering a playful dance of cherry, plum, and raspberry with a whisper of earth and herbs—perfect for those seeking a light, easy-drinking red that’s as versatile as it is rare.",
        },
        "color": "black",
        "regions": ["France", "United States", "Canada"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Lanzesa",
        "synonyms": ["Lanzés", "Lanzesca"],
        "description": {
            "default": "Very rare white wine speciality of Ravenna in northern Italy.",
            "julie": "",
            "sommelier": "Lanzesa is Ravenna’s secret white treasure, bursting with zesty citrus, delicate florals, and a stony minerality that dances on the palate. With its high acidity and feather-light body, this rare gem is a crisp, refreshing sip of northern Italian sunshine—perfect for those who crave discovery in their glass.",
        },
        "color": "white",
        "regions": ["Ravenna", "Emilia-Romagna", "Northern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Lasina",
        "synonyms": ["Krapljenica", "Kutlarica", "Lasin", "Lasina Crna", "Vlasina"],
        "description": {
            "default": "Very rare vine found only in Dalmacija (Dalmatia) and generally used in blends.",
            "julie": "",
            "sommelier": "Lasina, Dalmatia’s elusive black grape, charms with a medley of cherry and raspberry, underscored by herbal and earthy whispers—think of it as the soulful secret behind Croatia’s most convivial blends. Medium-bodied and delightfully approachable, it’s a rare treat for those seeking a taste of the Adriatic’s hidden gems.",
        },
        "color": "black",
        "regions": ["Dalmatia", "Croatia"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Laurot",
        "synonyms": ["MI 5-106"],
        "description": {
            "default": "Recently bred and privately owned disease-resistant Czech dark-skinned hybrid.",
            "julie": "",
            "sommelier": "Laurot is Central Europe’s answer to modern red wine: a lively, dark-skinned hybrid bursting with cherry, plum, and blackberry, underpinned by earthy and herbal notes. With its zippy acidity and approachable structure, it’s a fresh-faced charmer perfect for early-drinking and adventurous blends.",
        },
        "color": "black",
        "regions": ["Czech Republic", "Slovakia", "Central Europe"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "herbal",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "modern",
            "early_drinking",
        ],
    },
    {
        "name": "Lauzet",
        "synonyms": ["Laouset", "Lauzet Blanc"],
        "description": {
            "default": "Almost extinct variety in Jurançon, south-west France.",
            "julie": "",
            "sommelier": "Lauzet is a nearly forgotten gem from Jurançon, offering a zesty medley of citrus and stone fruit with a floral lift and mineral backbone—think of it as a crisp mountain stream in a glass, perfect for adventurous palates seeking a taste of French wine history.",
        },
        "color": "white",
        "regions": ["Jurançon", "South-West France"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Len De L’El",
        "synonyms": [
            "Cavaillès",
            "Cavalier",
            "Len-de-Lel",
            "Len de l’Elh",
            "Lenc dé l’El",
            "Loin de l’Oeil",
        ],
        "description": {
            "default": "Highly localized and well suited to the production of sweet wines in its native Gaillac.",
            "julie": "",
            "sommelier": "Len De L’El is Gaillac’s secret weapon for sumptuous dessert wines, bursting with red and black fruits, honeyed florals, and a whisper of dried fruit, all wrapped in a full-bodied, high-acid embrace. This rare grape is a decadent treat for those who crave both history and hedonism in their glass.",
        },
        "color": "black",
        "regions": ["Gaillac", "Southwest France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "dried_fruit",
            "floral",
            "honey",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": ["dessert", "traditional", "varietal", "age_worthy"],
    },
    {
        "name": "Léon Millot",
        "synonyms": ["Frühe Schwarze", "Kuhlmann 194-2", "Millot"],
        "description": {
            "default": "French hybrid producing deeply coloured reds. Popular in regions with short growing seasons.",
            "julie": "",
            "sommelier": "Léon Millot is the plucky underdog of the wine world, delivering a vibrant medley of cherry, plum, and blackberry with a whisper of earth and spice—perfect for those who crave a lively, medium-bodied red from cooler climes. This French hybrid charms with its adaptability and early-drinking appeal, making every glass a celebration of resilience and flavor.",
        },
        "color": "black",
        "regions": [
            "France (Alsace, Loire)",
            "United States (Midwest, Finger Lakes, Pacific Northwest)",
            "Canada (Ontario, Quebec)",
            "Switzerland",
            "Germany",
        ],
        "flavor_profile": [
            "black_fruit",
            "red_fruit",
            "cherry",
            "plum",
            "blackberry",
            "raspberry",
            "earth",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Liatiko",
        "synonyms": ["Aleatiko", "Liatico", "Liatis", "Stafili Tu Louliou"],
        "description": {
            "default": "Idiosyncratic and underrated dark-skinned Cretan variety making aromatic dry and sweet wines.",
            "julie": "",
            "sommelier": "Liatiko is Crete’s enigmatic black grape, weaving together red and dried fruits, spice, and wild herbs into both dry and sweet wines that are as aromatic as they are age-worthy. This underrated gem offers a taste of the island’s sun-drenched earth and ancient winemaking traditions in every glass.",
        },
        "color": "black",
        "regions": ["Crete", "Greece"],
        "flavor_profile": [
            "red_fruit",
            "dried_fruit",
            "spice",
            "earth",
            "herbal",
            "floral",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "traditional",
            "age_worthy",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Limnio",
        "synonyms": [
            "Kalabaki",
            "Kalambaki",
            "Kalampaki",
            "Lembiotiko",
            "Lemnia",
            "Lemnio",
        ],
        "description": {
            "default": "Ancient Greek variety that has successfully travelled from the island of Límnos to the mainland and is often a minor partner to Cabernets Sauvignon and Franc.",
            "julie": "",
            "sommelier": "Limnio, the ancient jewel of Greece, delivers a vibrant tapestry of red and black fruits, herbal intrigue, and earthy spice, all wrapped in a lively, medium-bodied frame. Whether blended or solo, this grape brings a taste of Greek history to every glass—think of it as mythology in a bottle!",
        },
        "color": "black",
        "regions": ["Límnos", "Macedonia (Greece)", "Thessaly", "Northern Greece"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "spice",
            "earth",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Limniona",
        "synonyms": ["Lemniona"],
        "description": {
            "default": "Recently resurrected and promising Greek variety from Thessalía.",
            "julie": "",
            "sommelier": "Limniona is Thessalía’s comeback kid, delivering a lively medley of cherry, raspberry, and spice, all wrapped in a floral embrace and earthy undertones—think of it as Greece’s answer to Pinot Noir, but with a sun-kissed Mediterranean twist.",
        },
        "color": "black",
        "regions": ["Thessalía", "Greece"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "modern",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Listán De Huelva",
        "synonyms": [
            "Listán",
            "Listán Blanca",
            "Malvasia Rasteiro",
            "Manteúdo",
            "Manteúdo Branco",
            "Mantheudo",
            "Manteúdo do Algarve",
            "Vale Grosso",
        ],
        "description": {
            "default": "Minor variety used mostly for fino-like wines in western Andalucía.",
            "julie": "",
            "sommelier": "Listán De Huelva is Andalucía’s zesty secret, delivering a lively medley of citrus, wildflowers, and a whisper of almonds in every glass. With its high acidity and feather-light body, this grape is the perfect companion for sun-drenched afternoons and tapas by the sea.",
        },
        "color": "white",
        "regions": ["Andalucía", "Huelva", "Algarve"],
        "flavor_profile": ["citrus", "mineral", "floral", "nuts"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Listán Negro",
        "synonyms": ["Almuñeco", "Listán Morado", "Negra Commún"],
        "description": {
            "default": "The red wine grape of Spain’s Islas Canarias. Potentially aromatic wines.",
            "julie": "",
            "sommelier": "Listán Negro is the volcanic soul of the Canary Islands in a glass—think smoky red and black fruits, a dash of spice, and a whisper of wildflowers, all wrapped in a medium-bodied, easy-drinking style that’s as lively as a Tenerife fiesta.",
        },
        "color": "black",
        "regions": ["Canary Islands", "Tenerife", "La Palma"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "earth",
            "mineral",
            "smoke",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Listán Prieto",
        "synonyms": [
            "Criolla Chica",
            "El Paso",
            "Hariri",
            "Listrão",
            "Misión",
            "Mission",
            "Mission’s Grape",
            "Moscatel Negro",
            "Negra Antigua",
            "Negra Corriente",
            "Negra Peruana",
            "País",
            "Palomina Negra",
            "Rosa del Perú",
            "Uva Chica Negra",
            "Uva Negra",
            "Uva Negra Vino",
            "Uva Tinta",
            "Viña Blanca",
            "Viña Negra",
        ],
        "description": {
            "default": "Historically important, well-travelled, dark-skinned Spanish variety now more common in the Americas but generally in retreat and, with some recent exceptions, producing inferior wines.",
            "julie": "",
            "sommelier": "Listán Prieto is the Indiana Jones of grapes—adventurous, well-traveled, and full of stories, delivering light, unoaked reds brimming with cherry and raspberry, a touch of earth, and a whisper of herbs. While it may not always steal the show, its rustic charm and historical pedigree make it a delightful companion for casual sipping and lively conversation.",
        },
        "color": "black",
        "regions": [
            "Chile",
            "Argentina",
            "California",
            "Canary Islands",
            "Peru",
            "Mexico",
            "Bolivia",
        ],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ljutun",
        "synonyms": ["Ljutac", "Plavac", "Plavac Bedalovac"],
        "description": {
            "default": "Rare, tart Croatian variety exclusive to the area just north west of Split on the Dalmatian coast.",
            "julie": "",
            "sommelier": "Ljutun is a hidden Croatian treasure, bursting with tart red and black fruits, herbal intrigue, and a salty Dalmatian breeze. With its zippy acidity and medium frame, this rare grape delivers a vibrant, mineral-driven red that’s as lively and authentic as the coast it calls home.",
        },
        "color": "black",
        "regions": ["Dalmatian Coast", "Croatia", "Split (northwest area)"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Longyan",
        "synonyms": ["Czhi-Pu-Tao", "Hun-Juan-Sin", "Long Yan", "Lungyen"],
        "description": {
            "default": "Old and widely planted red-skinned Chinese variety used for the table and for white wine.",
            "julie": "",
            "sommelier": 'Longyan, the "Dragon\'s Eye" of China, enchants with its ethereal bouquet of stone fruit and blossoms, delivering a crisp, light-bodied white wine that dances on the palate with whispers of apple and pear—perfect for early sipping and discovering the subtle elegance of Chinese terroir.',
        },
        "color": "red",
        "regions": ["China", "Hebei", "Shandong"],
        "flavor_profile": ["stone_fruit", "floral", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Louise Swenson",
        "synonyms": ["ES 4-8-33"],
        "description": {
            "default": "Complex American hybrid with a significant degree of cold hardiness.",
            "julie": "",
            "sommelier": "Louise Swenson is the snow queen of northern vineyards, delivering a zesty, floral bouquet with a mineral backbone and a medley of orchard fruits. This lively, light-bodied white is perfect for those who crave a crisp, refreshing sip straight from the heart of winter’s domain.",
        },
        "color": "white",
        "regions": [
            "Minnesota",
            "Vermont",
            "Wisconsin",
            "New York (Finger Lakes)",
            "Quebec",
        ],
        "flavor_profile": [
            "citrus",
            "floral",
            "mineral",
            "stone_fruit",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Loureiro",
        "synonyms": [
            "Branco Redondos",
            "Loureira",
            "Loureiro Blanco",
            "Marqués",
            "Marquez",
        ],
        "description": {
            "default": "High-quality, aromatic Vinho Verde variety.",
            "julie": "",
            "sommelier": "Loureiro is the zesty songbird of Portugal’s Vinho Verde, bursting with citrus blossom, green apple, and a mineral snap that dances across the palate. With its high acidity and feather-light body, this grape crafts wines as refreshing as a seaside breeze—perfect for sipping on sunlit afternoons.",
        },
        "color": "white",
        "regions": ["Vinho Verde", "Minho", "Portugal", "Galicia", "Spain"],
        "flavor_profile": ["citrus", "floral", "mineral", "lemon", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Lucie Kuhlmann",
        "synonyms": ["Kuhlmann 149-3", "Lucy-Kuhlman"],
        "description": {
            "default": "Minor French hybrid grown mainly in Canada.",
            "julie": "",
            "sommelier": "Lucie Kuhlmann is a spirited Canadian hybrid that bursts with cherry, plum, and raspberry, layered over earthy herbs and spice—think of it as the lively, chatty guest at a dinner party, always ready to charm with its fresh acidity and easygoing style.",
        },
        "color": "black",
        "regions": ["Canada", "Quebec", "Nova Scotia", "France (minor)"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "herbal",
            "earth",
            "spice",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Luglienga",
        "synonyms": [
            "Agostenga",
            "Bona in Ca",
            "Guštana",
            "Jouanenc",
            "Lignan Blanc",
            "Lignenga",
            "Lugliatica",
            "Luglienga Blanca",
            "Luigese",
            "Seidentraube",
            "Uva di Sant’Anna",
        ],
        "description": {
            "default": "Historic, widespread but mainly table grape.",
            "julie": "",
            "sommelier": "Luglienga is the charming summer guest at your table—crisp apple and pear flavors mingle with delicate floral and citrus notes, all wrapped in a light, refreshing body that’s perfect for easy sipping or snacking. This historic grape is a delightful reminder that sometimes, the simplest pleasures are the most memorable.",
        },
        "color": "white",
        "regions": ["Italy", "France", "Switzerland"],
        "flavor_profile": ["apple", "pear", "floral", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Lumassina",
        "synonyms": [
            "Acerbina",
            "Buzzetto",
            "Garella",
            "Mataòsso",
            "Mataòssu",
            "Uga Matta",
        ],
        "description": {
            "default": "Rare, light, crisp white exclusive to Liguria in north-west Italy.",
            "julie": "",
            "sommelier": "Lumassina is Liguria’s hidden gem—a zesty, floral white that dances on the palate with high acidity and a mineral backbone, perfect for seaside sipping. Rarely found outside its coastal home, this crisp varietal is a refreshing ode to Italian tradition and the Mediterranean breeze.",
        },
        "color": "white",
        "regions": ["Liguria", "Italy"],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Macabeo",
        "synonyms": [
            "Charas Blanc",
            "Lardot",
            "Macabeu",
            "Maccabéo",
            "Maccabeu",
            "Viura",
            "Vuera",
        ],
        "description": {
            "default": "Often underestimated, widely grown variety that can make ageworthy whites as Viura in Rioja and Maccabeu in Roussillon.",
            "julie": "Macabeo, also known as Viura, is northern spain most planted white grape variety. It plays a key role in the production of Cava wines in Catalonia where it is generally blended with Parellada and Xarello. Maccabeo wines tends to be delicately aromatic with nuances of white flowers and almonds and low in acidity. ",
            "sommelier": "Macabeo, the unsung hero behind Spain’s finest Cava and ageworthy Riojas, charms with whispers of white flowers and almonds, all wrapped in a gentle, medium-bodied embrace. Whether sparkling or still, this versatile grape proves that subtlety and grace can steal the show.",
        },
        "color": "white",
        "regions": ["Rioja", "Catalonia", "Roussillon", "Penedès", "Navarra"],
        "flavor_profile": ["floral", "nuts"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "blend",
            "varietal",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Maceratino",
        "synonyms": [
            "Bianchetta Montecchiese",
            "Greco delle Marche",
            "Greco Maceratino",
            "Maceratese",
            "Matelicano",
            "Montecchiese",
            "Ribona",
            "Uva Stretta",
            "Verdicchio Marino",
            "Verdicchio Tirolese",
        ],
        "description": {
            "default": "Rare white found in the Marche on Italy’s Adriatic coast.",
            "julie": "",
            "sommelier": "Maceratino is the Adriatic’s hidden gem—zesty, floral, and brimming with stone fruit and herbal intrigue, this light-bodied white dazzles with high acidity and a mineral backbone, making it the perfect seaside sipper for those in the know.",
        },
        "color": "white",
        "regions": ["Marche"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Madeleine Angevine",
        "synonyms": ["Äugstler Weiss", "Maddalena Angevina", "Madlen Anževin"],
        "description": {
            "default": "Minor, fresh, citrusy French variety found mainly in Canada and very cool parts of Europe, sometimes grown for table grapes.",
            "julie": "",
            "sommelier": "Madeleine Angevine is the zesty darling of northern vineyards, offering a lively burst of citrus and delicate florals with a crisp, mineral finish—perfect for those who crave a refreshing, low-alcohol white that sings of cool-climate terroir.",
        },
        "color": "white",
        "regions": [
            "Canada",
            "England",
            "Germany",
            "France (Loire Valley)",
            "Netherlands",
        ],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Madrasa",
        "synonyms": [
            "Kara Shirei",
            "Qara Shira",
            "Matrasa",
            "Matrassa",
            "Medrese",
            "Sevi Shirai",
        ],
        "description": {
            "default": "Widely planted Azeri variety producing full-bodied and well-structured wines.",
            "julie": "",
            "sommelier": "Madrasa is the pride of Azerbaijan, delivering deeply colored, full-bodied reds brimming with luscious black fruit, plum, and earthy spice—think of it as the soulful storyteller of the Caucasus in a glass. With its harmonious structure and age-worthy charm, Madrasa is a must-try for adventurous palates seeking a taste of ancient wine traditions.",
        },
        "color": "black",
        "regions": ["Azerbaijan", "Caucasus", "Georgia", "Armenia"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "age_worthy",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Magliocco Canino",
        "synonyms": ["Magliocco Ovale", "Maglioccolone", "Magliocco"],
        "description": {
            "default": "Makes tannic wines mainly for blends in Calabria.",
            "julie": "",
            "sommelier": "Magliocco Canino is Calabria’s brooding powerhouse, delivering a full-bodied, tannic embrace packed with black fruit, plum, and earthy spice—perfect for those who crave a wine with both muscle and Mediterranean soul. Often the backbone of local blends, it’s a grape that brings the rugged charm of southern Italy straight to your glass.",
        },
        "color": "black",
        "regions": ["Calabria"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "full_bodied", "table_wine"],
    },
    {
        "name": "Magliocco Dolce",
        "synonyms": [
            "Arvino",
            "Catanzarese",
            "Gaddrica",
            "Greco Nero",
            "Guarnaccia Nera",
            "Lacrima Cristi Nera",
            "Magliocco Tondo",
            "Maglioccuni",
            "Mangiaguerra",
            "Marcigliana",
            "Marsigliana Nera",
            "Merigallo",
            "Nera di Scilla",
            "Petroniere",
        ],
        "description": {
            "default": "Widely planted Calabrian and the more common of the two Maglioccos.",
            "julie": "",
            "sommelier": "Magliocco Dolce is Calabria’s bold black beauty, brimming with brooding blackberry, earthy spice, and a mineral backbone—think of it as southern Italy’s answer to a fireside philosopher, ready to age gracefully or charm at the table.",
        },
        "color": "black",
        "regions": ["Calabria", "Italy"],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "blackberry",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Magnolia",
        "synonyms": ["North Carolina 60-60"],
        "description": {
            "default": "Minor Muscadine variety that ripens unevenly.",
            "julie": "",
            "sommelier": "Magnolia, the Southern belle of Muscadines, dazzles with a bouquet of tropical fruit and floral notes, all wrapped in a crisp, high-acid embrace. This rare grey grape from North Carolina is perfect for those seeking a lively, unoaked white that’s as charmingly unpredictable as a summer garden party.",
        },
        "color": "grey",
        "regions": ["North Carolina", "Southeastern United States"],
        "flavor_profile": ["tropical_fruit", "floral", "earth"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Magyarfrankos",
        "synonyms": ["Magyar Frankos"],
        "description": {
            "default": "Dark-skinned escapee from experimental plantings during Hungary’s Communist era.",
            "julie": "",
            "sommelier": "Magyarfrankos is Hungary’s rebellious red, a medium-bodied charmer that escaped the shadows of Communist-era experimentation to deliver a lively medley of red and black fruits, earthy spice, and a dash of intrigue in every glass. This grape is a testament to resilience, offering a traditional table wine with a story as captivating as its flavors.",
        },
        "color": "black",
        "regions": ["Hungary"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Maiolica",
        "synonyms": ["Gaglioppa", "Ortonese"],
        "description": {
            "default": "Minor dark-skinned Abruzzo variety, usually blended with Montepulciano.",
            "julie": "",
            "sommelier": "Maiolica is the unsung hero of Abruzzo, lending its juicy cherry, plum, and earthy spice to classic blends—think of it as the soulful sidekick that brings balance and rustic charm to your glass. Medium-bodied and delightfully approachable, it’s a perfect companion for hearty Italian fare and lively conversation.",
        },
        "color": "black",
        "regions": ["Abruzzo", "Calabria"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "medium_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Maiolina",
        "synonyms": ["Majolina"],
        "description": {
            "default": "Rare, productive, northern Italian red rescued from extinction in the 1980s.",
            "julie": "",
            "sommelier": "Maiolina, the black pearl of Lombardy, delivers a vibrant medley of red and black fruits laced with earthy herbs, all wrapped in a zesty, medium-bodied frame—an Italian classic rescued from obscurity and ready to charm your table with its rustic elegance.",
        },
        "color": "black",
        "regions": ["Lombardy", "Oltrepò Pavese", "Northern Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Malagousia",
        "synonyms": ["Malagouzia", "Malagoyzia", "Malaouzia", "Melaouzia"],
        "description": {
            "default": "Aromatic, high-quality Greek recently rescued from oblivion.",
            "julie": "",
            "sommelier": "Once nearly lost to history, Malagousia dazzles with a bouquet of white blossoms, juicy pear, and zesty lemon, all wrapped in a lively, high-acid frame. This Greek gem is a sommelier’s secret weapon—equally at home in a sun-drenched taverna or a Michelin-starred dining room.",
        },
        "color": "white",
        "regions": ["Greece", "Macedonia (Greece)", "Central Greece"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "herbal",
            "pear",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "oaked",
            "varietal",
            "premium",
            "reserve",
            "early_drinking",
        ],
    },
    {
        "name": "Malbo Gentile",
        "synonyms": ["Amabile di Genova", "Tubino", "Turbino"],
        "description": {
            "default": "Minor Italian red exclusive to Modena.",
            "julie": "",
            "sommelier": "Malbo Gentile is Modena’s secret weapon, delivering a lively medley of plum, cherry, and earthy spice wrapped in a zesty, medium-bodied frame—perfect for those who crave a taste of Emilia-Romagna’s rustic charm in their glass.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna", "Modena"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "medium_bodied",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Maligia",
        "synonyms": [
            "Malese",
            "Malige",
            "Maligia Omalise",
            "Malis",
            "Malisa",
            "Malise",
            "Malisia",
            "Malixa",
            "Malixe",
            "Malixia",
        ],
        "description": {
            "default": "Rare vine makes alcoholic white in Emilia-Romagna.",
            "julie": "",
            "sommelier": "Maligia is Emilia-Romagna’s hidden white gem, offering a lively medley of citrus, stone fruit, and delicate floral notes over a crisp mineral backbone. Light on its feet and perfect for early enjoyment, this rare varietal is a charming companion to any Italian table.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia",
        "synonyms": [
            "Malvasia",
            "Malmsey",
            "Malvagia",
            "Malvasier",
            "Malvasijie",
            "Malvelzevec",
            "Malvoisie",
        ],
        "description": {
            "default": "MALVASIA",
            "julie": "",
            "sommelier": "Malvasia is the chameleon of the wine world, seducing with a bouquet of stone fruit, honey, and exotic florals, whether in a zesty white, a decadent dessert, or a sparkling celebration. Grown from Italy to Greece, this grape delivers a Mediterranean holiday in every glass—sunshine, spice, and a whisper of ancient tradition.",
        },
        "color": "",
        "regions": ["Italy", "Portugal", "Spain", "Greece", "Croatia"],
        "flavor_profile": [
            "stone_fruit",
            "tropical_fruit",
            "floral",
            "honey",
            "nuts",
            "spice",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "rosé",
            "sparkling",
            "dessert",
            "fortified",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Bianca Di Candia",
        "synonyms": [
            "Malvasia Bianca",
            "Malvasia Candia",
            "Malvasia di Candia",
            "Malvasia Rossa",
        ],
        "description": {
            "default": "Most planted Malvasia, making neutral white. In decline but still quite widely planted and blended in central Italy.",
            "julie": "",
            "sommelier": "Malvasia Bianca Di Candia is the quiet workhorse of central Italy, offering a breezy bouquet of citrus, stone fruit, and delicate florals atop a mineral backbone—perfect for those who crave a crisp, easy-drinking white with a whisper of Italian sunshine. Though its star may be fading, this grape still brings a charming, refreshing lift to blends and tables alike.",
        },
        "color": "white",
        "regions": ["Central Italy", "Lazio", "Abruzzo", "Umbria"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "table_wine",
            "light_bodied",
            "unoaked",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Bianca Di Piemonte",
        "synonyms": [
            "Caccarella",
            "Greco",
            "Malvasia Bianca",
            "Malvasia Greca",
            "Moscatella",
            "Moscato Greco",
        ],
        "description": {
            "default": "California’s Malvasia. Aromatic, tough-skinned, originally Italian.",
            "julie": "",
            "sommelier": "Malvasia Bianca Di Piemonte is a vivacious white grape that dazzles with a bouquet of florals, sun-kissed stone fruits, and a drizzle of honey, all wrapped in a medium-bodied, refreshing sip. Perfect for those who crave a lively, aromatic wine that brings a taste of Italian sunshine to every glass.",
        },
        "color": "white",
        "regions": ["Piemonte", "California", "Italy"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "tropical_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Bianca Lunga",
        "synonyms": [
            "Krizol",
            "Malvasia Bianca",
            "Malvasia Bianca Siciliana",
            "Malvasia Bianca Toscana",
            "Malvasia del Chianti",
            "Malvasia di Arezzo",
            "Malvasia di Brolio",
            "Malvasia di San Nicandro",
            "Malvasia Lunga",
            "Malvasia Toscana",
            "Malvasia Verace",
            "Maraškin",
            "Maraština",
            "Mareština",
            "Menuetta",
            "Pavlos",
            "Prosecco Nostrano",
            "Racina du Monacu Bianca",
            "Rukatac",
            "Tundulillu Bianco",
            "Višana",
        ],
        "description": {
            "default": "Widely distributed neutral Tuscan variety used in blends for both dry wines and Vin Santo.",
            "julie": "",
            "sommelier": "Malvasia Bianca Lunga is Tuscany’s chameleon grape, lending its subtle stone fruit, floral, and honeyed charm to everything from crisp table wines to the luscious, age-worthy Vin Santo. With a gentle touch of minerality and a whisper of dried fruit, it’s the secret ingredient behind some of Italy’s most beloved blends.",
        },
        "color": "white",
        "regions": ["Tuscany", "Italy", "Sicily", "Dalmatia", "Croatia"],
        "flavor_profile": ["stone_fruit", "floral", "mineral", "dried_fruit", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "blend",
            "traditional",
            "table_wine",
            "age_worthy",
            "unoaked",
        ],
    },
    {
        "name": "Malvasia Branca De São Jorge",
        "synonyms": ["Malvasia Branca de S Jorge"],
        "description": {
            "default": "Portuguese variety of unknown parentage but high quality used in the production of Madeira.",
            "julie": "",
            "sommelier": "Malvasia Branca De São Jorge is the charismatic star of Madeira, delivering a full-bodied, high-octane white with a kaleidoscope of citrus, honey, and nutty flavors, all wrapped in a zesty, mineral embrace. This grape crafts wines that are both opulent and enduring—perfect for those who savor tradition with a twist of intrigue.",
        },
        "color": "white",
        "regions": ["Madeira", "Portugal"],
        "flavor_profile": [
            "citrus",
            "dried_fruit",
            "floral",
            "spice",
            "honey",
            "nuts",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "fortified",
            "full_bodied",
            "premium",
            "reserve",
            "age_worthy",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Malvasía De Lanzarote",
        "synonyms": [
            "Málaga",
            "Malvasía",
            "Malvasía Portuguesa",
            "Malvasía Volcánica",
            "Peregil",
            "Perejil",
            "Sebastián García",
        ],
        "description": {
            "default": "Recently identified variety found on the Islas Canarias, easily confused with other Malvasía Somethings.",
            "julie": "",
            "sommelier": "Malvasía De Lanzarote is a volcanic island gem, bursting with floral and tropical aromas, a zesty backbone, and a whisper of honeyed minerality—think of it as a sun-drenched breeze in a glass, perfect for adventurous palates seeking both freshness and depth.",
        },
        "color": "white",
        "regions": ["Canary Islands", "Lanzarote", "Spain"],
        "flavor_profile": [
            "floral",
            "tropical_fruit",
            "stone_fruit",
            "mineral",
            "earth",
            "honey",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "unoaked",
            "oaked",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Del Lazio",
        "synonyms": ["Malvasia col Puntino", "Malvasia Gentile", "Malvasia Puntinata"],
        "description": {
            "default": "Muscat of Hamburg sibling, grapey wines.",
            "julie": "",
            "sommelier": "Malvasia Del Lazio is the life of the Roman white wine party—light on its feet, brimming with floral perfume and juicy tropical fruit, and always ready to charm with its easygoing, early-drinking style. Think of it as a sun-drenched stroll through Lazio’s orchards, bottled for your pleasure.",
        },
        "color": "white",
        "regions": ["Lazio", "Italy"],
        "flavor_profile": ["floral", "tropical_fruit", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Di Lipari",
        "synonyms": [
            "Greco Bianco di Gerace",
            "Greco di Gerace",
            "Malmsey",
            "Malvagia",
            "Malvasia Cândida",
            "Malvasía de la Palma",
            "Malvasía de Sitges",
            "Malvasía de Tenerife",
            "Malvasia delle Lipari",
            "Malvasia di Cagliari",
            "Malvasia di Sardegna",
            "Malvasija Dubrovačka",
        ],
        "description": {
            "default": "Very widespread variety used for a wide array of generally sweet, often dried-grape, wines.",
            "julie": "",
            "sommelier": "Malvasia Di Lipari is the Mediterranean’s golden muse, weaving together honeyed apricots, sun-dried figs, and a bouquet of wildflowers into voluptuous, full-bodied wines that can age gracefully or seduce as decadent dessert sippers. This grape is a passport to island indulgence, where every glass is a sunlit celebration.",
        },
        "color": "white",
        "regions": [
            "Lipari (Sicily, Italy)",
            "Sardinia",
            "Calabria",
            "Canary Islands",
            "Croatia",
        ],
        "flavor_profile": ["dried_fruit", "honey", "floral", "stone_fruit", "nuts"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Malvasia Di Schierano",
        "synonyms": ["Malvasia a Grappolo Corto", "Malvasia di Castelnuovo Don Bosco"],
        "description": {
            "default": "Minor, dark-skinned Malvasia from Piemonte that produces lightly aromatic sweet reds.",
            "julie": "",
            "sommelier": "Malvasia Di Schierano is Piemonte’s charming secret: a light-bodied, sweet red that dances with red fruit, floral, and spicy notes, perfect for those who crave a playful, aromatic sip. This grape’s low tannins and gentle acidity make it an irresistible companion for early drinking and dessert pairings.",
        },
        "color": "black",
        "regions": ["Piemonte"],
        "flavor_profile": ["red_fruit", "floral", "dried_fruit", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["red", "dessert", "light_bodied", "varietal", "early_drinking"],
    },
    {
        "name": "Malvasia Fina",
        "synonyms": [
            "Arinto do Dão",
            "Assario",
            "Assario Branco",
            "Boal",
            "Boal Branco",
            "Boal Cachudo",
            "Boal da Graciosa",
            "Boal da Madeira",
            "Cachudo",
            "Galego",
            "Gual",
            "Terrantez do Pico",
            "Torrontés",
        ],
        "description": {
            "default": "High-quality Portuguese variety that goes by many names, notably Boal on Madeira, and produces many styles of wine.",
            "julie": "",
            "sommelier": "Malvasia Fina is Portugal’s chameleon grape, dazzling with zesty citrus, stone fruit, and a whisper of honey, whether in a crisp Dão white or a sumptuous Madeira. With high acidity and a bouquet of aliases, it’s a globe-trotting charmer that brings both freshness and depth to the glass.",
        },
        "color": "white",
        "regions": ["Portugal", "Dão", "Madeira", "Douro", "Bairrada", "Pico (Azores)"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral", "honey"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Nera Di Basilicata",
        "synonyms": ["Malvasia Nera"],
        "description": {
            "default": "The less common of the two dark-skinned Malvasias of southern Italy.",
            "julie": "",
            "sommelier": "Malvasia Nera Di Basilicata is the hidden gem of southern Italy, offering a charming dance of plum, cherry, and spice with a whisper of wild herbs—perfect for those who crave a medium-bodied red that’s as lively as a Basilicata festa. This grape brings both tradition and intrigue to the glass, making every sip a celebration of Italian terroir.",
        },
        "color": "black",
        "regions": ["Basilicata", "Southern Italy", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "herbal",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Nera Di Brindisi",
        "synonyms": [
            "Malvasia Negra",
            "Malvasia Nera",
            "Malvasia Nera di Bari",
            "Malvasia Nera di Bitonto",
            "Malvasia Nera di Lecce",
            "Malvasia Nera di Trani",
            "Malvasia Niura",
        ],
        "description": {
            "default": "The most common of the two dark-skinned Malvasias of southern Italy, commonly blended with Negroamaro, one of its parents.",
            "julie": "",
            "sommelier": "Malvasia Nera di Brindisi is the sultry star of southern Italy, delivering a full-bodied embrace of plum, cherry, and spice, with a whisper of earthiness. Often blended but never overshadowed, this grape brings a bold, sun-drenched character to every glass.",
        },
        "color": "black",
        "regions": [
            "Puglia",
            "Brindisi",
            "Lecce",
            "Bari",
            "Bitonto",
            "Trani",
            "Southern Italy",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "plum",
            "cherry",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "blend",
            "full_bodied",
            "traditional",
            "table_wine",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Malvasia Nera Lunga",
        "synonyms": ["Moscatella"],
        "description": {
            "default": "Rare, dark-skinned Malvasia exclusive to the province of Asti.",
            "julie": "",
            "sommelier": "Malvasia Nera Lunga is Asti’s secret treasure, weaving together seductive red and black fruits, a bouquet of wildflowers, and a whisper of spice and earth. Medium-bodied and beautifully balanced, it’s a rare Piedmontese gem that brings both tradition and intrigue to the glass.",
        },
        "color": "black",
        "regions": ["Asti", "Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Malvasia Preta",
        "synonyms": ["Moreto", "Mureto", "Pinheira Roxa"],
        "description": {
            "default": "Douro variety used for port and table wines.",
            "julie": "",
            "sommelier": "Malvasia Preta is Portugal’s dark horse, delivering a full-bodied, high-octane ride of black and red fruits, earthy spice, and dried fruit notes—perfect for both bold table wines and luscious ports. This grape’s medium acidity and tannins make it a versatile star in blends or solo, always promising a rich, age-worthy experience.",
        },
        "color": "black",
        "regions": ["Douro", "Portugal", "Alentejo"],
        "flavor_profile": ["black_fruit", "red_fruit", "spice", "earth", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "fortified",
            "blend",
            "table_wine",
            "traditional",
            "full_bodied",
            "age_worthy",
        ],
    },
    {
        "name": "Malvazija Istarska",
        "synonyms": [
            "Istrska Malvazija",
            "Malvasia del Carso",
            "Malvasia Friulana",
            "Malvasia Istriana",
            "Malvazija",
            "Malvazija Istarska Bijela",
            "Polijšakica Drnovk",
        ],
        "description": {
            "default": "The emphatic white wine grape of Croatia’s Istra (Istria) peninsula.",
            "julie": "",
            "sommelier": "Malvazija Istarska is the sun-kissed jewel of Istria, delivering zesty citrus and juicy stone fruit wrapped in a floral, mineral embrace—think of it as Adriatic summer in a glass, equally at home at a seaside picnic or a fine dining table.",
        },
        "color": "white",
        "regions": [
            "Croatia (Istria)",
            "Slovenia (Primorska, Istrska)",
            "Italy (Friuli-Venezia Giulia, Carso)",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "herbal",
            "mineral",
            "pear",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "blend",
            "unoaked",
            "oaked",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Malverina",
        "synonyms": ["BV-19-143"],
        "description": {
            "default": "Recent, late-ripening, disease-resistant Czech hybrid producing aromatic whites.",
            "julie": "",
            "sommelier": "Malverina dazzles with zesty citrus, delicate stone fruit, and a whisper of florals, all wrapped in a crisp, mineral-driven frame—think of it as the Czech Republic’s aromatic answer to a summer breeze in a glass.",
        },
        "color": "pink",
        "regions": ["Czech Republic", "Slovakia", "Austria", "Germany"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mammolo",
        "synonyms": [
            "Broumest",
            "Malvasia Montanaccio",
            "Mammolo Toscano",
            "Mammolone di Lucca",
            "Muntanaccia",
            "Schiorello",
            "Sciaccarello",
            "Sciaccarellu",
        ],
        "description": {
            "default": "Minor but historically significant perfumed central Italian Sangiovese blending partner, more important on the French island of Corse, as Sciaccarello.",
            "julie": "",
            "sommelier": "Mammolo is the unsung hero of Tuscan blends, lending a fragrant bouquet of violets, cherries, and peppery herbs to the glass—think of it as Sangiovese’s charming, aromatic sidekick. On Corsica, as Sciaccarello, it shines solo, delivering a lively, medium-bodied red that’s as breezy and inviting as a Mediterranean afternoon.",
        },
        "color": "black",
        "regions": ["Tuscany", "Corsica"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "herbal",
            "spice",
            "cherry",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mandilaria",
        "synonyms": [
            "Amorghiano",
            "Amorgiano",
            "Dombrena Mavri",
            "Doubraina Mavri",
            "Doumpraina Mavri",
            "Kontoura",
            "Koudouro",
            "Kountoura",
            "Koundoura",
            "Kountoura Mavri",
            "Mandelaria",
            "Mandilaria",
            "Mantilari",
            "Mantilaria",
            "Montoyra",
        ],
        "description": {
            "default": "Greek island variety producing intensely coloured, tannic wines that tend to lack body.",
            "julie": "",
            "sommelier": "Mandilaria is the Greek islands’ brooding artist: inky in color, brimming with robust tannins, yet surprisingly light on its feet, offering a tapestry of cherry, plum, and earthy herbs that evoke windswept Aegean hillsides. A true original, it’s a must-try for those who crave character and tradition in every glass.",
        },
        "color": "black",
        "regions": ["Greece", "Crete", "Rhodes", "Santorini", "Aegean Islands"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "earth",
            "herbal",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Mandón",
        "synonyms": ["Galmeta", "Galmete", "Mandó", "Valenciana Tinta"],
        "description": {
            "default": "Virtually extinct variety from Bierzo, north-west Spain.",
            "julie": "",
            "sommelier": "Mandón is a nearly forgotten Spanish gem, weaving together juicy cherry, plum, and raspberry with earthy, mineral undertones in a medium-bodied, easy-drinking red—like a time capsule from Bierzo’s ancient vineyards, ready to charm adventurous palates.",
        },
        "color": "black",
        "regions": ["Bierzo", "Castilla y León", "Valencia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mandrègue",
        "synonyms": ["Manrègue", "Néral"],
        "description": {
            "default": "Ancient and recently rescued Ariège variety.",
            "julie": "",
            "sommelier": "Mandrègue, the black pearl of Ariège, enchants with a tapestry of red and black fruits, earthy undertones, and a whisper of wild herbs, all wrapped in vibrant acidity and supple tannins. This ancient grape, once nearly forgotten, now returns to the table with a medium-bodied elegance that promises both immediate pleasure and graceful aging.",
        },
        "color": "black",
        "regions": ["Ariège", "Southwest France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Manseng Noir",
        "synonyms": [
            "Caíño do Freixo",
            "Ferrón",
            "Ferrol",
            "Mansenc Noir",
            "Noir du Pays",
        ],
        "description": {
            "default": "Rare but characterful red wine grape from south-west France, also found in north-west Spain.",
            "julie": "",
            "sommelier": "Manseng Noir is the enigmatic troubadour of the vineyard, serenading your palate with a vibrant chorus of cherry, plum, and raspberry, underscored by earthy spice and a zesty, mouthwatering acidity. Rarely seen but never forgotten, this Gascon gem brings a rustic charm and lively freshness to any table.",
        },
        "color": "black",
        "regions": ["South-West France", "Gascony", "Galicia", "North-West Spain"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "herbal",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Manto Negro",
        "synonyms": ["Mantonegro", "Mantuo Negro"],
        "description": {
            "default": "Principal dark-skinned variety on the Spanish island of Mallorca, producing pale, fruity, high-alcohol wines.",
            "julie": "",
            "sommelier": "Manto Negro is Mallorca’s charismatic native, delivering pale, high-octane reds bursting with cherry and raspberry, accented by a whisper of wild herbs and flowers. Light on its feet and low in tannin, this grape is your ticket to a sun-drenched Mediterranean table.",
        },
        "color": "black",
        "regions": ["Mallorca", "Balearic Islands", "Spain"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Mantonico Bianco",
        "synonyms": [
            "Mantonico Pizzutella",
            "Mantonacu Viru della Locride",
            "Mantonico Vero",
        ],
        "description": {
            "default": "Minor light-skinned Calabrian.",
            "julie": "",
            "sommelier": "Mantonico Bianco is Calabria’s hidden white gem, offering a zesty medley of citrus and stone fruit with a whisper of florals and minerals. Medium-bodied and effortlessly charming, it’s the perfect companion for sun-drenched afternoons and convivial tables.",
        },
        "color": "white",
        "regions": ["Calabria"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Manzoni Bianco",
        "synonyms": ["I M 6.0.13", "Incrocio Manzoni 6.0.13", "Manzoni"],
        "description": {
            "default": "Potentially high-quality northern Italian white cross which has inherited the positive qualities of its parents.",
            "julie": "",
            "sommelier": "Manzoni Bianco is Italy’s vivacious white cross, dazzling with zesty citrus, orchard fruit, and a mineral streak, all wrapped in a refreshing, high-acid embrace—perfect for both a sunlit aperitivo or a contemplative cellar gem.",
        },
        "color": "black",
        "regions": ["Veneto", "Trentino", "Friuli-Venezia Giulia", "Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Manzoni Moscato",
        "synonyms": ["Incrocio Manzoni 13.0.25"],
        "description": {
            "default": "One of the least planted of Manzoni’s crosses, this dark-skinned version is used to make sweet, sparkling rosé in Trentino.",
            "julie": "",
            "sommelier": "Manzoni Moscato is Trentino’s sparkling secret—a black-skinned grape that dazzles with a bouquet of red fruit, blossoms, and zesty citrus, all wrapped in a feather-light, effervescent embrace. Perfect for those who crave a sweet, playful rosé with a lively Italian spirit.",
        },
        "color": "black",
        "regions": ["Trentino", "Italy"],
        "flavor_profile": ["red_fruit", "floral", "stone_fruit", "citrus"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Manzoni Rosa",
        "synonyms": ["Incrocio Manzoni 1-50"],
        "description": {
            "default": "Very rare Veneto pink-berried cross.",
            "julie": "",
            "sommelier": "Manzoni Rosa is Veneto’s elusive pink gem, seducing the palate with a delicate dance of red berries, fragrant florals, and a whisper of spice. Light-bodied and lively, it’s the perfect companion for those seeking a rare, refreshing rosé adventure.",
        },
        "color": "pink",
        "regions": ["Veneto"],
        "flavor_profile": ["red_fruit", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mara",
        "synonyms": ["C41", "C41"],
        "description": {
            "default": "Recent, promising, early-ripening Swiss cross.",
            "julie": "",
            "sommelier": "Mara is Switzerland’s rising star, offering a lively medley of red and black fruits, herbal intrigue, and a mineral backbone—all wrapped in a zesty, medium-bodied frame. Perfect for those who crave a fresh, modern red with alpine flair and a thirst-quenching finish.",
        },
        "color": "black",
        "regions": ["Switzerland"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "modern",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Maratheftiko",
        "synonyms": [
            "Aloupostaphylo",
            "Bambakada",
            "Bambakina",
            "Maratheftico",
            "Marathefticon",
            "Marathophiko",
            "Mavrospourtiko",
            "Pambakada",
            "Pambakina",
            "Pampakia",
            "Vambakadha",
            "Vambakina",
            "Vamvakada",
        ],
        "description": {
            "default": "Rare, high-quality dark-skinned Cyprus variety that is starting to gain in popularity despite difficulties in the vineyard.",
            "julie": "",
            "sommelier": "Maratheftiko is Cyprus’s enigmatic black pearl, delivering a bold, full-bodied wine bursting with blackberries, plums, and a swirl of spice and herbs—perfect for those who crave both power and intrigue in their glass. This rare gem rewards the adventurous with its age-worthy structure and a taste of the island’s wild heart.",
        },
        "color": "black",
        "regions": ["Cyprus"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "herbal",
            "floral",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Maréchal Foch",
        "synonyms": ["Foch", "Kuhlmann 188-2", "Marechal Foch", "Marshal Fosh"],
        "description": {
            "default": "French hybrid that has been very successful in the colder climes of the US and Canada.",
            "julie": "",
            "sommelier": "Maréchal Foch is the plucky underdog of the wine world, bursting with juicy cherry and blackberry flavors, a dash of spice, and a whisper of earth and smoke—perfect for those who crave a lively, cool-climate red with a story as bold as its taste.",
        },
        "color": "black",
        "regions": [
            "Canada",
            "United States (Northeast, Midwest, Pacific Northwest)",
            "France (Loire, Alsace, though rare)",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "smoke",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "oaked",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Marmajuelo",
        "synonyms": ["Bermejuela", "Marmajuela", "Vermejuelo"],
        "description": {
            "default": "Rare variety from Spain’s Islas Canarias producing crisp, aromatic and potentially high-quality whites.",
            "julie": "",
            "sommelier": "Marmajuelo dazzles with a lively medley of citrus, tropical fruit, and floral aromas, all underpinned by a crisp, mineral backbone—think of it as the Canary Islands’ sun-kissed answer to a zesty seaside breeze in a glass.",
        },
        "color": "white",
        "regions": ["Islas Canarias", "Canary Islands", "Spain"],
        "flavor_profile": ["citrus", "tropical_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "premium",
            "reserve",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Marquette",
        "synonyms": ["MN 1211"],
        "description": {
            "default": "Promising, increasingly popular, cold-hardy complex American hybrid.",
            "julie": "",
            "sommelier": "Marquette is the northern star of American reds, offering a lively medley of cherry, plum, and blackberry with a spicy, earthy twist—think of it as Pinot Noir’s rugged, cold-climate cousin. With its zippy acidity and medium body, this grape crafts wines that are as at home by a snowy fireplace as they are at a summer barbecue.",
        },
        "color": "black",
        "regions": [
            "Minnesota",
            "Wisconsin",
            "Vermont",
            "New York",
            "Ontario",
            "Quebec",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "oaked",
            "unoaked",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Marsanne",
        "synonyms": [
            "Avilleran",
            "Ermitage",
            "Hermitage",
            "Grosse Roussette",
            "Marsanne Blanche",
            "Roussette de Saint-Péray",
        ],
        "description": {
            "default": "Flavourful and potentially very high-quality light-skinned Rhône variety with notable outposts in Australia and the US.",
            "julie": "",
            "sommelier": "Marsanne is the Rhône’s golden heavyweight, delivering lush waves of pear, peach, and honey, all wrapped in a creamy, nutty embrace. Whether oaked or unoaked, this grape crafts age-worthy whites that are as opulent as they are sophisticated—think Hermitage in a glass, with a sun-kissed wink from Down Under.",
        },
        "color": "white",
        "regions": [
            "Rhône Valley",
            "Hermitage",
            "Saint-Péray",
            "Victoria",
            "Nagambie Lakes",
            "California",
        ],
        "flavor_profile": [
            "stone_fruit",
            "pear",
            "peach",
            "honey",
            "nuts",
            "floral",
            "mineral",
            "butter",
        ],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "full_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "age_worthy",
            "premium",
            "reserve",
            "traditional",
            "modern",
            "table_wine",
        ],
    },
    {
        "name": "Marselan",
        "synonyms": ["INRA 1810-68"],
        "description": {
            "default": "One of the most successful relatively recent French crosses.",
            "julie": "",
            "sommelier": "Marselan is the lovechild of Cabernet Sauvignon and Grenache, offering a juicy medley of plum, cherry, and blackberry with a dash of spice and earth—think of it as the cosmopolitan newcomer shaking up wine lists from France to China. Medium-bodied and charmingly versatile, it’s equally at home in a blend or solo, ready to impress now or reward a little patience in the cellar.",
        },
        "color": "black",
        "regions": ["Languedoc", "Provence", "Spain", "China", "Brazil", "Uruguay"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "earth",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "modern",
            "table_wine",
            "medium_bodied",
            "full_bodied",
            "early_drinking",
            "age_worthy",
        ],
    },
    {
        "name": "Marufo",
        "synonyms": [
            "Brujidera",
            "Brujidero",
            "Brujigero",
            "Crujidera",
            "Crujideiro",
            "Marufa",
            "Moravia Dulce",
            "Mourisco",
            "Mourisco du Douro",
            "Mourisco Preto",
            "Mourisco Tinto",
            "Rucial",
            "Trujidera",
            "Vigorosa",
        ],
        "description": {
            "default": "Iberian variety that goes by many names and whose light wine is used mainly in blends.",
            "julie": "",
            "sommelier": "Marufo, the chameleon of Iberian vineyards, charms with delicate red fruit, floral, and herbal notes, lending a graceful lift to classic blends from Douro and Castilla-La Mancha. Often the unsung hero in the bottle, this light-bodied grape brings subtlety and freshness to traditional table wines.",
        },
        "color": "black",
        "regions": ["Douro", "Portugal", "Castilla-La Mancha", "Spain"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Marzemina Bianca",
        "synonyms": ["Berzemina di Breganze", "Sciampagna"],
        "description": {
            "default": "Rare Veneto variety usually found as an ingredient in sweet blended wines.",
            "julie": "",
            "sommelier": "Marzemina Bianca is Veneto’s hidden gem, weaving together luscious stone fruit, honeyed florals, and a whisper of dried fruit into a medium-bodied, gently sweet wine that’s as charming at the table as it is in a dessert glass. This rare grape is a delightful secret for those who seek a taste of Italy’s sweeter side.",
        },
        "color": "white",
        "regions": ["Veneto"],
        "flavor_profile": ["stone_fruit", "floral", "honey", "dried_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Marzemino",
        "synonyms": [
            "Balsamina",
            "Barzemin",
            "Berzamino",
            "Marzemina Cenerenta",
            "Marzemina Nera",
            "Marzemino Comune",
            "Marzemino Gentile",
        ],
        "description": {
            "default": "Makes fruity, perfumed reds often sweet or sparkling or both.",
            "julie": "",
            "sommelier": "Marzemino dazzles with its fragrant bouquet of red and black fruits, delicate florals, and a playful sparkle—think of it as the life of the Italian wine party, perfect for those who crave a light, easy-drinking red with a touch of sweetness and charm.",
        },
        "color": "black",
        "regions": ["Trentino", "Lombardy", "Veneto", "Northern Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mátrai Muskotály",
        "synonyms": ["Mátrai Muskatály"],
        "description": {
            "default": "Recently registered, grapey Hungarian cross.",
            "julie": "",
            "sommelier": "Mátrai Muskotály is Hungary’s aromatic charmer, bursting with floral perfume, juicy stone fruit, and a zesty citrus twist—think of it as a sunbeam in a glass, perfect for those who crave a light, refreshing sip with a touch of exotic flair.",
        },
        "color": "white",
        "regions": ["Hungary", "Mátra"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Maturana Blanca",
        "synonyms": ["Maturano", "Ribadavia"],
        "description": {
            "default": "Rare and recently rescued Rioja variety with real potential.",
            "julie": "",
            "sommelier": "Maturana Blanca is Rioja’s hidden white gem, dazzling with zesty citrus, juicy stone fruit, and a whisper of wildflowers, all wrapped in a crisp, mineral embrace. This rare grape’s high acidity and medium body make it a lively companion for early drinking or a star in premium white blends.",
        },
        "color": "white",
        "regions": ["Rioja", "Spain"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "medium_bodied",
            "varietal",
            "table_wine",
            "premium",
            "reserve",
            "early_drinking",
        ],
    },
    {
        "name": "Mauzac Blanc",
        "synonyms": [
            "Mauzac",
            "Blanc Laffite",
            "Gaillac",
            "Plant de Gaillac",
            "Gamet Blanc",
            "Mausat",
        ],
        "description": {
            "default": "Characterful, apple-skin-flavoured Gaillac and Limoux variety used in dry, sweet and sparkling wines.",
            "julie": "",
            "sommelier": "Mauzac Blanc is the zesty, apple-skin charmer of Southwest France, lending its crisp orchard fruit and floral notes to everything from lively sparkling wines to delicate dessert sippers. With high acidity and a light, refreshing body, it’s the perfect grape for those who love their wines bright, breezy, and bursting with character.",
        },
        "color": "white",
        "regions": ["Gaillac", "Limoux", "Southwest France"],
        "flavor_profile": ["apple", "pear", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Mauzac Noir",
        "synonyms": ["Mauzac Rouge"],
        "description": {
            "default": "Rare variety from south-west France unrelated to its white-wine namesake.",
            "julie": "",
            "sommelier": "Mauzac Noir is the mysterious twin of its white namesake, offering a charming medley of cherry, plum, and earthy spice in a medium-bodied, easy-drinking style. This Gaillac rarity is a delightful discovery for adventurous palates seeking a taste of southwest France’s vinous heritage.",
        },
        "color": "black",
        "regions": ["Gaillac", "South-West France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mavro",
        "synonyms": [
            "Cipro Nero",
            "Cyperntraube Blaue",
            "Cypro Nero",
            "Korithi Mavro",
            "Kritiko Mavro",
            "Kypreico Mavro",
            "Kypreiko Mavro",
            "Kypriotiko",
            "Mavro Kyproy",
            "Skuro Mavro",
            "Staphili-Mavro",
        ],
        "description": {
            "default": "The dominant Cyprus variety, makes undistinguished wine.",
            "julie": "",
            "sommelier": "Mavro, Cyprus’s workhorse black grape, delivers light-bodied reds with a medley of red and black fruits and a whisper of earth, perfect for easy sipping and local tradition. While it may not win awards for complexity, its charm lies in its honest, everyday drinkability and its deep roots in Cypriot culture.",
        },
        "color": "black",
        "regions": ["Cyprus"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "blend",
            "early_drinking",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Mavro Kalavritino",
        "synonyms": ["Kalavritino Mavro", "Mavro Kalavrytiko", "Psilomavro Kalavryton"],
        "description": {
            "default": "Very minor Greek variety from the northern Pelopónnisos (Peloponnese).",
            "julie": "",
            "sommelier": "Mavro Kalavritino is a hidden gem from Greece’s northern Peloponnese, offering a harmonious medley of red and black fruits, earthy undertones, and a whisper of herbs. With its medium body and balanced structure, this rare variety is perfect for those seeking a taste of Greek tradition in a glass.",
        },
        "color": "black",
        "regions": ["Northern Peloponnese", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mavro Messenikola",
        "synonyms": ["Mavro de Messenicolas", "Mavro Mesenikola", "Messenikola Mavro"],
        "description": {
            "default": "Variety exclusive to the Greek region of Thessalía that benefits greatly from its partnership with Syrah.",
            "julie": "",
            "sommelier": "Mavro Messenikola is Thessalía’s secret handshake—an alluring Greek red that dances between red and black fruits, spice, and earthy undertones, equally at home in a rustic blend or a modern table wine. Medium-bodied and charmingly balanced, it’s a grape that whispers of ancient hillsides and contemporary flair.",
        },
        "color": "black",
        "regions": ["Thessalía", "Greece"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
        ],
    },
    {
        "name": "Mavrodafni",
        "synonyms": [
            "Ahmar Mechtras",
            "Fraoula Kokkini",
            "Mavrodafnitsa",
            "Mavrodaphne",
            "Mavrodaphni",
            "Mavrodrami",
            "Thiniatiko",
        ],
        "description": {
            "default": "Deeply coloured, tannic yet aromatic Greek variety famous for producing ageworthy, sweet, fortified wines.",
            "julie": "",
            "sommelier": "Mavrodafni is Greece’s brooding, black-clad poet—pouring out luscious waves of black fruit, dried figs, and a swirl of chocolate and coffee, all wrapped in a velvety, full-bodied embrace. This grape crafts legendary, ageworthy fortified wines that are as decadent and aromatic as a midnight stroll through a spice market.",
        },
        "color": "black",
        "regions": ["Greece", "Peloponnese", "Patras", "Ionian Islands"],
        "flavor_profile": [
            "black_fruit",
            "dried_fruit",
            "spice",
            "chocolate",
            "coffee",
            "floral",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "dessert",
            "fortified",
            "full_bodied",
            "premium",
            "reserve",
            "age_worthy",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Mavroudi Arachovis",
        "synonyms": [
            "Arachovis",
            "Arachovitiko Mavro",
            "Arahovitikos",
            "Mavro Arachovitiko",
            "Mavroudi of Arachova",
        ],
        "description": {
            "default": "Rare variety from central Greece.",
            "julie": "",
            "sommelier": "Mavroudi Arachovis is a hidden gem from central Greece, weaving together juicy cherries, plums, and a whisper of spice over an earthy backbone. This medium-bodied rarity charms with its balanced structure and a rustic elegance that transports you straight to the sun-drenched hills of Arachova.",
        },
        "color": "black",
        "regions": ["Central Greece", "Arachova", "Boeotia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Mavrud",
        "synonyms": [
            "Kachivela",
            "Mavro",
            "Mavroud",
            "Mavroudi",
            "Mavroudi Boulgarias",
            "Tsiganka",
        ],
        "description": {
            "default": "Indigenous Bulgarian variety producing sturdy reds that can improve with age.",
            "julie": "",
            "sommelier": "Mavrud is Bulgaria’s brooding black pearl, delivering full-bodied reds brimming with dark fruit, spice, and earthy intrigue—perfect for those who like their wines as bold and storied as a Balkan legend. With high acidity and tannins, these age-worthy bottles promise a thrilling journey from the first sip to the last.",
        },
        "color": "black",
        "regions": ["Bulgaria", "Thracian Valley"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "oak",
            "dried_fruit",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Mayolet",
        "synonyms": ["Maïolet", "Majolet"],
        "description": {
            "default": "Extremely rare Aosta variety gradually recovering from near-extinction.",
            "julie": "",
            "sommelier": "Mayolet is the Aosta Valley’s elusive treasure, offering a lively dance of cherry, raspberry, and wild herbs in a feather-light frame—think of it as the alpine breeze in a glass, perfect for those who crave rare finds and vibrant, early-drinking reds.",
        },
        "color": "black",
        "regions": ["Aosta Valley", "Valle d'Aosta", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Mazuelo",
        "synonyms": [
            "Bovale di Spagna",
            "Bovale Grande",
            "Bovale Mannu",
            "Carignan Noir",
            "Carignane",
            "Carignano",
            "Cariñano",
            "Crujillón",
            "Mazuela",
            "Mollard",
            "Samsó  and many more",
        ],
        "description": {
            "default": "Black variety from north-east Spain high in tannins and acidity that can make fine wine from old vines but has in its time, as Carignan, blighted Languedoc-Roussillon.",
            "julie": "Mazuelo, also known as Carignan, has been a controversial grape variety for its ability to give super high yields and many regions, such as Languedoc, have uprooted many of its vineyards. However, the grape has recently been cherised by new producers that have saved old bush vines and a trend of carbonic maceration Carignan is born in the last few years. The best examples are supple and fruit forward with a touch of umami.",
            "sommelier": "Once the workhorse of southern France, Mazuelo (a.k.a. Carignan) is now the darling of adventurous winemakers, yielding bold, full-bodied reds bursting with plum, blackberry, and a savory, earthy edge. High in both tannin and acidity, this grape transforms with age, offering a thrilling ride from rustic power to supple, umami-laced elegance.",
        },
        "color": "black",
        "regions": [
            "Spain",
            "France",
            "Languedoc-Roussillon",
            "Catalonia",
            "Rioja",
            "Sardinia",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "herbal",
            "mineral",
            "plum",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "full_bodied",
            "age_worthy",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mazzese",
        "synonyms": [
            "Massase",
            "Mazzese di Parlascio",
            "Orzese",
            "Rinaldesca",
            "Uva Mazzese",
            "Vajano",
        ],
        "description": {
            "default": "Very minor variety used as a minor component in blends.",
            "julie": "",
            "sommelier": "Mazzese is Tuscany’s secret handshake—a rare black grape lending whispers of red and black fruit and a rustic earthiness to traditional blends. Medium in every measure, it’s the quiet backbone of Central Italian table wines, adding depth and a touch of intrigue to every glass.",
        },
        "color": "black",
        "regions": ["Tuscany", "Central Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional"],
    },
    {
        "name": "Mècle De Bourgoin",
        "synonyms": ["Mescle de Bourgoin"],
        "description": {
            "default": "Neglected eastern French variety now receiving some attention.",
            "julie": "",
            "sommelier": "Mècle De Bourgoin is the comeback kid of eastern France, offering a lively medley of red and black fruits dusted with earthy spice—think of it as the soulful storyteller of Savoie and Jura, perfect for those who love their reds fresh, charming, and a little bit off the beaten path.",
        },
        "color": "black",
        "regions": ["Savoie", "Jura", "Bugey", "Eastern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Medna",
        "synonyms": ["Buboj", "Bumba", "Medna Bijala", "Medva", "Rizavac", "Zložder"],
        "description": {
            "default": "Rare Dalmatian variety, often with a honey aroma.",
            "julie": "",
            "sommelier": "Medna is Dalmatia’s hidden gem, a white grape that enchants with honeyed aromas, delicate florals, and juicy stone fruit, all wrapped in a medium-bodied, easy-drinking style. Sip this rare Croatian beauty for a taste of sun-drenched Adriatic tradition in every glass.",
        },
        "color": "white",
        "regions": ["Dalmatia", "Croatia"],
        "flavor_profile": ["honey", "floral", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Megrabuir",
        "synonyms": ["Meghrabuyr", "Megrabouir", "Megrabuyr"],
        "description": {
            "default": "Productive and cold-hardy Armenian hybrid used mainly to produce pink dessert wines.",
            "julie": "",
            "sommelier": "Megrabuir is Armenia’s cold-defying charmer, delivering a luscious medley of red and black fruits, dried fruit, and a whisper of honey in every sip. Perfect for pink dessert wines, this grape enchants with floral elegance and a medium-bodied, easy-drinking style that’s as inviting as a springtime orchard.",
        },
        "color": "black",
        "regions": ["Armenia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "dried_fruit",
            "floral",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "dessert",
            "rosé",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Melara",
        "synonyms": ["Merlara"],
        "description": {
            "default": "Rare, used as a component in Vin Santo di Vigoleno.",
            "julie": "",
            "sommelier": "Melara is Emilia-Romagna’s secret ingredient, lending Vin Santo di Vigoleno its luscious notes of honeyed dried fruit, toasted nuts, and a whisper of oak. With high acidity and a full, opulent body, this rare grape crafts dessert wines that are as decadent as they are enduring.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Italy"],
        "flavor_profile": ["dried_fruit", "honey", "nuts", "oak"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "oaked",
            "blend",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Melnik 82",
        "synonyms": ["Melnik"],
        "description": {
            "default": "Result of crossing the variety commonly called Melnik, Shiroka Melnishka, with a variety from south-west France.",
            "julie": "",
            "sommelier": "Melnik 82 is Bulgaria’s bold ambassador, seducing with a tapestry of cherry, plum, and spice, underpinned by earthy tobacco and a sultry whisper of oak and vanilla. Full-bodied and robust, this age-worthy red is a must-try for those seeking a taste of the Struma Valley’s unique terroir.",
        },
        "color": "black",
        "regions": ["Bulgaria", "Struma River Valley"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "plum",
            "spice",
            "earth",
            "tobacco",
            "oak",
            "vanilla",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "blend",
            "age_worthy",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Melon",
        "synonyms": [
            "Gamay Blanc",
            "Latran",
            "Melon de Bourgogne",
            "Plant de Bourgogne",
            "Petit Bourgogne",
        ],
        "description": {
            "default": "Old Burgundian variety well suited to the western, Atlantic-dominated mouth of the Loire.",
            "julie": "",
            "sommelier": "Melon is the zippy, sea-breeze-kissed star of Muscadet, delivering a bracing splash of lemon, green apple, and wet stone in every glass. This Loire Valley classic is the ultimate oyster companion—crisp, light, and as invigorating as a morning by the Atlantic.",
        },
        "color": "white",
        "regions": ["Loire Valley", "Muscadet", "Pays Nantais", "France", "Burgundy"],
        "flavor_profile": ["citrus", "mineral", "lemon", "apple"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
            "premium",
            "age_worthy",
        ],
    },
    {
        "name": "Mencía",
        "synonyms": ["Jaen", "Jaen du Dão", "Loureiro Tinto", "Mencía Pajaral"],
        "description": {
            "default": "Increasingly appreciated aromatic variety found in both Spain and Portugal.",
            "julie": "",
            "sommelier": "Mencía is the rising star of northwestern Spain and Portugal, seducing palates with its lively red fruit, floral perfume, and a whisper of earth and spice. With its high acidity and medium body, this grape crafts wines that are as charmingly fresh as they are elegantly complex—perfect for both a casual sip and a contemplative swirl.",
        },
        "color": "black",
        "regions": ["Bierzo", "Ribeira Sacra", "Valdeorras", "Dão"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "mineral",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Menoir",
        "synonyms": ["Kékmedoc", "Medoc Noir", "Menoire"],
        "description": {
            "default": "Minor, recently renamed Hungarian variety making reds with Muscat aromas.",
            "julie": "",
            "sommelier": "Menoir is Hungary’s aromatic secret, delivering light to medium-bodied reds that dance with red fruit, floral, and spicy notes, all kissed by a surprising Muscat perfume. Perfect for early sipping, this grape charms with its easy elegance and a whisper of the exotic.",
        },
        "color": "black",
        "regions": ["Hungary"],
        "flavor_profile": ["red_fruit", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Menu Pineau",
        "synonyms": [
            "Arbois Blanc",
            "Herbois",
            "Menu",
            "Menu Pinot",
            "Orbois",
            "Petit Pineau",
            "Verdet",
        ],
        "description": {
            "default": "Well-connected and once important Blois speciality with a handful of advocates.",
            "julie": "",
            "sommelier": "Menu Pineau is the Loire Valley’s zesty secret, offering a crisp medley of apple, pear, and citrus with a mineral backbone and floral lift—think of it as a refreshing spring breeze in a glass, perfect for those who love their whites light, bright, and full of character.",
        },
        "color": "white",
        "regions": ["Loire Valley", "France", "Blois"],
        "flavor_profile": ["apple", "pear", "mineral", "floral", "citrus"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mérille",
        "synonyms": [
            "Bordelais Noir",
            "Bourdalès",
            "Bouchalès",
            "Grand Vesparo",
            "Vesparo à Queue Verte",
            "Périgord",
        ],
        "description": {
            "default": "Virtually extinct variety found occasionally in Fronton blends in south-west France.",
            "julie": "",
            "sommelier": "Mérille is a rare gem from southwest France, lending its charming medley of red and black fruits, earthy undertones, and herbal whispers to traditional Fronton blends. Medium in every measure, this nearly forgotten grape crafts easy-drinking reds that are as intriguing as they are approachable.",
        },
        "color": "black",
        "regions": ["Southwest France", "Fronton"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Merlot",
        "synonyms": [
            "Bigney",
            "Crabutet",
            "Langon",
            "Médoc Noir",
            "Merlau",
            "Merlot Noir",
            "Picard",
            "Sémillon Rouge",
            "Vitraille",
        ],
        "description": {
            "default": "Fleshy, widely planted, relatively early ripening member of the Bordeaux family.",
            "julie": "",
            "sommelier": "Merlot is the velvet lounge singer of the wine world—seductive, smooth, and always ready to please, with plush notes of plum, cherry, and a sultry hint of chocolate and coffee. Whether in a Bordeaux blend or solo, it charms with supple tannins and a dark, inviting robe, making every sip a cozy embrace.",
        },
        "color": "black",
        "regions": ["Bordeaux", "California", "Tuscany", "Chile", "Australia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "chocolate",
            "coffee",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "full_bodied",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Merseguera",
        "synonyms": ["Exquitsagos", "Esquitxagos", "Verdosilla"],
        "description": {
            "default": "Uninspiring variety widely planted in eastern central Spain.",
            "julie": "",
            "sommelier": "Merseguera is the quiet workhorse of eastern Spain, delivering light-bodied, citrusy, and mineral-driven whites perfect for sunny afternoons and casual sipping. While it may not steal the spotlight, its easygoing charm and refreshing simplicity make it a delightful companion for everyday enjoyment.",
        },
        "color": "white",
        "regions": ["Valencia", "Alicante", "Utiel-Requena", "Castilla-La Mancha"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Merzling",
        "synonyms": [],
        "description": {
            "default": "Very minor, disease-resistant German hybrid.",
            "julie": "",
            "sommelier": "Merzling is the unsung hero of German vineyards, offering a zesty medley of citrus and apple with a whisper of wildflowers and herbs, all wrapped in a crisp, mineral embrace. Perfect for those who crave a light, refreshing white wine that’s as easygoing as a summer afternoon.",
        },
        "color": "white",
        "regions": ["Germany", "Switzerland"],
        "flavor_profile": ["citrus", "apple", "floral", "herbal", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Meslier Saint-François",
        "synonyms": [
            "Blanc Ramé",
            "Gaillac",
            "Gros Meslier",
            "Meslier",
            "Purgarie",
            "Pelegarie",
        ],
        "description": {
            "default": "Almost extinct, historic French variety.",
            "julie": "",
            "sommelier": "Meslier Saint-François is a rare French gem, offering a zesty burst of citrus and apple with a delicate floral lift and a crisp mineral finish. Light-bodied and vivacious, this nearly forgotten grape is a refreshing ode to France’s vinous heritage—perfect for those who love their whites bright and lively.",
        },
        "color": "white",
        "regions": ["Southwest France", "Gaillac", "Loire Valley"],
        "flavor_profile": ["citrus", "floral", "apple", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mézes Fehér",
        "synonyms": [
            "Alföldi Fehér",
            "Aranyka",
            "Aranyka Sarga",
            "Bieli Medenac",
            "Budai Fehér",
            "Goldtraube",
            "Honigler",
            "Honigler Weisser",
            "Honigler Bianco",
            "Honigtraube",
            "Margit",
            "Mézédes",
            "Mézes",
            "Sarféjer",
            "Sárga Margit",
            "Sárga Szőlő",
            "Zsige",
        ],
        "description": {
            "default": "Ancient but almost extinct Hungarian variety making rich, aromatic whites.",
            "julie": "",
            "sommelier": "Mézes Fehér is Hungary’s golden relic, weaving together lush aromas of wildflowers, honey, and ripe orchard fruits into a full-bodied, enchanting white wine. Nearly lost to time, this grape is a rare treat for those seeking a taste of Hungary’s vinous heritage.",
        },
        "color": "white",
        "regions": ["Hungary", "Great Hungarian Plain (Alföld)", "Budapest region"],
        "flavor_profile": ["floral", "honey", "stone_fruit", "pear", "peach"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "full_bodied",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Mézy",
        "synonyms": ["Mési", "Meslier Noir", "Petit Mesi"],
        "description": {
            "default": "Franche-Comté variety known only as a minor ingredient in a blend.",
            "julie": "",
            "sommelier": "Mézy is the unsung hero of Franche-Comté blends, lending whispers of red and black fruit with a rustic earthiness, all wrapped in a light, easy-drinking frame—perfect for those who appreciate the quiet artistry of traditional French table wines.",
        },
        "color": "black",
        "regions": ["Franche-Comté"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Milgranet",
        "synonyms": ["Périgord Noir", "Petite Mérille"],
        "description": {
            "default": "Recently snatched from virtual extinction by researchers in southern France.",
            "julie": "",
            "sommelier": "Once nearly lost to history, Milgranet is a black grape from Southwest France that charms with a tapestry of red and black fruits, earthy undertones, and a whisper of spice—think of it as the comeback kid of Cahors, ready to delight both traditionalists and adventurous palates alike.",
        },
        "color": "black",
        "regions": ["Southwest France", "Périgord", "Cahors"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Millot-Foch",
        "synonyms": ["VB 85-1"],
        "description": {
            "default": "Rare, disease-resistant Swiss hybrid producing deeply coloured, fruity wines.",
            "julie": "",
            "sommelier": "Millot-Foch is a rare Swiss hybrid that dazzles with inky hues and a medley of red and black fruits, plum, and earthy undertones—think of it as the adventurous cousin in the wine world, perfect for those seeking a medium-bodied, easy-drinking red with a story to tell.",
        },
        "color": "black",
        "regions": ["Switzerland", "France (Alsace, Jura)", "Germany", "Austria"],
        "flavor_profile": ["red_fruit", "black_fruit", "plum", "cherry", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Minella Bianca",
        "synonyms": ["Eppula", "Minedda Bianca", "Minnella"],
        "description": {
            "default": "Minor Sicilian white rarely made as a varietal.",
            "julie": "",
            "sommelier": "Minella Bianca is Sicily’s hidden white gem, bursting with zesty citrus, delicate stone fruit, and a whisper of wildflowers over a crisp, mineral backbone. Light-bodied and lively, it’s a refreshing sip of Sicilian sunshine, perfect for those who crave something off the beaten path.",
        },
        "color": "white",
        "regions": ["Sicily"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Minutolo",
        "synonyms": [
            "Fiano Aromatico",
            "Fiano della Valle d’Itria",
            "Fiano di Puglia",
            "Fiano di Salento",
            "Fiano Minutolo",
            "Fiore Mendillo",
            "Greco Aromatico",
            "Minutola",
            "Moscatellina",
        ],
        "description": {
            "default": "Opulently grapey Puglian once known as Fiano Aromatico.",
            "julie": "",
            "sommelier": "Minutolo is Puglia’s aromatic white gem, bursting with floral, stone fruit, and honeyed notes that dance on the palate like a Mediterranean breeze. This lively, unoaked varietal is a modern charmer—perfect for those who crave a taste of southern Italian sunshine in every glass.",
        },
        "color": "white",
        "regions": ["Puglia", "Valle d'Itria", "Salento"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "tropical_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "unoaked",
            "early_drinking",
            "table_wine",
            "modern",
        ],
    },
    {
        "name": "Misket Cherven",
        "synonyms": [
            "Karlovski Misket",
            "Kimionka",
            "Misket Siv",
            "Misket Starozagorski",
            "Misket Sungurlarski",
            "Sinja Temenuga",
            "Songurlarski Misket",
            "Yuzhnobalgarski Cherven Misket",
        ],
        "description": {
            "default": "Old, pink-skinned Bulgarian variety used to make dry, scented whites.",
            "julie": "",
            "sommelier": "Misket Cherven is Bulgaria’s aromatic gem, delivering a lively, floral bouquet with zesty citrus and stone fruit, all wrapped in a crisp, mineral-driven frame—perfect for those who crave a refreshing, unoaked white with a sense of place and history.",
        },
        "color": "pink",
        "regions": ["Bulgaria"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Misket Varnenski",
        "synonyms": ["Muscat de Varna", "Muscat Varnenski"],
        "description": {
            "default": "Minor Bulgarian cross from Varna.",
            "julie": "",
            "sommelier": "Misket Varnenski is Bulgaria’s aromatic charmer, wafting floral and citrus notes with a whisper of honey, all wrapped in a light, breezy body. Perfect for sun-drenched afternoons, this varietal is a delightful introduction to the lesser-known treasures of Varna.",
        },
        "color": "white",
        "regions": ["Varna", "Bulgaria"],
        "flavor_profile": ["floral", "citrus", "stone_fruit", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Misket Vrachanski",
        "synonyms": [
            "Mirizlivka",
            "Misket Vratchanski",
            "Tvarda Vrazhda Misket",
            "Wrat Chanskii Musket",
            "Wratchanski Misket",
        ],
        "description": {
            "default": "Minor Bulgarian cross planted mostly in the far east and west. The most aromatic of the Bulgarian Miskets.",
            "julie": "",
            "sommelier": "Misket Vrachanski is Bulgaria’s aromatic white gem, bursting with floral, citrus, and stone fruit notes atop a zesty backbone—think of it as a fragrant spring breeze in a glass, perfect for lively gatherings and sunlit afternoons.",
        },
        "color": "white",
        "regions": ["Bulgaria"],
        "flavor_profile": ["floral", "citrus", "stone_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mladinka",
        "synonyms": ["Mladenka"],
        "description": {
            "default": "Very rare variety from the Croatian coast generally used in blends.",
            "julie": "",
            "sommelier": "Mladinka is a coastal Croatian gem, offering a breezy bouquet of citrus and stone fruit with a whisper of seaside minerality—perfect for those who crave a light, refreshing white that captures the spirit of the Adriatic in every sip.",
        },
        "color": "white",
        "regions": ["Croatian coast", "Dalmatia", "Istria"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Molette",
        "synonyms": ["Molette Blanche", "Molette de Seyssel"],
        "description": {
            "default": "Minor and rather neutral vine used mainly for sparkling wines in Savoie, eastern France.",
            "julie": "",
            "sommelier": "Molette is the unsung hero of Savoie’s sparkling wines, bringing zesty citrus, crisp apple, and a refreshing mineral streak to the glass. With its high acidity and feather-light body, this grape is all about lively, early-drinking charm—think of it as the alpine breeze in your flute.",
        },
        "color": "white",
        "regions": ["Savoie", "Eastern France"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "blend",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Molinara",
        "synonyms": ["Brepon", "Mulinara", "Uva del Mulino", "Uva Salà"],
        "description": {
            "default": "Now plays distinctly third fiddle to Corvina Veronese and Rondinella in wines such as Valpolicella.",
            "julie": "Molinara is planted mainly in the region of Veneto in Italy. The wines are generally pale in colour, high in acidity and prone to oxidation. They play a minor role, blending with Rondinella and Corvina to producer the wines of Valpolicella, Amarone and Bardolino.",
            "sommelier": "Molinara is the unsung hero of Veneto blends, lending a zippy freshness and delicate red fruit charm to Valpolicella and Bardolino. With its high acidity and whisper-light body, it keeps the party lively while letting its bolder companions take center stage.",
        },
        "color": "black",
        "regions": ["Veneto", "Italy"],
        "flavor_profile": ["red_fruit", "mineral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Mollard",
        "synonyms": ["Molard", "Petit Mollard", "Tallardier"],
        "description": {
            "default": "Very minor variety making fresh, light reds in south-east France.",
            "julie": "",
            "sommelier": "Mollard is a hidden gem from the French Alps, offering a zippy, light-bodied red bursting with cherry and raspberry, kissed by alpine florals and a stony minerality—perfect for those who crave freshness and a taste of mountain terroir. This is the wine to pour when you want to impress with something rare, vibrant, and utterly drinkable.",
        },
        "color": "black",
        "regions": ["Hautes-Alpes", "Savoie", "South-East France"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Monarch",
        "synonyms": ["Freiburg 487-88"],
        "description": {
            "default": "Dark, powerful recent German hybrid giving fruity and full-bodied wines.",
            "julie": "",
            "sommelier": "Monarch is a bold, modern German hybrid that bursts with juicy blackberries and plums, delivering a full-bodied, fruit-forward red with a suave, contemporary edge—perfect for those who crave power and poise in their glass.",
        },
        "color": "black",
        "regions": ["Germany", "Austria", "Switzerland"],
        "flavor_profile": ["black_fruit", "plum", "blackberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "modern",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Monastrell",
        "synonyms": [
            "Alcayata",
            "Balzac Noir",
            "Catalan",
            "Espagnen",
            "Espar",
            "Garrut",
            "Gayata",
            "Mataro",
            "Mataró",
            "Mourvede",
            "Mourvedon",
            "Mourvèdre",
            "Negria",
            "Ros",
        ],
        "description": {
            "default": "High-quality, heat-loving dark-skinned variety most valued for its heady, structured contribution to blends.",
            "julie": 'The name monastrell derives from the Latin "mosnateriellu" meaning "monastery" and suggesting that the grape was first cultivated by monks. Kown as Mourvèdre in France and Mataro in Australia and USA, this grape thrives in Mediterrean climate. Spain has a lot of vineyard acreage dedicated to the variety and most of the plantings are located in centre and South East Spain. In France, Bandol is the most famous wine region for the production of Mourvèdre where it produces structures wines that needs time to soften and reveal their full aromatic potential. ',
            "sommelier": "Monastrell, the Mediterranean’s brooding black beauty, delivers a bold symphony of blackberry, spice, and earthy leather, wrapped in a full-bodied, tannic embrace. Revered by monks and modern winemakers alike, this grape crafts age-worthy reds that demand patience—and richly reward it.",
        },
        "color": "black",
        "regions": [
            "Spain",
            "France",
            "Bandol",
            "Jumilla",
            "Yecla",
            "Alicante",
            "Australia",
            "USA",
        ],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "earth",
            "mineral",
            "plum",
            "blackberry",
            "pepper",
            "leather",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "oaked",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Monbadon",
        "synonyms": ["Burger", "Frontignan des Charentes"],
        "description": {
            "default": "Productive, dull western French variety that once thrived in California’s Central Valley.",
            "julie": "",
            "sommelier": "Monbadon, also known as Burger, is the unsung workhorse of the vineyard, delivering crisp apple and pear flavors with a zesty citrus twist—perfect for those who prefer their whites light, lively, and ready to drink without pretense. Once a California staple, this grape is a charming reminder that sometimes the simplest pleasures are the most refreshing.",
        },
        "color": "white",
        "regions": ["California Central Valley", "Western France", "Charentes"],
        "flavor_profile": ["apple", "pear", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
            "blend",
        ],
    },
    {
        "name": "Mondeuse Blanche",
        "synonyms": ["Dongine", "Jongin", "Savouette"],
        "description": {
            "default": "Savoie variety more famous as Syrah’s parent than for its wines.",
            "julie": "",
            "sommelier": "Mondeuse Blanche is the unsung matriarch of Syrah, offering a zesty, high-acid white with lively citrus, apple, and pear flavors, all wrapped in a feather-light, mineral embrace—perfect for those who love their wines as crisp as an Alpine morning.",
        },
        "color": "white",
        "regions": ["Savoie", "France"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Mondeuse Noire",
        "synonyms": [
            "Gros Rouge",
            "Grosse Syrah",
            "Maldoux",
            "Persagne",
            "Petite Persaigne",
            "Plant Maldoux",
        ],
        "description": {
            "default": "Aromatic Savoie variety regaining recognition for its well-structured reds.",
            "julie": "",
            "sommelier": "Mondeuse Noire is the Savoie region’s secret weapon, delivering a vibrant medley of black and blue fruits, peppery spice, and earthy minerality, all wrapped in a lively, medium-bodied frame. With its high acidity and age-worthy structure, this grape is a sommelier’s delight—think Syrah’s wilder Alpine cousin ready to charm your palate.",
        },
        "color": "black",
        "regions": ["Savoie", "Bugey", "Isère", "Northern Italy (Piedmont)"],
        "flavor_profile": [
            "black_fruit",
            "blue_fruit",
            "spice",
            "earth",
            "pepper",
            "plum",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Monemvassia",
        "synonyms": [
            "Artemissi",
            "Klossaria",
            "Monemvasia",
            "Monemvassitiko",
            "Monovassia",
        ],
        "description": {
            "default": "Powerful, historic variety widely planted on Páros but receiving renewed attention in the southern Pelopónnisos (Peloponnese).",
            "julie": "",
            "sommelier": "Monemvassia is Greece’s golden secret, weaving together juicy stone fruit, zesty citrus, and a whisper of wildflowers over a mineral backbone—think of it as a sun-drenched stroll through a Peloponnesian orchard, equally at home in a crisp white or a luscious dessert wine.",
        },
        "color": "white",
        "regions": ["Páros", "Peloponnese", "Greece"],
        "flavor_profile": [
            "stone_fruit",
            "pear",
            "peach",
            "citrus",
            "lemon",
            "floral",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Monerac",
        "synonyms": ["Monérac"],
        "description": {
            "default": "Fairly recent Montpellier cross yet to win favour.",
            "julie": "",
            "sommelier": "Monerac is a modern Montpellier creation, offering a juicy medley of plum and cherry wrapped in a balanced, medium-bodied frame—perfect for those seeking a fresh French red before the rest of the world catches on. This under-the-radar grape is a delightful companion for casual sipping or lively blends.",
        },
        "color": "black",
        "regions": ["France", "Languedoc", "Montpellier"],
        "flavor_profile": ["red_fruit", "black_fruit", "plum", "cherry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "varietal", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Monica Nera",
        "synonyms": [
            "Manzesu",
            "Monaca",
            "Monica di Sardegna",
            "Niedda de Ispagna",
            "Niedda Mora",
            "Nieddera Manna",
            "Pascale Sardu",
        ],
        "description": {
            "default": "Generally undistinguished dark-skinned variety widely planted on the Italian island of Sardegna and made in a variety of styles.",
            "julie": "",
            "sommelier": "Monica Nera is Sardegna’s understated charmer, offering a medley of red and black fruits dusted with earthy notes—perfect for those seeking a friendly, medium-bodied red that’s as easygoing as an Italian island afternoon.",
        },
        "color": "black",
        "regions": ["Sardegna", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "table_wine",
            "varietal",
            "blend",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Montepulciano",
        "synonyms": [
            "Africano",
            "Angolano",
            "Montepulciano Cordisco",
            "Montepulciano Spargolo",
            "Morellone",
            "Sangiovese Cordisco",
            "Uva Abruzzese",
        ],
        "description": {
            "default": "Productive, deeply coloured, firmly structured and widely planted.",
            "julie": "",
            "sommelier": "Montepulciano is the Italian stallion of red grapes—muscular, deeply hued, and brimming with flavors of black plum, blackberry, and earthy spice. Whether enjoyed young or aged, its bold tannins and rustic charm make it a perfect companion for hearty Italian fare and lively conversation.",
        },
        "color": "black",
        "regions": ["Abruzzo", "Marche", "Molise", "Puglia", "Lazio", "Umbria"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "herbal",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Montils",
        "synonyms": ["Chalosse"],
        "description": {
            "default": "Charentais variety used in the production of cognac.",
            "julie": "",
            "sommelier": "Montils is the unsung hero of the Charente, delivering a zesty, high-acid white with whispers of orchard fruit and spring blossoms—think of it as the secret ingredient behind the elegance of fine cognac, or a refreshing solo act in a glass.",
        },
        "color": "white",
        "regions": ["Charente", "Cognac", "Southwest France"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "early_drinking",
            "varietal",
            "traditional",
        ],
    },
    {
        "name": "Montonico Bianco",
        "synonyms": [
            "Chiapparù",
            "Ciapparone",
            "Greco Bianco del Pollino",
            "Greco del Pollino",
            "Mantonico Bianco Italico",
            "Montonico",
            "Pagadebit",
            "Racciapaluta",
            "Uva della Scala",
            "Uva Regno",
        ],
        "description": {
            "default": "Minor southern Italian white used mainly in blends.",
            "julie": "",
            "sommelier": "Montonico Bianco is southern Italy’s zesty secret, bursting with citrus and stone fruit, kissed by floral and mineral notes, and always ready to refresh with its high acidity and light, breezy body. Perfect for those who crave a crisp, unoaked white that dances on the palate and vanishes before you know it.",
        },
        "color": "white",
        "regions": ["Calabria", "Basilicata", "Southern Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "blend",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Montù",
        "synonyms": ["Bianchetto Faentino", "Bianchino", "Montuni", "Montuno"],
        "description": {
            "default": "Very late ripening Bolognese variety.",
            "julie": "",
            "sommelier": "Montù is Emilia-Romagna’s zesty secret, delivering a lively dance of stone fruit, apple, and pear with a crisp, mineral finish—perfect for those who crave a refreshing, unoaked white that sings of Italian tradition and early harvest celebrations.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Bologna"],
        "flavor_profile": ["stone_fruit", "floral", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Monvedro",
        "synonyms": ["Bastardo", "Monvedro Dão"],
        "description": {
            "default": "Minor, late-budding Portuguese variety causing confusion by its synonyms.",
            "julie": "",
            "sommelier": "Monvedro is Portugal’s enigmatic white grape, dazzling with zesty citrus, delicate florals, and a mineral streak, all wrapped in a feather-light frame. Often hiding behind aliases, it’s a lively, high-acid charmer that brings a refreshing twist to any table.",
        },
        "color": "white",
        "regions": ["Portugal", "Dão"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Moore’S Diamond",
        "synonyms": ["Diamond"],
        "description": {
            "default": "Minor American hybrid similar to, but less successful than, Concord and Niagara.",
            "julie": "",
            "sommelier": "Moore’s Diamond is a delightful American hybrid that charms with floral and tropical fruit aromas, a whisper of herbs, and a crisp, light-bodied palate—perfect for those seeking a refreshing, unoaked white from the Northeast. While it may live in the shadow of its more famous cousins, this grape offers a playful, easy-drinking experience that’s as bright as a summer afternoon in New York.",
        },
        "color": "white",
        "regions": ["New York", "Northeastern United States"],
        "flavor_profile": ["floral", "tropical_fruit", "stone_fruit", "herbal"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Moradella",
        "synonyms": ["Croà", "Moranzana", "Vermiglio"],
        "description": {
            "default": "Prized by growers but not recognized by officialdom.",
            "julie": "",
            "sommelier": "Moradella is the unsung hero of northern Italy, delivering a symphony of cherry, plum, and earthy spice in every glass—think of it as the grape that locals love and bureaucrats forgot. Medium-bodied and effortlessly balanced, it’s the perfect companion for a hearty table and lively conversation.",
        },
        "color": "black",
        "regions": ["Lombardy", "Emilia-Romagna", "Piedmont"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "varietal",
        ],
    },
    {
        "name": "Moravia Agria",
        "synonyms": [],
        "description": {
            "default": "Hitherto neglected Spanish variety contributing to at least one distinctively fresh, tannic red in the heat of Manchuela.",
            "julie": "",
            "sommelier": "Moravia Agria is Spain’s hidden gem, delivering a lively, medium-bodied red bursting with tangy red fruit, earthy spice, and a firm tannic grip—perfect for those who crave freshness even in the heat of La Mancha. This grape’s spirited acidity and rustic charm make it a delightful companion for traditional Spanish fare.",
        },
        "color": "black",
        "regions": ["Manchuela", "Castilla-La Mancha", "Spain"],
        "flavor_profile": ["red_fruit", "spice", "earth"],
        "acidity": "High",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Moreto Do Alentejo",
        "synonyms": ["Morito"],
        "description": {
            "default": "Popular but generally light and lacklustre red in southern Portugal more commonly but ambiguously known as Moreto.",
            "julie": "",
            "sommelier": "Moreto Do Alentejo is the laid-back charmer of southern Portugal, offering light-bodied reds brimming with fresh red fruit and a gentle, easygoing character. Perfect for casual sipping and early enjoyment, this grape is the friendly companion at any Alentejo table.",
        },
        "color": "black",
        "regions": ["Alentejo", "Southern Portugal"],
        "flavor_profile": ["red_fruit"],
        "acidity": "Low",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["red", "light_bodied", "table_wine", "blend", "early_drinking"],
    },
    {
        "name": "Morio-Muskat",
        "synonyms": ["Geilweilerhof I-28-30"],
        "description": {
            "default": "Intensely grapey but rather flabby German cross that has had its day.",
            "julie": "",
            "sommelier": "Morio-Muskat is the flamboyant, floral showstopper of German whites, bursting with tropical and stone fruit aromas but with a soft, easygoing palate thanks to its low acidity. Once a darling of the table wine scene, it now offers a nostalgic sip of aromatic exuberance for those seeking something a little different.",
        },
        "color": "white",
        "regions": ["Germany", "Pfalz", "Rheinhessen"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
        ],
    },
    {
        "name": "Moristel",
        "synonyms": ["Concejón", "Juan Ibáñez", "Moristell"],
        "description": {
            "default": "Makes light but distinctive reds in Somontano, north-east Spain.",
            "julie": "",
            "sommelier": "Moristel is the charming underdog of Somontano, delivering lively, light-bodied reds brimming with cherry and raspberry, accented by a whisper of herbs and earth—perfect for those who crave a fresh, unoaked Spanish table wine with character.",
        },
        "color": "black",
        "regions": ["Somontano", "Aragon", "Spain"],
        "flavor_profile": ["red_fruit", "herbal", "earth", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mornen Noir",
        "synonyms": ["Chasselas Noir", "Montruchon", "Mornant", "Mornerain Noir"],
        "description": {
            "default": "Chasselas relative that might just be rescued from extinction.",
            "julie": "",
            "sommelier": "Mornen Noir is a charming, nearly forgotten French grape that delivers a whisper of red fruit, floral perfume, and stony minerality in a feather-light, low-alcohol frame—perfect for those who crave a taste of vinous history with a refreshing twist.",
        },
        "color": "black",
        "regions": ["Savoie", "Loire", "Jura", "Switzerland"],
        "flavor_profile": ["red_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Morone",
        "synonyms": [
            "Morone Farinaccio",
            "Mostaiola del Lapi",
            "Uva Moro",
            "Uva Morone Nera",
        ],
        "description": {
            "default": "Very minor Tuscan occasionally used to add colour to blends.",
            "julie": "",
            "sommelier": "Morone is Tuscany’s secretive black beauty, lending brooding color and a tapestry of plum, blackberry, and earthy notes to traditional blends. With its high tannins and rustic charm, this grape is a rare treat for those who crave a taste of the Tuscan countryside’s untold stories.",
        },
        "color": "black",
        "regions": ["Tuscany"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "earth"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "traditional", "early_drinking"],
    },
    {
        "name": "Morrastel Bouschet",
        "synonyms": ["Garnacho", "Morrastel Bouschet à Gros Grains"],
        "description": {
            "default": "Nineteenth-century southern French cross now making tiny amounts of deep red wine.",
            "julie": "",
            "sommelier": "Morrastel Bouschet is a southern French rarity, yielding deeply colored, full-bodied reds brimming with black fruit, plum, and earthy spice—think of it as the soulful troubadour of Languedoc, serenading your palate with tradition and intrigue.",
        },
        "color": "black",
        "regions": ["Languedoc", "Provence", "Southern France"],
        "flavor_profile": ["black_fruit", "plum", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "traditional",
            "varietal",
            "blend",
            "table_wine",
        ],
    },
    {
        "name": "Moscatello Selvatico",
        "synonyms": ["Moscato di Barletta"],
        "description": {
            "default": "Rare, aromatic white for sweet wines usually from southern Italy.",
            "julie": "",
            "sommelier": "Moscatello Selvatico is a hidden gem from Puglia, weaving together heady floral aromas, zesty citrus, and luscious stone fruit with a drizzle of honey. This rare grape dazzles in sweet wines, delivering a vibrant, mouthwatering finish that’s as enchanting as a southern Italian sunset.",
        },
        "color": "white",
        "regions": ["Puglia", "Southern Italy"],
        "flavor_profile": ["floral", "citrus", "stone_fruit", "honey"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["white", "dessert", "varietal", "traditional"],
    },
    {
        "name": "Moscato Di Scanzo",
        "synonyms": ["Moscatino di Scanzo"],
        "description": {
            "default": "Rare, aromatic red exclusive to Bergamo used to make sweet passito wines and basking in the creation of its new DOCG.",
            "julie": "",
            "sommelier": "Moscato Di Scanzo is Bergamo’s decadent secret: a full-bodied, high-octane dessert wine bursting with red and black fruits, honeyed florals, and a seductive hint of chocolate, all wrapped in a rare DOCG pedigree. This grape crafts a hedonistic, age-worthy elixir that’s as enchanting as the Lombardy hills it calls home.",
        },
        "color": "black",
        "regions": ["Bergamo", "Lombardy", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "dried_fruit",
            "floral",
            "spice",
            "honey",
            "chocolate",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "dessert",
            "full_bodied",
            "varietal",
            "premium",
            "reserve",
            "age_worthy",
            "traditional",
        ],
    },
    {
        "name": "Moscato Di Terracina",
        "synonyms": ["Moscato di Maccarese"],
        "description": {
            "default": "Recently rescued aromatic white from central Italy making a wide range of styles.",
            "julie": "",
            "sommelier": "Moscato Di Terracina is central Italy’s aromatic treasure, bursting with a bouquet of wildflowers, sun-kissed citrus, and a drizzle of honey—think of it as a Mediterranean holiday in a glass, equally at home as a zesty sparkler or a luscious dessert wine. Its lively personality and easy charm make it the perfect companion for early evening aperitivi or a sweet finish to any meal.",
        },
        "color": "white",
        "regions": ["Lazio", "Central Italy", "Terracina"],
        "flavor_profile": [
            "floral",
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Moscato Giallo",
        "synonyms": [
            "Fior d’Arancio",
            "Goldenmuskateller",
            "Goldmuskateller",
            "Moscatel",
            "Moscato dalla Siria",
            "Moscato Sirio",
            "Muscat du Pays",
            "Muscat Vert",
            "Muscatedda",
        ],
        "description": {
            "default": "Golden-berried Muscat variety of northern Italy making mainly passito-style wines.",
            "julie": "",
            "sommelier": "Moscato Giallo is northern Italy’s golden gem, bursting with heady floral aromas, luscious stone fruit, and a honeyed citrus zing—think of it as a sunbeam in a glass, perfect for those who crave both freshness and decadence in their dessert wines.",
        },
        "color": "white",
        "regions": [
            "Trentino-Alto Adige",
            "Veneto",
            "Friuli-Venezia Giulia",
            "Northern Italy",
        ],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "honey", "dried_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
            "unoaked",
        ],
    },
    {
        "name": "Moscato Rosa Del Trentino",
        "synonyms": ["Muškat Ruža Porečki", "Rosenmuskateller"],
        "description": {
            "default": "A minor, red-skinned northern Italian that produces rose-scented sweet wines.",
            "julie": "",
            "sommelier": "Moscato Rosa Del Trentino is a beguiling northern Italian gem, weaving together fragrant rose petals, juicy raspberries, and a whisper of spice into a light-bodied, sweet elixir. Perfect for dessert or a romantic evening, this rare varietal enchants with every sip.",
        },
        "color": "red",
        "regions": ["Trentino", "Alto Adige", "Northern Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "dried_fruit",
            "raspberry",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "light_bodied",
            "varietal",
            "traditional",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Moschofilero",
        "synonyms": ["Fileri", "Fileri Mantineias", "Moschophilero"],
        "description": {
            "default": "Aromatic, high-acid Greek variety that has seen a surge in popularity and plantings in the last twenty years.",
            "julie": "",
            "sommelier": "Moschofilero is Greece’s vivacious answer to summer in a glass—think zesty lemon, delicate peach, and a bouquet of wildflowers, all wrapped in a crisp, high-acid frame. This pink-skinned charmer from Mantinia is the ultimate refresher, perfect for those who crave aromatic intrigue and a lively palate.",
        },
        "color": "pink",
        "regions": ["Mantinia", "Peloponnese", "Greece"],
        "flavor_profile": ["citrus", "floral", "stone_fruit", "lemon", "peach"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "rosé",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Moschomavro",
        "synonyms": ["Moschato Mavro", "Moschogaltso", "Xinogaltso"],
        "description": {
            "default": "Minor Greek variety with good potential for rosés.",
            "julie": "",
            "sommelier": "Moschomavro is Greece’s secret weapon for lively, aromatic rosés—think a basket of raspberries and cherries sprinkled with wildflowers, all wrapped in a zippy, refreshing finish. With its high acidity and light body, this grape is a sommelier’s delight for those seeking a vibrant, early-drinking wine that dances on the palate.",
        },
        "color": "black",
        "regions": ["Greece", "Macedonia (Greece)", "Thessaly"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "raspberry", "cherry"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Mostosa",
        "synonyms": ["Empibotte Bianco", "Pagadebit", "Pagadebito"],
        "description": {
            "default": "Minor white variety found on the Adriatic coast, occasionally made as a varietal wine under its synonym Pagadebit.",
            "julie": "",
            "sommelier": "Mostosa, known locally as Pagadebit, is the Adriatic coast’s zesty secret—delivering a lively burst of citrus, apple, and pear with a mineral edge and mouthwatering acidity. This light-bodied, unoaked charmer is the perfect companion for sun-drenched afternoons and classic Italian fare.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Adriatic coast of Italy", "Romagna"],
        "flavor_profile": ["citrus", "floral", "apple", "pear", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Mouyssaguès",
        "synonyms": ["Négret", "Plant du Pauvre"],
        "description": {
            "default": "Virtually extinct variety once producing astringent reds in southern central France.",
            "julie": "",
            "sommelier": "Once the secret of southern central France, Mouyssaguès is a nearly forgotten black grape that delivers a bold handshake of tannin and earthy spice, wrapped in rustic red and black fruit. Sip it for a taste of history—this is the wine your great-great-grandparents might have called their daily bread.",
        },
        "color": "black",
        "regions": ["Southern Central France", "Tarn", "Lot", "Aveyron"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice", "vegetal"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "traditional",
            "varietal",
            "table_wine",
            "light_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Mskhali",
        "synonyms": [
            "Ararati",
            "At Uzyum",
            "Mashali",
            "Messchaly",
            "Mishali",
            "Msali",
            "Mschali",
            "Musrali",
            "Spitak Khagog",
        ],
        "description": {
            "default": "Armenia’s most planted variety, used mainly for brandy.",
            "julie": "",
            "sommelier": "Mskhali, Armenia’s pride and joy, dazzles with zesty apple and pear flavors, delicate floral aromas, and a mineral backbone—think of it as a mountain spring in a glass, perfect for those who crave a crisp, lively sip with a touch of tradition.",
        },
        "color": "white",
        "regions": ["Armenia"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "light_bodied", "unoaked", "varietal", "traditional"],
    },
    {
        "name": "Mtsvane Kakhuri",
        "synonyms": [
            "Dedali Mtsvane",
            "Mamali Mtsvane",
            "Mcknara",
            "Mtsvane",
            "Mtsvane Kachuri",
            "Mtsvani",
            "Mtzvané",
        ],
        "description": {
            "default": "The more widespread of the Mtsvanes makes high-quality Georgian whites in both traditional and European styles.",
            "julie": "",
            "sommelier": "Mtsvane Kakhuri is Georgia’s vivacious white grape, bursting with the aromas of orchard fruits, wildflowers, and a whisper of herbs, all wrapped in a zesty, mineral-driven frame. Whether crafted in ancient qvevri or sleek stainless steel, it delivers a lively, food-friendly wine that dances between tradition and modernity.",
        },
        "color": "white",
        "regions": ["Georgia", "Kakheti"],
        "flavor_profile": [
            "stone_fruit",
            "floral",
            "herbal",
            "mineral",
            "pear",
            "peach",
            "apple",
            "nuts",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Mujuretuli",
        "synonyms": ["Keduretuli"],
        "description": {
            "default": "Georgian variety used to produce dry and semi-sweet wines.",
            "julie": "",
            "sommelier": "Mujuretuli is Georgia’s charismatic black grape, weaving together vibrant cherry and plum flavors with earthy, mineral undertones for a wine that’s as versatile as it is intriguing—equally at home in a rustic table wine or a premium, age-worthy blend. This medium-bodied gem is a true testament to Georgian winemaking tradition, offering a delicious balance of fruit and structure.",
        },
        "color": "black",
        "regions": ["Georgia", "Kakheti", "Racha-Lechkhumi"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "earth",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Müller-Thurgau",
        "synonyms": [
            "Findling",
            "Riesling-Silvaner",
            "Riesling × Silvaner",
            "Rivaner",
            "Rizlingszilváni",
            "Rizvanec",
        ],
        "description": {
            "default": "Prolific German invader of the world’s vineyards producing soft, semi-aromatic whites in over-abundance.",
            "julie": "",
            "sommelier": "Müller-Thurgau is the charming workhorse of the wine world, offering a bouquet of gentle florals and orchard fruits in a glass that's as easygoing as a Sunday afternoon. With its soft, harmonious style and refreshing simplicity, this grape is your go-to companion for light fare and carefree sipping.",
        },
        "color": "white",
        "regions": [
            "Germany",
            "Austria",
            "Switzerland",
            "Hungary",
            "Czech Republic",
            "Slovakia",
            "Italy (Alto Adige, Trentino)",
            "Luxembourg",
            "England",
        ],
        "flavor_profile": ["floral", "herbal", "apple", "pear", "stone_fruit"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muscadelle",
        "synonyms": [
            "Bouillenc",
            "Guinlhan Musqué",
            "Muscat Fou",
            "Sauvignon Vert",
            "Tokay",
        ],
        "description": {
            "default": "Significant in Monbazillac, less so in sweet white bordeaux and very important in north-east Victoria.",
            "julie": "",
            "sommelier": "Muscadelle dazzles with a heady bouquet of stone fruit, honey, and wildflowers, delivering a full-bodied, high-acid experience that shines in both luscious dessert wines and opulent blends—think of it as the secret star behind Monbazillac’s golden elixirs and Victoria’s fortified treasures.",
        },
        "color": "white",
        "regions": ["Monbazillac", "Bordeaux", "Victoria"],
        "flavor_profile": ["stone_fruit", "floral", "honey", "dried_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "blend",
            "varietal",
            "full_bodied",
            "age_worthy",
            "premium",
            "reserve",
            "traditional",
        ],
    },
    {
        "name": "Muscat",
        "synonyms": [
            "Meski",
            "Misket",
            "Moscatel",
            "Moscato",
            "Moscatello",
            "Moschato",
            "Moschoudia",
            "Muskat",
            "Muskateller",
            "Muskatoly",
            "Muskotály",
            "Moscato d'Asti",
            "Muscat of Spina",
        ],
        "description": {
            "default": "MUSCAT",
            "julie": "",
            "sommelier": "Muscat is the globe-trotting charmer of the wine world, bursting with heady floral aromas and a fruit basket of flavors from peach to tropical fruit, all wrapped in a light, refreshing body. Whether sparkling, sweet, or dry, Muscat’s irresistible perfume and easy-drinking style make it the life of any party.",
        },
        "color": "",
        "regions": [
            "Italy",
            "France",
            "Spain",
            "Greece",
            "Hungary",
            "Australia",
            "South Africa",
        ],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "citrus",
            "tropical_fruit",
            "honey",
            "peach",
            "lemon",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Bailey A",
        "synonyms": ["Muscat Bailey"],
        "description": {
            "default": "Japanese hybrid with many an American gene, good disease resistance but producing candy-flavoured wines.",
            "julie": "",
            "sommelier": "Muscat Bailey A is Japan’s playful answer to red wine, bursting with red fruit, floral, and tropical notes that dance on the palate like a festival of flavors. With its candy-like charm and light, easy-drinking style, this grape is a delightful companion for early-drinking and casual occasions.",
        },
        "color": "black",
        "regions": ["Japan"],
        "flavor_profile": ["red_fruit", "floral", "tropical_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Muscat Blanc À Petits Grains",
        "synonyms": [
            "Muscat Blanc a Petits Grains",
            "Muscat d'Alsace",
            "Muscat Blanc",
            "Moscato Bianco",
            "Muscat Canelli",
            "Muscat de Frontignan",
            "Muscat de Lunel",
            "Moscatel de Grano Menudo",
            "Moscatel Rosé",
            "Sárgamuskotály",
        ],
        "description": {
            "default": "The classic Muscat, the small-berried one that is widely dispersed around the world.",
            "julie": "Muscat Blanc à Petits Grains is a very old white grape variety from the Mediterranéen area. The grape is used to produce dry, sweet and fortified wines. It is characterised by its perfumed aromatic reminescent or rose petals, orange blossom and spices. Its main areas of cultivation are the Roussillon and the island of Corsica in France,  the Piemonte region of Italy, the Douro Valley in Portugal, some parts of Spain, Greece and South Africa. ",
            "sommelier": "Muscat Blanc à Petits Grains is the aromatic showstopper of the wine world, bursting with heady scents of rose petals, orange blossom, and a dash of spice—think of it as springtime in a glass. Whether sparkling, sweet, or dry, this grape delivers a lively, floral experience that dances across the palate and leaves you dreaming of Mediterranean sunsets.",
        },
        "color": "white",
        "regions": [
            "Roussillon",
            "Corsica",
            "Piemonte",
            "Douro Valley",
            "Spain",
            "Greece",
            "South Africa",
        ],
        "flavor_profile": ["floral", "citrus", "spice", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "fortified",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Bleu",
        "synonyms": ["Garnier 83/2", "Muscat Bleu Garnier"],
        "description": {
            "default": "Minor Swiss hybrid valued particularly by organic growers for its Muscat-like aroma and disease resistance but more commonly grown for the table.",
            "julie": "",
            "sommelier": "Muscat Bleu is the Swiss charmer of the vineyard, seducing with a bouquet of wildflowers and juicy red fruits, all wrapped in a light, breezy body—perfect for those who crave a playful, aromatic sip without the fuss. Its disease resistance and organic appeal make it a favorite for both growers and wine lovers seeking something delightfully different.",
        },
        "color": "black",
        "regions": ["Switzerland"],
        "flavor_profile": ["floral", "red_fruit", "stone_fruit"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Fleur D’Oranger",
        "synonyms": [
            "Chasselas Fleur d’Orange",
            "Cranford Muscat",
            "Madarski Muskat",
            "Mirisavka",
            "Moscatel Gordo Peludo",
            "Moscato Fior d’Arancio",
            "Muscat Croquant",
            "Muscat de Jésus",
            "Muscat d’Espagne",
            "Muscat of Hungary",
            "Muscat Queen Victoria",
            "Muscat Regnier",
            "Muscat Vengerskii",
            "Orange Muscat",
            "Orange Muskat",
            "Primavis Muscat",
            "Raisin Vanille",
            "Vanilia Muskotaly",
            "Weisse Vanillentraube",
        ],
        "description": {
            "default": "Highly aromatic, orange-flavoured variety of unknown geographical origin but definitely related to Muscat Blanc à Petits Grains.",
            "julie": "",
            "sommelier": "Muscat Fleur D’Oranger is a vivacious white grape that bursts from the glass with heady orange blossom, zesty citrus, and a whisper of vanilla, making every sip feel like a stroll through a Mediterranean orchard in bloom. Light-bodied and irresistibly aromatic, it’s the life of the party in sparkling, dessert, or early-drinking styles—pure sunshine in a glass!",
        },
        "color": "white",
        "regions": ["France", "Italy", "Spain", "Hungary", "Australia", "California"],
        "flavor_profile": [
            "citrus",
            "floral",
            "stone_fruit",
            "lemon",
            "vanilla",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "varietal",
            "unoaked",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Of Alexandria",
        "synonyms": [
            "Acherfields Early Muscat",
            "Albillo di Toro",
            "Aleksandrijski Muskat",
            "Alexandriai Muskotály",
            "Angliko",
            "Apostoliatiko",
            "Argelino",
            "Daroczy Musko",
            "Gordo",
            "Gordo Zibibo",
            "Hanepoot",
            "Iskendiriye Misketi",
            "Lexia",
            "Malaga",
            "Moscatel",
            "Moscatel Bianco",
            "Moscatel Blanco",
            "Moscatel de Alejandría",
            "Moscatel de Chipiona",
            "Moscatel de Grano Gardo",
            "Moscatel de Málaga",
            "Moscatel de Setúbal",
            "Moscatel Gordo",
            "Moscatel Graúdo",
            "Moscatel Romano",
            "Moscatellone",
            "Moscato d’Alessandria",
            "Moscato di Pantelleria",
            "Moscato Francese",
            "Moschato Alexandrias",
            "Moschato Limnou",
            "Muscat à Gros Grains",
            "Muscat Bowood",
            "Muscat d’Alexandrie",
            "Muscat de Berkain",
            "Muscat de Fandouk",
            "Muscat de Raf-Raf",
            "Muscat de Rome",
            "Muscat El Adda",
            "Muscat Gordo Blanco",
            "Muscat Grec",
            "Muscat Romain",
            "Salamanca",
            "Seralamanna",
            "Tămaîioasă de Alexandria",
            "White Hanepoot",
            "Zibbibo",
            "Zibibo",
            "Zibibbo",
        ],
        "description": {
            "default": "Light-skinned Mediterranean variety generally considered inferior to Muscat Blanc à Petits Grains, used mostly to produce very sweet wines.",
            "julie": "",
            "sommelier": "Muscat of Alexandria is the globe-trotting, sun-loving grape that perfumes your glass with heady florals, ripe stone fruits, and a drizzle of honey—perfect for luscious dessert wines or a sweet Mediterranean escape in every sip.",
        },
        "color": "white",
        "regions": [
            "Spain",
            "Italy",
            "Greece",
            "Portugal",
            "France",
            "Australia",
            "South Africa",
            "Chile",
        ],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "tropical_fruit",
            "dried_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Of Hamburg",
        "synonyms": [
            "Black Muscat",
            "Black Muscat of Alexandria",
            "Hamburg Musqué",
            "Hamburgii Muskotály",
            "Malvasia Nera",
            "Moscatel de Hamburgo",
            "Moscatel Prato",
            "Moscato d’Amburgo",
            "Moscato Nero",
            "Moscato Nero d’Acqui",
            "Moschato Amvourgou",
            "Moschato Tyrnavou",
            "Muscat Albertdient’s",
            "Muscat de Hamburg",
            "Muscat Hamburg",
            "Muscat-Hamburgh",
            "Muscat Hamburg Crni",
            "Oeillade Musquée",
            "Snow’s Muscat Hamburgh",
            "Tămîioasă Hamburg",
            "Tămîioasă Neagra",
            "Venn’s Seedling",
            "Venn’s Seedling Black Muscat",
            "Zibibbo Nero",
        ],
        "description": {
            "default": "Genetic conundrum associated most readily with table grapes grown intermittently in England and widely elsewhere.",
            "julie": "",
            "sommelier": "Muscat of Hamburg is the globe-trotting charmer of the grape world, seducing with perfumed bouquets of red and black fruits, a whisper of spice, and a light, juicy palate—perfect for those who like their wines as lively and approachable as a summer garden party. Whether in a glass or on the table, it’s a grape that always brings a touch of intrigue and delight.",
        },
        "color": "black",
        "regions": ["England", "Italy", "Greece", "Hungary", "Romania", "Spain"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "spice"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Muscat Ottonel",
        "synonyms": [
            "Muscadel Ottonel",
            "Muskat Otonel",
            "Muskat Ottonel",
            "Muskotály",
            "Ottonel Muskotály",
            "Tămîioasă Ottonel",
        ],
        "description": {
            "default": "Soft, grapey French variety used for both dry and sweet wines, particularly in Alsace and Eastern Europe.",
            "julie": "",
            "sommelier": "Muscat Ottonel is the charming raconteur of the wine world, seducing with fragrant floral and honeyed aromas, and a juicy medley of stone and tropical fruits. Light on its feet and delightfully easy to drink, it brings a touch of French elegance and Eastern European flair to any glass.",
        },
        "color": "white",
        "regions": ["Alsace", "Hungary", "Romania", "Austria", "Bulgaria", "Moldova"],
        "flavor_profile": ["floral", "stone_fruit", "tropical_fruit", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muscat Swenson",
        "synonyms": ["ES 8-2-43", "Muscat de Swenson"],
        "description": {
            "default": "Muscat-like hardy American hybrid.",
            "julie": "",
            "sommelier": "Muscat Swenson dazzles with a bouquet of spring flowers, ripe peaches, and a drizzle of honey, all wrapped in a light, refreshing frame. This Midwestern charmer is your go-to for a lively, unoaked white that sings of summer picnics and easygoing afternoons.",
        },
        "color": "white",
        "regions": [
            "Midwestern United States",
            "Northeastern United States",
            "Minnesota",
            "Wisconsin",
            "New York",
        ],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Muškát Moravský",
        "synonyms": ["Mopr", "Moravian Muscat", "Moravsky Muskat"],
        "description": {
            "default": "The Czech Republic’s very own Muscat. Widely planted.",
            "julie": "",
            "sommelier": "Muškát Moravský is Moravia’s aromatic charmer, bursting with floral, citrus, and honeyed stone fruit notes that dance across a light, refreshing palate. This unoaked white is the Czech Republic’s answer to Muscat—perfect for easy sipping and lively gatherings.",
        },
        "color": "white",
        "regions": ["Czech Republic", "Moravia"],
        "flavor_profile": [
            "floral",
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Mustoasă De Măderat",
        "synonyms": ["Lampor", "Mustafer", "Mustosfehér"],
        "description": {
            "default": "Productive, high-acid variety from western Romania making light, fresh, locally popular whites.",
            "julie": "",
            "sommelier": "Mustoasă De Măderat is Romania’s zesty secret, bursting with citrus, apple, and floral notes, and a racy acidity that makes every sip as lively as a Carpathian spring. This light-bodied, unoaked white is the perfect companion for a sunlit afternoon or a convivial table of friends.",
        },
        "color": "white",
        "regions": ["Romania", "Western Romania"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Narince",
        "synonyms": ["Güzül Üzüm", "Kazova", "Narance", "Nerince"],
        "description": {
            "default": "Turkey’s best-known white wine variety, also grown for the table.",
            "julie": "",
            "sommelier": "Narince, Turkey’s golden child of white grapes, dazzles with zesty citrus, juicy stone fruit, and a whisper of Anatolian wildflowers, all wrapped in a vibrant, high-acid embrace. Whether sipped young or aged, it’s a sun-kissed taste of Turkish terroir that dances on the palate and pairs beautifully with mezze.",
        },
        "color": "white",
        "regions": ["Turkey", "Tokat", "Anatolia"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "pear",
            "peach",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "oaked",
            "varietal",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Nascetta",
        "synonyms": ["Anascetta", "Nas-cëtta"],
        "description": {
            "default": "Renascent semi-aromatic Piemontese made increasingly as a varietal wine.",
            "julie": "",
            "sommelier": "Nascetta is Piedmont’s hidden white gem, bursting with zesty citrus, juicy pear, and a whisper of wild herbs, all wrapped in a mineral embrace. This lively, medium-bodied wine is a sommelier’s secret handshake—delightfully fresh now, yet capable of blossoming with age.",
        },
        "color": "white",
        "regions": ["Piedmont", "Langhe", "Italy"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "herbal",
            "mineral",
            "pear",
            "apple",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "unoaked",
            "medium_bodied",
            "premium",
            "traditional",
            "modern",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Nasco",
        "synonyms": ["Nascu", "Nusco"],
        "description": {
            "default": "Possibly ancient light-berried variety making soft white, mostly dessert, wines on Sardegna.",
            "julie": "",
            "sommelier": "Nasco is Sardinia’s golden secret, weaving together honeyed florals, dried fruit, and a nutty richness into voluptuous, full-bodied dessert wines that linger like a Mediterranean sunset—decadent, age-worthy, and utterly enchanting.",
        },
        "color": "white",
        "regions": ["Sardegna", "Sardinia"],
        "flavor_profile": ["dried_fruit", "honey", "floral", "stone_fruit", "nuts"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
        ],
    },
    {
        "name": "Nebbiera",
        "synonyms": ["Incrocio Dalmasso XV/29"],
        "description": {
            "default": "Very minor northern Italian dark-skinned cross whose true parentage has only recently been revealed.",
            "julie": "",
            "sommelier": "Nebbiera is the enigmatic northern Italian grape that brings a lively medley of cherry, plum, and earthy minerality to your glass, all wrapped in a zippy, medium-bodied frame. Perfect for those who love their reds with a touch of intrigue and a refreshing, early-drinking style.",
        },
        "color": "black",
        "regions": ["Piedmont", "Lombardy", "Valle d'Aosta"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "blend",
            "table_wine",
            "light_bodied",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Nebbiolo",
        "synonyms": [
            "Chiavennasca",
            "Picotendro",
            "Picoutener",
            "Picotèner",
            "Prunent",
            "Prünent",
            "Spanna",
            "Michet",
        ],
        "description": {
            "default": "Piemonte’s, arguably Italy’s, most revered wine grape; very old variety capable of producing perfumed, expressive, ageworthy wines of great beauty.",
            "julie": "Iconic red grape of the Piemonte region of Italy where it produces world class wines in regions such as Barolo DOCG and Barbaresco DOCG. Fragrant, offering a perfect balance between elegance and structure, Barolo wines are high in acidity and tannins and the best of them need a lot of time to fully develop and reveal themselves. There are the true definition of an iron fist in a velvelt glove.",
            "sommelier": "Nebbiolo is the regal heart of Piemonte, crafting wines of haunting perfume and formidable structure—think roses and tar, cherries and truffles, all wrapped in a velvet glove with an iron fist. This grape demands patience, but rewards with a symphony of flavors that only deepen with age.",
        },
        "color": "black",
        "regions": [
            "Piemonte",
            "Lombardy",
            "Valle d'Aosta",
            "Valtellina",
            "Ghemme",
            "Gattinara",
        ],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "earth",
            "mineral",
            "cherry",
            "raspberry",
            "leather",
            "tobacco",
        ],
        "acidity": "High",
        "tannin": "Very high",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Nebbiolo Rosé",
        "synonyms": ["Chiavennasca Piccola", "Chiavennaschino", "Nebiol Matiné"],
        "description": {
            "default": "Piemontese similar to but genetically distinct from Nebbiolo.",
            "julie": "",
            "sommelier": "Nebbiolo Rosé is Piedmont’s enigmatic twin, offering a beguiling dance of cherry, plum, and rose petals over a backbone of spice and earthy minerality—think Nebbiolo with a secret identity and a flair for the dramatic. High in both acidity and tannin, this grape crafts age-worthy reds that are as complex as they are captivating.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
            "leather",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Medium",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Negoska",
        "synonyms": [
            "Goumenissas Mavro",
            "Mavro Goumenissas",
            "Neghotska",
            "Negkoska",
            "Negoska Popolka",
            "Negotska",
            "Popolka Naoussis",
        ],
        "description": {
            "default": "Northern Greek variety making soft, full-bodied wines that are often blended with Xinomavro.",
            "julie": "",
            "sommelier": "Negoska is the velvet-voiced crooner of Northern Greece, delivering plush waves of plum, cherry, and spice with a soft, full-bodied embrace—perfect solo or harmonizing with Xinomavro in a classic Goumenissa blend. This grape’s earthy undertones and juicy fruit make every glass a lively, early-drinking celebration of Macedonian terroir.",
        },
        "color": "black",
        "regions": ["Goumenissa", "Macedonia", "Northern Greece"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "full_bodied",
            "table_wine",
            "traditional",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Negramoll",
        "synonyms": [
            "Molar",
            "Mollar",
            "Mollar Cano",
            "Mollar de América",
            "Mollar de Cádiz",
            "Mollar de Granada",
            "Mollar de Huelva",
            "Mollar ICA",
            "Mulata",
            "Negra Criolla",
            "Negra Mole",
            "Negramolle",
            "Rabo de Ovelha Tinto",
            "Saborinho",
            "Tinta de Madeira",
            "Tinta Negra",
            "Tinta Negra Mole",
        ],
        "description": {
            "default": "The dark-skinned grape of Iberia’s Atlantic islands.",
            "julie": "",
            "sommelier": "Negramoll is the island-hopper of the grape world, delivering a breezy, light-bodied red brimming with cherry and raspberry, dusted with a whisper of volcanic earth. Perfect for early sipping, it’s a charming companion for seaside sunsets and lively tapas tables alike.",
        },
        "color": "black",
        "regions": ["Canary Islands", "Madeira", "Andalusia", "Azores"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "fortified",
            "traditional",
        ],
    },
    {
        "name": "Negrara Trentina",
        "synonyms": [
            "Doleara",
            "Doveana",
            "Dovenzana",
            "Edeleschwarze",
            "Keltertraube",
            "Zoveana",
        ],
        "description": {
            "default": "Trentino variety that lost significant ground post-phylloxera in the early twentieth century.",
            "julie": "",
            "sommelier": "Negrara Trentina, a resilient relic of Trentino’s vineyards, charms with a tapestry of red and black fruits, earthy undertones, and a whisper of herbs—making it the unsung hero in traditional blends and early-drinking reds. Once nearly lost to history, this grape now offers a delicious taste of northern Italy’s vinous heritage.",
        },
        "color": "black",
        "regions": ["Trentino", "Alto Adige", "Veneto"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "traditional",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Negrara Veronese",
        "synonyms": ["Terodola"],
        "description": {
            "default": "Minor Veneto blending component, useful for colour.",
            "julie": "",
            "sommelier": "Negrara Veronese is the unsung hero of Veneto blends, lending a brooding depth of black fruit, earthy undertones, and mineral intrigue to traditional reds—think of it as the grape that quietly makes the stars shine brighter.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": ["black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "age_worthy"],
    },
    {
        "name": "Négrette",
        "synonyms": [
            "Cap de More",
            "Dégoûtant",
            "Morelet",
            "Morillon",
            "Mourrelet",
            "Négralet",
            "Négret",
            "Négret de Gaillac",
            "Négret du Tarn",
            "Négrette de Fronton",
            "Noirien",
            "Pinot St George",
            "Vesparo Noir",
        ],
        "description": {
            "default": "Supple, fruity and distinctive variety that has thrived for centuries just north of Toulouse.",
            "julie": "",
            "sommelier": "Négrette is the soulful chanteuse of Southwest France, serenading your palate with juicy plum, raspberry, and a whisper of violets, all wrapped in a supple, medium-bodied embrace—perfect for those who crave a wine as charmingly offbeat as a Toulouse street café.",
        },
        "color": "black",
        "regions": ["Fronton", "Southwest France", "Gaillac"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "spice",
            "earth",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "early_drinking",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Negretto",
        "synonyms": [
            "Negretta",
            "Negrettino",
            "Negrettino Bolognese",
            "Negrettino Erioli",
        ],
        "description": {
            "default": "Ancient but now minor Emilia-Romagna variety for the table or early-drinking wines.",
            "julie": "",
            "sommelier": "Negretto is Emilia-Romagna’s hidden gem, offering a breezy, floral embrace of red and black fruits with a whisper of herbs—perfect for those who love their reds light, lively, and steeped in Italian tradition. This ancient variety is a delightful companion for casual sipping or a rustic table spread.",
        },
        "color": "black",
        "regions": ["Emilia-Romagna"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Negroamaro",
        "synonyms": [
            "Abruzzese",
            "Albese",
            "Jonico",
            "Lacrima",
            "Negro Amaro",
            "Nigroamaro",
            "Purcinara",
            "Uva Olivella",
        ],
        "description": {
            "default": "Makes sweet-tasting, early-drinking reds and some good rosés on the heel of Italy.",
            "julie": "",
            "sommelier": "Negroamaro is the dark-hearted darling of southern Italy, delivering plush black fruit and spicy earthiness in every glass—think of it as the soulful, sun-baked poet of Puglia, equally at home in a juicy red or a vibrant rosé.",
        },
        "color": "black",
        "regions": ["Puglia", "Salento", "Italy"],
        "flavor_profile": ["black_fruit", "plum", "spice", "earth", "herbal"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "rosé",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
            "premium",
        ],
    },
    {
        "name": "Ner D’Ala",
        "synonyms": [
            "Barau",
            "Durás",
            "Fiori",
            "Gros Vien",
            "Neirét dal Picul Rus",
            "Provinè",
            "Pruinè",
            "Uva di Biella",
            "Verdés",
            "Vernassa",
        ],
        "description": {
            "default": "Virtually extinct vine now known to come from Piemonte.",
            "julie": "",
            "sommelier": "Once nearly lost to history, Ner D’Ala is Piemonte’s hidden gem—delivering a lively dance of red and black fruits, earthy undertones, and a mineral streak, all wrapped in a medium-bodied, high-acid embrace that begs for rustic Italian fare.",
        },
        "color": "black",
        "regions": ["Piemonte"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Nerello Cappuccio",
        "synonyms": [
            "Mantiddatu Niuru",
            "Nerello Mantellato",
            "Nirello Cappucio",
            "Niureddu",
            "Niureddu Ammatiddatu",
            "Niureddu Capucciu",
        ],
        "description": {
            "default": "The lesser, softer of Sicily’s Nerellos, frequently planted with other, as yet unknown, varieties.",
            "julie": "",
            "sommelier": "Nerello Cappuccio is Sicily’s charming understudy, offering a lively medley of red fruit, floral, and earthy notes with a gentle touch of spice—perfect for those who crave a supple, easy-drinking red with a whisper of volcanic intrigue. Often blended but never overshadowed, it brings a soft, convivial spirit to the table.",
        },
        "color": "black",
        "regions": ["Sicily", "Etna", "Catania"],
        "flavor_profile": ["red_fruit", "floral", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "medium_bodied",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Nerello Mascalese",
        "synonyms": [
            "Mascalese Nera",
            "Mascalisi",
            "Nerello Calabrese",
            "Nerello Carbunaru",
            "Nerello di Mascali",
            "Nerello Nostrale",
            "Nerello Paesano",
            "Niureddu",
            "Niureddu Mascalese",
        ],
        "description": {
            "default": "Important, noble Sicilian of particular significance around Etna. The firmer, longer-lived Nerello.",
            "julie": "",
            "sommelier": "Nerello Mascalese is Sicily’s volcanic virtuoso, delivering a symphony of cherry, raspberry, and earthy spice, all wrapped in a mineral embrace. With its high acidity and medium structure, this grape crafts elegant, age-worthy reds that capture the wild beauty of Mount Etna in every glass.",
        },
        "color": "black",
        "regions": ["Sicily", "Etna", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "herbal",
            "spice",
            "earth",
            "mineral",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
            "table_wine",
        ],
    },
    {
        "name": "Neret Di Saint-Vincent",
        "synonyms": ["Neiret", "Neret", "Neretto", "Neyret"],
        "description": {
            "default": "Obscure, recently identified, burly Aostan.",
            "julie": "",
            "sommelier": "Neret Di Saint-Vincent is the Aosta Valley’s burly, black-clad secret—delivering a muscular, full-bodied red brimming with wild berries, alpine herbs, and a stony, earthy backbone. High in both acidity and tannin, this grape crafts age-worthy wines that are as rugged and intriguing as the mountain slopes where it grows.",
        },
        "color": "black",
        "regions": ["Aosta Valley", "Valle d'Aosta", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral", "herbal"],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Neretta Cuneese",
        "synonyms": [
            "Freisa di Nizza",
            "Freisa Grossa",
            "Freisa Mora",
            "Neretta",
            "Neretto",
            "Neretto di Cavaglià",
        ],
        "description": {
            "default": "Minor Piemontese that disappears into blends.",
            "julie": "",
            "sommelier": "Neretta Cuneese is Piedmont’s secret handshake—a zesty, high-acid grape that brings a burst of raspberry, cherry, and earthy spice to blends, making every sip a lively, floral affair. Though it rarely takes center stage, its vibrant character ensures the supporting cast shines just a little brighter.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "spice",
            "earth",
            "raspberry",
            "cherry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "table_wine",
            "traditional",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Neretto Di Bairo",
        "synonyms": ["Nerét", "Nerét Gros", "Neretto", "Neretto di San Giorgio"],
        "description": {
            "default": "Minor Piemontese used in blends.",
            "julie": "",
            "sommelier": "Neretto Di Bairo is Piedmont’s unsung blending hero, weaving notes of red and black fruit with earthy, mineral undertones into medium-bodied, easy-drinking reds. This grape brings a rustic Italian charm to the table, perfect for those who appreciate tradition and subtle complexity in their glass.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "mineral"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine", "early_drinking"],
    },
    {
        "name": "Neretto Duro",
        "synonyms": [
            "Balò",
            "Balau",
            "Barbera Rotonda",
            "Bonarda",
            "Bonarda ‘d Macoun",
            "Dolcetto di Boca",
            "Durasa",
            "Freisone",
            "Peilavert",
            "Uva ′d Galvan",
        ],
        "description": {
            "default": "Rare Piemontese with a disproportionate number of synonyms.",
            "julie": "",
            "sommelier": "Neretto Duro is Piedmont’s mysterious chameleon, boasting more aliases than a secret agent and delivering a vibrant medley of cherry, plum, and earthy spice in every glass. With its zippy acidity and medium structure, it’s the perfect companion for lively Italian feasts and convivial tables.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "traditional",
            "table_wine",
            "varietal",
            "blend",
            "early_drinking",
        ],
    },
    {
        "name": "Neretto Gentile",
        "synonyms": [
            "Nerét Cit",
            "Neretìn",
            "Neretto",
            "Neretto di Cavaglià",
            "Vermiglia",
        ],
        "description": {
            "default": "Fragile, minor Piemontese.",
            "julie": "",
            "sommelier": "Neretto Gentile is Piedmont’s charming underdog, offering a whisper of red fruit, floral perfume, and earthy intrigue in a light, easy-drinking frame. This fragile grape is a delightful companion for those seeking a gentle, traditional Italian red with a story to tell.",
        },
        "color": "black",
        "regions": ["Piedmont", "Italy"],
        "flavor_profile": ["red_fruit", "floral", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "table_wine",
            "traditional",
            "early_drinking",
            "blend",
            "varietal",
        ],
    },
    {
        "name": "Neretto Nostrano",
        "synonyms": [
            "Freisa Blu",
            "Nebbiulìn",
            "Nerét ‘d Rean",
            "Nerét dal Busc Bianc",
            "Nerét di Romano",
            "Nerét Gentil",
            "Neretto della Valchiusella",
        ],
        "description": {
            "default": "Minor Piemontese also known in the south of the Valle d’Aosta.",
            "julie": "",
            "sommelier": "Neretto Nostrano is Piedmont’s secret handshake—a zesty, medium-bodied red bursting with red and black fruits, a dash of spice, and a whisper of earth, perfect for those who love their wines lively and full of local character. This grape is a charming companion at the table, ready to delight with its rustic Italian soul and refreshing acidity.",
        },
        "color": "black",
        "regions": ["Piedmont", "Valle d'Aosta"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Nerkarat",
        "synonyms": ["Nerkarata"],
        "description": {
            "default": "Cold-hardy Armenian hybrid used mainly for sweet reds.",
            "julie": "",
            "sommelier": "Nerkarat is Armenia’s answer to indulgence: a full-bodied, cold-hardy black grape that bursts with red and black fruit, dried fruit, and a whisper of florals, making it the perfect companion for sweet reds and traditional dessert wines. Its low tannins and medium acidity let the lush fruit flavors shine, offering a taste of the Caucasus in every glass.",
        },
        "color": "black",
        "regions": ["Armenia", "Caucasus"],
        "flavor_profile": ["red_fruit", "black_fruit", "dried_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "dessert", "varietal", "traditional"],
    },
    {
        "name": "Nero Buono Di Cori",
        "synonyms": ["Nero Buono", "Nero di Cori"],
        "description": {
            "default": "Minor central Italian generally blended with Montepulciano or Cesanese.",
            "julie": "",
            "sommelier": "Nero Buono Di Cori is Lazio’s dark and mysterious gem, brimming with luscious black fruit, spicy earth, and a full-bodied embrace that lingers on the palate. Often blended but never overshadowed, this grape brings a bold Italian character to every glass.",
        },
        "color": "black",
        "regions": ["Lazio", "Central Italy"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "medium_bodied",
            "full_bodied",
            "traditional",
            "table_wine",
            "age_worthy",
        ],
    },
    {
        "name": "Nero D’Avola",
        "synonyms": [
            "Calabrese",
            "Calabrese d’Avola",
            "Calabrese di Vittoria",
            "Calabrese Dolce",
            "Niureddu Calavrisi",
        ],
        "description": {
            "default": "Sicilia’s most widely planted red wine variety valued for its colour, full body and ageing potential.",
            "julie": "",
            "sommelier": "Nero D’Avola, Sicily’s sultry black beauty, seduces with waves of ripe plum, blackberry, and a whisper of spice, all wrapped in a full-bodied embrace that lingers like a Mediterranean sunset. This grape is the island’s answer to bold red wine lovers, offering both power and poise in every glass.",
        },
        "color": "black",
        "regions": ["Sicily", "Italy"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "mineral",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Nero Di Troia",
        "synonyms": [
            "Sommarrello",
            "Sumarello",
            "Summariello",
            "Tranese",
            "Troiano",
            "Uva della Marina",
            "Uva di Barletta",
            "Uva di Canosa",
            "Uva di Troia",
        ],
        "description": {
            "default": "High-quality, flavourful, firm northern Puglian that has declined considerably in the last 40 years.",
            "julie": "",
            "sommelier": "Nero di Troia is Puglia’s brooding black pearl, delivering a full-bodied embrace of blackberries, plums, and earthy spice, all wrapped in a firm tannic grip. This grape’s wines are both powerful and perfumed, perfect for those who like their reds with a touch of Italian drama and age-worthy depth.",
        },
        "color": "black",
        "regions": [
            "Puglia",
            "Italy",
            "Northern Puglia",
            "Barletta",
            "Canosa",
            "Troia",
        ],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "floral",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "blend",
            "traditional",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Neuburger",
        "synonyms": ["Brubler", "Neuburské"],
        "description": {
            "default": "Nutty, full-bodied but soft Austrian white.",
            "julie": "",
            "sommelier": "Neuburger is Austria’s quietly charismatic white, offering a plush, full-bodied embrace with whispers of spice, spring flowers, and a signature nutty finish that deepens with age. Think of it as the velvet smoking jacket of Austrian whites—elegant, understated, and always a little intriguing.",
        },
        "color": "white",
        "regions": ["Austria", "Thermenregion", "Burgenland", "Leithaberg"],
        "flavor_profile": ["floral", "spice", "nuts"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "blend",
            "varietal",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "New York Muscat",
        "synonyms": ["New York 12997", "NY 12997", "NY Muscat"],
        "description": {
            "default": "American hybrid with pronounced Muscat flavours grown mainly in Canada.",
            "julie": "",
            "sommelier": "New York Muscat is a flamboyant showstopper, bursting with a kaleidoscope of floral, tropical, and honeyed notes that dance across the palate. This Canadian favorite delivers a juicy, aromatic experience in every glass, perfect for those who crave a touch of the exotic in their everyday wine.",
        },
        "color": "black",
        "regions": ["Canada", "New York State", "Ontario", "British Columbia"],
        "flavor_profile": [
            "floral",
            "stone_fruit",
            "tropical_fruit",
            "red_fruit",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "sparkling",
            "dessert",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Niagara",
        "synonyms": ["Niagara White", "White Concord"],
        "description": {
            "default": "The foxiest American hybrid of them all.",
            "julie": "",
            "sommelier": 'Niagara is the quintessentially "foxy" American white grape, bursting with tropical and stone fruit flavors, a hint of honey, and a playful floral lift. Light-bodied and easygoing, it\'s the perfect companion for a sunny picnic or a nostalgic sip of Americana.',
        },
        "color": "white",
        "regions": [
            "New York (Finger Lakes, Lake Erie)",
            "Ontario",
            "Pennsylvania",
            "Ohio",
            "Michigan",
        ],
        "flavor_profile": ["tropical_fruit", "stone_fruit", "floral", "honey"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Nieddera",
        "synonyms": ["Nieddaera", "Nireddie"],
        "description": {
            "default": "Recently revived and promising Sardinian.",
            "julie": "",
            "sommelier": "Nieddera, Sardinia’s dark-hued comeback kid, charms with a medley of red and black fruits, floral whispers, and a dash of Mediterranean herbs and spice. Medium-bodied and delightfully balanced, it’s a versatile grape that brings a taste of Sardinian tradition to both reds and rosés—perfect for those seeking something both classic and refreshingly new.",
        },
        "color": "black",
        "regions": ["Sardinia", "Oristano"],
        "flavor_profile": ["red_fruit", "black_fruit", "floral", "herbal", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "medium_bodied",
            "blend",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Nigra",
        "synonyms": ["Incrocio Cosmo 96"],
        "description": {
            "default": "Very minor, little-planted, dark-skinned Veneto cross.",
            "julie": "",
            "sommelier": "Nigra is Veneto’s secret handshake—a dusky, medium-bodied red brimming with juicy black fruit, plum, and a whisper of earth, perfect for those who crave something off the beaten path. This rare grape delivers a harmonious, easy-drinking experience that rewards curiosity with every sip.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ninčuša",
        "synonyms": ["Lincuša", "Mlinčevac", "Vincuša"],
        "description": {
            "default": "Now virtually extinct, rather ordinary variety from the region of Split, on Croatia’s Adriatic coast.",
            "julie": "",
            "sommelier": "Ninčuša, a rare relic from Croatia’s sun-drenched Dalmatian coast, offers a charming medley of red and black fruits dusted with earth, making it a delightful companion for rustic, early-drinking reds. Though nearly vanished, this grape whispers tales of Split’s winemaking past in every sip.",
        },
        "color": "black",
        "regions": ["Split", "Dalmatia", "Croatia"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Nitranka",
        "synonyms": ["CAAB 3/22"],
        "description": {
            "default": "Recently authorized and increasingly popular Slovakian cross.",
            "julie": "",
            "sommelier": "Nitranka is Slovakia’s rising star, delivering a harmonious medley of cherry, plum, and blackberry, dusted with spice and earth, all wrapped in a supple, medium-bodied frame. Whether poured as a lively table wine or a polished reserve, it charms with Central European flair and a modern twist.",
        },
        "color": "black",
        "regions": ["Slovakia", "Czech Republic", "Hungary", "Austria"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "blackberry",
            "spice",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
            "reserve",
            "early_drinking",
        ],
    },
    {
        "name": "Noah",
        "synonyms": [
            "Belo Otelo",
            "Charvat",
            "Flaga Alba",
            "Fraga",
            "Noa",
            "Noé",
            "Noka",
            "Nova",
            "Tatar Rizling",
        ],
        "description": {
            "default": "American hybrid once popular in Europe, notably Spanish Basque Country, but now almost extinct.",
            "julie": "",
            "sommelier": "Noah is a whimsical relic of the vineyard, offering a crisp medley of apple and pear with a whisper of wildflowers and herbs—think of it as the Basque Country’s secret handshake to adventurous palates. Light, lively, and almost lost to time, this grape is a charming companion for those who savor the thrill of discovery in their glass.",
        },
        "color": "white",
        "regions": [
            "Spanish Basque Country",
            "France",
            "United States (Northeast)",
            "Central Europe",
        ],
        "flavor_profile": ["apple", "pear", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "blend",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Noble",
        "synonyms": ["North Carolina 20-119"],
        "description": {
            "default": "Productive Muscadine variety widely grown in North Carolina for juice and wine.",
            "julie": "",
            "sommelier": "Noble is the Southern belle of Muscadines, offering a juicy medley of black fruit, earthy undertones, and a whisper of florals—perfect for easy-drinking reds or luscious dessert wines. Grown with pride in North Carolina, this grape brings a taste of the Southeast to every glass.",
        },
        "color": "black",
        "regions": ["North Carolina", "Southeastern United States"],
        "flavor_profile": ["black_fruit", "earth", "floral"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "dessert",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Nobling",
        "synonyms": ["Freiburg 128-40"],
        "description": {
            "default": "Demanding German cross making neutral wines.",
            "julie": "",
            "sommelier": "Nobling is the quiet achiever of German whites, offering a crisp medley of apple and pear with a whisper of minerality—perfect for those who prefer their wines light, unoaked, and refreshingly subtle. Think of it as the gentle breeze of Baden in a glass, ideal for easy sipping and lively conversation.",
        },
        "color": "white",
        "regions": ["Germany", "Baden"],
        "flavor_profile": ["apple", "pear", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "light_bodied", "unoaked", "varietal", "table_wine"],
    },
    {
        "name": "Nocera",
        "synonyms": [
            "Nocera di Catania",
            "Nocera Mantonico",
            "Nocera Nera di Milazzo",
            "Nucera",
            "Nucera Niura",
        ],
        "description": {
            "default": "Minor blending ingredient in Calabria and Sicilia.",
            "julie": "",
            "sommelier": "Nocera is the unsung hero of southern Italian blends, bringing a zesty burst of red and black fruit, earthy undertones, and a refreshing herbal lift—think of it as the secret spice that makes Sicilian and Calabrian reds sing. With its high acidity and medium body, it’s a lively companion for early-drinking wines that capture the sun-drenched spirit of the Mediterranean.",
        },
        "color": "black",
        "regions": ["Calabria", "Sicilia"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "traditional",
            "table_wine",
            "medium_bodied",
            "early_drinking",
        ],
    },
    {
        "name": "Noir Fleurien",
        "synonyms": [
            "Damas Rouge",
            "Fleurien Noir",
            "Mire-Fleurien",
            "Mirefleurien",
            "Noir-Fleurien",
        ],
        "description": {
            "default": "Ancient and very rare Auvergne vine.",
            "julie": "",
            "sommelier": "Noir Fleurien is a hidden gem from Auvergne, weaving together vibrant cherry and plum notes with earthy, mineral undertones—think of it as a rustic French treasure chest for your palate. With lively acidity and a medium frame, this rare grape brings both history and a juicy, refreshing charm to the glass.",
        },
        "color": "black",
        "regions": ["Auvergne", "France"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Noiret",
        "synonyms": ["NY 73.0136.17"],
        "description": {
            "default": "Promising new American hybrid producing peppery, well-structured dry reds.",
            "julie": "",
            "sommelier": "Noiret is the Finger Lakes' answer to a pepper mill in a glass—bursting with black fruit, earthy spice, and a signature peppery kick, this medium-bodied red is a bold, modern hybrid that’s as lively as a jazz night in upstate New York. Perfect for those who crave a little intrigue in their glass, Noiret is ready to charm you from the first sip.",
        },
        "color": "black",
        "regions": ["New York", "Finger Lakes", "Lake Erie", "Pennsylvania", "Ohio"],
        "flavor_profile": ["black_fruit", "spice", "pepper", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Norton",
        "synonyms": [
            "Arkansas",
            "Cynthiana",
            "Norton Virginia",
            "Norton’s Seedling",
            "Norton’s Virginia Seedling",
            "Red River",
            "Virginia",
            "Vitis Nortoni",
        ],
        "description": {
            "default": "Old, very successful American hybrid making rich, vinifera-like reds in a wide range of US states.",
            "julie": "",
            "sommelier": "Norton is the bold, all-American underdog of the wine world, delivering a symphony of black fruit, spice, and earthy intrigue with a vinifera-like finesse. Full-bodied and high in acidity, this grape crafts reds that are as age-worthy as they are conversation-worthy—think of it as the soulful jazz of American wine.",
        },
        "color": "black",
        "regions": ["Virginia", "Missouri", "Arkansas", "Midwest USA", "Eastern USA"],
        "flavor_profile": ["black_fruit", "cherry", "plum", "spice", "earth", "herbal"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "modern",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Nosiola",
        "synonyms": [
            "Groppello Bianco",
            "Nosellara",
            "Nosiola Gentile",
            "Nusiola",
            "Spargelen",
        ],
        "description": {
            "default": "Trentino-Alto Adige variety long appreciated for Vino Santo but now making waves for its characterful dry wine.",
            "julie": "",
            "sommelier": "Nosiola is Trentino’s hidden gem, offering a zesty medley of citrus and stone fruit with a whisper of hazelnut and mountain minerals—think alpine breeze in a glass, equally at home as a crisp aperitif or a contemplative, age-worthy white.",
        },
        "color": "white",
        "regions": ["Trentino-Alto Adige", "Trentino", "Italy"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "nuts", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Notardomenico",
        "synonyms": ["Notar Domenico"],
        "description": {
            "default": "Minor variety of unknown origin found in Puglia today.",
            "julie": "",
            "sommelier": "Notardomenico is Puglia’s enigmatic black grape, weaving together red and black fruit, spice, and earthy undertones into a medium-bodied, balanced red wine. A true hidden treasure, it brings rustic charm and intrigue to both varietal and blended wines.",
        },
        "color": "black",
        "regions": ["Puglia"],
        "flavor_profile": ["red_fruit", "black_fruit", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "table_wine", "traditional", "varietal", "blend"],
    },
    {
        "name": "Nuragus",
        "synonyms": [
            "Abbondosa",
            "Axina ’e Pòberus",
            "Axina Scacciadèppidus",
            "Preni Tineddus",
        ],
        "description": {
            "default": "Ancient, fertile and generally unremarkable Sardinian.",
            "julie": "",
            "sommelier": "Nuragus, Sardinia’s humble white grape, charms with zesty citrus, crisp apple, and a whisper of minerality—think of it as the island’s refreshing answer to a thirst-quenching afternoon, perfect for those who appreciate tradition in their glass.",
        },
        "color": "white",
        "regions": ["Sardinia"],
        "flavor_profile": ["citrus", "apple", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "table_wine",
            "varietal",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Odessky Cherny",
        "synonyms": [
            "Alibernet",
            "Oděskij Čornyj",
            "Odessa Black",
            "Odesskii Chernyi",
            "Semenac 1-17-4",
        ],
        "description": {
            "default": "Red-fleshed, versatile Ukrainian cross that reveals its Cabernet parentage.",
            "julie": "",
            "sommelier": "Odessky Cherny is Ukraine’s bold answer to Cabernet, bursting with juicy plum, cherry, and blackberry, laced with peppery spice and earthy intrigue—a full-bodied, versatile charmer that brings both tradition and modern flair to the glass.",
        },
        "color": "black",
        "regions": ["Ukraine", "Moldova", "Russia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "herbal",
            "plum",
            "cherry",
            "blackberry",
            "pepper",
            "earth",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "full_bodied",
            "table_wine",
            "traditional",
            "modern",
            "early_drinking",
        ],
    },
    {
        "name": "Oeillade Noire",
        "synonyms": [
            "Aragnan Noir",
            "Ouillade",
            "Ouillard",
            "Ouliade",
            "Passerille Noire",
        ],
        "description": {
            "default": "Disappearing, dark-skinned, southern French variety more popular as a table grape.",
            "julie": "",
            "sommelier": "Oeillade Noire is the charming wallflower of southern France—delicate, juicy, and brimming with cherry and plum, it’s a light-bodied, low-alcohol red that’s as delightful in a glass as it is on the table. A true rarity, this grape offers a breezy, early-drinking experience that whispers of sun-drenched Languedoc afternoons.",
        },
        "color": "black",
        "regions": ["Languedoc", "Provence", "Southern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Ofthalmo",
        "synonyms": [
            "Oftalmo",
            "Ophtalmo",
            "Ophtalmon",
            "Optalmo",
            "Pephtalmo",
            "Pophtalmo",
        ],
        "description": {
            "default": "Rare Cypriot variety whose soft, light reds are generally hidden in blends.",
            "julie": "",
            "sommelier": "Ofthalmo is Cyprus’s hidden gem—a rare, feather-light red that charms with whispers of red fruit, wild herbs, and spring flowers. Delightfully easy-drinking, it’s a breezy Mediterranean companion perfect for those seeking something off the beaten path.",
        },
        "color": "red",
        "regions": ["Cyprus"],
        "flavor_profile": ["red_fruit", "floral", "herbal"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": ["red", "light_bodied", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Ohridsko Crno",
        "synonyms": ["Prespanka"],
        "description": {
            "default": "Macedonian variety that was a casualty of phylloxera.",
            "julie": "",
            "sommelier": "Ohridsko Crno is a Macedonian gem lost to time, offering a harmonious medley of cherry, plum, and earthy notes in a medium-bodied, traditional red—think of it as a delicious echo from the vineyards of old North Macedonia. A true conversation starter for those who savor history in their glass!",
        },
        "color": "black",
        "regions": ["North Macedonia"],
        "flavor_profile": ["red_fruit", "black_fruit", "cherry", "plum", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "table_wine",
            "traditional",
            "varietal",
        ],
    },
    {
        "name": "Ojaleshi",
        "synonyms": ["Chonouri", "Odjaleshi", "Odzhaleshi", "Sconuri", "Svanuri"],
        "description": {
            "default": "Georgian variety suspected of Turkish origins.",
            "julie": "",
            "sommelier": "Ojaleshi is Georgia’s enigmatic black grape, weaving together a tapestry of cherry, plum, and spice with a floral lift, all balanced by zesty acidity and supple tannins—perfect for those who crave both tradition and intrigue in their glass.",
        },
        "color": "black",
        "regions": ["Georgia", "Samegrelo", "Western Georgia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "floral",
            "cherry",
            "plum",
            "spice",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Öküzgözü",
        "synonyms": ["Kara Erik"],
        "description": {
            "default": "Turkish variety with an increasing reputation for its juicy, fresh, aromatic reds.",
            "julie": "",
            "sommelier": "Öküzgözü, the pride of Eastern Anatolia, bursts onto the palate with a vibrant medley of cherries, plums, and a whisper of spice, all wrapped in a juicy, refreshing frame. This Turkish gem is a must-try for adventurous wine lovers seeking a lively, aromatic red with a story to tell.",
        },
        "color": "black",
        "regions": ["Turkey", "Elazığ", "Eastern Anatolia"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "plum",
            "floral",
            "spice",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Onchette",
        "synonyms": ["Ouchette"],
        "description": {
            "default": "Recently rescued Isère variety.",
            "julie": "",
            "sommelier": "Onchette, the alpine gem of Isère, charms with a brisk mountain breeze of red fruit, wild herbs, and stony minerality, all wrapped in a light, zesty frame—perfect for those who crave a taste of the French Alps in their glass.",
        },
        "color": "black",
        "regions": ["Isère", "Savoie", "French Alps"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Ondenc",
        "synonyms": [
            "Blanquette",
            "Irvine’s White",
            "Oundenc",
            "Oundenq",
            "Piquepout de Moissac",
            "Plant de Gaillac",
        ],
        "description": {
            "default": "Neglected variety persists in south-west France and in isolated spots in Australia.",
            "julie": "",
            "sommelier": "Ondenc is a zesty, high-acid white grape that dazzles with citrus, apple, and floral notes, making it a refreshing choice for sparkling and light-bodied wines. Once nearly forgotten, this French-Australian rarity is a sommelier’s secret weapon for those seeking vibrant, mineral-driven sips.",
        },
        "color": "white",
        "regions": ["Southwest France", "Gaillac", "Australia"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "dessert",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Opsimo Edessis",
        "synonyms": [
            "Agriostaphylo",
            "Chimoniatiko",
            "Dopio",
            "Foustani",
            "Karatsova Naousis",
            "Karatzovitiko",
            "Ntopia",
            "Opsimo",
            "Opsimos Edessis",
            "Opsimos Lefko",
            "Pandiri",
            "Paschalino",
            "Raisin de Foustani",
            "Raisin de Karatzova",
            "Staphyli Edessis",
            "Staphyli Karatzovas",
            "Valandovski Drenak",
            "Zimsko Belo",
            "Belo Zimsko",
        ],
        "description": {
            "default": "Inferior northern Greek variety also grown for the table.",
            "julie": "",
            "sommelier": "Opsimo Edessis is the humble workhorse of northern Greece, delivering crisp apple, pear, and citrus notes in a light, unoaked style—perfect for easy sipping and lively conversation, if not for grand occasions. Think of it as the friendly neighborhood grape: unpretentious, refreshing, and always ready for a casual gathering.",
        },
        "color": "white",
        "regions": ["Edessa", "Naoussa", "Macedonia", "Northern Greece"],
        "flavor_profile": ["apple", "pear", "citrus"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Optima",
        "synonyms": ["Optima 113"],
        "description": {
            "default": "German cross designed to reach stupendous sugar levels even on poor sites.",
            "julie": "",
            "sommelier": "Optima dazzles with decadent stone fruit and honeyed notes, balanced by a zesty citrus lift and a whisper of minerality—think of it as Germany’s answer to opulence in a glass, perfect for those who crave both power and poise in their whites.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["stone_fruit", "citrus", "honey", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "age_worthy",
            "premium",
            "table_wine",
            "unoaked",
        ],
    },
    {
        "name": "Orangetraube",
        "synonyms": ["Gelbe Orangetraube", "Narancsszőlő", "Orangentraube"],
        "description": {
            "default": "Variety with a much-discussed history but now strictly limited geography.",
            "julie": "",
            "sommelier": "Orangetraube is a zesty, high-acid white grape that dazzles with lively citrus, floral, and stone fruit notes—think of it as Austria and Hungary’s best-kept secret for crisp, refreshing sips. Light-bodied and unoaked, it’s the perfect companion for those who crave a bright, early-drinking white with a touch of intrigue.",
        },
        "color": "white",
        "regions": ["Austria", "Hungary", "Germany"],
        "flavor_profile": ["citrus", "floral", "stone_fruit", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Oraniensteiner",
        "synonyms": ["Geisenheim 11-34", "Hochkroner"],
        "description": {
            "default": "German cross that seems to have a found a niche in Canada.",
            "julie": "",
            "sommelier": "Oraniensteiner is a zesty German-Canadian charmer, bursting with citrus, stone fruit, and floral notes, all wrapped in a crisp, high-acid frame—think of it as Riesling’s playful cousin, perfect for those who crave a refreshing, unoaked white with a mineral edge.",
        },
        "color": "white",
        "regions": ["Germany", "Canada"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Orion",
        "synonyms": ["Geilweilerhof GA-58-30"],
        "description": {
            "default": "Little-planted cool-climate German hybrid similar to Müller-Thurgau.",
            "julie": "",
            "sommelier": "Orion is a zesty, cool-climate charmer from Germany and its neighbors, offering a lively medley of citrus, pear, and floral notes atop a mineral backbone. Light on its feet and delightfully unoaked, this rare hybrid is the perfect companion for early drinking and sunny afternoons.",
        },
        "color": "white",
        "regions": ["Germany", "Switzerland", "Austria", "Czech Republic"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Orleans Gelb",
        "synonyms": [
            "Gelber Orleans",
            "Hart-Heunscht",
            "Hartheinisch",
            "Harthengst",
            "Hart-Hängst",
            "Harthinsch",
            "Orleaner",
            "Orléans Jaune",
            "Orleanser",
            "Orleanstraube",
            "Weisser Orleans",
        ],
        "description": {
            "default": "Ancient but now very minor, high-acid German vine replaced by Riesling. The oldest vines in Germany may be Orleans Gelb.",
            "julie": "",
            "sommelier": "Orleans Gelb is a zippy, citrus-laced relic of German viticulture, offering a lively dance of apple and pear atop a mineral backbone—think of it as Riesling’s forgotten ancestor, ready to refresh and intrigue with every sip.",
        },
        "color": "white",
        "regions": ["Germany"],
        "flavor_profile": ["citrus", "apple", "pear", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Ortega",
        "synonyms": ["Würzburg 48-21-4"],
        "description": {
            "default": "Early-ripening Gerrman cross that can achieve impressive sugar levels if not acidity.",
            "julie": "",
            "sommelier": "Ortega is Germany’s sun-chasing white grape, delivering a luscious medley of peach, honey, and floral notes in a glass that’s as charming as a summer picnic. With its generous alcohol and gentle acidity, Ortega is the perfect companion for those who like their wines ripe, aromatic, and ready to drink.",
        },
        "color": "white",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["stone_fruit", "floral", "citrus", "honey", "peach"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "High",
        "wine_styles": ["white", "dessert", "varietal", "early_drinking"],
    },
    {
        "name": "Ortrugo",
        "synonyms": ["Altruga", "Altrugo", "Artrugo"],
        "description": {
            "default": "Emilia-Romagnan often blended with the most aromatic Malvasia.",
            "julie": "",
            "sommelier": "Ortrugo is Emilia-Romagna’s crisp, convivial white, offering a lively medley of apple, pear, and floral notes with a mineral edge—perfect for sparkling or light-bodied wines that dance on the palate and invite another glass.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Colli Piacentini"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "blend",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Oseleta",
        "synonyms": ["Oselina"],
        "description": {
            "default": "Revived and rather fashionable in Valpolicella country.",
            "julie": "",
            "sommelier": "Oseleta is Valpolicella’s comeback kid, delivering a bold, full-bodied red packed with brooding black fruit, spicy earth, and a structure built for the ages. This grape’s high acidity and tannin make it a sommelier’s secret weapon for blends that demand both power and finesse.",
        },
        "color": "black",
        "regions": ["Veneto", "Valpolicella"],
        "flavor_profile": ["black_fruit", "plum", "blackberry", "spice", "earth"],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "blend",
            "full_bodied",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Osteiner",
        "synonyms": ["Geisenheim 9-97"],
        "description": {
            "default": "Very minor German cross with a successful outpost in New Zealand.",
            "julie": "",
            "sommelier": "Osteiner is a zesty, high-acid charmer that dazzles with citrus, pear, and floral notes, offering a lively sip reminiscent of a spring orchard in bloom. Rarely seen outside Germany and New Zealand, this light-bodied white is a hidden gem for fans of fresh, mineral-driven wines.",
        },
        "color": "white",
        "regions": ["Germany", "New Zealand"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Österreichisch Weiss",
        "synonyms": ["Kahlenberger Weisse"],
        "description": {
            "default": "Rare light-skinned Viennese variety with a well-known offspring.",
            "julie": "",
            "sommelier": "Österreichisch Weiss is Vienna’s hidden gem—a zesty, feather-light white grape that dazzles with crisp apple, juicy pear, and a whisper of wildflowers, all underpinned by a stony minerality. Perfect for those who crave a refreshing, unoaked sip with a dash of old-world intrigue.",
        },
        "color": "white",
        "regions": ["Austria", "Vienna"],
        "flavor_profile": ["apple", "pear", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Otskhanuri Sapere",
        "synonyms": ["Argvetuli Sapere"],
        "description": {
            "default": "Minor Georgian variety responsible for deeply coloured, ageworthy reds.",
            "julie": "",
            "sommelier": "Otskhanuri Sapere is Georgia’s inky treasure, delivering a robust, full-bodied red brimming with tart cherry, blackberry, and earthy spice, all wrapped in a mineral cloak and built to age gracefully. This high-acid, high-tannin varietal is a bold, soulful sip for adventurous palates seeking tradition and depth.",
        },
        "color": "black",
        "regions": ["Georgia", "Imereti"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "spice",
            "mineral",
            "plum",
            "cherry",
            "blackberry",
        ],
        "acidity": "High",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Padeiro",
        "synonyms": ["Padeiro de Basto", "Tinto Matias"],
        "description": {
            "default": "Productive but good-quality Portuguese variety makes rosé and light-red wines.",
            "julie": "",
            "sommelier": "Padeiro is Portugal’s playful answer to summer sipping—a vivacious grape that bursts with cherry and raspberry, laced with floral and herbal whispers. Light on its feet and high in acidity, it crafts refreshing reds and rosés that are perfect for early enjoyment and lively gatherings.",
        },
        "color": "black",
        "regions": ["Portugal", "Vinho Verde", "Basto"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "herbal"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pálava",
        "synonyms": ["Veverka"],
        "description": {
            "default": "Pink-skinned Czech cross producing full-bodied yet fresh, spicy whites.",
            "julie": "",
            "sommelier": "Pálava is Moravia’s aromatic gem, delivering a voluptuous white wine that dances with notes of ripe stone fruit, honeyed pear, and a whisper of spice—think Gewürztraminer’s lively Czech cousin, but with a fresher, more elegant twist.",
        },
        "color": "pink",
        "regions": ["Czech Republic", "Moravia"],
        "flavor_profile": ["stone_fruit", "floral", "spice", "honey", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["white", "full_bodied", "varietal", "premium", "traditional"],
    },
    {
        "name": "Pallagrello Bianco",
        "synonyms": [
            "Pallagrella Bianca",
            "Pallagrello di Avellino",
            "Pallarella",
            "Piedimonte Bianco",
        ],
        "description": {
            "default": "Old, rare Campanian, not unlike Viognier.",
            "julie": "",
            "sommelier": "Pallagrello Bianco is Campania’s hidden white gem, seducing the palate with lush pear and peach, a whisper of honeyed florals, and a mineral backbone that lingers like a well-kept secret. Full-bodied yet graceful, it’s a Viognier-like rarity that rewards both curiosity and patience.",
        },
        "color": "white",
        "regions": ["Campania"],
        "flavor_profile": [
            "stone_fruit",
            "floral",
            "honey",
            "spice",
            "mineral",
            "pear",
            "peach",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Pallagrello Nero",
        "synonyms": [
            "Coda di Volpe Nera",
            "Pallagrella Nera",
            "Piedilungo",
            "Piedimonte Rosso",
        ],
        "description": {
            "default": "Rare dark-skinned variety from Campania, unrelated to Pallagrello Bianco.",
            "julie": "",
            "sommelier": "Pallagrello Nero is Campania’s enigmatic black pearl, seducing the palate with a cascade of cherry, plum, and earthy spice, all wrapped in a full-bodied embrace. This rare varietal is a must-try for adventurous wine lovers seeking a taste of southern Italy’s hidden treasures.",
        },
        "color": "black",
        "regions": ["Campania", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "full_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Palomino Fino",
        "synonyms": [
            "Albillo de Lucena",
            "Bianco",
            "Fransdruif",
            "Golden Chasselas",
            "Jerez",
            "Listan",
            "Listan de Jerez",
            "Listán Blanco",
            "Listán Comun",
            "Listão",
            "Listrão",
            "Madera",
            "Malvasia Rei",
            "Manzanilla de Sanlucar",
            "Ojo de Liebre",
            "Palomina Blanca",
            "Palomino",
            "Palomino Macho",
            "Palomino Pelusón",
            "Temprana",
            "Tempranilla",
            "Xeres",
        ],
        "description": {
            "default": "The sherry grape.",
            "julie": "",
            "sommelier": "Palomino Fino is the unsung hero of sherry, offering delicate apple and pear flavors with a whisper of minerality and nuts—think of it as the quiet genius behind Spain’s most iconic fortified wines. Light in body but high in spirit, this grape transforms from humble table sipper to the star of the solera with effortless grace.",
        },
        "color": "white",
        "regions": [
            "Jerez (Sherry Triangle), Spain",
            "Sanlúcar de Barrameda, Spain",
            "Montilla-Moriles, Spain",
            "Madeira, Portugal",
            "South Africa",
            "Australia",
        ],
        "flavor_profile": ["apple", "pear", "mineral", "nuts"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "fortified",
            "light_bodied",
            "oaked",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
            "premium",
            "reserve",
        ],
    },
    {
        "name": "Pamid",
        "synonyms": [
            "Grechesky Rosovy",
            "Manaluki",
            "Pamidi",
            "Pamitis",
            "Piros Szlanka",
            "Plovdina",
            "Roşioar",
            "Saratchoubouk",
            "Slankamenka Crvena",
        ],
        "description": {
            "default": "Old, widely planted but uninspiring Bulgarian red wine grape.",
            "julie": "",
            "sommelier": "Pamid is the cheerful workhorse of the Balkans, offering a breezy medley of cherry and raspberry flavors in a light, unoaked style—perfect for casual sipping and lively gatherings. While it may not steal the spotlight, its easygoing nature and historical roots make it a beloved companion at any table.",
        },
        "color": "pink, red and black",
        "regions": ["Bulgaria", "Serbia", "Romania", "North Macedonia", "Hungary"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pampanuto",
        "synonyms": ["Pampanino", "Pampanuta", "Rizzulo"],
        "description": {
            "default": "Minor and largely unexciting Puglian.",
            "julie": "",
            "sommelier": "Pampanuto is Puglia’s easygoing white, offering a breezy medley of apple and pear with a whisper of minerality—perfect for those sun-drenched afternoons when you want your wine as relaxed as the Italian countryside. Light-bodied and low in acidity, it’s a charming companion for simple fare and good company.",
        },
        "color": "white",
        "regions": ["Puglia"],
        "flavor_profile": ["apple", "pear", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "table_wine",
            "blend",
            "unoaked",
            "early_drinking",
        ],
    },
    {
        "name": "Papazkarasi",
        "synonyms": ["Papaskara", "Papaz Karası"],
        "description": {
            "default": "Turkish variety found mainly in Trakya (Thrace) with a very local purpose.",
            "julie": "",
            "sommelier": "Papazkarasi is Thrace’s hidden gem, offering a lively medley of cherry and raspberry with a whisper of spice and earth—think of it as Turkey’s answer to a picnic red, perfect for early sipping and local feasts.",
        },
        "color": "black",
        "regions": ["Turkey", "Thrace", "Trakya"],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "spice", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pardillo",
        "synonyms": [
            "Blanca Pequeña",
            "Marisancho",
            "Parda",
            "Pardilla",
            "Pardillo de Madrid",
            "Parill Blanco",
            "Temprana Media",
        ],
        "description": {
            "default": "Local La Mancha variety producing well-structured, non-aromatic wines.",
            "julie": "",
            "sommelier": "Pardillo is La Mancha’s quietly confident white grape, delivering a mineral-driven, subtly fruity wine with whispers of apple and pear—perfect for those who appreciate structure over showiness. This medium-bodied charmer is a local favorite for easy, early sipping and traditional Spanish tables.",
        },
        "color": "white",
        "regions": ["La Mancha", "Castilla-La Mancha", "Madrid"],
        "flavor_profile": ["mineral", "earth", "stone_fruit", "apple", "pear"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "table_wine",
            "varietal",
            "blend",
            "medium_bodied",
            "early_drinking",
            "traditional",
        ],
    },
    {
        "name": "Parellada",
        "synonyms": [
            "Martorella",
            "Moltonach",
            "Montañesa",
            "Montona",
            "Montònec",
            "Montónega",
            "Montonench",
            "Verda Grossa",
        ],
        "description": {
            "default": "Aromatic variety with high quality potential used mainly in the production of Cava.",
            "julie": "Parellada is a white grape variety mostly used for the production of Cava wines. It produces aromatic wines with a moderate level of alcohol and a juicy acidity.",
            "sommelier": "Parellada is the zesty backbone of Spain’s finest Cava, delivering a lively dance of citrus, crisp apple, and delicate florals with a mineral edge—think of it as the sparkling soul of Catalonia in a glass.",
        },
        "color": "white",
        "regions": ["Catalonia", "Penedès", "Spain"],
        "flavor_profile": ["citrus", "apple", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "blend",
            "varietal",
            "traditional",
            "early_drinking",
        ],
    },
    {
        "name": "Parraleta",
        "synonyms": [
            "Bonifaccencu",
            "Bonifacienco",
            "Bonvedro",
            "Bomvedro",
            "Carcaghjolu Neru",
            "Carcajolo Nero",
            "Carcajolo Noir",
            "Carenisca",
            "Caricagiola",
            "Cua Tendra",
            "Espagnin Noir",
            "False Carignan",
            "Lambrusco de Alentejo",
            "Monvedro",
            "Monvedro do Algarve",
            "Monvedro de Sines",
            "Olho Branco",
            "Parrel",
            "Pau Ferro",
            "Perrel",
            "Preto Foz",
            "Preto João Mendes",
            "Salceño Negro",
            "Tinta Caiada",
            "Tinta Grossa",
            "Tinta Lameira",
            "Tintorro",
            "Torres de Algarve",
        ],
        "description": {
            "default": "Distinctive Somontano variety producing dark, aromatic wines in several countries and under many different names.",
            "julie": "",
            "sommelier": "Parraleta is the globe-trotting chameleon of the wine world, delivering vibrant, aromatic reds bursting with black and red fruits, floral hints, and a spicy, earthy backbone. With its zippy acidity and medium structure, this Somontano star shines equally in rustic blends or as a solo act, always promising a lively, memorable sip.",
        },
        "color": "black",
        "regions": [
            "Somontano (Spain)",
            "Aragon (Spain)",
            "Alentejo (Portugal)",
            "Sardinia (Italy)",
        ],
        "flavor_profile": ["black_fruit", "red_fruit", "floral", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Pascal Blanc",
        "synonyms": ["Pascal", "Pascaou", "Pascau"],
        "description": {
            "default": "Historic variety barely surviving in Provence.",
            "julie": "",
            "sommelier": "Pascal Blanc is Provence’s elusive white gem, offering a delicate dance of citrus, stone fruit, and floral notes over a subtle mineral backbone. Nearly lost to time, this historic grape delivers a charming, medium-bodied wine that whispers of sun-drenched French hillsides and bygone eras.",
        },
        "color": "white",
        "regions": ["Provence"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pascale",
        "synonyms": [
            "Barberone",
            "Falso Gregu",
            "Giacomino",
            "Muresconu",
            "Nera Tomentosa",
            "Nieddu Mannu",
            "Nieddu Pedra Serra",
            "Pascale di Cagliari",
            "Pascale Nero",
            "Pasquale",
            "Picciolo Rosso",
            "Primidivu Nieddu",
        ],
        "description": {
            "default": "Dark-skinned Sardinian rarely bottled on its own.",
            "julie": "",
            "sommelier": "Pascale is Sardinia’s secret handshake—an earthy, medium-bodied red grape that weaves together red and black fruits with a whisper of wild herbs, rarely stepping into the spotlight alone but always adding a rustic charm to local blends. Sip it and you’ll taste the sunbaked hills and ancient traditions of the island in every glass.",
        },
        "color": "black",
        "regions": ["Sardinia", "Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine", "varietal"],
    },
    {
        "name": "Passau",
        "synonyms": ["Incrocio Dalmasso 17/25"],
        "description": {
            "default": "Very minor Veneto cross whose correct parentage has only recently been identified.",
            "julie": "",
            "sommelier": "Passau is Veneto’s enigmatic black grape, offering a harmonious medley of red and black fruits dusted with earthy intrigue—think of it as the region’s best-kept secret, perfect for those who crave discovery in their glass. Medium-bodied and versatile, it’s a delightful companion for early sipping or blending adventures.",
        },
        "color": "black",
        "regions": ["Veneto"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "table_wine", "varietal", "blend", "early_drinking"],
    },
    {
        "name": "Passerina",
        "synonyms": [
            "Cacciadebiti",
            "Caccione",
            "Camplese",
            "Pagadebito",
            "Scacciadebito",
            "Trebbiano di Teramo",
            "Uva d’Oro",
            "Uva Fermana",
        ],
        "description": {
            "default": "Old variety from Italy’s Adriatic coast made in a variety of styles.",
            "julie": "",
            "sommelier": "Passerina is Italy’s Adriatic coast in a glass: zesty, floral, and bursting with citrus and stone fruit, this high-acid charmer dances lightly on the palate, making it the perfect companion for seaside afternoons and convivial tables alike.",
        },
        "color": "white",
        "regions": ["Marche", "Abruzzo", "Italy (Adriatic coast)"],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "floral",
            "mineral",
            "apple",
            "pear",
            "lemon",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pavana",
        "synonyms": [
            "Nera Gentile di Fonzaso",
            "Nostrana Nera",
            "Pelosetta",
            "Ussulara",
            "Vicentina",
            "Visentina",
        ],
        "description": {
            "default": "Much diminished, now highly localized, northern Italian.",
            "julie": "",
            "sommelier": "Pavana is a northern Italian gem, weaving together red and black fruit with a rustic herbal-earthy charm—think of it as the soulful storyteller of Trentino and Veneto, perfect for those who crave a taste of Italy’s hidden traditions in a glass.",
        },
        "color": "black",
        "regions": ["Trentino", "Veneto", "Northern Italy"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pecorino",
        "synonyms": [
            "Arquitano",
            "Norcino",
            "Pecorina Arquatanella",
            "Pecorino di Osimo",
            "Promotico",
            "Uva delle Pecore",
            "Uva Pecorina",
            "Vissanello",
        ],
        "description": {
            "default": "Marche speciality enjoying a certain modishness. Mineral or herbal dry whites.",
            "julie": "",
            "sommelier": "Pecorino is the zesty darling of central Italy, delivering a lively medley of citrus, pear, and wild herbs wrapped in a mineral embrace—think of it as a mountain breeze in a glass, perfect for those who crave both refreshment and character. This high-acid, medium-bodied white is a sommelier’s secret weapon for cutting through rich dishes or simply sipping in style.",
        },
        "color": "white",
        "regions": ["Marche", "Abruzzo", "Lazio", "Umbria"],
        "flavor_profile": ["herbal", "mineral", "citrus", "floral", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Pedral",
        "synonyms": [
            "Alvarinho Tinto",
            "Cainho dos Milagres",
            "Cainho Espanhol",
            "Dozal",
            "Padral",
            "Pardal",
            "Pedrol",
            "Pégudo",
            "Perna de Perdiz",
            "Verdejo Colorado",
        ],
        "description": {
            "default": "Rare Minho variety, now more common (just) over the border in Spain and found in blends.",
            "julie": "",
            "sommelier": "Pedral is the elusive black pearl of the Minho and Galicia, offering a charming medley of raspberry, cherry, and wild herbs in a light, easy-drinking style. With its floral lift and earthy undertones, this grape brings a whisper of tradition and a dash of Iberian intrigue to every glass.",
        },
        "color": "black",
        "regions": ["Minho", "Galicia", "Rías Baixas", "Vinho Verde"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "herbal",
            "earth",
            "raspberry",
            "cherry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "light_bodied",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pedro Giménez",
        "synonyms": ["Pedro Jiménez"],
        "description": {
            "default": "Quantitatively if not qualitatively important Argentine white unrelated to Spain’s Pedro Ximénez.",
            "julie": "",
            "sommelier": "Pedro Giménez is Argentina’s unsung white grape hero, delivering a refreshing medley of citrus, stone fruit, and delicate floral notes in a light, easy-drinking style. Perfect for sunny afternoons, this unoaked charmer is a far cry from its Spanish namesake, offering a crisp, lively sip that’s as friendly as a Mendoza vineyard picnic.",
        },
        "color": "white",
        "regions": ["Argentina", "Mendoza", "San Juan"],
        "flavor_profile": ["citrus", "stone_fruit", "floral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "blend",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Pedro Ximénez",
        "synonyms": [
            "Corinto Bianco",
            "Don Bueno",
            "Pedro Jimenez",
            "Pedro Ximenes",
            "Perrum",
            "PX",
            "Verdello",
            "Ximenes",
        ],
        "description": {
            "default": "Andalucía’s variety used mainly for some of the darkest, stickiest wines made anywhere.",
            "julie": "",
            "sommelier": "Pedro Ximénez is the hedonist of the wine world, delivering unctuous, velvety wines that taste like liquid fruitcake drizzled with honey and espresso. Grown under the Andalusian sun, PX is the secret behind Spain’s most decadent, age-worthy dessert wines—think Christmas pudding in a glass!",
        },
        "color": "white",
        "regions": ["Andalucía", "Montilla-Moriles", "Jerez", "Spain"],
        "flavor_profile": ["dried_fruit", "honey", "nuts", "chocolate", "coffee"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Very full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "fortified",
            "full_bodied",
            "oaked",
            "varietal",
            "traditional",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Pelaverga",
        "synonyms": [
            "Cari",
            "Pelaverga di Pagno",
            "Pelaverga Grosso",
            "Uva Coussa",
            "Uva delle Zucche",
        ],
        "description": {
            "default": "The more commonly planted, big-berried Pelaverga, often blended with Nebbiolo and/or Barbera in Piemonte.",
            "julie": "",
            "sommelier": "Pelaverga is Piemonte’s playful secret, offering a light-bodied red that bursts with cherry, rose petals, and a signature peppery kick—think of it as Nebbiolo’s charming, spicy cousin, perfect for those who crave freshness and flair in their glass.",
        },
        "color": "black",
        "regions": ["Piemonte", "Verduno", "Italy"],
        "flavor_profile": ["red_fruit", "floral", "spice", "cherry", "pepper"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "varietal",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Pelaverga Piccolo",
        "synonyms": ["Pelaverga di Verduno"],
        "description": {
            "default": "Fashionable if relatively minor Piemontese making light, fruity, spicy varietal reds.",
            "julie": "",
            "sommelier": "Pelaverga Piccolo is Piedmont’s playful secret, offering a flirtatious swirl of raspberry, rose petals, and a peppery wink—perfect for those who like their reds light on their feet and bursting with personality. This is the wine to pour when you want to impress with something rare, spicy, and utterly delightful.",
        },
        "color": "black",
        "regions": ["Piedmont", "Verduno"],
        "flavor_profile": ["red_fruit", "spice", "floral", "raspberry", "pepper"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Peloursin",
        "synonyms": [
            "Corsin",
            "Fumette",
            "Feunette",
            "Gros Béclan",
            "Pelossard",
            "Péloursin",
            "Pourret",
            "Pourrot",
        ],
        "description": {
            "default": "From Isère, now mostly of historical and genetic significance.",
            "julie": "",
            "sommelier": "Once a hidden gem of the French Alps, Peloursin delivers a bold, full-bodied red brimming with black fruit, plum, and earthy spice—think of it as the mysterious ancestor at a family reunion, full of stories and character, waiting to be rediscovered.",
        },
        "color": "black",
        "regions": ["Isère", "Savoie", "Jura", "Rhône Valley"],
        "flavor_profile": ["black_fruit", "plum", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": ["red", "full_bodied", "varietal", "blend", "traditional"],
    },
    {
        "name": "Perera",
        "synonyms": ["Perera Gialla", "Pevarise"],
        "description": {
            "default": "Old variety of the Veneto used to perfume passito and sparkling wines in Prosecco country.",
            "julie": "",
            "sommelier": "Perera is the secret aromatic weapon of Veneto, infusing Prosecco blends with a fragrant bouquet of orchard blossoms, ripe pears, and a whisper of dried fruit. Light on its feet yet bursting with zesty acidity, this grape brings a playful elegance to both sparkling celebrations and decadent dessert wines.",
        },
        "color": "white",
        "regions": ["Veneto"],
        "flavor_profile": ["floral", "stone_fruit", "apple", "pear", "dried_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "sparkling", "dessert", "blend", "traditional"],
    },
    {
        "name": "Perle",
        "synonyms": ["Perle von Alzey"],
        "description": {
            "default": "Pink-berried German cross with a hint of its rose-like parental perfume but short on freshness.",
            "julie": "",
            "sommelier": "Perle is a charming German grape that enchants with delicate floral and stone fruit notes, reminiscent of a stroll through a blooming rose garden. Light-bodied and low in alcohol, it’s the perfect companion for a sunny afternoon, offering easy-drinking pleasure without pretense.",
        },
        "color": "pink",
        "regions": ["Germany", "Rheinhessen", "Pfalz"],
        "flavor_profile": ["floral", "stone_fruit"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Perricone",
        "synonyms": [
            "Catarratto Rouge",
            "Niuru",
            "Perricone Nero",
            "Pignateddu",
            "Pignatello",
            "Pirricuni",
            "Tuccarinu",
        ],
        "description": {
            "default": "Dark-skinned, relatively tannic Sicilian, often blended with Nero d’Avola.",
            "julie": "",
            "sommelier": "Perricone is Sicily’s brooding black beauty, delivering a bold, full-bodied red brimming with blackberry, plum, and earthy spice, all wrapped in a firm tannic embrace. Whether solo or blended, this grape brings a rustic charm and age-worthy depth that’s as captivating as a Sicilian sunset.",
        },
        "color": "black",
        "regions": ["Sicily", "Italy"],
        "flavor_profile": [
            "black_fruit",
            "plum",
            "blackberry",
            "spice",
            "earth",
            "herbal",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "full_bodied",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Perruno",
        "synonyms": [
            "Casta de Montúo",
            "Firmissima",
            "Getibi",
            "Granadina",
            "Jetibi",
            "Morata",
            "Perruna",
            "Perruno Común",
            "Perruno de Arcos",
            "Perruno de la Sierra",
            "Perruno Duro",
            "Perruno Fino",
            "Perruno Tierno",
            "Vidueño",
        ],
        "description": {
            "default": "Old Extremaduran variety with a lone supporter in Andalucía.",
            "julie": "",
            "sommelier": "Perruno is a charming relic of Spain’s viticultural past, offering a delicate dance of citrus and stone fruit with a whisper of minerality. Light-bodied and easygoing, this rare Andalusian white is perfect for those seeking a refreshing sip of history.",
        },
        "color": "white",
        "regions": ["Extremadura", "Andalucía"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "table_wine",
            "traditional",
            "early_drinking",
            "varietal",
            "blend",
        ],
    },
    {
        "name": "Persan",
        "synonyms": [
            "Beccu",
            "Bécuet",
            "Becuét",
            "Bécuette",
            "Berla‘d Crava Cita",
            "Berlo Citto",
            "Etraire",
            "Etris",
            "Princens",
            "Prinsens",
            "Serine",
            "Siranne",
        ],
        "description": {
            "default": "Rare but high-quality Savoie variety on a voyage of rediscovery.",
            "julie": "",
            "sommelier": "Persan is the Savoie region’s hidden gem, offering a vibrant medley of cherry, plum, and peppery spice wrapped in a lively, medium-bodied frame. This rare grape is a sommelier’s delight—earthy, age-worthy, and ready to charm adventurous palates seeking a taste of Alpine tradition.",
        },
        "color": "black",
        "regions": ["Savoie", "Isère", "Piedmont"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
            "blackberry",
            "pepper",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "traditional",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Pervenets Magaracha",
        "synonyms": ["Pervenec Magaraca", "Pervenyec Magaracsa"],
        "description": {
            "default": "Recent Ukrainian cross notably resistant to downy mildew and used for dry and sweet wines.",
            "julie": "",
            "sommelier": "Pervenets Magaracha is Ukraine’s resilient white gem, offering a lively medley of citrus, stone fruit, and delicate floral notes over a crisp mineral backbone. Perfect for both dry and sweet wines, this grape charms with its versatility and easy-drinking style—think of it as the Black Sea’s answer to a summer breeze in a glass.",
        },
        "color": "white",
        "regions": ["Ukraine", "Crimea", "Black Sea region"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "medium_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Petit Bouschet",
        "synonyms": [
            "Aramon-Teinturier",
            "Bouschet Petit",
            "Negrón de Aldán",
            "Tintinha",
        ],
        "description": {
            "default": "Disappearing red-juiced nineteenth-century southern French cross.",
            "julie": "",
            "sommelier": "Once a star in southern French blends, Petit Bouschet is a disappearing act with a flair for drama—its inky juice brings vibrant color and a medley of red and black fruits, earthy undertones, and a whisper of spice to the glass. This medium-bodied grape is a nostalgic nod to the past, perfect for those who savor history with their wine.",
        },
        "color": "black",
        "regions": ["Languedoc", "Provence", "Southern France"],
        "flavor_profile": ["red_fruit", "black_fruit", "earth", "spice"],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Petit Courbu",
        "synonyms": [
            "Courbis",
            "Courbu Petit",
            "Petit Courbu Blanc",
            "Vieux Pacherenc",
            "Xuri Zerratu",
        ],
        "description": {
            "default": "Minor but high-quality, aromatic Jurançon speciality.",
            "julie": "",
            "sommelier": "Petit Courbu is the secret jewel of Southwest France, dazzling with zesty citrus, lush stone fruit, and a whisper of honeyed florals, all wrapped in a lively, mineral embrace. This high-acid charmer brings both freshness and finesse, perfect for adventurous palates craving a taste of tradition and terroir.",
        },
        "color": "white",
        "regions": ["Jurançon", "Southwest France", "Pacherenc du Vic-Bilh"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral", "honey"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "blend",
            "varietal",
            "medium_bodied",
            "unoaked",
            "traditional",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Petit Manseng",
        "synonyms": [
            "Izkiriot Ttipi",
            "Iskiriota Zuri Tipia",
            "Ichiriota Zuria Tipia",
            "Manseng Petit Blanc",
            "Mansengou",
        ],
        "description": {
            "default": "High-quality variety making superb sweet wines in south-western France.",
            "julie": "",
            "sommelier": "Petit Manseng dazzles with a symphony of citrus, stone fruit, and honeyed tropical notes, all lifted by electrifying acidity—think of it as the acrobat of dessert wines, balancing richness and freshness with effortless grace. This grape crafts age-worthy, full-bodied whites that are as enchanting as the misty hillsides of Jurançon where they’re born.",
        },
        "color": "white",
        "regions": [
            "Jurançon",
            "Pacherenc du Vic-Bilh",
            "South-West France",
            "Irouléguy",
        ],
        "flavor_profile": [
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "floral",
            "honey",
            "mineral",
        ],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "premium",
            "age_worthy",
            "reserve",
            "traditional",
        ],
    },
    {
        "name": "Petit Meslier",
        "synonyms": ["Melié Blanc", "Meslier Doré", "Meslier Jaune", "Meslier Petit"],
        "description": {
            "default": "Extremely rare, light-berried potential champagne ingredient with significant relatives and a lone outpost in Australia.",
            "julie": "",
            "sommelier": "Petit Meslier is Champagne’s secret weapon: a zippy, citrus-charged grape that brings electric acidity and a bouquet of orchard and wildflower notes to sparkling blends. Elusive and enchanting, it’s a sommelier’s delight for those who crave a taste of vinous rarity.",
        },
        "color": "white",
        "regions": ["Champagne", "Australia"],
        "flavor_profile": ["citrus", "apple", "floral", "herbal", "mineral"],
        "acidity": "Very high",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "blend",
            "varietal",
            "light_bodied",
            "unoaked",
            "traditional",
            "age_worthy",
        ],
    },
    {
        "name": "Petit Rouge",
        "synonyms": ["Oriou", "Picciourouzo"],
        "description": {
            "default": "Old, dark-skinned Aostan producing spicy, redcurrant-flavoured wines.",
            "julie": "",
            "sommelier": "Petit Rouge is the spirited heart of the Aosta Valley, delivering vibrant, spicy redcurrant and raspberry notes wrapped in earthy intrigue—think of it as a mountain breeze in a glass, perfect for those who crave both freshness and character.",
        },
        "color": "black",
        "regions": ["Aosta Valley", "Italy"],
        "flavor_profile": ["red_fruit", "spice", "raspberry", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Petit Verdot",
        "synonyms": ["Lambrusquet", "Verdau", "Verdot", "Verdot Petit"],
        "description": {
            "default": "High-quality, late-ripening Bordeaux variety adding colour and spice to blends there but making an increasing number of solo appearances elsewhere.",
            "julie": "Petit Verdot produces wines which are powerful, rich, deeply coloured, tannic and ageworthy. Small plantings are found in the region of Bordeaux, where it originates, and where it is still used in blends. The grape is also planted in various countries such as USA (California), Argentina and Australia. ",
            "sommelier": "Petit Verdot is the brooding poet of the Bordeaux family—inky, intense, and brimming with black fruit, spice, and a peppery edge. Whether adding backbone to a blend or starring solo, this grape delivers a bold, full-bodied wine that rewards patience and adventurous palates alike.",
        },
        "color": "black",
        "regions": ["Bordeaux", "California", "Argentina", "Australia"],
        "flavor_profile": [
            "black_fruit",
            "spice",
            "earth",
            "plum",
            "blackberry",
            "pepper",
        ],
        "acidity": "Medium",
        "tannin": "High",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "blend",
            "varietal",
            "traditional",
            "modern",
            "premium",
            "reserve",
            "age_worthy",
        ],
    },
    {
        "name": "Petite Amie",
        "synonyms": ["DM 8313.1"],
        "description": {
            "default": "Recent and promisingly aromatic American hybrid planted in Nebraska.",
            "julie": "",
            "sommelier": "Petite Amie is Nebraska’s charming new white, bursting with floral, citrus, and stone fruit notes, and zippy high acidity that dances on the palate. Light-bodied and unoaked, this early-drinking hybrid is a delightful Midwest answer to your summer wine cravings.",
        },
        "color": "white",
        "regions": ["Nebraska", "Midwestern United States"],
        "flavor_profile": ["floral", "citrus", "stone_fruit"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Petite Pearl",
        "synonyms": ["TP 2-1-24"],
        "description": {
            "default": "Promising new cold-hardy American hybrid.",
            "julie": "",
            "sommelier": "Petite Pearl is the northern star of American hybrids, delivering a vibrant medley of black fruit, cherry, and earthy spice wrapped in a lively, high-acid frame—perfect for those seeking a bold yet approachable red from the coldest corners of the vineyard world.",
        },
        "color": "black",
        "regions": [
            "Minnesota",
            "Wisconsin",
            "Vermont",
            "New York",
            "Iowa",
            "Canada (Ontario, Quebec)",
        ],
        "flavor_profile": ["black_fruit", "cherry", "plum", "spice", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "medium_bodied",
            "full_bodied",
            "varietal",
            "blend",
            "oaked",
            "unoaked",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Petra",
        "synonyms": ["Petka"],
        "description": {
            "default": "Serbian hybrid producing full-bodied, aromatic whites.",
            "julie": "",
            "sommelier": "Petra is Serbia’s aromatic white gem, delivering a full-bodied embrace of floral, stone fruit, and tropical flavors, all wrapped in a lush, high-alcohol package. This hybrid grape is perfect for those who crave a bold, fragrant white that’s as lively as a Balkan summer.",
        },
        "color": "white",
        "regions": ["Serbia"],
        "flavor_profile": ["floral", "stone_fruit", "citrus", "tropical_fruit"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "white",
            "full_bodied",
            "varietal",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Petrokoritho",
        "synonyms": ["Petrocoritho", "Pietro Corinto"],
        "description": {
            "default": "Greek island variety of which the white mutation is the stronger survivor.",
            "julie": "",
            "sommelier": "Petrokoritho is the zesty island survivor of Greece, delivering a breezy bouquet of citrus, stone fruit, and wild herbs, all wrapped in a mineral embrace. Light-bodied and lively, it’s the perfect companion for sun-drenched afternoons and seaside feasts.",
        },
        "color": "white",
        "regions": ["Greek Islands", "Aegean Islands", "Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral", "herbal"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Petroulianos",
        "synonyms": ["Petrolianos"],
        "description": {
            "default": "Rare but promising vine from the southern tip of Greece’s Pelopónnisos (Peloponnese).",
            "julie": "",
            "sommelier": "Petroulianos is a hidden gem from Greece’s sun-drenched Peloponnese, dazzling with zesty citrus, juicy stone fruit, and a mineral streak that sings of its coastal terroir. With high acidity and a floral lift, this unoaked white is a crisp, vivacious companion for Mediterranean fare or a sunny afternoon.",
        },
        "color": "white",
        "regions": ["Peloponnese", "Southern Greece"],
        "flavor_profile": ["citrus", "stone_fruit", "mineral", "floral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "unoaked",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Phoenix",
        "synonyms": ["Geilweilerhof GA-49-22"],
        "description": {
            "default": "Disease-resistant German hybrid producing fresh and lightly aromatic wines in the UK.",
            "julie": "",
            "sommelier": "Phoenix is the zesty, garden-fresh charmer of the white wine world, delivering a lively bouquet of citrus, apple, and pear with a crisp, mineral edge—perfect for those who crave a refreshing, easy-drinking glass from the cool vineyards of the UK and Germany.",
        },
        "color": "white",
        "regions": ["United Kingdom", "Germany"],
        "flavor_profile": ["citrus", "floral", "mineral", "apple", "pear"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Low",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Picapoll Blanco",
        "synonyms": [
            "Blanca Extra",
            "Clairette Blanche",
            "Picapoll",
            "Picapolla Blanca",
        ],
        "description": {
            "default": "Minor Catalan that may be the same as France’s Clairette Blanche.",
            "julie": "",
            "sommelier": "Picapoll Blanco is a charming Mediterranean white, offering a breezy bouquet of citrus, stone fruit, and wildflowers, underpinned by a gentle herbal-mineral freshness. Light on its feet and easygoing, it’s the perfect companion for sun-drenched afternoons and lively Catalan feasts.",
        },
        "color": "white",
        "regions": ["Catalonia", "Languedoc", "Roussillon", "Provence", "Rhône Valley"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "herbal", "mineral"],
        "acidity": "Low",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Picardan",
        "synonyms": [
            "Aragnan",
            "Aragnan Blanc",
            "Araignan Blanc",
            "Gallet",
            "Gallet Blanc",
            "Grosse Clairette",
            "Milhaud Blanc",
            "Papadoux",
            "Oeillade Blanche",
            "Picardan Blanc",
        ],
        "description": {
            "default": "Occasionally adds acidity to Châteauneuf.",
            "julie": "",
            "sommelier": "Picardan is the secret zesty spark in Châteauneuf-du-Pape whites, bringing a lively citrus and floral lift with a mineral edge—think of it as the grape that keeps the party crisp and refreshing in every blend.",
        },
        "color": "white",
        "regions": ["Southern Rhône", "Châteauneuf-du-Pape", "France"],
        "flavor_profile": ["citrus", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": ["white", "blend", "traditional", "table_wine"],
    },
    {
        "name": "Piccola Nera",
        "synonyms": ["Mala Cerna", "Nera Tenera"],
        "description": {
            "default": "Makes very pale reds in the hinterland of Trieste.",
            "julie": "",
            "sommelier": "Piccola Nera is the ballerina of the wine world—delicate, light on its feet, and bursting with raspberry and cherry notes, making it a perfect companion for a sun-dappled afternoon in Trieste or a lively table in Friuli. Its pale hue and floral lift promise a graceful, easy-drinking experience that dances across the palate.",
        },
        "color": "pink",
        "regions": ["Friuli-Venezia Giulia", "Trieste", "Slovenia"],
        "flavor_profile": ["red_fruit", "floral", "raspberry", "cherry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "early_drinking",
            "varietal",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Picolit",
        "synonyms": ["Pikolit"],
        "description": {
            "default": "Ancient Friulian producing small quantities of highly regarded sweet wines.",
            "julie": "",
            "sommelier": "Picolit is the crown jewel of Friuli, yielding golden, nectar-like wines brimming with honeyed stone fruit and delicate florals—an opulent treat reserved for those who appreciate rarity and finesse in their glass.",
        },
        "color": "white",
        "regions": ["Friuli", "Friuli-Venezia Giulia", "Italy"],
        "flavor_profile": [
            "stone_fruit",
            "dried_fruit",
            "floral",
            "honey",
            "pear",
            "peach",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Full",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "dessert",
            "full_bodied",
            "varietal",
            "premium",
            "reserve",
            "age_worthy",
            "traditional",
        ],
    },
    {
        "name": "Piculit Neri",
        "synonyms": ["Picolit Neri", "Picolit Nero"],
        "description": {
            "default": "Old, rare, small-berried red wine variety unrelated to Picolit.",
            "julie": "",
            "sommelier": "Piculit Neri is a hidden gem from Friuli-Venezia Giulia, offering a beguiling medley of cherry, plum, and earthy spice in a medium-bodied, age-worthy red—perfect for those who crave the thrill of rare Italian treasures in their glass.",
        },
        "color": "black",
        "regions": ["Friuli-Venezia Giulia", "Northeastern Italy"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "spice",
            "earth",
            "cherry",
            "plum",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "varietal",
            "traditional",
            "premium",
            "age_worthy",
            "table_wine",
        ],
    },
    {
        "name": "Piedirosso",
        "synonyms": [
            "Palombina",
            "Palumbina",
            "Palumbo",
            "Palummina",
            "Per’e Palummo",
            "Streppa Verde",
        ],
        "description": {
            "default": "Fresh, aromatic Campanian that makes an ideal blending partner for Aglianico but can also shine as a varietal.",
            "julie": "",
            "sommelier": "Piedirosso is Campania’s vivacious black grape, bursting with cherry and raspberry, a hint of wildflowers, and a spicy, earthy backbone—think of it as the life of the southern Italian table, equally charming solo or in a blend. With its zippy acidity and medium body, it’s a red that dances on the palate and brings a taste of Naples’ sun-drenched hills to your glass.",
        },
        "color": "black",
        "regions": ["Campania", "Italy"],
        "flavor_profile": [
            "red_fruit",
            "cherry",
            "raspberry",
            "floral",
            "spice",
            "earth",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "traditional",
            "table_wine",
            "early_drinking",
            "medium_bodied",
        ],
    },
    {
        "name": "Pignola Valtellinese",
        "synonyms": [
            "Groppello di Breganze",
            "Pignola",
            "Pignola Spanna",
            "Pignolo Spano",
        ],
        "description": {
            "default": "Minor red wine grape grown in Lombardia and Piemonte, and in the Veneto as the recently rescued Groppello di Breganze.",
            "julie": "",
            "sommelier": "Pignola Valtellinese is a charmingly rare Italian red, bursting with bright cherry and raspberry, laced with floral and earthy undertones, and finishing with a lively acidity that makes it a delightful companion to rustic fare. This light-bodied gem is a sommelier’s secret for those seeking a taste of northern Italy’s hidden treasures.",
        },
        "color": "black",
        "regions": ["Lombardia", "Piemonte", "Veneto"],
        "flavor_profile": [
            "red_fruit",
            "floral",
            "mineral",
            "earth",
            "cherry",
            "raspberry",
        ],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pignoletto",
        "synonyms": [
            "Grechetto di Todi",
            "Grechetto Gentile",
            "Occhietto",
            "Pallagrello di Caserta",
            "Pignoletto Bolognese",
            "Pignolino",
            "Pulcinculo",
            "Rébola",
            "Ribolla Riminese",
            "Strozzavolpe",
        ],
        "description": {
            "default": "Light, refreshing variety quite widely planted in the Bologna hills and in Umbria.",
            "julie": "",
            "sommelier": "Pignoletto is the zesty charmer of Emilia-Romagna, bursting with citrus and stone fruit, a floral breeze, and a mineral snap—perfect for those who crave a lively, unoaked white that dances on the palate. Whether still or sparkling, it’s the Italian answer to your thirst for refreshment and fun.",
        },
        "color": "white",
        "regions": ["Emilia-Romagna", "Umbria"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pineau D’Aunis",
        "synonyms": [
            "Aunis",
            "Chenin Noir",
            "Gros Pineau",
            "Gros-Véronais",
            "Plant d’Aunis",
            "Plant de Mayet",
        ],
        "description": {
            "default": "Ancient, light and underrated Loire variety, often used for rosé but capable of interesting reds.",
            "julie": "",
            "sommelier": "Pineau D’Aunis is the Loire Valley’s best-kept secret, delivering a lively dance of raspberry, pepper, and wild herbs in a feather-light frame—think of it as Pinot Noir’s eccentric, spice-loving cousin, perfect for adventurous palates seeking something refreshingly different.",
        },
        "color": "black",
        "regions": ["Loire Valley", "Anjou", "Touraine"],
        "flavor_profile": [
            "red_fruit",
            "spice",
            "herbal",
            "floral",
            "earth",
            "raspberry",
            "pepper",
            "cherry",
        ],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "rosé",
            "light_bodied",
            "unoaked",
            "varietal",
            "traditional",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pinella",
        "synonyms": ["Mattozza", "Pinela", "Pinjela", "Pinola"],
        "description": {
            "default": "Minor variety from the hills south of Padova, also grown in neighbouring Slovenia.",
            "julie": "",
            "sommelier": "Pinella is a charmingly obscure Venetian-Slovenian white, bursting with zesty citrus, delicate stone fruit, and a whisper of wildflowers—think of it as a breezy hillside picnic in a glass, perfect for those who crave freshness and subtlety in their wine.",
        },
        "color": "white",
        "regions": ["Veneto (Italy)", "Slovenia"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pinot Noir",
        "synonyms": [
            "Auvernat",
            "Auvernas",
            "Black Burgundy",
            "Blauburgunder",
            "Blauer Arbst",
            "Blauer Spätburgunder",
            "Bourguignon",
            "Burgunder",
            "Cerna",
            "Clevner",
            "Klävner",
            "Cortaillod",
            "Kék Burgundi",
            "Kisburgundi",
            "Klebroth",
            "Moréote",
            "Morillon",
            "Morillon Noir",
            "Mourillon",
            "Noirien",
            "Noirin",
            "Orléanais",
            "Pineau Noir",
            "Pino Fran and Pino Ceren",
            "Pinot Cernii",
            "Pinot Liébault",
            "Pinot Nero",
            "Plant Doré",
            "Rulandské Modré",
            "Savagnin Noir",
            "Salvagnin Noir",
            "Servagnin",
            "Spätburgunder",
            "Vert Doré",
        ],
        "description": {
            "default": "Finicky Burgundian vine produces wildly variable, relatively delicate, potentially haunting essences of place.",
            "julie": "An incredibly elegant red grape variety thay thrives in cool climate area. King variety of red Burgundy wines, it also produces excellent wines in Germany under the name späburgunder, Austria, New Zealand, Tasmania, Oregon, etc. It is also the major components in many traditional method sparkling wines. ",
            "sommelier": "Pinot Noir is the enigmatic poet of the wine world—delicate yet profound, with a silken texture and a symphony of red and black fruits, spice, and a whisper of earth. Whether in Burgundy or beyond, it seduces with haunting elegance and a finish that lingers like a fond memory.",
        },
        "color": "black",
        "regions": [
            "Burgundy",
            "Germany",
            "Austria",
            "New Zealand",
            "Tasmania",
            "Oregon",
        ],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "blackberry",
            "stone_fruit",
            "vanilla",
            "spice",
            "pepper",
            "nuts",
        ],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "traditional",
            "modern",
            "age_worthy",
        ],
    },
    {
        "name": "Pinot Meunier",
        "synonyms": [
            "Auvernat Blanc",
            "Gris Meunier",
            "Meunier",
            "Morillon Taconné",
            "Müllerrebe",
            "Samtrot",
            "Schwarzriesling",
        ],
        "description": {
            "default": "Fruity blending ingredient for top-quality sparkling wine.",
            "julie": "Pinot Meunier is a key player in the production of Champagne. The grapes contributes to adding softeness, juiciness and yellow fruit aromas and flavours to the wines. 100% Pinot Meunier Champagne are more commonly seen than in the past but the grape is rarely sold as a still wine. ",
            "sommelier": "Pinot Meunier is Champagne’s secret weapon, lending a playful burst of red and stone fruits, apple, and pear to sparkling blends, with a floral lift and a juicy, easygoing charm. Though rarely bottled solo, this grape’s high acidity and soft touch make it the life of the sparkling party—effervescent, approachable, and always ready to celebrate.",
        },
        "color": "black",
        "regions": ["Champagne", "France", "Germany", "England", "Australia"],
        "flavor_profile": ["red_fruit", "stone_fruit", "apple", "pear", "floral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "sparkling",
            "blend",
            "light_bodied",
            "traditional",
            "varietal",
            "early_drinking",
        ],
    },
    {
        "name": "Pinot Grigio",
        "description": {
            "default": "The Pinot Grigio we are all accustomed to tends to exhibit white peach notes, slight citrus tings and a hint of pear. An element of perfume and light spice round off what is a light, easy-sipping white, while you may also experience additional flavours of honeysuckle, green apple or even grapefruit.",
            "julie": "",
            "sommelier": "Pinot Grigio is the ultimate crowd-pleaser: a zesty, high-acid white that dances with notes of white peach, pear, and honeysuckle, finishing with a whisper of spice. Light on its feet and endlessly refreshing, it’s the perfect companion for sun-drenched afternoons and lively gatherings.",
        },
        "synonyms": [],
        "color": "pink",
        "regions": [
            "Italy",
            "France (Alsace)",
            "Germany",
            "United States (Oregon)",
            "United States (California)",
        ],
        "flavor_profile": [
            "stone_fruit",
            "citrus",
            "pear",
            "apple",
            "peach",
            "lemon",
            "floral",
            "spice",
            "honey",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "varietal",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Pinot Gris",
        "synonyms": [
            "Auvernat Gris",
            "Beurot",
            "Burgunder Roter",
            "Friset",
            "Fromenteau",
            "Fromenteau Gris",
            "Grauburgunder",
            "Grauer Burgunder",
            "Grauer Clevner",
            "Griset",
            "Kleiner Traminer",
            "Malvoisie",
            "Pinot Beurot",
            "Pirosburgundi",
            "Râjik",
            "Ruländer",
            "Rulandské Šedé",
            "Rulandské Sivé",
            "Sivi Pinot",
            "Speyeren",
            "Szürkebarát",
            "Tokay",
        ],
        "description": {
            "default": "Full-bodied and aromatic at its best but much more usually encountered enjoying international fame if not glory as anodyne Pinot Grigio.",
            "julie": "Wines labelled as Pinot Gris tend to have body, texture a good aromatic intensity reminescent of stone fruits, flowers and spices. Wines labelled as Pinot Grigio, however made from the same grape variety, are generarlly light, crisp and farily neutral. ",
            "sommelier": "Pinot Gris is the ultimate shape-shifter of the wine world, offering everything from lush, aromatic, stone-fruited opulence to zesty, refreshing sips under its Pinot Grigio alias. With flavors dancing from pear and peach to almond and spice, this pink-skinned grape is a globe-trotting charmer that pairs as easily with seafood as it does with blue cheese and honeyed desserts.",
        },
        "color": "pink",
        "regions": [
            "Alsace",
            "Italy (Veneto, Friuli)",
            "Germany",
            "Austria",
            "Hungary",
            "Oregon",
            "New Zealand",
        ],
        "flavor_profile": [
            "stone_fruit",
            "tropical_fruit",
            "dried_fruit",
            "floral",
            "spice",
            "vegetal",
            "citrus",
            "pear",
            "peach",
            "lemon",
            "butter",
            "nuts",
            "honey",
        ],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "medium_bodied",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "premium",
            "reserve",
            "age_worthy",
            "early_drinking",
            "dessert",
        ],
    },
    {
        "name": "Pinot Blanc",
        "synonyms": [
            "Auvernat Blanc",
            "Beli Pinot",
            "Burgunder Veisser",
            "Chardonnet Pinot Blanc",
            "Pinot Blanc Chardonnet",
            "Clevner",
            "Klävner",
            "Fehér Burgundi",
            "Pino Belîi",
            "Pinot Bianco",
            "Pinot Bijeli",
            "Pinot Blanc Vrai",
            "Pinot Branco",
            "Rulandské Biele",
            "Rulandské Bílé",
            "Weissburgunder",
            "Weisser Burgunder",
            "Burgunder Weiss",
        ],
        "description": {
            "default": "Possibly underrated producer of friendly, medium-bodied, confident whites. Easy to ripen.",
            "julie": "For years Pinot Blanc has been mistaken for Chardonnay as the grapes look very similar..Pinot Blanc, however is a colour mutation of Pinot Noir and is mostly found in Alsace where it is used for the production of Crémants but also for the production of elegant, fresh and moderatly complex white wines. The variety is known as Pinot Bianco in Italy and Weissburgunder in Austria and Germany, two countries that produces some exceptionnally good examples of the variety. ",
            "sommelier": "Pinot Blanc is the quiet achiever of the white wine world—delicate yet confident, with subtle notes of apple, pear, and a whisper of nuts, all wrapped in a refreshing, food-loving acidity. Whether sparkling in Alsace or crisp in Austria, it’s the perfect companion for a sunny terrace or a seafood feast.",
        },
        "color": "white",
        "regions": ["Alsace", "Italy", "Austria", "Germany"],
        "flavor_profile": [
            "apple",
            "pear",
            "citrus",
            "stone_fruit",
            "tropical_fruit",
            "nuts",
        ],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "sparkling",
            "light_bodied",
            "medium_bodied",
            "unoaked",
            "varietal",
            "blend",
            "traditional",
            "table_wine",
            "premium",
            "early_drinking",
        ],
    },
    {
        "name": "Pinot Teinturier",
        "synonyms": ["Farbclevner", "Pinot Fin Teinturier"],
        "description": {
            "default": "Red-fleshed Pinot mutation.",
            "julie": "",
            "sommelier": "Pinot Teinturier is the black sheep of the Pinot family—literally—with its red-fleshed berries lending a dramatic splash of color and a lively mix of cherry, plum, and earthy minerality to the glass. This medium-bodied marvel is a sommelier’s secret weapon for adding both depth and intrigue to blends or standing proudly on its own.",
        },
        "color": "black",
        "regions": ["France", "Germany", "Switzerland"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "mineral",
            "cherry",
            "plum",
            "raspberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "blend",
            "varietal",
            "medium_bodied",
            "table_wine",
            "traditional",
        ],
    },
    {
        "name": "Pinot Noir Précoce",
        "synonyms": [
            "Augustclevner",
            "Augusttraube",
            "Blauer Frühburgunder",
            "Frühburgunder",
            "Ischia",
            "Vigne d’Ischia",
            "Jacobstraube",
            "Jakobstraube",
            "Juliustraube",
            "Madeleine Noire",
            "Möhrchen",
            "Morillon Noir Hâtif",
            "Pinot Hâtif de Rilly",
            "Pinot Madeleine",
            "Pinot Précoce",
            "Pinot Précoce Noir",
            "Raisin de la Madeleine",
        ],
        "description": {
            "default": "Early-ripening mutation of Pinot Noir that is currently popular in Germany as Frühburgunder.",
            "julie": "",
            "sommelier": "Pinot Noir Précoce is the sprightly, early-bird cousin of Pinot Noir, delivering a charming medley of cherry and raspberry with a whisper of earth and flowers—think of it as Pinot Noir’s playful, easygoing sibling, perfect for those who crave elegance without the wait. Light-bodied and low in tannin, it’s a delightful companion for a summer picnic or a casual dinner with friends.",
        },
        "color": "black",
        "regions": [
            "Germany",
            "Ahr",
            "Rheingau",
            "Rheinhessen",
            "Switzerland",
            "Alsace",
        ],
        "flavor_profile": ["red_fruit", "cherry", "raspberry", "floral", "earth"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "early_drinking",
            "table_wine",
            "premium",
        ],
    },
    {
        "name": "Pinotage",
        "synonyms": ["Perold’s Hermitage × Pinot"],
        "description": {
            "default": "South Africa’s very own cross, both loved and despised.",
            "julie": "",
            "sommelier": "Pinotage is South Africa’s rebellious original, bursting with smoky plum, blackberry, and a hint of coffee—like a campfire breakfast in a glass. Love it or loathe it, this full-bodied, high-octane red is unforgettable and always ready to spark conversation.",
        },
        "color": "black",
        "regions": ["South Africa", "New Zealand", "California", "Brazil"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "earth",
            "smoke",
            "coffee",
            "chocolate",
            "plum",
            "blackberry",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Full",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "full_bodied",
            "oaked",
            "unoaked",
            "varietal",
            "blend",
            "table_wine",
            "premium",
            "age_worthy",
            "early_drinking",
        ],
    },
    {
        "name": "Pinotin",
        "synonyms": ["VB 91-26-19"],
        "description": {
            "default": "Recent, obscure Swiss hybrid.",
            "julie": "",
            "sommelier": "Pinotin is Switzerland’s secret handshake—a modern hybrid grape bursting with juicy cherry, raspberry, and blackberry flavors, all dusted with a whisper of earth and stone. Medium-bodied and delightfully balanced, it’s the perfect companion for those seeking a fresh, early-drinking red with a touch of Alpine intrigue.",
        },
        "color": "black",
        "regions": ["Switzerland"],
        "flavor_profile": [
            "red_fruit",
            "black_fruit",
            "cherry",
            "raspberry",
            "plum",
            "blackberry",
            "earth",
            "mineral",
        ],
        "acidity": "Medium",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "medium_bodied",
            "varietal",
            "blend",
            "modern",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Pionnier",
        "synonyms": ["ES 4-7-25"],
        "description": {
            "default": "Minor but complex, cold-hardy American hybrid used in blends in Québec.",
            "julie": "",
            "sommelier": "Pionnier is the unsung hero of Québec blends, delivering a lively burst of red and black fruits laced with earthy herbs, all wrapped in a brisk, refreshing acidity—think of it as the cool-climate grape that keeps your palate on its toes!",
        },
        "color": "black",
        "regions": ["Québec", "Ontario", "Northeastern United States"],
        "flavor_profile": ["red_fruit", "black_fruit", "herbal", "earth"],
        "acidity": "High",
        "tannin": "Medium",
        "body": "Medium",
        "alcohol": "Medium",
        "wine_styles": ["red", "blend", "table_wine", "early_drinking"],
    },
    {
        "name": "Piquepoul Noir",
        "synonyms": ["Picapoll Negro", "Picapoll Tinta"],
        "description": {
            "default": "DNA profiling has recently shown that PICAPOLL BLANCO, a white variety from Pla de Bages in Catalunya, north-east Spain, already mentioned in the sixteenth century and long considered identical to the French Piquepoul Blanc, is in fact a distinct variety that is much more closely related to CLAIRETTE, possibly a clone (Puig et al. 2006). However, Picapoll Negro has been shown to be identical to Piqupoul Noir (Galet 2000). Piquepoul belongs to the Piquepoul ampelographic group (see p XXVII; Bisson 2009).",
            "julie": "",
            "sommelier": "Piquepoul Noir is a vivacious, light-bodied red that dances on the palate with zesty acidity and a medley of red fruit, floral, and herbal notes—think of it as the life of the Languedoc party, perfect for those who crave a refreshing, early-drinking wine with a dash of history.",
        },
        "color": "black",
        "regions": ["Languedoc", "Southern Rhône", "Catalunya", "Pla de Bages"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "mineral"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "blend",
            "traditional",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Piquepoul Blanc",
        "synonyms": ["Avillo", "Picpoul de Pinet", "Piquepoul de Pinet"],
        "description": {
            "default": "Piquepoul Noir produces pale, alcoholic but aromatic and nervy wines well suited to rosé production and is much less widely planted than the white version – there were just 73 ha (180 acres) in southern France in 2008. Although it is recommended in most French wine-growing départements, and is a permitted variety in Châteauneuf-du-Pape and Côtes du Rhône, it is generally a very minor component in blends, unlike its more successful white mutation. A rare example of a Piquepoul Noir-dominant red wine is Minervois producer Clos Centeille’s C de Centeilles, which is 90% Piquepoul Noir and 10% RIVAIRENC; Domaine La Grangette just south of Pézenas bottle a varietal rosé.",
            "julie": "",
            "sommelier": "Piquepoul Noir is the secret spice of southern France, delivering a zesty, high-acid punch with delicate red fruit, floral, and herbal notes—perfect for lively rosés or as a bright accent in classic blends. Rarely bottled solo, this grape is a true sommelier’s delight for those seeking something off the beaten path.",
        },
        "color": "white",
        "regions": [
            "Languedoc",
            "Rhône Valley",
            "Minervois",
            "Châteauneuf-du-Pape",
            "Côtes du Rhône",
        ],
        "flavor_profile": ["red_fruit", "floral", "herbal", "spice"],
        "acidity": "High",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "High",
        "wine_styles": [
            "red",
            "rosé",
            "blend",
            "varietal",
            "light_bodied",
            "early_drinking",
            "traditional",
            "table_wine",
        ],
    },
    {
        "name": "Plant Droit",
        "synonyms": ["Cinsaut Droit", "Espanenc", "Garnacha Francesa", "Plant Dressé"],
        "description": {
            "default": "Minor and diminishing southern Rhône variety producing rather pale reds.",
            "julie": "",
            "sommelier": "Plant Droit is the wallflower of the southern Rhône, offering a delicate dance of cherry, raspberry, and wild herbs in a light, unoaked frame—perfect for those who prefer their reds with a whisper rather than a shout. This grape is a rare treat, best enjoyed young and in good company.",
        },
        "color": "black",
        "regions": ["Southern Rhône", "Languedoc", "Provence"],
        "flavor_profile": ["red_fruit", "floral", "herbal", "cherry", "raspberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "unoaked",
            "varietal",
            "blend",
            "early_drinking",
            "table_wine",
        ],
    },
    {
        "name": "Planta Nova",
        "synonyms": ["Coma", "Malvasia", "Tardana", "Tortozon", "Tortozón"],
        "description": {
            "default": "Actually very old but generally undistinguished variety grown mainly in Valencia today.",
            "julie": "",
            "sommelier": "Planta Nova, a Valencian classic hiding in plain sight, charms with delicate notes of stone fruit, apple, and a whisper of wildflowers over a crisp, mineral backbone. Light-bodied and lively, it’s the perfect companion for sun-drenched afternoons and spontaneous tapas.",
        },
        "color": "white",
        "regions": ["Valencia", "Spain"],
        "flavor_profile": ["stone_fruit", "apple", "floral", "mineral"],
        "acidity": "Medium",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "light_bodied",
            "unoaked",
            "table_wine",
            "early_drinking",
            "varietal",
        ],
    },
    {
        "name": "Plantet",
        "synonyms": ["Seibel 5455"],
        "description": {
            "default": "Hybrid once popular in the Loire, now producing slightly odd, raspberry-flavoured wines.",
            "julie": "",
            "sommelier": "Plantet, the Loire’s eccentric hybrid, delivers a playful burst of raspberry atop a feather-light frame—think of it as the region’s quirky answer to easygoing reds, perfect for those who like their wines with a dash of intrigue and a wink of nostalgia.",
        },
        "color": "black",
        "regions": ["Loire", "France"],
        "flavor_profile": ["red_fruit", "raspberry"],
        "acidity": "Medium",
        "tannin": "Low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "red",
            "light_bodied",
            "varietal",
            "table_wine",
            "early_drinking",
        ],
    },
    {
        "name": "Plantscher",
        "synonyms": ["Bordeaux Blanc", "Bourgogne Blanc", "Gros Bourgogne"],
        "description": {
            "default": "Very rare Swiss or possibly Hungarian variety just surviving in the Haut-Valais.",
            "julie": "",
            "sommelier": "Plantscher is a unicorn of the Swiss Alps—a nearly vanished white grape that dazzles with zesty citrus, delicate florals, and a stony minerality, all wrapped in a feather-light frame. Sip it for a taste of alpine history and a refreshing, high-altitude zing.",
        },
        "color": "white",
        "regions": ["Switzerland", "Haut-Valais", "Hungary"],
        "flavor_profile": ["citrus", "stone_fruit", "floral", "mineral"],
        "acidity": "High",
        "tannin": "Very low",
        "body": "Light",
        "alcohol": "Medium",
        "wine_styles": [
            "white",
            "varietal",
            "traditional",
            "unoaked",
            "light_bodied",
            "table_wine",
        ],
    },
    {
        "name": "Plassa",
        "synonyms": ["Scarlattino"],
        "description": {
            "default": "Thick-skinned r