notes_and_hits = [
    {
        "name": "melon",
        "synonyms": [],
        "description": "A note of melon in wine brings a bright and fresh sweetness, often found in youthful whites, evoking the crisp juiciness of summer fruits.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "spice cake",
        "synonyms": [],
        "description": "This evokes the warmth and complexity of autumn, with notes of cinnamon, nutmeg, and clove mingling in rich, full-bodied wines.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "biscuit",
        "synonyms": [],
        "description": "It suggests a toasty, slightly yeasty quality, reminiscent of freshly baked bread, often found in aged sparkling wines.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "buttery",
        "synonyms": [],
        "description": "A creamy and rich descriptor, often associated with full-bodied white wines that have undergone malolactic fermentation, imparting a smooth, velvety texture.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "menthol",
        "synonyms": [],
        "description": "Adds a cool, refreshing lift to the aroma profile, providing a counterpoint to the richer, more dense fruit notes in some red wines.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "hazelnut",
        "synonyms": [],
        "description": "This note contributes a nutty, slightly sweet, and roasted dimension, often detected in wines aged in oak barrels.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "pear",
        "synonyms": [],
        "description": "A crisp, fresh fruit aroma that adds a delicate sweetness and acidity to lighter white wines, hinting at youthful vibrancy.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "birch leaf",
        "synonyms": [],
        "description": "Introduces a unique, slightly herbal and earthy tone, suggesting a wine's connection to its terroir and the freshness of nature.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lily",
        "synonyms": [],
        "description": "A floral note that imparts elegance and a fragrant, aromatic lift, enhancing the complexity and allure of both white and sparkling wines.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fruit",
        "synonyms": [],
        "description": "A broad descriptor that encompasses the essence of a wine's character, ranging from ripe, juicy berries in reds to succulent stone fruits in whites, highlighting the wine's vitality and flavor spectrum.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dark cherry",
        "synonyms": [],
        "description": "Velvety whispers of dark cherry evoke moonlit orchards, promising depth and mystery in each sip.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "appel marmalade",
        "synonyms": [],
        "description": "The sunny, tangy sweetness of apple marmalade dances on the palate, blending nostalgia with a touch of sophistication.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "honey melon",
        "synonyms": [],
        "description": "Honey melon's gentle, luscious notes offer a refreshing embrace, like a soft, sweet melody in summer's heat.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cardamom",
        "synonyms": [],
        "description": "Cardamom's exotic spice weaves through the wine, adding whispers of ancient markets and faraway lands.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dried fig",
        "synonyms": [],
        "description": "The richness of dried fig lends a warm, earthy base, reminiscent of stories told beside a flickering fire.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "vanilla",
        "synonyms": [],
        "description": "A hint of vanilla, smooth and comforting, wraps around the senses like a soft, well-loved blanket.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "resin ",
        "synonyms": [],
        "description": "The intriguing scent of resin adds a mysterious depth, beckoning you into a forest at dawn, mist clinging to ancient trees.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "bread",
        "synonyms": [],
        "description": "The comforting aroma of freshly baked bread brings a heartwarming simplicity, grounding and familiar.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "straw",
        "synonyms": [],
        "description": "Straw offers a rustic touch, a reminder of open fields and endless skies, carrying the essence of tranquility.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "red apple",
        "synonyms": [],
        "description": "Crisp and invigorating, red apple's vibrant notes capture the joy of biting into the first apple of autumn.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lime",
        "synonyms": [],
        "description": "Zesty and fresh, lime notes bring a vibrant, tangy acidity that brightens the palate, reminiscent of a crisp, summer day.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "apricot marmalade",
        "synonyms": [],
        "description": "Rich and sweet, with a touch of tartness, apricot marmalade notes envelop the senses in a luscious, fruity embrace.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "candy",
        "synonyms": [],
        "description": "Playful and sweet, candy notes evoke memories of childhood with their sugary, colorful burst of joy.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lemon",
        "synonyms": [],
        "description": "Sharp and invigorating, lemon notes cut through with a clean, citrusy sharpness that refreshes with each sip.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "blueberry",
        "synonyms": [],
        "description": "Deep and complex, blueberry notes offer a harmonious blend of sweetness and acidity, wrapped in earthy undertones.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cinnamon",
        "synonyms": [],
        "description": "Warm and spicy, cinnamon notes weave through the palate with a comforting, aromatic richness that's both exotic and familiar.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dill",
        "synonyms": [],
        "description": "Fresh and herbaceous, dill notes add a delicate, green brightness, evoking the crispness of a garden in spring.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "flower meadow",
        "synonyms": [],
        "description": "Evocative and delicate, notes of a flower meadow transport you to a serene, blooming field with every breath.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "star anise",
        "synonyms": [],
        "description": "Mysterious and licorice-like, star anise notes provide a bold, intriguing spiciness that's both warm and inviting.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mint",
        "synonyms": [],
        "description": "Cool and refreshing, mint notes sweep across the palate with a clean, invigorating burst of herbal clarity.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "bay leaf",
        "synonyms": [],
        "description": "A herbaceous and slightly astringent note reminiscent of the Mediterranean landscape.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "resinous",
        "synonyms": [],
        "description": "Evoking the dense, sticky essence of pine or sap, adding depth and complexity.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "grassy",
        "synonyms": [],
        "description": "Fresh and vibrant, akin to the smell of freshly cut lawn or green fields.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fruit cake",
        "synonyms": [],
        "description": "Rich and decadent, with layers of dried fruits, nuts, and spices melded together.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "peruvian pepper",
        "synonyms": [],
        "description": "A unique spicy and slightly fruity note, offering a hint of exotic warmth.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "nutshell",
        "synonyms": [],
        "description": "Earthy and slightly bitter, capturing the essence of a forest floor in autumn.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0],
    },
    {
        "name": "liquorice",
        "synonyms": [],
        "description": "Sweet, yet slightly bitter and herbal, evoking childhood confectionary memories.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "stable",
        "synonyms": [],
        "description": "A rustic, earthy note with nuances of hay and leather, grounding and complex.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "olive",
        "synonyms": [],
        "description": "Briny and slightly bitter, reminiscent of Mediterranean groves and sunny days.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "kiwi fruit",
        "synonyms": [],
        "description": "Bright and tart, with a juicy sweetness that brings a burst of freshness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pear candy",
        "synonyms": [],
        "description": "Sweet and slightly floral, with the luscious aroma of ripe pears and sugary treats.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "tar",
        "synonyms": [],
        "description": "Intensely smoky and dark, with a depth that adds a brooding character to the profile.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "cocoa bean",
        "synonyms": [],
        "description": "Rich and slightly bitter, evoking dark chocolate with a touch of earthiness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "oat biscuit",
        "synonyms": [],
        "description": "Warm and comforting, with a sweet, toasty quality reminiscent of home baking.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "vanilla pod",
        "synonyms": [],
        "description": "Sweet and creamy, with a luxurious fragrance that envelops the senses.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "oat flake",
        "synonyms": [],
        "description": "Mild and grainy, with a natural sweetness and a comforting, soft texture.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "cake",
        "synonyms": [],
        "description": "Sweet and buttery, with hints of vanilla and a soft, indulgent texture.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "clementine",
        "synonyms": [],
        "description": "Zesty and sweet, with a vibrant citrus burst that’s refreshing and lively.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fruit pie",
        "synonyms": [],
        "description": "Warm and inviting, filled with the sweet and tangy aromas of baked fruit and spices.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "boysenberry",
        "synonyms": [],
        "description": "Juicy and slightly tart, with a deep berry flavor that’s both bold and nuanced.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "ginger",
        "synonyms": [],
        "description": "A zesty and slightly spicy note that invigorates the palate with its fiery warmth.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "pineapple",
        "synonyms": [],
        "description": "A burst of tropical sweetness, balancing sugar and acidity for a refreshing tang.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "heather",
        "synonyms": [],
        "description": "Subtly floral and earthy, reminiscent of the wild, breezy landscapes where it thrives.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "apple",
        "synonyms": [],
        "description": "Crisp and clean, ranging from sweet to tart, evoking the freshness of orchard harvests.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "passion fruit",
        "synonyms": [],
        "description": "Exotic and intense, with a heady perfume and a tart, tropical flavor that dances on the tongue.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "black olive",
        "synonyms": [],
        "description": "Briny and rich, offering a savory depth with notes of earthiness and a touch of bitterness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "chocolate",
        "synonyms": [],
        "description": "Luxuriously smooth and comforting, with a deep richness varying from sweet milk to bitter dark.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "apricot",
        "synonyms": [],
        "description": "Sweet and softly tangy, with a velvety, floral fruitiness that whispers of summer.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "milk coffee",
        "synonyms": [],
        "description": "Creamy and soothing, with a gentle coffee bitterness mellowed by the sweetness of milk.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "malty",
        "synonyms": [],
        "description": "Warm and comforting, with a toasty sweetness that recalls baked bread and autumn afternoons.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "dark cranberry",
        "synonyms": [],
        "description": "Tart and bold, with a deep, red fruit sharpness that awakens the senses.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "buckthorn",
        "synonyms": [],
        "description": "Intriguingly sour and sharp, with a wild, berry-like intensity that's both rare and refreshing.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "roasted almond",
        "synonyms": [],
        "description": "Nutty and warm, with a toasty richness that envelops the palate in comfort.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0],
    },
    {
        "name": "quince",
        "synonyms": [],
        "description": "Uniquely fragrant and tart, a rare treat that combines pear-like sweetness with a citrus edge.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "toast",
        "synonyms": [],
        "description": "Comfortingly familiar, with a golden, crispy warmth that evokes mornings bathed in sunlight.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0],
    },
    {
        "name": "currant",
        "synonyms": [],
        "description": "Tart and tangy, with a berry brightness that adds a lively spark to any tasting.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fruit candy",
        "synonyms": [],
        "description": "Playfully sweet, bursting with a rainbow of flavors that delight and entertain the taste buds.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "champignon",
        "synonyms": [],
        "description": "Earthy and subtle, with a savory depth that grounds the palate in forest freshness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0],
    },
    {
        "name": "flowery",
        "synonyms": [],
        "description": "Delicately aromatic, painting the senses with a bouquet of spring's first blooms.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "blood grapefruit",
        "synonyms": [],
        "description": "Bold and bitter-sweet, offering a citrusy jolt with a ruby-red twist of complexity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "almond",
        "synonyms": [],
        "description": "A nutty and slightly sweet flavor that evokes warmth and earthiness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "balanced oak",
        "synonyms": [],
        "description": "Offers a harmonious woodiness without overpowering, lending a backbone of structure to the wine.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "salmiak",
        "synonyms": [],
        "description": "A distinctive salty-licorice note, often found in Nordic countries, adding depth and intrigue.",
        "vector": [0.0, 0.0, 1.0, 0.0, 1.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "ink",
        "synonyms": [],
        "description": "A deep, dark, slightly astringent note reminiscent of wet stone and graphite.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "white peach",
        "synonyms": [],
        "description": "Delicate and floral, with a juicy, succulent sweetness that’s both refreshing and aromatic.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "orange blossom",
        "synonyms": [],
        "description": "Fragrant and subtly sweet, like walking through an orchard in bloom.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "yuzu fruit",
        "synonyms": [],
        "description": "A tantalizing blend of tart and tangy, with hints of citrus zest and a unique floral undertone.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "honey",
        "synonyms": [],
        "description": "Sweet, rich, and comforting, evoking fields of flowers and summertime warmth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0],
    },
    {
        "name": "green paprika",
        "synonyms": [],
        "description": "A crisp, slightly spicy and vegetal note that adds a fresh layer of complexity.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cream filled pastry",
        "synonyms": [],
        "description": "Lusciously sweet with a hint of vanilla and buttery richness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "grapefruit",
        "synonyms": [],
        "description": "Zesty and slightly bitter, offering a refreshing and invigorating citrus kick.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "honeycomb",
        "synonyms": [],
        "description": "A deeper, richer version of honey, with a waxy texture and complex layers of sweetness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "smoked ham",
        "synonyms": [],
        "description": "Savory and smoky, with a hint of saltiness that evokes a sense of comfort and depth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "cocoa",
        "synonyms": [],
        "description": "Dark and slightly bitter, evoking a sense of indulgence and depth.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "cherry",
        "synonyms": [],
        "description": "Juicy and vibrant, with a perfect balance of sweet and tart that dances on the palate.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "citrus",
        "synonyms": [],
        "description": "A burst of refreshing acidity, bringing light and zest to the wine’s profile.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "arctic bramble",
        "synonyms": [],
        "description": "A rare and delicate fruity note, combining sweetness with a hint of Arctic freshness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "whitecurrant",
        "synonyms": [],
        "description": "Crisp and tart, with a delicate sweetness and a refreshing acidity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rhubarb",
        "synonyms": [],
        "description": "Tart and slightly earthy, adding a unique vegetal sweetness with a hint of sourness.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "red gooseberry",
        "synonyms": [],
        "description": "A lively and tart fruit note, with a nuanced sweetness and a hint of astringency.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "anise",
        "synonyms": [],
        "description": "Evokes the sweet, slightly spicy, and licorice-like aroma.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "whisky",
        "synonyms": [],
        "description": "Brings forth rich, warm notes of malt, oak, and smoky peat.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "creme brulee",
        "synonyms": [],
        "description": "Delivers the comforting sweetness of vanilla and caramelized sugar.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0],
    },
    {
        "name": "noble rot",
        "synonyms": [],
        "description": "Offers complex flavors of honey, dried fruit, and a touch of earthiness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "wheat",
        "synonyms": [],
        "description": "Contributes a fresh, light, and slightly nutty essence.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "rye",
        "synonyms": [],
        "description": "Adds a spicy, grainy character with a hint of fruitiness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "elegant oaky",
        "synonyms": [],
        "description": "Introduces refined notes of vanilla, toast, and a hint of smoke.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "apple compote",
        "synonyms": [],
        "description": "Brings a warm, cooked apple sweetness with hints of cinnamon.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "white chocolate",
        "synonyms": [],
        "description": "Provides a creamy, buttery sweetness with a delicate cocoa note.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "black tea",
        "synonyms": [],
        "description": "Offers a robust, slightly astringent, and earthy undertone.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "vermouth",
        "synonyms": [],
        "description": "Combines herbaceous, floral, and bitter elements for a complex profile.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "black pepper",
        "synonyms": [],
        "description": "Adds a sharp, piquant spiciness to the mix.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "dried cranberry",
        "synonyms": [],
        "description": "Introduces a tart, sweet, and slightly chewy fruit character.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mocha",
        "synonyms": [],
        "description": "Melds the richness of coffee with the creamy sweetness of chocolate.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "dried plum",
        "synonyms": [],
        "description": "Offers a concentrated sweetness with a hint of tartness and earthiness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "waffle",
        "synonyms": [],
        "description": "Delivers a comforting aroma of cooked batter with a hint of sweetness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "clove",
        "synonyms": [],
        "description": "Adds a warm, spicy note with a hint of sweetness.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "perfume",
        "synonyms": [],
        "description": "Suggests a complex, floral, and sometimes fruity or spicy character.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "petrol",
        "synonyms": [],
        "description": "Brings a unique, mineral-like, slightly gasoline note, often found in aged Rieslings.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "toasted",
        "synonyms": [],
        "description": "Offers warm, comforting notes of toasted bread, nuts, or grains.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0],
    },
    {
        "name": "apple tart cake",
        "synonyms": [],
        "description": "Invitingly sweet with a hint of rustic charm.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "berry",
        "synonyms": [],
        "description": "Bursting with juicy, fresh vibrancy.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "toasted bread",
        "synonyms": [],
        "description": "Comfortingly warm with a hint of earthiness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0],
    },
    {
        "name": "raspberry sorbet",
        "synonyms": [],
        "description": "Refreshingly tart with a sweet finish.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "blood orange",
        "synonyms": [],
        "description": "Boldly tangy with a deep citrus complexity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "herbal",
        "synonyms": [],
        "description": "Subtly aromatic with a whisper of green freshness.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "strawberry",
        "synonyms": [],
        "description": "Delightfully sweet with a soft, summery essence.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rowanberry",
        "synonyms": [],
        "description": "Distinctly tart with a wild, untamed edge.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "juniper berry",
        "synonyms": [],
        "description": "Crisp with a piney, almost mystical depth.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "sour cherry",
        "synonyms": [],
        "description": "Sharply tangy, awakening the palate with its vibrance.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rye bread",
        "synonyms": [],
        "description": "Earthy with a robust, grainy character.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "blackcurrant",
        "synonyms": [],
        "description": "Deeply fruity with a lush, velvety richness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "redcurrant",
        "synonyms": [],
        "description": "Brightly acidic, adding a lively sparkle.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cinnamon-apple",
        "synonyms": [],
        "description": "Comfortingly warm, spiced with a sweet crispness.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "red pepper",
        "synonyms": [],
        "description": "Vividly sharp with a subtle, smoky sweetness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "bog bilberry",
        "synonyms": [],
        "description": "Rare and wild, with a tart, haunting flavor.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "coffee flavoured chocolate",
        "synonyms": [],
        "description": "Luxuriously rich with a bittersweet complexity.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "balsamic",
        "synonyms": [],
        "description": "Richly tart, layered with a sweet, syrupy depth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "shortbread",
        "synonyms": [],
        "description": "Buttery and crumbly, melting delightfully on the tongue.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "medicinal herb",
        "synonyms": [],
        "description": "Earthy and potent, with a healing, bitter edge.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "plum",
        "synonyms": [],
        "description": "A ripe, juicy plum note brings a sweet and slightly tart complexity, reminiscent of summer fruits.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "green pepper",
        "synonyms": [],
        "description": "The green pepper note introduces a fresh, slightly grassy, and crisp dimension, often found in Cabernet Franc wines.",
        "vector": [1.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "umami",
        "synonyms": [],
        "description": "Umami offers a savory taste depth, enhancing flavors with a rich and complex character.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "autumn apple",
        "synonyms": [],
        "description": "Autumn apple notes evoke the crisp, slightly tart flavors of freshly harvested apples, adding brightness and freshness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "grainy",
        "synonyms": [],
        "description": "A grainy note suggests a subtle, earthy texture reminiscent of cereals or bread, adding complexity to the wine's profile.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "eucalyptus",
        "synonyms": [],
        "description": "Eucalyptus imparts a cool, minty, and slightly herbal aroma, adding a refreshing and invigorating layer.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cognac",
        "synonyms": [],
        "description": "A cognac note adds a warm, rich, and slightly spicy character, suggesting aged elegance and depth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "peach candy",
        "synonyms": [],
        "description": "Peach candy notes bring a playful, sweet, and fruity essence, reminiscent of sugared summer fruits.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "citrus marmalade",
        "synonyms": [],
        "description": "Citrus marmalade introduces a sweet and tangy burst, combining the zestiness of citrus with a sugary finish.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "sorrel",
        "synonyms": [],
        "description": "Sorrel contributes a unique, slightly tangy and herbaceous flavor, adding a refreshing and slightly sour twist.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "white pepper",
        "synonyms": [],
        "description": "White pepper adds a subtle, spicy kick, offering a gentle heat that lifts the wine's aromatic profile.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "red berry",
        "synonyms": [],
        "description": "Red berry notes encapsulate the juicy, sweet, and slightly tart flavors of strawberries and raspberries, adding a vibrant fruitiness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "berry yogurt",
        "synonyms": [],
        "description": "Berry yogurt combines the creamy, tangy qualities of yogurt with the sweet, lush flavors of mixed berries.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "smoked paprika",
        "synonyms": [],
        "description": "Smoked paprika lends a smoky, slightly spicy, and rich dimension, evoking warmth and complexity.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fig",
        "synonyms": [],
        "description": "Fig introduces a sweet, jammy, and slightly nutty flavor, adding richness and a hint of decadence.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rose petals",
        "synonyms": [],
        "description": "Rose petals offer a delicate, floral aroma, adding elegance and a soft, perfumed character.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mushroom",
        "synonyms": [],
        "description": "Mushroom notes bring an earthy, umami-rich dimension, grounding the wine with a sense of depth and savoriness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "cherry-blossom",
        "synonyms": [],
        "description": "Cherry-blossom adds a gentle, floral sweetness, infusing the wine with a spring-like freshness and delicacy.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "raspberry marmalade",
        "synonyms": [],
        "description": "Raspberry marmalade combines the tartness of raspberries with a sweet, concentrated depth, adding a luscious fruitiness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "velvety oak",
        "synonyms": [],
        "description": "Velvety oak imparts a smooth, rich texture along with hints of vanilla and spice, adding complexity and warmth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "strawberry cake",
        "synonyms": [],
        "description": "Like a slice of summer, evoking the sweetness and lightness of ripe strawberries.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "ginger snap",
        "synonyms": [],
        "description": "A bite that snaps with warmth and spice, reminiscent of cozy, aromatic evenings.",
        "vector": [0.0, 0.0, 1.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "leather",
        "synonyms": [],
        "description": "A complex, deep note that brings to mind the richness of well-aged wine or the interior of a cherished library.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "dark raspberry",
        "synonyms": [],
        "description": "A juicy, dark burst of flavor, marrying sweetness with a touch of earthy depth.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "coriander seed",
        "synonyms": [],
        "description": "Aromatic and slightly citrusy, with a spicy, nutty finish that dances on the palate.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "grain",
        "synonyms": [],
        "description": "Earthy and comforting, embodying the heartiness of the field and the breadbasket.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "jasmine",
        "synonyms": [],
        "description": "Delicately floral, with a whisper of sweet perfume that lingers like a serene, moonlit garden.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "date",
        "synonyms": [],
        "description": "Rich and sweet, conjuring images of opulent desserts and Middle Eastern bazaars.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cloudberry",
        "synonyms": [],
        "description": "A rare, tart sweetness, evocative of northern wilderness and the glow of midnight suns.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "walnut",
        "synonyms": [],
        "description": "Earthy and robust, a blend of crunch and bitterness that grounds and satisfies.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "nectarine",
        "synonyms": [],
        "description": "Bright and sunny, with a juicy sweetness undercut by a hint of acidity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "smoky",
        "synonyms": [],
        "description": "A mysterious, lingering essence that evokes fireside gatherings and ancient traditions.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "asparagus",
        "synonyms": [],
        "description": "Fresh and green, with a distinctive, slightly bitter undertone that intrigues the palate.",
        "vector": [1.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pencil lead",
        "synonyms": [],
        "description": "Minerally and sharp, suggesting precision and a certain austere elegance.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "coconut",
        "synonyms": [],
        "description": "Tropical and creamy, whisking you away to sandy shores with its sweet, lush bounty.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "peach",
        "synonyms": [],
        "description": "Summery and soft, a gentle caress of sweetness with a velvety finish.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "saddle leather",
        "synonyms": [],
        "description": "Rich and evocative, a testament to craftsmanship and the passage of time.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "spruce shoot",
        "synonyms": [],
        "description": "Crisp and clean, with a hint of resinous freshness that awakens the senses.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "bourbon vanilla",
        "synonyms": [],
        "description": "Deep and sultry, a luxurious swirl of sweetness with a smoky, intoxicating edge.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "gingerbread",
        "synonyms": [],
        "description": "Warm and festive, a comforting blend of spices that tastes like holidays and homecomings.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "paprika",
        "synonyms": [],
        "description": "A warm, earthy note with a gentle heat, reminiscent of the vibrant red spice it's named after.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "chocolate",
        "synonyms": [],
        "description": "Rich and indulgent, evoking the comfort and depth of dark cocoa.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "rose",
        "synonyms": [],
        "description": "Delicately floral, with a soft, aromatic sweetness that whispers of romance.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mineral",
        "synonyms": [],
        "description": "Crisp and refreshing, bringing to mind the purity of rain-kissed rocks and soil.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rum",
        "synonyms": [],
        "description": "Sugarcane's complexity distilled into a sweet, slightly spicy, and warm embrace.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "thyme",
        "synonyms": [],
        "description": "Herbal and slightly earthy, with a whisper of the Mediterranean breeze.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "biscuit dough",
        "synonyms": [],
        "description": "Comfortingly warm and buttery, hinting at sweetness and home-baked goodness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "chamomile",
        "synonyms": [],
        "description": "Gentle and soothing, with a soft, floral, and slightly sweet nature.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "griddle pancake",
        "synonyms": [],
        "description": "The essence of cozy mornings, with warm, golden notes and a hint of vanilla.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "basil",
        "synonyms": [],
        "description": "Fresh and vibrant, a green note with a peppery edge that dances on the palate.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "banana",
        "synonyms": [],
        "description": "Tropical and sweet, with a creamy, ripe fruitiness that's instantly recognizable.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "dried pineapple",
        "synonyms": [],
        "description": "Concentrated sweetness and tropical flair, rich with a chewy, fruity intensity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "blackcurrant leaf",
        "synonyms": [],
        "description": "Green and slightly fruity, with a tangy, herbaceous note that's refreshingly unique.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "chestnut",
        "synonyms": [],
        "description": "Earthy and nutty, with a rich, sweet undercurrent that's warmly inviting.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "violet",
        "synonyms": [],
        "description": "A delicate floral sweetness, elegant and slightly powdery in its allure.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "spice",
        "synonyms": [],
        "description": "A thrilling blend of warmth and mystery, evoking exotic destinations and colorful markets.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dark chocolate",
        "synonyms": [],
        "description": "The bittersweet edge of cocoa deepened into something dense, complex, and indulgent.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "currant leaf",
        "synonyms": [],
        "description": "Similar to blackcurrant leaf, offering a green and slightly tangy berry nuance.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "chokeberry",
        "synonyms": [],
        "description": "Tart and tannic, with a deep, dark fruitiness that's intriguing and bold.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "creamy",
        "synonyms": [],
        "description": "Smooth and rich, a luxurious texture that coats the palate with a velvety touch.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "butter popcorn",
        "synonyms": [],
        "description": "A delightful hint of creamy butter with the warm, toasted aroma of freshly popped corn.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "persimmon",
        "synonyms": [],
        "description": "A lush sweetness with a honeyed, slightly tangy finish reminiscent of autumn's bounty.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "forest floor",
        "synonyms": [],
        "description": "Earthy and rich, evoking the damp, mossy blanket of a forest underfoot.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "cream toffee",
        "synonyms": [],
        "description": "Velvety and indulgent, like melted toffee with a smooth, creamy backdrop.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "coriander",
        "synonyms": [],
        "description": "A lively, citrusy spice with hints of sage and lemon, offering a refreshing complexity.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dark berry",
        "synonyms": [],
        "description": "Deep and mysterious, bursting with the essence of ripe, dark berries on a summer's eve.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "raspberry-chocolate",
        "synonyms": [],
        "description": "A seductive duo of tart raspberry and luxurious dark chocolate, both rich and enticing.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "apple blossom",
        "synonyms": [],
        "description": "Delicately floral with the crisp, airy sweetness of spring apple blossoms.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cedar",
        "synonyms": [],
        "description": "A robust and woodsy aroma, evoking the timeless grace of cedar forests.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "orange marmalade",
        "synonyms": [],
        "description": "Sweet and tangy, with the vibrant zest of citrus and a sticky, sweet finish.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "damson",
        "synonyms": [],
        "description": "A rich, plummy note with a hint of almond, dark and sumptuous.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "truffle",
        "synonyms": [],
        "description": "Earthy and opulent, with a deep, musky allure that's unmistakably gourmet.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "christmas apple",
        "synonyms": [],
        "description": "Warm and spiced, reminiscent of apples mulled with cinnamon and cloves by the fireside.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mandarin",
        "synonyms": [],
        "description": "Bright and zesty, capturing the sunlit sparkle of fresh mandarins.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "christmas spice",
        "synonyms": [],
        "description": "A cozy melange of cinnamon, nutmeg, and cloves, wrapped in holiday warmth.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "raspberry",
        "synonyms": [],
        "description": "Vibrantly sweet and tart, like a burst of fresh raspberries on a summer day.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "green pear",
        "synonyms": [],
        "description": "Crisp and juicy, with a fresh, lightly floral sweetness that's refreshingly light.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "mango",
        "synonyms": [],
        "description": "Tropical and sweet, with a lush, mouthwatering richness that transports you to an island paradise.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "brandyish",
        "synonyms": [],
        "description": "Warm and velvety, with a rich, aged depth and notes of caramel and wood.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "liquorice root",
        "synonyms": [],
        "description": "Dark and mysterious, offering a sweet, anise-like flavor that's both complex and comforting.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "nutty",
        "synonyms": [],
        "description": "A comforting embrace of earthiness and warmth, reminiscent of autumn evenings by the fire.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "green gooseberry",
        "synonyms": [],
        "description": "Vibrantly tart and refreshing, evoking a crisp, sunny morning in the countryside.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fruity",
        "synonyms": [],
        "description": "A joyful burst of summer orchard fruits, dancing lively on the palate.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "maraschino cherry",
        "synonyms": [],
        "description": "Sweet, with a hint of nostalgia, like a cherished memory from a festive celebration.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "funnel chanterelle",
        "synonyms": [],
        "description": "Earthy and rich, a subtle whisper of the forest's hidden treasures.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "yellow plum",
        "synonyms": [],
        "description": "Delicately sweet with a hint of tartness, capturing the essence of late summer's bounty.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "milky cocoa",
        "synonyms": [],
        "description": "Smooth and comforting, a velvety whisper of chocolatey indulgence.",
        "vector": [0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "apricot",
        "synonyms": [],
        "description": "Bright and sun-kissed, with a tender sweetness that softly lingers.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "salty almond",
        "synonyms": [],
        "description": "A delightful contrast of savory nuttiness, evoking a sense of seaside adventures.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "marzipan",
        "synonyms": [],
        "description": "Sweetly almond, a dreamy confection that transports you to a festive market square.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 1.0, 1.0],
    },
    {
        "name": "dried date",
        "synonyms": [],
        "description": "Deeply sweet and rich, a treasure trove of desert warmth.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "pear marmalade",
        "synonyms": [],
        "description": "Lusciously sweet and fragrant, a spread of autumn harvest on your palate.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pudding",
        "synonyms": [],
        "description": "Creamy and comforting, a spoonful of blissful indulgence.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "tropical fruit",
        "synonyms": [],
        "description": "Exotically sweet, a carnival of sunshine and vibrant colors.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pomelo",
        "synonyms": [],
        "description": "Fresh and zesty, a splash of citrus brightness to awaken the senses.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "caramel",
        "synonyms": [],
        "description": "Decadently sweet, a silky ribbon of golden indulgence.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "salted caramel",
        "synonyms": [],
        "description": "A tantalizing dance of sweet and savory, a delightful intrigue.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "elderflower",
        "synonyms": [],
        "description": "Delicately floral, a gentle whisper of spring's first bloom.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "brioche",
        "synonyms": [],
        "description": "Buttery and rich, a soft embrace of comforting luxury.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "yellow raisin",
        "synonyms": [],
        "description": "Sweetly sun-dried, a nugget of golden warmth and nostalgia.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "allspice",
        "synonyms": [],
        "description": "Allspice evokes the warm, sweet-spicy aroma of winter holidays.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "cranberry",
        "synonyms": [],
        "description": "Cranberry brings a tart, vibrant red berry burst, perfect for autumn.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "milk chocolate",
        "synonyms": [],
        "description": "Milk chocolate offers a creamy, comforting sweetness with a velvety texture.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 1.0],
    },
    {
        "name": "rosemary",
        "synonyms": [],
        "description": "Rosemary adds a woodsy, aromatic lift, reminiscent of Mediterranean landscapes.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "green apple",
        "synonyms": [],
        "description": "Green apple provides a crisp, juicy tartness, refreshing the palate.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "oak",
        "synonyms": [],
        "description": "Oak infuses a robust, toasty richness with hints of vanilla.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "tea",
        "synonyms": [],
        "description": "Tea imparts a delicate, soothing earthiness with subtle floral notes.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "raisin",
        "synonyms": [],
        "description": "Raisin delivers a sun-kissed sweetness with a chewy, dried fruit essence.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pine",
        "synonyms": [],
        "description": "Pine introduces a fresh, resinous sharpness, akin to a forest after rain.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dandelion",
        "synonyms": [],
        "description": "Dandelion contributes a slightly bitter, grassy note, grounding and herbal.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "sour orange",
        "synonyms": [],
        "description": "Sour orange offers a tangy, citrusy zing, brightening dishes with its acidity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "balanced vanilla",
        "synonyms": [],
        "description": "Balanced vanilla presents a sweet, creamy smoothness, universally comforting.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "barley bread",
        "synonyms": [],
        "description": "Barley bread suggests a hearty, grainy texture with a slightly nutty flavor.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0],
    },
    {
        "name": "greencurrant",
        "synonyms": [],
        "description": "Greencurrant adds a tart, zesty punch, vibrant and invigorating.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "orange",
        "synonyms": [],
        "description": "Orange brings a sunny, sweet citrus burst, full of vitamin joy.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "fennel",
        "synonyms": [],
        "description": "Fennel offers an aniseed-like sweetness, crisp and refreshing.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "rose hip",
        "synonyms": [],
        "description": "Rose hip introduces a tangy, floral vitamin C kick, subtly sweet and tart.",
        "vector": [0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "nut croquant",
        "synonyms": [],
        "description": "Nut croquant provides a caramelized, crunchy nuttiness, rich and satisfying.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "woody",
        "synonyms": [],
        "description": "Woody evokes the essence of a dense forest, grounding with a matured depth.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "hay",
        "synonyms": [],
        "description": "Hay brings a dry, sweet earthiness, reminiscent of late summer fields.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0],
    },
    {
        "name": "nettle",
        "synonyms": [],
        "description": "A green, slightly herbaceous note with a touch of earthiness and freshness.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "toffee",
        "synonyms": [],
        "description": "Rich, buttery sweetness with a caramel-like finish that lingers pleasantly.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "coffee",
        "synonyms": [],
        "description": "Deep, roasted aromas with hints of bitterness and complexity akin to a freshly brewed cup.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "yellow apple",
        "synonyms": [],
        "description": "Bright and crisp, embodying the perfect balance of sweetness and acidity.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dark plum",
        "synonyms": [],
        "description": "Lush and juicy, with a deep fruity sweetness and subtle tartness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "highbush blueberry",
        "synonyms": [],
        "description": "Vibrant and slightly tart, encapsulating the essence of fresh blueberries with a hint of sweetness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lingonberry",
        "synonyms": [],
        "description": "Tart and slightly sweet, with a unique berry freshness that invigorates the palate.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "soft liquorice",
        "synonyms": [],
        "description": "Gentle yet unmistakable, with a sweet, earthy profile and a hint of anise.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "herb",
        "synonyms": [],
        "description": "A refreshing and aromatic note that evokes a sense of green, leafy freshness.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "pepper",
        "synonyms": [],
        "description": "Spicy and invigorating, adding a lively kick and depth to the aroma profile.",
        "vector": [0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "exotic fruit",
        "synonyms": [],
        "description": "A tantalizing mix of sweetness and acidity, bursting with tropical flavors.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "kumquat",
        "synonyms": [],
        "description": "A distinct, tangy citrus note with a sweet outer layer and a sour center.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "blackberry",
        "synonyms": [],
        "description": "Juicy and rich, with a perfect blend of sweetness and tartness.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "gooseberry",
        "synonyms": [],
        "description": "A unique, tangy fruitiness with an underlying sweet and sour character.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "dried herbal",
        "synonyms": [],
        "description": "Concentrated and aromatic, evoking the warmth and earthiness of sun-dried herbs.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "vanilla-oak",
        "synonyms": [],
        "description": "Smooth and creamy with a woody depth, adding warmth and richness.",
        "vector": [0.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0],
    },
    {
        "name": "raspberry candy",
        "synonyms": [],
        "description": "Sweet and fruity, with a vibrant berry flavor that's reminiscent of childhood treats.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lovage",
        "synonyms": [],
        "description": "Earthy and slightly celery-like, with a savory depth that adds complexity.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "lychee",
        "synonyms": [],
        "description": "Exotic and floral, with a perfumed sweetness that's both refreshing and captivating.",
        "vector": [1.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0],
    },
    {
        "name": "tomato leaf",
        "synonyms": [],
        "description": "Green and vegetal, with a distinct freshness that's reminiscent of a garden after the rain.",
        "vector": [0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0],
    },
]
