# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from .raw_client import AsyncRawDocumentsClient, RawDocumentsClient
from .types.get_job_status_response import GetJobStatusResponse
from .types.initialize_render_job_request_format_opts import InitializeRenderJobRequestFormatOpts
from .types.initialize_render_job_request_target import InitializeRenderJobRequestTarget
from .types.initialize_render_job_request_type import InitializeRenderJobRequestType
from .types.initialize_render_job_response import InitializeRenderJobResponse
from .types.start_immediate_render_request_format_opts import StartImmediateRenderRequestFormatOpts
from .types.start_immediate_render_request_target import StartImmediateRenderRequestTarget
from .types.start_immediate_render_request_type import StartImmediateRenderRequestType
from .types.start_immediate_render_response import StartImmediateRenderResponse
from .types.start_render_job_response import StartRenderJobResponse

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class DocumentsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawDocumentsClient
        """
        return self._raw_client

    def initialize_render_job(
        self,
        *,
        type: InitializeRenderJobRequestType,
        target: InitializeRenderJobRequestTarget,
        data: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        template_id: typing.Optional[str] = OMIT,
        format_opts: typing.Optional[InitializeRenderJobRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InitializeRenderJobResponse:
        """
        Creates a new render job with a unique ID, sets up S3 storage for template and data files, and generates presigned upload URLs if needed. Requires subscription check.

        Parameters
        ----------
        type : InitializeRenderJobRequestType
            Type of template to be rendered

        target : InitializeRenderJobRequestTarget
            Type of output to be rendered

        data : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Sample data for the template

        template_id : typing.Optional[str]
            ID of the template to be used

        format_opts : typing.Optional[InitializeRenderJobRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitializeRenderJobResponse
            Default Response

        Examples
        --------
        from Pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.documents.initialize_render_job(
            type="docx",
            target="pdf",
        )
        """
        _response = self._raw_client.initialize_render_job(
            type=type,
            target=target,
            data=data,
            template_id=template_id,
            format_opts=format_opts,
            request_options=request_options,
        )
        return _response.data

    def start_render_job(
        self,
        job_id: str,
        *,
        should_wait_for_render_completion: typing.Optional[bool] = OMIT,
        upload_presigned_s_3_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartRenderJobResponse:
        """
        Takes a previously initialized job, updates its status to in-progress, and triggers the rendering process using Puppeteer. Can optionally wait for render completion.

        Parameters
        ----------
        job_id : str

        should_wait_for_render_completion : typing.Optional[bool]
            Whether to wait for the render job to complete, if false, the job will be returned immediately

        upload_presigned_s_3_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartRenderJobResponse
            Default Response

        Examples
        --------
        from Pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.documents.start_render_job(
            job_id="jobId",
        )
        """
        _response = self._raw_client.start_render_job(
            job_id,
            should_wait_for_render_completion=should_wait_for_render_completion,
            upload_presigned_s_3_url=upload_presigned_s_3_url,
            request_options=request_options,
        )
        return _response.data

    def start_immediate_render(
        self,
        *,
        type: StartImmediateRenderRequestType,
        target: StartImmediateRenderRequestTarget,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        template_id: typing.Optional[str] = OMIT,
        format_opts: typing.Optional[StartImmediateRenderRequestFormatOpts] = OMIT,
        template: typing.Optional[str] = OMIT,
        upload_presigned_s_3_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartImmediateRenderResponse:
        """
        Combines initialization and rendering in one step. Creates a job, uploads template/data directly, starts rendering, and adds the document to Strapi. Requires subscription check.

        Parameters
        ----------
        type : StartImmediateRenderRequestType
            Type of template to be rendered

        target : StartImmediateRenderRequestTarget
            Type of output to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        template_id : typing.Optional[str]
            ID of the template to be used

        format_opts : typing.Optional[StartImmediateRenderRequestFormatOpts]
            Format options for the rendered document

        template : typing.Optional[str]
            index.html or ejs file of the template as a string

        upload_presigned_s_3_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartImmediateRenderResponse
            Default Response

        Examples
        --------
        from Pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.documents.start_immediate_render(
            type="docx",
            target="pdf",
            data={"key": "value"},
        )
        """
        _response = self._raw_client.start_immediate_render(
            type=type,
            target=target,
            data=data,
            template_id=template_id,
            format_opts=format_opts,
            template=template,
            upload_presigned_s_3_url=upload_presigned_s_3_url,
            request_options=request_options,
        )
        return _response.data

    def get_job_status(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetJobStatusResponse:
        """
        Fetches detailed job information from S3 storage including job status, template ID, target format, and output details if available.

        Parameters
        ----------
        job_id : str
            ID of the render job

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobStatusResponse
            Default Response

        Examples
        --------
        from Pogodoc import PogodocApi

        client = PogodocApi(
            token="YOUR_TOKEN",
        )
        client.documents.get_job_status(
            job_id="jobId",
        )
        """
        _response = self._raw_client.get_job_status(job_id, request_options=request_options)
        return _response.data


class AsyncDocumentsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawDocumentsClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawDocumentsClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawDocumentsClient
        """
        return self._raw_client

    async def initialize_render_job(
        self,
        *,
        type: InitializeRenderJobRequestType,
        target: InitializeRenderJobRequestTarget,
        data: typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]] = OMIT,
        template_id: typing.Optional[str] = OMIT,
        format_opts: typing.Optional[InitializeRenderJobRequestFormatOpts] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> InitializeRenderJobResponse:
        """
        Creates a new render job with a unique ID, sets up S3 storage for template and data files, and generates presigned upload URLs if needed. Requires subscription check.

        Parameters
        ----------
        type : InitializeRenderJobRequestType
            Type of template to be rendered

        target : InitializeRenderJobRequestTarget
            Type of output to be rendered

        data : typing.Optional[typing.Dict[str, typing.Optional[typing.Any]]]
            Sample data for the template

        template_id : typing.Optional[str]
            ID of the template to be used

        format_opts : typing.Optional[InitializeRenderJobRequestFormatOpts]
            Format options for the rendered document

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        InitializeRenderJobResponse
            Default Response

        Examples
        --------
        import asyncio

        from Pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.documents.initialize_render_job(
                type="docx",
                target="pdf",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.initialize_render_job(
            type=type,
            target=target,
            data=data,
            template_id=template_id,
            format_opts=format_opts,
            request_options=request_options,
        )
        return _response.data

    async def start_render_job(
        self,
        job_id: str,
        *,
        should_wait_for_render_completion: typing.Optional[bool] = OMIT,
        upload_presigned_s_3_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartRenderJobResponse:
        """
        Takes a previously initialized job, updates its status to in-progress, and triggers the rendering process using Puppeteer. Can optionally wait for render completion.

        Parameters
        ----------
        job_id : str

        should_wait_for_render_completion : typing.Optional[bool]
            Whether to wait for the render job to complete, if false, the job will be returned immediately

        upload_presigned_s_3_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartRenderJobResponse
            Default Response

        Examples
        --------
        import asyncio

        from Pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.documents.start_render_job(
                job_id="jobId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.start_render_job(
            job_id,
            should_wait_for_render_completion=should_wait_for_render_completion,
            upload_presigned_s_3_url=upload_presigned_s_3_url,
            request_options=request_options,
        )
        return _response.data

    async def start_immediate_render(
        self,
        *,
        type: StartImmediateRenderRequestType,
        target: StartImmediateRenderRequestTarget,
        data: typing.Dict[str, typing.Optional[typing.Any]],
        template_id: typing.Optional[str] = OMIT,
        format_opts: typing.Optional[StartImmediateRenderRequestFormatOpts] = OMIT,
        template: typing.Optional[str] = OMIT,
        upload_presigned_s_3_url: typing.Optional[str] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> StartImmediateRenderResponse:
        """
        Combines initialization and rendering in one step. Creates a job, uploads template/data directly, starts rendering, and adds the document to Strapi. Requires subscription check.

        Parameters
        ----------
        type : StartImmediateRenderRequestType
            Type of template to be rendered

        target : StartImmediateRenderRequestTarget
            Type of output to be rendered

        data : typing.Dict[str, typing.Optional[typing.Any]]
            Sample data for the template

        template_id : typing.Optional[str]
            ID of the template to be used

        format_opts : typing.Optional[StartImmediateRenderRequestFormatOpts]
            Format options for the rendered document

        template : typing.Optional[str]
            index.html or ejs file of the template as a string

        upload_presigned_s_3_url : typing.Optional[str]

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        StartImmediateRenderResponse
            Default Response

        Examples
        --------
        import asyncio

        from Pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.documents.start_immediate_render(
                type="docx",
                target="pdf",
                data={"key": "value"},
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.start_immediate_render(
            type=type,
            target=target,
            data=data,
            template_id=template_id,
            format_opts=format_opts,
            template=template,
            upload_presigned_s_3_url=upload_presigned_s_3_url,
            request_options=request_options,
        )
        return _response.data

    async def get_job_status(
        self, job_id: str, *, request_options: typing.Optional[RequestOptions] = None
    ) -> GetJobStatusResponse:
        """
        Fetches detailed job information from S3 storage including job status, template ID, target format, and output details if available.

        Parameters
        ----------
        job_id : str
            ID of the render job

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        GetJobStatusResponse
            Default Response

        Examples
        --------
        import asyncio

        from Pogodoc import AsyncPogodocApi

        client = AsyncPogodocApi(
            token="YOUR_TOKEN",
        )


        async def main() -> None:
            await client.documents.get_job_status(
                job_id="jobId",
            )


        asyncio.run(main())
        """
        _response = await self._raw_client.get_job_status(job_id, request_options=request_options)
        return _response.data
