# This file was auto-generated by Fern from our API Definition.

import typing

import pydantic
import typing_extensions
from ...core.pydantic_utilities import IS_PYDANTIC_V2, UniversalBaseModel
from ...core.serialization import FieldMetadata
from .initialize_render_job_response_target import InitializeRenderJobResponseTarget


class InitializeRenderJobResponse(UniversalBaseModel):
    job_id: typing_extensions.Annotated[str, FieldMetadata(alias="jobId")] = pydantic.Field()
    """
    ID of the render job
    """

    target: InitializeRenderJobResponseTarget = pydantic.Field()
    """
    Type of output to be rendered
    """

    presigned_data_upload_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="presignedDataUploadUrl")
    ] = pydantic.Field(default=None)
    """
    Presigned URL to upload the data for the render job to S3
    """

    presigned_template_upload_url: typing_extensions.Annotated[
        typing.Optional[str], FieldMetadata(alias="presignedTemplateUploadUrl")
    ] = pydantic.Field(default=None)
    """
    Presigned URL to upload the template for the render job to S3. Only works with EJS templates
    """

    if IS_PYDANTIC_V2:
        model_config: typing.ClassVar[pydantic.ConfigDict] = pydantic.ConfigDict(extra="allow", frozen=True)  # type: ignore # Pydantic v2
    else:

        class Config:
            frozen = True
            smart_union = True
            extra = pydantic.Extra.allow
