# coding: utf-8

"""
AIStudioApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CreateGuide
from ..models import CreateGuideVersion
from ..models import ErrorBody
from ..models import GenerateGuideContentRequest
from ..models import Guide
from ..models import GuideContentGenerationJob
from ..models import GuideEntityListing
from ..models import GuideJob
from ..models import GuideVersion
from ..models import GuideVersionPublishJob
from ..models import GuideVersionPublishJobRequest
from ..models import UpdateGuide
from ..models import UpdateGuideVersion

class AIStudioApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_guide_jobs(self, guide_id: str, **kwargs) -> 'GuideJob':
        """
        Start the deletion of a guide.
        
	    delete_guide_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_guide_jobs(guide_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :return: GuideJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_guide_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `delete_guide_jobs`")


        resource_path = '/api/v2/guides/{guideId}/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guide(self, guide_id: str, **kwargs) -> 'Guide':
        """
        Get guide.
        
	    get_guide is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guide(guide_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :return: Guide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guide" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `get_guide`")


        resource_path = '/api/v2/guides/{guideId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Guide',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guide_job(self, guide_id: str, job_id: str, **kwargs) -> 'GuideJob':
        """
        Get the specified guide deletion job.
        
	    get_guide_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guide_job(guide_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param str job_id: jobId (required)
        :return: GuideJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guide_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `get_guide_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_guide_job`")


        resource_path = '/api/v2/guides/{guideId}/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guide_version(self, guide_id: str, version_id: str, **kwargs) -> 'GuideVersion':
        """
        Get a guide version.
        
	    get_guide_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guide_version(guide_id, version_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param str version_id: Version ID (required)
        :return: GuideVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'version_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guide_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `get_guide_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_guide_version`")


        resource_path = '/api/v2/guides/{guideId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guide_version_job(self, guide_id: str, version_id: str, job_id: str, **kwargs) -> 'GuideVersionPublishJob':
        """
        Get the status of the publishing job for this guide version.
        
	    get_guide_version_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guide_version_job(guide_id, version_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param str version_id: Version ID (required)
        :param str job_id: jobId (required)
        :return: GuideVersionPublishJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'version_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guide_version_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `get_guide_version_job`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `get_guide_version_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_guide_version_job`")


        resource_path = '/api/v2/guides/{guideId}/versions/{versionId}/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideVersionPublishJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guides(self, **kwargs) -> 'GuideEntityListing':
        """
        Get all guides.
        
	    get_guides is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guides(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str name: Filter by matching name - case insensitive.
        :param str name_contains: Filter by name contains - case insensitive.
        :param str status: Filter by status.
        :param str sort_by: Sort by. Default value dateModified.
        :param str sort_order: Sort Order. Default value desc.
        :param int page_number: Page number.
        :param int page_size: Page size. The maximum page size is 100.
        :return: GuideEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['name', 'name_contains', 'status', 'sort_by', 'sort_order', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guides" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/guides'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'name' in params:
            query_params['name'] = params['name']
        if 'name_contains' in params:
            query_params['nameContains'] = params['name_contains']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_guides_job(self, job_id: str, **kwargs) -> 'GuideContentGenerationJob':
        """
        Get the status of the guide content generation job.
        
	    get_guides_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_guides_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :return: GuideContentGenerationJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_guides_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_guides_job`")


        resource_path = '/api/v2/guides/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideContentGenerationJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_guide(self, guide_id: str, body: 'UpdateGuide', **kwargs) -> 'Guide':
        """
        Update a guide.
        
	    patch_guide is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_guide(guide_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param UpdateGuide body:  (required)
        :return: Guide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_guide" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `patch_guide`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_guide`")


        resource_path = '/api/v2/guides/{guideId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Guide',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_guide_version(self, guide_id: str, version_id: str, body: 'UpdateGuideVersion', **kwargs) -> 'GuideVersion':
        """
        Update a guide version.
        
	    patch_guide_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_guide_version(guide_id, version_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param str version_id: Version ID (required)
        :param UpdateGuideVersion body:  (required)
        :return: GuideVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'version_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_guide_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `patch_guide_version`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `patch_guide_version`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_guide_version`")


        resource_path = '/api/v2/guides/{guideId}/versions/{versionId}'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_guide_version_jobs(self, guide_id: str, version_id: str, body: 'GuideVersionPublishJobRequest', **kwargs) -> 'GuideVersionPublishJob':
        """
        Start the publishing of a guide version.
        
	    post_guide_version_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_guide_version_jobs(guide_id, version_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param str version_id: Version ID (required)
        :param GuideVersionPublishJobRequest body:  (required)
        :return: GuideVersionPublishJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'version_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_guide_version_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `post_guide_version_jobs`")
        # verify the required parameter 'version_id' is set
        if ('version_id' not in params) or (params['version_id'] is None):
            raise ValueError("Missing the required parameter `version_id` when calling `post_guide_version_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_guide_version_jobs`")


        resource_path = '/api/v2/guides/{guideId}/versions/{versionId}/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']
        if 'version_id' in params:
            path_params['versionId'] = params['version_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideVersionPublishJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_guide_versions(self, guide_id: str, **kwargs) -> 'GuideVersion':
        """
        Create a guide version.
        
	    post_guide_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_guide_versions(guide_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str guide_id: Guide ID (required)
        :param CreateGuideVersion body: 
        :return: GuideVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['guide_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_guide_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'guide_id' is set
        if ('guide_id' not in params) or (params['guide_id'] is None):
            raise ValueError("Missing the required parameter `guide_id` when calling `post_guide_versions`")


        resource_path = '/api/v2/guides/{guideId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'guide_id' in params:
            path_params['guideId'] = params['guide_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_guides(self, body: 'CreateGuide', **kwargs) -> 'Guide':
        """
        Create a guide.
        
	    post_guides is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_guides(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateGuide body:  (required)
        :return: Guide
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_guides" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_guides`")


        resource_path = '/api/v2/guides'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Guide',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_guides_jobs(self, body: 'GenerateGuideContentRequest', **kwargs) -> 'GuideContentGenerationJob':
        """
        Start a guide content generation job.
        
	    post_guides_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_guides_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GenerateGuideContentRequest body:  (required)
        :return: GuideContentGenerationJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_guides_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_guides_jobs`")


        resource_path = '/api/v2/guides/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GuideContentGenerationJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
