# coding: utf-8

"""
AlertingApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import AlertListing
from ..models import AlertRequest
from ..models import AlertingUnreadStatus
from ..models import BulkResponse
from ..models import CommonAlert
from ..models import CommonAlertBulkUpdateRequest
from ..models import CommonAllAlertUpdateRequest
from ..models import CommonRule
from ..models import CommonRuleBulkDeleteRequest
from ..models import CommonRuleBulkUpdateNotificationsRequest
from ..models import CommonRuleContainer
from ..models import ErrorBody
from ..models import GetAlertQuery
from ..models import GetRulesQuery
from ..models import ModifiableRuleProperties

class AlertingApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_alerting_alert(self, alert_id: str, **kwargs) -> None:
        """
        Delete an alert
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_alerting_alert(alert_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str alert_id: Alert ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alerting_alert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params) or (params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `delete_alerting_alert`")


        resource_path = '/api/v2/alerting/alerts/{alertId}'.replace('{format}', 'json')
        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_alerting_alerts_all(self, **kwargs) -> object:
        """
        Delete all alerts for the user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_alerting_alerts_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alerting_alerts_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/alerting/alerts/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_alerting_rule(self, rule_id: str, **kwargs) -> None:
        """
        Delete a rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_alerting_rule(rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: Rule Id (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_alerting_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `delete_alerting_rule`")


        resource_path = '/api/v2/alerting/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_alerting_alert(self, alert_id: str, **kwargs) -> 'CommonAlert':
        """
        Get an alert
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_alerting_alert(alert_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str alert_id: Alert ID (required)
        :return: CommonAlert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alerting_alert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params) or (params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `get_alerting_alert`")


        resource_path = '/api/v2/alerting/alerts/{alertId}'.replace('{format}', 'json')
        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonAlert',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_alerting_rule(self, rule_id: str, **kwargs) -> 'CommonRule':
        """
        Get a rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_alerting_rule(rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: Rule Id (required)
        :return: CommonRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_alerting_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `get_alerting_rule`")


        resource_path = '/api/v2/alerting/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_alerting_alert(self, alert_id: str, **kwargs) -> 'CommonAlert':
        """
        Allows an entity to mute/snooze an alert or update the unread status of the alert.
        Snoozing an alert temporarily stop it from resending notifications to individualsas well as other services within Genesys Cloud for a given period.  Muting an alert will only block the notifications to individuals.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_alerting_alert(alert_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str alert_id: Alert ID (required)
        :param AlertRequest body: 
        :return: CommonAlert
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alerting_alert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params) or (params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `patch_alerting_alert`")


        resource_path = '/api/v2/alerting/alerts/{alertId}'.replace('{format}', 'json')
        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonAlert',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_alerting_alerts_all(self, **kwargs) -> object:
        """
        Updates all alerts
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_alerting_alerts_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CommonAllAlertUpdateRequest body: 
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alerting_alerts_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/alerting/alerts/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_alerting_alerts_bulk(self, body: 'CommonAlertBulkUpdateRequest', **kwargs) -> 'BulkResponse':
        """
        Bulk alert updates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_alerting_alerts_bulk(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CommonAlertBulkUpdateRequest body:  (required)
        :return: BulkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alerting_alerts_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_alerting_alerts_bulk`")


        resource_path = '/api/v2/alerting/alerts/bulk'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_alerting_rules_bulk(self, body: 'CommonRuleBulkUpdateNotificationsRequest', **kwargs) -> 'BulkResponse':
        """
        Bulk update of notification lists
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_alerting_rules_bulk(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CommonRuleBulkUpdateNotificationsRequest body:  (required)
        :return: BulkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_alerting_rules_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_alerting_rules_bulk`")


        resource_path = '/api/v2/alerting/rules/bulk'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_alerting_alerts_query(self, **kwargs) -> 'AlertListing':
        """
        Gets a paged list of alerts. The max page size is 50
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_alerting_alerts_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GetAlertQuery body: 
        :return: AlertListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alerting_alerts_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/alerting/alerts/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AlertListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_alerting_rules(self, body: 'CommonRule', **kwargs) -> 'CommonRule':
        """
        Create a Rule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_alerting_rules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CommonRule body: rule to be created (required)
        :return: CommonRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alerting_rules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_alerting_rules`")


        resource_path = '/api/v2/alerting/rules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_alerting_rules_bulk_remove(self, body: 'CommonRuleBulkDeleteRequest', **kwargs) -> 'BulkResponse':
        """
        Bulk remove rules
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_alerting_rules_bulk_remove(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CommonRuleBulkDeleteRequest body:  (required)
        :return: BulkResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alerting_rules_bulk_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_alerting_rules_bulk_remove`")


        resource_path = '/api/v2/alerting/rules/bulk/remove'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BulkResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_alerting_rules_query(self, **kwargs) -> 'CommonRuleContainer':
        """
        Get a paged list of rules.  The max size of the page is 50 items.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_alerting_rules_query(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GetRulesQuery body: 
        :return: CommonRuleContainer
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_alerting_rules_query" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/alerting/rules/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonRuleContainer',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_alerting_alert(self, alert_id: str, **kwargs) -> 'AlertingUnreadStatus':
        """
        Update an alert read status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_alerting_alert(alert_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str alert_id: Alert ID (required)
        :param AlertingUnreadStatus body: 
        :return: AlertingUnreadStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['alert_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_alerting_alert" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'alert_id' is set
        if ('alert_id' not in params) or (params['alert_id'] is None):
            raise ValueError("Missing the required parameter `alert_id` when calling `put_alerting_alert`")


        resource_path = '/api/v2/alerting/alerts/{alertId}'.replace('{format}', 'json')
        path_params = {}
        if 'alert_id' in params:
            path_params['alertId'] = params['alert_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AlertingUnreadStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_alerting_rule(self, rule_id: str, body: 'ModifiableRuleProperties', **kwargs) -> 'CommonRule':
        """
        Update a rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_alerting_rule(rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_id: Rule Id (required)
        :param ModifiableRuleProperties body: rule to be updated (required)
        :return: CommonRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_alerting_rule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_id' is set
        if ('rule_id' not in params) or (params['rule_id'] is None):
            raise ValueError("Missing the required parameter `rule_id` when calling `put_alerting_rule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_alerting_rule`")


        resource_path = '/api/v2/alerting/rules/{ruleId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_id' in params:
            path_params['ruleId'] = params['rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
