# coding: utf-8

"""
BusinessRulesApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CopyDecisionTableRequest
from ..models import Coretype
from ..models import CoretypeListing
from ..models import CreateDecisionTableRequest
from ..models import CreateDecisionTableRowRequest
from ..models import DataSchema
from ..models import DataSchemaListing
from ..models import DecisionTable
from ..models import DecisionTableExecutionRequest
from ..models import DecisionTableExecutionResponse
from ..models import DecisionTableListing
from ..models import DecisionTableRow
from ..models import DecisionTableRowListing
from ..models import DecisionTableVersion
from ..models import DecisionTableVersionListing
from ..models import ErrorBody
from ..models import PutDecisionTableRowRequest
from ..models import SearchDecisionTableRowsRequest
from ..models import UpdateDecisionTableRequest
from ..models import UpdateDecisionTableVersionRequest

class BusinessRulesApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_businessrules_decisiontable(self, table_id: str, **kwargs) -> None:
        """
        Delete a decision table
        
	    delete_businessrules_decisiontable is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_businessrules_decisiontable(table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param bool force_delete: Force delete decision table (under certain conditions)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'force_delete']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_businessrules_decisiontable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `delete_businessrules_decisiontable`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}
        if 'force_delete' in params:
            query_params['forceDelete'] = params['force_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_businessrules_decisiontable_version(self, table_id: str, table_version: int, **kwargs) -> None:
        """
        Delete a decision table version
        
	    delete_businessrules_decisiontable_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_businessrules_decisiontable_version(table_id, table_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_businessrules_decisiontable_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `delete_businessrules_decisiontable_version`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `delete_businessrules_decisiontable_version`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_businessrules_decisiontable_version_row(self, table_id: str, table_version: int, row_id: str, **kwargs) -> None:
        """
        Delete a decision table row
        
	    delete_businessrules_decisiontable_version_row is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_businessrules_decisiontable_version_row(table_id, table_version, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param str row_id: Row ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'row_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_businessrules_decisiontable_version_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `delete_businessrules_decisiontable_version_row`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `delete_businessrules_decisiontable_version_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `delete_businessrules_decisiontable_version_row`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_businessrules_schema(self, schema_id: str, **kwargs) -> None:
        """
        Delete a schema
        
	    delete_businessrules_schema is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_businessrules_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_businessrules_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `delete_businessrules_schema`")


        resource_path = '/api/v2/businessrules/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontable(self, table_id: str, **kwargs) -> 'DecisionTable':
        """
        Get a decision table
        
	    get_businessrules_decisiontable is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontable(table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :return: DecisionTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_businessrules_decisiontable`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontable_version(self, table_id: str, table_version: int, **kwargs) -> 'DecisionTableVersion':
        """
        Get a decision table version
        
	    get_businessrules_decisiontable_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontable_version(table_id, table_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontable_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_businessrules_decisiontable_version`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `get_businessrules_decisiontable_version`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontable_version_row(self, table_id: str, table_version: int, row_id: str, **kwargs) -> 'DecisionTableRow':
        """
        Get a decision table row
        
	    get_businessrules_decisiontable_version_row is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontable_version_row(table_id, table_version, row_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param str row_id: Row ID (required)
        :return: DecisionTableRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'row_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontable_version_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_businessrules_decisiontable_version_row`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `get_businessrules_decisiontable_version_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `get_businessrules_decisiontable_version_row`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableRow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontable_version_rows(self, table_id: str, table_version: int, **kwargs) -> 'DecisionTableRowListing':
        """
        Get a list of decision table rows.
        
	    get_businessrules_decisiontable_version_rows is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontable_version_rows(table_id, table_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param str page_number: Page number of the entities to return. Defaults to 1.
        :param str page_size: Number of entities to return. Maximum of 100. Defaults to 25.
        :return: DecisionTableRowListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontable_version_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_businessrules_decisiontable_version_rows`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `get_businessrules_decisiontable_version_rows`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableRowListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontable_versions(self, table_id: str, **kwargs) -> 'DecisionTableVersionListing':
        """
        Get a list of decision table versions
        
	    get_businessrules_decisiontable_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontable_versions(table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 100.
        :return: DecisionTableVersionListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontable_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `get_businessrules_decisiontable_versions`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersionListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontables(self, **kwargs) -> 'DecisionTableListing':
        """
        Get a list of decision tables.
        
	    get_businessrules_decisiontables is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontables(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 100.
        :param list[str] division_ids: One or more comma separated divisions to filters decision tables by. If nothing is provided, the decision tables associated with the list of divisions that the user has access to will be returned.
        :param str name: Search for decision tables with a name that contains the given search string. Search is case insensitive and will match any table that contains this string in any part of the name.
        :return: DecisionTableListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'page_size', 'division_ids', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontables" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/businessrules/decisiontables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'division_ids' in params:
            query_params['divisionIds'] = params['division_ids']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_decisiontables_search(self, **kwargs) -> 'DecisionTableListing':
        """
        Search for decision tables.
        
	    get_businessrules_decisiontables_search is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_decisiontables_search(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :param str page_size: Number of entities to return. Maximum of 100.
        :param str schema_id: Search for decision tables that use the schema with this ID. Cannot be combined with name search. Search results will not be paginated if used.
        :param str name: Search for decision tables with a name that contains the given search string. Search is case insensitive and will match any table that contains this string in any part of the name. Cannot be combined with schema search. Search results will not be paginated if used.
        :param bool with_published_version: Filters results to only decision tables that have at least one version in Published status
        :param list[str] expand: Fields to expand in response
        :param list[str] ids: Decision table IDs to search for
        :return: DecisionTableListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'page_size', 'schema_id', 'name', 'with_published_version', 'expand', 'ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_decisiontables_search" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/businessrules/decisiontables/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'schema_id' in params:
            query_params['schemaId'] = params['schema_id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'with_published_version' in params:
            query_params['withPublishedVersion'] = params['with_published_version']
        if 'expand' in params:
            query_params['expand'] = params['expand']
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_schema(self, schema_id: str, **kwargs) -> 'DataSchema':
        """
        Get a schema
        
	    get_businessrules_schema is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_schema(schema_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `get_businessrules_schema`")


        resource_path = '/api/v2/businessrules/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_schemas(self, **kwargs) -> 'DataSchemaListing':
        """
        Get a list of schemas.
        
	    get_businessrules_schemas is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_schemas(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DataSchemaListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_schemas" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/businessrules/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchemaListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_schemas_coretype(self, core_type_name: str, **kwargs) -> 'Coretype':
        """
        Get a specific named core type.
        
	    get_businessrules_schemas_coretype is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_schemas_coretype(core_type_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str core_type_name: The core type's name (required)
        :return: Coretype
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['core_type_name']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_schemas_coretype" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'core_type_name' is set
        if ('core_type_name' not in params) or (params['core_type_name'] is None):
            raise ValueError("Missing the required parameter `core_type_name` when calling `get_businessrules_schemas_coretype`")


        resource_path = '/api/v2/businessrules/schemas/coretypes/{coreTypeName}'.replace('{format}', 'json')
        path_params = {}
        if 'core_type_name' in params:
            path_params['coreTypeName'] = params['core_type_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Coretype',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_businessrules_schemas_coretypes(self, **kwargs) -> 'CoretypeListing':
        """
        Get the core types from which all schemas are built.
        
	    get_businessrules_schemas_coretypes is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_businessrules_schemas_coretypes(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: CoretypeListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_businessrules_schemas_coretypes" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/businessrules/schemas/coretypes'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CoretypeListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_businessrules_decisiontable(self, table_id: str, body: 'UpdateDecisionTableRequest', **kwargs) -> 'DecisionTable':
        """
        Update a decision table
        
	    patch_businessrules_decisiontable is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_businessrules_decisiontable(table_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param UpdateDecisionTableRequest body: Decision Table (required)
        :return: DecisionTable
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_businessrules_decisiontable" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `patch_businessrules_decisiontable`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_businessrules_decisiontable`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTable',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_businessrules_decisiontable_version(self, table_id: str, table_version: int, body: 'UpdateDecisionTableVersionRequest', **kwargs) -> 'DecisionTableVersion':
        """
        Update a decision table version
        
	    patch_businessrules_decisiontable_version is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_businessrules_decisiontable_version(table_id, table_version, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param UpdateDecisionTableVersionRequest body: Decision Table (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_businessrules_decisiontable_version" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `patch_businessrules_decisiontable_version`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `patch_businessrules_decisiontable_version`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_businessrules_decisiontable_version`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_execute(self, table_id: str, body: 'DecisionTableExecutionRequest', **kwargs) -> 'DecisionTableExecutionResponse':
        """
        Execute a published decision table
        
	    post_businessrules_decisiontable_execute is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_execute(table_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param DecisionTableExecutionRequest body: Decision Table (required)
        :return: DecisionTableExecutionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_execute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_execute`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontable_execute`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/execute'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableExecutionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_version_copy(self, table_id: str, table_version: int, body: 'CopyDecisionTableRequest', **kwargs) -> 'DecisionTableVersion':
        """
        Copy a decision table version
        
	    post_businessrules_decisiontable_version_copy is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_version_copy(table_id, table_version, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param CopyDecisionTableRequest body: Decision Table (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_version_copy" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_version_copy`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `post_businessrules_decisiontable_version_copy`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontable_version_copy`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/copy'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_version_execute(self, table_id: str, table_version: int, body: 'DecisionTableExecutionRequest', **kwargs) -> 'DecisionTableExecutionResponse':
        """
        Execute a decision table version
        
	    post_businessrules_decisiontable_version_execute is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_version_execute(table_id, table_version, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param DecisionTableExecutionRequest body: Decision Table (required)
        :return: DecisionTableExecutionResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_version_execute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_version_execute`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `post_businessrules_decisiontable_version_execute`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontable_version_execute`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/execute'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableExecutionResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_version_rows(self, table_id: str, table_version: int, body: 'CreateDecisionTableRowRequest', **kwargs) -> 'DecisionTableRow':
        """
        Create a decision table row
        
	    post_businessrules_decisiontable_version_rows is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_version_rows(table_id, table_version, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param CreateDecisionTableRowRequest body: Create decision table row request (required)
        :return: DecisionTableRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_version_rows" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_version_rows`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `post_businessrules_decisiontable_version_rows`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontable_version_rows`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableRow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_version_rows_search(self, table_id: str, table_version: int, body: 'SearchDecisionTableRowsRequest', **kwargs) -> 'DecisionTableRowListing':
        """
        Search for decision table rows
        
	    post_businessrules_decisiontable_version_rows_search is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_version_rows_search(table_id, table_version, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param SearchDecisionTableRowsRequest body: Search decision table rows request (required)
        :param str page_number: Page number of the entities to return. Defaults to 1.
        :param str page_size: Number of entities to return. Maximum of 100. Defaults to 25.
        :return: DecisionTableRowListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'body', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_version_rows_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_version_rows_search`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `post_businessrules_decisiontable_version_rows_search`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontable_version_rows_search`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows/search'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableRowListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_version_sync(self, table_id: str, table_version: int, **kwargs) -> 'DecisionTableVersion':
        """
        Update the Business Rules Schema to the latest version for a given decision table version
        
	    post_businessrules_decisiontable_version_sync is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_version_sync(table_id, table_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_version_sync" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_version_sync`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `post_businessrules_decisiontable_version_sync`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/sync'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontable_versions(self, table_id: str, **kwargs) -> 'DecisionTableVersion':
        """
        Create a new decision table version
        
	    post_businessrules_decisiontable_versions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontable_versions(table_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontable_versions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `post_businessrules_decisiontable_versions`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_decisiontables(self, body: 'CreateDecisionTableRequest', **kwargs) -> 'DecisionTableVersion':
        """
        Create a decision table
        
	    post_businessrules_decisiontables is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_decisiontables(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateDecisionTableRequest body: Decision Table (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_decisiontables" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_decisiontables`")


        resource_path = '/api/v2/businessrules/decisiontables'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_businessrules_schemas(self, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Create a schema
        
	    post_businessrules_schemas is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_businessrules_schemas(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DataSchema body: Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_businessrules_schemas" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_businessrules_schemas`")


        resource_path = '/api/v2/businessrules/schemas'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_businessrules_decisiontable_version_publish(self, table_id: str, table_version: int, **kwargs) -> 'DecisionTableVersion':
        """
        Publish a decision table version
        
	    put_businessrules_decisiontable_version_publish is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_businessrules_decisiontable_version_publish(table_id, table_version, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :return: DecisionTableVersion
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_businessrules_decisiontable_version_publish" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `put_businessrules_decisiontable_version_publish`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `put_businessrules_decisiontable_version_publish`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/publish'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableVersion',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_businessrules_decisiontable_version_row(self, table_id: str, table_version: int, row_id: str, body: 'PutDecisionTableRowRequest', **kwargs) -> 'DecisionTableRow':
        """
        Full update a decision table row
        
	    put_businessrules_decisiontable_version_row is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_businessrules_decisiontable_version_row(table_id, table_version, row_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str table_id: Table ID (required)
        :param int table_version: Table Version (required)
        :param str row_id: Row ID (required)
        :param PutDecisionTableRowRequest body: Full update decision table row request (required)
        :return: DecisionTableRow
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['table_id', 'table_version', 'row_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_businessrules_decisiontable_version_row" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'table_id' is set
        if ('table_id' not in params) or (params['table_id'] is None):
            raise ValueError("Missing the required parameter `table_id` when calling `put_businessrules_decisiontable_version_row`")
        # verify the required parameter 'table_version' is set
        if ('table_version' not in params) or (params['table_version'] is None):
            raise ValueError("Missing the required parameter `table_version` when calling `put_businessrules_decisiontable_version_row`")
        # verify the required parameter 'row_id' is set
        if ('row_id' not in params) or (params['row_id'] is None):
            raise ValueError("Missing the required parameter `row_id` when calling `put_businessrules_decisiontable_version_row`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_businessrules_decisiontable_version_row`")


        resource_path = '/api/v2/businessrules/decisiontables/{tableId}/versions/{tableVersion}/rows/{rowId}'.replace('{format}', 'json')
        path_params = {}
        if 'table_id' in params:
            path_params['tableId'] = params['table_id']
        if 'table_version' in params:
            path_params['tableVersion'] = params['table_version']
        if 'row_id' in params:
            path_params['rowId'] = params['row_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DecisionTableRow',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_businessrules_schema(self, schema_id: str, body: 'DataSchema', **kwargs) -> 'DataSchema':
        """
        Update a schema
        
	    put_businessrules_schema is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_businessrules_schema(schema_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str schema_id: Schema ID (required)
        :param DataSchema body: Data Schema (required)
        :return: DataSchema
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['schema_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_businessrules_schema" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'schema_id' is set
        if ('schema_id' not in params) or (params['schema_id'] is None):
            raise ValueError("Missing the required parameter `schema_id` when calling `put_businessrules_schema`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_businessrules_schema`")


        resource_path = '/api/v2/businessrules/schemas/{schemaId}'.replace('{format}', 'json')
        path_params = {}
        if 'schema_id' in params:
            path_params['schemaId'] = params['schema_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DataSchema',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
