# coding: utf-8

"""
ChatApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ChatMessageEntityListing
from ..models import ChatMessageResponse
from ..models import ChatReactionUpdate
from ..models import ChatSendMessageResponse
from ..models import ChatSettings
from ..models import ChatUserSettings
from ..models import CreateRoomRequest
from ..models import CreateRoomResponse
from ..models import ErrorBody
from ..models import OneOnOne
from ..models import PinnedMessageRequest
from ..models import Room
from ..models import RoomParticipant
from ..models import RoomParticipantsResponse
from ..models import RoomUpdateRequest
from ..models import SendMessageBody
from ..models import UserChatSettingsPost
from ..models import UserSettingsForChat

class ChatApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_chats_room_message(self, room_jid: str, message_id: str, **kwargs) -> None:
        """
        Delete a message in a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_room_message(room_jid, message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomId (required)
        :param str message_id: messageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'message_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_room_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `delete_chats_room_message`")
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `delete_chats_room_message`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_chats_room_messages_pin(self, room_jid: str, pinned_message_id: str, **kwargs) -> None:
        """
        Remove a pinned message from a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_room_messages_pin(room_jid, pinned_message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str pinned_message_id: pinnedMessageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'pinned_message_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_room_messages_pin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `delete_chats_room_messages_pin`")
        # verify the required parameter 'pinned_message_id' is set
        if ('pinned_message_id' not in params) or (params['pinned_message_id'] is None):
            raise ValueError("Missing the required parameter `pinned_message_id` when calling `delete_chats_room_messages_pin`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages/pins/{pinnedMessageId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'pinned_message_id' in params:
            path_params['pinnedMessageId'] = params['pinned_message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_chats_room_participant(self, room_jid: str, user_id: str, **kwargs) -> None:
        """
        Remove a user from a room.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_room_participant(room_jid, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str user_id: userId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'user_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_room_participant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `delete_chats_room_participant`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_chats_room_participant`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/participants/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_chats_user_message(self, user_id: str, message_id: str, **kwargs) -> None:
        """
        Delete a message to a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_user_message(user_id, message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param str message_id: messageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'message_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_user_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_chats_user_message`")
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `delete_chats_user_message`")


        resource_path = '/api/v2/chats/users/{userId}/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_chats_user_messages_pin(self, user_id: str, pinned_message_id: str, **kwargs) -> None:
        """
        Remove a pinned message from a 1on1
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_user_messages_pin(user_id, pinned_message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param str pinned_message_id: pinnedMessageId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'pinned_message_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_user_messages_pin" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `delete_chats_user_messages_pin`")
        # verify the required parameter 'pinned_message_id' is set
        if ('pinned_message_id' not in params) or (params['pinned_message_id'] is None):
            raise ValueError("Missing the required parameter `pinned_message_id` when calling `delete_chats_user_messages_pin`")


        resource_path = '/api/v2/chats/users/{userId}/messages/pins/{pinnedMessageId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'pinned_message_id' in params:
            path_params['pinnedMessageId'] = params['pinned_message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_chats_users_me_settings(self, **kwargs) -> None:
        """
        Delete a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_chats_users_me_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_chats_users_me_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/chats/users/me/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_message(self, message_id: str, **kwargs) -> 'ChatMessageResponse':
        """
        Get a message
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_message(message_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message_id: messageId (required)
        :return: ChatMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `get_chats_message`")


        resource_path = '/api/v2/chats/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_room(self, room_jid: str, **kwargs) -> 'Room':
        """
        Get a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_room(room_jid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :return: Room
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_room" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `get_chats_room`")


        resource_path = '/api/v2/chats/rooms/{roomJid}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Room',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_room_message(self, room_jid: str, message_ids: str, **kwargs) -> 'ChatMessageEntityListing':
        """
        Get messages by id(s) from a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_room_message(room_jid, message_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str message_ids: messageIds, comma separated (required)
        :return: ChatMessageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'message_ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_room_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `get_chats_room_message`")
        # verify the required parameter 'message_ids' is set
        if ('message_ids' not in params) or (params['message_ids'] is None):
            raise ValueError("Missing the required parameter `message_ids` when calling `get_chats_room_message`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages/{messageIds}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'message_ids' in params:
            path_params['messageIds'] = params['message_ids']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_room_messages(self, room_jid: str, **kwargs) -> 'ChatMessageEntityListing':
        """
        Get a room's message history
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_room_messages(room_jid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str limit: The maximum number of messages to retrieve
        :param str before: The cutoff date for messages to retrieve
        :param str after: The beginning date for messages to retrieve
        :param bool exclude_metadata: Whether to exclude metadata for messages
        :return: ChatMessageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'limit', 'before', 'after', 'exclude_metadata']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_room_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `get_chats_room_messages`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'exclude_metadata' in params:
            query_params['excludeMetadata'] = params['exclude_metadata']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_room_participant(self, room_jid: str, participant_jid: str, **kwargs) -> 'RoomParticipant':
        """
        Get a room participant
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_room_participant(room_jid, participant_jid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str participant_jid: participantJid (required)
        :return: RoomParticipant
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'participant_jid']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_room_participant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `get_chats_room_participant`")
        # verify the required parameter 'participant_jid' is set
        if ('participant_jid' not in params) or (params['participant_jid'] is None):
            raise ValueError("Missing the required parameter `participant_jid` when calling `get_chats_room_participant`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/participants/{participantJid}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'participant_jid' in params:
            path_params['participantJid'] = params['participant_jid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoomParticipant',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_room_participants(self, room_jid: str, **kwargs) -> 'RoomParticipantsResponse':
        """
        Get room participants in a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_room_participants(room_jid, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param bool notify: Whether to get users to notify
        :return: RoomParticipantsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'notify']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_room_participants" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `get_chats_room_participants`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/participants'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}
        if 'notify' in params:
            query_params['notify'] = params['notify']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RoomParticipantsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_settings(self, **kwargs) -> 'ChatSettings':
        """
        Get Chat Settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: ChatSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/chats/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_thread_messages(self, thread_id: str, **kwargs) -> 'ChatMessageEntityListing':
        """
        Get history by thread
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_thread_messages(thread_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str thread_id: threadId (required)
        :param str limit: The maximum number of messages to retrieve
        :param str before: The cutoff date for messages to retrieve
        :param str after: The beginning date for messages to retrieve
        :param bool exclude_metadata: Whether to exclude metadata for messages
        :return: ChatMessageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['thread_id', 'limit', 'before', 'after', 'exclude_metadata']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_thread_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'thread_id' is set
        if ('thread_id' not in params) or (params['thread_id'] is None):
            raise ValueError("Missing the required parameter `thread_id` when calling `get_chats_thread_messages`")


        resource_path = '/api/v2/chats/threads/{threadId}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'thread_id' in params:
            path_params['threadId'] = params['thread_id']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'exclude_metadata' in params:
            query_params['excludeMetadata'] = params['exclude_metadata']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_user(self, user_id: str, **kwargs) -> 'OneOnOne':
        """
        Get information for a 1on1
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_user(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :return: OneOnOne
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_user" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_chats_user`")


        resource_path = '/api/v2/chats/users/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OneOnOne',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_user_message(self, user_id: str, message_ids: str, **kwargs) -> 'ChatMessageEntityListing':
        """
        Get messages by id(s) from a 1on1
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_user_message(user_id, message_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param str message_ids: messageIds, comma separated (required)
        :return: ChatMessageEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'message_ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_user_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_chats_user_message`")
        # verify the required parameter 'message_ids' is set
        if ('message_ids' not in params) or (params['message_ids'] is None):
            raise ValueError("Missing the required parameter `message_ids` when calling `get_chats_user_message`")


        resource_path = '/api/v2/chats/users/{userId}/messages/{messageIds}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'message_ids' in params:
            path_params['messageIds'] = params['message_ids']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_user_messages(self, user_id: str, **kwargs) -> 'ChatMessageResponse':
        """
        Get 1on1 History between a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_user_messages(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param str limit: The maximum number of messages to retrieve
        :param str before: The cutoff date for messages to retrieve
        :param str after: The beginning date for messages to retrieve
        :param bool exclude_metadata: Whether to exclude metadata for messages
        :return: ChatMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'limit', 'before', 'after', 'exclude_metadata']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_user_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_chats_user_messages`")


        resource_path = '/api/v2/chats/users/{userId}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'limit' in params:
            query_params['limit'] = params['limit']
        if 'before' in params:
            query_params['before'] = params['before']
        if 'after' in params:
            query_params['after'] = params['after']
        if 'exclude_metadata' in params:
            query_params['excludeMetadata'] = params['exclude_metadata']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_user_settings(self, user_id: str, **kwargs) -> 'ChatUserSettings':
        """
        Get a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_user_settings(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: ChatUserSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_user_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_chats_user_settings`")


        resource_path = '/api/v2/chats/users/{userId}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatUserSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_chats_users_me_settings(self, **kwargs) -> 'UserSettingsForChat':
        """
        Get a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_chats_users_me_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: UserSettingsForChat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_chats_users_me_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/chats/users/me/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSettingsForChat',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_room(self, room_jid: str, body: 'RoomUpdateRequest', **kwargs) -> None:
        """
        Set properties for a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_room(room_jid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param RoomUpdateRequest body: Room properties (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_room" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `patch_chats_room`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_room`")


        resource_path = '/api/v2/chats/rooms/{roomJid}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_room_message(self, room_jid: str, message_id: str, body: 'SendMessageBody', **kwargs) -> 'ChatSendMessageResponse':
        """
        Edit a message in a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_room_message(room_jid, message_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomId (required)
        :param str message_id: messageId (required)
        :param SendMessageBody body: messageBody (required)
        :return: ChatSendMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'message_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_room_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `patch_chats_room_message`")
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `patch_chats_room_message`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_room_message`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSendMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_settings(self, body: 'ChatSettings', **kwargs) -> 'ChatSettings':
        """
        Patch Chat Settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ChatSettings body: Chat (required)
        :return: ChatSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_settings`")


        resource_path = '/api/v2/chats/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_user_message(self, user_id: str, message_id: str, body: 'SendMessageBody', **kwargs) -> 'ChatSendMessageResponse':
        """
        Edit a message to a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_user_message(user_id, message_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param str message_id: messageId (required)
        :param SendMessageBody body: message body (required)
        :return: ChatSendMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'message_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_user_message" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_chats_user_message`")
        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `patch_chats_user_message`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_user_message`")


        resource_path = '/api/v2/chats/users/{userId}/messages/{messageId}'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSendMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_user_settings(self, user_id: str, body: 'ChatUserSettings', **kwargs) -> 'ChatUserSettings':
        """
        Update a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_user_settings(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param ChatUserSettings body:  (required)
        :return: ChatUserSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_user_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `patch_chats_user_settings`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_user_settings`")


        resource_path = '/api/v2/chats/users/{userId}/settings'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatUserSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_chats_users_me_settings(self, body: 'UserSettingsForChat', **kwargs) -> 'UserSettingsForChat':
        """
        Update a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_chats_users_me_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserSettingsForChat body:  (required)
        :return: UserSettingsForChat
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_chats_users_me_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_chats_users_me_settings`")


        resource_path = '/api/v2/chats/users/me/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UserSettingsForChat',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_room_messages(self, room_jid: str, body: 'SendMessageBody', **kwargs) -> 'ChatSendMessageResponse':
        """
        Send a message to a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_room_messages(room_jid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomId (required)
        :param SendMessageBody body: messageBody (required)
        :return: ChatSendMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_room_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `post_chats_room_messages`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_room_messages`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSendMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_room_messages_pins(self, room_jid: str, body: 'PinnedMessageRequest', **kwargs) -> None:
        """
        Add pinned messages for a room, up to a maximum of 5 pinned messages
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_room_messages_pins(room_jid, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param PinnedMessageRequest body: Pinned Message Ids (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_room_messages_pins" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `post_chats_room_messages_pins`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_room_messages_pins`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/messages/pins'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_room_participant(self, room_jid: str, user_id: str, **kwargs) -> None:
        """
        Join a room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_room_participant(room_jid, user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str room_jid: roomJid (required)
        :param str user_id: userId (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['room_jid', 'user_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_room_participant" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'room_jid' is set
        if ('room_jid' not in params) or (params['room_jid'] is None):
            raise ValueError("Missing the required parameter `room_jid` when calling `post_chats_room_participant`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_chats_room_participant`")


        resource_path = '/api/v2/chats/rooms/{roomJid}/participants/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'room_jid' in params:
            path_params['roomJid'] = params['room_jid']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_rooms(self, body: 'CreateRoomRequest', **kwargs) -> 'CreateRoomResponse':
        """
        Create an adhoc room
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_rooms(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateRoomRequest body: Room properties (required)
        :return: CreateRoomResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_rooms" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_rooms`")


        resource_path = '/api/v2/chats/rooms'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CreateRoomResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_user_messages(self, user_id: str, body: 'SendMessageBody', **kwargs) -> 'ChatSendMessageResponse':
        """
        Send a message to a user
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_user_messages(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param SendMessageBody body: message body (required)
        :return: ChatSendMessageResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_user_messages" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_chats_user_messages`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_user_messages`")


        resource_path = '/api/v2/chats/users/{userId}/messages'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSendMessageResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_user_messages_pins(self, user_id: str, body: 'PinnedMessageRequest', **kwargs) -> None:
        """
        Add pinned messages for a 1on1, up to a maximum of 5 pinned messages
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_user_messages_pins(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: userId (required)
        :param PinnedMessageRequest body: Pinned Message Ids (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_user_messages_pins" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_chats_user_messages_pins`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_user_messages_pins`")


        resource_path = '/api/v2/chats/users/{userId}/messages/pins'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_chats_users_me_settings(self, body: 'UserChatSettingsPost', **kwargs) -> None:
        """
        Create a user's chat settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_chats_users_me_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param UserChatSettingsPost body:  (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_chats_users_me_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_chats_users_me_settings`")


        resource_path = '/api/v2/chats/users/me/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_chats_message_reactions(self, message_id: str, body: 'ChatReactionUpdate', **kwargs) -> None:
        """
        Update reactions to a message
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_chats_message_reactions(message_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str message_id: messageId (required)
        :param ChatReactionUpdate body: reactionUpdate (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['message_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_chats_message_reactions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'message_id' is set
        if ('message_id' not in params) or (params['message_id'] is None):
            raise ValueError("Missing the required parameter `message_id` when calling `put_chats_message_reactions`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_chats_message_reactions`")


        resource_path = '/api/v2/chats/messages/{messageId}/reactions'.replace('{format}', 'json')
        path_params = {}
        if 'message_id' in params:
            path_params['messageId'] = params['message_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_chats_settings(self, body: 'ChatSettings', **kwargs) -> 'ChatSettings':
        """
        Update Chat Settings.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_chats_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ChatSettings body: Chat (required)
        :return: ChatSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_chats_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_chats_settings`")


        resource_path = '/api/v2/chats/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ChatSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
