# coding: utf-8

"""
GreetingsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import DefaultGreetingList
from ..models import DomainEntityListing
from ..models import ErrorBody
from ..models import Greeting
from ..models import GreetingListing
from ..models import GreetingMediaInfo

class GreetingsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_greeting(self, greeting_id: str, **kwargs) -> None:
        """
        Deletes a Greeting with the given GreetingId
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_greeting(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_greeting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `delete_greeting`")


        resource_path = '/api/v2/greetings/{greetingId}'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greeting(self, greeting_id: str, **kwargs) -> 'Greeting':
        """
        Get a Greeting with the given GreetingId
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greeting(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :return: Greeting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greeting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `get_greeting`")


        resource_path = '/api/v2/greetings/{greetingId}'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Greeting',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greeting_downloads(self, greeting_id: str, **kwargs) -> 'GreetingMediaInfo':
        """
        Download a organization greeting recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greeting_downloads(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :param str format_id: The desired media format.
        :return: GreetingMediaInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greeting_downloads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `get_greeting_downloads`")


        resource_path = '/api/v2/greetings/{greetingId}/downloads'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GreetingMediaInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greeting_groups_downloads(self, greeting_id: str, **kwargs) -> 'GreetingMediaInfo':
        """
        Download a group greeting recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greeting_groups_downloads(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :param str format_id: The desired media format.
        :return: GreetingMediaInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greeting_groups_downloads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `get_greeting_groups_downloads`")


        resource_path = '/api/v2/greetings/{greetingId}/groups/downloads'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GreetingMediaInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greeting_media(self, greeting_id: str, **kwargs) -> 'GreetingMediaInfo':
        """
        Get media playback URI for this greeting
        API should migrate to use GET api/v2/greetings/{greetingId}/downloads

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greeting_media(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :param str format_id: The desired media format.
        :return: GreetingMediaInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greeting_media" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `get_greeting_media`")


        resource_path = '/api/v2/greetings/{greetingId}/media'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GreetingMediaInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greeting_users_downloads(self, greeting_id: str, **kwargs) -> 'GreetingMediaInfo':
        """
        Download a user greeting recording
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greeting_users_downloads(greeting_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :param str format_id: The desired media format.
        :return: GreetingMediaInfo
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id', 'format_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greeting_users_downloads" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `get_greeting_users_downloads`")


        resource_path = '/api/v2/greetings/{greetingId}/users/downloads'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}
        if 'format_id' in params:
            query_params['formatId'] = params['format_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GreetingMediaInfo',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greetings(self, **kwargs) -> 'DomainEntityListing':
        """
        Gets an Organization's Greetings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greetings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: DomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greetings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/greetings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_greetings_defaults(self, **kwargs) -> 'DefaultGreetingList':
        """
        Get an Organization's DefaultGreetingList
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_greetings_defaults(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/greetings/defaults'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_group_greetings(self, group_id: str, **kwargs) -> 'GreetingListing':
        """
        Get a list of the Group's Greetings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_group_greetings(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Group ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: GreetingListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_greetings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_group_greetings`")


        resource_path = '/api/v2/groups/{groupId}/greetings'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GreetingListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_group_greetings_defaults(self, group_id: str, **kwargs) -> 'DefaultGreetingList':
        """
        Grabs the list of Default Greetings given a Group's ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_group_greetings_defaults(group_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Group ID (required)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_group_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `get_group_greetings_defaults`")


        resource_path = '/api/v2/groups/{groupId}/greetings/defaults'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_greetings(self, user_id: str, **kwargs) -> 'DomainEntityListing':
        """
        Get a list of the User's Greetings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_greetings(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: DomainEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_greetings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_greetings`")


        resource_path = '/api/v2/users/{userId}/greetings'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_user_greetings_defaults(self, user_id: str, **kwargs) -> 'DefaultGreetingList':
        """
        Grabs the list of Default Greetings given a User's ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_user_greetings_defaults(user_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_user_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `get_user_greetings_defaults`")


        resource_path = '/api/v2/users/{userId}/greetings/defaults'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_greetings(self, body: 'Greeting', **kwargs) -> 'Greeting':
        """
        Create a Greeting for an Organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_greetings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Greeting body: The Greeting to create (required)
        :return: Greeting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_greetings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_greetings`")


        resource_path = '/api/v2/greetings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Greeting',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_group_greetings(self, group_id: str, body: 'Greeting', **kwargs) -> 'Greeting':
        """
        Creates a Greeting for a Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_group_greetings(group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Group ID (required)
        :param Greeting body: The Greeting to create (required)
        :return: Greeting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_group_greetings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `post_group_greetings`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_group_greetings`")


        resource_path = '/api/v2/groups/{groupId}/greetings'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Greeting',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_user_greetings(self, user_id: str, body: 'Greeting', **kwargs) -> 'Greeting':
        """
        Creates a Greeting for a User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_user_greetings(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param Greeting body: The Greeting to create (required)
        :return: Greeting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_user_greetings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `post_user_greetings`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_user_greetings`")


        resource_path = '/api/v2/users/{userId}/greetings'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Greeting',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_greeting(self, greeting_id: str, body: 'Greeting', **kwargs) -> 'Greeting':
        """
        Updates the Greeting with the given GreetingId
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_greeting(greeting_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str greeting_id: Greeting ID (required)
        :param Greeting body: The updated Greeting (required)
        :return: Greeting
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['greeting_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_greeting" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'greeting_id' is set
        if ('greeting_id' not in params) or (params['greeting_id'] is None):
            raise ValueError("Missing the required parameter `greeting_id` when calling `put_greeting`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_greeting`")


        resource_path = '/api/v2/greetings/{greetingId}'.replace('{format}', 'json')
        path_params = {}
        if 'greeting_id' in params:
            path_params['greetingId'] = params['greeting_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Greeting',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_greetings_defaults(self, body: 'DefaultGreetingList', **kwargs) -> 'DefaultGreetingList':
        """
        Update an Organization's DefaultGreetingList
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_greetings_defaults(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DefaultGreetingList body: The updated defaultGreetingList (required)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_greetings_defaults`")


        resource_path = '/api/v2/greetings/defaults'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_group_greetings_defaults(self, group_id: str, body: 'DefaultGreetingList', **kwargs) -> 'DefaultGreetingList':
        """
        Updates the DefaultGreetingList of the specified Group
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_group_greetings_defaults(group_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str group_id: Group ID (required)
        :param DefaultGreetingList body: The updated defaultGreetingList (required)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['group_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_group_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'group_id' is set
        if ('group_id' not in params) or (params['group_id'] is None):
            raise ValueError("Missing the required parameter `group_id` when calling `put_group_greetings_defaults`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_group_greetings_defaults`")


        resource_path = '/api/v2/groups/{groupId}/greetings/defaults'.replace('{format}', 'json')
        path_params = {}
        if 'group_id' in params:
            path_params['groupId'] = params['group_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_user_greetings_defaults(self, user_id: str, body: 'DefaultGreetingList', **kwargs) -> 'DefaultGreetingList':
        """
        Updates the DefaultGreetingList of the specified User
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_user_greetings_defaults(user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str user_id: User ID (required)
        :param DefaultGreetingList body: The updated defaultGreetingList (required)
        :return: DefaultGreetingList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_user_greetings_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_user_greetings_defaults`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_user_greetings_defaults`")


        resource_path = '/api/v2/users/{userId}/greetings/defaults'.replace('{format}', 'json')
        path_params = {}
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DefaultGreetingList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
