# coding: utf-8

"""
OrganizationApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import EmbeddedIntegration
from ..models import ErrorBody
from ..models import FeatureState
from ..models import FieldConfig
from ..models import FreeTrialLimitDocs
from ..models import IpAddressAuthentication
from ..models import LimitChangeRequestDetails
from ..models import LimitChangeRequestsEntityListing
from ..models import LimitDocumentation
from ..models import LimitsEntityListing
from ..models import OrgAuthSettings
from ..models import OrgWhitelistSettings
from ..models import Organization
from ..models import OrganizationFeatures

class OrganizationApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    @deprecated("get_fieldconfig is deprecated")
    def get_fieldconfig(self, type: str, **kwargs) -> 'FieldConfig':
        """
        Fetch field config for an entity type
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_fieldconfig(type, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str type: Field type (required)
        :return: FieldConfig
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['type']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_fieldconfig" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'type' is set
        if ('type' not in params) or (params['type'] is None):
            raise ValueError("Missing the required parameter `type` when calling `get_fieldconfig`")


        resource_path = '/api/v2/fieldconfig'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'type' in params:
            query_params['type'] = params['type']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FieldConfig',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_authentication_settings(self, **kwargs) -> 'OrgAuthSettings':
        """
        Gets the organization's settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_authentication_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OrgAuthSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_authentication_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/authentication/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrgAuthSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("get_organizations_embeddedintegration is deprecated")
    def get_organizations_embeddedintegration(self, **kwargs) -> 'EmbeddedIntegration':
        """
        Get the list of domains that will be allowed to embed PureCloud applications
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_embeddedintegration(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EmbeddedIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_embeddedintegration" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/embeddedintegration'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmbeddedIntegration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("get_organizations_ipaddressauthentication is deprecated")
    def get_organizations_ipaddressauthentication(self, **kwargs) -> 'IpAddressAuthentication':
        """
        Get organization IP address whitelist settings
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_ipaddressauthentication(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: IpAddressAuthentication
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_ipaddressauthentication" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/ipaddressauthentication'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IpAddressAuthentication',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_changerequest(self, request_id: str, **kwargs) -> 'LimitChangeRequestDetails':
        """
        Get a limit change request
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_changerequest(request_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str request_id: Unique id for the limit change request (required)
        :return: LimitChangeRequestDetails
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['request_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_changerequest" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'request_id' is set
        if ('request_id' not in params) or (params['request_id'] is None):
            raise ValueError("Missing the required parameter `request_id` when calling `get_organizations_limits_changerequest`")


        resource_path = '/api/v2/organizations/limits/changerequests/{requestId}'.replace('{format}', 'json')
        path_params = {}
        if 'request_id' in params:
            path_params['requestId'] = params['request_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LimitChangeRequestDetails',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_changerequests(self, **kwargs) -> 'LimitChangeRequestsEntityListing':
        """
        Get the available limit change requests
        Timestamp interval defaults to the last 365 days if both query parameters are omitted. If only one parameter is omitted, the interval will default to a 180 day range in the specified direction.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_changerequests(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int after: Timestamp indicating the date to begin after when searching for requests.
        :param int before: Timestamp indicating the date to end before when searching for requests.
        :param str status: Status of the request to be filtered by
        :param int page_size: Page Size
        :param list[str] expand: Which fields, if any, to expand.
        :return: LimitChangeRequestsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['after', 'before', 'status', 'page_size', 'expand']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_changerequests" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/limits/changerequests'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'before' in params:
            query_params['before'] = params['before']
        if 'status' in params:
            query_params['status'] = params['status']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'expand' in params:
            query_params['expand'] = params['expand']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LimitChangeRequestsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_docs(self, **kwargs) -> 'LimitDocumentation':
        """
        Get limit documentation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_docs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: LimitDocumentation
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_docs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/limits/docs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LimitDocumentation',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_docs_freetrial(self, **kwargs) -> 'FreeTrialLimitDocs':
        """
        Get free trial limit documentation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_docs_freetrial(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: FreeTrialLimitDocs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_docs_freetrial" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/limits/docs/freetrial'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FreeTrialLimitDocs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_namespace(self, namespace_name: str, **kwargs) -> 'LimitsEntityListing':
        """
        Get the effective limits in a namespace for an organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_namespace(namespace_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace_name: The namespace to fetch limits for (required)
        :return: LimitsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace_name']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_namespace" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'namespace_name' is set
        if ('namespace_name' not in params) or (params['namespace_name'] is None):
            raise ValueError("Missing the required parameter `namespace_name` when calling `get_organizations_limits_namespace`")


        resource_path = '/api/v2/organizations/limits/namespaces/{namespaceName}'.replace('{format}', 'json')
        path_params = {}
        if 'namespace_name' in params:
            path_params['namespaceName'] = params['namespace_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LimitsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_namespace_defaults(self, namespace_name: str, **kwargs) -> 'LimitsEntityListing':
        """
        Get the default limits in a namespace for an organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_namespace_defaults(namespace_name, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str namespace_name: The namespace to fetch defaults limits for (required)
        :return: LimitsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['namespace_name']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_namespace_defaults" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'namespace_name' is set
        if ('namespace_name' not in params) or (params['namespace_name'] is None):
            raise ValueError("Missing the required parameter `namespace_name` when calling `get_organizations_limits_namespace_defaults`")


        resource_path = '/api/v2/organizations/limits/namespaces/{namespaceName}/defaults'.replace('{format}', 'json')
        path_params = {}
        if 'namespace_name' in params:
            path_params['namespaceName'] = params['namespace_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='LimitsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_limits_namespaces(self, **kwargs) -> object:
        """
        Get the available limit namespaces
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_limits_namespaces(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_limits_namespaces" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/limits/namespaces'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_organizations_me(self, **kwargs) -> 'Organization':
        """
        Get organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Organization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("get_organizations_whitelist is deprecated")
    def get_organizations_whitelist(self, **kwargs) -> 'OrgWhitelistSettings':
        """
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_organizations_whitelist(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OrgWhitelistSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_organizations_whitelist" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/whitelist'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrgWhitelistSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_organizations_authentication_settings(self, body: 'OrgAuthSettings', **kwargs) -> 'OrgAuthSettings':
        """
        Update the organization's settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_organizations_authentication_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OrgAuthSettings body: Org settings (required)
        :return: OrgAuthSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_organizations_authentication_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_organizations_authentication_settings`")


        resource_path = '/api/v2/organizations/authentication/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrgAuthSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_organizations_feature(self, feature_name: str, enabled: 'FeatureState', **kwargs) -> 'OrganizationFeatures':
        """
        Update organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_organizations_feature(feature_name, enabled, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str feature_name: Organization feature (required)
        :param FeatureState enabled: New state of feature (required)
        :return: OrganizationFeatures
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['feature_name', 'enabled']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_organizations_feature" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'feature_name' is set
        if ('feature_name' not in params) or (params['feature_name'] is None):
            raise ValueError("Missing the required parameter `feature_name` when calling `patch_organizations_feature`")
        # verify the required parameter 'enabled' is set
        if ('enabled' not in params) or (params['enabled'] is None):
            raise ValueError("Missing the required parameter `enabled` when calling `patch_organizations_feature`")


        resource_path = '/api/v2/organizations/features/{featureName}'.replace('{format}', 'json')
        path_params = {}
        if 'feature_name' in params:
            path_params['featureName'] = params['feature_name']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'enabled' in params:
            body_params = params['enabled']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationFeatures',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("put_organizations_embeddedintegration is deprecated")
    def put_organizations_embeddedintegration(self, body: 'EmbeddedIntegration', **kwargs) -> 'EmbeddedIntegration':
        """
        Update the list of domains that will be allowed to embed PureCloud applications
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_organizations_embeddedintegration(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param EmbeddedIntegration body: Whitelist settings (required)
        :return: EmbeddedIntegration
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_organizations_embeddedintegration" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_organizations_embeddedintegration`")


        resource_path = '/api/v2/organizations/embeddedintegration'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmbeddedIntegration',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("put_organizations_ipaddressauthentication is deprecated")
    def put_organizations_ipaddressauthentication(self, body: 'IpAddressAuthentication', **kwargs) -> 'IpAddressAuthentication':
        """
        Update organization IP address whitelist settings
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_organizations_ipaddressauthentication(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param IpAddressAuthentication body: IP address Whitelist settings (required)
        :return: IpAddressAuthentication
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_organizations_ipaddressauthentication" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_organizations_ipaddressauthentication`")


        resource_path = '/api/v2/organizations/ipaddressauthentication'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='IpAddressAuthentication',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_organizations_me(self, **kwargs) -> 'Organization':
        """
        Update organization.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_organizations_me(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Organization body: Organization
        :return: Organization
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_organizations_me" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/organizations/me'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Organization',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("put_organizations_whitelist is deprecated")
    def put_organizations_whitelist(self, body: 'OrgWhitelistSettings', **kwargs) -> 'OrgWhitelistSettings':
        """
        This route is deprecated, please use /api/v2/organizations/authentication/settings instead
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_organizations_whitelist(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OrgWhitelistSettings body: Whitelist settings (required)
        :return: OrgWhitelistSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_organizations_whitelist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_organizations_whitelist`")


        resource_path = '/api/v2/organizations/whitelist'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrgWhitelistSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
