# coding: utf-8

"""
OutboundApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import Agent
from ..models import AgentOwnedMappingPreviewListing
from ..models import AttemptLimits
from ..models import AttemptLimitsEntityListing
from ..models import CallableTimeSet
from ..models import CallableTimeSetEntityListing
from ..models import Campaign
from ..models import CampaignDiagnostics
from ..models import CampaignDivisionView
from ..models import CampaignDivisionViewListing
from ..models import CampaignEntityListing
from ..models import CampaignInteractions
from ..models import CampaignOutboundLinesDistribution
from ..models import CampaignPatchRequest
from ..models import CampaignProgress
from ..models import CampaignRule
from ..models import CampaignRuleEntityListing
from ..models import CampaignSchedule
from ..models import CampaignSequence
from ..models import CampaignSequenceEntityListing
from ..models import CampaignStats
from ..models import CommonCampaignDivisionViewEntityListing
from ..models import CommonCampaignEntityListing
from ..models import ContactBulkEditRequest
from ..models import ContactBulkSearchParameters
from ..models import ContactCallbackRequest
from ..models import ContactList
from ..models import ContactListDivisionView
from ..models import ContactListDivisionViewListing
from ..models import ContactListEntityListing
from ..models import ContactListFilter
from ..models import ContactListFilterBulkRetrieveBody
from ..models import ContactListFilterEntityListing
from ..models import ContactListTemplate
from ..models import ContactListTemplateBulkRetrieveBody
from ..models import ContactListTemplateEntityListing
from ..models import ContactListingRequest
from ..models import ContactListingResponse
from ..models import ContactsBulkOperationJob
from ..models import ContactsBulkOperationJobListing
from ..models import ContactsExportRequest
from ..models import DialerContact
from ..models import DialerEventEntityListing
from ..models import DigitalRuleSet
from ..models import DigitalRuleSetEntityListing
from ..models import DncList
from ..models import DncListCreate
from ..models import DncListDivisionView
from ..models import DncListDivisionViewListing
from ..models import DncListEntityListing
from ..models import DncPatchCustomExclusionColumnsRequest
from ..models import DncPatchEmailsRequest
from ..models import DncPatchPhoneNumbersRequest
from ..models import DncPatchWhatsAppNumbersRequest
from ..models import DomainEntityRef
from ..models import EmailCampaignSchedule
from ..models import EmailCampaignScheduleEntityListing
from ..models import ErrorBody
from ..models import EventLog
from ..models import ExportUri
from ..models import FileSpecificationTemplate
from ..models import FileSpecificationTemplateEntityListing
from ..models import FilterPreviewResponse
from ..models import ImportStatus
from ..models import ImportTemplate
from ..models import ImportTemplateEntityListing
from ..models import MessagingCampaign
from ..models import MessagingCampaignDiagnostics
from ..models import MessagingCampaignDivisionView
from ..models import MessagingCampaignDivisionViewEntityListing
from ..models import MessagingCampaignEntityListing
from ..models import MessagingCampaignSchedule
from ..models import MessagingCampaignScheduleEntityListing
from ..models import OutboundSettings
from ..models import PagedSkillCombinationListing
from ..models import ResponseSet
from ..models import ResponseSetEntityListing
from ..models import RuleSet
from ..models import RuleSetEntityListing
from ..models import SequenceSchedule
from ..models import TimeZoneMappingPreview
from ..models import WhatsAppCampaignSchedule
from ..models import WhatsAppCampaignScheduleEntityListing
from ..models import WrapUpCodeMapping
from ..models import WritableDialerContact

class OutboundApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_outbound_attemptlimit(self, attempt_limits_id: str, **kwargs) -> None:
        """
        Delete attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_attemptlimit(attempt_limits_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `delete_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_callabletimeset(self, callable_time_set_id: str, **kwargs) -> None:
        """
        Delete callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_callabletimeset(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `delete_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_callanalysisresponseset(self, call_analysis_set_id: str, **kwargs) -> None:
        """
        Delete a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_callanalysisresponseset(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `delete_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaign(self, campaign_id: str, **kwargs) -> 'Campaign':
        """
        Delete a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaign_progress(self, campaign_id: str, **kwargs) -> None:
        """
        Reset campaign progress and recycle the campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaign_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_campaign_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_campaignrule(self, campaign_rule_id: str, **kwargs) -> None:
        """
        Delete Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_campaignrule(campaign_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `delete_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist(self, contact_list_id: str, **kwargs) -> None:
        """
        Delete a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist_contact(self, contact_list_id: str, contact_id: str, **kwargs) -> None:
        """
        Delete a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist_contact(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `delete_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlist_contacts(self, contact_list_id: str, contact_ids: List['str'], **kwargs) -> None:
        """
        Delete contacts from a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlist_contacts(contact_list_id, contact_ids, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[str] contact_ids: ContactIds to delete. (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlist_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `delete_outbound_contactlist_contacts`")
        # verify the required parameter 'contact_ids' is set
        if ('contact_ids' not in params) or (params['contact_ids'] is None):
            raise ValueError("Missing the required parameter `contact_ids` when calling `delete_outbound_contactlist_contacts`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'contact_ids' in params:
            query_params['contactIds'] = params['contact_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlistfilter(self, contact_list_filter_id: str, **kwargs) -> None:
        """
        Delete Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlistfilter(contact_list_filter_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `delete_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlists(self, id: List['str'], **kwargs) -> None:
        """
        Delete multiple contact lists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlists(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: contact list id(s) to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outbound_contactlists`")


        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlisttemplate(self, contact_list_template_id: str, **kwargs) -> None:
        """
        Delete Contact List Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlisttemplate(contact_list_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_template_id: ContactListTemplate ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlisttemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_template_id' is set
        if ('contact_list_template_id' not in params) or (params['contact_list_template_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_template_id` when calling `delete_outbound_contactlisttemplate`")


        resource_path = '/api/v2/outbound/contactlisttemplates/{contactListTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_template_id' in params:
            path_params['contactListTemplateId'] = params['contact_list_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_contactlisttemplates(self, id: List['str'], **kwargs) -> None:
        """
        Delete multiple contact list templates.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_contactlisttemplates(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: contact list template id(s) to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_contactlisttemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outbound_contactlisttemplates`")


        resource_path = '/api/v2/outbound/contactlisttemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_digitalruleset(self, digital_rule_set_id: str, **kwargs) -> None:
        """
        Delete an Outbound Digital Rule Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_digitalruleset(digital_rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str digital_rule_set_id: The Digital Rule Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['digital_rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_digitalruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'digital_rule_set_id' is set
        if ('digital_rule_set_id' not in params) or (params['digital_rule_set_id'] is None):
            raise ValueError("Missing the required parameter `digital_rule_set_id` when calling `delete_outbound_digitalruleset`")


        resource_path = '/api/v2/outbound/digitalrulesets/{digitalRuleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'digital_rule_set_id' in params:
            path_params['digitalRuleSetId'] = params['digital_rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist(self, dnc_list_id: str, **kwargs) -> None:
        """
        Delete dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist_customexclusioncolumns(self, dnc_list_id: str, **kwargs) -> None:
        """
        Deletes all or expired custom exclusion column entries from a DNC list.
        This operation is only for Internal DNC lists of custom exclusion column entries

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist_customexclusioncolumns(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool expired_only: Set to true to only remove DNC entries that are expired
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'expired_only']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist_customexclusioncolumns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist_customexclusioncolumns`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/customexclusioncolumns'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'expired_only' in params:
            query_params['expiredOnly'] = params['expired_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist_emailaddresses(self, dnc_list_id: str, **kwargs) -> None:
        """
        Deletes all or expired email addresses from a DNC list.
        This operation is Only for Internal DNC lists of email addresses

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist_emailaddresses(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool expired_only: Set to true to only remove DNC entries that are expired
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'expired_only']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist_emailaddresses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist_emailaddresses`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/emailaddresses'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'expired_only' in params:
            query_params['expiredOnly'] = params['expired_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist_phonenumbers(self, dnc_list_id: str, **kwargs) -> None:
        """
        Deletes all or expired phone numbers from a DNC list.
        This operation is Only for Internal DNC lists of phone numbers

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist_phonenumbers(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool expired_only: Set to true to only remove DNC entries that are expired
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'expired_only']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist_phonenumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/phonenumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'expired_only' in params:
            query_params['expiredOnly'] = params['expired_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_dnclist_whatsappnumbers(self, dnc_list_id: str, **kwargs) -> None:
        """
        Deletes all or expired whatsApp numbers from a DNC list.
        This operation is only for Internal DNC lists of whatsApp numbers

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_dnclist_whatsappnumbers(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool expired_only: Set to true to only remove DNC whatsApp numbers that are expired
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'expired_only']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_dnclist_whatsappnumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `delete_outbound_dnclist_whatsappnumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/whatsappnumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'expired_only' in params:
            query_params['expiredOnly'] = params['expired_only']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_filespecificationtemplate(self, file_specification_template_id: str, **kwargs) -> None:
        """
        Delete File Specification Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_filespecificationtemplate(file_specification_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_specification_template_id: File Specification Template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_specification_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_filespecificationtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'file_specification_template_id' is set
        if ('file_specification_template_id' not in params) or (params['file_specification_template_id'] is None):
            raise ValueError("Missing the required parameter `file_specification_template_id` when calling `delete_outbound_filespecificationtemplate`")


        resource_path = '/api/v2/outbound/filespecificationtemplates/{fileSpecificationTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'file_specification_template_id' in params:
            path_params['fileSpecificationTemplateId'] = params['file_specification_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_filespecificationtemplates_bulk(self, id: List['str'], **kwargs) -> None:
        """
        Delete multiple file specification templates.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_filespecificationtemplates_bulk(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: File Specification template id(s) to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_filespecificationtemplates_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outbound_filespecificationtemplates_bulk`")


        resource_path = '/api/v2/outbound/filespecificationtemplates/bulk'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_importtemplate(self, import_template_id: str, **kwargs) -> None:
        """
        Delete Import Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_importtemplate(import_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str import_template_id: Import Template ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['import_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_importtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'import_template_id' is set
        if ('import_template_id' not in params) or (params['import_template_id'] is None):
            raise ValueError("Missing the required parameter `import_template_id` when calling `delete_outbound_importtemplate`")


        resource_path = '/api/v2/outbound/importtemplates/{importTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'import_template_id' in params:
            path_params['importTemplateId'] = params['import_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_importtemplates(self, id: List['str'], **kwargs) -> None:
        """
        Delete multiple import templates.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_importtemplates(id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] id: import template id(s) to delete (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_importtemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'id' is set
        if ('id' not in params) or (params['id'] is None):
            raise ValueError("Missing the required parameter `id` when calling `delete_outbound_importtemplates`")


        resource_path = '/api/v2/outbound/importtemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_messagingcampaign(self, messaging_campaign_id: str, **kwargs) -> 'MessagingCampaign':
        """
        Delete an Outbound Messaging Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_messagingcampaign(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: MessagingCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `delete_outbound_messagingcampaign`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_messagingcampaign_progress(self, messaging_campaign_id: str, **kwargs) -> None:
        """
        Reset messaging campaign progress and recycle the messaging campaign
        Documented permissions are applicable based on campaign type.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_messagingcampaign_progress(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_messagingcampaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `delete_outbound_messagingcampaign_progress`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_ruleset(self, rule_set_id: str, **kwargs) -> None:
        """
        Delete a Rule Set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_ruleset(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `delete_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_campaign(self, campaign_id: str, **kwargs) -> None:
        """
        Delete a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `delete_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_emailcampaign(self, email_campaign_id: str, **kwargs) -> None:
        """
        Delete an email campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_emailcampaign(email_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_campaign_id: Email Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_emailcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_campaign_id' is set
        if ('email_campaign_id' not in params) or (params['email_campaign_id'] is None):
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `delete_outbound_schedules_emailcampaign`")


        resource_path = '/api/v2/outbound/schedules/emailcampaigns/{emailCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_campaign_id' in params:
            path_params['emailCampaignId'] = params['email_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_messagingcampaign(self, messaging_campaign_id: str, **kwargs) -> None:
        """
        Delete a messaging campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_messagingcampaign(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: Messaging Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `delete_outbound_schedules_messagingcampaign`")


        resource_path = '/api/v2/outbound/schedules/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_sequence(self, sequence_id: str, **kwargs) -> None:
        """
        Delete a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_schedules_whatsappcampaign(self, whats_app_campaign_id: str, **kwargs) -> None:
        """
        Delete a WhatsApp campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_schedules_whatsappcampaign(whats_app_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str whats_app_campaign_id: WhatsApp Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['whats_app_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_schedules_whatsappcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'whats_app_campaign_id' is set
        if ('whats_app_campaign_id' not in params) or (params['whats_app_campaign_id'] is None):
            raise ValueError("Missing the required parameter `whats_app_campaign_id` when calling `delete_outbound_schedules_whatsappcampaign`")


        resource_path = '/api/v2/outbound/schedules/whatsappcampaigns/{whatsAppCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'whats_app_campaign_id' in params:
            path_params['whatsAppCampaignId'] = params['whats_app_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_outbound_sequence(self, sequence_id: str, **kwargs) -> None:
        """
        Delete a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_outbound_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `delete_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_attemptlimit(self, attempt_limits_id: str, **kwargs) -> 'AttemptLimits':
        """
        Get attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_attemptlimit(attempt_limits_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `get_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_attemptlimits(self, **kwargs) -> 'AttemptLimitsEntityListing':
        """
        Query attempt limits list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_attemptlimits(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: AttemptLimitsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_attemptlimits" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/attemptlimits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimitsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callabletimeset(self, callable_time_set_id: str, **kwargs) -> 'CallableTimeSet':
        """
        Get callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callabletimeset(callable_time_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `get_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callabletimesets(self, **kwargs) -> 'CallableTimeSetEntityListing':
        """
        Query callable time set list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callabletimesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CallableTimeSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callanalysisresponseset(self, call_analysis_set_id: str, **kwargs) -> 'ResponseSet':
        """
        Get a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callanalysisresponseset(call_analysis_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `get_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_callanalysisresponsesets(self, **kwargs) -> 'ResponseSetEntityListing':
        """
        Query a list of dialer call analysis response sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_callanalysisresponsesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ResponseSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign(self, campaign_id: str, **kwargs) -> 'Campaign':
        """
        Get dialer campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_agentownedmappingpreview_results(self, campaign_id: str, **kwargs) -> 'AgentOwnedMappingPreviewListing':
        """
        Get a preview of how agents will be mapped to this campaign's contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_agentownedmappingpreview_results(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: AgentOwnedMappingPreviewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_agentownedmappingpreview_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_agentownedmappingpreview_results`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/agentownedmappingpreview/results'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AgentOwnedMappingPreviewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_diagnostics(self, campaign_id: str, **kwargs) -> 'CampaignDiagnostics':
        """
        Get campaign diagnostics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_diagnostics(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_diagnostics`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/diagnostics'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDiagnostics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_interactions(self, campaign_id: str, **kwargs) -> 'CampaignInteractions':
        """
        Get dialer campaign interactions.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_interactions(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignInteractions
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_interactions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_interactions`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/interactions'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignInteractions',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_linedistribution(self, campaign_id: str, **kwargs) -> 'CampaignOutboundLinesDistribution':
        """
        Get line distribution information for campaigns using same Edge Group or Site as given campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_linedistribution(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param bool include_only_active_campaigns: If true will return only active Campaigns
        :param str edge_group_id: Edge group to be used in line distribution calculations instead of current Campaign's Edge Group. Campaign's Site and Edge Group are mutually exclusive.
        :param str site_id: Site to be used in line distribution calculations instead of current Campaign's Site.  Campaign's Site and Edge Group are mutually exclusive.
        :param bool use_weight: Enable usage of weight, this value overrides current Campaign's setting in line distribution calculations
        :param int relative_weight: Relative weight to be used in line distribution calculations instead of current Campaign's relative weight
        :param int outbound_line_count: The number of outbound lines to be used in line distribution calculations, instead of current Campaign's Outbound Lines Count
        :return: CampaignOutboundLinesDistribution
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'include_only_active_campaigns', 'edge_group_id', 'site_id', 'use_weight', 'relative_weight', 'outbound_line_count']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_linedistribution" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_linedistribution`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/linedistribution'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}
        if 'include_only_active_campaigns' in params:
            query_params['includeOnlyActiveCampaigns'] = params['include_only_active_campaigns']
        if 'edge_group_id' in params:
            query_params['edgeGroupId'] = params['edge_group_id']
        if 'site_id' in params:
            query_params['siteId'] = params['site_id']
        if 'use_weight' in params:
            query_params['useWeight'] = params['use_weight']
        if 'relative_weight' in params:
            query_params['relativeWeight'] = params['relative_weight']
        if 'outbound_line_count' in params:
            query_params['outboundLineCount'] = params['outbound_line_count']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignOutboundLinesDistribution',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_progress(self, campaign_id: str, **kwargs) -> 'CampaignProgress':
        """
        Get campaign progress
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_progress(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_progress`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignProgress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_skillcombinations(self, campaign_id: str, **kwargs) -> 'PagedSkillCombinationListing':
        """
        Get the remaining and total contact count for each skill combination in a skills campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_skillcombinations(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param int page_number: Page number
        :param int page_size: Page size
        :return: PagedSkillCombinationListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'page_number', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_skillcombinations" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_skillcombinations`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/skillcombinations'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PagedSkillCombinationListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaign_stats(self, campaign_id: str, **kwargs) -> 'CampaignStats':
        """
        Get statistics about a Dialer Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaign_stats(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignStats
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaign_stats" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaign_stats`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/stats'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignStats',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaignrule(self, campaign_rule_id: str, **kwargs) -> 'CampaignRule':
        """
        Get Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaignrule(campaign_rule_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `get_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaignrules(self, **kwargs) -> 'CampaignRuleEntityListing':
        """
        Query Campaign Rule list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaignrules(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignRuleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaignrules" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaignrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRuleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns(self, **kwargs) -> 'CampaignEntityListing':
        """
        Query a list of dialer campaigns.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str contact_list_id: Contact List ID
        :param str dnc_list_ids: DNC list ID
        :param str distribution_queue_id: Distribution queue ID
        :param str edge_group_id: Edge group ID
        :param str call_analysis_response_set_id: Call analysis response set ID
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'id', 'contact_list_id', 'dnc_list_ids', 'distribution_queue_id', 'edge_group_id', 'call_analysis_response_set_id', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']
        if 'dnc_list_ids' in params:
            query_params['dncListIds'] = params['dnc_list_ids']
        if 'distribution_queue_id' in params:
            query_params['distributionQueueId'] = params['distribution_queue_id']
        if 'edge_group_id' in params:
            query_params['edgeGroupId'] = params['edge_group_id']
        if 'call_analysis_response_set_id' in params:
            query_params['callAnalysisResponseSetId'] = params['call_analysis_response_set_id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_all(self, **kwargs) -> 'CommonCampaignEntityListing':
        """
        Query across all types of campaigns by division
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_all(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param list[str] id: Campaign ID(s)
        :param str name: Campaign name(s)
        :param list[str] division_id: Division ID(s)
        :param list[str] media_type: Media type(s)
        :param str sort_order: Sort order
        :return: CommonCampaignEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'id', 'name', 'division_id', 'media_type', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_all" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns/all'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'media_type' in params:
            query_params['mediaType'] = params['media_type']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonCampaignEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_all_divisionviews(self, **kwargs) -> 'CommonCampaignDivisionViewEntityListing':
        """
        Query across all types of campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_all_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param list[str] id: Campaign ID(s)
        :param str name: Campaign name(s)
        :param list[str] division_id: Division ID(s)
        :param list[str] media_type: Media type(s)
        :param str sort_order: Sort order
        :return: CommonCampaignDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'id', 'name', 'division_id', 'media_type', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_all_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns/all/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'media_type' in params:
            query_params['mediaType'] = params['media_type']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommonCampaignDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_divisionview(self, campaign_id: str, **kwargs) -> 'CampaignDivisionView':
        """
        Get a basic Campaign information object
        This returns a simplified version of a Campaign, consisting of name and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_divisionview(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_campaigns_divisionview`")


        resource_path = '/api/v2/outbound/campaigns/divisionviews/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_campaigns_divisionviews(self, **kwargs) -> 'CampaignDivisionViewListing':
        """
        Query a list of basic Campaign information objects
        This returns a simplified version of a Campaign, consisting of name and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_campaigns_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'name', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_campaigns_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/campaigns/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist(self, contact_list_id: str, **kwargs) -> 'ContactList':
        """
        Get a dialer contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_contact(self, contact_list_id: str, contact_id: str, **kwargs) -> 'DialerContact':
        """
        Get a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_contact(contact_list_id, contact_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `get_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_contacts_bulk_job(self, contact_list_id: str, job_id: str, **kwargs) -> 'ContactsBulkOperationJob':
        """
        Get bulk operation job.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_contacts_bulk_job(contact_list_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str job_id: Job ID (required)
        :return: ContactsBulkOperationJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_contacts_bulk_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_contacts_bulk_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_outbound_contactlist_contacts_bulk_job`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsBulkOperationJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_contacts_bulk_jobs(self, contact_list_id: str, **kwargs) -> 'ContactsBulkOperationJobListing':
        """
        Get 10 most recent bulk operation jobs associated with contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_contacts_bulk_jobs(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :return: ContactsBulkOperationJobListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_contacts_bulk_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_contacts_bulk_jobs`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsBulkOperationJobListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_export(self, contact_list_id: str, **kwargs) -> 'ExportUri':
        """
        Get the URI of a contact list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_importstatus(self, contact_list_id: str, **kwargs) -> 'ImportStatus':
        """
        Get dialer contactList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_importstatus(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_importstatus`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlist_timezonemappingpreview(self, contact_list_id: str, **kwargs) -> 'TimeZoneMappingPreview':
        """
        Preview the result of applying Automatic Time Zone Mapping to a contact list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlist_timezonemappingpreview(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :return: TimeZoneMappingPreview
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlist_timezonemappingpreview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlist_timezonemappingpreview`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/timezonemappingpreview'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TimeZoneMappingPreview',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlistfilter(self, contact_list_filter_id: str, **kwargs) -> 'ContactListFilter':
        """
        Get Contact list filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlistfilter(contact_list_filter_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `get_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlistfilters(self, **kwargs) -> 'ContactListFilterEntityListing':
        """
        Query Contact list filters
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlistfilters(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str contact_list_id: Contact List ID
        :return: ContactListFilterEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order', 'contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlistfilters" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlistfilters'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilterEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists(self, **kwargs) -> 'ContactListEntityListing':
        """
        Query a list of contact lists.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'id', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists_divisionview(self, contact_list_id: str, **kwargs) -> 'ContactListDivisionView':
        """
        Get a basic ContactList information object
        This returns a simplified version of a ContactList, consisting of the name, division, column names, phone columns, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists_divisionview(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contactlist ID (required)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :return: ContactListDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `get_outbound_contactlists_divisionview`")


        resource_path = '/api/v2/outbound/contactlists/divisionviews/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlists_divisionviews(self, **kwargs) -> 'ContactListDivisionViewListing':
        """
        Query a list of simplified contact list objects.
        This return a simplified version of contact lists, consisting of the name, division, column names, phone columns, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlists_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlists_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlists/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlisttemplate(self, contact_list_template_id: str, **kwargs) -> 'ContactListTemplate':
        """
        Get Contact List Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlisttemplate(contact_list_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_template_id: ContactListTemplate ID (required)
        :return: ContactListTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlisttemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_template_id' is set
        if ('contact_list_template_id' not in params) or (params['contact_list_template_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_template_id` when calling `get_outbound_contactlisttemplate`")


        resource_path = '/api/v2/outbound/contactlisttemplates/{contactListTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_template_id' in params:
            path_params['contactListTemplateId'] = params['contact_list_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_contactlisttemplates(self, **kwargs) -> 'ContactListTemplateEntityListing':
        """
        Query a list of contact list templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_contactlisttemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: ContactListTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_contactlisttemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/contactlisttemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_digitalruleset(self, digital_rule_set_id: str, **kwargs) -> 'DigitalRuleSet':
        """
        Get an Outbound Digital Rule Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_digitalruleset(digital_rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str digital_rule_set_id: The Digital Rule Set ID (required)
        :return: DigitalRuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['digital_rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_digitalruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'digital_rule_set_id' is set
        if ('digital_rule_set_id' not in params) or (params['digital_rule_set_id'] is None):
            raise ValueError("Missing the required parameter `digital_rule_set_id` when calling `get_outbound_digitalruleset`")


        resource_path = '/api/v2/outbound/digitalrulesets/{digitalRuleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'digital_rule_set_id' in params:
            path_params['digitalRuleSetId'] = params['digital_rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DigitalRuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_digitalrulesets(self, **kwargs) -> 'DigitalRuleSetEntityListing':
        """
        Query a list of Outbound Digital Rule Sets
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_digitalrulesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str sort_by: The field to sort by
        :param str sort_order: The direction to sort
        :param str name: Name
        :param list[str] id: A list of digital rule set ids to bulk fetch
        :return: DigitalRuleSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'name', 'id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_digitalrulesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/digitalrulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'id' in params:
            query_params['id'] = params['id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DigitalRuleSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist(self, dnc_list_id: str, **kwargs) -> 'DncList':
        """
        Get dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist_export(self, dnc_list_id: str, **kwargs) -> 'ExportUri':
        """
        Get the URI of a DNC list export.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param str download: Redirect to download uri
        :return: ExportUri
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'download']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'download' in params:
            query_params['download'] = params['download']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ExportUri',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclist_importstatus(self, dnc_list_id: str, **kwargs) -> 'ImportStatus':
        """
        Get dialer dncList import status.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclist_importstatus(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclist_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclist_importstatus`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists(self, **kwargs) -> 'DncListEntityListing':
        """
        Query dialer DNC lists
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str dnc_source_type: DncSourceType
        :param list[str] division_id: Division ID(s)
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DncListEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'dnc_source_type', 'division_id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'dnc_source_type' in params:
            query_params['dncSourceType'] = params['dnc_source_type']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists_divisionview(self, dnc_list_id: str, **kwargs) -> 'DncListDivisionView':
        """
        Get a basic DncList information object
        This returns a simplified version of a DncList, consisting of the name, division, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists_divisionview(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: Dnclist ID (required)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :return: DncListDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'include_import_status', 'include_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `get_outbound_dnclists_divisionview`")


        resource_path = '/api/v2/outbound/dnclists/divisionviews/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_dnclists_divisionviews(self, **kwargs) -> 'DncListDivisionViewListing':
        """
        Query a list of simplified dnc list objects.
        This return a simplified version of dnc lists, consisting of the name, division, import status, and size.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_dnclists_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Include import status
        :param bool include_size: Include size
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str name: Name
        :param str dnc_source_type: DncSourceType
        :param list[str] id: id
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DncListDivisionViewListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'include_size', 'page_size', 'page_number', 'filter_type', 'name', 'dnc_source_type', 'id', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_dnclists_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/dnclists/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'include_size' in params:
            query_params['includeSize'] = params['include_size']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'dnc_source_type' in params:
            query_params['dncSourceType'] = params['dnc_source_type']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncListDivisionViewListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_event(self, event_id: str, **kwargs) -> 'EventLog':
        """
        Get Dialer Event
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_event(event_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str event_id: Event Log ID (required)
        :return: EventLog
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['event_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_event" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'event_id' is set
        if ('event_id' not in params) or (params['event_id'] is None):
            raise ValueError("Missing the required parameter `event_id` when calling `get_outbound_event`")


        resource_path = '/api/v2/outbound/events/{eventId}'.replace('{format}', 'json')
        path_params = {}
        if 'event_id' in params:
            path_params['eventId'] = params['event_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EventLog',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_events(self, **kwargs) -> 'DialerEventEntityListing':
        """
        Query Event Logs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_events(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size
        :param int page_number: Page number
        :param str filter_type: Filter type
        :param str category: Category
        :param str level: Level
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: DialerEventEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'filter_type', 'category', 'level', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_events" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/events'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'category' in params:
            query_params['category'] = params['category']
        if 'level' in params:
            query_params['level'] = params['level']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerEventEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_filespecificationtemplate(self, file_specification_template_id: str, **kwargs) -> 'FileSpecificationTemplate':
        """
        Get File Specification Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_filespecificationtemplate(file_specification_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_specification_template_id: File Specification Template ID (required)
        :return: FileSpecificationTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_specification_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_filespecificationtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'file_specification_template_id' is set
        if ('file_specification_template_id' not in params) or (params['file_specification_template_id'] is None):
            raise ValueError("Missing the required parameter `file_specification_template_id` when calling `get_outbound_filespecificationtemplate`")


        resource_path = '/api/v2/outbound/filespecificationtemplates/{fileSpecificationTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'file_specification_template_id' in params:
            path_params['fileSpecificationTemplateId'] = params['file_specification_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FileSpecificationTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_filespecificationtemplates(self, **kwargs) -> 'FileSpecificationTemplateEntityListing':
        """
        Query File Specification Templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_filespecificationtemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: FileSpecificationTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_filespecificationtemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/filespecificationtemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FileSpecificationTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_importtemplate(self, import_template_id: str, **kwargs) -> 'ImportTemplate':
        """
        Get Import Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_importtemplate(import_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str import_template_id: Import Template ID (required)
        :param bool include_import_status: Import status
        :return: ImportTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['import_template_id', 'include_import_status']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_importtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'import_template_id' is set
        if ('import_template_id' not in params) or (params['import_template_id'] is None):
            raise ValueError("Missing the required parameter `import_template_id` when calling `get_outbound_importtemplate`")


        resource_path = '/api/v2/outbound/importtemplates/{importTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'import_template_id' in params:
            path_params['importTemplateId'] = params['import_template_id']

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_importtemplate_importstatus(self, import_template_id: str, **kwargs) -> 'ImportStatus':
        """
        Get the import status for an import template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_importtemplate_importstatus(import_template_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str import_template_id: importTemplateId (required)
        :param str list_name_prefix: listNamePrefix
        :return: ImportStatus
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['import_template_id', 'list_name_prefix']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_importtemplate_importstatus" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'import_template_id' is set
        if ('import_template_id' not in params) or (params['import_template_id'] is None):
            raise ValueError("Missing the required parameter `import_template_id` when calling `get_outbound_importtemplate_importstatus`")


        resource_path = '/api/v2/outbound/importtemplates/{importTemplateId}/importstatus'.replace('{format}', 'json')
        path_params = {}
        if 'import_template_id' in params:
            path_params['importTemplateId'] = params['import_template_id']

        query_params = {}
        if 'list_name_prefix' in params:
            query_params['listNamePrefix'] = params['list_name_prefix']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportStatus',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_importtemplates(self, **kwargs) -> 'ImportTemplateEntityListing':
        """
        Query Import Templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_importtemplates(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param bool include_import_status: Import status
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :param str contact_list_template_id: Contact List Template ID
        :return: ImportTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['include_import_status', 'page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order', 'contact_list_template_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_importtemplates" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/importtemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'include_import_status' in params:
            query_params['includeImportStatus'] = params['include_import_status']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'contact_list_template_id' in params:
            query_params['contactListTemplateId'] = params['contact_list_template_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaign(self, messaging_campaign_id: str, **kwargs) -> 'MessagingCampaign':
        """
        Get an Outbound Messaging Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaign(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: MessagingCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `get_outbound_messagingcampaign`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaign_diagnostics(self, messaging_campaign_id: str, **kwargs) -> 'MessagingCampaignDiagnostics':
        """
        Get messaging campaign diagnostics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaign_diagnostics(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: MessagingCampaignDiagnostics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaign_diagnostics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `get_outbound_messagingcampaign_diagnostics`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}/diagnostics'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignDiagnostics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaign_progress(self, messaging_campaign_id: str, **kwargs) -> 'CampaignProgress':
        """
        Get messaging campaign's progress
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaign_progress(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: CampaignProgress
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaign_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `get_outbound_messagingcampaign_progress`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}/progress'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignProgress',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaigns(self, **kwargs) -> 'MessagingCampaignEntityListing':
        """
        Query a list of Messaging Campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str sort_by: The field to sort by
        :param str sort_order: The direction to sort
        :param str name: Name
        :param str contact_list_id: Contact List ID
        :param list[str] division_id: Division ID(s)
        :param str type: Campaign Type
        :param str sender_sms_phone_number: Sender SMS Phone Number
        :param list[str] id: A list of messaging campaign ids to bulk fetch
        :param str content_template_id: Content template ID
        :param str campaign_status: Campaign Status
        :return: MessagingCampaignEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_by', 'sort_order', 'name', 'contact_list_id', 'division_id', 'type', 'sender_sms_phone_number', 'id', 'content_template_id', 'campaign_status']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/messagingcampaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'contact_list_id' in params:
            query_params['contactListId'] = params['contact_list_id']
        if 'division_id' in params:
            query_params['divisionId'] = params['division_id']
        if 'type' in params:
            query_params['type'] = params['type']
        if 'sender_sms_phone_number' in params:
            query_params['senderSmsPhoneNumber'] = params['sender_sms_phone_number']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'content_template_id' in params:
            query_params['contentTemplateId'] = params['content_template_id']
        if 'campaign_status' in params:
            query_params['campaignStatus'] = params['campaign_status']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaigns_divisionview(self, messaging_campaign_id: str, **kwargs) -> 'MessagingCampaignDivisionView':
        """
        Get a basic Messaging Campaign information object
        This returns a simplified version of a Messaging Campaign, consisting of id, name, and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaigns_divisionview(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: MessagingCampaignDivisionView
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaigns_divisionview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `get_outbound_messagingcampaigns_divisionview`")


        resource_path = '/api/v2/outbound/messagingcampaigns/divisionviews/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignDivisionView',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_messagingcampaigns_divisionviews(self, **kwargs) -> 'MessagingCampaignDivisionViewEntityListing':
        """
        Query a list of basic Messaging Campaign information objects
        This returns a listing of simplified Messaging Campaigns, each consisting of id, name, and division.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_messagingcampaigns_divisionviews(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param str sort_order: The direction to sort
        :param str name: Name
        :param str type: Campaign Type
        :param list[str] id: id
        :param str sender_sms_phone_number: Sender SMS Phone Number
        :param str content_template_id: Content template ID
        :param str campaign_status: Campaign Status
        :return: MessagingCampaignDivisionViewEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_order', 'name', 'type', 'id', 'sender_sms_phone_number', 'content_template_id', 'campaign_status']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_messagingcampaigns_divisionviews" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/messagingcampaigns/divisionviews'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'type' in params:
            query_params['type'] = params['type']
        if 'id' in params:
            query_params['id'] = params['id']
        if 'sender_sms_phone_number' in params:
            query_params['senderSmsPhoneNumber'] = params['sender_sms_phone_number']
        if 'content_template_id' in params:
            query_params['contentTemplateId'] = params['content_template_id']
        if 'campaign_status' in params:
            query_params['campaignStatus'] = params['campaign_status']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignDivisionViewEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_ruleset(self, rule_set_id: str, **kwargs) -> 'RuleSet':
        """
        Get a Rule Set by ID.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_ruleset(rule_set_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `get_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_rulesets(self, **kwargs) -> 'RuleSetEntityListing':
        """
        Query a list of Rule Sets.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_rulesets(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: RuleSetEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_rulesets" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSetEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_campaign(self, campaign_id: str, **kwargs) -> 'CampaignSchedule':
        """
        Get a dialer campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_campaign(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `get_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_campaigns(self, **kwargs) -> List['CampaignSchedule']:
        """
        Query for a list of dialer campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_campaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[CampaignSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_campaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_emailcampaign(self, email_campaign_id: str, **kwargs) -> 'EmailCampaignSchedule':
        """
        Get an email campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_emailcampaign(email_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_campaign_id: Email Campaign ID (required)
        :return: EmailCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_emailcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_campaign_id' is set
        if ('email_campaign_id' not in params) or (params['email_campaign_id'] is None):
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `get_outbound_schedules_emailcampaign`")


        resource_path = '/api/v2/outbound/schedules/emailcampaigns/{emailCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_campaign_id' in params:
            path_params['emailCampaignId'] = params['email_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_emailcampaigns(self, **kwargs) -> 'EmailCampaignScheduleEntityListing':
        """
        Query for a list of email campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_emailcampaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EmailCampaignScheduleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_emailcampaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/emailcampaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailCampaignScheduleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_messagingcampaign(self, messaging_campaign_id: str, **kwargs) -> 'MessagingCampaignSchedule':
        """
        Get a messaging campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_messagingcampaign(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: Messaging Campaign ID (required)
        :return: MessagingCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `get_outbound_schedules_messagingcampaign`")


        resource_path = '/api/v2/outbound/schedules/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_messagingcampaigns(self, **kwargs) -> 'MessagingCampaignScheduleEntityListing':
        """
        Query for a list of messaging campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_messagingcampaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: MessagingCampaignScheduleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_messagingcampaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/messagingcampaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignScheduleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_sequence(self, sequence_id: str, **kwargs) -> 'SequenceSchedule':
        """
        Get a dialer sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_sequences(self, **kwargs) -> List['SequenceSchedule']:
        """
        Query for a list of dialer sequence schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: list[SequenceSchedule]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[SequenceSchedule]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_whatsappcampaign(self, whats_app_campaign_id: str, **kwargs) -> 'WhatsAppCampaignSchedule':
        """
        Get a WhatsApp campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_whatsappcampaign(whats_app_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str whats_app_campaign_id: WhatsApp Campaign ID (required)
        :return: WhatsAppCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['whats_app_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_whatsappcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'whats_app_campaign_id' is set
        if ('whats_app_campaign_id' not in params) or (params['whats_app_campaign_id'] is None):
            raise ValueError("Missing the required parameter `whats_app_campaign_id` when calling `get_outbound_schedules_whatsappcampaign`")


        resource_path = '/api/v2/outbound/schedules/whatsappcampaigns/{whatsAppCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'whats_app_campaign_id' in params:
            path_params['whatsAppCampaignId'] = params['whats_app_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WhatsAppCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_schedules_whatsappcampaigns(self, **kwargs) -> 'WhatsAppCampaignScheduleEntityListing':
        """
        Query for a list of WhatsApp campaign schedules.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_schedules_whatsappcampaigns(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: WhatsAppCampaignScheduleEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_schedules_whatsappcampaigns" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/schedules/whatsappcampaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WhatsAppCampaignScheduleEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_sequence(self, sequence_id: str, **kwargs) -> 'CampaignSequence':
        """
        Get a dialer campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_sequence(sequence_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `get_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_sequences(self, **kwargs) -> 'CampaignSequenceEntityListing':
        """
        Query a list of dialer campaign sequences.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_sequences(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: Page size. The max that will be returned is 100.
        :param int page_number: Page number
        :param bool allow_empty_result: Whether to return an empty page when there are no results for that page
        :param str filter_type: Filter type
        :param str name: Name
        :param str sort_by: Sort by
        :param str sort_order: Sort order
        :return: CampaignSequenceEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'allow_empty_result', 'filter_type', 'name', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_sequences" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'allow_empty_result' in params:
            query_params['allowEmptyResult'] = params['allow_empty_result']
        if 'filter_type' in params:
            query_params['filterType'] = params['filter_type']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequenceEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_settings(self, **kwargs) -> 'OutboundSettings':
        """
        Get the outbound settings for this organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: OutboundSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OutboundSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_outbound_wrapupcodemappings(self, **kwargs) -> 'WrapUpCodeMapping':
        """
        Get the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_outbound_wrapupcodemappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_outbound_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_campaign(self, campaign_id: str, body: 'CampaignPatchRequest', **kwargs) -> None:
        """
        Update a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_campaign(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param CampaignPatchRequest body: CampaignPatchRequest (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `patch_outbound_campaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_dnclist_customexclusioncolumns(self, dnc_list_id: str, body: 'DncPatchCustomExclusionColumnsRequest', **kwargs) -> None:
        """
        Add entries to or delete entries from a DNC list.
        Only Internal DNC lists may be deleted from

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_dnclist_customexclusioncolumns(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncPatchCustomExclusionColumnsRequest body: DNC Custom exclusion column entries (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_dnclist_customexclusioncolumns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `patch_outbound_dnclist_customexclusioncolumns`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_dnclist_customexclusioncolumns`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/customexclusioncolumns'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_dnclist_emailaddresses(self, dnc_list_id: str, body: 'DncPatchEmailsRequest', **kwargs) -> None:
        """
        Add emails to or Delete emails from a DNC list.
        Only Internal DNC lists may be added to or deleted from

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_dnclist_emailaddresses(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncPatchEmailsRequest body: DNC Emails (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_dnclist_emailaddresses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `patch_outbound_dnclist_emailaddresses`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_dnclist_emailaddresses`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/emailaddresses'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_dnclist_phonenumbers(self, dnc_list_id: str, body: 'DncPatchPhoneNumbersRequest', **kwargs) -> None:
        """
        Add numbers to or delete numbers from a DNC list.
        Only Internal DNC lists may be added to deleted from

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_dnclist_phonenumbers(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncPatchPhoneNumbersRequest body: DNC Phone Numbers (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_dnclist_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `patch_outbound_dnclist_phonenumbers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_dnclist_phonenumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/phonenumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_dnclist_whatsappnumbers(self, dnc_list_id: str, body: 'DncPatchWhatsAppNumbersRequest', **kwargs) -> None:
        """
        Add entries to or delete entries from a DNC list.
        Only Internal DNC lists may be deleted from

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_dnclist_whatsappnumbers(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncPatchWhatsAppNumbersRequest body: DNC whatsApp numbers (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_dnclist_whatsappnumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `patch_outbound_dnclist_whatsappnumbers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_dnclist_whatsappnumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/whatsappnumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_outbound_settings(self, body: 'OutboundSettings', **kwargs) -> None:
        """
        Update the outbound settings for this organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_outbound_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OutboundSettings body: outboundSettings (required)
        :param bool use_max_calls_per_agent_decimal: Use maxCallsPerAgent with decimal precision
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'use_max_calls_per_agent_decimal']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_outbound_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_outbound_settings`")


        resource_path = '/api/v2/outbound/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'use_max_calls_per_agent_decimal' in params:
            query_params['useMaxCallsPerAgentDecimal'] = params['use_max_calls_per_agent_decimal']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_attemptlimits(self, body: 'AttemptLimits', **kwargs) -> 'AttemptLimits':
        """
        Create attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_attemptlimits(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param AttemptLimits body: AttemptLimits (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_attemptlimits" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_attemptlimits`")


        resource_path = '/api/v2/outbound/attemptlimits'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_callabletimesets(self, body: 'CallableTimeSet', **kwargs) -> 'CallableTimeSet':
        """
        Create callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_callabletimesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CallableTimeSet body: DialerCallableTimeSet (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_callabletimesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_callabletimesets`")


        resource_path = '/api/v2/outbound/callabletimesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_callanalysisresponsesets(self, body: 'ResponseSet', **kwargs) -> 'ResponseSet':
        """
        Create a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_callanalysisresponsesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ResponseSet body: ResponseSet (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_callanalysisresponsesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_callanalysisresponsesets`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaign_agentownedmappingpreview(self, campaign_id: str, **kwargs) -> object:
        """
        Initiate request for a preview of how agents will be mapped to this campaign's contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaign_agentownedmappingpreview(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: object
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaign_agentownedmappingpreview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_outbound_campaign_agentownedmappingpreview`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/agentownedmappingpreview'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='object',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    @deprecated("post_outbound_campaign_callback_schedule is deprecated")
    def post_outbound_campaign_callback_schedule(self, campaign_id: str, body: 'ContactCallbackRequest', **kwargs) -> 'ContactCallbackRequest':
        """
        Schedule a Callback for a Dialer Campaign (Deprecated)
        This endpoint is deprecated and may have unexpected results. Please use \"/conversations/{conversationId}/participants/{participantId}/callbacks instead.\"

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaign_callback_schedule(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param ContactCallbackRequest body: ContactCallbackRequest (required)
        :return: ContactCallbackRequest
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaign_callback_schedule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_outbound_campaign_callback_schedule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaign_callback_schedule`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/callback/schedule'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactCallbackRequest',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaign_start(self, campaign_id: str, **kwargs) -> None:
        """
        Start the campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaign_start(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaign_start" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_outbound_campaign_start`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/start'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaign_stop(self, campaign_id: str, **kwargs) -> None:
        """
        Stop the campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaign_stop(campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaign_stop" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `post_outbound_campaign_stop`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/stop'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaignrules(self, body: 'CampaignRule', **kwargs) -> 'CampaignRule':
        """
        Create Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaignrules(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CampaignRule body: CampaignRule (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaignrules" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaignrules`")


        resource_path = '/api/v2/outbound/campaignrules'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaigns(self, body: 'Campaign', **kwargs) -> 'Campaign':
        """
        Create a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaigns(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param Campaign body: Campaign (required)
        :param bool use_max_calls_per_agent_decimal: Use maxCallsPerAgent with decimal precision
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body', 'use_max_calls_per_agent_decimal']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaigns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaigns`")


        resource_path = '/api/v2/outbound/campaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'use_max_calls_per_agent_decimal' in params:
            query_params['useMaxCallsPerAgentDecimal'] = params['use_max_calls_per_agent_decimal']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_campaigns_progress(self, body: List['str'], **kwargs) -> List['CampaignProgress']:
        """
        Get progress for a list of campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_campaigns_progress(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Campaign IDs (required)
        :return: list[CampaignProgress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_campaigns_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_campaigns_progress`")


        resource_path = '/api/v2/outbound/campaigns/progress'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignProgress]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_clear(self, contact_list_id: str, **kwargs) -> None:
        """
        Deletes all contacts out of a list. All outstanding recalls or rule-scheduled callbacks for non-preview campaigns configured with the contactlist will be cancelled.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_clear(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_clear" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_clear`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/clear'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts(self, contact_list_id: str, body: List['WritableDialerContact'], **kwargs) -> List['DialerContact']:
        """
        Add contacts to a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[WritableDialerContact] body: Contact (required)
        :param bool priority: Contact priority. True means the contact(s) will be dialed next; false means the contact will go to the end of the contact queue.
        :param bool clear_system_data: Clear system data. True means the system columns (attempts, callable status, etc) stored on the contact will be cleared if the contact already exists; false means they won't.
        :param bool do_not_queue: Do not queue. True means that updated contacts will not have their positions in the queue altered, so contacts that have already been dialed will not be redialed. For new contacts, this parameter has no effect; False means that updated contacts will be re-queued, according to the 'priority' parameter.
        :return: list[DialerContact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body', 'priority', 'clear_system_data', 'do_not_queue']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}
        if 'priority' in params:
            query_params['priority'] = params['priority']
        if 'clear_system_data' in params:
            query_params['clearSystemData'] = params['clear_system_data']
        if 'do_not_queue' in params:
            query_params['doNotQueue'] = params['do_not_queue']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DialerContact]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts_bulk(self, contact_list_id: str, body: List['str'], **kwargs) -> List['DialerContact']:
        """
        Get contacts from a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts_bulk(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param list[str] body: ContactIds to get. (required)
        :return: list[DialerContact]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts_bulk" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts_bulk`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts_bulk`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[DialerContact]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts_bulk_remove(self, contact_list_id: str, body: 'ContactBulkSearchParameters', **kwargs) -> 'ContactsBulkOperationJob':
        """
        Start an async job to delete contacts using a filter.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts_bulk_remove(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param ContactBulkSearchParameters body: Contact filter information. (required)
        :return: ContactsBulkOperationJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts_bulk_remove" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts_bulk_remove`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts_bulk_remove`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk/remove'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsBulkOperationJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts_bulk_update(self, contact_list_id: str, body: 'ContactBulkEditRequest', **kwargs) -> 'ContactsBulkOperationJob':
        """
        Start an async job to bulk edit contacts.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts_bulk_update(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param ContactBulkEditRequest body: Contact bulk edit request information. (required)
        :return: ContactsBulkOperationJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts_bulk_update" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts_bulk_update`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts_bulk_update`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/bulk/update'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactsBulkOperationJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_contacts_search(self, contact_list_id: str, body: 'ContactListingRequest', **kwargs) -> 'ContactListingResponse':
        """
        Query contacts from a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_contacts_search(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param ContactListingRequest body: Contact search parameters. (required)
        :return: ContactListingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_contacts_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_contacts_search`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlist_contacts_search`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/search'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListingResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlist_export(self, contact_list_id: str, **kwargs) -> 'DomainEntityRef':
        """
        Initiate the export of a contact list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlist_export(contact_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param ContactsExportRequest body: Export information to get
        :return: DomainEntityRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `post_outbound_contactlist_export`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityRef',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlistfilters(self, body: 'ContactListFilter', **kwargs) -> 'ContactListFilter':
        """
        Create Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlistfilters(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListFilter body: ContactListFilter (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlistfilters" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlistfilters`")


        resource_path = '/api/v2/outbound/contactlistfilters'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlistfilters_bulk_retrieve(self, body: 'ContactListFilterBulkRetrieveBody', **kwargs) -> 'ContactListFilterEntityListing':
        """
        Retrieve multiple contact list filters
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlistfilters_bulk_retrieve(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListFilterBulkRetrieveBody body: The contact list filters to retrieve (required)
        :return: ContactListFilterEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlistfilters_bulk_retrieve" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlistfilters_bulk_retrieve`")


        resource_path = '/api/v2/outbound/contactlistfilters/bulk/retrieve'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilterEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlistfilters_preview(self, body: 'ContactListFilter', **kwargs) -> 'FilterPreviewResponse':
        """
        Get a preview of the output of a contact list filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlistfilters_preview(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListFilter body: ContactListFilter (required)
        :return: FilterPreviewResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlistfilters_preview" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlistfilters_preview`")


        resource_path = '/api/v2/outbound/contactlistfilters/preview'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FilterPreviewResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlists(self, body: 'ContactList', **kwargs) -> 'ContactList':
        """
        Create a contact List.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlists(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactList body: ContactList (required)
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlists`")


        resource_path = '/api/v2/outbound/contactlists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlisttemplates(self, body: 'ContactListTemplate', **kwargs) -> 'ContactListTemplate':
        """
        Create Contact List Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlisttemplates(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListTemplate body: ContactListTemplate (required)
        :return: ContactListTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlisttemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlisttemplates`")


        resource_path = '/api/v2/outbound/contactlisttemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlisttemplates_bulk_add(self, body: List['ContactListTemplate'], **kwargs) -> 'ContactListTemplateEntityListing':
        """
        Add multiple contact list templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlisttemplates_bulk_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[ContactListTemplate] body: contact list template(s) to add (required)
        :return: ContactListTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlisttemplates_bulk_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlisttemplates_bulk_add`")


        resource_path = '/api/v2/outbound/contactlisttemplates/bulk/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_contactlisttemplates_bulk_retrieve(self, body: 'ContactListTemplateBulkRetrieveBody', **kwargs) -> 'ContactListTemplateEntityListing':
        """
        Get multiple contact list templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_contactlisttemplates_bulk_retrieve(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ContactListTemplateBulkRetrieveBody body: contact list templates to get (required)
        :return: ContactListTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_contactlisttemplates_bulk_retrieve" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_contactlisttemplates_bulk_retrieve`")


        resource_path = '/api/v2/outbound/contactlisttemplates/bulk/retrieve'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_conversation_dnc(self, conversation_id: str, **kwargs) -> None:
        """
        Add phone numbers to a Dialer DNC list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_conversation_dnc(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_conversation_dnc" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `post_outbound_conversation_dnc`")


        resource_path = '/api/v2/outbound/conversations/{conversationId}/dnc'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_digitalrulesets(self, body: 'DigitalRuleSet', **kwargs) -> 'DigitalRuleSet':
        """
        Create an Outbound Digital Rule Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_digitalrulesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DigitalRuleSet body: Digital Rule Set (required)
        :return: DigitalRuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_digitalrulesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_digitalrulesets`")


        resource_path = '/api/v2/outbound/digitalrulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DigitalRuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclist_emailaddresses(self, dnc_list_id: str, body: List['str'], **kwargs) -> None:
        """
        Add email addresses to a DNC list.
        Only Internal DNC lists may be appended to

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclist_emailaddresses(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param list[str] body: DNC email addresses (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclist_emailaddresses" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_outbound_dnclist_emailaddresses`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_dnclist_emailaddresses`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/emailaddresses'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclist_export(self, dnc_list_id: str, **kwargs) -> 'DomainEntityRef':
        """
        Initiate the export of a dnc list.
        Returns 200 if received OK.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclist_export(dnc_list_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :return: DomainEntityRef
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclist_export" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_outbound_dnclist_export`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/export'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DomainEntityRef',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclist_phonenumbers(self, dnc_list_id: str, body: List['str'], **kwargs) -> None:
        """
        Add phone numbers to a DNC list.
        Only Internal DNC lists may be appended to

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclist_phonenumbers(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param list[str] body: DNC Phone Numbers (required)
        :param str expiration_date_time: Expiration date for DNC phone numbers in yyyy-MM-ddTHH:mmZ format
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body', 'expiration_date_time']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclist_phonenumbers" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `post_outbound_dnclist_phonenumbers`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_dnclist_phonenumbers`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}/phonenumbers'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}
        if 'expiration_date_time' in params:
            query_params['expirationDateTime'] = params['expiration_date_time']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_dnclists(self, body: 'DncListCreate', **kwargs) -> 'DncList':
        """
        Create dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_dnclists(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DncListCreate body: DncList (required)
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_dnclists" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_dnclists`")


        resource_path = '/api/v2/outbound/dnclists'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_filespecificationtemplates(self, body: 'FileSpecificationTemplate', **kwargs) -> 'FileSpecificationTemplate':
        """
        Create File Specification Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_filespecificationtemplates(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param FileSpecificationTemplate body: FileSpecificationTemplate (required)
        :return: FileSpecificationTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_filespecificationtemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_filespecificationtemplates`")


        resource_path = '/api/v2/outbound/filespecificationtemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FileSpecificationTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_importtemplates(self, body: 'ImportTemplate', **kwargs) -> 'ImportTemplate':
        """
        Create Import Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_importtemplates(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ImportTemplate body: ImportTemplate (required)
        :return: ImportTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_importtemplates" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_importtemplates`")


        resource_path = '/api/v2/outbound/importtemplates'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_importtemplates_bulk_add(self, body: List['ImportTemplate'], **kwargs) -> 'ImportTemplateEntityListing':
        """
        Add multiple import templates
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_importtemplates_bulk_add(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[ImportTemplate] body: import template(s) to add (required)
        :return: ImportTemplateEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_importtemplates_bulk_add" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_importtemplates_bulk_add`")


        resource_path = '/api/v2/outbound/importtemplates/bulk/add'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportTemplateEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_messagingcampaign_start(self, messaging_campaign_id: str, **kwargs) -> None:
        """
        Start the campaign
        Documented permissions are applicable based on campaign type.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_messagingcampaign_start(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_messagingcampaign_start" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `post_outbound_messagingcampaign_start`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}/start'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_messagingcampaign_stop(self, messaging_campaign_id: str, **kwargs) -> None:
        """
        Stop the campaign
        Documented permissions are applicable based on campaign type.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_messagingcampaign_stop(messaging_campaign_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_messagingcampaign_stop" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `post_outbound_messagingcampaign_stop`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}/stop'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_messagingcampaigns(self, body: 'MessagingCampaign', **kwargs) -> 'MessagingCampaign':
        """
        Create a Messaging Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_messagingcampaigns(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param MessagingCampaign body: Messaging Campaign (required)
        :return: MessagingCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_messagingcampaigns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_messagingcampaigns`")


        resource_path = '/api/v2/outbound/messagingcampaigns'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_messagingcampaigns_progress(self, body: List['str'], **kwargs) -> List['CampaignProgress']:
        """
        Get progress for a list of messaging campaigns
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_messagingcampaigns_progress(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] body: Messaging Campaign IDs (required)
        :return: list[CampaignProgress]
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_messagingcampaigns_progress" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_messagingcampaigns_progress`")


        resource_path = '/api/v2/outbound/messagingcampaigns/progress'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='list[CampaignProgress]',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_rulesets(self, body: 'RuleSet', **kwargs) -> 'RuleSet':
        """
        Create a Rule Set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_rulesets(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param RuleSet body: RuleSet (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_rulesets" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_rulesets`")


        resource_path = '/api/v2/outbound/rulesets'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_outbound_sequences(self, body: 'CampaignSequence', **kwargs) -> 'CampaignSequence':
        """
        Create a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_outbound_sequences(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CampaignSequence body: Organization (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_outbound_sequences" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_outbound_sequences`")


        resource_path = '/api/v2/outbound/sequences'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_attemptlimit(self, attempt_limits_id: str, body: 'AttemptLimits', **kwargs) -> 'AttemptLimits':
        """
        Update attempt limits
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_attemptlimit(attempt_limits_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str attempt_limits_id: Attempt limits ID (required)
        :param AttemptLimits body: AttemptLimits (required)
        :return: AttemptLimits
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['attempt_limits_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_attemptlimit" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'attempt_limits_id' is set
        if ('attempt_limits_id' not in params) or (params['attempt_limits_id'] is None):
            raise ValueError("Missing the required parameter `attempt_limits_id` when calling `put_outbound_attemptlimit`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_attemptlimit`")


        resource_path = '/api/v2/outbound/attemptlimits/{attemptLimitsId}'.replace('{format}', 'json')
        path_params = {}
        if 'attempt_limits_id' in params:
            path_params['attemptLimitsId'] = params['attempt_limits_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='AttemptLimits',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_callabletimeset(self, callable_time_set_id: str, body: 'CallableTimeSet', **kwargs) -> 'CallableTimeSet':
        """
        Update callable time set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_callabletimeset(callable_time_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str callable_time_set_id: Callable Time Set ID (required)
        :param CallableTimeSet body: DialerCallableTimeSet (required)
        :return: CallableTimeSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['callable_time_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_callabletimeset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'callable_time_set_id' is set
        if ('callable_time_set_id' not in params) or (params['callable_time_set_id'] is None):
            raise ValueError("Missing the required parameter `callable_time_set_id` when calling `put_outbound_callabletimeset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_callabletimeset`")


        resource_path = '/api/v2/outbound/callabletimesets/{callableTimeSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'callable_time_set_id' in params:
            path_params['callableTimeSetId'] = params['callable_time_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CallableTimeSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_callanalysisresponseset(self, call_analysis_set_id: str, body: 'ResponseSet', **kwargs) -> 'ResponseSet':
        """
        Update a dialer call analysis response set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_callanalysisresponseset(call_analysis_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str call_analysis_set_id: Call Analysis Response Set ID (required)
        :param ResponseSet body: ResponseSet (required)
        :return: ResponseSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['call_analysis_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_callanalysisresponseset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'call_analysis_set_id' is set
        if ('call_analysis_set_id' not in params) or (params['call_analysis_set_id'] is None):
            raise ValueError("Missing the required parameter `call_analysis_set_id` when calling `put_outbound_callanalysisresponseset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_callanalysisresponseset`")


        resource_path = '/api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'call_analysis_set_id' in params:
            path_params['callAnalysisSetId'] = params['call_analysis_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ResponseSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaign(self, campaign_id: str, body: 'Campaign', **kwargs) -> 'Campaign':
        """
        Update a campaign.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaign(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param Campaign body: Campaign (required)
        :param bool use_max_calls_per_agent_decimal: Use maxCallsPerAgent with decimal precision
        :return: Campaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body', 'use_max_calls_per_agent_decimal']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_campaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaign`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}
        if 'use_max_calls_per_agent_decimal' in params:
            query_params['useMaxCallsPerAgentDecimal'] = params['use_max_calls_per_agent_decimal']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Campaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaign_agent(self, campaign_id: str, user_id: str, body: 'Agent', **kwargs) -> str:
        """
        Send notification that an agent's state changed 
        New agent state.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaign_agent(campaign_id, user_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param str user_id: Agent's user ID (required)
        :param Agent body: agent (required)
        :return: str
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'user_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaign_agent" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_campaign_agent`")
        # verify the required parameter 'user_id' is set
        if ('user_id' not in params) or (params['user_id'] is None):
            raise ValueError("Missing the required parameter `user_id` when calling `put_outbound_campaign_agent`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaign_agent`")


        resource_path = '/api/v2/outbound/campaigns/{campaignId}/agents/{userId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']
        if 'user_id' in params:
            path_params['userId'] = params['user_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='str',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_campaignrule(self, campaign_rule_id: str, body: 'CampaignRule', **kwargs) -> 'CampaignRule':
        """
        Update Campaign Rule
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_campaignrule(campaign_rule_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_rule_id: Campaign Rule ID (required)
        :param CampaignRule body: CampaignRule (required)
        :return: CampaignRule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_rule_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_campaignrule" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_rule_id' is set
        if ('campaign_rule_id' not in params) or (params['campaign_rule_id'] is None):
            raise ValueError("Missing the required parameter `campaign_rule_id` when calling `put_outbound_campaignrule`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_campaignrule`")


        resource_path = '/api/v2/outbound/campaignrules/{campaignRuleId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_rule_id' in params:
            path_params['campaignRuleId'] = params['campaign_rule_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignRule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlist(self, contact_list_id: str, body: 'ContactList', **kwargs) -> 'ContactList':
        """
        Update a contact list.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlist(contact_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: ContactList ID (required)
        :param ContactList body: ContactList (required)
        :return: ContactList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_outbound_contactlist`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlist`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlist_contact(self, contact_list_id: str, contact_id: str, body: 'DialerContact', **kwargs) -> 'DialerContact':
        """
        Update a contact.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlist_contact(contact_list_id, contact_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_id: Contact List ID (required)
        :param str contact_id: Contact ID (required)
        :param DialerContact body: Contact (required)
        :return: DialerContact
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_id', 'contact_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlist_contact" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_id' is set
        if ('contact_list_id' not in params) or (params['contact_list_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_id` when calling `put_outbound_contactlist_contact`")
        # verify the required parameter 'contact_id' is set
        if ('contact_id' not in params) or (params['contact_id'] is None):
            raise ValueError("Missing the required parameter `contact_id` when calling `put_outbound_contactlist_contact`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlist_contact`")


        resource_path = '/api/v2/outbound/contactlists/{contactListId}/contacts/{contactId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_id' in params:
            path_params['contactListId'] = params['contact_list_id']
        if 'contact_id' in params:
            path_params['contactId'] = params['contact_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DialerContact',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlistfilter(self, contact_list_filter_id: str, body: 'ContactListFilter', **kwargs) -> 'ContactListFilter':
        """
        Update Contact List Filter
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlistfilter(contact_list_filter_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_filter_id: Contact List Filter ID (required)
        :param ContactListFilter body: ContactListFilter (required)
        :return: ContactListFilter
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_filter_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlistfilter" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_filter_id' is set
        if ('contact_list_filter_id' not in params) or (params['contact_list_filter_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_filter_id` when calling `put_outbound_contactlistfilter`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlistfilter`")


        resource_path = '/api/v2/outbound/contactlistfilters/{contactListFilterId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_filter_id' in params:
            path_params['contactListFilterId'] = params['contact_list_filter_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListFilter',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_contactlisttemplate(self, contact_list_template_id: str, body: 'ContactListTemplate', **kwargs) -> 'ContactListTemplate':
        """
        Update a contact list template.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_contactlisttemplate(contact_list_template_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str contact_list_template_id: ContactListTemplate ID (required)
        :param ContactListTemplate body: ContactListTemplate (required)
        :return: ContactListTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['contact_list_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_contactlisttemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'contact_list_template_id' is set
        if ('contact_list_template_id' not in params) or (params['contact_list_template_id'] is None):
            raise ValueError("Missing the required parameter `contact_list_template_id` when calling `put_outbound_contactlisttemplate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_contactlisttemplate`")


        resource_path = '/api/v2/outbound/contactlisttemplates/{contactListTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'contact_list_template_id' in params:
            path_params['contactListTemplateId'] = params['contact_list_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ContactListTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_digitalruleset(self, digital_rule_set_id: str, body: 'DigitalRuleSet', **kwargs) -> 'DigitalRuleSet':
        """
        Update an Outbound Digital Rule Set
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_digitalruleset(digital_rule_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str digital_rule_set_id: The Digital Rule Set ID (required)
        :param DigitalRuleSet body: Digital Rule Set (required)
        :return: DigitalRuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['digital_rule_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_digitalruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'digital_rule_set_id' is set
        if ('digital_rule_set_id' not in params) or (params['digital_rule_set_id'] is None):
            raise ValueError("Missing the required parameter `digital_rule_set_id` when calling `put_outbound_digitalruleset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_digitalruleset`")


        resource_path = '/api/v2/outbound/digitalrulesets/{digitalRuleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'digital_rule_set_id' in params:
            path_params['digitalRuleSetId'] = params['digital_rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DigitalRuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_dnclist(self, dnc_list_id: str, body: 'DncList', **kwargs) -> 'DncList':
        """
        Update dialer DNC list
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_dnclist(dnc_list_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dnc_list_id: DncList ID (required)
        :param DncList body: DncList (required)
        :return: DncList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dnc_list_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_dnclist" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dnc_list_id' is set
        if ('dnc_list_id' not in params) or (params['dnc_list_id'] is None):
            raise ValueError("Missing the required parameter `dnc_list_id` when calling `put_outbound_dnclist`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_dnclist`")


        resource_path = '/api/v2/outbound/dnclists/{dncListId}'.replace('{format}', 'json')
        path_params = {}
        if 'dnc_list_id' in params:
            path_params['dncListId'] = params['dnc_list_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DncList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_filespecificationtemplate(self, file_specification_template_id: str, body: 'FileSpecificationTemplate', **kwargs) -> 'FileSpecificationTemplate':
        """
        Update File Specification Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_filespecificationtemplate(file_specification_template_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str file_specification_template_id: File Specification Template ID (required)
        :param FileSpecificationTemplate body: fileSpecificationTemplate (required)
        :return: FileSpecificationTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['file_specification_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_filespecificationtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'file_specification_template_id' is set
        if ('file_specification_template_id' not in params) or (params['file_specification_template_id'] is None):
            raise ValueError("Missing the required parameter `file_specification_template_id` when calling `put_outbound_filespecificationtemplate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_filespecificationtemplate`")


        resource_path = '/api/v2/outbound/filespecificationtemplates/{fileSpecificationTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'file_specification_template_id' in params:
            path_params['fileSpecificationTemplateId'] = params['file_specification_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='FileSpecificationTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_importtemplate(self, import_template_id: str, body: 'ImportTemplate', **kwargs) -> 'ImportTemplate':
        """
        Update Import Template
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_importtemplate(import_template_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str import_template_id: Import Template ID (required)
        :param ImportTemplate body: importTemplate (required)
        :return: ImportTemplate
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['import_template_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_importtemplate" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'import_template_id' is set
        if ('import_template_id' not in params) or (params['import_template_id'] is None):
            raise ValueError("Missing the required parameter `import_template_id` when calling `put_outbound_importtemplate`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_importtemplate`")


        resource_path = '/api/v2/outbound/importtemplates/{importTemplateId}'.replace('{format}', 'json')
        path_params = {}
        if 'import_template_id' in params:
            path_params['importTemplateId'] = params['import_template_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ImportTemplate',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_messagingcampaign(self, messaging_campaign_id: str, body: 'MessagingCampaign', **kwargs) -> 'MessagingCampaign':
        """
        Update an Outbound Messaging Campaign
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_messagingcampaign(messaging_campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: The Messaging Campaign ID (required)
        :param MessagingCampaign body: MessagingCampaign (required)
        :return: MessagingCampaign
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `put_outbound_messagingcampaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_messagingcampaign`")


        resource_path = '/api/v2/outbound/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaign',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_ruleset(self, rule_set_id: str, body: 'RuleSet', **kwargs) -> 'RuleSet':
        """
        Update a Rule Set.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_ruleset(rule_set_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str rule_set_id: Rule Set ID (required)
        :param RuleSet body: RuleSet (required)
        :return: RuleSet
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['rule_set_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_ruleset" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'rule_set_id' is set
        if ('rule_set_id' not in params) or (params['rule_set_id'] is None):
            raise ValueError("Missing the required parameter `rule_set_id` when calling `put_outbound_ruleset`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_ruleset`")


        resource_path = '/api/v2/outbound/rulesets/{ruleSetId}'.replace('{format}', 'json')
        path_params = {}
        if 'rule_set_id' in params:
            path_params['ruleSetId'] = params['rule_set_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='RuleSet',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_campaign(self, campaign_id: str, body: 'CampaignSchedule', **kwargs) -> 'CampaignSchedule':
        """
        Update a new campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_campaign(campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str campaign_id: Campaign ID (required)
        :param CampaignSchedule body: CampaignSchedule (required)
        :return: CampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_campaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'campaign_id' is set
        if ('campaign_id' not in params) or (params['campaign_id'] is None):
            raise ValueError("Missing the required parameter `campaign_id` when calling `put_outbound_schedules_campaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_campaign`")


        resource_path = '/api/v2/outbound/schedules/campaigns/{campaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'campaign_id' in params:
            path_params['campaignId'] = params['campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_emailcampaign(self, email_campaign_id: str, body: 'EmailCampaignSchedule', **kwargs) -> 'EmailCampaignSchedule':
        """
        Update an email campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_emailcampaign(email_campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str email_campaign_id: Email Campaign ID (required)
        :param EmailCampaignSchedule body: EmailCampaignSchedule (required)
        :return: EmailCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['email_campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_emailcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'email_campaign_id' is set
        if ('email_campaign_id' not in params) or (params['email_campaign_id'] is None):
            raise ValueError("Missing the required parameter `email_campaign_id` when calling `put_outbound_schedules_emailcampaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_emailcampaign`")


        resource_path = '/api/v2/outbound/schedules/emailcampaigns/{emailCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'email_campaign_id' in params:
            path_params['emailCampaignId'] = params['email_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EmailCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_messagingcampaign(self, messaging_campaign_id: str, body: 'MessagingCampaignSchedule', **kwargs) -> 'MessagingCampaignSchedule':
        """
        Update a new messaging campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_messagingcampaign(messaging_campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str messaging_campaign_id: Messaging Campaign ID (required)
        :param MessagingCampaignSchedule body: MessagingCampaignSchedule (required)
        :return: MessagingCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['messaging_campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_messagingcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'messaging_campaign_id' is set
        if ('messaging_campaign_id' not in params) or (params['messaging_campaign_id'] is None):
            raise ValueError("Missing the required parameter `messaging_campaign_id` when calling `put_outbound_schedules_messagingcampaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_messagingcampaign`")


        resource_path = '/api/v2/outbound/schedules/messagingcampaigns/{messagingCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'messaging_campaign_id' in params:
            path_params['messagingCampaignId'] = params['messaging_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='MessagingCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_sequence(self, sequence_id: str, body: 'SequenceSchedule', **kwargs) -> 'SequenceSchedule':
        """
        Update a new sequence schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_sequence(sequence_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Sequence ID (required)
        :param SequenceSchedule body: SequenceSchedule (required)
        :return: SequenceSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_outbound_schedules_sequence`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_sequence`")


        resource_path = '/api/v2/outbound/schedules/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SequenceSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_schedules_whatsappcampaign(self, whats_app_campaign_id: str, body: 'WhatsAppCampaignSchedule', **kwargs) -> 'WhatsAppCampaignSchedule':
        """
        Update a WhatsApp campaign schedule.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_schedules_whatsappcampaign(whats_app_campaign_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str whats_app_campaign_id: WhatsApp Campaign ID (required)
        :param WhatsAppCampaignSchedule body: WhatsAppCampaignSchedule (required)
        :return: WhatsAppCampaignSchedule
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['whats_app_campaign_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_schedules_whatsappcampaign" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'whats_app_campaign_id' is set
        if ('whats_app_campaign_id' not in params) or (params['whats_app_campaign_id'] is None):
            raise ValueError("Missing the required parameter `whats_app_campaign_id` when calling `put_outbound_schedules_whatsappcampaign`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_schedules_whatsappcampaign`")


        resource_path = '/api/v2/outbound/schedules/whatsappcampaigns/{whatsAppCampaignId}'.replace('{format}', 'json')
        path_params = {}
        if 'whats_app_campaign_id' in params:
            path_params['whatsAppCampaignId'] = params['whats_app_campaign_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WhatsAppCampaignSchedule',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_sequence(self, sequence_id: str, body: 'CampaignSequence', **kwargs) -> 'CampaignSequence':
        """
        Update a new campaign sequence.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_sequence(sequence_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sequence_id: Campaign Sequence ID (required)
        :param CampaignSequence body: Organization (required)
        :return: CampaignSequence
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sequence_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_sequence" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sequence_id' is set
        if ('sequence_id' not in params) or (params['sequence_id'] is None):
            raise ValueError("Missing the required parameter `sequence_id` when calling `put_outbound_sequence`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_sequence`")


        resource_path = '/api/v2/outbound/sequences/{sequenceId}'.replace('{format}', 'json')
        path_params = {}
        if 'sequence_id' in params:
            path_params['sequenceId'] = params['sequence_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CampaignSequence',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_outbound_wrapupcodemappings(self, body: 'WrapUpCodeMapping', **kwargs) -> 'WrapUpCodeMapping':
        """
        Update the Dialer wrap up code mapping.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_outbound_wrapupcodemappings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param WrapUpCodeMapping body: wrapUpCodeMapping (required)
        :return: WrapUpCodeMapping
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_outbound_wrapupcodemappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_outbound_wrapupcodemappings`")


        resource_path = '/api/v2/outbound/wrapupcodemappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='WrapUpCodeMapping',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
