# coding: utf-8

"""
SpeechTextAnalyticsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import CategoriesEntityListing
from ..models import CategoryRequest
from ..models import CommunicationTranslationList
from ..models import ConversationCategoriesEntityListing
from ..models import ConversationMetrics
from ..models import CreateReprocessJobRequest
from ..models import DeleteProgramResponse
from ..models import DictionaryFeedback
from ..models import DictionaryFeedbackEntityListing
from ..models import EntityListing
from ..models import ErrorBody
from ..models import GeneralProgramJob
from ..models import GeneralProgramJobRequest
from ..models import GeneralTopicsEntityListing
from ..models import InsightsSettingsRequest
from ..models import JsonSearchResponse
from ..models import Program
from ..models import ProgramInsightsSettings
from ..models import ProgramInsightsSettingsEntityListing
from ..models import ProgramJob
from ..models import ProgramJobRequest
from ..models import ProgramMappings
from ..models import ProgramMappingsRequest
from ..models import ProgramRequest
from ..models import ProgramTranscriptionEngines
from ..models import ProgramsEntityListing
from ..models import ProgramsMappingsEntityListing
from ..models import ReprocessInteractionsByJobIdResponse
from ..models import ReprocessJobEntityListingResponse
from ..models import ReprocessJobResponse
from ..models import SentimentData
from ..models import SentimentFeedback
from ..models import SentimentFeedbackEntityListing
from ..models import SpeechTextAnalyticsConversationSummaryListing
from ..models import SpeechTextAnalyticsSettingsRequest
from ..models import SpeechTextAnalyticsSettingsResponse
from ..models import StaCategory
from ..models import SupportedDialectsEntityListing
from ..models import TestTopicPhraseJob
from ..models import TestTopicPhraseJobRequest
from ..models import TestTopicPhraseJobs
from ..models import Topic
from ..models import TopicJob
from ..models import TopicJobRequest
from ..models import TopicRequest
from ..models import TopicsEntityListing
from ..models import TranscriptSearchRequest
from ..models import TranscriptUrl
from ..models import TranscriptUrls
from ..models import TranscriptionEnginesRequest
from ..models import TranslateSupportedLanguageList
from ..models import UnifiedGeneralTopicEntityListing
from ..models import UnpublishedProgramsEntityListing

class SpeechTextAnalyticsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def delete_speechandtextanalytics_category(self, category_id: str, **kwargs) -> None:
        """
        Delete a Speech & Text Analytics category by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_category(category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: The id of the category (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `delete_speechandtextanalytics_category`")


        resource_path = '/api/v2/speechandtextanalytics/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(self, dictionary_feedback_id: str, **kwargs) -> None:
        """
        Delete a Speech & Text Analytics DictionaryFeedback by Id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(dictionary_feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dictionary_feedback_id: The Id of the Dictionary Feedback (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dictionary_feedback_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dictionary_feedback_id' is set
        if ('dictionary_feedback_id' not in params) or (params['dictionary_feedback_id'] is None):
            raise ValueError("Missing the required parameter `dictionary_feedback_id` when calling `delete_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id`")


        resource_path = '/api/v2/speechandtextanalytics/dictionaryfeedback/{dictionaryFeedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'dictionary_feedback_id' in params:
            path_params['dictionaryFeedbackId'] = params['dictionary_feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_program(self, program_id: str, **kwargs) -> 'DeleteProgramResponse':
        """
        Delete a Speech & Text Analytics program by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_program(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param bool force_delete: Indicates whether the program is forced to be deleted or not. Required when the program to delete is the default program.
        :return: DeleteProgramResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'force_delete']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `delete_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}
        if 'force_delete' in params:
            query_params['forceDelete'] = params['force_delete']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DeleteProgramResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_reprocessing_job(self, job_id: str, **kwargs) -> None:
        """
        Delete a Speech & Text Analytics Reprocessing job by Id
        
	    delete_speechandtextanalytics_reprocessing_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_reprocessing_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The Id of the Reprocessing job (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_reprocessing_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `delete_speechandtextanalytics_reprocessing_job`")


        resource_path = '/api/v2/speechandtextanalytics/reprocessing/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_sentimentfeedback(self, **kwargs) -> None:
        """
        Delete All Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_sentimentfeedback(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id(self, sentiment_feedback_id: str, **kwargs) -> None:
        """
        Delete a Speech & Text Analytics SentimentFeedback by Id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id(sentiment_feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str sentiment_feedback_id: The Id of the SentimentFeedback (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['sentiment_feedback_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'sentiment_feedback_id' is set
        if ('sentiment_feedback_id' not in params) or (params['sentiment_feedback_id'] is None):
            raise ValueError("Missing the required parameter `sentiment_feedback_id` when calling `delete_speechandtextanalytics_sentimentfeedback_sentiment_feedback_id`")


        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback/{sentimentFeedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'sentiment_feedback_id' in params:
            path_params['sentimentFeedbackId'] = params['sentiment_feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def delete_speechandtextanalytics_topic(self, topic_id: str, **kwargs) -> None:
        """
        Delete a Speech & Text Analytics topic by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.delete_speechandtextanalytics_topic(topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :return: None
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method delete_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `delete_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'DELETE',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type=None,
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_categories(self, **kwargs) -> 'CategoriesEntityListing':
        """
        Get the list of Speech and Text Analytics categories
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_categories(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The page size for the listing. The max that will be returned is 25.
        :param int page_number: The page number for the listing
        :param str name: The category name filter applied to the listing
        :param str sort_order: The sort order for the listing
        :param str sort_by: The field to sort by for the listing
        :param list[str] ids: Comma separated Category IDs to filter by. Cannot be used with other filters. Maximum of 25 IDs allowed.
        :return: CategoriesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'name', 'sort_order', 'sort_by', 'ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_categories" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/categories'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'ids' in params:
            query_params['ids'] = params['ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CategoriesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_category(self, category_id: str, **kwargs) -> 'StaCategory':
        """
        Get a Speech & Text Analytics Category by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_category(category_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: The id of the category (required)
        :return: StaCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `get_speechandtextanalytics_category`")


        resource_path = '/api/v2/speechandtextanalytics/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='StaCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation(self, conversation_id: str, **kwargs) -> 'ConversationMetrics':
        """
        Get Speech and Text Analytics for a specific conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation Id (required)
        :return: ConversationMetrics
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConversationMetrics',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_categories(self, conversation_id: str, **kwargs) -> 'ConversationCategoriesEntityListing':
        """
        Get the list of detected Speech and Text Analytics categories of conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_categories(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: The id of the conversation (required)
        :param int page_size: The page size for the listing. The max that will be returned is 50.
        :param int page_number: The page number for the listing
        :return: ConversationCategoriesEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'page_size', 'page_number']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_categories" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_categories`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/categories'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ConversationCategoriesEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_communication_transcripturl(self, conversation_id: str, communication_id: str, **kwargs) -> 'TranscriptUrl':
        """
        Get the pre-signed S3 URL for the transcript of a specific communication of a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_communication_transcripturl(conversation_id, communication_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str communication_id: Communication ID (required)
        :return: TranscriptUrl
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'communication_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_communication_transcripturl" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturl`")
        # verify the required parameter 'communication_id' is set
        if ('communication_id' not in params) or (params['communication_id'] is None):
            raise ValueError("Missing the required parameter `communication_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturl`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/communications/{communicationId}/transcripturl'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'communication_id' in params:
            path_params['communicationId'] = params['communication_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptUrl',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_communication_transcripturls(self, conversation_id: str, communication_id: str, **kwargs) -> 'TranscriptUrls':
        """
        Get the list of pre-signed S3 URL for the transcripts of a specific communication of a conversation
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_communication_transcripturls(conversation_id, communication_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: Conversation ID (required)
        :param str communication_id: Communication ID (required)
        :return: TranscriptUrls
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id', 'communication_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_communication_transcripturls" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturls`")
        # verify the required parameter 'communication_id' is set
        if ('communication_id' not in params) or (params['communication_id'] is None):
            raise ValueError("Missing the required parameter `communication_id` when calling `get_speechandtextanalytics_conversation_communication_transcripturls`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/communications/{communicationId}/transcripturls'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']
        if 'communication_id' in params:
            path_params['communicationId'] = params['communication_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranscriptUrls',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_sentiments(self, conversation_id: str, **kwargs) -> 'SentimentData':
        """
        Get sentiment data
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_sentiments(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: The conversation ID of the sentiment data (required)
        :return: SentimentData
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_sentiments" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_sentiments`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/sentiments'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SentimentData',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_conversation_summaries(self, conversation_id: str, **kwargs) -> 'SpeechTextAnalyticsConversationSummaryListing':
        """
        Get conversation summaries by conversation id.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_conversation_summaries(conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str conversation_id: The conversation ID of the summaries (required)
        :return: SpeechTextAnalyticsConversationSummaryListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['conversation_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_conversation_summaries" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_conversation_summaries`")


        resource_path = '/api/v2/speechandtextanalytics/conversations/{conversationId}/summaries'.replace('{format}', 'json')
        path_params = {}
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsConversationSummaryListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_dictionaryfeedback(self, **kwargs) -> 'DictionaryFeedbackEntityListing':
        """
        Get the list of Speech & Text Analytics dictionary feedbacks
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_dictionaryfeedback(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The key for filter the listing by dialect, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: DictionaryFeedbackEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect', 'next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_dictionaryfeedback" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/dictionaryfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DictionaryFeedbackEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(self, dictionary_feedback_id: str, **kwargs) -> 'DictionaryFeedback':
        """
        Get a Speech & Text Analytics dictionary feedback by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(dictionary_feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dictionary_feedback_id: The Id of the Dictionary Feedback (required)
        :return: DictionaryFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dictionary_feedback_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dictionary_feedback_id' is set
        if ('dictionary_feedback_id' not in params) or (params['dictionary_feedback_id'] is None):
            raise ValueError("Missing the required parameter `dictionary_feedback_id` when calling `get_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id`")


        resource_path = '/api/v2/speechandtextanalytics/dictionaryfeedback/{dictionaryFeedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'dictionary_feedback_id' in params:
            path_params['dictionaryFeedbackId'] = params['dictionary_feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DictionaryFeedback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program(self, program_id: str, **kwargs) -> 'Program':
        """
        Get a Speech & Text Analytics program by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program_mappings(self, program_id: str, **kwargs) -> 'ProgramMappings':
        """
        Get Speech & Text Analytics program mappings to queues and flows by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program_mappings(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: ProgramMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program_mappings`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/mappings'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramMappings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program_settings_insights(self, program_id: str, **kwargs) -> 'ProgramInsightsSettings':
        """
        Get AI Insights settings of a program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program_settings_insights(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: ProgramInsightsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program_settings_insights" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program_settings_insights`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/settings/insights'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramInsightsSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_program_transcriptionengines(self, program_id: str, **kwargs) -> 'ProgramTranscriptionEngines':
        """
        Get transcription engine settings of a program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_program_transcriptionengines(program_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :return: ProgramTranscriptionEngines
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_program_transcriptionengines" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `get_speechandtextanalytics_program_transcriptionengines`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/transcriptionengines'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramTranscriptionEngines',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs(self, **kwargs) -> 'ProgramsEntityListing':
        """
        Get the list of Speech & Text Analytics programs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :param str state: Program state. Defaults to Latest
        :return: ProgramsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size', 'state']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'state' in params:
            query_params['state'] = params['state']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_general_job(self, job_id: str, **kwargs) -> 'GeneralProgramJob':
        """
        Get a Speech & Text Analytics general program job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_general_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish programs job (required)
        :return: GeneralProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_general_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_programs_general_job`")


        resource_path = '/api/v2/speechandtextanalytics/programs/general/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_mappings(self, **kwargs) -> 'ProgramsMappingsEntityListing':
        """
        Get the list of Speech & Text Analytics programs mappings to queues and flows
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_mappings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: ProgramsMappingsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_mappings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/mappings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramsMappingsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_publishjob(self, job_id: str, **kwargs) -> 'ProgramJob':
        """
        Get a Speech & Text Analytics publish programs job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_publishjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish programs job (required)
        :return: ProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_publishjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_programs_publishjob`")


        resource_path = '/api/v2/speechandtextanalytics/programs/publishjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_settings_insights(self, **kwargs) -> 'ProgramInsightsSettingsEntityListing':
        """
        Get the list of program AI Insights settings for the organization
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_settings_insights(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The page size for the listing. The max that will be returned is 100.
        :param int page_number: The page number for the listing
        :param list[str] program_ids: Comma separated Program IDs to filter by. Maximum of 50 IDs allowed.
        :return: ProgramInsightsSettingsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'program_ids']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_settings_insights" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/settings/insights'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'program_ids' in params:
            query_params['programIds'] = params['program_ids']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramInsightsSettingsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_transcriptionengines_dialects(self, **kwargs) -> 'SupportedDialectsEntityListing':
        """
        Get supported dialects for each transcription engine
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_transcriptionengines_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SupportedDialectsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_transcriptionengines_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/transcriptionengines/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SupportedDialectsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_programs_unpublished(self, **kwargs) -> 'UnpublishedProgramsEntityListing':
        """
        Get the list of Speech & Text Analytics unpublished programs
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_programs_unpublished(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing
        :return: UnpublishedProgramsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_programs_unpublished" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/programs/unpublished'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UnpublishedProgramsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_reprocessing_job(self, job_id: str, **kwargs) -> 'ReprocessJobResponse':
        """
        Get a Speech & Text Analytics reprocess job by id
        
	    get_speechandtextanalytics_reprocessing_job is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_reprocessing_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The Id of the Reprocessing job (required)
        :return: ReprocessJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_reprocessing_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_reprocessing_job`")


        resource_path = '/api/v2/speechandtextanalytics/reprocessing/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReprocessJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_reprocessing_job_interactions(self, job_id: str, **kwargs) -> 'ReprocessInteractionsByJobIdResponse':
        """
        Get a Speech & Text Analytics Reprocessing interactions statuses by job id
        
	    get_speechandtextanalytics_reprocessing_job_interactions is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_reprocessing_job_interactions(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The Id of the Reprocessing job (required)
        :return: ReprocessInteractionsByJobIdResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_reprocessing_job_interactions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_reprocessing_job_interactions`")


        resource_path = '/api/v2/speechandtextanalytics/reprocessing/jobs/{jobId}/interactions'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReprocessInteractionsByJobIdResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_reprocessing_jobs(self, **kwargs) -> 'ReprocessJobEntityListingResponse':
        """
        Get the list of Speech & Text Analytics reprocess jobs
        
	    get_speechandtextanalytics_reprocessing_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_reprocessing_jobs(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param int page_size: The page size for the listing. The max that will be returned is 100. Default is 25.
        :param int page_number: The page number for the listing. Defaults to 1.
        :param str sort_order: Results are sorted by dateCreated. Please choose the sort order. The default is descending (desc).
        :param str name: Case insensitive partial name to filter by.
        :return: ReprocessJobEntityListingResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['page_size', 'page_number', 'sort_order', 'name']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_reprocessing_jobs" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/reprocessing/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'page_number' in params:
            query_params['pageNumber'] = params['page_number']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']
        if 'name' in params:
            query_params['name'] = params['name']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReprocessJobEntityListingResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_sentiment_dialects(self, **kwargs) -> 'EntityListing':
        """
        Get the list of Speech & Text Analytics sentiment supported dialects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_sentiment_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_sentiment_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentiment/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_sentimentfeedback(self, **kwargs) -> 'SentimentFeedbackEntityListing':
        """
        Get the list of Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_sentimentfeedback(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The key for filter the listing by dialect, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :return: SentimentFeedbackEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SentimentFeedbackEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_settings(self, **kwargs) -> 'SpeechTextAnalyticsSettingsResponse':
        """
        Get Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_settings(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topic(self, topic_id: str, **kwargs) -> 'Topic':
        """
        Get a Speech & Text Analytics topic by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topic(topic_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `get_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics(self, **kwargs) -> 'TopicsEntityListing':
        """
        Get the list of Speech & Text Analytics topics
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str next_page: The key for listing the next page
        :param int page_size: The page size for the listing. The max that will be returned is 500.
        :param str state: Topic state. Defaults to latest
        :param str name: Case insensitive partial name to filter by
        :param list[str] ids: Comma separated Topic IDs to filter by. Cannot be used with other filters. Maximum of 50 IDs allowed.
        :param list[str] dialects: Comma separated dialect strings to filter by. Maximum of 15 dialects allowed.
        :param str sort_by: Sort results by. Defaults to name
        :param str sort_order: Sort order. Defaults to asc
        :return: TopicsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['next_page', 'page_size', 'state', 'name', 'ids', 'dialects', 'sort_by', 'sort_order']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'next_page' in params:
            query_params['nextPage'] = params['next_page']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'state' in params:
            query_params['state'] = params['state']
        if 'name' in params:
            query_params['name'] = params['name']
        if 'ids' in params:
            query_params['ids'] = params['ids']
        if 'dialects' in params:
            query_params['dialects'] = params['dialects']
        if 'sort_by' in params:
            query_params['sortBy'] = params['sort_by']
        if 'sort_order' in params:
            query_params['sortOrder'] = params['sort_order']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_dialects(self, **kwargs) -> 'EntityListing':
        """
        Get list of supported Speech & Text Analytics topics dialects
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_dialects(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: EntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_dialects" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics/dialects'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='EntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_general(self, **kwargs) -> 'GeneralTopicsEntityListing':
        """
        Get the Speech & Text Analytics general topics for a given dialect
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_general(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The dialect of the general topics, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :return: GeneralTopicsEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_general" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics/general'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralTopicsEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_general_status(self, **kwargs) -> 'UnifiedGeneralTopicEntityListing':
        """
        Get the list of general topics from the org and the system with their current status
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_general_status(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dialect: The dialect of the general topics, dialect format is {language}-{country} where language follows ISO 639-1 standard and country follows ISO 3166-1 alpha 2 standard
        :return: UnifiedGeneralTopicEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dialect']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_general_status" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/topics/general/status'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'dialect' in params:
            query_params['dialect'] = params['dialect']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UnifiedGeneralTopicEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_publishjob(self, job_id: str, **kwargs) -> 'TopicJob':
        """
        Get a Speech & Text Analytics publish topics job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_publishjob(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: The id of the publish topics job (required)
        :return: TopicJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_publishjob" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_topics_publishjob`")


        resource_path = '/api/v2/speechandtextanalytics/topics/publishjobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_topics_testphrase_job(self, job_id: str, **kwargs) -> 'TestTopicPhraseJob':
        """
        Get a Speech & Text Analytics test topics phrase job by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_topics_testphrase_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: the id of the test topic phrase job (required)
        :return: TestTopicPhraseJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_topics_testphrase_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_speechandtextanalytics_topics_testphrase_job`")


        resource_path = '/api/v2/speechandtextanalytics/topics/testphrase/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestTopicPhraseJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_translations_language_conversation(self, language_id: str, conversation_id: str, **kwargs) -> 'CommunicationTranslationList':
        """
        Translate a single interaction recording (or an email conversation)
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_translations_language_conversation(language_id, conversation_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str language_id: Target translation language (required)
        :param str conversation_id: Conversation id (required)
        :param str communication_id: Communication id associated with the conversation. Please provide a valid communicationId when requesting non-email interactions.
        :param str recording_id: Recording id associated with the communication. Please provide a valid recordingId when requesting voice interactions.
        :return: CommunicationTranslationList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['language_id', 'conversation_id', 'communication_id', 'recording_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_translations_language_conversation" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'language_id' is set
        if ('language_id' not in params) or (params['language_id'] is None):
            raise ValueError("Missing the required parameter `language_id` when calling `get_speechandtextanalytics_translations_language_conversation`")
        # verify the required parameter 'conversation_id' is set
        if ('conversation_id' not in params) or (params['conversation_id'] is None):
            raise ValueError("Missing the required parameter `conversation_id` when calling `get_speechandtextanalytics_translations_language_conversation`")


        resource_path = '/api/v2/speechandtextanalytics/translations/languages/{languageId}/conversations/{conversationId}'.replace('{format}', 'json')
        path_params = {}
        if 'language_id' in params:
            path_params['languageId'] = params['language_id']
        if 'conversation_id' in params:
            path_params['conversationId'] = params['conversation_id']

        query_params = {}
        if 'communication_id' in params:
            query_params['communicationId'] = params['communication_id']
        if 'recording_id' in params:
            query_params['recordingId'] = params['recording_id']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='CommunicationTranslationList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_speechandtextanalytics_translations_languages(self, **kwargs) -> 'TranslateSupportedLanguageList':
        """
        Get supported translation languages
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_speechandtextanalytics_translations_languages(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :return: TranslateSupportedLanguageList
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = []
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_speechandtextanalytics_translations_languages" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/speechandtextanalytics/translations/languages'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TranslateSupportedLanguageList',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def patch_speechandtextanalytics_settings(self, body: 'SpeechTextAnalyticsSettingsRequest', **kwargs) -> 'SpeechTextAnalyticsSettingsResponse':
        """
        Patch Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.patch_speechandtextanalytics_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpeechTextAnalyticsSettingsRequest body: Speech And Text Analytics Settings (required)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method patch_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `patch_speechandtextanalytics_settings`")


        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PATCH',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_categories(self, body: 'CategoryRequest', **kwargs) -> 'StaCategory':
        """
        Create new Speech & Text Analytics category
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_categories(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CategoryRequest body: The category to create (required)
        :return: StaCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_categories" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_categories`")


        resource_path = '/api/v2/speechandtextanalytics/categories'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='StaCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_dictionaryfeedback(self, body: 'DictionaryFeedback', **kwargs) -> 'DictionaryFeedback':
        """
        Create a Speech & Text Analytics DictionaryFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_dictionaryfeedback(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param DictionaryFeedback body: The DictionaryFeedback to create (required)
        :return: DictionaryFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_dictionaryfeedback" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_dictionaryfeedback`")


        resource_path = '/api/v2/speechandtextanalytics/dictionaryfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DictionaryFeedback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs(self, body: 'ProgramRequest', **kwargs) -> 'Program':
        """
        Create new Speech & Text Analytics program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProgramRequest body: The program to create (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs`")


        resource_path = '/api/v2/speechandtextanalytics/programs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs_general_jobs(self, body: 'GeneralProgramJobRequest', **kwargs) -> 'GeneralProgramJob':
        """
        Create new Speech & Text Analytics general program job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs_general_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param GeneralProgramJobRequest body: The general programs job to create (required)
        :return: GeneralProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs_general_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs_general_jobs`")


        resource_path = '/api/v2/speechandtextanalytics/programs/general/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='GeneralProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_programs_publishjobs(self, body: 'ProgramJobRequest', **kwargs) -> 'ProgramJob':
        """
        Create new Speech & Text Analytics publish programs job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_programs_publishjobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ProgramJobRequest body: The publish programs job to create (required)
        :return: ProgramJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_programs_publishjobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_programs_publishjobs`")


        resource_path = '/api/v2/speechandtextanalytics/programs/publishjobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_reprocessing_jobs(self, body: 'CreateReprocessJobRequest', **kwargs) -> 'ReprocessJobResponse':
        """
        Create a Speech & Text Analytics reprocess job.
        
	    post_speechandtextanalytics_reprocessing_jobs is a preview method and is subject to both breaking and non-breaking changes at any time without notice

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_reprocessing_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param CreateReprocessJobRequest body: The ReprocessJob to create (required)
        :return: ReprocessJobResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_reprocessing_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_reprocessing_jobs`")


        resource_path = '/api/v2/speechandtextanalytics/reprocessing/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ReprocessJobResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_sentimentfeedback(self, body: 'SentimentFeedback', **kwargs) -> 'SentimentFeedback':
        """
        Create a Speech & Text Analytics SentimentFeedback
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_sentimentfeedback(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SentimentFeedback body: The SentimentFeedback to create (required)
        :return: SentimentFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_sentimentfeedback" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_sentimentfeedback`")


        resource_path = '/api/v2/speechandtextanalytics/sentimentfeedback'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SentimentFeedback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_topics(self, body: 'TopicRequest', **kwargs) -> 'Topic':
        """
        Create new Speech & Text Analytics topic
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_topics(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TopicRequest body: The topic to create (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_topics" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_topics`")


        resource_path = '/api/v2/speechandtextanalytics/topics'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_topics_publishjobs(self, body: 'TopicJobRequest', **kwargs) -> 'TopicJob':
        """
        Create new Speech & Text Analytics publish topics job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_topics_publishjobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TopicJobRequest body: The publish topics job to create (required)
        :return: TopicJob
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_topics_publishjobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_topics_publishjobs`")


        resource_path = '/api/v2/speechandtextanalytics/topics/publishjobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TopicJob',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_topics_testphrase_jobs(self, body: 'TestTopicPhraseJobRequest', **kwargs) -> 'TestTopicPhraseJobs':
        """
        Create new Speech & Text Analytics publish topics job
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_topics_testphrase_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TestTopicPhraseJobRequest body: The publish test topic phrase job to create (required)
        :return: TestTopicPhraseJobs
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_topics_testphrase_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_topics_testphrase_jobs`")


        resource_path = '/api/v2/speechandtextanalytics/topics/testphrase/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TestTopicPhraseJobs',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_speechandtextanalytics_transcripts_search(self, body: 'TranscriptSearchRequest', **kwargs) -> 'JsonSearchResponse':
        """
        Search resources.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_speechandtextanalytics_transcripts_search(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TranscriptSearchRequest body: Search request options (required)
        :return: JsonSearchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_speechandtextanalytics_transcripts_search" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_speechandtextanalytics_transcripts_search`")


        resource_path = '/api/v2/speechandtextanalytics/transcripts/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='JsonSearchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_category(self, category_id: str, body: 'CategoryRequest', **kwargs) -> 'StaCategory':
        """
        Update a Speech & Text Analytics category by ID
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_category(category_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str category_id: The id of the category (required)
        :param CategoryRequest body: The updated category (required)
        :return: StaCategory
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['category_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_category" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'category_id' is set
        if ('category_id' not in params) or (params['category_id'] is None):
            raise ValueError("Missing the required parameter `category_id` when calling `put_speechandtextanalytics_category`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_category`")


        resource_path = '/api/v2/speechandtextanalytics/categories/{categoryId}'.replace('{format}', 'json')
        path_params = {}
        if 'category_id' in params:
            path_params['categoryId'] = params['category_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='StaCategory',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(self, dictionary_feedback_id: str, **kwargs) -> 'DictionaryFeedback':
        """
        Update existing Speech & Text Analytics dictionary feedback by id
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id(dictionary_feedback_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str dictionary_feedback_id: The Id of the Dictionary Feedback (required)
        :param DictionaryFeedback body: 
        :return: DictionaryFeedback
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['dictionary_feedback_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'dictionary_feedback_id' is set
        if ('dictionary_feedback_id' not in params) or (params['dictionary_feedback_id'] is None):
            raise ValueError("Missing the required parameter `dictionary_feedback_id` when calling `put_speechandtextanalytics_dictionaryfeedback_dictionary_feedback_id`")


        resource_path = '/api/v2/speechandtextanalytics/dictionaryfeedback/{dictionaryFeedbackId}'.replace('{format}', 'json')
        path_params = {}
        if 'dictionary_feedback_id' in params:
            path_params['dictionaryFeedbackId'] = params['dictionary_feedback_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='DictionaryFeedback',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program(self, program_id: str, body: 'ProgramRequest', **kwargs) -> 'Program':
        """
        Update existing Speech & Text Analytics program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param ProgramRequest body: The program to update (required)
        :return: Program
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Program',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program_mappings(self, program_id: str, body: 'ProgramMappingsRequest', **kwargs) -> 'ProgramMappings':
        """
        Set Speech & Text Analytics program mappings to queues and flows
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program_mappings(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param ProgramMappingsRequest body: The program to set mappings for (required)
        :return: ProgramMappings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program_mappings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program_mappings`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program_mappings`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/mappings'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramMappings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program_settings_insights(self, program_id: str, body: 'InsightsSettingsRequest', **kwargs) -> 'ProgramInsightsSettings':
        """
        Update AI Insights settings of a program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program_settings_insights(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param InsightsSettingsRequest body: Program AI Insights setting (required)
        :return: ProgramInsightsSettings
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program_settings_insights" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program_settings_insights`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program_settings_insights`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/settings/insights'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramInsightsSettings',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_program_transcriptionengines(self, program_id: str, body: 'TranscriptionEnginesRequest', **kwargs) -> 'ProgramTranscriptionEngines':
        """
        Update transcription engine settings of a program
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_program_transcriptionengines(program_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str program_id: The id of the program (required)
        :param TranscriptionEnginesRequest body: Program transcription engine setting (required)
        :return: ProgramTranscriptionEngines
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['program_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_program_transcriptionengines" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'program_id' is set
        if ('program_id' not in params) or (params['program_id'] is None):
            raise ValueError("Missing the required parameter `program_id` when calling `put_speechandtextanalytics_program_transcriptionengines`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_program_transcriptionengines`")


        resource_path = '/api/v2/speechandtextanalytics/programs/{programId}/transcriptionengines'.replace('{format}', 'json')
        path_params = {}
        if 'program_id' in params:
            path_params['programId'] = params['program_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ProgramTranscriptionEngines',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_settings(self, body: 'SpeechTextAnalyticsSettingsRequest', **kwargs) -> 'SpeechTextAnalyticsSettingsResponse':
        """
        Update Speech And Text Analytics Settings
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_settings(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param SpeechTextAnalyticsSettingsRequest body: Speech And Text Analytics Settings (required)
        :return: SpeechTextAnalyticsSettingsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_settings" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_settings`")


        resource_path = '/api/v2/speechandtextanalytics/settings'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='SpeechTextAnalyticsSettingsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def put_speechandtextanalytics_topic(self, topic_id: str, body: 'TopicRequest', **kwargs) -> 'Topic':
        """
        Update existing Speech & Text Analytics topic
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.put_speechandtextanalytics_topic(topic_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str topic_id: The id of the topic (required)
        :param TopicRequest body: The topic to update (required)
        :return: Topic
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['topic_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method put_speechandtextanalytics_topic" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'topic_id' is set
        if ('topic_id' not in params) or (params['topic_id'] is None):
            raise ValueError("Missing the required parameter `topic_id` when calling `put_speechandtextanalytics_topic`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `put_speechandtextanalytics_topic`")


        resource_path = '/api/v2/speechandtextanalytics/topics/{topicId}'.replace('{format}', 'json')
        path_params = {}
        if 'topic_id' in params:
            path_params['topicId'] = params['topic_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'PUT',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='Topic',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
