# coding: utf-8

"""
TextbotsApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import BotSearchResponseEntityListing
from ..models import ErrorBody
from ..models import PostTextRequest
from ..models import PostTextResponse
from ..models import TextBotFlowLaunchRequest
from ..models import TextBotFlowLaunchResponse
from ..models import TextBotFlowTurnRequest
from ..models import TextBotFlowTurnResponse

class TextbotsApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_textbots_bots_search(self, **kwargs) -> 'BotSearchResponseEntityListing':
        """
        Find bots using the currently configured friendly name or ID.
        The name does allow case-insensitive partial string matches or by IDs (up to 50), but not both at the same time. Optionally you can limit the scope of the search by providing one or more bot types.  You can specify the maximum results to return, up to a limit of 100

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_textbots_bots_search(callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param list[str] bot_type: Bot types
        :param str bot_name: Bot name
        :param list[str] bot_id: Bot IDs. Maximum of 50
        :param bool virtual_agent_enabled: Include or exclude virtual agent flows, only applies to GenesysBotFlows or GenesysDigitalBotFlows
        :param int page_size: The maximum results to return. Maximum of 100
        :return: BotSearchResponseEntityListing
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['bot_type', 'bot_name', 'bot_id', 'virtual_agent_enabled', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_textbots_bots_search" % key
                )
            params[key] = val
        del params['kwargs']



        resource_path = '/api/v2/textbots/bots/search'.replace('{format}', 'json')
        path_params = {}

        query_params = {}
        if 'bot_type' in params:
            query_params['botType'] = params['bot_type']
        if 'bot_name' in params:
            query_params['botName'] = params['bot_name']
        if 'bot_id' in params:
            query_params['botId'] = params['bot_id']
        if 'virtual_agent_enabled' in params:
            query_params['virtualAgentEnabled'] = params['virtual_agent_enabled']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='BotSearchResponseEntityListing',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_textbots_botflows_session_turns(self, session_id: str, turn_request: 'TextBotFlowTurnRequest', **kwargs) -> 'TextBotFlowTurnResponse':
        """
        Issue a bot flow turn event
        Send a turn event to an executing bot flow and produce the next action to take.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_textbots_botflows_session_turns(session_id, turn_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str session_id: The bot flow session ID, typically obtained from 'POST /api/v2/textbots/botflows/sessions' (required)
        :param TextBotFlowTurnRequest turn_request:  (required)
        :return: TextBotFlowTurnResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['session_id', 'turn_request']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_textbots_botflows_session_turns" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'session_id' is set
        if ('session_id' not in params) or (params['session_id'] is None):
            raise ValueError("Missing the required parameter `session_id` when calling `post_textbots_botflows_session_turns`")
        # verify the required parameter 'turn_request' is set
        if ('turn_request' not in params) or (params['turn_request'] is None):
            raise ValueError("Missing the required parameter `turn_request` when calling `post_textbots_botflows_session_turns`")


        resource_path = '/api/v2/textbots/botflows/sessions/{sessionId}/turns'.replace('{format}', 'json')
        path_params = {}
        if 'session_id' in params:
            path_params['sessionId'] = params['session_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'turn_request' in params:
            body_params = params['turn_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TextBotFlowTurnResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_textbots_botflows_sessions(self, launch_request: 'TextBotFlowLaunchRequest', **kwargs) -> 'TextBotFlowLaunchResponse':
        """
        Create an execution instance of a bot flow definition.
        The launch is asynchronous; use the returned instance ID to post turns to it using 'POST /api/v2/textbots/botflows/sessions/{sessionId}/turns'.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_textbots_botflows_sessions(launch_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param TextBotFlowLaunchRequest launch_request:  (required)
        :return: TextBotFlowLaunchResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['launch_request']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_textbots_botflows_sessions" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'launch_request' is set
        if ('launch_request' not in params) or (params['launch_request'] is None):
            raise ValueError("Missing the required parameter `launch_request` when calling `post_textbots_botflows_sessions`")


        resource_path = '/api/v2/textbots/botflows/sessions'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'launch_request' in params:
            body_params = params['launch_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='TextBotFlowLaunchResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_textbots_bots_execute(self, post_text_request: 'PostTextRequest', **kwargs) -> 'PostTextResponse':
        """
        Send an intent to a bot to start a dialog/interact with it via text
        This will either start a bot with the given id or relay a communication to an existing bot session.

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_textbots_bots_execute(post_text_request, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param PostTextRequest post_text_request:  (required)
        :return: PostTextResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['post_text_request']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_textbots_bots_execute" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'post_text_request' is set
        if ('post_text_request' not in params) or (params['post_text_request'] is None):
            raise ValueError("Missing the required parameter `post_text_request` when calling `post_textbots_bots_execute`")


        resource_path = '/api/v2/textbots/bots/execute'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'post_text_request' in params:
            body_params = params['post_text_request']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='PostTextResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
