# coding: utf-8

"""
UsageApi.py
Copyright 2016 SmartBear Software

   Licensed under the Apache License, Version 2.0 (the "License");
   you may not use this file except in compliance with the License.
   You may obtain a copy of the License at

       http://www.apache.org/licenses/LICENSE-2.0

   Unless required by applicable law or agreed to in writing, software
   distributed under the License is distributed on an "AS IS" BASIS,
   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
   See the License for the specific language governing permissions and
   limitations under the License.
"""

from __future__ import absolute_import

import sys
import os
import re

from datetime import datetime
from datetime import date

from ..configuration import Configuration
from ..api_client import ApiClient
from ..utils import deprecated

from typing import List
from typing import Dict
from typing import Any

from ..models import Empty
from ..models import ApiUsageClientQuery
from ..models import ApiUsageOrganizationQuery
from ..models import ApiUsageQueryResult
from ..models import ApiUsageSimpleSearch
from ..models import ClientPublicApiUsageQueryRequest
from ..models import ClientPublicApiUsageResultsResponse
from ..models import ClientUsageQueryResponse
from ..models import ErrorBody
from ..models import OrganizationPublicApiUsageQueryRequest
from ..models import OrganizationPublicApiUsageResultsResponse
from ..models import OrganizationUsageQueryResponse
from ..models import UsageExecutionResult

class UsageApi(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    Ref: https://github.com/swagger-api/swagger-codegen
    """

    def __init__(self, api_client=None):
        config = Configuration()
        if api_client:
            self.api_client = api_client
        else:
            if not config.api_client:
                config.api_client = ApiClient()
            self.api_client = config.api_client

    def get_oauth_client_usage_query_result(self, execution_id: str, client_id: str, **kwargs) -> 'ApiUsageQueryResult':
        """
        Get the results of a usage query
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_client_usage_query_result(execution_id, client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str execution_id: ID of the query execution (required)
        :param str client_id: Client ID (required)
        :return: ApiUsageQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'client_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_client_usage_query_result" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_oauth_client_usage_query_result`")
        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_client_usage_query_result`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/query/results/{executionId}'.replace('{format}', 'json')
        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ApiUsageQueryResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_oauth_client_usage_summary(self, client_id: str, **kwargs) -> 'UsageExecutionResult':
        """
        Get a summary of OAuth client API usage
        After calling this method, you will then need to poll for the query results based on the returned execution Id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_oauth_client_usage_summary(client_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :param str days: Previous number of days to query
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'days']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_oauth_client_usage_summary" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_oauth_client_usage_summary`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/summary'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}
        if 'days' in params:
            query_params['days'] = params['days']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_usage_aggregates_query_job(self, job_id: str, **kwargs) -> 'OrganizationPublicApiUsageResultsResponse':
        """
        Get the status and results of the usage query
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_usage_aggregates_query_job(job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str job_id: jobId (required)
        :param int page_size: Page size of the results. Max is 1000.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :return: OrganizationPublicApiUsageResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['job_id', 'page_size', 'after']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage_aggregates_query_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_usage_aggregates_query_job`")


        resource_path = '/api/v2/usage/aggregates/query/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'after' in params:
            query_params['after'] = params['after']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationPublicApiUsageResultsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_usage_client_client_id_aggregates_query_job(self, client_id: str, job_id: str, **kwargs) -> 'ClientPublicApiUsageResultsResponse':
        """
        Get the status and results of the usage query
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_usage_client_client_id_aggregates_query_job(client_id, job_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: clientId (required)
        :param str job_id: jobId (required)
        :param int page_size: Page size of the results. Max is 1000.
        :param str after: The cursor that points to the end of the set of entities that has been returned.
        :return: ClientPublicApiUsageResultsResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'job_id', 'page_size', 'after']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage_client_client_id_aggregates_query_job" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `get_usage_client_client_id_aggregates_query_job`")
        # verify the required parameter 'job_id' is set
        if ('job_id' not in params) or (params['job_id'] is None):
            raise ValueError("Missing the required parameter `job_id` when calling `get_usage_client_client_id_aggregates_query_job`")


        resource_path = '/api/v2/usage/client/{clientId}/aggregates/query/jobs/{jobId}'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']
        if 'job_id' in params:
            path_params['jobId'] = params['job_id']

        query_params = {}
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']
        if 'after' in params:
            query_params['after'] = params['after']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClientPublicApiUsageResultsResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_usage_query_execution_id_results(self, execution_id: str, **kwargs) -> 'ApiUsageQueryResult':
        """
        Get the results of a usage query
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_usage_query_execution_id_results(execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str execution_id: ID of the query execution (required)
        :return: ApiUsageQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage_query_execution_id_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_usage_query_execution_id_results`")


        resource_path = '/api/v2/usage/query/{executionId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ApiUsageQueryResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def get_usage_simplesearch_execution_id_results(self, execution_id: str, **kwargs) -> 'ApiUsageQueryResult':
        """
        Get the results of a usage search. Number of records to be returned is limited to 20,000 results.
        

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.get_usage_simplesearch_execution_id_results(execution_id, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str execution_id: ID of the search execution (required)
        :param str after: The cursor that points to the end of the set of entities that has been returned
        :param int page_size: The max number of entities to be returned per request. Maximum page size of 1000
        :return: ApiUsageQueryResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['execution_id', 'after', 'page_size']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method get_usage_simplesearch_execution_id_results" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'execution_id' is set
        if ('execution_id' not in params) or (params['execution_id'] is None):
            raise ValueError("Missing the required parameter `execution_id` when calling `get_usage_simplesearch_execution_id_results`")


        resource_path = '/api/v2/usage/simplesearch/{executionId}/results'.replace('{format}', 'json')
        path_params = {}
        if 'execution_id' in params:
            path_params['executionId'] = params['execution_id']

        query_params = {}
        if 'after' in params:
            query_params['after'] = params['after']
        if 'page_size' in params:
            query_params['pageSize'] = params['page_size']

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'GET',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ApiUsageQueryResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_oauth_client_usage_query(self, client_id: str, body: 'ApiUsageClientQuery', **kwargs) -> 'UsageExecutionResult':
        """
        Query for OAuth client API usage
        After calling this method, you will then need to poll for the query results based on the returned execution Id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_oauth_client_usage_query(client_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: Client ID (required)
        :param ApiUsageClientQuery body: Query (required)
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_oauth_client_usage_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `post_oauth_client_usage_query`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_oauth_client_usage_query`")


        resource_path = '/api/v2/oauth/clients/{clientId}/usage/query'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_usage_aggregates_query_jobs(self, body: 'OrganizationPublicApiUsageQueryRequest', **kwargs) -> 'OrganizationUsageQueryResponse':
        """
        Query your organization's public api usage.
        After calling this method, you will need to save the queryExecutionId from the response and use it in a call to the results endpoint to get the results

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_usage_aggregates_query_jobs(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param OrganizationPublicApiUsageQueryRequest body: Query (required)
        :return: OrganizationUsageQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_usage_aggregates_query_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_usage_aggregates_query_jobs`")


        resource_path = '/api/v2/usage/aggregates/query/jobs'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='OrganizationUsageQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_usage_client_client_id_aggregates_query_jobs(self, client_id: str, body: 'ClientPublicApiUsageQueryRequest', **kwargs) -> 'ClientUsageQueryResponse':
        """
        Query your client's public api usage.
        After calling this method, you will need to save the queryExecutionId from the response and use it in a call to the results endpoint to get the results

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_usage_client_client_id_aggregates_query_jobs(client_id, body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param str client_id: clientId (required)
        :param ClientPublicApiUsageQueryRequest body: Query (required)
        :return: ClientUsageQueryResponse
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['client_id', 'body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_usage_client_client_id_aggregates_query_jobs" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'client_id' is set
        if ('client_id' not in params) or (params['client_id'] is None):
            raise ValueError("Missing the required parameter `client_id` when calling `post_usage_client_client_id_aggregates_query_jobs`")
        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_usage_client_client_id_aggregates_query_jobs`")


        resource_path = '/api/v2/usage/client/{clientId}/aggregates/query/jobs'.replace('{format}', 'json')
        path_params = {}
        if 'client_id' in params:
            path_params['clientId'] = params['client_id']

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='ClientUsageQueryResponse',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_usage_query(self, body: 'ApiUsageOrganizationQuery', **kwargs) -> 'UsageExecutionResult':
        """
        Query organization API Usage - 
        After calling this method, you will then need to poll for the query results based on the returned execution Id

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_usage_query(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiUsageOrganizationQuery body: Query (required)
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_usage_query" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_usage_query`")


        resource_path = '/api/v2/usage/query'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response

    def post_usage_simplesearch(self, body: 'ApiUsageSimpleSearch', **kwargs) -> 'UsageExecutionResult':
        """
        Search organization API Usage
        After calling this method, you will then need to poll for the query results based on the returned execution Id. The number of records is limited to 20,000 results

        This method makes a synchronous HTTP request by default. To make an
        asynchronous HTTP request, please define a `callback` function
        to be invoked when receiving the response.
        >>> def callback_function(response):
        >>>     pprint(response)
        >>>
        >>> thread = api.post_usage_simplesearch(body, callback=callback_function)

        :param callback function: The callback function
            for asynchronous request. (optional)
        :param ApiUsageSimpleSearch body: SimpleSearch (required)
        :return: UsageExecutionResult
                 If the method is called asynchronously,
                 returns the request thread.
        """

        all_params = ['body']
        all_params.append('callback')

        params = locals()
        for key, val in params['kwargs'].items():
            if key not in all_params:
                raise TypeError(
                    "Got an unexpected keyword argument '%s'"
                    " to method post_usage_simplesearch" % key
                )
            params[key] = val
        del params['kwargs']

        # verify the required parameter 'body' is set
        if ('body' not in params) or (params['body'] is None):
            raise ValueError("Missing the required parameter `body` when calling `post_usage_simplesearch`")


        resource_path = '/api/v2/usage/simplesearch'.replace('{format}', 'json')
        path_params = {}

        query_params = {}

        header_params = {}

        form_params = []
        local_var_files = {}

        body_params = None
        if 'body' in params:
            body_params = params['body']

        # HTTP header `Accept`
        header_params['Accept'] = self.api_client.\
            select_header_accept(['application/json'])
        if not header_params['Accept']:
            del header_params['Accept']

        # HTTP header `Content-Type`
        header_params['Content-Type'] = self.api_client.\
            select_header_content_type(['application/json'])

        # Authentication setting
        auth_settings = ['PureCloud OAuth']

        response = self.api_client.call_api(resource_path, 'POST',
                                            path_params,
                                            query_params,
                                            header_params,
                                            body=body_params,
                                            post_params=form_params,
                                            files=local_var_files,
                                            response_type='UsageExecutionResult',
                                            auth_settings=auth_settings,
                                            callback=params.get('callback'))
        return response
