# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AcknowledgeScreenRecordingRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AcknowledgeScreenRecordingRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'participant_jid': 'str',
            'room_id': 'str',
            'conversation_id': 'str'
        }

        self.attribute_map = {
            'participant_jid': 'participantJid',
            'room_id': 'roomId',
            'conversation_id': 'conversationId'
        }

        self._participant_jid = None
        self._room_id = None
        self._conversation_id = None

    @property
    def participant_jid(self) -> str:
        """
        Gets the participant_jid of this AcknowledgeScreenRecordingRequest.


        :return: The participant_jid of this AcknowledgeScreenRecordingRequest.
        :rtype: str
        """
        return self._participant_jid

    @participant_jid.setter
    def participant_jid(self, participant_jid: str) -> None:
        """
        Sets the participant_jid of this AcknowledgeScreenRecordingRequest.


        :param participant_jid: The participant_jid of this AcknowledgeScreenRecordingRequest.
        :type: str
        """
        

        self._participant_jid = participant_jid

    @property
    def room_id(self) -> str:
        """
        Gets the room_id of this AcknowledgeScreenRecordingRequest.


        :return: The room_id of this AcknowledgeScreenRecordingRequest.
        :rtype: str
        """
        return self._room_id

    @room_id.setter
    def room_id(self, room_id: str) -> None:
        """
        Sets the room_id of this AcknowledgeScreenRecordingRequest.


        :param room_id: The room_id of this AcknowledgeScreenRecordingRequest.
        :type: str
        """
        

        self._room_id = room_id

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this AcknowledgeScreenRecordingRequest.


        :return: The conversation_id of this AcknowledgeScreenRecordingRequest.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this AcknowledgeScreenRecordingRequest.


        :param conversation_id: The conversation_id of this AcknowledgeScreenRecordingRequest.
        :type: str
        """
        

        self._conversation_id = conversation_id

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

