# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ActionCertificate(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActionCertificate - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'signing_authority': 'str',
            'certificate': 'str',
            'status': 'str',
            'type': 'str'
        }

        self.attribute_map = {
            'signing_authority': 'signingAuthority',
            'certificate': 'certificate',
            'status': 'status',
            'type': 'type'
        }

        self._signing_authority = None
        self._certificate = None
        self._status = None
        self._type = None

    @property
    def signing_authority(self) -> str:
        """
        Gets the signing_authority of this ActionCertificate.
        The Signing Authority for the certificate

        :return: The signing_authority of this ActionCertificate.
        :rtype: str
        """
        return self._signing_authority

    @signing_authority.setter
    def signing_authority(self, signing_authority: str) -> None:
        """
        Sets the signing_authority of this ActionCertificate.
        The Signing Authority for the certificate

        :param signing_authority: The signing_authority of this ActionCertificate.
        :type: str
        """
        if isinstance(signing_authority, int):
            signing_authority = str(signing_authority)
        allowed_values = ["DigiCert", "Genesys"]
        if signing_authority.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for signing_authority -> " + signing_authority)
            self._signing_authority = "outdated_sdk_version"
        else:
            self._signing_authority = signing_authority

    @property
    def certificate(self) -> str:
        """
        Gets the certificate of this ActionCertificate.
        The certificate string

        :return: The certificate of this ActionCertificate.
        :rtype: str
        """
        return self._certificate

    @certificate.setter
    def certificate(self, certificate: str) -> None:
        """
        Sets the certificate of this ActionCertificate.
        The certificate string

        :param certificate: The certificate of this ActionCertificate.
        :type: str
        """
        

        self._certificate = certificate

    @property
    def status(self) -> str:
        """
        Gets the status of this ActionCertificate.
        The certificate status

        :return: The status of this ActionCertificate.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this ActionCertificate.
        The certificate status

        :param status: The status of this ActionCertificate.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Current", "Upcoming"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def type(self) -> str:
        """
        Gets the type of this ActionCertificate.
        The certificate type

        :return: The type of this ActionCertificate.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ActionCertificate.
        The certificate type

        :param type: The type of this ActionCertificate.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Client"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

