# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class ActionEventRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActionEventRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'session_id': 'str',
            'action_id': 'str',
            'action_state': 'str',
            'error_code': 'str',
            'error_message': 'str',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'session_id': 'sessionId',
            'action_id': 'actionId',
            'action_state': 'actionState',
            'error_code': 'errorCode',
            'error_message': 'errorMessage',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._session_id = None
        self._action_id = None
        self._action_state = None
        self._error_code = None
        self._error_message = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ActionEventRequest.
        The globally unique identifier for the object.

        :return: The id of this ActionEventRequest.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ActionEventRequest.
        The globally unique identifier for the object.

        :param id: The id of this ActionEventRequest.
        :type: str
        """
        

        self._id = id

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this ActionEventRequest.
        UUID of the customer session for this action.

        :return: The session_id of this ActionEventRequest.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this ActionEventRequest.
        UUID of the customer session for this action.

        :param session_id: The session_id of this ActionEventRequest.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def action_id(self) -> str:
        """
        Gets the action_id of this ActionEventRequest.
        UUID for the action, as returned by the Ping endpoint when the action was qualified.

        :return: The action_id of this ActionEventRequest.
        :rtype: str
        """
        return self._action_id

    @action_id.setter
    def action_id(self, action_id: str) -> None:
        """
        Sets the action_id of this ActionEventRequest.
        UUID for the action, as returned by the Ping endpoint when the action was qualified.

        :param action_id: The action_id of this ActionEventRequest.
        :type: str
        """
        

        self._action_id = action_id

    @property
    def action_state(self) -> str:
        """
        Gets the action_state of this ActionEventRequest.
        State the action is transitioning to.

        :return: The action_state of this ActionEventRequest.
        :rtype: str
        """
        return self._action_state

    @action_state.setter
    def action_state(self, action_state: str) -> None:
        """
        Sets the action_state of this ActionEventRequest.
        State the action is transitioning to.

        :param action_state: The action_state of this ActionEventRequest.
        :type: str
        """
        if isinstance(action_state, int):
            action_state = str(action_state)
        allowed_values = ["accepted", "rejected", "timedout", "errored", "ignored", "qualified", "offered", "started", "engaged", "qualifiedOutsideSchedule", "offeredOutsideSchedule", "abandoned", "completed", "frequencyCapReached"]
        if action_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for action_state -> " + action_state)
            self._action_state = "outdated_sdk_version"
        else:
            self._action_state = action_state

    @property
    def error_code(self) -> str:
        """
        Gets the error_code of this ActionEventRequest.
        Client defined error code (when state transitions to errored)

        :return: The error_code of this ActionEventRequest.
        :rtype: str
        """
        return self._error_code

    @error_code.setter
    def error_code(self, error_code: str) -> None:
        """
        Sets the error_code of this ActionEventRequest.
        Client defined error code (when state transitions to errored)

        :param error_code: The error_code of this ActionEventRequest.
        :type: str
        """
        

        self._error_code = error_code

    @property
    def error_message(self) -> str:
        """
        Gets the error_message of this ActionEventRequest.
        Message of the error returned when the action fails (when state transitions to errored)

        :return: The error_message of this ActionEventRequest.
        :rtype: str
        """
        return self._error_message

    @error_message.setter
    def error_message(self, error_message: str) -> None:
        """
        Sets the error_message of this ActionEventRequest.
        Message of the error returned when the action fails (when state transitions to errored)

        :param error_message: The error_message of this ActionEventRequest.
        :type: str
        """
        

        self._error_message = error_message

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ActionEventRequest.
        The URI for this object

        :return: The self_uri of this ActionEventRequest.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ActionEventRequest.
        The URI for this object

        :param self_uri: The self_uri of this ActionEventRequest.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

