# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmVersionedEntityMetadata

class ActivityCode(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActivityCode - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'self_uri': 'str',
            'name': 'str',
            'is_active': 'bool',
            'is_default': 'bool',
            'category': 'str',
            'length_in_minutes': 'int',
            'counts_as_paid_time': 'bool',
            'counts_as_work_time': 'bool',
            'agent_time_off_selectable': 'bool',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'id': 'id',
            'self_uri': 'selfUri',
            'name': 'name',
            'is_active': 'isActive',
            'is_default': 'isDefault',
            'category': 'category',
            'length_in_minutes': 'lengthInMinutes',
            'counts_as_paid_time': 'countsAsPaidTime',
            'counts_as_work_time': 'countsAsWorkTime',
            'agent_time_off_selectable': 'agentTimeOffSelectable',
            'metadata': 'metadata'
        }

        self._id = None
        self._self_uri = None
        self._name = None
        self._is_active = None
        self._is_default = None
        self._category = None
        self._length_in_minutes = None
        self._counts_as_paid_time = None
        self._counts_as_work_time = None
        self._agent_time_off_selectable = None
        self._metadata = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ActivityCode.
        The globally unique identifier for the object.

        :return: The id of this ActivityCode.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ActivityCode.
        The globally unique identifier for the object.

        :param id: The id of this ActivityCode.
        :type: str
        """
        

        self._id = id

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ActivityCode.
        The URI for this object

        :return: The self_uri of this ActivityCode.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ActivityCode.
        The URI for this object

        :param self_uri: The self_uri of this ActivityCode.
        :type: str
        """
        

        self._self_uri = self_uri

    @property
    def name(self) -> str:
        """
        Gets the name of this ActivityCode.
        The name of the activity code. Default activity codes will be created with an empty name

        :return: The name of this ActivityCode.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ActivityCode.
        The name of the activity code. Default activity codes will be created with an empty name

        :param name: The name of this ActivityCode.
        :type: str
        """
        

        self._name = name

    @property
    def is_active(self) -> bool:
        """
        Gets the is_active of this ActivityCode.
        Whether this activity code is active or has been deleted

        :return: The is_active of this ActivityCode.
        :rtype: bool
        """
        return self._is_active

    @is_active.setter
    def is_active(self, is_active: bool) -> None:
        """
        Sets the is_active of this ActivityCode.
        Whether this activity code is active or has been deleted

        :param is_active: The is_active of this ActivityCode.
        :type: bool
        """
        

        self._is_active = is_active

    @property
    def is_default(self) -> bool:
        """
        Gets the is_default of this ActivityCode.
        Whether this is a default activity code

        :return: The is_default of this ActivityCode.
        :rtype: bool
        """
        return self._is_default

    @is_default.setter
    def is_default(self, is_default: bool) -> None:
        """
        Sets the is_default of this ActivityCode.
        Whether this is a default activity code

        :param is_default: The is_default of this ActivityCode.
        :type: bool
        """
        

        self._is_default = is_default

    @property
    def category(self) -> str:
        """
        Gets the category of this ActivityCode.
        The activity code's category.

        :return: The category of this ActivityCode.
        :rtype: str
        """
        return self._category

    @category.setter
    def category(self, category: str) -> None:
        """
        Sets the category of this ActivityCode.
        The activity code's category.

        :param category: The category of this ActivityCode.
        :type: str
        """
        if isinstance(category, int):
            category = str(category)
        allowed_values = ["OnQueueWork", "Break", "Meal", "Meeting", "OffQueueWork", "TimeOff", "Training", "Unavailable"]
        if category.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for category -> " + category)
            self._category = "outdated_sdk_version"
        else:
            self._category = category

    @property
    def length_in_minutes(self) -> int:
        """
        Gets the length_in_minutes of this ActivityCode.
        The default length of the activity in minutes

        :return: The length_in_minutes of this ActivityCode.
        :rtype: int
        """
        return self._length_in_minutes

    @length_in_minutes.setter
    def length_in_minutes(self, length_in_minutes: int) -> None:
        """
        Sets the length_in_minutes of this ActivityCode.
        The default length of the activity in minutes

        :param length_in_minutes: The length_in_minutes of this ActivityCode.
        :type: int
        """
        

        self._length_in_minutes = length_in_minutes

    @property
    def counts_as_paid_time(self) -> bool:
        """
        Gets the counts_as_paid_time of this ActivityCode.
        Whether an agent is paid while performing this activity

        :return: The counts_as_paid_time of this ActivityCode.
        :rtype: bool
        """
        return self._counts_as_paid_time

    @counts_as_paid_time.setter
    def counts_as_paid_time(self, counts_as_paid_time: bool) -> None:
        """
        Sets the counts_as_paid_time of this ActivityCode.
        Whether an agent is paid while performing this activity

        :param counts_as_paid_time: The counts_as_paid_time of this ActivityCode.
        :type: bool
        """
        

        self._counts_as_paid_time = counts_as_paid_time

    @property
    def counts_as_work_time(self) -> bool:
        """
        Gets the counts_as_work_time of this ActivityCode.
        Indicates whether or not the activity should be counted as contiguous work time for calculating daily constraints

        :return: The counts_as_work_time of this ActivityCode.
        :rtype: bool
        """
        return self._counts_as_work_time

    @counts_as_work_time.setter
    def counts_as_work_time(self, counts_as_work_time: bool) -> None:
        """
        Sets the counts_as_work_time of this ActivityCode.
        Indicates whether or not the activity should be counted as contiguous work time for calculating daily constraints

        :param counts_as_work_time: The counts_as_work_time of this ActivityCode.
        :type: bool
        """
        

        self._counts_as_work_time = counts_as_work_time

    @property
    def agent_time_off_selectable(self) -> bool:
        """
        Gets the agent_time_off_selectable of this ActivityCode.
        Whether an agent can select this activity code when creating or editing a time off request. Null if the activity's category is not time off.

        :return: The agent_time_off_selectable of this ActivityCode.
        :rtype: bool
        """
        return self._agent_time_off_selectable

    @agent_time_off_selectable.setter
    def agent_time_off_selectable(self, agent_time_off_selectable: bool) -> None:
        """
        Sets the agent_time_off_selectable of this ActivityCode.
        Whether an agent can select this activity code when creating or editing a time off request. Null if the activity's category is not time off.

        :param agent_time_off_selectable: The agent_time_off_selectable of this ActivityCode.
        :type: bool
        """
        

        self._agent_time_off_selectable = agent_time_off_selectable

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this ActivityCode.
        Version metadata for the associated management unit's list of activity codes

        :return: The metadata of this ActivityCode.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this ActivityCode.
        Version metadata for the associated management unit's list of activity codes

        :param metadata: The metadata of this ActivityCode.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

