# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import ActivityCodeReference
    from . import ManagementUnitReference
    from . import RecurrenceSettings
    from . import UserReference

class ActivityPlanListItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        ActivityPlanListItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'management_units': 'list[ManagementUnitReference]',
            'description': 'str',
            'activity_code': 'ActivityCodeReference',
            'type': 'str',
            'optimization_objective': 'str',
            'recurrence_settings': 'RecurrenceSettings',
            'state': 'str',
            'last_run_date': 'datetime',
            'last_run_by': 'UserReference',
            'created_date': 'datetime',
            'created_by': 'UserReference',
            'modified_date': 'datetime',
            'modified_by': 'UserReference',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'management_units': 'managementUnits',
            'description': 'description',
            'activity_code': 'activityCode',
            'type': 'type',
            'optimization_objective': 'optimizationObjective',
            'recurrence_settings': 'recurrenceSettings',
            'state': 'state',
            'last_run_date': 'lastRunDate',
            'last_run_by': 'lastRunBy',
            'created_date': 'createdDate',
            'created_by': 'createdBy',
            'modified_date': 'modifiedDate',
            'modified_by': 'modifiedBy',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._management_units = None
        self._description = None
        self._activity_code = None
        self._type = None
        self._optimization_objective = None
        self._recurrence_settings = None
        self._state = None
        self._last_run_date = None
        self._last_run_by = None
        self._created_date = None
        self._created_by = None
        self._modified_date = None
        self._modified_by = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this ActivityPlanListItem.
        The globally unique identifier for the object.

        :return: The id of this ActivityPlanListItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this ActivityPlanListItem.
        The globally unique identifier for the object.

        :param id: The id of this ActivityPlanListItem.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this ActivityPlanListItem.
        The name of the activity plan

        :return: The name of this ActivityPlanListItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this ActivityPlanListItem.
        The name of the activity plan

        :param name: The name of this ActivityPlanListItem.
        :type: str
        """
        

        self._name = name

    @property
    def management_units(self) -> List['ManagementUnitReference']:
        """
        Gets the management_units of this ActivityPlanListItem.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to all management units in the business unit

        :return: The management_units of this ActivityPlanListItem.
        :rtype: list[ManagementUnitReference]
        """
        return self._management_units

    @management_units.setter
    def management_units(self, management_units: List['ManagementUnitReference']) -> None:
        """
        Sets the management_units of this ActivityPlanListItem.
        The management units to which this activity plan applies. Empty list or null means this activity plan applies to all management units in the business unit

        :param management_units: The management_units of this ActivityPlanListItem.
        :type: list[ManagementUnitReference]
        """
        

        self._management_units = management_units

    @property
    def description(self) -> str:
        """
        Gets the description of this ActivityPlanListItem.
        The description of this activity plan

        :return: The description of this ActivityPlanListItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this ActivityPlanListItem.
        The description of this activity plan

        :param description: The description of this ActivityPlanListItem.
        :type: str
        """
        

        self._description = description

    @property
    def activity_code(self) -> 'ActivityCodeReference':
        """
        Gets the activity_code of this ActivityPlanListItem.
        The activity code to which this activity plan applies. Note: It is recommended to load and cache the entire list of activity codes rather than look up individual codes

        :return: The activity_code of this ActivityPlanListItem.
        :rtype: ActivityCodeReference
        """
        return self._activity_code

    @activity_code.setter
    def activity_code(self, activity_code: 'ActivityCodeReference') -> None:
        """
        Sets the activity_code of this ActivityPlanListItem.
        The activity code to which this activity plan applies. Note: It is recommended to load and cache the entire list of activity codes rather than look up individual codes

        :param activity_code: The activity_code of this ActivityPlanListItem.
        :type: ActivityCodeReference
        """
        

        self._activity_code = activity_code

    @property
    def type(self) -> str:
        """
        Gets the type of this ActivityPlanListItem.
        The type of the activity plan

        :return: The type of this ActivityPlanListItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this ActivityPlanListItem.
        The type of the activity plan

        :param type: The type of this ActivityPlanListItem.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["Individual", "Group"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def optimization_objective(self) -> str:
        """
        Gets the optimization_objective of this ActivityPlanListItem.
        The optimization objective of this activity plan

        :return: The optimization_objective of this ActivityPlanListItem.
        :rtype: str
        """
        return self._optimization_objective

    @optimization_objective.setter
    def optimization_objective(self, optimization_objective: str) -> None:
        """
        Sets the optimization_objective of this ActivityPlanListItem.
        The optimization objective of this activity plan

        :param optimization_objective: The optimization_objective of this ActivityPlanListItem.
        :type: str
        """
        if isinstance(optimization_objective, int):
            optimization_objective = str(optimization_objective)
        allowed_values = ["FavorServiceGoals", "FavorSchedulingAll"]
        if optimization_objective.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for optimization_objective -> " + optimization_objective)
            self._optimization_objective = "outdated_sdk_version"
        else:
            self._optimization_objective = optimization_objective

    @property
    def recurrence_settings(self) -> 'RecurrenceSettings':
        """
        Gets the recurrence_settings of this ActivityPlanListItem.
        Recurrence settings for this activity plan

        :return: The recurrence_settings of this ActivityPlanListItem.
        :rtype: RecurrenceSettings
        """
        return self._recurrence_settings

    @recurrence_settings.setter
    def recurrence_settings(self, recurrence_settings: 'RecurrenceSettings') -> None:
        """
        Sets the recurrence_settings of this ActivityPlanListItem.
        Recurrence settings for this activity plan

        :param recurrence_settings: The recurrence_settings of this ActivityPlanListItem.
        :type: RecurrenceSettings
        """
        

        self._recurrence_settings = recurrence_settings

    @property
    def state(self) -> str:
        """
        Gets the state of this ActivityPlanListItem.
        The state of this activity plan

        :return: The state of this ActivityPlanListItem.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this ActivityPlanListItem.
        The state of this activity plan

        :param state: The state of this ActivityPlanListItem.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Active", "Inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def last_run_date(self) -> datetime:
        """
        Gets the last_run_date of this ActivityPlanListItem.
        The date the activity plan was last run, in ISO-8601 format

        :return: The last_run_date of this ActivityPlanListItem.
        :rtype: datetime
        """
        return self._last_run_date

    @last_run_date.setter
    def last_run_date(self, last_run_date: datetime) -> None:
        """
        Sets the last_run_date of this ActivityPlanListItem.
        The date the activity plan was last run, in ISO-8601 format

        :param last_run_date: The last_run_date of this ActivityPlanListItem.
        :type: datetime
        """
        

        self._last_run_date = last_run_date

    @property
    def last_run_by(self) -> 'UserReference':
        """
        Gets the last_run_by of this ActivityPlanListItem.
        The last user to run this activity plan

        :return: The last_run_by of this ActivityPlanListItem.
        :rtype: UserReference
        """
        return self._last_run_by

    @last_run_by.setter
    def last_run_by(self, last_run_by: 'UserReference') -> None:
        """
        Sets the last_run_by of this ActivityPlanListItem.
        The last user to run this activity plan

        :param last_run_by: The last_run_by of this ActivityPlanListItem.
        :type: UserReference
        """
        

        self._last_run_by = last_run_by

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this ActivityPlanListItem.
        The date the activity plan was created, in ISO-8601 format

        :return: The created_date of this ActivityPlanListItem.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this ActivityPlanListItem.
        The date the activity plan was created, in ISO-8601 format

        :param created_date: The created_date of this ActivityPlanListItem.
        :type: datetime
        """
        

        self._created_date = created_date

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this ActivityPlanListItem.
        The user who created this activity plan

        :return: The created_by of this ActivityPlanListItem.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this ActivityPlanListItem.
        The user who created this activity plan

        :param created_by: The created_by of this ActivityPlanListItem.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def modified_date(self) -> datetime:
        """
        Gets the modified_date of this ActivityPlanListItem.
        The date the activity plan was modified, in ISO-8601 format

        :return: The modified_date of this ActivityPlanListItem.
        :rtype: datetime
        """
        return self._modified_date

    @modified_date.setter
    def modified_date(self, modified_date: datetime) -> None:
        """
        Sets the modified_date of this ActivityPlanListItem.
        The date the activity plan was modified, in ISO-8601 format

        :param modified_date: The modified_date of this ActivityPlanListItem.
        :type: datetime
        """
        

        self._modified_date = modified_date

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this ActivityPlanListItem.
        The last user to modify this activity plan. The id may be 'System' if it was an automated process

        :return: The modified_by of this ActivityPlanListItem.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this ActivityPlanListItem.
        The last user to modify this activity plan. The id may be 'System' if it was an automated process

        :param modified_by: The modified_by of this ActivityPlanListItem.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this ActivityPlanListItem.
        The URI for this object

        :return: The self_uri of this ActivityPlanListItem.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this ActivityPlanListItem.
        The URI for this object

        :param self_uri: The self_uri of this ActivityPlanListItem.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

