# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmVersionedEntityMetadata

class AdminBulkUpdateAlternativeShiftTradeState(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AdminBulkUpdateAlternativeShiftTradeState - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'trade_id': 'str',
            'state': 'str',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'trade_id': 'tradeId',
            'state': 'state',
            'metadata': 'metadata'
        }

        self._trade_id = None
        self._state = None
        self._metadata = None

    @property
    def trade_id(self) -> str:
        """
        Gets the trade_id of this AdminBulkUpdateAlternativeShiftTradeState.
        The ID of the trade for this alternative shift trade

        :return: The trade_id of this AdminBulkUpdateAlternativeShiftTradeState.
        :rtype: str
        """
        return self._trade_id

    @trade_id.setter
    def trade_id(self, trade_id: str) -> None:
        """
        Sets the trade_id of this AdminBulkUpdateAlternativeShiftTradeState.
        The ID of the trade for this alternative shift trade

        :param trade_id: The trade_id of this AdminBulkUpdateAlternativeShiftTradeState.
        :type: str
        """
        

        self._trade_id = trade_id

    @property
    def state(self) -> str:
        """
        Gets the state of this AdminBulkUpdateAlternativeShiftTradeState.
        The new alternative shift trade state

        :return: The state of this AdminBulkUpdateAlternativeShiftTradeState.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this AdminBulkUpdateAlternativeShiftTradeState.
        The new alternative shift trade state

        :param state: The state of this AdminBulkUpdateAlternativeShiftTradeState.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Approved", "Denied"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this AdminBulkUpdateAlternativeShiftTradeState.
        Version metadata for this alternative shift trade

        :return: The metadata of this AdminBulkUpdateAlternativeShiftTradeState.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this AdminBulkUpdateAlternativeShiftTradeState.
        Version metadata for this alternative shift trade

        :param metadata: The metadata of this AdminBulkUpdateAlternativeShiftTradeState.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

