# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmIntegrationReference

class AgentIntegrationAssociationResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentIntegrationAssociationResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent_external_id': 'str',
            'integration': 'WfmIntegrationReference',
            'locked': 'bool'
        }

        self.attribute_map = {
            'agent_external_id': 'agentExternalId',
            'integration': 'integration',
            'locked': 'locked'
        }

        self._agent_external_id = None
        self._integration = None
        self._locked = None

    @property
    def agent_external_id(self) -> str:
        """
        Gets the agent_external_id of this AgentIntegrationAssociationResponse.
        ID of the agent in external system

        :return: The agent_external_id of this AgentIntegrationAssociationResponse.
        :rtype: str
        """
        return self._agent_external_id

    @agent_external_id.setter
    def agent_external_id(self, agent_external_id: str) -> None:
        """
        Sets the agent_external_id of this AgentIntegrationAssociationResponse.
        ID of the agent in external system

        :param agent_external_id: The agent_external_id of this AgentIntegrationAssociationResponse.
        :type: str
        """
        

        self._agent_external_id = agent_external_id

    @property
    def integration(self) -> 'WfmIntegrationReference':
        """
        Gets the integration of this AgentIntegrationAssociationResponse.
        The integration associated with the agent

        :return: The integration of this AgentIntegrationAssociationResponse.
        :rtype: WfmIntegrationReference
        """
        return self._integration

    @integration.setter
    def integration(self, integration: 'WfmIntegrationReference') -> None:
        """
        Sets the integration of this AgentIntegrationAssociationResponse.
        The integration associated with the agent

        :param integration: The integration of this AgentIntegrationAssociationResponse.
        :type: WfmIntegrationReference
        """
        

        self._integration = integration

    @property
    def locked(self) -> bool:
        """
        Gets the locked of this AgentIntegrationAssociationResponse.
        Whether agentExternalId should be protected from update by automatic processes

        :return: The locked of this AgentIntegrationAssociationResponse.
        :rtype: bool
        """
        return self._locked

    @locked.setter
    def locked(self, locked: bool) -> None:
        """
        Sets the locked of this AgentIntegrationAssociationResponse.
        Whether agentExternalId should be protected from update by automatic processes

        :param locked: The locked of this AgentIntegrationAssociationResponse.
        :type: bool
        """
        

        self._locked = locked

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

