# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AgentIntegrationAssociationResponse
    from . import UserReference
    from . import WfmIntegrationReference

class AgentIntegrationsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentIntegrationsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent': 'UserReference',
            'selected_integration': 'WfmIntegrationReference',
            'user_selected': 'bool',
            'associated_integrations': 'list[AgentIntegrationAssociationResponse]'
        }

        self.attribute_map = {
            'agent': 'agent',
            'selected_integration': 'selectedIntegration',
            'user_selected': 'userSelected',
            'associated_integrations': 'associatedIntegrations'
        }

        self._agent = None
        self._selected_integration = None
        self._user_selected = None
        self._associated_integrations = None

    @property
    def agent(self) -> 'UserReference':
        """
        Gets the agent of this AgentIntegrationsResponse.
        The user associated with the integrations

        :return: The agent of this AgentIntegrationsResponse.
        :rtype: UserReference
        """
        return self._agent

    @agent.setter
    def agent(self, agent: 'UserReference') -> None:
        """
        Sets the agent of this AgentIntegrationsResponse.
        The user associated with the integrations

        :param agent: The agent of this AgentIntegrationsResponse.
        :type: UserReference
        """
        

        self._agent = agent

    @property
    def selected_integration(self) -> 'WfmIntegrationReference':
        """
        Gets the selected_integration of this AgentIntegrationsResponse.
        The integration selected for the agent. If not set, no integration will be used for the agent

        :return: The selected_integration of this AgentIntegrationsResponse.
        :rtype: WfmIntegrationReference
        """
        return self._selected_integration

    @selected_integration.setter
    def selected_integration(self, selected_integration: 'WfmIntegrationReference') -> None:
        """
        Sets the selected_integration of this AgentIntegrationsResponse.
        The integration selected for the agent. If not set, no integration will be used for the agent

        :param selected_integration: The selected_integration of this AgentIntegrationsResponse.
        :type: WfmIntegrationReference
        """
        

        self._selected_integration = selected_integration

    @property
    def user_selected(self) -> bool:
        """
        Gets the user_selected of this AgentIntegrationsResponse.
        Whether the integration association has been manually selected

        :return: The user_selected of this AgentIntegrationsResponse.
        :rtype: bool
        """
        return self._user_selected

    @user_selected.setter
    def user_selected(self, user_selected: bool) -> None:
        """
        Sets the user_selected of this AgentIntegrationsResponse.
        Whether the integration association has been manually selected

        :param user_selected: The user_selected of this AgentIntegrationsResponse.
        :type: bool
        """
        

        self._user_selected = user_selected

    @property
    def associated_integrations(self) -> List['AgentIntegrationAssociationResponse']:
        """
        Gets the associated_integrations of this AgentIntegrationsResponse.
        The list of integrations associated with the agent

        :return: The associated_integrations of this AgentIntegrationsResponse.
        :rtype: list[AgentIntegrationAssociationResponse]
        """
        return self._associated_integrations

    @associated_integrations.setter
    def associated_integrations(self, associated_integrations: List['AgentIntegrationAssociationResponse']) -> None:
        """
        Sets the associated_integrations of this AgentIntegrationsResponse.
        The list of integrations associated with the agent

        :param associated_integrations: The associated_integrations of this AgentIntegrationsResponse.
        :type: list[AgentIntegrationAssociationResponse]
        """
        

        self._associated_integrations = associated_integrations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

