# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AgentOwnedMappingPreview(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentOwnedMappingPreview - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'agent_owned_column': 'str',
            'email': 'str',
            'user_id': 'str',
            'exists': 'bool',
            'is_queue_member': 'bool',
            'record_count': 'int'
        }

        self.attribute_map = {
            'agent_owned_column': 'agentOwnedColumn',
            'email': 'email',
            'user_id': 'userId',
            'exists': 'exists',
            'is_queue_member': 'isQueueMember',
            'record_count': 'recordCount'
        }

        self._agent_owned_column = None
        self._email = None
        self._user_id = None
        self._exists = None
        self._is_queue_member = None
        self._record_count = None

    @property
    def agent_owned_column(self) -> str:
        """
        Gets the agent_owned_column of this AgentOwnedMappingPreview.
        The raw value of the agent-owned column

        :return: The agent_owned_column of this AgentOwnedMappingPreview.
        :rtype: str
        """
        return self._agent_owned_column

    @agent_owned_column.setter
    def agent_owned_column(self, agent_owned_column: str) -> None:
        """
        Sets the agent_owned_column of this AgentOwnedMappingPreview.
        The raw value of the agent-owned column

        :param agent_owned_column: The agent_owned_column of this AgentOwnedMappingPreview.
        :type: str
        """
        

        self._agent_owned_column = agent_owned_column

    @property
    def email(self) -> str:
        """
        Gets the email of this AgentOwnedMappingPreview.
        The email address of the user, if it exists

        :return: The email of this AgentOwnedMappingPreview.
        :rtype: str
        """
        return self._email

    @email.setter
    def email(self, email: str) -> None:
        """
        Sets the email of this AgentOwnedMappingPreview.
        The email address of the user, if it exists

        :param email: The email of this AgentOwnedMappingPreview.
        :type: str
        """
        

        self._email = email

    @property
    def user_id(self) -> str:
        """
        Gets the user_id of this AgentOwnedMappingPreview.
        The id of the user, if it exists

        :return: The user_id of this AgentOwnedMappingPreview.
        :rtype: str
        """
        return self._user_id

    @user_id.setter
    def user_id(self, user_id: str) -> None:
        """
        Sets the user_id of this AgentOwnedMappingPreview.
        The id of the user, if it exists

        :param user_id: The user_id of this AgentOwnedMappingPreview.
        :type: str
        """
        

        self._user_id = user_id

    @property
    def exists(self) -> bool:
        """
        Gets the exists of this AgentOwnedMappingPreview.
        Whether the user exists

        :return: The exists of this AgentOwnedMappingPreview.
        :rtype: bool
        """
        return self._exists

    @exists.setter
    def exists(self, exists: bool) -> None:
        """
        Sets the exists of this AgentOwnedMappingPreview.
        Whether the user exists

        :param exists: The exists of this AgentOwnedMappingPreview.
        :type: bool
        """
        

        self._exists = exists

    @property
    def is_queue_member(self) -> bool:
        """
        Gets the is_queue_member of this AgentOwnedMappingPreview.
        Whether the user is a member of the campaign's queue

        :return: The is_queue_member of this AgentOwnedMappingPreview.
        :rtype: bool
        """
        return self._is_queue_member

    @is_queue_member.setter
    def is_queue_member(self, is_queue_member: bool) -> None:
        """
        Sets the is_queue_member of this AgentOwnedMappingPreview.
        Whether the user is a member of the campaign's queue

        :param is_queue_member: The is_queue_member of this AgentOwnedMappingPreview.
        :type: bool
        """
        

        self._is_queue_member = is_queue_member

    @property
    def record_count(self) -> int:
        """
        Gets the record_count of this AgentOwnedMappingPreview.
        The number of contact records whose agent-owned column matches the raw value

        :return: The record_count of this AgentOwnedMappingPreview.
        :rtype: int
        """
        return self._record_count

    @record_count.setter
    def record_count(self, record_count: int) -> None:
        """
        Sets the record_count of this AgentOwnedMappingPreview.
        The number of contact records whose agent-owned column matches the raw value

        :param record_count: The record_count of this AgentOwnedMappingPreview.
        :type: int
        """
        

        self._record_count = record_count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

