# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AgentOwnedRouting(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentOwnedRouting - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enable_agent_owned_callbacks': 'bool',
            'max_owned_callback_hours': 'int',
            'max_owned_callback_delay_hours': 'int'
        }

        self.attribute_map = {
            'enable_agent_owned_callbacks': 'enableAgentOwnedCallbacks',
            'max_owned_callback_hours': 'maxOwnedCallbackHours',
            'max_owned_callback_delay_hours': 'maxOwnedCallbackDelayHours'
        }

        self._enable_agent_owned_callbacks = None
        self._max_owned_callback_hours = None
        self._max_owned_callback_delay_hours = None

    @property
    def enable_agent_owned_callbacks(self) -> bool:
        """
        Gets the enable_agent_owned_callbacks of this AgentOwnedRouting.
        Indicates if Agent Owned Callbacks are enabled for the queue

        :return: The enable_agent_owned_callbacks of this AgentOwnedRouting.
        :rtype: bool
        """
        return self._enable_agent_owned_callbacks

    @enable_agent_owned_callbacks.setter
    def enable_agent_owned_callbacks(self, enable_agent_owned_callbacks: bool) -> None:
        """
        Sets the enable_agent_owned_callbacks of this AgentOwnedRouting.
        Indicates if Agent Owned Callbacks are enabled for the queue

        :param enable_agent_owned_callbacks: The enable_agent_owned_callbacks of this AgentOwnedRouting.
        :type: bool
        """
        

        self._enable_agent_owned_callbacks = enable_agent_owned_callbacks

    @property
    def max_owned_callback_hours(self) -> int:
        """
        Gets the max_owned_callback_hours of this AgentOwnedRouting.
        The max amount of time a callback can be owned (in hours); Allowable range 1 - 168 hour(s) (inclusive)

        :return: The max_owned_callback_hours of this AgentOwnedRouting.
        :rtype: int
        """
        return self._max_owned_callback_hours

    @max_owned_callback_hours.setter
    def max_owned_callback_hours(self, max_owned_callback_hours: int) -> None:
        """
        Sets the max_owned_callback_hours of this AgentOwnedRouting.
        The max amount of time a callback can be owned (in hours); Allowable range 1 - 168 hour(s) (inclusive)

        :param max_owned_callback_hours: The max_owned_callback_hours of this AgentOwnedRouting.
        :type: int
        """
        

        self._max_owned_callback_hours = max_owned_callback_hours

    @property
    def max_owned_callback_delay_hours(self) -> int:
        """
        Gets the max_owned_callback_delay_hours of this AgentOwnedRouting.
        The max amount of time a callback can be scheduled out into the future (in hours); Allowable range 1 - 720 hour(s) (inclusive)

        :return: The max_owned_callback_delay_hours of this AgentOwnedRouting.
        :rtype: int
        """
        return self._max_owned_callback_delay_hours

    @max_owned_callback_delay_hours.setter
    def max_owned_callback_delay_hours(self, max_owned_callback_delay_hours: int) -> None:
        """
        Sets the max_owned_callback_delay_hours of this AgentOwnedRouting.
        The max amount of time a callback can be scheduled out into the future (in hours); Allowable range 1 - 720 hour(s) (inclusive)

        :param max_owned_callback_delay_hours: The max_owned_callback_delay_hours of this AgentOwnedRouting.
        :type: int
        """
        

        self._max_owned_callback_delay_hours = max_owned_callback_delay_hours

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

