# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AgentStateIsOutOfOfficeCount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentStateIsOutOfOfficeCount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'is_out_of_office': 'bool',
            'count': 'int'
        }

        self.attribute_map = {
            'is_out_of_office': 'isOutOfOffice',
            'count': 'count'
        }

        self._is_out_of_office = None
        self._count = None

    @property
    def is_out_of_office(self) -> bool:
        """
        Gets the is_out_of_office of this AgentStateIsOutOfOfficeCount.
        The out of office state

        :return: The is_out_of_office of this AgentStateIsOutOfOfficeCount.
        :rtype: bool
        """
        return self._is_out_of_office

    @is_out_of_office.setter
    def is_out_of_office(self, is_out_of_office: bool) -> None:
        """
        Sets the is_out_of_office of this AgentStateIsOutOfOfficeCount.
        The out of office state

        :param is_out_of_office: The is_out_of_office of this AgentStateIsOutOfOfficeCount.
        :type: bool
        """
        

        self._is_out_of_office = is_out_of_office

    @property
    def count(self) -> int:
        """
        Gets the count of this AgentStateIsOutOfOfficeCount.
        Count of users with this out of office state

        :return: The count of this AgentStateIsOutOfOfficeCount.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this AgentStateIsOutOfOfficeCount.
        Count of users with this out of office state

        :param count: The count of this AgentStateIsOutOfOfficeCount.
        :type: int
        """
        

        self._count = count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

