# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AgentStatePresenceCount(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentStatePresenceCount - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'system_presence': 'str',
            'organization_presence_id': 'str',
            'count': 'int'
        }

        self.attribute_map = {
            'system_presence': 'systemPresence',
            'organization_presence_id': 'organizationPresenceId',
            'count': 'count'
        }

        self._system_presence = None
        self._organization_presence_id = None
        self._count = None

    @property
    def system_presence(self) -> str:
        """
        Gets the system_presence of this AgentStatePresenceCount.
        System presence

        :return: The system_presence of this AgentStatePresenceCount.
        :rtype: str
        """
        return self._system_presence

    @system_presence.setter
    def system_presence(self, system_presence: str) -> None:
        """
        Sets the system_presence of this AgentStatePresenceCount.
        System presence

        :param system_presence: The system_presence of this AgentStatePresenceCount.
        :type: str
        """
        if isinstance(system_presence, int):
            system_presence = str(system_presence)
        allowed_values = ["UNKNOWN", "AVAILABLE", "AWAY", "BUSY", "OFFLINE", "IDLE", "ON_QUEUE", "MEAL", "TRAINING", "MEETING", "BREAK"]
        if system_presence.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for system_presence -> " + system_presence)
            self._system_presence = "outdated_sdk_version"
        else:
            self._system_presence = system_presence

    @property
    def organization_presence_id(self) -> str:
        """
        Gets the organization_presence_id of this AgentStatePresenceCount.
        The identifier for the organization presence

        :return: The organization_presence_id of this AgentStatePresenceCount.
        :rtype: str
        """
        return self._organization_presence_id

    @organization_presence_id.setter
    def organization_presence_id(self, organization_presence_id: str) -> None:
        """
        Sets the organization_presence_id of this AgentStatePresenceCount.
        The identifier for the organization presence

        :param organization_presence_id: The organization_presence_id of this AgentStatePresenceCount.
        :type: str
        """
        

        self._organization_presence_id = organization_presence_id

    @property
    def count(self) -> int:
        """
        Gets the count of this AgentStatePresenceCount.
        Count of users with this system presence and organization presence

        :return: The count of this AgentStatePresenceCount.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this AgentStatePresenceCount.
        Count of users with this system presence and organization presence

        :param count: The count of this AgentStatePresenceCount.
        :type: int
        """
        

        self._count = count

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

