# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AgentWorkPlanActivity
    from . import SetWrapperDayOfWeek

class AgentWorkPlanShift(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AgentWorkPlanShift - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'days': 'SetWrapperDayOfWeek',
            'flexible_start_time': 'bool',
            'exact_start_time_minutes_from_midnight': 'int',
            'earliest_start_time_minutes_from_midnight': 'int',
            'latest_start_time_minutes_from_midnight': 'int',
            'earliest_stop_time_minutes_from_midnight': 'int',
            'constrain_latest_stop_time': 'bool',
            'latest_stop_time_minutes_from_midnight': 'int',
            'flexible_paid_time': 'bool',
            'exact_paid_time_minutes': 'int',
            'minimum_paid_time_minutes': 'int',
            'maximum_paid_time_minutes': 'int',
            'activities': 'list[AgentWorkPlanActivity]'
        }

        self.attribute_map = {
            'days': 'days',
            'flexible_start_time': 'flexibleStartTime',
            'exact_start_time_minutes_from_midnight': 'exactStartTimeMinutesFromMidnight',
            'earliest_start_time_minutes_from_midnight': 'earliestStartTimeMinutesFromMidnight',
            'latest_start_time_minutes_from_midnight': 'latestStartTimeMinutesFromMidnight',
            'earliest_stop_time_minutes_from_midnight': 'earliestStopTimeMinutesFromMidnight',
            'constrain_latest_stop_time': 'constrainLatestStopTime',
            'latest_stop_time_minutes_from_midnight': 'latestStopTimeMinutesFromMidnight',
            'flexible_paid_time': 'flexiblePaidTime',
            'exact_paid_time_minutes': 'exactPaidTimeMinutes',
            'minimum_paid_time_minutes': 'minimumPaidTimeMinutes',
            'maximum_paid_time_minutes': 'maximumPaidTimeMinutes',
            'activities': 'activities'
        }

        self._days = None
        self._flexible_start_time = None
        self._exact_start_time_minutes_from_midnight = None
        self._earliest_start_time_minutes_from_midnight = None
        self._latest_start_time_minutes_from_midnight = None
        self._earliest_stop_time_minutes_from_midnight = None
        self._constrain_latest_stop_time = None
        self._latest_stop_time_minutes_from_midnight = None
        self._flexible_paid_time = None
        self._exact_paid_time_minutes = None
        self._minimum_paid_time_minutes = None
        self._maximum_paid_time_minutes = None
        self._activities = None

    @property
    def days(self) -> 'SetWrapperDayOfWeek':
        """
        Gets the days of this AgentWorkPlanShift.
        Days of the week applicable for this shift

        :return: The days of this AgentWorkPlanShift.
        :rtype: SetWrapperDayOfWeek
        """
        return self._days

    @days.setter
    def days(self, days: 'SetWrapperDayOfWeek') -> None:
        """
        Sets the days of this AgentWorkPlanShift.
        Days of the week applicable for this shift

        :param days: The days of this AgentWorkPlanShift.
        :type: SetWrapperDayOfWeek
        """
        

        self._days = days

    @property
    def flexible_start_time(self) -> bool:
        """
        Gets the flexible_start_time of this AgentWorkPlanShift.
        Whether the start time of the shift is flexible

        :return: The flexible_start_time of this AgentWorkPlanShift.
        :rtype: bool
        """
        return self._flexible_start_time

    @flexible_start_time.setter
    def flexible_start_time(self, flexible_start_time: bool) -> None:
        """
        Sets the flexible_start_time of this AgentWorkPlanShift.
        Whether the start time of the shift is flexible

        :param flexible_start_time: The flexible_start_time of this AgentWorkPlanShift.
        :type: bool
        """
        

        self._flexible_start_time = flexible_start_time

    @property
    def exact_start_time_minutes_from_midnight(self) -> int:
        """
        Gets the exact_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Exact start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == false

        :return: The exact_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._exact_start_time_minutes_from_midnight

    @exact_start_time_minutes_from_midnight.setter
    def exact_start_time_minutes_from_midnight(self, exact_start_time_minutes_from_midnight: int) -> None:
        """
        Sets the exact_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Exact start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == false

        :param exact_start_time_minutes_from_midnight: The exact_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :type: int
        """
        

        self._exact_start_time_minutes_from_midnight = exact_start_time_minutes_from_midnight

    @property
    def earliest_start_time_minutes_from_midnight(self) -> int:
        """
        Gets the earliest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Earliest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true

        :return: The earliest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._earliest_start_time_minutes_from_midnight

    @earliest_start_time_minutes_from_midnight.setter
    def earliest_start_time_minutes_from_midnight(self, earliest_start_time_minutes_from_midnight: int) -> None:
        """
        Sets the earliest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Earliest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true

        :param earliest_start_time_minutes_from_midnight: The earliest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :type: int
        """
        

        self._earliest_start_time_minutes_from_midnight = earliest_start_time_minutes_from_midnight

    @property
    def latest_start_time_minutes_from_midnight(self) -> int:
        """
        Gets the latest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Latest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true

        :return: The latest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._latest_start_time_minutes_from_midnight

    @latest_start_time_minutes_from_midnight.setter
    def latest_start_time_minutes_from_midnight(self, latest_start_time_minutes_from_midnight: int) -> None:
        """
        Sets the latest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        Latest start time of the shift defined as offset minutes from midnight. Used if flexibleStartTime == true

        :param latest_start_time_minutes_from_midnight: The latest_start_time_minutes_from_midnight of this AgentWorkPlanShift.
        :type: int
        """
        

        self._latest_start_time_minutes_from_midnight = latest_start_time_minutes_from_midnight

    @property
    def earliest_stop_time_minutes_from_midnight(self) -> int:
        """
        Gets the earliest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        This is the earliest time a shift can end

        :return: The earliest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._earliest_stop_time_minutes_from_midnight

    @earliest_stop_time_minutes_from_midnight.setter
    def earliest_stop_time_minutes_from_midnight(self, earliest_stop_time_minutes_from_midnight: int) -> None:
        """
        Sets the earliest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        This is the earliest time a shift can end

        :param earliest_stop_time_minutes_from_midnight: The earliest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        :type: int
        """
        

        self._earliest_stop_time_minutes_from_midnight = earliest_stop_time_minutes_from_midnight

    @property
    def constrain_latest_stop_time(self) -> bool:
        """
        Gets the constrain_latest_stop_time of this AgentWorkPlanShift.
        Whether the latest stop time constraint for the shift is enabled

        :return: The constrain_latest_stop_time of this AgentWorkPlanShift.
        :rtype: bool
        """
        return self._constrain_latest_stop_time

    @constrain_latest_stop_time.setter
    def constrain_latest_stop_time(self, constrain_latest_stop_time: bool) -> None:
        """
        Sets the constrain_latest_stop_time of this AgentWorkPlanShift.
        Whether the latest stop time constraint for the shift is enabled

        :param constrain_latest_stop_time: The constrain_latest_stop_time of this AgentWorkPlanShift.
        :type: bool
        """
        

        self._constrain_latest_stop_time = constrain_latest_stop_time

    @property
    def latest_stop_time_minutes_from_midnight(self) -> int:
        """
        Gets the latest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        Latest stop time of the shift defined as offset minutes from midnight. Used if constrainStopTime == true

        :return: The latest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._latest_stop_time_minutes_from_midnight

    @latest_stop_time_minutes_from_midnight.setter
    def latest_stop_time_minutes_from_midnight(self, latest_stop_time_minutes_from_midnight: int) -> None:
        """
        Sets the latest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        Latest stop time of the shift defined as offset minutes from midnight. Used if constrainStopTime == true

        :param latest_stop_time_minutes_from_midnight: The latest_stop_time_minutes_from_midnight of this AgentWorkPlanShift.
        :type: int
        """
        

        self._latest_stop_time_minutes_from_midnight = latest_stop_time_minutes_from_midnight

    @property
    def flexible_paid_time(self) -> bool:
        """
        Gets the flexible_paid_time of this AgentWorkPlanShift.
        Whether the paid time setting for the shift is flexible

        :return: The flexible_paid_time of this AgentWorkPlanShift.
        :rtype: bool
        """
        return self._flexible_paid_time

    @flexible_paid_time.setter
    def flexible_paid_time(self, flexible_paid_time: bool) -> None:
        """
        Sets the flexible_paid_time of this AgentWorkPlanShift.
        Whether the paid time setting for the shift is flexible

        :param flexible_paid_time: The flexible_paid_time of this AgentWorkPlanShift.
        :type: bool
        """
        

        self._flexible_paid_time = flexible_paid_time

    @property
    def exact_paid_time_minutes(self) -> int:
        """
        Gets the exact_paid_time_minutes of this AgentWorkPlanShift.
        Exact paid time in minutes configured for the shift. Used if flexiblePaidTime == false

        :return: The exact_paid_time_minutes of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._exact_paid_time_minutes

    @exact_paid_time_minutes.setter
    def exact_paid_time_minutes(self, exact_paid_time_minutes: int) -> None:
        """
        Sets the exact_paid_time_minutes of this AgentWorkPlanShift.
        Exact paid time in minutes configured for the shift. Used if flexiblePaidTime == false

        :param exact_paid_time_minutes: The exact_paid_time_minutes of this AgentWorkPlanShift.
        :type: int
        """
        

        self._exact_paid_time_minutes = exact_paid_time_minutes

    @property
    def minimum_paid_time_minutes(self) -> int:
        """
        Gets the minimum_paid_time_minutes of this AgentWorkPlanShift.
        Minimum paid time in minutes configured for the shift. Used if flexiblePaidTime == true

        :return: The minimum_paid_time_minutes of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._minimum_paid_time_minutes

    @minimum_paid_time_minutes.setter
    def minimum_paid_time_minutes(self, minimum_paid_time_minutes: int) -> None:
        """
        Sets the minimum_paid_time_minutes of this AgentWorkPlanShift.
        Minimum paid time in minutes configured for the shift. Used if flexiblePaidTime == true

        :param minimum_paid_time_minutes: The minimum_paid_time_minutes of this AgentWorkPlanShift.
        :type: int
        """
        

        self._minimum_paid_time_minutes = minimum_paid_time_minutes

    @property
    def maximum_paid_time_minutes(self) -> int:
        """
        Gets the maximum_paid_time_minutes of this AgentWorkPlanShift.
        Maximum paid time in minutes configured for the shift. Used if flexiblePaidTime == true

        :return: The maximum_paid_time_minutes of this AgentWorkPlanShift.
        :rtype: int
        """
        return self._maximum_paid_time_minutes

    @maximum_paid_time_minutes.setter
    def maximum_paid_time_minutes(self, maximum_paid_time_minutes: int) -> None:
        """
        Sets the maximum_paid_time_minutes of this AgentWorkPlanShift.
        Maximum paid time in minutes configured for the shift. Used if flexiblePaidTime == true

        :param maximum_paid_time_minutes: The maximum_paid_time_minutes of this AgentWorkPlanShift.
        :type: int
        """
        

        self._maximum_paid_time_minutes = maximum_paid_time_minutes

    @property
    def activities(self) -> List['AgentWorkPlanActivity']:
        """
        Gets the activities of this AgentWorkPlanShift.
        Activities configured for this shift

        :return: The activities of this AgentWorkPlanShift.
        :rtype: list[AgentWorkPlanActivity]
        """
        return self._activities

    @activities.setter
    def activities(self, activities: List['AgentWorkPlanActivity']) -> None:
        """
        Sets the activities of this AgentWorkPlanShift.
        Activities configured for this shift

        :param activities: The activities of this AgentWorkPlanShift.
        :type: list[AgentWorkPlanActivity]
        """
        

        self._activities = activities

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

