# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AggregationResultEntry

class AggregationResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AggregationResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'type': 'str',
            'dimension': 'str',
            'metric': 'str',
            'count': 'int',
            'results': 'list[AggregationResultEntry]'
        }

        self.attribute_map = {
            'type': 'type',
            'dimension': 'dimension',
            'metric': 'metric',
            'count': 'count',
            'results': 'results'
        }

        self._type = None
        self._dimension = None
        self._metric = None
        self._count = None
        self._results = None

    @property
    def type(self) -> str:
        """
        Gets the type of this AggregationResult.


        :return: The type of this AggregationResult.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this AggregationResult.


        :param type: The type of this AggregationResult.
        :type: str
        """
        if isinstance(type, int):
            type = str(type)
        allowed_values = ["termFrequency", "numericRange"]
        if type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for type -> " + type)
            self._type = "outdated_sdk_version"
        else:
            self._type = type

    @property
    def dimension(self) -> str:
        """
        Gets the dimension of this AggregationResult.
        For termFrequency aggregations

        :return: The dimension of this AggregationResult.
        :rtype: str
        """
        return self._dimension

    @dimension.setter
    def dimension(self, dimension: str) -> None:
        """
        Sets the dimension of this AggregationResult.
        For termFrequency aggregations

        :param dimension: The dimension of this AggregationResult.
        :type: str
        """
        

        self._dimension = dimension

    @property
    def metric(self) -> str:
        """
        Gets the metric of this AggregationResult.
        For numericRange aggregations

        :return: The metric of this AggregationResult.
        :rtype: str
        """
        return self._metric

    @metric.setter
    def metric(self, metric: str) -> None:
        """
        Sets the metric of this AggregationResult.
        For numericRange aggregations

        :param metric: The metric of this AggregationResult.
        :type: str
        """
        

        self._metric = metric

    @property
    def count(self) -> int:
        """
        Gets the count of this AggregationResult.


        :return: The count of this AggregationResult.
        :rtype: int
        """
        return self._count

    @count.setter
    def count(self, count: int) -> None:
        """
        Sets the count of this AggregationResult.


        :param count: The count of this AggregationResult.
        :type: int
        """
        

        self._count = count

    @property
    def results(self) -> List['AggregationResultEntry']:
        """
        Gets the results of this AggregationResult.


        :return: The results of this AggregationResult.
        :rtype: list[AggregationResultEntry]
        """
        return self._results

    @results.setter
    def results(self, results: List['AggregationResultEntry']) -> None:
        """
        Sets the results of this AggregationResult.


        :param results: The results of this AggregationResult.
        :type: list[AggregationResultEntry]
        """
        

        self._results = results

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

