# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import WfmVersionedEntityMetadata

class AlternativeShiftBuSettingsResponse(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftBuSettingsResponse - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'enabled_granularities': 'list[str]',
            'min_minutes_before_start_time': 'int',
            'retained_activity_categories': 'list[str]',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'enabled_granularities': 'enabledGranularities',
            'min_minutes_before_start_time': 'minMinutesBeforeStartTime',
            'retained_activity_categories': 'retainedActivityCategories',
            'metadata': 'metadata'
        }

        self._enabled_granularities = None
        self._min_minutes_before_start_time = None
        self._retained_activity_categories = None
        self._metadata = None

    @property
    def enabled_granularities(self) -> List[str]:
        """
        Gets the enabled_granularities of this AlternativeShiftBuSettingsResponse.
        The granularity at which alternative shifts is allowed. An empty list means Alternative Shifts is disabled

        :return: The enabled_granularities of this AlternativeShiftBuSettingsResponse.
        :rtype: list[str]
        """
        return self._enabled_granularities

    @enabled_granularities.setter
    def enabled_granularities(self, enabled_granularities: List[str]) -> None:
        """
        Sets the enabled_granularities of this AlternativeShiftBuSettingsResponse.
        The granularity at which alternative shifts is allowed. An empty list means Alternative Shifts is disabled

        :param enabled_granularities: The enabled_granularities of this AlternativeShiftBuSettingsResponse.
        :type: list[str]
        """
        

        self._enabled_granularities = enabled_granularities

    @property
    def min_minutes_before_start_time(self) -> int:
        """
        Gets the min_minutes_before_start_time of this AlternativeShiftBuSettingsResponse.
        The minimum number of minutes before the start of a shift that an alternative shift can be automatically approved

        :return: The min_minutes_before_start_time of this AlternativeShiftBuSettingsResponse.
        :rtype: int
        """
        return self._min_minutes_before_start_time

    @min_minutes_before_start_time.setter
    def min_minutes_before_start_time(self, min_minutes_before_start_time: int) -> None:
        """
        Sets the min_minutes_before_start_time of this AlternativeShiftBuSettingsResponse.
        The minimum number of minutes before the start of a shift that an alternative shift can be automatically approved

        :param min_minutes_before_start_time: The min_minutes_before_start_time of this AlternativeShiftBuSettingsResponse.
        :type: int
        """
        

        self._min_minutes_before_start_time = min_minutes_before_start_time

    @property
    def retained_activity_categories(self) -> List[str]:
        """
        Gets the retained_activity_categories of this AlternativeShiftBuSettingsResponse.
        Categories of activities that are required to remain at the same time slot for the alternative shifts offered. An empty list represents no retained activities

        :return: The retained_activity_categories of this AlternativeShiftBuSettingsResponse.
        :rtype: list[str]
        """
        return self._retained_activity_categories

    @retained_activity_categories.setter
    def retained_activity_categories(self, retained_activity_categories: List[str]) -> None:
        """
        Sets the retained_activity_categories of this AlternativeShiftBuSettingsResponse.
        Categories of activities that are required to remain at the same time slot for the alternative shifts offered. An empty list represents no retained activities

        :param retained_activity_categories: The retained_activity_categories of this AlternativeShiftBuSettingsResponse.
        :type: list[str]
        """
        

        self._retained_activity_categories = retained_activity_categories

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this AlternativeShiftBuSettingsResponse.
        Version metadata for this business unit's alternative shift settings

        :return: The metadata of this AlternativeShiftBuSettingsResponse.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this AlternativeShiftBuSettingsResponse.
        Version metadata for this business unit's alternative shift settings

        :param metadata: The metadata of this AlternativeShiftBuSettingsResponse.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

