# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference

class AlternativeShiftNotification(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftNotification - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'week_date': 'date',
            'granularity': 'str',
            'new_state': 'str',
            'initiating_user': 'UserReference',
            'initiating_shift_date': 'datetime',
            'receiving_user': 'UserReference',
            'receiving_shift_date': 'datetime',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'week_date': 'weekDate',
            'granularity': 'granularity',
            'new_state': 'newState',
            'initiating_user': 'initiatingUser',
            'initiating_shift_date': 'initiatingShiftDate',
            'receiving_user': 'receivingUser',
            'receiving_shift_date': 'receivingShiftDate',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._week_date = None
        self._granularity = None
        self._new_state = None
        self._initiating_user = None
        self._initiating_shift_date = None
        self._receiving_user = None
        self._receiving_shift_date = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this AlternativeShiftNotification.
        The globally unique identifier for the object.

        :return: The id of this AlternativeShiftNotification.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this AlternativeShiftNotification.
        The globally unique identifier for the object.

        :param id: The id of this AlternativeShiftNotification.
        :type: str
        """
        

        self._id = id

    @property
    def week_date(self) -> date:
        """
        Gets the week_date of this AlternativeShiftNotification.
        The start date of the schedule with which this trade is associated. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The week_date of this AlternativeShiftNotification.
        :rtype: date
        """
        return self._week_date

    @week_date.setter
    def week_date(self, week_date: date) -> None:
        """
        Sets the week_date of this AlternativeShiftNotification.
        The start date of the schedule with which this trade is associated. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param week_date: The week_date of this AlternativeShiftNotification.
        :type: date
        """
        

        self._week_date = week_date

    @property
    def granularity(self) -> str:
        """
        Gets the granularity of this AlternativeShiftNotification.
        The granularity of alternative shifts to be traded

        :return: The granularity of this AlternativeShiftNotification.
        :rtype: str
        """
        return self._granularity

    @granularity.setter
    def granularity(self, granularity: str) -> None:
        """
        Sets the granularity of this AlternativeShiftNotification.
        The granularity of alternative shifts to be traded

        :param granularity: The granularity of this AlternativeShiftNotification.
        :type: str
        """
        if isinstance(granularity, int):
            granularity = str(granularity)
        allowed_values = ["Daily"]
        if granularity.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for granularity -> " + granularity)
            self._granularity = "outdated_sdk_version"
        else:
            self._granularity = granularity

    @property
    def new_state(self) -> str:
        """
        Gets the new_state of this AlternativeShiftNotification.
        The new state of the alternative shift trade, null if there was no change

        :return: The new_state of this AlternativeShiftNotification.
        :rtype: str
        """
        return self._new_state

    @new_state.setter
    def new_state(self, new_state: str) -> None:
        """
        Sets the new_state of this AlternativeShiftNotification.
        The new state of the alternative shift trade, null if there was no change

        :param new_state: The new_state of this AlternativeShiftNotification.
        :type: str
        """
        if isinstance(new_state, int):
            new_state = str(new_state)
        allowed_values = ["Canceled", "Denied", "Expired", "Submitted", "Approved"]
        if new_state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for new_state -> " + new_state)
            self._new_state = "outdated_sdk_version"
        else:
            self._new_state = new_state

    @property
    def initiating_user(self) -> 'UserReference':
        """
        Gets the initiating_user of this AlternativeShiftNotification.
        The user who initiated the alternative shift trade

        :return: The initiating_user of this AlternativeShiftNotification.
        :rtype: UserReference
        """
        return self._initiating_user

    @initiating_user.setter
    def initiating_user(self, initiating_user: 'UserReference') -> None:
        """
        Sets the initiating_user of this AlternativeShiftNotification.
        The user who initiated the alternative shift trade

        :param initiating_user: The initiating_user of this AlternativeShiftNotification.
        :type: UserReference
        """
        

        self._initiating_user = initiating_user

    @property
    def initiating_shift_date(self) -> datetime:
        """
        Gets the initiating_shift_date of this AlternativeShiftNotification.
        The start date and time of the initiating shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The initiating_shift_date of this AlternativeShiftNotification.
        :rtype: datetime
        """
        return self._initiating_shift_date

    @initiating_shift_date.setter
    def initiating_shift_date(self, initiating_shift_date: datetime) -> None:
        """
        Sets the initiating_shift_date of this AlternativeShiftNotification.
        The start date and time of the initiating shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param initiating_shift_date: The initiating_shift_date of this AlternativeShiftNotification.
        :type: datetime
        """
        

        self._initiating_shift_date = initiating_shift_date

    @property
    def receiving_user(self) -> 'UserReference':
        """
        Gets the receiving_user of this AlternativeShiftNotification.
        The user on the receiving side of this alternative shift trade

        :return: The receiving_user of this AlternativeShiftNotification.
        :rtype: UserReference
        """
        return self._receiving_user

    @receiving_user.setter
    def receiving_user(self, receiving_user: 'UserReference') -> None:
        """
        Sets the receiving_user of this AlternativeShiftNotification.
        The user on the receiving side of this alternative shift trade

        :param receiving_user: The receiving_user of this AlternativeShiftNotification.
        :type: UserReference
        """
        

        self._receiving_user = receiving_user

    @property
    def receiving_shift_date(self) -> datetime:
        """
        Gets the receiving_shift_date of this AlternativeShiftNotification.
        The start date and time of the receiving alternative shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The receiving_shift_date of this AlternativeShiftNotification.
        :rtype: datetime
        """
        return self._receiving_shift_date

    @receiving_shift_date.setter
    def receiving_shift_date(self, receiving_shift_date: datetime) -> None:
        """
        Sets the receiving_shift_date of this AlternativeShiftNotification.
        The start date and time of the receiving alternative shift. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param receiving_shift_date: The receiving_shift_date of this AlternativeShiftNotification.
        :type: datetime
        """
        

        self._receiving_shift_date = receiving_shift_date

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this AlternativeShiftNotification.
        The URI for this object

        :return: The self_uri of this AlternativeShiftNotification.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this AlternativeShiftNotification.
        The URI for this object

        :param self_uri: The self_uri of this AlternativeShiftNotification.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

