# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import UserReference
    from . import WfmVersionedEntityMetadata

class AlternativeShiftTradeBulkUpdateTemplateItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AlternativeShiftTradeBulkUpdateTemplateItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'trade_id': 'str',
            'state': 'str',
            'failure_reason': 'str',
            'admin_date_reviewed': 'datetime',
            'admin_reviewed_by': 'UserReference',
            'metadata': 'WfmVersionedEntityMetadata'
        }

        self.attribute_map = {
            'trade_id': 'tradeId',
            'state': 'state',
            'failure_reason': 'failureReason',
            'admin_date_reviewed': 'adminDateReviewed',
            'admin_reviewed_by': 'adminReviewedBy',
            'metadata': 'metadata'
        }

        self._trade_id = None
        self._state = None
        self._failure_reason = None
        self._admin_date_reviewed = None
        self._admin_reviewed_by = None
        self._metadata = None

    @property
    def trade_id(self) -> str:
        """
        Gets the trade_id of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The ID of this alternative shift trade

        :return: The trade_id of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: str
        """
        return self._trade_id

    @trade_id.setter
    def trade_id(self, trade_id: str) -> None:
        """
        Sets the trade_id of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The ID of this alternative shift trade

        :param trade_id: The trade_id of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: str
        """
        

        self._trade_id = trade_id

    @property
    def state(self) -> str:
        """
        Gets the state of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The current state of this alternative shift trade request

        :return: The state of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The current state of this alternative shift trade request

        :param state: The state of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Canceled", "Denied", "Expired", "Submitted", "Approved"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def failure_reason(self) -> str:
        """
        Gets the failure_reason of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The reason the update failed, if applicable

        :return: The failure_reason of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: str
        """
        return self._failure_reason

    @failure_reason.setter
    def failure_reason(self, failure_reason: str) -> None:
        """
        Sets the failure_reason of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The reason the update failed, if applicable

        :param failure_reason: The failure_reason of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: str
        """
        if isinstance(failure_reason, int):
            failure_reason = str(failure_reason)
        allowed_values = ["TransitionNotAllowed", "NotAuthorized"]
        if failure_reason.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for failure_reason -> " + failure_reason)
            self._failure_reason = "outdated_sdk_version"
        else:
            self._failure_reason = failure_reason

    @property
    def admin_date_reviewed(self) -> datetime:
        """
        Gets the admin_date_reviewed of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The timestamp of when the trade request was manually reviewed by an admin in ISO-8601 format

        :return: The admin_date_reviewed of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: datetime
        """
        return self._admin_date_reviewed

    @admin_date_reviewed.setter
    def admin_date_reviewed(self, admin_date_reviewed: datetime) -> None:
        """
        Sets the admin_date_reviewed of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The timestamp of when the trade request was manually reviewed by an admin in ISO-8601 format

        :param admin_date_reviewed: The admin_date_reviewed of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: datetime
        """
        

        self._admin_date_reviewed = admin_date_reviewed

    @property
    def admin_reviewed_by(self) -> 'UserReference':
        """
        Gets the admin_reviewed_by of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The admin who manually reviewed this alternative shift trade after system denial

        :return: The admin_reviewed_by of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: UserReference
        """
        return self._admin_reviewed_by

    @admin_reviewed_by.setter
    def admin_reviewed_by(self, admin_reviewed_by: 'UserReference') -> None:
        """
        Sets the admin_reviewed_by of this AlternativeShiftTradeBulkUpdateTemplateItem.
        The admin who manually reviewed this alternative shift trade after system denial

        :param admin_reviewed_by: The admin_reviewed_by of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: UserReference
        """
        

        self._admin_reviewed_by = admin_reviewed_by

    @property
    def metadata(self) -> 'WfmVersionedEntityMetadata':
        """
        Gets the metadata of this AlternativeShiftTradeBulkUpdateTemplateItem.
        Version metadata for this alternative shift trade

        :return: The metadata of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :rtype: WfmVersionedEntityMetadata
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: 'WfmVersionedEntityMetadata') -> None:
        """
        Sets the metadata of this AlternativeShiftTradeBulkUpdateTemplateItem.
        Version metadata for this alternative shift trade

        :param metadata: The metadata of this AlternativeShiftTradeBulkUpdateTemplateItem.
        :type: WfmVersionedEntityMetadata
        """
        

        self._metadata = metadata

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

