# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AnalyticsAgentStateAgentSessionResult(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AnalyticsAgentStateAgentSessionResult - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'conversation_id': 'str',
            'session_id': 'str',
            'session_start': 'datetime',
            'segment_start': 'datetime',
            'segment_type': 'str',
            'routed_queue_id': 'str',
            'requested_routing_skill_ids': 'list[str]',
            'requested_language_id': 'str',
            'originating_direction': 'str',
            'media_type': 'str'
        }

        self.attribute_map = {
            'conversation_id': 'conversationId',
            'session_id': 'sessionId',
            'session_start': 'sessionStart',
            'segment_start': 'segmentStart',
            'segment_type': 'segmentType',
            'routed_queue_id': 'routedQueueId',
            'requested_routing_skill_ids': 'requestedRoutingSkillIds',
            'requested_language_id': 'requestedLanguageId',
            'originating_direction': 'originatingDirection',
            'media_type': 'mediaType'
        }

        self._conversation_id = None
        self._session_id = None
        self._session_start = None
        self._segment_start = None
        self._segment_type = None
        self._routed_queue_id = None
        self._requested_routing_skill_ids = None
        self._requested_language_id = None
        self._originating_direction = None
        self._media_type = None

    @property
    def conversation_id(self) -> str:
        """
        Gets the conversation_id of this AnalyticsAgentStateAgentSessionResult.
        Conversation Id

        :return: The conversation_id of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._conversation_id

    @conversation_id.setter
    def conversation_id(self, conversation_id: str) -> None:
        """
        Sets the conversation_id of this AnalyticsAgentStateAgentSessionResult.
        Conversation Id

        :param conversation_id: The conversation_id of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        

        self._conversation_id = conversation_id

    @property
    def session_id(self) -> str:
        """
        Gets the session_id of this AnalyticsAgentStateAgentSessionResult.
        Session Id

        :return: The session_id of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._session_id

    @session_id.setter
    def session_id(self, session_id: str) -> None:
        """
        Sets the session_id of this AnalyticsAgentStateAgentSessionResult.
        Session Id

        :param session_id: The session_id of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        

        self._session_id = session_id

    @property
    def session_start(self) -> datetime:
        """
        Gets the session_start of this AnalyticsAgentStateAgentSessionResult.
        Session start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The session_start of this AnalyticsAgentStateAgentSessionResult.
        :rtype: datetime
        """
        return self._session_start

    @session_start.setter
    def session_start(self, session_start: datetime) -> None:
        """
        Sets the session_start of this AnalyticsAgentStateAgentSessionResult.
        Session start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param session_start: The session_start of this AnalyticsAgentStateAgentSessionResult.
        :type: datetime
        """
        

        self._session_start = session_start

    @property
    def segment_start(self) -> datetime:
        """
        Gets the segment_start of this AnalyticsAgentStateAgentSessionResult.
        Segment start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The segment_start of this AnalyticsAgentStateAgentSessionResult.
        :rtype: datetime
        """
        return self._segment_start

    @segment_start.setter
    def segment_start(self, segment_start: datetime) -> None:
        """
        Sets the segment_start of this AnalyticsAgentStateAgentSessionResult.
        Segment start datetime. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param segment_start: The segment_start of this AnalyticsAgentStateAgentSessionResult.
        :type: datetime
        """
        

        self._segment_start = segment_start

    @property
    def segment_type(self) -> str:
        """
        Gets the segment_type of this AnalyticsAgentStateAgentSessionResult.
        Segment type

        :return: The segment_type of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._segment_type

    @segment_type.setter
    def segment_type(self, segment_type: str) -> None:
        """
        Sets the segment_type of this AnalyticsAgentStateAgentSessionResult.
        Segment type

        :param segment_type: The segment_type of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        if isinstance(segment_type, int):
            segment_type = str(segment_type)
        allowed_values = ["alert", "barging", "callback", "coaching", "contacting", "converting", "delay", "dialing", "hold", "interact", "ivr", "monitoring", "parked", "scheduled", "sharing", "system", "transmitting", "unknown", "uploading", "voicemail", "wrapup"]
        if segment_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for segment_type -> " + segment_type)
            self._segment_type = "outdated_sdk_version"
        else:
            self._segment_type = segment_type

    @property
    def routed_queue_id(self) -> str:
        """
        Gets the routed_queue_id of this AnalyticsAgentStateAgentSessionResult.
        Routed queue Id

        :return: The routed_queue_id of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._routed_queue_id

    @routed_queue_id.setter
    def routed_queue_id(self, routed_queue_id: str) -> None:
        """
        Sets the routed_queue_id of this AnalyticsAgentStateAgentSessionResult.
        Routed queue Id

        :param routed_queue_id: The routed_queue_id of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        

        self._routed_queue_id = routed_queue_id

    @property
    def requested_routing_skill_ids(self) -> List[str]:
        """
        Gets the requested_routing_skill_ids of this AnalyticsAgentStateAgentSessionResult.
        List of requested routing skill Id

        :return: The requested_routing_skill_ids of this AnalyticsAgentStateAgentSessionResult.
        :rtype: list[str]
        """
        return self._requested_routing_skill_ids

    @requested_routing_skill_ids.setter
    def requested_routing_skill_ids(self, requested_routing_skill_ids: List[str]) -> None:
        """
        Sets the requested_routing_skill_ids of this AnalyticsAgentStateAgentSessionResult.
        List of requested routing skill Id

        :param requested_routing_skill_ids: The requested_routing_skill_ids of this AnalyticsAgentStateAgentSessionResult.
        :type: list[str]
        """
        

        self._requested_routing_skill_ids = requested_routing_skill_ids

    @property
    def requested_language_id(self) -> str:
        """
        Gets the requested_language_id of this AnalyticsAgentStateAgentSessionResult.
        Requested language Id

        :return: The requested_language_id of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._requested_language_id

    @requested_language_id.setter
    def requested_language_id(self, requested_language_id: str) -> None:
        """
        Sets the requested_language_id of this AnalyticsAgentStateAgentSessionResult.
        Requested language Id

        :param requested_language_id: The requested_language_id of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        

        self._requested_language_id = requested_language_id

    @property
    def originating_direction(self) -> str:
        """
        Gets the originating_direction of this AnalyticsAgentStateAgentSessionResult.
        Originating direction

        :return: The originating_direction of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._originating_direction

    @originating_direction.setter
    def originating_direction(self, originating_direction: str) -> None:
        """
        Sets the originating_direction of this AnalyticsAgentStateAgentSessionResult.
        Originating direction

        :param originating_direction: The originating_direction of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        if isinstance(originating_direction, int):
            originating_direction = str(originating_direction)
        allowed_values = ["inbound", "outbound"]
        if originating_direction.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for originating_direction -> " + originating_direction)
            self._originating_direction = "outdated_sdk_version"
        else:
            self._originating_direction = originating_direction

    @property
    def media_type(self) -> str:
        """
        Gets the media_type of this AnalyticsAgentStateAgentSessionResult.
        Media type

        :return: The media_type of this AnalyticsAgentStateAgentSessionResult.
        :rtype: str
        """
        return self._media_type

    @media_type.setter
    def media_type(self, media_type: str) -> None:
        """
        Sets the media_type of this AnalyticsAgentStateAgentSessionResult.
        Media type

        :param media_type: The media_type of this AnalyticsAgentStateAgentSessionResult.
        :type: str
        """
        if isinstance(media_type, int):
            media_type = str(media_type)
        allowed_values = ["callback", "chat", "cobrowse", "email", "internalmessage", "message", "screenshare", "unknown", "video", "voice"]
        if media_type.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for media_type -> " + media_type)
            self._media_type = "outdated_sdk_version"
        else:
            self._media_type = media_type

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

