# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import CustomEventAttribute
    from . import JourneyApp
    from . import NetworkConnectivity
    from . import RequestDevice
    from . import SdkLibrary

class AppEventRequest(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AppEventRequest - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'event_name': 'str',
            'screen_name': 'str',
            'app': 'JourneyApp',
            'device': 'RequestDevice',
            'sdk_library': 'SdkLibrary',
            'network_connectivity': 'NetworkConnectivity',
            'referrer_url': 'str',
            'search_query': 'str',
            'attributes': 'dict(str, CustomEventAttribute)',
            'traits': 'dict(str, CustomEventAttribute)',
            'customer_cookie_id': 'str',
            'created_date': 'datetime'
        }

        self.attribute_map = {
            'event_name': 'eventName',
            'screen_name': 'screenName',
            'app': 'app',
            'device': 'device',
            'sdk_library': 'sdkLibrary',
            'network_connectivity': 'networkConnectivity',
            'referrer_url': 'referrerUrl',
            'search_query': 'searchQuery',
            'attributes': 'attributes',
            'traits': 'traits',
            'customer_cookie_id': 'customerCookieId',
            'created_date': 'createdDate'
        }

        self._event_name = None
        self._screen_name = None
        self._app = None
        self._device = None
        self._sdk_library = None
        self._network_connectivity = None
        self._referrer_url = None
        self._search_query = None
        self._attributes = None
        self._traits = None
        self._customer_cookie_id = None
        self._created_date = None

    @property
    def event_name(self) -> str:
        """
        Gets the event_name of this AppEventRequest.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. screen_viewed, search_performed, user_registered.

        :return: The event_name of this AppEventRequest.
        :rtype: str
        """
        return self._event_name

    @event_name.setter
    def event_name(self, event_name: str) -> None:
        """
        Sets the event_name of this AppEventRequest.
        Represents the action the customer performed. Event types are created for each unique event name and can be faceted on in segment and outcome conditions. A valid event name must only contain alphanumeric characters and underscores. A good event name is typically an object followed by the action performed in past tense, e.g. screen_viewed, search_performed, user_registered.

        :param event_name: The event_name of this AppEventRequest.
        :type: str
        """
        

        self._event_name = event_name

    @property
    def screen_name(self) -> str:
        """
        Gets the screen_name of this AppEventRequest.
        The name of the screen, view, or fragment in the app where the event took place.

        :return: The screen_name of this AppEventRequest.
        :rtype: str
        """
        return self._screen_name

    @screen_name.setter
    def screen_name(self, screen_name: str) -> None:
        """
        Sets the screen_name of this AppEventRequest.
        The name of the screen, view, or fragment in the app where the event took place.

        :param screen_name: The screen_name of this AppEventRequest.
        :type: str
        """
        

        self._screen_name = screen_name

    @property
    def app(self) -> 'JourneyApp':
        """
        Gets the app of this AppEventRequest.
        Application that the customer is interacting with.

        :return: The app of this AppEventRequest.
        :rtype: JourneyApp
        """
        return self._app

    @app.setter
    def app(self, app: 'JourneyApp') -> None:
        """
        Sets the app of this AppEventRequest.
        Application that the customer is interacting with.

        :param app: The app of this AppEventRequest.
        :type: JourneyApp
        """
        

        self._app = app

    @property
    def device(self) -> 'RequestDevice':
        """
        Gets the device of this AppEventRequest.
        Customer's device.

        :return: The device of this AppEventRequest.
        :rtype: RequestDevice
        """
        return self._device

    @device.setter
    def device(self, device: 'RequestDevice') -> None:
        """
        Sets the device of this AppEventRequest.
        Customer's device.

        :param device: The device of this AppEventRequest.
        :type: RequestDevice
        """
        

        self._device = device

    @property
    def sdk_library(self) -> 'SdkLibrary':
        """
        Gets the sdk_library of this AppEventRequest.
        SDK library used to generate the event.

        :return: The sdk_library of this AppEventRequest.
        :rtype: SdkLibrary
        """
        return self._sdk_library

    @sdk_library.setter
    def sdk_library(self, sdk_library: 'SdkLibrary') -> None:
        """
        Sets the sdk_library of this AppEventRequest.
        SDK library used to generate the event.

        :param sdk_library: The sdk_library of this AppEventRequest.
        :type: SdkLibrary
        """
        

        self._sdk_library = sdk_library

    @property
    def network_connectivity(self) -> 'NetworkConnectivity':
        """
        Gets the network_connectivity of this AppEventRequest.
        Information relating to the device's network connectivity.

        :return: The network_connectivity of this AppEventRequest.
        :rtype: NetworkConnectivity
        """
        return self._network_connectivity

    @network_connectivity.setter
    def network_connectivity(self, network_connectivity: 'NetworkConnectivity') -> None:
        """
        Sets the network_connectivity of this AppEventRequest.
        Information relating to the device's network connectivity.

        :param network_connectivity: The network_connectivity of this AppEventRequest.
        :type: NetworkConnectivity
        """
        

        self._network_connectivity = network_connectivity

    @property
    def referrer_url(self) -> str:
        """
        Gets the referrer_url of this AppEventRequest.
        The referrer URL of the first event in the app session.

        :return: The referrer_url of this AppEventRequest.
        :rtype: str
        """
        return self._referrer_url

    @referrer_url.setter
    def referrer_url(self, referrer_url: str) -> None:
        """
        Sets the referrer_url of this AppEventRequest.
        The referrer URL of the first event in the app session.

        :param referrer_url: The referrer_url of this AppEventRequest.
        :type: str
        """
        

        self._referrer_url = referrer_url

    @property
    def search_query(self) -> str:
        """
        Gets the search_query of this AppEventRequest.
        Represents the keywords in a customer search query.

        :return: The search_query of this AppEventRequest.
        :rtype: str
        """
        return self._search_query

    @search_query.setter
    def search_query(self, search_query: str) -> None:
        """
        Sets the search_query of this AppEventRequest.
        Represents the keywords in a customer search query.

        :param search_query: The search_query of this AppEventRequest.
        :type: str
        """
        

        self._search_query = search_query

    @property
    def attributes(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the attributes of this AppEventRequest.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :return: The attributes of this AppEventRequest.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._attributes

    @attributes.setter
    def attributes(self, attributes: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the attributes of this AppEventRequest.
        User-defined attributes associated with a particular event. These attributes provide additional context about the event. For example, items_in_cart or subscription_level.

        :param attributes: The attributes of this AppEventRequest.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._attributes = attributes

    @property
    def traits(self) -> Dict[str, 'CustomEventAttribute']:
        """
        Gets the traits of this AppEventRequest.
        Traits are attributes intrinsic to the customer that may be sent in selected events, (e.g. email, givenName, cellPhone). Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :return: The traits of this AppEventRequest.
        :rtype: dict(str, CustomEventAttribute)
        """
        return self._traits

    @traits.setter
    def traits(self, traits: Dict[str, 'CustomEventAttribute']) -> None:
        """
        Sets the traits of this AppEventRequest.
        Traits are attributes intrinsic to the customer that may be sent in selected events, (e.g. email, givenName, cellPhone). Traits are used to collect information for identity resolution. For example, the same person might be using an application on different devices which might create two sessions with different customerIds. Additional information can be provided as traits to help link those two sessions and customers to a single external contact through common identifiers that were submitted via a form fill, message, or other input in both sessions.

        :param traits: The traits of this AppEventRequest.
        :type: dict(str, CustomEventAttribute)
        """
        

        self._traits = traits

    @property
    def customer_cookie_id(self) -> str:
        """
        Gets the customer_cookie_id of this AppEventRequest.
        A UUID representing the customer associated with the app event. This is expected to be set per application install or device and can be used to identify a single customer across multiple sessions. This identifier, along with others passed as traits, is used for identity resolution.

        :return: The customer_cookie_id of this AppEventRequest.
        :rtype: str
        """
        return self._customer_cookie_id

    @customer_cookie_id.setter
    def customer_cookie_id(self, customer_cookie_id: str) -> None:
        """
        Sets the customer_cookie_id of this AppEventRequest.
        A UUID representing the customer associated with the app event. This is expected to be set per application install or device and can be used to identify a single customer across multiple sessions. This identifier, along with others passed as traits, is used for identity resolution.

        :param customer_cookie_id: The customer_cookie_id of this AppEventRequest.
        :type: str
        """
        

        self._customer_cookie_id = customer_cookie_id

    @property
    def created_date(self) -> datetime:
        """
        Gets the created_date of this AppEventRequest.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The created_date of this AppEventRequest.
        :rtype: datetime
        """
        return self._created_date

    @created_date.setter
    def created_date(self, created_date: datetime) -> None:
        """
        Sets the created_date of this AppEventRequest.
        UTC timestamp indicating when the event actually took place, events older than an hour will be rejected. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param created_date: The created_date of this AppEventRequest.
        :type: datetime
        """
        

        self._created_date = created_date

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

