# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import AddressableEntityRef
    from . import MetadataAttribute

class Article(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Article - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'title': 'str',
            'uri': 'str',
            'snippets': 'list[str]',
            'confidence': 'float',
            'metadata': 'dict(str, MetadataAttribute)',
            'version': 'AddressableEntityRef',
            'variations': 'list[AddressableEntityRef]'
        }

        self.attribute_map = {
            'title': 'title',
            'uri': 'uri',
            'snippets': 'snippets',
            'confidence': 'confidence',
            'metadata': 'metadata',
            'version': 'version',
            'variations': 'variations'
        }

        self._title = None
        self._uri = None
        self._snippets = None
        self._confidence = None
        self._metadata = None
        self._version = None
        self._variations = None

    @property
    def title(self) -> str:
        """
        Gets the title of this Article.
        The article title.

        :return: The title of this Article.
        :rtype: str
        """
        return self._title

    @title.setter
    def title(self, title: str) -> None:
        """
        Sets the title of this Article.
        The article title.

        :param title: The title of this Article.
        :type: str
        """
        

        self._title = title

    @property
    def uri(self) -> str:
        """
        Gets the uri of this Article.
        The URI for the article.

        :return: The uri of this Article.
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri: str) -> None:
        """
        Sets the uri of this Article.
        The URI for the article.

        :param uri: The uri of this Article.
        :type: str
        """
        

        self._uri = uri

    @property
    def snippets(self) -> List[str]:
        """
        Gets the snippets of this Article.
        This contains snippets of text from the article matching the query.

        :return: The snippets of this Article.
        :rtype: list[str]
        """
        return self._snippets

    @snippets.setter
    def snippets(self, snippets: List[str]) -> None:
        """
        Sets the snippets of this Article.
        This contains snippets of text from the article matching the query.

        :param snippets: The snippets of this Article.
        :type: list[str]
        """
        

        self._snippets = snippets

    @property
    def confidence(self) -> float:
        """
        Gets the confidence of this Article.
        Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all.

        :return: The confidence of this Article.
        :rtype: float
        """
        return self._confidence

    @confidence.setter
    def confidence(self, confidence: float) -> None:
        """
        Sets the confidence of this Article.
        Value between 0 and 1. 1 corresponds to very confident, 0 to not confident at all.

        :param confidence: The confidence of this Article.
        :type: float
        """
        

        self._confidence = confidence

    @property
    def metadata(self) -> Dict[str, 'MetadataAttribute']:
        """
        Gets the metadata of this Article.
        A map that contains custom metadata about the article answer.

        :return: The metadata of this Article.
        :rtype: dict(str, MetadataAttribute)
        """
        return self._metadata

    @metadata.setter
    def metadata(self, metadata: Dict[str, 'MetadataAttribute']) -> None:
        """
        Sets the metadata of this Article.
        A map that contains custom metadata about the article answer.

        :param metadata: The metadata of this Article.
        :type: dict(str, MetadataAttribute)
        """
        

        self._metadata = metadata

    @property
    def version(self) -> 'AddressableEntityRef':
        """
        Gets the version of this Article.
        The version of the Article.

        :return: The version of this Article.
        :rtype: AddressableEntityRef
        """
        return self._version

    @version.setter
    def version(self, version: 'AddressableEntityRef') -> None:
        """
        Sets the version of this Article.
        The version of the Article.

        :param version: The version of this Article.
        :type: AddressableEntityRef
        """
        

        self._version = version

    @property
    def variations(self) -> List['AddressableEntityRef']:
        """
        Gets the variations of this Article.
        Variations of the Article.

        :return: The variations of this Article.
        :rtype: list[AddressableEntityRef]
        """
        return self._variations

    @variations.setter
    def variations(self, variations: List['AddressableEntityRef']) -> None:
        """
        Sets the variations of this Article.
        Variations of the Article.

        :param variations: The variations of this Article.
        :type: list[AddressableEntityRef]
        """
        

        self._variations = variations

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

