# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import InvalidAssignment
    from . import OtherProfileAssignment
    from . import UserReference

class AssignmentValidation(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AssignmentValidation - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'members_not_assigned': 'list[UserReference]',
            'members_already_assigned': 'list[UserReference]',
            'members_already_assigned_to_other': 'list[OtherProfileAssignment]',
            'invalid_member_assignments': 'list[InvalidAssignment]'
        }

        self.attribute_map = {
            'members_not_assigned': 'membersNotAssigned',
            'members_already_assigned': 'membersAlreadyAssigned',
            'members_already_assigned_to_other': 'membersAlreadyAssignedToOther',
            'invalid_member_assignments': 'invalidMemberAssignments'
        }

        self._members_not_assigned = None
        self._members_already_assigned = None
        self._members_already_assigned_to_other = None
        self._invalid_member_assignments = None

    @property
    def members_not_assigned(self) -> List['UserReference']:
        """
        Gets the members_not_assigned of this AssignmentValidation.
        The list of users that are not assigned to any custom performance profile

        :return: The members_not_assigned of this AssignmentValidation.
        :rtype: list[UserReference]
        """
        return self._members_not_assigned

    @members_not_assigned.setter
    def members_not_assigned(self, members_not_assigned: List['UserReference']) -> None:
        """
        Sets the members_not_assigned of this AssignmentValidation.
        The list of users that are not assigned to any custom performance profile

        :param members_not_assigned: The members_not_assigned of this AssignmentValidation.
        :type: list[UserReference]
        """
        

        self._members_not_assigned = members_not_assigned

    @property
    def members_already_assigned(self) -> List['UserReference']:
        """
        Gets the members_already_assigned of this AssignmentValidation.
        The list of users that are already assigned to the requesting custom performance profile

        :return: The members_already_assigned of this AssignmentValidation.
        :rtype: list[UserReference]
        """
        return self._members_already_assigned

    @members_already_assigned.setter
    def members_already_assigned(self, members_already_assigned: List['UserReference']) -> None:
        """
        Sets the members_already_assigned of this AssignmentValidation.
        The list of users that are already assigned to the requesting custom performance profile

        :param members_already_assigned: The members_already_assigned of this AssignmentValidation.
        :type: list[UserReference]
        """
        

        self._members_already_assigned = members_already_assigned

    @property
    def members_already_assigned_to_other(self) -> List['OtherProfileAssignment']:
        """
        Gets the members_already_assigned_to_other of this AssignmentValidation.
        The list of users that are already assigned to other custom performance profiles

        :return: The members_already_assigned_to_other of this AssignmentValidation.
        :rtype: list[OtherProfileAssignment]
        """
        return self._members_already_assigned_to_other

    @members_already_assigned_to_other.setter
    def members_already_assigned_to_other(self, members_already_assigned_to_other: List['OtherProfileAssignment']) -> None:
        """
        Sets the members_already_assigned_to_other of this AssignmentValidation.
        The list of users that are already assigned to other custom performance profiles

        :param members_already_assigned_to_other: The members_already_assigned_to_other of this AssignmentValidation.
        :type: list[OtherProfileAssignment]
        """
        

        self._members_already_assigned_to_other = members_already_assigned_to_other

    @property
    def invalid_member_assignments(self) -> List['InvalidAssignment']:
        """
        Gets the invalid_member_assignments of this AssignmentValidation.
        The list of user id that are invalid for the gamfication service to handle

        :return: The invalid_member_assignments of this AssignmentValidation.
        :rtype: list[InvalidAssignment]
        """
        return self._invalid_member_assignments

    @invalid_member_assignments.setter
    def invalid_member_assignments(self, invalid_member_assignments: List['InvalidAssignment']) -> None:
        """
        Sets the invalid_member_assignments of this AssignmentValidation.
        The list of user id that are invalid for the gamfication service to handle

        :param invalid_member_assignments: The invalid_member_assignments of this AssignmentValidation.
        :type: list[InvalidAssignment]
        """
        

        self._invalid_member_assignments = invalid_member_assignments

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

