# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Copilot
    from . import GoogleDialogflowConfig
    from . import KnowledgeSuggestionConfig
    from . import TranscriptionConfig
    from . import UserReference

class Assistant(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        Assistant - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'date_created': 'datetime',
            'date_modified': 'datetime',
            'created_by': 'UserReference',
            'modified_by': 'UserReference',
            'google_dialogflow_config': 'GoogleDialogflowConfig',
            'transcription_config': 'TranscriptionConfig',
            'knowledge_suggestion_config': 'KnowledgeSuggestionConfig',
            'state': 'str',
            'copilot': 'Copilot',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'date_created': 'dateCreated',
            'date_modified': 'dateModified',
            'created_by': 'createdBy',
            'modified_by': 'modifiedBy',
            'google_dialogflow_config': 'googleDialogflowConfig',
            'transcription_config': 'transcriptionConfig',
            'knowledge_suggestion_config': 'knowledgeSuggestionConfig',
            'state': 'state',
            'copilot': 'copilot',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._date_created = None
        self._date_modified = None
        self._created_by = None
        self._modified_by = None
        self._google_dialogflow_config = None
        self._transcription_config = None
        self._knowledge_suggestion_config = None
        self._state = None
        self._copilot = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this Assistant.
        The globally unique identifier for the object.

        :return: The id of this Assistant.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this Assistant.
        The globally unique identifier for the object.

        :param id: The id of this Assistant.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this Assistant.
        The name of the assistant that will assist the agent.

        :return: The name of this Assistant.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this Assistant.
        The name of the assistant that will assist the agent.

        :param name: The name of this Assistant.
        :type: str
        """
        

        self._name = name

    @property
    def date_created(self) -> datetime:
        """
        Gets the date_created of this Assistant.
        Date when the assistant was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_created of this Assistant.
        :rtype: datetime
        """
        return self._date_created

    @date_created.setter
    def date_created(self, date_created: datetime) -> None:
        """
        Sets the date_created of this Assistant.
        Date when the assistant was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_created: The date_created of this Assistant.
        :type: datetime
        """
        

        self._date_created = date_created

    @property
    def date_modified(self) -> datetime:
        """
        Gets the date_modified of this Assistant.
        Date when the assistant was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_modified of this Assistant.
        :rtype: datetime
        """
        return self._date_modified

    @date_modified.setter
    def date_modified(self, date_modified: datetime) -> None:
        """
        Sets the date_modified of this Assistant.
        Date when the assistant was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_modified: The date_modified of this Assistant.
        :type: datetime
        """
        

        self._date_modified = date_modified

    @property
    def created_by(self) -> 'UserReference':
        """
        Gets the created_by of this Assistant.
        The user who created the assistant.

        :return: The created_by of this Assistant.
        :rtype: UserReference
        """
        return self._created_by

    @created_by.setter
    def created_by(self, created_by: 'UserReference') -> None:
        """
        Sets the created_by of this Assistant.
        The user who created the assistant.

        :param created_by: The created_by of this Assistant.
        :type: UserReference
        """
        

        self._created_by = created_by

    @property
    def modified_by(self) -> 'UserReference':
        """
        Gets the modified_by of this Assistant.
        The user who last modified the assistant.

        :return: The modified_by of this Assistant.
        :rtype: UserReference
        """
        return self._modified_by

    @modified_by.setter
    def modified_by(self, modified_by: 'UserReference') -> None:
        """
        Sets the modified_by of this Assistant.
        The user who last modified the assistant.

        :param modified_by: The modified_by of this Assistant.
        :type: UserReference
        """
        

        self._modified_by = modified_by

    @property
    def google_dialogflow_config(self) -> 'GoogleDialogflowConfig':
        """
        Gets the google_dialogflow_config of this Assistant.
        (Deprecated: use the 'knowledgeSuggestionConfig' for genesys knowledge suggestions) Configuration of Dialogflow used to assist the agent with transcriptions and knowledge suggestions.

        :return: The google_dialogflow_config of this Assistant.
        :rtype: GoogleDialogflowConfig
        """
        return self._google_dialogflow_config

    @google_dialogflow_config.setter
    def google_dialogflow_config(self, google_dialogflow_config: 'GoogleDialogflowConfig') -> None:
        """
        Sets the google_dialogflow_config of this Assistant.
        (Deprecated: use the 'knowledgeSuggestionConfig' for genesys knowledge suggestions) Configuration of Dialogflow used to assist the agent with transcriptions and knowledge suggestions.

        :param google_dialogflow_config: The google_dialogflow_config of this Assistant.
        :type: GoogleDialogflowConfig
        """
        

        self._google_dialogflow_config = google_dialogflow_config

    @property
    def transcription_config(self) -> 'TranscriptionConfig':
        """
        Gets the transcription_config of this Assistant.
        Configuration for speech transcription used to assist the agent.

        :return: The transcription_config of this Assistant.
        :rtype: TranscriptionConfig
        """
        return self._transcription_config

    @transcription_config.setter
    def transcription_config(self, transcription_config: 'TranscriptionConfig') -> None:
        """
        Sets the transcription_config of this Assistant.
        Configuration for speech transcription used to assist the agent.

        :param transcription_config: The transcription_config of this Assistant.
        :type: TranscriptionConfig
        """
        

        self._transcription_config = transcription_config

    @property
    def knowledge_suggestion_config(self) -> 'KnowledgeSuggestionConfig':
        """
        Gets the knowledge_suggestion_config of this Assistant.
        Configuration that defines how to produce knowledge suggestions.

        :return: The knowledge_suggestion_config of this Assistant.
        :rtype: KnowledgeSuggestionConfig
        """
        return self._knowledge_suggestion_config

    @knowledge_suggestion_config.setter
    def knowledge_suggestion_config(self, knowledge_suggestion_config: 'KnowledgeSuggestionConfig') -> None:
        """
        Sets the knowledge_suggestion_config of this Assistant.
        Configuration that defines how to produce knowledge suggestions.

        :param knowledge_suggestion_config: The knowledge_suggestion_config of this Assistant.
        :type: KnowledgeSuggestionConfig
        """
        

        self._knowledge_suggestion_config = knowledge_suggestion_config

    @property
    def state(self) -> str:
        """
        Gets the state of this Assistant.
        State of the assistant.

        :return: The state of this Assistant.
        :rtype: str
        """
        return self._state

    @state.setter
    def state(self, state: str) -> None:
        """
        Sets the state of this Assistant.
        State of the assistant.

        :param state: The state of this Assistant.
        :type: str
        """
        if isinstance(state, int):
            state = str(state)
        allowed_values = ["Active", "Inactive"]
        if state.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for state -> " + state)
            self._state = "outdated_sdk_version"
        else:
            self._state = state

    @property
    def copilot(self) -> 'Copilot':
        """
        Gets the copilot of this Assistant.
        Agent copilot configuration.

        :return: The copilot of this Assistant.
        :rtype: Copilot
        """
        return self._copilot

    @copilot.setter
    def copilot(self, copilot: 'Copilot') -> None:
        """
        Sets the copilot of this Assistant.
        Agent copilot configuration.

        :param copilot: The copilot of this Assistant.
        :type: Copilot
        """
        

        self._copilot = copilot

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this Assistant.
        The URI for this object

        :return: The self_uri of this Assistant.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this Assistant.
        The URI for this object

        :param self_uri: The self_uri of this Assistant.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

