# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AuthorizationSettings(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AuthorizationSettings - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'analysis_enabled': 'bool',
            'analysis_days': 'int',
            'date_last_calculated': 'datetime',
            'date_last_active': 'date',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'analysis_enabled': 'analysisEnabled',
            'analysis_days': 'analysisDays',
            'date_last_calculated': 'dateLastCalculated',
            'date_last_active': 'dateLastActive',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._analysis_enabled = None
        self._analysis_days = None
        self._date_last_calculated = None
        self._date_last_active = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this AuthorizationSettings.
        The globally unique identifier for the object.

        :return: The id of this AuthorizationSettings.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this AuthorizationSettings.
        The globally unique identifier for the object.

        :param id: The id of this AuthorizationSettings.
        :type: str
        """
        

        self._id = id

    @property
    def analysis_enabled(self) -> bool:
        """
        Gets the analysis_enabled of this AuthorizationSettings.
        Boolean showing if organization is opted in or not to unused role/perm analysis

        :return: The analysis_enabled of this AuthorizationSettings.
        :rtype: bool
        """
        return self._analysis_enabled

    @analysis_enabled.setter
    def analysis_enabled(self, analysis_enabled: bool) -> None:
        """
        Sets the analysis_enabled of this AuthorizationSettings.
        Boolean showing if organization is opted in or not to unused role/perm analysis

        :param analysis_enabled: The analysis_enabled of this AuthorizationSettings.
        :type: bool
        """
        

        self._analysis_enabled = analysis_enabled

    @property
    def analysis_days(self) -> int:
        """
        Gets the analysis_days of this AuthorizationSettings.
        Integer number of days to analyze user usage

        :return: The analysis_days of this AuthorizationSettings.
        :rtype: int
        """
        return self._analysis_days

    @analysis_days.setter
    def analysis_days(self, analysis_days: int) -> None:
        """
        Sets the analysis_days of this AuthorizationSettings.
        Integer number of days to analyze user usage

        :param analysis_days: The analysis_days of this AuthorizationSettings.
        :type: int
        """
        

        self._analysis_days = analysis_days

    @property
    def date_last_calculated(self) -> datetime:
        """
        Gets the date_last_calculated of this AuthorizationSettings.
        The date and time of the most recent unused role calculation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The date_last_calculated of this AuthorizationSettings.
        :rtype: datetime
        """
        return self._date_last_calculated

    @date_last_calculated.setter
    def date_last_calculated(self, date_last_calculated: datetime) -> None:
        """
        Sets the date_last_calculated of this AuthorizationSettings.
        The date and time of the most recent unused role calculation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param date_last_calculated: The date_last_calculated of this AuthorizationSettings.
        :type: datetime
        """
        

        self._date_last_calculated = date_last_calculated

    @property
    def date_last_active(self) -> date:
        """
        Gets the date_last_active of this AuthorizationSettings.
        The date of the most recent org activity used for analysis. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_last_active of this AuthorizationSettings.
        :rtype: date
        """
        return self._date_last_active

    @date_last_active.setter
    def date_last_active(self, date_last_active: date) -> None:
        """
        Sets the date_last_active of this AuthorizationSettings.
        The date of the most recent org activity used for analysis. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_last_active: The date_last_active of this AuthorizationSettings.
        :type: date
        """
        

        self._date_last_active = date_last_active

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this AuthorizationSettings.
        The URI for this object

        :return: The self_uri of this AuthorizationSettings.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this AuthorizationSettings.
        The URI for this object

        :param self_uri: The self_uri of this AuthorizationSettings.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

