# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class AvailabilityRange(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        AvailabilityRange - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'earliest_start_minutes_from_midnight': 'int',
            'latest_end_minutes_from_midnight': 'int'
        }

        self.attribute_map = {
            'earliest_start_minutes_from_midnight': 'earliestStartMinutesFromMidnight',
            'latest_end_minutes_from_midnight': 'latestEndMinutesFromMidnight'
        }

        self._earliest_start_minutes_from_midnight = None
        self._latest_end_minutes_from_midnight = None

    @property
    def earliest_start_minutes_from_midnight(self) -> int:
        """
        Gets the earliest_start_minutes_from_midnight of this AvailabilityRange.
        The earliest time of day the activity can be scheduled to begin, in minutes from midnight in the configured time zone of the business unit

        :return: The earliest_start_minutes_from_midnight of this AvailabilityRange.
        :rtype: int
        """
        return self._earliest_start_minutes_from_midnight

    @earliest_start_minutes_from_midnight.setter
    def earliest_start_minutes_from_midnight(self, earliest_start_minutes_from_midnight: int) -> None:
        """
        Sets the earliest_start_minutes_from_midnight of this AvailabilityRange.
        The earliest time of day the activity can be scheduled to begin, in minutes from midnight in the configured time zone of the business unit

        :param earliest_start_minutes_from_midnight: The earliest_start_minutes_from_midnight of this AvailabilityRange.
        :type: int
        """
        

        self._earliest_start_minutes_from_midnight = earliest_start_minutes_from_midnight

    @property
    def latest_end_minutes_from_midnight(self) -> int:
        """
        Gets the latest_end_minutes_from_midnight of this AvailabilityRange.
        The latest time of day the activity can be scheduled to end, in minutes from midnight in the configured time zone of the business unit

        :return: The latest_end_minutes_from_midnight of this AvailabilityRange.
        :rtype: int
        """
        return self._latest_end_minutes_from_midnight

    @latest_end_minutes_from_midnight.setter
    def latest_end_minutes_from_midnight(self, latest_end_minutes_from_midnight: int) -> None:
        """
        Sets the latest_end_minutes_from_midnight of this AvailabilityRange.
        The latest time of day the activity can be scheduled to end, in minutes from midnight in the configured time zone of the business unit

        :param latest_end_minutes_from_midnight: The latest_end_minutes_from_midnight of this AvailabilityRange.
        :type: int
        """
        

        self._latest_end_minutes_from_midnight = latest_end_minutes_from_midnight

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

