# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingProduct
    from . import NamedEntity

class BillingCharge(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingCharge - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'product': 'BillingProduct',
            'organizations': 'list[NamedEntity]',
            'getprepaid_quantity': 'int',
            'getfairuse_quantity': 'int',
            'getactual_quantity': 'int',
            'getoverage_quantity': 'int',
            'overage_rate': 'float',
            'overage_charge': 'float',
            'overage_currency': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'product': 'product',
            'organizations': 'organizations',
            'getprepaid_quantity': 'getprepaidQuantity',
            'getfairuse_quantity': 'getfairuseQuantity',
            'getactual_quantity': 'getactualQuantity',
            'getoverage_quantity': 'getoverageQuantity',
            'overage_rate': 'overageRate',
            'overage_charge': 'overageCharge',
            'overage_currency': 'overageCurrency'
        }

        self._id = None
        self._product = None
        self._organizations = None
        self._getprepaid_quantity = None
        self._getfairuse_quantity = None
        self._getactual_quantity = None
        self._getoverage_quantity = None
        self._overage_rate = None
        self._overage_charge = None
        self._overage_currency = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingCharge.
        The globally unique identifier for the object.

        :return: The id of this BillingCharge.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingCharge.
        The globally unique identifier for the object.

        :param id: The id of this BillingCharge.
        :type: str
        """
        

        self._id = id

    @property
    def product(self) -> 'BillingProduct':
        """
        Gets the product of this BillingCharge.
        Represents the details of a product.

        :return: The product of this BillingCharge.
        :rtype: BillingProduct
        """
        return self._product

    @product.setter
    def product(self, product: 'BillingProduct') -> None:
        """
        Sets the product of this BillingCharge.
        Represents the details of a product.

        :param product: The product of this BillingCharge.
        :type: BillingProduct
        """
        

        self._product = product

    @property
    def organizations(self) -> List['NamedEntity']:
        """
        Gets the organizations of this BillingCharge.
        List of plans within the organization.

        :return: The organizations of this BillingCharge.
        :rtype: list[NamedEntity]
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations: List['NamedEntity']) -> None:
        """
        Sets the organizations of this BillingCharge.
        List of plans within the organization.

        :param organizations: The organizations of this BillingCharge.
        :type: list[NamedEntity]
        """
        

        self._organizations = organizations

    @property
    def getprepaid_quantity(self) -> int:
        """
        Gets the getprepaid_quantity of this BillingCharge.
        The quantity of usage that is prepaid.

        :return: The getprepaid_quantity of this BillingCharge.
        :rtype: int
        """
        return self._getprepaid_quantity

    @getprepaid_quantity.setter
    def getprepaid_quantity(self, getprepaid_quantity: int) -> None:
        """
        Sets the getprepaid_quantity of this BillingCharge.
        The quantity of usage that is prepaid.

        :param getprepaid_quantity: The getprepaid_quantity of this BillingCharge.
        :type: int
        """
        

        self._getprepaid_quantity = getprepaid_quantity

    @property
    def getfairuse_quantity(self) -> int:
        """
        Gets the getfairuse_quantity of this BillingCharge.
        The quantity of usage allowed under fair use policies.

        :return: The getfairuse_quantity of this BillingCharge.
        :rtype: int
        """
        return self._getfairuse_quantity

    @getfairuse_quantity.setter
    def getfairuse_quantity(self, getfairuse_quantity: int) -> None:
        """
        Sets the getfairuse_quantity of this BillingCharge.
        The quantity of usage allowed under fair use policies.

        :param getfairuse_quantity: The getfairuse_quantity of this BillingCharge.
        :type: int
        """
        

        self._getfairuse_quantity = getfairuse_quantity

    @property
    def getactual_quantity(self) -> int:
        """
        Gets the getactual_quantity of this BillingCharge.
        The actual quantity of usage.

        :return: The getactual_quantity of this BillingCharge.
        :rtype: int
        """
        return self._getactual_quantity

    @getactual_quantity.setter
    def getactual_quantity(self, getactual_quantity: int) -> None:
        """
        Sets the getactual_quantity of this BillingCharge.
        The actual quantity of usage.

        :param getactual_quantity: The getactual_quantity of this BillingCharge.
        :type: int
        """
        

        self._getactual_quantity = getactual_quantity

    @property
    def getoverage_quantity(self) -> int:
        """
        Gets the getoverage_quantity of this BillingCharge.
        The quantity of usage that exceeds prepaid or fair use limits.

        :return: The getoverage_quantity of this BillingCharge.
        :rtype: int
        """
        return self._getoverage_quantity

    @getoverage_quantity.setter
    def getoverage_quantity(self, getoverage_quantity: int) -> None:
        """
        Sets the getoverage_quantity of this BillingCharge.
        The quantity of usage that exceeds prepaid or fair use limits.

        :param getoverage_quantity: The getoverage_quantity of this BillingCharge.
        :type: int
        """
        

        self._getoverage_quantity = getoverage_quantity

    @property
    def overage_rate(self) -> float:
        """
        Gets the overage_rate of this BillingCharge.
        The rate charged per unit of overage.

        :return: The overage_rate of this BillingCharge.
        :rtype: float
        """
        return self._overage_rate

    @overage_rate.setter
    def overage_rate(self, overage_rate: float) -> None:
        """
        Sets the overage_rate of this BillingCharge.
        The rate charged per unit of overage.

        :param overage_rate: The overage_rate of this BillingCharge.
        :type: float
        """
        

        self._overage_rate = overage_rate

    @property
    def overage_charge(self) -> float:
        """
        Gets the overage_charge of this BillingCharge.
        The total charge for overage usage.

        :return: The overage_charge of this BillingCharge.
        :rtype: float
        """
        return self._overage_charge

    @overage_charge.setter
    def overage_charge(self, overage_charge: float) -> None:
        """
        Sets the overage_charge of this BillingCharge.
        The total charge for overage usage.

        :param overage_charge: The overage_charge of this BillingCharge.
        :type: float
        """
        

        self._overage_charge = overage_charge

    @property
    def overage_currency(self) -> str:
        """
        Gets the overage_currency of this BillingCharge.
        The currency in which the overage charge is billed.

        :return: The overage_currency of this BillingCharge.
        :rtype: str
        """
        return self._overage_currency

    @overage_currency.setter
    def overage_currency(self, overage_currency: str) -> None:
        """
        Sets the overage_currency of this BillingCharge.
        The currency in which the overage charge is billed.

        :param overage_currency: The overage_currency of this BillingCharge.
        :type: str
        """
        

        self._overage_currency = overage_currency

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

