# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingContractPeriod
    from . import BillingPlan
    from . import Customer

class BillingContract(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingContract - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'external_number': 'str',
            'status': 'str',
            'commercial_model': 'str',
            'getpurchase_order_numbers': 'list[str]',
            'bill_to_customer': 'Customer',
            'sold_to_customer': 'Customer',
            'end_customer': 'Customer',
            'date_start': 'date',
            'date_end': 'date',
            'date_ramp_start': 'date',
            'date_ramp_end': 'date',
            'billing_periods': 'list[BillingContractPeriod]',
            'plans': 'list[BillingPlan]'
        }

        self.attribute_map = {
            'id': 'id',
            'external_number': 'externalNumber',
            'status': 'status',
            'commercial_model': 'commercialModel',
            'getpurchase_order_numbers': 'getpurchaseOrderNumbers',
            'bill_to_customer': 'billToCustomer',
            'sold_to_customer': 'soldToCustomer',
            'end_customer': 'endCustomer',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'date_ramp_start': 'dateRampStart',
            'date_ramp_end': 'dateRampEnd',
            'billing_periods': 'billingPeriods',
            'plans': 'plans'
        }

        self._id = None
        self._external_number = None
        self._status = None
        self._commercial_model = None
        self._getpurchase_order_numbers = None
        self._bill_to_customer = None
        self._sold_to_customer = None
        self._end_customer = None
        self._date_start = None
        self._date_end = None
        self._date_ramp_start = None
        self._date_ramp_end = None
        self._billing_periods = None
        self._plans = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingContract.
        The globally unique identifier for the object.

        :return: The id of this BillingContract.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingContract.
        The globally unique identifier for the object.

        :param id: The id of this BillingContract.
        :type: str
        """
        

        self._id = id

    @property
    def external_number(self) -> str:
        """
        Gets the external_number of this BillingContract.
        Unique external number.

        :return: The external_number of this BillingContract.
        :rtype: str
        """
        return self._external_number

    @external_number.setter
    def external_number(self, external_number: str) -> None:
        """
        Sets the external_number of this BillingContract.
        Unique external number.

        :param external_number: The external_number of this BillingContract.
        :type: str
        """
        

        self._external_number = external_number

    @property
    def status(self) -> str:
        """
        Gets the status of this BillingContract.
        The status of the contract.

        :return: The status of this BillingContract.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this BillingContract.
        The status of the contract.

        :param status: The status of this BillingContract.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Active", "Inactive"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def commercial_model(self) -> str:
        """
        Gets the commercial_model of this BillingContract.
        The type of commercial model.

        :return: The commercial_model of this BillingContract.
        :rtype: str
        """
        return self._commercial_model

    @commercial_model.setter
    def commercial_model(self, commercial_model: str) -> None:
        """
        Sets the commercial_model of this BillingContract.
        The type of commercial model.

        :param commercial_model: The commercial_model of this BillingContract.
        :type: str
        """
        

        self._commercial_model = commercial_model

    @property
    def getpurchase_order_numbers(self) -> List[str]:
        """
        Gets the getpurchase_order_numbers of this BillingContract.
        List of po numbers periods for this contract.

        :return: The getpurchase_order_numbers of this BillingContract.
        :rtype: list[str]
        """
        return self._getpurchase_order_numbers

    @getpurchase_order_numbers.setter
    def getpurchase_order_numbers(self, getpurchase_order_numbers: List[str]) -> None:
        """
        Sets the getpurchase_order_numbers of this BillingContract.
        List of po numbers periods for this contract.

        :param getpurchase_order_numbers: The getpurchase_order_numbers of this BillingContract.
        :type: list[str]
        """
        

        self._getpurchase_order_numbers = getpurchase_order_numbers

    @property
    def bill_to_customer(self) -> 'Customer':
        """
        Gets the bill_to_customer of this BillingContract.
        The bill to customer.

        :return: The bill_to_customer of this BillingContract.
        :rtype: Customer
        """
        return self._bill_to_customer

    @bill_to_customer.setter
    def bill_to_customer(self, bill_to_customer: 'Customer') -> None:
        """
        Sets the bill_to_customer of this BillingContract.
        The bill to customer.

        :param bill_to_customer: The bill_to_customer of this BillingContract.
        :type: Customer
        """
        

        self._bill_to_customer = bill_to_customer

    @property
    def sold_to_customer(self) -> 'Customer':
        """
        Gets the sold_to_customer of this BillingContract.
        The sold to customer.

        :return: The sold_to_customer of this BillingContract.
        :rtype: Customer
        """
        return self._sold_to_customer

    @sold_to_customer.setter
    def sold_to_customer(self, sold_to_customer: 'Customer') -> None:
        """
        Sets the sold_to_customer of this BillingContract.
        The sold to customer.

        :param sold_to_customer: The sold_to_customer of this BillingContract.
        :type: Customer
        """
        

        self._sold_to_customer = sold_to_customer

    @property
    def end_customer(self) -> 'Customer':
        """
        Gets the end_customer of this BillingContract.
        The end customer.

        :return: The end_customer of this BillingContract.
        :rtype: Customer
        """
        return self._end_customer

    @end_customer.setter
    def end_customer(self, end_customer: 'Customer') -> None:
        """
        Sets the end_customer of this BillingContract.
        The end customer.

        :param end_customer: The end_customer of this BillingContract.
        :type: Customer
        """
        

        self._end_customer = end_customer

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this BillingContract.
        The start date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this BillingContract.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this BillingContract.
        The start date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this BillingContract.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this BillingContract.
        The end date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this BillingContract.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this BillingContract.
        The end date of the contract. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this BillingContract.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def date_ramp_start(self) -> date:
        """
        Gets the date_ramp_start of this BillingContract.
        the date when the first revenue or quantity in a ramped deal begins. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_ramp_start of this BillingContract.
        :rtype: date
        """
        return self._date_ramp_start

    @date_ramp_start.setter
    def date_ramp_start(self, date_ramp_start: date) -> None:
        """
        Sets the date_ramp_start of this BillingContract.
        the date when the first revenue or quantity in a ramped deal begins. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_ramp_start: The date_ramp_start of this BillingContract.
        :type: date
        """
        

        self._date_ramp_start = date_ramp_start

    @property
    def date_ramp_end(self) -> date:
        """
        Gets the date_ramp_end of this BillingContract.
        the date when the first revenue or quantity in a ramped deal ends. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_ramp_end of this BillingContract.
        :rtype: date
        """
        return self._date_ramp_end

    @date_ramp_end.setter
    def date_ramp_end(self, date_ramp_end: date) -> None:
        """
        Sets the date_ramp_end of this BillingContract.
        the date when the first revenue or quantity in a ramped deal ends. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_ramp_end: The date_ramp_end of this BillingContract.
        :type: date
        """
        

        self._date_ramp_end = date_ramp_end

    @property
    def billing_periods(self) -> List['BillingContractPeriod']:
        """
        Gets the billing_periods of this BillingContract.
        List of billing periods for the contract.

        :return: The billing_periods of this BillingContract.
        :rtype: list[BillingContractPeriod]
        """
        return self._billing_periods

    @billing_periods.setter
    def billing_periods(self, billing_periods: List['BillingContractPeriod']) -> None:
        """
        Sets the billing_periods of this BillingContract.
        List of billing periods for the contract.

        :param billing_periods: The billing_periods of this BillingContract.
        :type: list[BillingContractPeriod]
        """
        

        self._billing_periods = billing_periods

    @property
    def plans(self) -> List['BillingPlan']:
        """
        Gets the plans of this BillingContract.
        The collection of prices for the related organizations.

        :return: The plans of this BillingContract.
        :rtype: list[BillingPlan]
        """
        return self._plans

    @plans.setter
    def plans(self, plans: List['BillingPlan']) -> None:
        """
        Sets the plans of this BillingContract.
        The collection of prices for the related organizations.

        :param plans: The plans of this BillingContract.
        :type: list[BillingPlan]
        """
        

        self._plans = plans

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

