# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingCharge
    from . import BillingWallet

class BillingContractPeriodDetail(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingContractPeriodDetail - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'date_start': 'date',
            'date_end': 'date',
            'status': 'str',
            'charges': 'list[BillingCharge]',
            'wallets': 'list[BillingWallet]'
        }

        self.attribute_map = {
            'id': 'id',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'status': 'status',
            'charges': 'charges',
            'wallets': 'wallets'
        }

        self._id = None
        self._date_start = None
        self._date_end = None
        self._status = None
        self._charges = None
        self._wallets = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingContractPeriodDetail.
        The globally unique identifier for the object.

        :return: The id of this BillingContractPeriodDetail.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingContractPeriodDetail.
        The globally unique identifier for the object.

        :param id: The id of this BillingContractPeriodDetail.
        :type: str
        """
        

        self._id = id

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this BillingContractPeriodDetail.
        The date when the Billing Period starts. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this BillingContractPeriodDetail.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this BillingContractPeriodDetail.
        The date when the Billing Period starts. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this BillingContractPeriodDetail.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this BillingContractPeriodDetail.
        The date when the Billing Period starts. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this BillingContractPeriodDetail.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this BillingContractPeriodDetail.
        The date when the Billing Period starts. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this BillingContractPeriodDetail.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def status(self) -> str:
        """
        Gets the status of this BillingContractPeriodDetail.
        The type of address.

        :return: The status of this BillingContractPeriodDetail.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this BillingContractPeriodDetail.
        The type of address.

        :param status: The status of this BillingContractPeriodDetail.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["Open", "Closed"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def charges(self) -> List['BillingCharge']:
        """
        Gets the charges of this BillingContractPeriodDetail.
        Represents usage metrics including prepaid, actual, and overage quantities along with associated charges.

        :return: The charges of this BillingContractPeriodDetail.
        :rtype: list[BillingCharge]
        """
        return self._charges

    @charges.setter
    def charges(self, charges: List['BillingCharge']) -> None:
        """
        Sets the charges of this BillingContractPeriodDetail.
        Represents usage metrics including prepaid, actual, and overage quantities along with associated charges.

        :param charges: The charges of this BillingContractPeriodDetail.
        :type: list[BillingCharge]
        """
        

        self._charges = charges

    @property
    def wallets(self) -> List['BillingWallet']:
        """
        Gets the wallets of this BillingContractPeriodDetail.
        Represents usage metrics including prepaid, actual, and overage quantities along with associated charges.

        :return: The wallets of this BillingContractPeriodDetail.
        :rtype: list[BillingWallet]
        """
        return self._wallets

    @wallets.setter
    def wallets(self, wallets: List['BillingWallet']) -> None:
        """
        Sets the wallets of this BillingContractPeriodDetail.
        Represents usage metrics including prepaid, actual, and overage quantities along with associated charges.

        :param wallets: The wallets of this BillingContractPeriodDetail.
        :type: list[BillingWallet]
        """
        

        self._wallets = wallets

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

