# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import Customer
    from . import InvoiceAddress

class BillingInvoice(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingInvoice - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'bill_to_customer': 'Customer',
            'ship_to_customer': 'Customer',
            'sold_to_customer': 'Customer',
            'date_invoiced': 'date',
            'bill_to_address': 'InvoiceAddress',
            'ship_to_address': 'InvoiceAddress',
            'currency_iso_code': 'str',
            'payment_status': 'str',
            'payment_terms': 'str',
            'payment_link': 'str',
            'customer_po_number': 'str',
            'customer_invoice_type': 'str',
            'amount': 'float'
        }

        self.attribute_map = {
            'id': 'id',
            'bill_to_customer': 'billToCustomer',
            'ship_to_customer': 'shipToCustomer',
            'sold_to_customer': 'soldToCustomer',
            'date_invoiced': 'dateInvoiced',
            'bill_to_address': 'billToAddress',
            'ship_to_address': 'shipToAddress',
            'currency_iso_code': 'currencyIsoCode',
            'payment_status': 'paymentStatus',
            'payment_terms': 'paymentTerms',
            'payment_link': 'paymentLink',
            'customer_po_number': 'customerPoNumber',
            'customer_invoice_type': 'customerInvoiceType',
            'amount': 'amount'
        }

        self._id = None
        self._bill_to_customer = None
        self._ship_to_customer = None
        self._sold_to_customer = None
        self._date_invoiced = None
        self._bill_to_address = None
        self._ship_to_address = None
        self._currency_iso_code = None
        self._payment_status = None
        self._payment_terms = None
        self._payment_link = None
        self._customer_po_number = None
        self._customer_invoice_type = None
        self._amount = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingInvoice.
        The globally unique identifier for the object.

        :return: The id of this BillingInvoice.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingInvoice.
        The globally unique identifier for the object.

        :param id: The id of this BillingInvoice.
        :type: str
        """
        

        self._id = id

    @property
    def bill_to_customer(self) -> 'Customer':
        """
        Gets the bill_to_customer of this BillingInvoice.
        The bill to customer.

        :return: The bill_to_customer of this BillingInvoice.
        :rtype: Customer
        """
        return self._bill_to_customer

    @bill_to_customer.setter
    def bill_to_customer(self, bill_to_customer: 'Customer') -> None:
        """
        Sets the bill_to_customer of this BillingInvoice.
        The bill to customer.

        :param bill_to_customer: The bill_to_customer of this BillingInvoice.
        :type: Customer
        """
        

        self._bill_to_customer = bill_to_customer

    @property
    def ship_to_customer(self) -> 'Customer':
        """
        Gets the ship_to_customer of this BillingInvoice.
        The ship to customer.

        :return: The ship_to_customer of this BillingInvoice.
        :rtype: Customer
        """
        return self._ship_to_customer

    @ship_to_customer.setter
    def ship_to_customer(self, ship_to_customer: 'Customer') -> None:
        """
        Sets the ship_to_customer of this BillingInvoice.
        The ship to customer.

        :param ship_to_customer: The ship_to_customer of this BillingInvoice.
        :type: Customer
        """
        

        self._ship_to_customer = ship_to_customer

    @property
    def sold_to_customer(self) -> 'Customer':
        """
        Gets the sold_to_customer of this BillingInvoice.
        The sold to customer.

        :return: The sold_to_customer of this BillingInvoice.
        :rtype: Customer
        """
        return self._sold_to_customer

    @sold_to_customer.setter
    def sold_to_customer(self, sold_to_customer: 'Customer') -> None:
        """
        Sets the sold_to_customer of this BillingInvoice.
        The sold to customer.

        :param sold_to_customer: The sold_to_customer of this BillingInvoice.
        :type: Customer
        """
        

        self._sold_to_customer = sold_to_customer

    @property
    def date_invoiced(self) -> date:
        """
        Gets the date_invoiced of this BillingInvoice.
        Date when the invoice was issued. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_invoiced of this BillingInvoice.
        :rtype: date
        """
        return self._date_invoiced

    @date_invoiced.setter
    def date_invoiced(self, date_invoiced: date) -> None:
        """
        Sets the date_invoiced of this BillingInvoice.
        Date when the invoice was issued. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_invoiced: The date_invoiced of this BillingInvoice.
        :type: date
        """
        

        self._date_invoiced = date_invoiced

    @property
    def bill_to_address(self) -> 'InvoiceAddress':
        """
        Gets the bill_to_address of this BillingInvoice.
        Details of the bill to address.

        :return: The bill_to_address of this BillingInvoice.
        :rtype: InvoiceAddress
        """
        return self._bill_to_address

    @bill_to_address.setter
    def bill_to_address(self, bill_to_address: 'InvoiceAddress') -> None:
        """
        Sets the bill_to_address of this BillingInvoice.
        Details of the bill to address.

        :param bill_to_address: The bill_to_address of this BillingInvoice.
        :type: InvoiceAddress
        """
        

        self._bill_to_address = bill_to_address

    @property
    def ship_to_address(self) -> 'InvoiceAddress':
        """
        Gets the ship_to_address of this BillingInvoice.
        Details of the ship to address.

        :return: The ship_to_address of this BillingInvoice.
        :rtype: InvoiceAddress
        """
        return self._ship_to_address

    @ship_to_address.setter
    def ship_to_address(self, ship_to_address: 'InvoiceAddress') -> None:
        """
        Sets the ship_to_address of this BillingInvoice.
        Details of the ship to address.

        :param ship_to_address: The ship_to_address of this BillingInvoice.
        :type: InvoiceAddress
        """
        

        self._ship_to_address = ship_to_address

    @property
    def currency_iso_code(self) -> str:
        """
        Gets the currency_iso_code of this BillingInvoice.
        Contains the ISO code for any currency allowed by the organization.

        :return: The currency_iso_code of this BillingInvoice.
        :rtype: str
        """
        return self._currency_iso_code

    @currency_iso_code.setter
    def currency_iso_code(self, currency_iso_code: str) -> None:
        """
        Sets the currency_iso_code of this BillingInvoice.
        Contains the ISO code for any currency allowed by the organization.

        :param currency_iso_code: The currency_iso_code of this BillingInvoice.
        :type: str
        """
        

        self._currency_iso_code = currency_iso_code

    @property
    def payment_status(self) -> str:
        """
        Gets the payment_status of this BillingInvoice.
        Status of the payment.

        :return: The payment_status of this BillingInvoice.
        :rtype: str
        """
        return self._payment_status

    @payment_status.setter
    def payment_status(self, payment_status: str) -> None:
        """
        Sets the payment_status of this BillingInvoice.
        Status of the payment.

        :param payment_status: The payment_status of this BillingInvoice.
        :type: str
        """
        if isinstance(payment_status, int):
            payment_status = str(payment_status)
        allowed_values = ["Paid", "Unpaid"]
        if payment_status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for payment_status -> " + payment_status)
            self._payment_status = "outdated_sdk_version"
        else:
            self._payment_status = payment_status

    @property
    def payment_terms(self) -> str:
        """
        Gets the payment_terms of this BillingInvoice.
        Payment terms.

        :return: The payment_terms of this BillingInvoice.
        :rtype: str
        """
        return self._payment_terms

    @payment_terms.setter
    def payment_terms(self, payment_terms: str) -> None:
        """
        Sets the payment_terms of this BillingInvoice.
        Payment terms.

        :param payment_terms: The payment_terms of this BillingInvoice.
        :type: str
        """
        

        self._payment_terms = payment_terms

    @property
    def payment_link(self) -> str:
        """
        Gets the payment_link of this BillingInvoice.
        Payment link.

        :return: The payment_link of this BillingInvoice.
        :rtype: str
        """
        return self._payment_link

    @payment_link.setter
    def payment_link(self, payment_link: str) -> None:
        """
        Sets the payment_link of this BillingInvoice.
        Payment link.

        :param payment_link: The payment_link of this BillingInvoice.
        :type: str
        """
        

        self._payment_link = payment_link

    @property
    def customer_po_number(self) -> str:
        """
        Gets the customer_po_number of this BillingInvoice.
        Purchase Order Number.

        :return: The customer_po_number of this BillingInvoice.
        :rtype: str
        """
        return self._customer_po_number

    @customer_po_number.setter
    def customer_po_number(self, customer_po_number: str) -> None:
        """
        Sets the customer_po_number of this BillingInvoice.
        Purchase Order Number.

        :param customer_po_number: The customer_po_number of this BillingInvoice.
        :type: str
        """
        

        self._customer_po_number = customer_po_number

    @property
    def customer_invoice_type(self) -> str:
        """
        Gets the customer_invoice_type of this BillingInvoice.
        Type of the invoice.

        :return: The customer_invoice_type of this BillingInvoice.
        :rtype: str
        """
        return self._customer_invoice_type

    @customer_invoice_type.setter
    def customer_invoice_type(self, customer_invoice_type: str) -> None:
        """
        Sets the customer_invoice_type of this BillingInvoice.
        Type of the invoice.

        :param customer_invoice_type: The customer_invoice_type of this BillingInvoice.
        :type: str
        """
        

        self._customer_invoice_type = customer_invoice_type

    @property
    def amount(self) -> float:
        """
        Gets the amount of this BillingInvoice.
        Amount.

        :return: The amount of this BillingInvoice.
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount: float) -> None:
        """
        Sets the amount of this BillingInvoice.
        Amount.

        :param amount: The amount of this BillingInvoice.
        :type: float
        """
        

        self._amount = amount

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

