# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingProduct
    from . import NamedEntity

class BillingInvoiceItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingInvoiceItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'product': 'BillingProduct',
            'description': 'str',
            'date_transacted': 'date',
            'date_start': 'date',
            'date_end': 'date',
            'organization': 'NamedEntity',
            'quantity': 'int',
            'unit_of_measure': 'str',
            'amount': 'float'
        }

        self.attribute_map = {
            'id': 'id',
            'product': 'product',
            'description': 'description',
            'date_transacted': 'dateTransacted',
            'date_start': 'dateStart',
            'date_end': 'dateEnd',
            'organization': 'organization',
            'quantity': 'quantity',
            'unit_of_measure': 'unitOfMeasure',
            'amount': 'amount'
        }

        self._id = None
        self._product = None
        self._description = None
        self._date_transacted = None
        self._date_start = None
        self._date_end = None
        self._organization = None
        self._quantity = None
        self._unit_of_measure = None
        self._amount = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingInvoiceItem.
        The globally unique identifier for the object.

        :return: The id of this BillingInvoiceItem.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingInvoiceItem.
        The globally unique identifier for the object.

        :param id: The id of this BillingInvoiceItem.
        :type: str
        """
        

        self._id = id

    @property
    def product(self) -> 'BillingProduct':
        """
        Gets the product of this BillingInvoiceItem.
        Represents the details of a product.

        :return: The product of this BillingInvoiceItem.
        :rtype: BillingProduct
        """
        return self._product

    @product.setter
    def product(self, product: 'BillingProduct') -> None:
        """
        Sets the product of this BillingInvoiceItem.
        Represents the details of a product.

        :param product: The product of this BillingInvoiceItem.
        :type: BillingProduct
        """
        

        self._product = product

    @property
    def description(self) -> str:
        """
        Gets the description of this BillingInvoiceItem.
        Line Item Description.

        :return: The description of this BillingInvoiceItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this BillingInvoiceItem.
        Line Item Description.

        :param description: The description of this BillingInvoiceItem.
        :type: str
        """
        

        self._description = description

    @property
    def date_transacted(self) -> date:
        """
        Gets the date_transacted of this BillingInvoiceItem.
        Invoice transaction date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_transacted of this BillingInvoiceItem.
        :rtype: date
        """
        return self._date_transacted

    @date_transacted.setter
    def date_transacted(self, date_transacted: date) -> None:
        """
        Sets the date_transacted of this BillingInvoiceItem.
        Invoice transaction date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_transacted: The date_transacted of this BillingInvoiceItem.
        :type: date
        """
        

        self._date_transacted = date_transacted

    @property
    def date_start(self) -> date:
        """
        Gets the date_start of this BillingInvoiceItem.
        Invoice start date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_start of this BillingInvoiceItem.
        :rtype: date
        """
        return self._date_start

    @date_start.setter
    def date_start(self, date_start: date) -> None:
        """
        Sets the date_start of this BillingInvoiceItem.
        Invoice start date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_start: The date_start of this BillingInvoiceItem.
        :type: date
        """
        

        self._date_start = date_start

    @property
    def date_end(self) -> date:
        """
        Gets the date_end of this BillingInvoiceItem.
        Invoice end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_end of this BillingInvoiceItem.
        :rtype: date
        """
        return self._date_end

    @date_end.setter
    def date_end(self, date_end: date) -> None:
        """
        Sets the date_end of this BillingInvoiceItem.
        Invoice end date. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_end: The date_end of this BillingInvoiceItem.
        :type: date
        """
        

        self._date_end = date_end

    @property
    def organization(self) -> 'NamedEntity':
        """
        Gets the organization of this BillingInvoiceItem.
        A Genesys Cloud Organization.

        :return: The organization of this BillingInvoiceItem.
        :rtype: NamedEntity
        """
        return self._organization

    @organization.setter
    def organization(self, organization: 'NamedEntity') -> None:
        """
        Sets the organization of this BillingInvoiceItem.
        A Genesys Cloud Organization.

        :param organization: The organization of this BillingInvoiceItem.
        :type: NamedEntity
        """
        

        self._organization = organization

    @property
    def quantity(self) -> int:
        """
        Gets the quantity of this BillingInvoiceItem.
        Quantity of the item.

        :return: The quantity of this BillingInvoiceItem.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity: int) -> None:
        """
        Sets the quantity of this BillingInvoiceItem.
        Quantity of the item.

        :param quantity: The quantity of this BillingInvoiceItem.
        :type: int
        """
        

        self._quantity = quantity

    @property
    def unit_of_measure(self) -> str:
        """
        Gets the unit_of_measure of this BillingInvoiceItem.
        Unit of Measure.

        :return: The unit_of_measure of this BillingInvoiceItem.
        :rtype: str
        """
        return self._unit_of_measure

    @unit_of_measure.setter
    def unit_of_measure(self, unit_of_measure: str) -> None:
        """
        Sets the unit_of_measure of this BillingInvoiceItem.
        Unit of Measure.

        :param unit_of_measure: The unit_of_measure of this BillingInvoiceItem.
        :type: str
        """
        if isinstance(unit_of_measure, int):
            unit_of_measure = str(unit_of_measure)
        allowed_values = ["Call", "Character", "Conversation", "Course", "Day", "Each", "Employee", "Engagement", "Event", "Exam", "GB", "Hour", "Instance", "Interaction", "Invocation", "Message", "MillionCharacters", "Minute", "Person", "PhoneNumber", "Port", "Segment", "Session", "Stream", "Token", "Transaction", "Turn", "Unit", "User"]
        if unit_of_measure.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_of_measure -> " + unit_of_measure)
            self._unit_of_measure = "outdated_sdk_version"
        else:
            self._unit_of_measure = unit_of_measure

    @property
    def amount(self) -> float:
        """
        Gets the amount of this BillingInvoiceItem.
        Amount.

        :return: The amount of this BillingInvoiceItem.
        :rtype: float
        """
        return self._amount

    @amount.setter
    def amount(self, amount: float) -> None:
        """
        Sets the amount of this BillingInvoiceItem.
        Amount.

        :param amount: The amount of this BillingInvoiceItem.
        :type: float
        """
        

        self._amount = amount

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

