# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingPlanItem
    from . import BillingProduct
    from . import NamedEntity

class BillingPlan(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingPlan - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'organizations': 'list[NamedEntity]',
            'product': 'BillingProduct',
            'items': 'list[BillingPlanItem]'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'organizations': 'organizations',
            'product': 'product',
            'items': 'items'
        }

        self._id = None
        self._name = None
        self._organizations = None
        self._product = None
        self._items = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingPlan.
        The globally unique identifier for the object.

        :return: The id of this BillingPlan.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingPlan.
        The globally unique identifier for the object.

        :param id: The id of this BillingPlan.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingPlan.
        The name of the object.

        :return: The name of this BillingPlan.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingPlan.
        The name of the object.

        :param name: The name of this BillingPlan.
        :type: str
        """
        

        self._name = name

    @property
    def organizations(self) -> List['NamedEntity']:
        """
        Gets the organizations of this BillingPlan.
        List of organizations for the plan.

        :return: The organizations of this BillingPlan.
        :rtype: list[NamedEntity]
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations: List['NamedEntity']) -> None:
        """
        Sets the organizations of this BillingPlan.
        List of organizations for the plan.

        :param organizations: The organizations of this BillingPlan.
        :type: list[NamedEntity]
        """
        

        self._organizations = organizations

    @property
    def product(self) -> 'BillingProduct':
        """
        Gets the product of this BillingPlan.
        Represents the details of a product.

        :return: The product of this BillingPlan.
        :rtype: BillingProduct
        """
        return self._product

    @product.setter
    def product(self, product: 'BillingProduct') -> None:
        """
        Sets the product of this BillingPlan.
        Represents the details of a product.

        :param product: The product of this BillingPlan.
        :type: BillingProduct
        """
        

        self._product = product

    @property
    def items(self) -> List['BillingPlanItem']:
        """
        Gets the items of this BillingPlan.
        List of items for the plan.

        :return: The items of this BillingPlan.
        :rtype: list[BillingPlanItem]
        """
        return self._items

    @items.setter
    def items(self, items: List['BillingPlanItem']) -> None:
        """
        Sets the items of this BillingPlan.
        List of items for the plan.

        :param items: The items of this BillingPlan.
        :type: list[BillingPlanItem]
        """
        

        self._items = items

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

