# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BillingPlanItem(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingPlanItem - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'item_number': 'str',
            'name': 'str',
            'type': 'str',
            'function': 'str',
            'description': 'str',
            'date_charged_through': 'date',
            'currency_iso_code': 'str',
            'discount_amount': 'float',
            'date_effective_start': 'date',
            'date_effective_end': 'date',
            'overage_price': 'float',
            'price': 'float',
            'quantity': 'int',
            'unit_of_measure': 'str'
        }

        self.attribute_map = {
            'item_number': 'itemNumber',
            'name': 'name',
            'type': 'type',
            'function': 'function',
            'description': 'description',
            'date_charged_through': 'dateChargedThrough',
            'currency_iso_code': 'currencyIsoCode',
            'discount_amount': 'discountAmount',
            'date_effective_start': 'dateEffectiveStart',
            'date_effective_end': 'dateEffectiveEnd',
            'overage_price': 'overagePrice',
            'price': 'price',
            'quantity': 'quantity',
            'unit_of_measure': 'unitOfMeasure'
        }

        self._item_number = None
        self._name = None
        self._type = None
        self._function = None
        self._description = None
        self._date_charged_through = None
        self._currency_iso_code = None
        self._discount_amount = None
        self._date_effective_start = None
        self._date_effective_end = None
        self._overage_price = None
        self._price = None
        self._quantity = None
        self._unit_of_measure = None

    @property
    def item_number(self) -> str:
        """
        Gets the item_number of this BillingPlanItem.
        Item number.

        :return: The item_number of this BillingPlanItem.
        :rtype: str
        """
        return self._item_number

    @item_number.setter
    def item_number(self, item_number: str) -> None:
        """
        Sets the item_number of this BillingPlanItem.
        Item number.

        :param item_number: The item_number of this BillingPlanItem.
        :type: str
        """
        

        self._item_number = item_number

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingPlanItem.
        Name of the item.

        :return: The name of this BillingPlanItem.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingPlanItem.
        Name of the item.

        :param name: The name of this BillingPlanItem.
        :type: str
        """
        

        self._name = name

    @property
    def type(self) -> str:
        """
        Gets the type of this BillingPlanItem.
        Type of the item.

        :return: The type of this BillingPlanItem.
        :rtype: str
        """
        return self._type

    @type.setter
    def type(self, type: str) -> None:
        """
        Sets the type of this BillingPlanItem.
        Type of the item.

        :param type: The type of this BillingPlanItem.
        :type: str
        """
        

        self._type = type

    @property
    def function(self) -> str:
        """
        Gets the function of this BillingPlanItem.
        Function of the item.

        :return: The function of this BillingPlanItem.
        :rtype: str
        """
        return self._function

    @function.setter
    def function(self, function: str) -> None:
        """
        Sets the function of this BillingPlanItem.
        Function of the item.

        :param function: The function of this BillingPlanItem.
        :type: str
        """
        

        self._function = function

    @property
    def description(self) -> str:
        """
        Gets the description of this BillingPlanItem.
        Detailed description of the item.

        :return: The description of this BillingPlanItem.
        :rtype: str
        """
        return self._description

    @description.setter
    def description(self, description: str) -> None:
        """
        Sets the description of this BillingPlanItem.
        Detailed description of the item.

        :param description: The description of this BillingPlanItem.
        :type: str
        """
        

        self._description = description

    @property
    def date_charged_through(self) -> date:
        """
        Gets the date_charged_through of this BillingPlanItem.
        The date through which a customer has been billed for the charge. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_charged_through of this BillingPlanItem.
        :rtype: date
        """
        return self._date_charged_through

    @date_charged_through.setter
    def date_charged_through(self, date_charged_through: date) -> None:
        """
        Sets the date_charged_through of this BillingPlanItem.
        The date through which a customer has been billed for the charge. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_charged_through: The date_charged_through of this BillingPlanItem.
        :type: date
        """
        

        self._date_charged_through = date_charged_through

    @property
    def currency_iso_code(self) -> str:
        """
        Gets the currency_iso_code of this BillingPlanItem.
        Contains the ISO code for any currency allowed by the organization.

        :return: The currency_iso_code of this BillingPlanItem.
        :rtype: str
        """
        return self._currency_iso_code

    @currency_iso_code.setter
    def currency_iso_code(self, currency_iso_code: str) -> None:
        """
        Sets the currency_iso_code of this BillingPlanItem.
        Contains the ISO code for any currency allowed by the organization.

        :param currency_iso_code: The currency_iso_code of this BillingPlanItem.
        :type: str
        """
        

        self._currency_iso_code = currency_iso_code

    @property
    def discount_amount(self) -> float:
        """
        Gets the discount_amount of this BillingPlanItem.
        The amount of the discount.

        :return: The discount_amount of this BillingPlanItem.
        :rtype: float
        """
        return self._discount_amount

    @discount_amount.setter
    def discount_amount(self, discount_amount: float) -> None:
        """
        Sets the discount_amount of this BillingPlanItem.
        The amount of the discount.

        :param discount_amount: The discount_amount of this BillingPlanItem.
        :type: float
        """
        

        self._discount_amount = discount_amount

    @property
    def date_effective_start(self) -> date:
        """
        Gets the date_effective_start of this BillingPlanItem.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_effective_start of this BillingPlanItem.
        :rtype: date
        """
        return self._date_effective_start

    @date_effective_start.setter
    def date_effective_start(self, date_effective_start: date) -> None:
        """
        Sets the date_effective_start of this BillingPlanItem.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_effective_start: The date_effective_start of this BillingPlanItem.
        :type: date
        """
        

        self._date_effective_start = date_effective_start

    @property
    def date_effective_end(self) -> date:
        """
        Gets the date_effective_end of this BillingPlanItem.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :return: The date_effective_end of this BillingPlanItem.
        :rtype: date
        """
        return self._date_effective_end

    @date_effective_end.setter
    def date_effective_end(self, date_effective_end: date) -> None:
        """
        Sets the date_effective_end of this BillingPlanItem.
        The date when the Address became effective. Dates are represented as an ISO-8601 string. For example: yyyy-MM-dd

        :param date_effective_end: The date_effective_end of this BillingPlanItem.
        :type: date
        """
        

        self._date_effective_end = date_effective_end

    @property
    def overage_price(self) -> float:
        """
        Gets the overage_price of this BillingPlanItem.
        The price for units over the allowed amount.

        :return: The overage_price of this BillingPlanItem.
        :rtype: float
        """
        return self._overage_price

    @overage_price.setter
    def overage_price(self, overage_price: float) -> None:
        """
        Sets the overage_price of this BillingPlanItem.
        The price for units over the allowed amount.

        :param overage_price: The overage_price of this BillingPlanItem.
        :type: float
        """
        

        self._overage_price = overage_price

    @property
    def price(self) -> float:
        """
        Gets the price of this BillingPlanItem.
        The price associated with the item expressed as a decimal.

        :return: The price of this BillingPlanItem.
        :rtype: float
        """
        return self._price

    @price.setter
    def price(self, price: float) -> None:
        """
        Sets the price of this BillingPlanItem.
        The price associated with the item expressed as a decimal.

        :param price: The price of this BillingPlanItem.
        :type: float
        """
        

        self._price = price

    @property
    def quantity(self) -> int:
        """
        Gets the quantity of this BillingPlanItem.
        The quantity of units.

        :return: The quantity of this BillingPlanItem.
        :rtype: int
        """
        return self._quantity

    @quantity.setter
    def quantity(self, quantity: int) -> None:
        """
        Sets the quantity of this BillingPlanItem.
        The quantity of units.

        :param quantity: The quantity of this BillingPlanItem.
        :type: int
        """
        

        self._quantity = quantity

    @property
    def unit_of_measure(self) -> str:
        """
        Gets the unit_of_measure of this BillingPlanItem.
        The unit of measure for the wallet.

        :return: The unit_of_measure of this BillingPlanItem.
        :rtype: str
        """
        return self._unit_of_measure

    @unit_of_measure.setter
    def unit_of_measure(self, unit_of_measure: str) -> None:
        """
        Sets the unit_of_measure of this BillingPlanItem.
        The unit of measure for the wallet.

        :param unit_of_measure: The unit_of_measure of this BillingPlanItem.
        :type: str
        """
        if isinstance(unit_of_measure, int):
            unit_of_measure = str(unit_of_measure)
        allowed_values = ["Call", "Character", "Conversation", "Course", "Day", "Each", "Employee", "Engagement", "Event", "Exam", "GB", "Hour", "Instance", "Interaction", "Invocation", "Message", "MillionCharacters", "Minute", "Person", "PhoneNumber", "Port", "Segment", "Session", "Stream", "Token", "Transaction", "Turn", "Unit", "User"]
        if unit_of_measure.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_of_measure -> " + unit_of_measure)
            self._unit_of_measure = "outdated_sdk_version"
        else:
            self._unit_of_measure = unit_of_measure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

