# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict


class BillingProduct(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingProduct - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'sku': 'str',
            'name': 'str',
            'unit_of_measure': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'sku': 'sku',
            'name': 'name',
            'unit_of_measure': 'unitOfMeasure'
        }

        self._id = None
        self._sku = None
        self._name = None
        self._unit_of_measure = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingProduct.
        The globally unique identifier for the object.

        :return: The id of this BillingProduct.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingProduct.
        The globally unique identifier for the object.

        :param id: The id of this BillingProduct.
        :type: str
        """
        

        self._id = id

    @property
    def sku(self) -> str:
        """
        Gets the sku of this BillingProduct.
        The product associated with the fund.

        :return: The sku of this BillingProduct.
        :rtype: str
        """
        return self._sku

    @sku.setter
    def sku(self, sku: str) -> None:
        """
        Sets the sku of this BillingProduct.
        The product associated with the fund.

        :param sku: The sku of this BillingProduct.
        :type: str
        """
        

        self._sku = sku

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingProduct.
        The name of the product.

        :return: The name of this BillingProduct.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingProduct.
        The name of the product.

        :param name: The name of this BillingProduct.
        :type: str
        """
        

        self._name = name

    @property
    def unit_of_measure(self) -> str:
        """
        Gets the unit_of_measure of this BillingProduct.
        The unit of measure for the product.

        :return: The unit_of_measure of this BillingProduct.
        :rtype: str
        """
        return self._unit_of_measure

    @unit_of_measure.setter
    def unit_of_measure(self, unit_of_measure: str) -> None:
        """
        Sets the unit_of_measure of this BillingProduct.
        The unit of measure for the product.

        :param unit_of_measure: The unit_of_measure of this BillingProduct.
        :type: str
        """
        if isinstance(unit_of_measure, int):
            unit_of_measure = str(unit_of_measure)
        allowed_values = ["Call", "Character", "Conversation", "Course", "Day", "Each", "Employee", "Engagement", "Event", "Exam", "GB", "Hour", "Instance", "Interaction", "Invocation", "Message", "MillionCharacters", "Minute", "Person", "PhoneNumber", "Port", "Segment", "Session", "Stream", "Token", "Transaction", "Turn", "Unit", "User"]
        if unit_of_measure.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_of_measure -> " + unit_of_measure)
            self._unit_of_measure = "outdated_sdk_version"
        else:
            self._unit_of_measure = unit_of_measure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

