# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingUsageResource

class BillingUsage(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingUsage - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'name': 'str',
            'total_usage': 'str',
            'resources': 'list[BillingUsageResource]'
        }

        self.attribute_map = {
            'name': 'name',
            'total_usage': 'totalUsage',
            'resources': 'resources'
        }

        self._name = None
        self._total_usage = None
        self._resources = None

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingUsage.
        Identifies the billable usage.

        :return: The name of this BillingUsage.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingUsage.
        Identifies the billable usage.

        :param name: The name of this BillingUsage.
        :type: str
        """
        

        self._name = name

    @property
    def total_usage(self) -> str:
        """
        Gets the total_usage of this BillingUsage.
        The total amount of usage, expressed as a decimal number in string format.

        :return: The total_usage of this BillingUsage.
        :rtype: str
        """
        return self._total_usage

    @total_usage.setter
    def total_usage(self, total_usage: str) -> None:
        """
        Sets the total_usage of this BillingUsage.
        The total amount of usage, expressed as a decimal number in string format.

        :param total_usage: The total_usage of this BillingUsage.
        :type: str
        """
        

        self._total_usage = total_usage

    @property
    def resources(self) -> List['BillingUsageResource']:
        """
        Gets the resources of this BillingUsage.
        The resources for which usage was observed (e.g. license users, devices).

        :return: The resources of this BillingUsage.
        :rtype: list[BillingUsageResource]
        """
        return self._resources

    @resources.setter
    def resources(self, resources: List['BillingUsageResource']) -> None:
        """
        Sets the resources of this BillingUsage.
        The resources for which usage was observed (e.g. license users, devices).

        :param resources: The resources of this BillingUsage.
        :type: list[BillingUsageResource]
        """
        

        self._resources = resources

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

