# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingUsage

class BillingUsageReport(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingUsageReport - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'start_date': 'datetime',
            'end_date': 'datetime',
            'status': 'str',
            'usages': 'list[BillingUsage]',
            'self_uri': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'start_date': 'startDate',
            'end_date': 'endDate',
            'status': 'status',
            'usages': 'usages',
            'self_uri': 'selfUri'
        }

        self._id = None
        self._name = None
        self._start_date = None
        self._end_date = None
        self._status = None
        self._usages = None
        self._self_uri = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingUsageReport.
        The globally unique identifier for the object.

        :return: The id of this BillingUsageReport.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingUsageReport.
        The globally unique identifier for the object.

        :param id: The id of this BillingUsageReport.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingUsageReport.


        :return: The name of this BillingUsageReport.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingUsageReport.


        :param name: The name of this BillingUsageReport.
        :type: str
        """
        

        self._name = name

    @property
    def start_date(self) -> datetime:
        """
        Gets the start_date of this BillingUsageReport.
        The period start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The start_date of this BillingUsageReport.
        :rtype: datetime
        """
        return self._start_date

    @start_date.setter
    def start_date(self, start_date: datetime) -> None:
        """
        Sets the start_date of this BillingUsageReport.
        The period start date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param start_date: The start_date of this BillingUsageReport.
        :type: datetime
        """
        

        self._start_date = start_date

    @property
    def end_date(self) -> datetime:
        """
        Gets the end_date of this BillingUsageReport.
        The period end date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :return: The end_date of this BillingUsageReport.
        :rtype: datetime
        """
        return self._end_date

    @end_date.setter
    def end_date(self, end_date: datetime) -> None:
        """
        Sets the end_date of this BillingUsageReport.
        The period end date. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss[.mmm]Z

        :param end_date: The end_date of this BillingUsageReport.
        :type: datetime
        """
        

        self._end_date = end_date

    @property
    def status(self) -> str:
        """
        Gets the status of this BillingUsageReport.
        Generation status of report

        :return: The status of this BillingUsageReport.
        :rtype: str
        """
        return self._status

    @status.setter
    def status(self, status: str) -> None:
        """
        Sets the status of this BillingUsageReport.
        Generation status of report

        :param status: The status of this BillingUsageReport.
        :type: str
        """
        if isinstance(status, int):
            status = str(status)
        allowed_values = ["InProgress", "Complete"]
        if status.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for status -> " + status)
            self._status = "outdated_sdk_version"
        else:
            self._status = status

    @property
    def usages(self) -> List['BillingUsage']:
        """
        Gets the usages of this BillingUsageReport.
        The usages for the given period.

        :return: The usages of this BillingUsageReport.
        :rtype: list[BillingUsage]
        """
        return self._usages

    @usages.setter
    def usages(self, usages: List['BillingUsage']) -> None:
        """
        Sets the usages of this BillingUsageReport.
        The usages for the given period.

        :param usages: The usages of this BillingUsageReport.
        :type: list[BillingUsage]
        """
        

        self._usages = usages

    @property
    def self_uri(self) -> str:
        """
        Gets the self_uri of this BillingUsageReport.
        The URI for this object

        :return: The self_uri of this BillingUsageReport.
        :rtype: str
        """
        return self._self_uri

    @self_uri.setter
    def self_uri(self, self_uri: str) -> None:
        """
        Sets the self_uri of this BillingUsageReport.
        The URI for this object

        :param self_uri: The self_uri of this BillingUsageReport.
        :type: str
        """
        

        self._self_uri = self_uri

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

