# coding: utf-8

"""
Copyright 2016 SmartBear Software

    Licensed under the Apache License, Version 2.0 (the "License");
    you may not use this file except in compliance with the License.
    You may obtain a copy of the License at

        http://www.apache.org/licenses/LICENSE-2.0

    Unless required by applicable law or agreed to in writing, software
    distributed under the License is distributed on an "AS IS" BASIS,
    WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
    See the License for the specific language governing permissions and
    limitations under the License.

    Ref: https://github.com/swagger-api/swagger-codegen
"""

from datetime import datetime
from datetime import date
from pprint import pformat
import re
import json

from ..utils import sanitize_for_serialization

# type hinting support
from typing import TYPE_CHECKING
from typing import List
from typing import Dict

if TYPE_CHECKING:
    from . import BillingProduct
    from . import NamedEntity

class BillingWallet(object):
    """
    NOTE: This class is auto generated by the swagger code generator program.
    Do not edit the class manually.
    """
    def __init__(self) -> None:
        """
        BillingWallet - a model defined in Swagger

        :param dict swaggerTypes: The key is attribute name
                                  and the value is attribute type.
        :param dict attributeMap: The key is attribute name
                                  and the value is json key in definition.
        """
        self.swagger_types = {
            'id': 'str',
            'name': 'str',
            'organizations': 'list[NamedEntity]',
            'product': 'BillingProduct',
            'starting_balance': 'float',
            'ending_balance': 'float',
            'balance_increase': 'float',
            'balance_decrease': 'float',
            'balance_consumption': 'float',
            'balance_overage': 'float',
            'balance_overage_rate': 'float',
            'balance_overage_charge': 'float',
            'balance_overage_currency': 'str',
            'unit_of_measure': 'str'
        }

        self.attribute_map = {
            'id': 'id',
            'name': 'name',
            'organizations': 'organizations',
            'product': 'product',
            'starting_balance': 'startingBalance',
            'ending_balance': 'endingBalance',
            'balance_increase': 'balanceIncrease',
            'balance_decrease': 'balanceDecrease',
            'balance_consumption': 'balanceConsumption',
            'balance_overage': 'balanceOverage',
            'balance_overage_rate': 'balanceOverageRate',
            'balance_overage_charge': 'balanceOverageCharge',
            'balance_overage_currency': 'balanceOverageCurrency',
            'unit_of_measure': 'unitOfMeasure'
        }

        self._id = None
        self._name = None
        self._organizations = None
        self._product = None
        self._starting_balance = None
        self._ending_balance = None
        self._balance_increase = None
        self._balance_decrease = None
        self._balance_consumption = None
        self._balance_overage = None
        self._balance_overage_rate = None
        self._balance_overage_charge = None
        self._balance_overage_currency = None
        self._unit_of_measure = None

    @property
    def id(self) -> str:
        """
        Gets the id of this BillingWallet.
        The globally unique identifier for the object.

        :return: The id of this BillingWallet.
        :rtype: str
        """
        return self._id

    @id.setter
    def id(self, id: str) -> None:
        """
        Sets the id of this BillingWallet.
        The globally unique identifier for the object.

        :param id: The id of this BillingWallet.
        :type: str
        """
        

        self._id = id

    @property
    def name(self) -> str:
        """
        Gets the name of this BillingWallet.
        The name of the object.

        :return: The name of this BillingWallet.
        :rtype: str
        """
        return self._name

    @name.setter
    def name(self, name: str) -> None:
        """
        Sets the name of this BillingWallet.
        The name of the object.

        :param name: The name of this BillingWallet.
        :type: str
        """
        

        self._name = name

    @property
    def organizations(self) -> List['NamedEntity']:
        """
        Gets the organizations of this BillingWallet.
        A Genesys Cloud Organization and it's related plans.

        :return: The organizations of this BillingWallet.
        :rtype: list[NamedEntity]
        """
        return self._organizations

    @organizations.setter
    def organizations(self, organizations: List['NamedEntity']) -> None:
        """
        Sets the organizations of this BillingWallet.
        A Genesys Cloud Organization and it's related plans.

        :param organizations: The organizations of this BillingWallet.
        :type: list[NamedEntity]
        """
        

        self._organizations = organizations

    @property
    def product(self) -> 'BillingProduct':
        """
        Gets the product of this BillingWallet.
        Represents the details of a product.

        :return: The product of this BillingWallet.
        :rtype: BillingProduct
        """
        return self._product

    @product.setter
    def product(self, product: 'BillingProduct') -> None:
        """
        Sets the product of this BillingWallet.
        Represents the details of a product.

        :param product: The product of this BillingWallet.
        :type: BillingProduct
        """
        

        self._product = product

    @property
    def starting_balance(self) -> float:
        """
        Gets the starting_balance of this BillingWallet.
        The initial balance in the wallet.

        :return: The starting_balance of this BillingWallet.
        :rtype: float
        """
        return self._starting_balance

    @starting_balance.setter
    def starting_balance(self, starting_balance: float) -> None:
        """
        Sets the starting_balance of this BillingWallet.
        The initial balance in the wallet.

        :param starting_balance: The starting_balance of this BillingWallet.
        :type: float
        """
        

        self._starting_balance = starting_balance

    @property
    def ending_balance(self) -> float:
        """
        Gets the ending_balance of this BillingWallet.
        The final balance in the wallet after transactions.

        :return: The ending_balance of this BillingWallet.
        :rtype: float
        """
        return self._ending_balance

    @ending_balance.setter
    def ending_balance(self, ending_balance: float) -> None:
        """
        Sets the ending_balance of this BillingWallet.
        The final balance in the wallet after transactions.

        :param ending_balance: The ending_balance of this BillingWallet.
        :type: float
        """
        

        self._ending_balance = ending_balance

    @property
    def balance_increase(self) -> float:
        """
        Gets the balance_increase of this BillingWallet.
        Total amount added to the wallet.

        :return: The balance_increase of this BillingWallet.
        :rtype: float
        """
        return self._balance_increase

    @balance_increase.setter
    def balance_increase(self, balance_increase: float) -> None:
        """
        Sets the balance_increase of this BillingWallet.
        Total amount added to the wallet.

        :param balance_increase: The balance_increase of this BillingWallet.
        :type: float
        """
        

        self._balance_increase = balance_increase

    @property
    def balance_decrease(self) -> float:
        """
        Gets the balance_decrease of this BillingWallet.
        The amount removed from the wallet due to a contract change.

        :return: The balance_decrease of this BillingWallet.
        :rtype: float
        """
        return self._balance_decrease

    @balance_decrease.setter
    def balance_decrease(self, balance_decrease: float) -> None:
        """
        Sets the balance_decrease of this BillingWallet.
        The amount removed from the wallet due to a contract change.

        :param balance_decrease: The balance_decrease of this BillingWallet.
        :type: float
        """
        

        self._balance_decrease = balance_decrease

    @property
    def balance_consumption(self) -> float:
        """
        Gets the balance_consumption of this BillingWallet.
        Total consumption deducted from the wallet.

        :return: The balance_consumption of this BillingWallet.
        :rtype: float
        """
        return self._balance_consumption

    @balance_consumption.setter
    def balance_consumption(self, balance_consumption: float) -> None:
        """
        Sets the balance_consumption of this BillingWallet.
        Total consumption deducted from the wallet.

        :param balance_consumption: The balance_consumption of this BillingWallet.
        :type: float
        """
        

        self._balance_consumption = balance_consumption

    @property
    def balance_overage(self) -> float:
        """
        Gets the balance_overage of this BillingWallet.
        The amount exceeding a predefined balance threshold.

        :return: The balance_overage of this BillingWallet.
        :rtype: float
        """
        return self._balance_overage

    @balance_overage.setter
    def balance_overage(self, balance_overage: float) -> None:
        """
        Sets the balance_overage of this BillingWallet.
        The amount exceeding a predefined balance threshold.

        :param balance_overage: The balance_overage of this BillingWallet.
        :type: float
        """
        

        self._balance_overage = balance_overage

    @property
    def balance_overage_rate(self) -> float:
        """
        Gets the balance_overage_rate of this BillingWallet.
        The rate charged for an overage..

        :return: The balance_overage_rate of this BillingWallet.
        :rtype: float
        """
        return self._balance_overage_rate

    @balance_overage_rate.setter
    def balance_overage_rate(self, balance_overage_rate: float) -> None:
        """
        Sets the balance_overage_rate of this BillingWallet.
        The rate charged for an overage..

        :param balance_overage_rate: The balance_overage_rate of this BillingWallet.
        :type: float
        """
        

        self._balance_overage_rate = balance_overage_rate

    @property
    def balance_overage_charge(self) -> float:
        """
        Gets the balance_overage_charge of this BillingWallet.
        The amount to be charged.

        :return: The balance_overage_charge of this BillingWallet.
        :rtype: float
        """
        return self._balance_overage_charge

    @balance_overage_charge.setter
    def balance_overage_charge(self, balance_overage_charge: float) -> None:
        """
        Sets the balance_overage_charge of this BillingWallet.
        The amount to be charged.

        :param balance_overage_charge: The balance_overage_charge of this BillingWallet.
        :type: float
        """
        

        self._balance_overage_charge = balance_overage_charge

    @property
    def balance_overage_currency(self) -> str:
        """
        Gets the balance_overage_currency of this BillingWallet.
        The currency in which the overage charge is invoiced.

        :return: The balance_overage_currency of this BillingWallet.
        :rtype: str
        """
        return self._balance_overage_currency

    @balance_overage_currency.setter
    def balance_overage_currency(self, balance_overage_currency: str) -> None:
        """
        Sets the balance_overage_currency of this BillingWallet.
        The currency in which the overage charge is invoiced.

        :param balance_overage_currency: The balance_overage_currency of this BillingWallet.
        :type: str
        """
        

        self._balance_overage_currency = balance_overage_currency

    @property
    def unit_of_measure(self) -> str:
        """
        Gets the unit_of_measure of this BillingWallet.
        The unit of measure for the wallet.

        :return: The unit_of_measure of this BillingWallet.
        :rtype: str
        """
        return self._unit_of_measure

    @unit_of_measure.setter
    def unit_of_measure(self, unit_of_measure: str) -> None:
        """
        Sets the unit_of_measure of this BillingWallet.
        The unit of measure for the wallet.

        :param unit_of_measure: The unit_of_measure of this BillingWallet.
        :type: str
        """
        if isinstance(unit_of_measure, int):
            unit_of_measure = str(unit_of_measure)
        allowed_values = ["Call", "Character", "Conversation", "Course", "Day", "Each", "Employee", "Engagement", "Event", "Exam", "GB", "Hour", "Instance", "Interaction", "Invocation", "Message", "MillionCharacters", "Minute", "Person", "PhoneNumber", "Port", "Segment", "Session", "Stream", "Token", "Transaction", "Turn", "Unit", "User"]
        if unit_of_measure.lower() not in map(str.lower, allowed_values):
            # print("Invalid value for unit_of_measure -> " + unit_of_measure)
            self._unit_of_measure = "outdated_sdk_version"
        else:
            self._unit_of_measure = unit_of_measure

    def to_dict(self):
        """
        Returns the model properties as a dict
        """
        result = {}

        for attr, _ in self.swagger_types.items():
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value

        return result

    def to_json(self):
        """
        Returns the model as raw JSON
        """
        return json.dumps(sanitize_for_serialization(self.to_dict()))

    def to_str(self):
        """
        Returns the string representation of the model
        """
        return pformat(self.to_dict())

    def __repr__(self):
        """
        For `print` and `pprint`
        """
        return self.to_str()

    def __eq__(self, other):
        """
        Returns true if both objects are equal
        """
        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """
        Returns true if both objects are not equal
        """
        return not self == other

